/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.datastore.core.historytree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.internal.datastore.core.historytree.HtIo;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.exceptions.RangeException;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.HTNode;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.IHTNode;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.IHistoryTree;

public abstract class AbstractHistoryTree<E extends IHTInterval, N extends HTNode<E>>
implements IHistoryTree<E> {
    private final File fHistoryFile;
    private final int fBlockSize;
    private final int fMaxChildren;
    private final int fProviderVersion;
    private final long fTreeStart;
    private final IHTIntervalReader<E> fIntervalReader;
    private HtIo<E, N> fTreeIO;
    private long fTreeEnd;
    private int fNodeCount;
    private final List<N> fLatestBranch;
    private final ReentrantReadWriteLock fRwl;
    private transient @Nullable List<N> fLatestBranchSnapshot;

    public AbstractHistoryTree(File stateHistoryFile, int blockSize, int maxChildren, int providerVersion, long treeStart, IHTIntervalReader<E> intervalReader) throws IOException {
        this.fRwl = new ReentrantReadWriteLock(false);
        this.fLatestBranchSnapshot = null;
        if (blockSize < 4096) {
            throw new IllegalArgumentException();
        }
        this.fHistoryFile = stateHistoryFile;
        this.fBlockSize = blockSize;
        this.fMaxChildren = maxChildren;
        this.fProviderVersion = providerVersion;
        this.fTreeStart = treeStart;
        this.fIntervalReader = intervalReader;
        this.fTreeEnd = treeStart;
        this.fNodeCount = 0;
        this.fLatestBranch = (List)NonNullUtils.checkNotNull(Collections.synchronizedList(new ArrayList()));
        this.fTreeIO = new HtIo<E, N>(stateHistoryFile, blockSize, maxChildren, true, intervalReader, this.getNodeFactory());
        N firstNode = this.initNewLeafNode(-1, treeStart);
        this.fLatestBranch.add(firstNode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AbstractHistoryTree(File existingStateFile, int expectedProviderVersion, IHTIntervalReader<E> intervalReader) throws IOException {
        long startTime;
        int rootNodeSeqNb;
        block19: {
            this.fRwl = new ReentrantReadWriteLock(false);
            this.fLatestBranchSnapshot = null;
            if (!existingStateFile.exists()) {
                throw new IOException("Selected state file does not exist");
            }
            if (existingStateFile.length() <= 0L) {
                throw new IOException("Empty target file");
            }
            Throwable throwable = null;
            Object var11_6 = null;
            try {
                FileInputStream fis = new FileInputStream(existingStateFile);
                try {
                    try (FileChannel fc = fis.getChannel();){
                        ByteBuffer buffer = ByteBuffer.allocate(4096);
                        buffer.order(ByteOrder.LITTLE_ENDIAN);
                        buffer.clear();
                        int res = fc.read(buffer);
                        if (res != 4096) {
                            throw new IOException("Invalid header size");
                        }
                        buffer.flip();
                        res = buffer.getInt();
                        if (res != this.getMagicNumber()) {
                            throw new IOException("Wrong magic number");
                        }
                        res = buffer.getInt();
                        if (res != this.getFileVersion()) {
                            throw new IOException("Mismatching History Tree file format versions");
                        }
                        res = buffer.getInt();
                        if (res != expectedProviderVersion) {
                            throw new IOException("Mismatching event handler versions");
                        }
                        int bs = buffer.getInt();
                        int maxc = buffer.getInt();
                        this.fNodeCount = buffer.getInt();
                        rootNodeSeqNb = buffer.getInt();
                        startTime = buffer.getLong();
                        this.fHistoryFile = existingStateFile;
                        this.fBlockSize = bs;
                        this.fMaxChildren = maxc;
                        this.fProviderVersion = expectedProviderVersion;
                        this.fIntervalReader = intervalReader;
                        this.fTreeStart = startTime;
                    }
                    if (fis == null) break block19;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        this.fTreeIO = new HtIo<E, N>(this.fHistoryFile, this.fBlockSize, this.fMaxChildren, false, this.fIntervalReader, this.getNodeFactory());
        this.fLatestBranch = this.buildLatestBranch(rootNodeSeqNb);
        this.fTreeEnd = ((HTNode)this.getRootNode()).getNodeEnd();
        if (startTime == ((HTNode)this.getRootNode()).getNodeStart()) return;
        throw new IOException("Inconsistent start times in the history file, it might be corrupted.");
    }

    private List<N> buildLatestBranch(int rootNodeSeqNb) throws ClosedChannelException {
        ArrayList<N> list = new ArrayList<N>();
        N nextChildNode = this.fTreeIO.readNode(rootNodeSeqNb);
        list.add(nextChildNode);
        while (((HTNode)nextChildNode).getNodeType() == IHTNode.NodeType.CORE) {
            nextChildNode = this.fTreeIO.readNode(((HTNode)nextChildNode).getLatestChild());
            list.add(nextChildNode);
        }
        return Collections.synchronizedList(list);
    }

    @Override
    public long getTreeStart() {
        return this.fTreeStart;
    }

    @Override
    public long getTreeEnd() {
        return this.fTreeEnd;
    }

    public int getNodeCount() {
        return this.fNodeCount;
    }

    public N getRootNode() {
        return (N)((HTNode)this.fLatestBranch.get(0));
    }

    @Override
    public long getFileSize() {
        return this.fHistoryFile.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected final List<N> getLatestBranch() {
        ImmutableList latestBranchSnapshot = this.fLatestBranchSnapshot;
        if (latestBranchSnapshot == null) {
            List<N> list = this.fLatestBranch;
            synchronized (list) {
                this.fLatestBranchSnapshot = latestBranchSnapshot = ImmutableList.copyOf(this.fLatestBranch);
            }
        }
        return latestBranchSnapshot;
    }

    protected N getLatestNode(int depth) {
        if (depth > this.fLatestBranch.size()) {
            throw new IndexOutOfBoundsException("Trying to get latest node too deep");
        }
        return (N)((HTNode)this.fLatestBranch.get(depth));
    }

    protected abstract int getMagicNumber();

    protected abstract int getFileVersion();

    protected abstract IHTNodeFactory<E, N> getNodeFactory();

    @VisibleForTesting
    protected @NonNull N getNode(int seqNum) throws ClosedChannelException {
        for (HTNode node : this.fLatestBranch) {
            if (node.getSequenceNumber() != seqNum) continue;
            return (N)node;
        }
        return this.fTreeIO.readNode(seqNum);
    }

    @VisibleForTesting
    HtIo<E, N> getTreeIO() {
        return this.fTreeIO;
    }

    @Override
    public FileInputStream supplyATReader() {
        this.fRwl.readLock().lock();
        try {
            FileInputStream fileInputStream = this.fTreeIO.supplyATReader(this.getNodeCount());
            return fileInputStream;
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    @Override
    public File supplyATWriterFile() {
        return this.fHistoryFile;
    }

    @Override
    public long supplyATWriterFilePos() {
        return 4096L + (long)this.getNodeCount() * (long)this.fBlockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public N readNode(int seqNumber) throws ClosedChannelException {
        List<N> list = this.fLatestBranch;
        synchronized (list) {
            for (HTNode node : this.fLatestBranch) {
                if (node.getSequenceNumber() != seqNumber) continue;
                return (N)node;
            }
        }
        this.fRwl.readLock().lock();
        try {
            N n = this.fTreeIO.readNode(seqNumber);
            return n;
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    public void writeNode(N node) {
        this.fRwl.readLock().lock();
        try {
            this.fTreeIO.writeNode(node);
        }
        finally {
            this.fRwl.readLock().unlock();
        }
    }

    @Override
    public void closeFile() {
        this.fRwl.writeLock().lock();
        try {
            this.fTreeIO.closeFile();
            this.clearContent();
        }
        finally {
            this.fRwl.writeLock().unlock();
        }
    }

    @Override
    public void deleteFile() {
        this.fRwl.writeLock().lock();
        try {
            this.fTreeIO.deleteFile();
            this.clearContent();
        }
        finally {
            this.fRwl.writeLock().unlock();
        }
    }

    @Override
    public void cleanFile() throws IOException {
        this.fRwl.writeLock().lock();
        try {
            this.closeTree(this.fTreeEnd);
            this.fTreeIO.deleteFile();
            this.fTreeIO = new HtIo<E, N>(this.fHistoryFile, this.fBlockSize, this.fMaxChildren, true, this.fIntervalReader, this.getNodeFactory());
            this.clearContent();
            N firstNode = this.initNewLeafNode(-1, this.fTreeStart);
            this.fLatestBranch.add(firstNode);
        }
        finally {
            this.fRwl.writeLock().unlock();
        }
    }

    private void clearContent() {
        this.fNodeCount = 0;
        this.fLatestBranch.clear();
    }

    @Override
    public synchronized void insert(E interval) throws RangeException {
        if (interval.getStart() < this.fTreeStart) {
            throw new RangeException("Interval Start:" + interval.getStart() + ", Config Start:" + this.fTreeStart);
        }
        this.tryInsertAtNode(interval, this.fLatestBranch.size() - 1);
    }

    protected final N initNewCoreNode(int parentSeqNumber, long startTime) {
        N newNode = this.getNodeFactory().createNode(IHTNode.NodeType.CORE, this.fBlockSize, this.fMaxChildren, this.fNodeCount, parentSeqNumber, startTime);
        ++this.fNodeCount;
        return newNode;
    }

    protected final N initNewLeafNode(int parentSeqNumber, long startTime) {
        N newNode = this.getNodeFactory().createNode(IHTNode.NodeType.LEAF, this.fBlockSize, this.fMaxChildren, this.fNodeCount, parentSeqNumber, startTime);
        ++this.fNodeCount;
        return newNode;
    }

    protected final void tryInsertAtNode(E interval, int depth) {
        HTNode targetNode = (HTNode)this.fLatestBranch.get(depth);
        this.informInsertingAtDepth(depth);
        if (interval.getSizeOnDisk() > targetNode.getNodeFreeSpace()) {
            this.addSiblingNode(depth, this.getNewBranchStart(depth, interval));
            this.tryInsertAtNode(interval, this.getLatestBranch().size() - 1);
            return;
        }
        if (interval.getStart() < targetNode.getNodeStart()) {
            this.tryInsertAtNode(interval, depth - 1);
            return;
        }
        targetNode.add(interval);
        this.updateEndTime(interval);
    }

    @VisibleForTesting
    protected void informInsertingAtDepth(int depth) {
    }

    protected abstract long getNewBranchStart(int var1, E var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addSiblingNode(int depth, long newNodeStartTime) {
        List<N> list = this.fLatestBranch;
        synchronized (list) {
            long splitTime = this.fTreeEnd;
            this.fLatestBranchSnapshot = null;
            if (depth >= this.fLatestBranch.size()) {
                throw new IllegalStateException();
            }
            if (depth == 0) {
                this.addNewRootNode(newNodeStartTime);
                return;
            }
            if (((HTNode)this.fLatestBranch.get(depth - 1)).getNbChildren() == this.fMaxChildren || newNodeStartTime < ((HTNode)this.fLatestBranch.get(depth - 1)).getNodeStart()) {
                this.addSiblingNode(depth - 1, newNodeStartTime);
                return;
            }
            int i = this.fLatestBranch.size() - 1;
            while (i >= depth) {
                ((HTNode)this.fLatestBranch.get(i)).closeThisNode(splitTime);
                this.fTreeIO.writeNode((HTNode)this.fLatestBranch.get(i));
                --i;
            }
            i = depth;
            while (i < this.fLatestBranch.size()) {
                N newNode;
                HTNode prevNode = (HTNode)this.fLatestBranch.get(i - 1);
                switch (((HTNode)this.fLatestBranch.get(i)).getNodeType()) {
                    case CORE: {
                        newNode = this.initNewCoreNode(prevNode.getSequenceNumber(), newNodeStartTime);
                        break;
                    }
                    case LEAF: {
                        newNode = this.initNewLeafNode(prevNode.getSequenceNumber(), newNodeStartTime);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                prevNode.linkNewChild(newNode);
                this.fLatestBranch.set(i, newNode);
                ++i;
            }
        }
    }

    private void addNewRootNode(long newNodeStartTime) {
        long nodeEnd = this.fTreeEnd;
        HTNode oldRootNode = (HTNode)this.fLatestBranch.get(0);
        N newRootNode = this.initNewCoreNode(-1, this.fTreeStart);
        oldRootNode.setParentSequenceNumber(((HTNode)newRootNode).getSequenceNumber());
        int i = this.fLatestBranch.size() - 1;
        while (i >= 0) {
            ((HTNode)this.fLatestBranch.get(i)).closeThisNode(nodeEnd);
            this.fTreeIO.writeNode((HTNode)this.fLatestBranch.get(i));
            --i;
        }
        ((HTNode)newRootNode).linkNewChild(oldRootNode);
        int depth = this.fLatestBranch.size();
        this.fLatestBranch.clear();
        this.fLatestBranch.add(newRootNode);
        int i2 = 1;
        while (i2 < depth) {
            HTNode prevNode = (HTNode)this.fLatestBranch.get(i2 - 1);
            N newNode = this.initNewCoreNode(prevNode.getSequenceNumber(), newNodeStartTime);
            prevNode.linkNewChild(newNode);
            this.fLatestBranch.add(newNode);
            ++i2;
        }
        HTNode prevNode = (HTNode)this.fLatestBranch.get(depth - 1);
        N newNode = this.initNewLeafNode(prevNode.getSequenceNumber(), newNodeStartTime);
        prevNode.linkNewChild(newNode);
        this.fLatestBranch.add(newNode);
    }

    protected void updateEndTime(E interval) {
        this.fTreeEnd = Math.max(this.fTreeEnd, interval.getEnd());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeTree(long requestedEndTime) {
        List<N> list = this.fLatestBranch;
        synchronized (list) {
            this.fTreeEnd = requestedEndTime;
            int i2 = this.fLatestBranch.size() - 1;
            while (i2 >= 0) {
                ((HTNode)this.fLatestBranch.get(i2)).closeThisNode(this.fTreeEnd);
                this.fTreeIO.writeNode((HTNode)this.fLatestBranch.get(i2));
                --i2;
            }
            try {
                Throwable i2 = null;
                Object var5_7 = null;
                try (FileOutputStream fc = this.fTreeIO.getFileWriter(-1);){
                    ByteBuffer buffer = ByteBuffer.allocate(4096);
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                    buffer.clear();
                    buffer.putInt(this.getMagicNumber());
                    buffer.putInt(this.getFileVersion());
                    buffer.putInt(this.fProviderVersion);
                    buffer.putInt(this.fBlockSize);
                    buffer.putInt(this.fMaxChildren);
                    buffer.putInt(this.fNodeCount);
                    buffer.putInt(((HTNode)this.fLatestBranch.get(0)).getSequenceNumber());
                    buffer.putLong(((HTNode)this.fLatestBranch.get(0)).getNodeStart());
                    buffer.flip();
                    fc.write(buffer.array());
                }
                catch (Throwable throwable) {
                    if (i2 == null) {
                        i2 = throwable;
                    } else if (i2 != throwable) {
                        i2.addSuppressed(throwable);
                    }
                    throw i2;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("State system write error");
            }
        }
    }

    @Override
    public Iterable<E> getMatchingIntervals(TimeRangeCondition timeCondition, Predicate<E> extraPredicate) {
        ArrayList intervalsOfNodes = new ArrayList();
        LinkedList<Integer> queue = new LinkedList<Integer>();
        queue.add(((HTNode)this.getRootNode()).getSequenceNumber());
        try {
            while (!queue.isEmpty()) {
                int sequenceNumber = (Integer)queue.pop();
                N currentNode = this.readNode(sequenceNumber);
                TimeRangeCondition nodeCondition = timeCondition.subCondition(((HTNode)currentNode).getNodeStart(), ((HTNode)currentNode).getNodeEnd());
                if (nodeCondition == null) continue;
                if (((HTNode)currentNode).getNodeType() == IHTNode.NodeType.CORE) {
                    queue.addAll(((HTNode)currentNode).selectNextChildren(nodeCondition, ((HTNode)currentNode).getCoreDataPredicate(extraPredicate)));
                }
                Iterable nodeIntervals = ((HTNode)currentNode).getMatchingIntervals(nodeCondition, (Predicate)extraPredicate);
                intervalsOfNodes.addAll(nodeIntervals);
            }
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
        return intervalsOfNodes;
    }

    @Override
    public @Nullable E getMatchingInterval(TimeRangeCondition timeCondition, Predicate<E> extraPredicate) {
        LinkedList<Integer> queue = new LinkedList<Integer>();
        queue.add(((HTNode)this.getRootNode()).getSequenceNumber());
        try {
            while (!queue.isEmpty()) {
                int sequenceNumber = (Integer)queue.pop();
                N currentNode = this.readNode(sequenceNumber);
                @Nullable E interval = ((HTNode)currentNode).getMatchingInterval(timeCondition, extraPredicate);
                if (interval != null) {
                    return interval;
                }
                if (((HTNode)currentNode).getNodeType() != IHTNode.NodeType.CORE) continue;
                queue.addAll(((HTNode)currentNode).selectNextChildren(timeCondition));
            }
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return "Information on the current tree:\n\nBlocksize: " + this.fBlockSize + "\n" + "Max nb. of children per node: " + this.fMaxChildren + "\n" + "Number of nodes: " + this.fNodeCount + "\n" + "Depth of the tree: " + this.fLatestBranch.size() + "\n" + "Size of the treefile: " + this.getFileSize() + "\n" + "Root node has sequence number: " + ((HTNode)this.fLatestBranch.get(0)).getSequenceNumber() + "\n" + "'Latest leaf' has sequence number: " + ((HTNode)this.fLatestBranch.get(this.fLatestBranch.size() - 1)).getSequenceNumber();
    }

    @VisibleForTesting
    protected int getDepth() {
        return this.getLatestBranch().size();
    }

    @VisibleForTesting
    protected N getLatestLeaf() {
        List<N> latestBranch = this.getLatestBranch();
        return (N)((HTNode)latestBranch.get(latestBranch.size() - 1));
    }

    @VisibleForTesting
    protected boolean verifyChildrenSpecific(N parent, int index, N child) {
        return true;
    }

    @VisibleForTesting
    protected boolean verifyIntersectingChildren(N parent, N child) {
        int childSequence = ((HTNode)child).getSequenceNumber();
        long t = ((HTNode)parent).getNodeStart();
        while (t < ((HTNode)parent).getNodeEnd()) {
            boolean shouldBeInCollection = true;
            Collection<Integer> nextChildren = ((HTNode)parent).selectNextChildren(TimeRangeCondition.singleton(t));
            if (shouldBeInCollection != nextChildren.contains(childSequence)) {
                return false;
            }
            ++t;
        }
        return true;
    }

    @FunctionalInterface
    public static interface IHTNodeFactory<E extends IHTInterval, N extends HTNode<E>> {
        public N createNode(IHTNode.NodeType var1, int var2, int var3, int var4, int var5, long var6);
    }
}

