/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;

public class ClasspathValidation {
    private final JavaProject project;

    public ClasspathValidation(JavaProject project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        IJavaModelStatus status;
        IPath outputLocation;
        IClasspathEntry[] rawClasspath;
        JavaModelManager.PerProjectInfo perProjectInfo;
        try {
            perProjectInfo = this.project.getPerProjectInfo();
        }
        catch (JavaModelException e) {
            IProject resource = this.project.getProject();
            if (resource.isAccessible()) {
                this.project.flushClasspathProblemMarkers(true, true, true);
                JavaBuilder.removeProblemsAndTasksFor((IResource)resource);
            }
            return;
        }
        JavaModelManager.PerProjectInfo perProjectInfo2 = perProjectInfo;
        synchronized (perProjectInfo2) {
            rawClasspath = perProjectInfo.rawClasspath;
            outputLocation = perProjectInfo.outputLocation;
            status = perProjectInfo.rawClasspathStatus;
        }
        this.project.flushClasspathProblemMarkers(false, true, false);
        if (!status.isOK()) {
            this.project.createClasspathProblemMarker(status);
        }
        this.project.flushClasspathProblemMarkers(false, false, true);
        this.project.flushClasspathProblemMarkers(false, false, false);
        if (rawClasspath != JavaProject.INVALID_CLASSPATH && outputLocation != null) {
            IClasspathEntry[] iClasspathEntryArray = rawClasspath;
            int n = rawClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                status = ClasspathEntry.validateClasspathEntry(this.project, cpe, false, false);
                if (!status.isOK()) {
                    this.project.createClasspathProblemMarker(status);
                }
                ++n2;
            }
            status = ClasspathEntry.validateClasspath(this.project, rawClasspath, outputLocation);
            if (status.getCode() != 0) {
                this.project.createClasspathProblemMarker(status);
            }
        }
    }
}

