/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.cn.smart.HMMChineseTokenizer;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.util.IOUtils;

public final class SmartChineseAnalyzer
extends Analyzer {
    private final CharArraySet stopWords;
    private static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private static final String STOPWORD_FILE_COMMENT = "//";

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public SmartChineseAnalyzer() {
        this(true);
    }

    public SmartChineseAnalyzer(boolean useDefaultStopWords) {
        this.stopWords = useDefaultStopWords ? DefaultSetHolder.DEFAULT_STOP_SET : CharArraySet.EMPTY_SET;
    }

    public SmartChineseAnalyzer(CharArraySet stopWords) {
        this.stopWords = stopWords == null ? CharArraySet.EMPTY_SET : stopWords;
    }

    public Analyzer.TokenStreamComponents createComponents(String fieldName) {
        HMMChineseTokenizer tokenizer;
        HMMChineseTokenizer result = tokenizer = new HMMChineseTokenizer();
        result = new PorterStemFilter((TokenStream)result);
        if (!this.stopWords.isEmpty()) {
            result = new StopFilter((TokenStream)result, this.stopWords);
        }
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)result);
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static CharArraySet loadDefaultStopWordSet() throws IOException {
            return CharArraySet.unmodifiableSet((CharArraySet)WordlistLoader.getWordSet((InputStream)((InputStream)IOUtils.requireResourceNonNull((Object)SmartChineseAnalyzer.class.getResourceAsStream(SmartChineseAnalyzer.DEFAULT_STOPWORD_FILE), (String)SmartChineseAnalyzer.DEFAULT_STOPWORD_FILE)), (String)SmartChineseAnalyzer.STOPWORD_FILE_COMMENT));
        }

        static {
            try {
                DEFAULT_STOP_SET = DefaultSetHolder.loadDefaultStopWordSet();
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

