/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.extension;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.sse.ui.internal.IExtendedSimpleEditor;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISelfValidateEditAction;

public class DropActionProxy
implements InvocationHandler {
    private IExtendedSimpleEditor editor = null;
    private IStructuredModel fRecorder;
    private Object obj;

    public static Object newInstance(Object obj) {
        Object instance = null;
        try {
            HashSet set = new HashSet();
            Class<?> clazz = obj.getClass();
            while (clazz != null) {
                Class<?>[] interfaces = clazz.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    set.add(interfaces[i]);
                    ++i;
                }
                clazz = clazz.getSuperclass();
            }
            Class[] classes = new Class[set.size()];
            Iterator itr = set.iterator();
            int i = 0;
            while (itr.hasNext()) {
                classes[i] = (Class)itr.next();
                ++i;
            }
            instance = Proxy.newProxyInstance(obj.getClass().getClassLoader(), classes, (InvocationHandler)new DropActionProxy(obj));
        }
        catch (Error e) {
            Logger.logException("Exception while proxying a drop action", e);
            instance = obj;
        }
        return instance;
    }

    private DropActionProxy(Object obj) {
        this.obj = obj;
    }

    private void beginRecording() {
        IDocument document = null;
        if (this.editor != null) {
            IStructuredTextUndoManager um;
            document = this.editor.getDocument();
            if (document != null) {
                this.fRecorder = StructuredModelManager.getModelManager().getExistingModelForEdit(document);
            }
            if (this.fRecorder != null && (um = this.fRecorder.getUndoManager()) != null) {
                if (this.obj instanceof IAction) {
                    um.beginRecording((Object)this, ((IAction)this.obj).getText(), ((IAction)this.obj).getDescription());
                } else {
                    um.beginRecording((Object)this);
                }
            }
        }
    }

    private void endRecording() {
        if (this.fRecorder != null) {
            IStructuredTextUndoManager um = this.fRecorder.getUndoManager();
            if (um != null) {
                um.endRecording((Object)this);
            }
            this.fRecorder.releaseFromEdit();
            this.fRecorder = null;
        }
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result;
        String name = m.getName();
        try {
            if (name.equals("equals")) {
                Object arg = args[0];
                Boolean bl = proxy.getClass() == arg.getClass() && this.equals(Proxy.getInvocationHandler(arg)) ? Boolean.TRUE : Boolean.FALSE;
                return bl;
            }
            if (name.equals("run")) {
                if (args[1] instanceof IExtendedSimpleEditor) {
                    this.editor = (IExtendedSimpleEditor)args[1];
                }
                this.beginRecording();
                if (args[1] instanceof ITextEditor && !(this.obj instanceof ISelfValidateEditAction) && !this.isEditable((ITextEditor)args[1])) {
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
            }
            try {
                result = m.invoke(this.obj, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        finally {
            if (name.equals("run")) {
                this.endRecording();
            }
        }
        return result;
    }

    private boolean isEditable(ITextEditor editor) {
        if (editor instanceof ITextEditorExtension2) {
            return ((ITextEditorExtension2)editor).validateEditorInputState();
        }
        return editor.isEditable();
    }
}

