/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.HashSet;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.team.core.synchronize.ISyncInfoTreeChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.synchronize.AbstractSynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProviderDescriptor;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElementComparator;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.UnchangedResourceModelElement;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class HierarchicalModelProvider
extends SynchronizeModelProvider {
    private static final HierarchicalModelProviderDescriptor hierarchicalDescriptor = new HierarchicalModelProviderDescriptor();

    public HierarchicalModelProvider(ISynchronizePageConfiguration configuration, SyncInfoSet set) {
        super(configuration, set);
    }

    public HierarchicalModelProvider(AbstractSynchronizeModelProvider parentProvider, ISynchronizeModelElement modelRoot, ISynchronizePageConfiguration configuration, SyncInfoSet set) {
        super(parentProvider, modelRoot, configuration, set);
    }

    @Override
    public ISynchronizeModelProviderDescriptor getDescriptor() {
        return hierarchicalDescriptor;
    }

    @Override
    public ViewerComparator getViewerComparator() {
        return new SynchronizeModelElementComparator();
    }

    protected SyncInfoTree getSyncInfoTree() {
        return (SyncInfoTree)this.getSyncInfoSet();
    }

    protected IDiffElement[] createModelObjects(ISynchronizeModelElement container) {
        Object resource = null;
        resource = container == this.getModelRoot() ? ResourcesPlugin.getWorkspace().getRoot() : container.getResource();
        if (resource != null) {
            SyncInfoTree infoTree = this.getSyncInfoTree();
            IResource[] children = infoTree.members((IResource)resource);
            ISynchronizeModelElement[] nodes = new ISynchronizeModelElement[children.length];
            int i = 0;
            while (i < children.length) {
                nodes[i] = this.createModelObject(container, children[i]);
                ++i;
            }
            return nodes;
        }
        return new IDiffElement[0];
    }

    protected ISynchronizeModelElement createModelObject(ISynchronizeModelElement parent, IResource resource) {
        SyncInfo info = this.getSyncInfoTree().getSyncInfo(resource);
        SynchronizeModelElement newNode = info != null ? new SyncInfoModelElement(parent, info) : new UnchangedResourceModelElement(parent, resource);
        this.addToViewer(newNode);
        return newNode;
    }

    protected Object[] getModelObjects(IResource[] resources) {
        Object[] result = new Object[resources.length];
        int i = 0;
        while (i < resources.length) {
            result[i] = this.getModelObject(resources[i]);
            ++i;
        }
        return result;
    }

    protected void addResources(IResource[] added) {
        IResource[] iResourceArray = added;
        int n = added.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            this.addResource(resource);
            ++n2;
        }
    }

    private void addResource(IResource resource) {
        ISynchronizeModelElement parent;
        ISynchronizeModelElement node = this.getModelObject(resource);
        if (node != null) {
            this.removeFromViewer(resource);
        }
        if ((parent = this.getModelObject((IResource)resource.getParent())) != null) {
            node = this.createModelObject(parent, resource);
            this.buildModelObjects(node);
        }
    }

    @Override
    protected IDiffElement[] buildModelObjects(ISynchronizeModelElement node) {
        IDiffElement[] children;
        IDiffElement[] iDiffElementArray = children = this.createModelObjects(node);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IDiffElement element = iDiffElementArray[n2];
            if (element instanceof ISynchronizeModelElement) {
                this.buildModelObjects((ISynchronizeModelElement)element);
            }
            ++n2;
        }
        return children;
    }

    @Override
    protected void handleResourceAdditions(ISyncInfoTreeChangeEvent event) {
        SyncInfo[] infos = event.getAddedResources();
        HashSet<IProject> set = new HashSet<IProject>();
        SyncInfo[] syncInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            SyncInfo info = syncInfoArray[n2];
            set.add(info.getLocal().getProject());
            ++n2;
        }
        for (IProject element : set) {
            this.addResource((IResource)element);
        }
    }

    @Override
    protected void handleResourceRemovals(ISyncInfoTreeChangeEvent event) {
        IResource[] removedResources;
        IResource[] removedRoots = event.getRemovedSubtreeRoots();
        this.removeFromViewer(removedRoots);
        IResource[] iResourceArray = removedResources = event.getRemovedResources();
        int n = removedResources.length;
        int n2 = 0;
        while (n2 < n) {
            ISynchronizeModelElement node;
            IResource resource = iResourceArray[n2];
            if (resource.getType() != 1 && (node = this.getModelObject(resource)) != null) {
                this.removeFromViewer(resource);
            }
            ++n2;
        }
    }

    @Override
    protected ISynchronizeModelElement createModelObject(ISynchronizeModelElement parent, SyncInfo info) {
        return this.createModelObject(parent, info.getLocal());
    }

    @Override
    protected void addResource(SyncInfo info) {
        this.addResource(info.getLocal());
    }

    public static class HierarchicalModelProviderDescriptor
    implements ISynchronizeModelProviderDescriptor {
        public static final String ID = "org.eclipse.team.ui.modelprovider_hierarchical";

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public String getName() {
            return TeamUIMessages.HierarchicalModelProvider_0;
        }

        @Override
        public ImageDescriptor getImageDescriptor() {
            return TeamImages.getImageDescriptor("elcl16/hierarchicalLayout.png");
        }
    }
}

