/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.eclipse.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.environment.Choice;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.environment.StatusException;
import org.eclipse.wst.common.frameworks.internal.dialog.ui.MessageDialog;
import org.eclipse.wst.common.frameworks.internal.eclipse.ui.Messages;

public class EclipseStatusHandler
implements IStatusHandler {
    private Shell shell_;

    public EclipseStatusHandler() {
        this(new Shell());
    }

    public EclipseStatusHandler(Shell shell) {
        this.shell_ = shell;
    }

    public Choice report(IStatus status, Choice[] choices) {
        int result = MessageDialog.openMessage(this.shell_, Messages.TITLE_WARNING, null, status, choices);
        int i = 0;
        while (i < choices.length) {
            if (choices[i].getShortcut() == result) {
                return choices[i];
            }
            ++i;
        }
        return null;
    }

    public void report(IStatus status) throws StatusException {
        boolean userOk = false;
        switch (status.getSeverity()) {
            case 4: {
                userOk = this.reportErrorStatus(status);
                break;
            }
            case 2: {
                userOk = this.reportWarning(status);
                break;
            }
            case 1: {
                userOk = true;
                this.reportInfo(status);
            }
        }
        if (!userOk) {
            throw new StatusException(status);
        }
    }

    private boolean reportWarning(IStatus status) {
        int userResponse = MessageDialog.openMessage(this.shell_, Messages.TITLE_WARNING, null, status);
        return userResponse == 0;
    }

    private boolean reportErrorStatus(IStatus status) {
        MessageDialog.openMessage(this.shell_, Messages.TITLE_ERROR, null, status);
        return false;
    }

    public void reportError(IStatus status) {
        this.reportErrorStatus(status);
    }

    public void reportInfo(IStatus status) {
        MessageDialog.openMessage(this.shell_, Messages.TITLE_INFO, null, status);
    }
}

