/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.core.search.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.core.search.internal.SearchParticipantDescriptor;
import org.eclipse.wst.common.core.search.internal.SearchParticipantRegistry;

public class SearchParticipantRegistryReader {
    protected static final String EXTENSION_POINT_ID = "searchParticipants";
    protected static final String TAG_NAME = "searchParticipant";
    protected static final String ATT_CLASS = "class";
    protected static final String ATT_ID = "id";
    protected String pluginId;
    protected String extensionPointId;
    protected SearchParticipantRegistry registry;

    public SearchParticipantRegistryReader(SearchParticipantRegistry registry) {
        this.registry = registry;
    }

    public void readRegistry() {
        String bundleid = "org.eclipse.wst.common.core";
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(bundleid, EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
    }

    protected void readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG_NAME)) {
            String contributorClass = element.getAttribute(ATT_CLASS);
            String id = element.getAttribute(ATT_ID);
            if (id != null && contributorClass != null) {
                SearchParticipantDescriptor descriptor = new SearchParticipantDescriptor(element);
                this.registry.putSearchParticipant(id, descriptor);
            }
        }
    }
}

