/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpApplication;
import org.eclipse.help.internal.base.HelpDisplay;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class ControlServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String CMD_DISPLAYHELP = "displayHelp";
    public static final String CMD_DISPLAYHELPWINDOW = "displayHelpWindow";
    public static final String CMD_SHUTDOWN = "shutdown";
    public static final String CMD_INSTALL = "install";
    public static final String CMD_UPDATE = "update";
    public static final String CMD_ENABLE = "enable";
    public static final String CMD_DISABLE = "disable";
    public static final String CMD_UNINSTALL = "uninstall";
    public static final String CMD_SEARCH = "search";
    public static final String CMD_LIST = "listFeatures";
    public static final String CMD_ADDSITE = "addSite";
    public static final String CMD_APPLY = "apply";
    public static final String CMD_REMOVESITE = "removeSite";
    public static final String PACKAGE_PREFIX = "org.eclipse.update.standalone.";
    public static final String CLASS_INSTALL = "org.eclipse.update.standalone.InstallCommand";
    public static final String CLASS_UPDATE = "org.eclipse.update.standalone.UpdateCommand";
    public static final String CLASS_ENABLE = "org.eclipse.update.standalone.EnableCommand";
    public static final String CLASS_DISABLE = "org.eclipse.update.standalone.DisableCommand";
    public static final String CLASS_UNINSTALL = "org.eclipse.update.standalone.UninstallCommand";
    public static final String CLASS_SEARCH = "org.eclipse.update.standalone.SearchCommand";
    public static final String CLASS_LIST = "org.eclipse.update.standalone.ListFeaturesCommand";
    public static final String CLASS_ADDSITE = "org.eclipse.update.standalone.AddSiteCommand";
    public static final String CLASS_REMOVESITE = "org.eclipse.update.standalone.RemoveSiteCommand";
    public static final String PARAM_FEATUREID = "featureId";
    public static final String PARAM_VERSION = "version";
    public static final String PARAM_FROM = "from";
    public static final String PARAM_TO = "to";
    public static final String PARAM_VERIFYONLY = "verifyOnly";
    private HelpDisplay helpDisplay = null;
    private boolean shuttingDown = false;

    public void init() throws ServletException {
        super.init();
        if (BaseHelpSystem.getMode() == 2) {
            this.helpDisplay = BaseHelpSystem.getHelpDisplay();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        resp.setDateHeader("Expires", 0L);
        if (!UrlUtil.isLocalRequest(req)) {
            return;
        }
        if (!"/help".equals(req.getContextPath()) || !"/control".equals(req.getServletPath())) {
            resp.sendError(403, "");
            return;
        }
        if (this.shuttingDown) {
            return;
        }
        String command = req.getParameter("command");
        if (command == null) {
            resp.getWriter().print("No command.");
            return;
        }
        if (CMD_SHUTDOWN.equalsIgnoreCase(command)) {
            this.shutdown();
        } else if (CMD_DISPLAYHELP.equalsIgnoreCase(command)) {
            if (BaseHelpSystem.getMode() == 2) {
                this.displayHelp(req);
            }
        } else if (CMD_DISPLAYHELPWINDOW.equalsIgnoreCase(command)) {
            if (BaseHelpSystem.getMode() == 2) {
                this.displayHelp(req);
                HelpApplication.setShutdownOnClose((boolean)true);
            }
        } else if (!(CMD_INSTALL.equalsIgnoreCase(command) || CMD_ENABLE.equalsIgnoreCase(command) || CMD_UPDATE.equalsIgnoreCase(command) || CMD_DISABLE.equalsIgnoreCase(command) || CMD_UNINSTALL.equalsIgnoreCase(command) || CMD_SEARCH.equalsIgnoreCase(command) || CMD_LIST.equalsIgnoreCase(command) || CMD_ADDSITE.equalsIgnoreCase(command) || CMD_REMOVESITE.equalsIgnoreCase(command) || CMD_APPLY.equalsIgnoreCase(command))) {
            resp.getWriter().print("Unrecognized command.");
        }
    }

    private void shutdown() {
        this.shuttingDown = true;
        HelpApplication.stopHelp();
    }

    private void displayHelp(HttpServletRequest req) {
        String href = req.getParameter("href");
        if (href != null) {
            this.helpDisplay.displayHelpResource(href, false);
        } else {
            this.helpDisplay.displayHelp(false);
        }
    }
}

