/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.trace;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.GenericFtraceField;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.trace.GenericFtrace;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;

public abstract class FtraceTrace
extends GenericFtrace {
    private static final int MAX_LINES = 100;
    private static final int MAX_CONFIDENCE = 100;

    public IStatus validate(IProject project, String path) {
        int confidence;
        block31: {
            File file = new File(path);
            if (!file.exists()) {
                return new Status(4, "org.eclipse.tracecompass.incubator.ftrace.core", "File not found: " + path);
            }
            if (!file.isFile()) {
                return new Status(4, "org.eclipse.tracecompass.incubator.ftrace.core", "Not a file. It's a directory: " + path);
            }
            confidence = 0;
            try {
                if (TmfTraceUtils.isText((File)file)) break block31;
                int magicLength = TRACE_CMD_DAT_MAGIC.length;
                if (file.length() > (long)magicLength) {
                    Throwable throwable = null;
                    Object var7_14 = null;
                    try (FileInputStream fis = new FileInputStream(file);){
                        byte[] start = new byte[magicLength];
                        int read = fis.read(start);
                        if (read == magicLength && Arrays.equals(TRACE_CMD_DAT_MAGIC, start)) {
                            return new Status(4, "org.eclipse.tracecompass.incubator.ftrace.core", "This file looks like a binary trace-cmd, try running 'trace-cmd report -R' on it.");
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                return new TraceValidationStatus(confidence, "org.eclipse.tracecompass.incubator.ftrace.core");
            }
            catch (IOException e) {
                Activator.getInstance().logError("Error validating file: " + path, (Throwable)e);
                return new Status(4, "org.eclipse.tracecompass.incubator.ftrace.core", "IOException validating file: " + path, (Throwable)e);
            }
        }
        try {
            Throwable e = null;
            Object var6_12 = null;
            try (BufferedRandomAccessFile rafile = new BufferedRandomAccessFile(path, "r");){
                int lineCount = 0;
                int matches = 0;
                String line = rafile.readLine();
                while (line != null && lineCount++ < 100) {
                    try {
                        GenericFtraceField field = GenericFtraceField.parseLine(line);
                        if (field != null) {
                            ++matches;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        confidence = Integer.MIN_VALUE;
                    }
                    confidence = 100 * matches / lineCount;
                    line = rafile.readLine();
                }
                if (matches == 0) {
                    return new Status(4, "org.eclipse.tracecompass.incubator.ftrace.core", "Most assuredly NOT an fTrace text trace");
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            Activator.getInstance().logError("Error validating file: " + path, (Throwable)e);
            return new Status(4, "org.eclipse.tracecompass.incubator.ftrace.core", "IOException validating file: " + path, (Throwable)e);
        }
        return new TraceValidationStatus(confidence, "org.eclipse.tracecompass.incubator.ftrace.core");
    }
}

