/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.Activator;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.ExperimentQueryParameters;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.QueryParameters;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.Experiment;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.QueryParametersUtil;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.TraceManagerService;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.model.annotations.TraceAnnotationProvider;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

@Path(value="/experiments")
@Tag(name="Experiments")
public class ExperimentManagerService {
    private static final Map<UUID, List<UUID>> TRACE_UUIDS = Collections.synchronizedMap(new HashMap());
    private static final Map<UUID, Map<UUID, ITmfTrace>> TRACE_INSTANCES = Collections.synchronizedMap(new HashMap());
    private static final Map<UUID, IResource> EXPERIMENT_RESOURCES = Collections.synchronizedMap(ExperimentManagerService.initExperimentResources());
    private static final Map<UUID, TmfExperiment> EXPERIMENTS = Collections.synchronizedMap(new HashMap());
    private static final Map<UUID, TraceAnnotationProvider> TRACE_ANNOTATION_PROVIDERS = Collections.synchronizedMap(new HashMap());
    private static final String EXPERIMENTS_FOLDER = "Experiments";
    private static final String TRACES_FOLDER = "Traces";
    private static final String SUFFIX = "_exp";
    private static final String BOOKMARKS_HIDDEN_FILE = ".bookmarks";
    private static final String EXPERIMENT_EDITOR_INPUT_TYPE = "editorInputType.experiment";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get the list of experiments on the server", responses={@ApiResponse(responseCode="200", description="Returns a list of experiments", content={@Content(array=@ArraySchema(schema=@Schema(implementation=org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.Experiment.class)))})})
    public Response getExperiments() {
        Map<UUID, IResource> map = EXPERIMENT_RESOURCES;
        synchronized (map) {
            List experiments = Lists.transform(new ArrayList<Map.Entry<UUID, IResource>>(EXPERIMENT_RESOURCES.entrySet()), e -> {
                UUID expUUID = (UUID)e.getKey();
                TmfExperiment experiment = EXPERIMENTS.get(expUUID);
                if (experiment != null) {
                    return Experiment.from(experiment, expUUID);
                }
                IResource experimentResource = (IResource)e.getValue();
                return Experiment.from(experimentResource, expUUID);
            });
            return Response.ok((Object)experiments).build();
        }
    }

    private static Map<UUID, IResource> initExperimentResources() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME);
        HashMap<UUID, IResource> experimentResources = new HashMap<UUID, IResource>();
        try {
            project.refreshLocal(2, null);
            IFolder experimentsFolder = project.getFolder(EXPERIMENTS_FOLDER);
            experimentsFolder.accept(resource -> {
                if (resource.equals((Object)experimentsFolder)) {
                    return true;
                }
                if (resource instanceof IFolder) {
                    UUID expUUID = UUID.nameUUIDFromBytes(Objects.requireNonNull(resource.getName().getBytes(Charset.defaultCharset())));
                    experimentResources.put(expUUID, resource);
                    List<UUID> traceUUIDs = ExperimentManagerService.getTraceUUIDs((IFolder)resource);
                    TRACE_UUIDS.put(expUUID, traceUUIDs);
                }
                return false;
            }, 1, 0);
        }
        catch (CoreException coreException) {}
        return experimentResources;
    }

    private static List<UUID> getTraceUUIDs(IFolder experimentResource) throws CoreException {
        ArrayList<UUID> traceUUIDs = new ArrayList<UUID>();
        experimentResource.accept(resource -> {
            if (resource instanceof IFile) {
                IPath path = resource.getProjectRelativePath().makeRelativeTo(experimentResource.getProjectRelativePath());
                IResource traceResource = experimentResource.getProject().getFolder(TRACES_FOLDER).findMember(path);
                if (traceResource != null) {
                    traceUUIDs.add(TraceManagerService.getTraceUUID(traceResource));
                }
                return false;
            }
            return true;
        });
        return traceUUIDs;
    }

    @GET
    @Path(value="/{expUUID}")
    @Produces(value={"application/json"})
    @Operation(summary="Get the model object for an experiment", responses={@ApiResponse(responseCode="200", description="Return the experiment model", content={@Content(schema=@Schema(implementation=org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.Experiment.class))}), @ApiResponse(responseCode="404", description="No such experiment", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getExperiment(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID) {
        TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
        if (experiment != null) {
            return Response.ok((Object)Experiment.from(experiment, expUUID)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{expUUID}")
    @Produces(value={"application/json"})
    @Operation(summary="Remove an experiment from the server", responses={@ApiResponse(responseCode="200", description="The trace was successfully deleted, return the deleted experiment.", content={@Content(schema=@Schema(implementation=org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.Experiment.class))}), @ApiResponse(responseCode="404", description="No such experiment", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response deleteExperiment(@Parameter(description="UUID of the experiment to query") @PathParam(value="expUUID") UUID expUUID) {
        Experiment experimentModel;
        IResource resource = EXPERIMENT_RESOURCES.remove(expUUID);
        if (resource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        TmfExperiment experiment = EXPERIMENTS.remove(expUUID);
        Experiment experiment2 = experimentModel = experiment != null ? Experiment.from(experiment, expUUID) : Experiment.from(resource, expUUID);
        if (experiment != null) {
            TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceClosedSignal((Object)this, (ITmfTrace)experiment));
            experiment.dispose();
        }
        TRACE_ANNOTATION_PROVIDERS.remove(expUUID);
        TRACE_UUIDS.remove(expUUID);
        TRACE_INSTANCES.remove(expUUID);
        boolean deleteResources = true;
        Map<UUID, TmfExperiment> map = EXPERIMENTS;
        synchronized (map) {
            for (TmfExperiment e : EXPERIMENTS.values()) {
                if (!resource.equals((Object)e.getResource())) continue;
                deleteResources = false;
                break;
            }
        }
        if (deleteResources) {
            try {
                File supplFolder = new File(resource.getPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER));
                FileUtils.cleanDirectory((File)supplFolder);
                supplFolder.delete();
                resource.delete(true, null);
                resource.getProject().refreshLocal(Integer.MAX_VALUE, null);
            }
            catch (IOException | CoreException e) {
                Activator.getInstance().logError("Failed to delete experiment", e);
            }
        }
        return Response.ok((Object)experimentModel).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a new experiment on the server", responses={@ApiResponse(responseCode="200", description="The experiment was successfully created", content={@Content(schema=@Schema(implementation=org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.Experiment.class))}), @ApiResponse(responseCode="204", description="The experiment has at least one trace which hasn't been created yet", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="400", description="Invalid query parameters", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="409", description="The experiment (name) already exists and both differ", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="500", description="Internal trace-server error while trying to post experiment", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response postExperiment(@RequestBody(content={@Content(schema=@Schema(implementation=ExperimentQueryParameters.class))}, required=true) QueryParameters queryParameters) {
        IFolder resource;
        if (queryParameters == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing query parameters").build();
        }
        Map<String, Object> parameters = queryParameters.getParameters();
        String errorMessage = QueryParametersUtil.validateExperimentQueryParameters(parameters);
        if (errorMessage != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
        }
        String name = Objects.requireNonNull((String)parameters.get("name"));
        List tracesObj = Objects.requireNonNull((List)parameters.get("traces"));
        ArrayList<UUID> traceUUIDs = new ArrayList<UUID>();
        ArrayList<IResource> traceResources = new ArrayList<IResource>();
        for (Object uuidObj : tracesObj) {
            if (!(uuidObj instanceof String)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            UUID uuid = UUID.fromString((String)uuidObj);
            IResource traceResource = TraceManagerService.getTraceResource(uuid);
            if (traceResource == null) {
                return Response.noContent().build();
            }
            traceResources.add(traceResource);
            traceUUIDs.add(uuid);
        }
        UUID expUUID = UUID.nameUUIDFromBytes(Objects.requireNonNull(name.getBytes(Charset.defaultCharset())));
        try {
            resource = ExperimentManagerService.getExperimentResource(name);
            if (resource.exists()) {
                HashMultiset newTraceResources;
                HashMultiset oldTraceResources = HashMultiset.create(ExperimentManagerService.getTraceResources(resource));
                if (!oldTraceResources.equals((Object)(newTraceResources = HashMultiset.create(traceResources)))) {
                    TmfExperiment oldExperiment = new TmfExperiment(ITmfEvent.class, resource.getLocation().toOSString(), new ITmfTrace[0], 5000, (IResource)resource);
                    Experiment entity = Experiment.from(oldExperiment, expUUID);
                    oldExperiment.dispose();
                    return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)entity).build();
                }
                TmfExperiment experiment = EXPERIMENTS.get(expUUID);
                if (experiment != null) {
                    return Response.ok((Object)Experiment.from(experiment, expUUID)).build();
                }
            } else {
                ExperimentManagerService.createExperiment(resource, traceResources);
            }
        }
        catch (CoreException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
        TRACE_UUIDS.put(expUUID, traceUUIDs);
        EXPERIMENT_RESOURCES.put(expUUID, (IResource)resource);
        TmfExperiment experiment = ExperimentManagerService.createExperimentInstance(expUUID);
        if (experiment == null) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Failed to instantiate experiment").build();
        }
        return Response.ok((Object)Experiment.from(experiment, expUUID)).build();
    }

    private static @Nullable TmfExperiment createExperimentInstance(UUID expUUID) {
        List<UUID> traceUUIDs = TRACE_UUIDS.get(expUUID);
        IResource resource = EXPERIMENT_RESOURCES.get(expUUID);
        if (traceUUIDs == null || resource == null) {
            return null;
        }
        ExperimentManagerService.createSupplementaryFolder(resource);
        LinkedHashMap<UUID, ITmfTrace> uuidToTraceInstances = new LinkedHashMap<UUID, ITmfTrace>();
        for (UUID uuid : traceUUIDs) {
            ITmfTrace trace = TraceManagerService.createTraceInstance(uuid);
            uuidToTraceInstances.put(uuid, trace);
        }
        int cacheSize = Integer.MAX_VALUE;
        for (ITmfTrace trace : uuidToTraceInstances.values()) {
            cacheSize = Math.min(cacheSize, trace.getCacheSize());
        }
        TmfExperiment experiment = null;
        try {
            ITmfTrace[] traces = uuidToTraceInstances.values().toArray(new ITmfTrace[0]);
            String experimentTypeId = ExperimentManagerService.getOrDetectExerimentType(resource, traces);
            experiment = TmfTraceType.instantiateExperiment((String)experimentTypeId);
            if (experiment != null) {
                experiment.initExperiment(ITmfEvent.class, resource.getLocation().toOSString(), traces, cacheSize, resource, experimentTypeId);
                experiment.indexTrace(false);
                ITmfContext ctx = experiment.seekEvent(0L);
                experiment.getNext(ctx);
                ctx.dispose();
                TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceOpenedSignal(ExperimentManagerService.class, (ITmfTrace)experiment, ExperimentManagerService.createBookmarksFile(resource)));
                EXPERIMENTS.put(expUUID, experiment);
                TRACE_INSTANCES.put(expUUID, uuidToTraceInstances);
                TRACE_ANNOTATION_PROVIDERS.put(expUUID, new TraceAnnotationProvider((ITmfTrace)experiment));
                return experiment;
            }
        }
        catch (CoreException coreException) {
            Activator.getInstance().logWarning("Error instantiating experiment");
        }
        return experiment;
    }

    private static @NonNull String getOrDetectExerimentType(IResource resource, ITmfTrace[] traces) throws CoreException {
        String experimentTypeId = TmfTraceType.getTraceTypeId((IResource)resource);
        if (experimentTypeId == null) {
            experimentTypeId = "org.eclipse.linuxtools.tmf.core.experiment.generic";
            List helpers = TmfTraceType.selectExperimentType(Arrays.asList(traces), null);
            if (!helpers.isEmpty()) {
                experimentTypeId = ((TraceTypeHelper)helpers.get(0)).getTraceTypeId();
            }
            resource.setPersistentProperty(TmfCommonConstants.TRACETYPE, experimentTypeId);
        } else if (TmfTraceType.getTraceAttributes((String)experimentTypeId) == null) {
            Activator.getInstance().logWarning("Extension for experiment type (" + experimentTypeId + ") not installed. Fall-back to generic experiment.");
            experimentTypeId = "org.eclipse.linuxtools.tmf.core.experiment.generic";
        }
        return experimentTypeId;
    }

    private static IFolder getExperimentResource(String name) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME);
        project.refreshLocal(2, null);
        IFolder experimentsFolder = project.getFolder(EXPERIMENTS_FOLDER);
        return experimentsFolder.getFolder(name);
    }

    private static List<IResource> getTraceResources(final IFolder folder) {
        final ArrayList<IResource> list = new ArrayList<IResource>();
        final IFolder tracesFolder = folder.getProject().getFolder(TRACES_FOLDER);
        try {
            folder.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy resource) throws CoreException {
                    if (resource.getType() == 1) {
                        IResource traceResourceUnderExperiment = resource.requestResource();
                        IPath relativePath = traceResourceUnderExperiment.getProjectRelativePath().makeRelativeTo(folder.getProjectRelativePath());
                        IResource traceResource = tracesFolder.findMember(relativePath);
                        if (traceResource != null) {
                            list.add(traceResource);
                        }
                        return false;
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException coreException) {}
        list.sort(Comparator.comparing(resource -> resource.getFullPath().toString()));
        return list;
    }

    private static void createExperiment(IFolder folder, List<IResource> traceResources) throws CoreException {
        ExperimentManagerService.createFolder(folder);
        for (IResource traceResource : traceResources) {
            ExperimentManagerService.addTrace(folder, traceResource);
        }
    }

    private static void addTrace(IFolder folder, IResource traceResource) throws CoreException {
        IPath relativePath = traceResource.getProjectRelativePath().removeFirstSegments(1);
        IFile file = folder.getFile(relativePath);
        ExperimentManagerService.createFolder((IFolder)file.getParent());
        file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, (IProgressMonitor)new NullProgressMonitor());
        file.setPersistentProperty(TmfCommonConstants.TRACETYPE, TmfTraceType.getTraceTypeId((IResource)traceResource));
    }

    private static void createSupplementaryFolder(IResource experimentResource) {
        try {
            IFolder supplRootFolder = experimentResource.getProject().getFolder(".tracing");
            IFolder supplFolder = supplRootFolder.getFolder(experimentResource.getName() + SUFFIX);
            ExperimentManagerService.createFolder(supplFolder);
            experimentResource.setPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER, supplFolder.getLocation().toOSString());
        }
        catch (CoreException coreException) {}
    }

    private static IFile createBookmarksFile(IResource resource) {
        IFile file = ((IFolder)resource).getFile(resource.getName() + "_");
        try {
            if (!file.exists()) {
                IFile bookmarksFile = ((IFolder)resource.getParent()).getFile(BOOKMARKS_HIDDEN_FILE);
                if (!bookmarksFile.exists()) {
                    ByteArrayInputStream source = new ByteArrayInputStream(new byte[0]);
                    bookmarksFile.create((InputStream)source, 4097, (IProgressMonitor)new NullProgressMonitor());
                }
                file.createLink(bookmarksFile.getLocation(), 4352, (IProgressMonitor)new NullProgressMonitor());
            }
            file.setPersistentProperty(TmfCommonConstants.TRACETYPE, EXPERIMENT_EDITOR_INPUT_TYPE);
        }
        catch (CoreException e) {
            Activator.getInstance().logWarning("Error creating bookmarks file", (Throwable)e);
        }
        return file;
    }

    private static void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            if (folder.getParent() instanceof IFolder) {
                ExperimentManagerService.createFolder((IFolder)folder.getParent());
            }
            folder.create(true, true, null);
        }
    }

    public static synchronized @Nullable TmfExperiment getExperimentByUUID(UUID expUUID) {
        TmfExperiment experiment = EXPERIMENTS.get(expUUID);
        if (experiment == null) {
            experiment = ExperimentManagerService.createExperimentInstance(expUUID);
        }
        return experiment;
    }

    public static List<UUID> getTraceUUIDs(UUID expUUID) {
        return TRACE_UUIDS.getOrDefault(expUUID, Collections.emptyList());
    }

    public static Map<UUID, ITmfTrace> getTraceInstances(UUID expUUID) {
        return TRACE_INSTANCES.getOrDefault(expUUID, Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTraceInUse(UUID uuid) {
        Map<UUID, List<UUID>> map = TRACE_UUIDS;
        synchronized (map) {
            return TRACE_UUIDS.values().stream().anyMatch(traceUUIDs -> traceUUIDs.contains(uuid));
        }
    }

    public static TraceAnnotationProvider getTraceAnnotationProvider(UUID uuid) {
        return TRACE_ANNOTATION_PROVIDERS.get(uuid);
    }

    public static void dispose() {
        for (TmfExperiment experiment : EXPERIMENTS.values()) {
            if (experiment == null) continue;
            TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceClosedSignal((Object)experiment, (ITmfTrace)experiment));
            experiment.dispose();
        }
        EXPERIMENTS.clear();
        TRACE_UUIDS.clear();
        TRACE_INSTANCES.clear();
        EXPERIMENT_RESOURCES.clear();
        TRACE_ANNOTATION_PROVIDERS.clear();
    }
}

