/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;

public final class IndexOrDocValuesQuery
extends Query {
    private final Query indexQuery;
    private final Query dvQuery;

    public IndexOrDocValuesQuery(Query indexQuery, Query dvQuery) {
        this.indexQuery = indexQuery;
        this.dvQuery = dvQuery;
    }

    public Query getIndexQuery() {
        return this.indexQuery;
    }

    public Query getRandomAccessQuery() {
        return this.dvQuery;
    }

    @Override
    public String toString(String field) {
        return this.indexQuery.toString(field);
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        IndexOrDocValuesQuery that = (IndexOrDocValuesQuery)obj;
        return this.indexQuery.equals(that.indexQuery) && this.dvQuery.equals(that.dvQuery);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.indexQuery.hashCode();
        h = 31 * h + this.dvQuery.hashCode();
        return h;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query indexRewrite = this.indexQuery.rewrite(reader);
        Query dvRewrite = this.dvQuery.rewrite(reader);
        if (this.indexQuery != indexRewrite || this.dvQuery != dvRewrite) {
            return new IndexOrDocValuesQuery(indexRewrite, dvRewrite);
        }
        return this;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        final Weight indexWeight = this.indexQuery.createWeight(searcher, scoreMode, boost);
        final Weight dvWeight = this.dvQuery.createWeight(searcher, scoreMode, boost);
        return new Weight(this){

            @Override
            public void extractTerms(Set<Term> terms) {
                indexWeight.extractTerms(terms);
            }

            @Override
            public Matches matches(LeafReaderContext context, int doc) throws IOException {
                return dvWeight.matches(context, doc);
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                return dvWeight.explain(context, doc);
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                return indexWeight.bulkScorer(context);
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final ScorerSupplier indexScorerSupplier = indexWeight.scorerSupplier(context);
                final ScorerSupplier dvScorerSupplier = dvWeight.scorerSupplier(context);
                if (indexScorerSupplier == null || dvScorerSupplier == null) {
                    return null;
                }
                return new ScorerSupplier(){

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        long threshold = this.cost() >>> 3;
                        if (threshold <= leadCost) {
                            return indexScorerSupplier.get(leadCost);
                        }
                        return dvScorerSupplier.get(leadCost);
                    }

                    @Override
                    public long cost() {
                        return indexScorerSupplier.cost();
                    }
                };
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return indexWeight.isCacheable(ctx);
            }
        };
    }
}

