/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui;

import java.util.ArrayList;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class SelectionConverter {
    public Object[] getElements(IStructuredModel model, int start, int end) {
        IndexedRegion region;
        Object[] localSelectedStructures = null;
        if (model != null && (region = model.getIndexedRegion(start)) != null) {
            if (end <= region.getEndOffset()) {
                localSelectedStructures = new Object[]{region};
            } else {
                int maxLength = model.getStructuredDocument().getLength();
                ArrayList<IndexedRegion> structures = new ArrayList<IndexedRegion>(2);
                while (region != null && region.getEndOffset() <= end && region.getEndOffset() < maxLength) {
                    structures.add(region);
                    region = model.getIndexedRegion(region.getEndOffset() + 1);
                }
                localSelectedStructures = structures.toArray();
            }
        }
        if (localSelectedStructures == null) {
            localSelectedStructures = new Object[]{};
        }
        return localSelectedStructures;
    }

    public IRegion getRegion(Object o) {
        if (o instanceof ITextRegion) {
            int start = ((ITextRegion)o).getStart();
            return new Region(start, ((ITextRegion)o).getEnd() - start);
        }
        if (o instanceof IRegion) {
            return new Region(((IRegion)o).getOffset(), ((IRegion)o).getLength());
        }
        int startOffset = ((IndexedRegion)o).getStartOffset();
        return new Region(startOffset, ((IndexedRegion)o).getEndOffset() - startOffset);
    }

    public IRegion getSelectionRegion(Object o) {
        if (o instanceof ITextRegion) {
            int start = ((ITextRegion)o).getStart();
            return new Region(start, 0);
        }
        if (o instanceof IRegion) {
            return new Region(((IRegion)o).getOffset(), 0);
        }
        int startOffset = ((IndexedRegion)o).getStartOffset();
        return new Region(startOffset, 0);
    }
}

