/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.ease.ui.scripts.ui.ScriptPopup;
import org.eclipse.ease.ui.scripts.ui.ScriptPopupMenu;
import org.eclipse.ease.ui.tools.AbstractPopupItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public final class ScriptContributionFactory
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator fServiceLocator;
    private boolean fDirty = true;

    public void initialize(IServiceLocator serviceLocator) {
        this.fServiceLocator = serviceLocator;
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<IContributionItem> contributions = new ArrayList<IContributionItem>();
        IRepositoryService repositoryService = (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
        if (repositoryService != null) {
            ArrayList<IScript> scripts = new ArrayList<IScript>(repositoryService.getScripts());
            Collections.sort(scripts, new Comparator<IScript>(){

                @Override
                public int compare(IScript o1, IScript o2) {
                    IPath path1 = o1.getPath();
                    IPath path2 = o2.getPath();
                    if (path1.isEmpty() && !path2.isEmpty()) {
                        return 1;
                    }
                    if (!path1.isEmpty() && path2.isEmpty()) {
                        return -1;
                    }
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            HashMap<IPath, ScriptPopupMenu> dynamicMenus = new HashMap<IPath, ScriptPopupMenu>();
            ArrayList<IContributionItem> rootItems = new ArrayList<IContributionItem>();
            for (IScript iScript : scripts) {
                ScriptPopup popup = new ScriptPopup(iScript);
                IPath path = iScript.getPath().removeLastSegments(1);
                if (path.lastSegment() == null) {
                    rootItems.add(popup.getContribution(this.fServiceLocator));
                    continue;
                }
                ScriptPopupMenu menu = ScriptContributionFactory.registerPath(dynamicMenus, path);
                menu.addItem(popup);
            }
            for (Map.Entry entry : dynamicMenus.entrySet()) {
                if (((IPath)entry.getKey()).segmentCount() != 1) continue;
                contributions.add(((ScriptPopupMenu)((Object)entry.getValue())).getContribution(this.fServiceLocator));
            }
            for (IContributionItem iContributionItem : rootItems) {
                contributions.add(iContributionItem);
            }
            this.fDirty = false;
        }
        return contributions.toArray(new IContributionItem[contributions.size()]);
    }

    public boolean isDirty() {
        return true;
    }

    public void dispose() {
        this.fDirty = false;
        super.dispose();
    }

    private static ScriptPopupMenu registerPath(Map<IPath, ScriptPopupMenu> dynamicMenus, IPath path) {
        if (!dynamicMenus.containsKey(path)) {
            dynamicMenus.put(path, new ScriptPopupMenu(path.lastSegment()));
            if (path.segmentCount() > 1) {
                IPath parent = path.removeLastSegments(1);
                ScriptPopupMenu parentMenu = ScriptContributionFactory.registerPath(dynamicMenus, parent);
                parentMenu.addItem((AbstractPopupItem)dynamicMenus.get(path));
            }
        }
        return dynamicMenus.get(path);
    }
}

