/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.duallist.DLItem;
import org.eclipse.nebula.widgets.opal.duallist.SelectionChangeEvent;
import org.eclipse.nebula.widgets.opal.duallist.SelectionChangeListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class DualSelectionList
extends Composite {
    private static final String MOVE_BOTTOM_IMAGE = "double_down.png";
    private static final String MOVE_TOP_IMAGE = "double_up.png";
    private static final String DESELECT_ALL_IMAGE = "double_left.png";
    private static final String SELECT_ALL_IMAGE = "double_right.png";
    private static final String MOVE_DOWN_IMAGE = "arrow_down.png";
    private static final String DESELECT_IMAGE = "arrow_left.png";
    private static final String MOVE_UP_IMAGE = "arrow_up.png";
    private static final String SELECT_IMAGE = "arrow_right.png";
    private List<DLItem> fOriginalItems = new ArrayList<DLItem>();
    private List<DLItem> fSelectedItems = new ArrayList<DLItem>();
    private Table fOriginalItemsTable;
    private Table fSelectedItemsTable;
    private List<SelectionChangeListener> fSelectionChangeListeners = new ArrayList<SelectionChangeListener>();

    public DualSelectionList(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(4, false));
        this.createOriginalItemsTable();
        this.createSelectAllButton();
        this.createSelectedItemsTable();
        this.createMoveTopButton();
        this.createButtonSelect();
        this.createButtonMoveUp();
        this.createButtonDeselect();
        this.createButtonMoveDown();
        this.createButtonDeselectAll();
        this.createButtonMoveBottom();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        Point itemsTableDefaultSize = this.fOriginalItemsTable.computeSize(-1, -1);
        Point selectionTableDefaultSize = this.fSelectedItemsTable.computeSize(-1, -1);
        int itemsTableSize = this.fOriginalItemsTable.getSize().x;
        if (itemsTableDefaultSize.y > this.fOriginalItemsTable.getSize().y) {
            itemsTableSize -= this.fOriginalItemsTable.getVerticalBar().getSize().x;
        }
        int selectionTableSize = this.fSelectedItemsTable.getSize().x;
        if (selectionTableDefaultSize.y > this.fSelectedItemsTable.getSize().y) {
            selectionTableSize -= this.fSelectedItemsTable.getVerticalBar().getSize().x;
        }
        boolean itemsContainImage = DualSelectionList.hasImages(this.fOriginalItems) || DualSelectionList.hasImages(this.fSelectedItems);
        TableColumn originalItemsTableZeroColumn = this.fOriginalItemsTable.getColumn(0);
        TableColumn selectedItemsTableZeroColumn = this.fSelectedItemsTable.getColumn(0);
        if (itemsContainImage) {
            originalItemsTableZeroColumn.pack();
            this.fOriginalItemsTable.getColumn(1).setWidth(itemsTableSize - originalItemsTableZeroColumn.getWidth());
            selectedItemsTableZeroColumn.pack();
            this.fSelectedItemsTable.getColumn(1).setWidth(selectionTableSize - selectedItemsTableZeroColumn.getWidth());
        } else {
            originalItemsTableZeroColumn.setWidth(itemsTableSize);
            selectedItemsTableZeroColumn.setWidth(selectionTableSize);
        }
        originalItemsTableZeroColumn.pack();
        selectedItemsTableZeroColumn.pack();
    }

    public void setItems(List<DLItem> items) {
        this.checkWidget();
        this.fOriginalItems = new ArrayList<DLItem>();
        if (items == null) {
            this.refreshTables();
            return;
        }
        for (DLItem item : items) {
            if (item == null) continue;
            this.fOriginalItems.add(item);
        }
        this.refreshTables();
    }

    public List<DLItem> getSelected() {
        return new ArrayList<DLItem>(this.fSelectedItems);
    }

    public void setSelected(List<DLItem> list) {
        this.fSelectedItems.clear();
        this.fSelectedItems.addAll(list);
        this.refreshTables();
    }

    public void addSelectionChangeListener(SelectionChangeListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.fSelectionChangeListeners.add(listener);
    }

    public void removeSelectionChangeListener(SelectionChangeListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.fSelectionChangeListeners.remove(listener);
    }

    private void selectItems(int[] indicesToSelect) {
        this.checkWidget();
        Arrays.sort(indicesToSelect);
        int[] nArray = indicesToSelect;
        int n = indicesToSelect.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            this.fSelectedItems.add(this.fOriginalItems.get(index));
            ++n2;
        }
        this.fireSelectionChangeEvent(this.getSelected());
        this.refreshTables();
        this.fOriginalItemsTable.select(indicesToSelect);
        this.fOriginalItemsTable.forceFocus();
    }

    private void deselectItems(int[] indicesToRemove) {
        this.checkWidget();
        Arrays.sort(indicesToRemove);
        int i = this.fSelectedItems.size() - 1;
        while (i >= 0) {
            if (DualSelectionList.arrayHasElement(indicesToRemove, i)) {
                this.fSelectedItems.remove(i);
            }
            --i;
        }
        this.fireSelectionChangeEvent(this.getSelected());
        this.refreshTables();
    }

    private void moveTop() {
        this.checkWidget();
        int[] indicesToMove = this.fSelectedItemsTable.getSelectionIndices();
        Arrays.sort(indicesToMove);
        int i = 0;
        int[] nArray = indicesToMove;
        int n = indicesToMove.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            DLItem item = this.fSelectedItems.remove(index);
            this.fSelectedItems.add(i, item);
            ++i;
            ++n2;
        }
        this.refreshTables();
        this.fSelectedItemsTable.select(0, --i);
        this.fSelectedItemsTable.forceFocus();
    }

    private void moveBottom() {
        this.checkWidget();
        int[] indicesToMove = this.fSelectedItemsTable.getSelectionIndices();
        Arrays.sort(indicesToMove);
        int[] nArray = indicesToMove;
        int n = indicesToMove.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            this.fSelectedItems.add(this.fSelectedItems.get(index));
            ++n2;
        }
        int i = this.fSelectedItems.size() - 1;
        while (i >= 0) {
            if (DualSelectionList.arrayHasElement(indicesToMove, i)) {
                this.fSelectedItems.remove(i);
            }
            --i;
        }
        this.refreshTables();
        this.fSelectedItemsTable.select(this.fSelectedItems.size() - indicesToMove.length, this.fSelectedItems.size());
        this.fSelectedItemsTable.forceFocus();
    }

    private void moveUp() {
        this.checkWidget();
        int[] indicesToMove = this.fSelectedItemsTable.getSelectionIndices();
        Arrays.sort(indicesToMove);
        if (DualSelectionList.arrayHasElement(indicesToMove, 0)) {
            return;
        }
        int i = 0;
        while (i < indicesToMove.length) {
            this.swapSelected(indicesToMove[i], indicesToMove[i] - 1);
            indicesToMove[i] = indicesToMove[i] - 1;
            ++i;
        }
        this.refreshTables();
        this.fSelectedItemsTable.select(indicesToMove);
        this.fSelectedItemsTable.forceFocus();
    }

    private void moveDown() {
        this.checkWidget();
        int[] indicesToMove = this.fSelectedItemsTable.getSelectionIndices();
        Arrays.sort(indicesToMove);
        if (DualSelectionList.arrayHasElement(indicesToMove, this.fSelectedItems.size() - 1)) {
            return;
        }
        int i = indicesToMove.length - 1;
        while (i >= 0) {
            this.swapSelected(indicesToMove[i], indicesToMove[i] + 1);
            indicesToMove[i] = indicesToMove[i] + 1;
            --i;
        }
        this.refreshTables();
        this.fSelectedItemsTable.select(indicesToMove);
        this.fSelectedItemsTable.forceFocus();
    }

    private void swapSelected(int index, int otherIndex) {
        DLItem item = this.fSelectedItems.get(index);
        this.fSelectedItems.set(index, this.fSelectedItems.get(otherIndex));
        this.fSelectedItems.set(otherIndex, item);
    }

    private static boolean arrayHasElement(int[] array, int element) {
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            if (e == element) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void refreshTables() {
        this.setRedraw(false);
        this.refreshTable(this.fOriginalItemsTable, this.fOriginalItems);
        this.refreshTable(this.fSelectedItemsTable, this.fSelectedItems);
        this.setRedraw(true);
        this.setBounds(this.getBounds());
        this.getParent().layout(true, true);
    }

    private void refreshTable(Table table, List<DLItem> items) {
        DualSelectionList.cleanTable(table);
        boolean hasImages = DualSelectionList.hasImages(this.fOriginalItems) || DualSelectionList.hasImages(this.fSelectedItems);
        new TableColumn(table, 16384);
        int textColumnIndex = 0;
        if (hasImages) {
            textColumnIndex = 1;
            new TableColumn(table, 16384);
        }
        for (DLItem item : items) {
            TableItem tableItem = new TableItem(table, 0);
            Image image = item.getImage();
            if (image != null) {
                tableItem.setImage(0, image);
            }
            tableItem.setText(textColumnIndex, item.getText());
        }
    }

    private static boolean hasImages(List<DLItem> items) {
        for (DLItem item : items) {
            if (item.getImage() == null) continue;
            return true;
        }
        return false;
    }

    private static void cleanTable(Table table) {
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.dispose();
            ++n2;
        }
        tableItemArray = table.getColumns();
        n = tableItemArray.length;
        n2 = 0;
        while (n2 < n) {
            TableItem column = tableItemArray[n2];
            column.dispose();
            ++n2;
        }
    }

    private void fireSelectionChangeEvent(List<DLItem> items) {
        if (this.fSelectionChangeListeners == null) {
            return;
        }
        Event event = new Event();
        event.button = 1;
        event.display = this.getDisplay();
        event.widget = this;
        SelectionChangeEvent selectionChangeEvent = new SelectionChangeEvent(event);
        selectionChangeEvent.setItems(items);
        for (SelectionChangeListener listener : this.fSelectionChangeListeners) {
            listener.widgetSelected(selectionChangeEvent);
        }
    }

    private void createOriginalItemsTable() {
        this.fOriginalItemsTable = DualSelectionList.createTable(this);
        this.fOriginalItemsTable.addListener(8, e -> this.selectItems(this.fOriginalItemsTable.getSelectionIndices()));
    }

    private void createSelectedItemsTable() {
        this.fSelectedItemsTable = DualSelectionList.createTable(this);
        this.fSelectedItemsTable.addListener(8, e -> this.deselectItems(this.fSelectedItemsTable.getSelectionIndices()));
    }

    private void createSelectAllButton() {
        DualSelectionList.createButton(this, SELECT_ALL_IMAGE).addListener(13, e -> this.selectItems(IntStream.range(0, this.fOriginalItemsTable.getItemCount()).toArray()));
    }

    private void createMoveTopButton() {
        DualSelectionList.createButton(this, MOVE_TOP_IMAGE).addListener(13, e -> this.moveTop());
    }

    private void createButtonSelect() {
        DualSelectionList.createButton(this, SELECT_IMAGE).addListener(13, e -> this.selectItems(this.fOriginalItemsTable.getSelectionIndices()));
    }

    private void createButtonMoveUp() {
        DualSelectionList.createButton(this, MOVE_UP_IMAGE).addListener(13, e -> this.moveUp());
    }

    private void createButtonDeselect() {
        DualSelectionList.createButton(this, DESELECT_IMAGE).addListener(13, e -> this.deselectItems(this.fSelectedItemsTable.getSelectionIndices()));
    }

    private void createButtonMoveDown() {
        DualSelectionList.createButton(this, MOVE_DOWN_IMAGE).addListener(13, e -> this.moveDown());
    }

    private void createButtonDeselectAll() {
        DualSelectionList.createButton(this, DESELECT_ALL_IMAGE).addListener(13, e -> this.deselectItems(IntStream.range(0, this.fSelectedItemsTable.getItemCount()).toArray()));
    }

    private void createButtonMoveBottom() {
        DualSelectionList.createButton(this, MOVE_BOTTOM_IMAGE).addListener(13, e -> this.moveBottom());
    }

    private static Table createTable(Composite parent) {
        Table table = new Table(parent, 66306);
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        GridData gridData = new GridData(4, 4, true, true, 1, 4);
        gridData.widthHint = 200;
        table.setLayoutData((Object)gridData);
        return table;
    }

    private static Button createButton(Composite parent, String fileName) {
        Button button = new Button(parent, 8);
        Image image = SWTGraphicUtil.createImageFromFile((String)("images/" + fileName));
        button.setImage(image);
        button.setLayoutData((Object)new GridData(2, 1, false, false));
        SWTGraphicUtil.addDisposer((Widget)button, (Resource)image);
        return button;
    }
}

