/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.uftrace.core.trace;

import java.io.File;
import java.io.IOException;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.MapEntry;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.Perms;

public class MapParser {
    private static final String SESSION_PATTERN_STRING = "sid\\-([a-fA-F0-9]+)\\.map";
    private static final Pattern SESSION_PATTERN = Pattern.compile("sid\\-([a-fA-F0-9]+)\\.map");
    private static final Pattern MAPFILE_PATTERN = Pattern.compile("^\\s*([a-fA-F0-9]+)\\-([a-fA-F0-9]+)\\s+([rxwps-]+)\\s+([a-fA-F0-9]+)\\s+([a-fA-F0-9]+)\\:([a-fA-F0-9]+)\\s+([a-fA-F0-9]+)\\s*(\\S+)?$");
    private final long fSessionId;
    private final NavigableMap<Long, MapEntry> fData;

    public static MapParser create(File file) throws IOException {
        String name = file.getName();
        Matcher sessionName = SESSION_PATTERN.matcher(name);
        if (!sessionName.matches()) {
            return null;
        }
        long sessionId = Long.parseUnsignedLong(sessionName.group(1), 16);
        LineIterator iter = FileUtils.lineIterator((File)file);
        TreeMap<Long, MapEntry> entries = new TreeMap<Long, MapEntry>();
        while (iter.hasNext()) {
            String line = iter.next();
            Matcher matcher = MAPFILE_PATTERN.matcher(line);
            matcher.matches();
            long addrLow = Long.parseUnsignedLong(matcher.group(1), 16);
            long addrHigh = Long.parseUnsignedLong(matcher.group(2), 16);
            Perms perms = Perms.create(matcher.group(3));
            long offset = Long.parseLong(matcher.group(4), 16);
            char deviceHigh = (char)Integer.parseInt(matcher.group(5), 16);
            char deviceLow = (char)Integer.parseInt(matcher.group(6), 16);
            long iNode = Long.parseLong(matcher.group(7), 16);
            String pathName = matcher.group(8);
            entries.put(addrLow, new MapEntry(addrLow, addrHigh, perms, offset, deviceLow, deviceHigh, iNode, pathName));
        }
        return new MapParser(sessionId, entries);
    }

    private MapParser(long sessionId, NavigableMap<Long, MapEntry> data) {
        this.fSessionId = sessionId;
        this.fData = data;
    }

    public NavigableMap<Long, MapEntry> getData() {
        return this.fData;
    }

    public long getSessionId() {
        return this.fSessionId;
    }
}

