/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.analysis.core.weighted.tree;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.ITree;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeSet;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.WeightedTree;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.DifferentialWeightedTree;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.DifferentialWeightedTreeProvider;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.DifferentialWeightedTreeSet;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public final class WeightedTreeUtils {
    private WeightedTreeUtils() {
    }

    public static <T> Collection<DifferentialWeightedTree<T>> diffTrees(Collection<WeightedTree<T>> first, Collection<WeightedTree<T>> second) {
        ArrayList<DifferentialWeightedTree<T>> diffTrees = new ArrayList<DifferentialWeightedTree<T>>();
        for (WeightedTree<T> base : second) {
            T object = base.getObject();
            WeightedTree<T> other = WeightedTreeUtils.findObject(first, object);
            double diffWeight = other == null ? Double.NaN : (double)(base.getWeight() - other.getWeight()) / (double)other.getWeight();
            DifferentialWeightedTree<@NonNull T> diffTree = new DifferentialWeightedTree<T>(base, object, base.getWeight(), diffWeight);
            diffTrees.add(diffTree);
            for (DifferentialWeightedTree<T> childTree : WeightedTreeUtils.diffTrees(other == null ? Collections.emptyList() : other.getChildren(), base.getChildren())) {
                diffTree.addChild(childTree);
            }
        }
        return diffTrees;
    }

    public static <N> @Nullable DifferentialWeightedTreeProvider<N> diffTreeSets(IWeightedTreeProvider<N, ?, WeightedTree<N>> provider, IWeightedTreeSet<N, @NonNull ?, WeightedTree<N>> first, IWeightedTreeSet<N, @NonNull ?, WeightedTree<N>> second) {
        Collection<Pair<@NonNull ?, @NonNull ?>> pairedElements = WeightedTreeUtils.pairElementsFromTrees(first, second);
        if (pairedElements.isEmpty()) {
            return null;
        }
        DifferentialWeightedTreeSet treeSet = new DifferentialWeightedTreeSet();
        for (Pair<?, ?> pair : pairedElements) {
            Collection trees1 = first.getTreesFor(pair.getFirst());
            Collection trees2 = second.getTreesFor(pair.getSecond());
            Collection diffTrees = WeightedTreeUtils.diffTrees(trees1, trees2);
            for (DifferentialWeightedTree tree : diffTrees) {
                treeSet.addWeightedTree(pair.getFirst(), tree);
            }
        }
        return new DifferentialWeightedTreeProvider<N>(provider, treeSet);
    }

    private static <N> Collection<Pair<@NonNull ?, @NonNull ?>> pairElementsFromTrees(IWeightedTreeSet<N, @NonNull ?, WeightedTree<N>> first, IWeightedTreeSet<N, @NonNull ?, WeightedTree<N>> second) {
        Collection<Pair<?, ?>> pairedElements;
        Collection<@NonNull ?> elements1 = first.getElements();
        Collection<@NonNull ?> elements2 = second.getElements();
        if (elements1.size() == 1 && elements2.size() == 1) {
            @NonNull ? element1 = elements1.iterator().next();
            @NonNull ? element2 = elements2.iterator().next();
            if (!(element1 instanceof ITree) && !(element2 instanceof ITree)) {
                return ImmutableList.of((Object)new Pair(element1, element2));
            }
        }
        if (!(pairedElements = WeightedTreeUtils.pairEqualElements(elements1, elements2)).isEmpty()) {
            return pairedElements;
        }
        pairedElements = WeightedTreeUtils.pairSameNameElements(elements1, elements2);
        return pairedElements;
    }

    private static Collection<Pair<@NonNull ?, @NonNull ?>> pairEqualElements(Collection<@NonNull ?> elements1, Collection<@NonNull ?> elements2) {
        ArrayList<Pair<@NonNull ?, @NonNull ?>> pairedElements = new ArrayList();
        block0: for (Object element1 : elements1) {
            for (Object element2 : elements2) {
                if (!element1.equals(element2)) continue;
                pairedElements.add(new Pair(element1, element1));
                if (!(element1 instanceof ITree) || !(element2 instanceof ITree)) continue block0;
                pairedElements.addAll(WeightedTreeUtils.pairEqualElements(((ITree)element1).getChildren(), ((ITree)element2).getChildren()));
                continue block0;
            }
        }
        return pairedElements;
    }

    private static Collection<Pair<@NonNull ?, @NonNull ?>> pairSameNameElements(Collection<@NonNull ?> elements1, Collection<?> elements2) {
        ArrayList<Pair<@NonNull ?, @NonNull ?>> pairedElements = new ArrayList();
        block0: for (Object element1 : elements1) {
            if (!(element1 instanceof ITree)) continue;
            for (Object element2 : elements2) {
                if (!(element2 instanceof ITree) || !((ITree)element1).getName().equals(((ITree)element2).getName())) continue;
                pairedElements.add(new Pair(element1, element2));
                pairedElements.addAll(WeightedTreeUtils.pairSameNameElements(((ITree)element1).getChildren(), ((ITree)element2).getChildren()));
                continue block0;
            }
        }
        return pairedElements;
    }

    private static <T> @Nullable WeightedTree<T> findObject(Collection<WeightedTree<T>> tree, @NonNull T object) {
        for (WeightedTree<T> other : tree) {
            if (!other.getObject().equals(object)) continue;
            return other;
        }
        return null;
    }
}

