/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    public static final String ICON_SET_RANGE = "ICON_SET_RANGE";
    public static final String ICON_HIDE = "ICON_HIDE";
    public static final String ICON_RESET = "ICON_RESET";
    private static Activator plugin;
    private Bundle bundle;
    private ImageRegistry imageRegistry;

    public void start(BundleContext context) throws Exception {
        plugin = this;
        this.bundle = context.getBundle();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
    }

    public Image getImage(String key) {
        if (this.imageRegistry == null) {
            this.initializeImageRegistry();
        }
        return this.imageRegistry.get(key);
    }

    public final Bundle getBundle() {
        return this.bundle;
    }

    public static Activator getDefault() {
        return plugin;
    }

    private void initializeImageRegistry() {
        if (Display.getCurrent() == null) {
            throw new SWTException(22);
        }
        this.imageRegistry = new ImageRegistry();
        HashMap<String, String> imageHashMap = new HashMap<String, String>();
        imageHashMap.put(ICON_SET_RANGE, "icons/16x16/set_range.gif");
        imageHashMap.put(ICON_HIDE, "icons/16x16/hide.gif");
        imageHashMap.put(ICON_RESET, "icons/16x16/reset.gif");
        for (Map.Entry entry : imageHashMap.entrySet()) {
            this.imageRegistry.put((String)entry.getKey(), this.createImageDescriptor(this.getBundle(), (String)entry.getValue()));
        }
    }

    private ImageDescriptor createImageDescriptor(Bundle bundle, String string) {
        ImageDescriptor imageDescriptor = null;
        Path path = new Path(string);
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        imageDescriptor = ImageDescriptor.createFromURL((URL)url);
        return imageDescriptor;
    }
}

