/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.messageflow;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.messageflow.RosMessageFlowSegmentEntryModel;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messageflow.IRosMessageFlowModel;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messageflow.RosMessageFlowSegment;
import org.eclipse.tracecompass.internal.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class RosMessageFlowDataProvider
extends AbstractTmfTraceDataProvider
implements ITimeGraphDataProvider<TimeGraphEntryModel> {
    public static final @NonNull String SUFFIX = ".dataprovider";
    public static final @NonNull String SEGMENT_NAME_SEP = ";";
    private static final AtomicLong ATOMIC_LONG = new AtomicLong();
    private @NonNull IRosMessageFlowModel fModel;
    private final BiMap<RosMessageFlowSegment, Long> fSegmentToId = HashBiMap.create();

    public RosMessageFlowDataProvider(@NonNull ITmfTrace trace, @NonNull IRosMessageFlowModel model) {
        super(trace);
        this.fModel = model;
    }

    private long getSegmentId(RosMessageFlowSegment segment) {
        return (Long)this.fSegmentToId.computeIfAbsent((Object)segment, i -> ATOMIC_LONG.getAndIncrement());
    }

    public @NonNull TmfModelResponse<@NonNull TmfTreeModel<@NonNull TimeGraphEntryModel>> fetchTree(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(fetchParameters);
        if (filter == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        if (!this.fModel.isModelDone()) {
            return new TmfModelResponse(null, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
        }
        ArrayList<@NonNull TimeGraphEntryModel> entries = new ArrayList<TimeGraphEntryModel>();
        long rootId = ATOMIC_LONG.getAndIncrement();
        entries.add(new TimeGraphEntryModel(rootId, -1L, String.valueOf(this.getTrace().getName()), filter.getStart(), filter.getEnd()));
        RosMessageFlowSegment firstSegment = this.fModel.getFirstSegment();
        this.addTreeChildren(entries, firstSegment, rootId);
        return new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), entries), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private void addTreeChildren(List<@NonNull TimeGraphEntryModel> entries, RosMessageFlowSegment segment, long parentId) {
        long entryId = this.getSegmentId(segment);
        entries.add(new RosMessageFlowSegmentEntryModel(entryId, parentId, segment.getStartTime(), segment.getEndTime(), segment));
        Collection<RosMessageFlowSegment> next = segment.getNext();
        for (RosMessageFlowSegment n : next) {
            this.addTreeChildren(entries, n, parentId);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull TmfModelResponse<@NonNull TimeGraphModel> fetchRowModel(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        if (filter == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        if (!this.fModel.isModelDone()) {
            return new TmfModelResponse(null, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
        }
        @NonNull HashMap<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> predicates = new HashMap<Integer, Predicate<Multimap<String, Object>>>();
        @NonNull @NonNull Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(fetchParameters);
        if (regexesMap != null) {
            predicates.putAll(this.computeRegexPredicate(regexesMap));
        }
        ArrayList<@NonNull ITimeGraphRowModel> rows = new ArrayList<ITimeGraphRowModel>();
        RosMessageFlowSegment firstSegment = this.fModel.getFirstSegment();
        this.addRowModels(rows, firstSegment, predicates, monitor);
        return new TmfModelResponse((Object)new TimeGraphModel(rows), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private void addRowModels(List<@NonNull ITimeGraphRowModel> rows, RosMessageFlowSegment segment, @NonNull Map<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> predicates, @Nullable IProgressMonitor monitor) {
        @NonNull ArrayList<@NonNull E> eventList = new ArrayList();
        long entryId = this.getSegmentId(segment);
        long startTime = segment.getStartTime();
        long duration = segment.getEndTime() - startTime + 1L;
        TimeGraphState state = new TimeGraphState(startTime, duration, RosMessageFlowDataProvider.getMatchingSegmentState(segment.getType()));
        this.applyFilterAndAddState(eventList, (ITimeGraphState)state, entryId, predicates, monitor);
        rows.add((ITimeGraphRowModel)new TimeGraphRowModel(entryId, eventList));
        Collection<RosMessageFlowSegment> next = segment.getNext();
        for (RosMessageFlowSegment n : next) {
            this.addRowModels(rows, n, predicates, monitor);
        }
    }

    private static int getMatchingSegmentState(RosMessageFlowSegment.SegmentType type) {
        switch (type) {
            case PUB_QUEUE: {
                return 0;
            }
            case SUB_QUEUE: {
                return 1;
            }
            case SUB_CALLBACK: {
                return 2;
            }
            case INVALID: {
                break;
            }
        }
        return 4;
    }

    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(fetchParameters);
        if (filter == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        if (!this.fModel.isModelDone()) {
            return new TmfModelResponse(null, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
        }
        return new TmfModelResponse(this.getArrows(filter.getStart(), filter.getEnd()), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable List<@NonNull ITimeGraphArrow> getArrows(long startTime, long endTime) {
        @NonNull ArrayList arrows = Lists.newArrayList();
        RosMessageFlowSegment firstSegment = this.fModel.getFirstSegment();
        this.addArrows(firstSegment, arrows, startTime, endTime);
        return arrows;
    }

    private void addArrows(RosMessageFlowSegment parent, List<@NonNull ITimeGraphArrow> arrows, long startTime, long endTime) {
        Collection<RosMessageFlowSegment> next = parent.getNext();
        for (RosMessageFlowSegment n : next) {
            if (parent.getEndTime() <= endTime && n.getStartTime() >= startTime) {
                this.addArrow(parent, n, arrows);
            }
            this.addArrows(n, arrows, startTime, endTime);
        }
    }

    private void addArrow(RosMessageFlowSegment parent, RosMessageFlowSegment child, List<@NonNull ITimeGraphArrow> arrows) {
        long sourceId = this.getSegmentId(parent);
        long destinationId = this.getSegmentId(child);
        long time = parent.getEndTime();
        long duration = child.getStartTime() - parent.getEndTime();
        arrows.add((ITimeGraphArrow)new TimeGraphArrow(sourceId, destinationId, time, duration, RosMessageFlowDataProvider.getMatchingArrowState(parent.getType(), child.getType())));
    }

    private static int getMatchingArrowState(RosMessageFlowSegment.SegmentType source, RosMessageFlowSegment.SegmentType destination) {
        if (source.equals((Object)RosMessageFlowSegment.SegmentType.PUB_QUEUE) && destination.equals((Object)RosMessageFlowSegment.SegmentType.SUB_QUEUE)) {
            return 4;
        }
        if (source.equals((Object)RosMessageFlowSegment.SegmentType.SUB_QUEUE) && destination.equals((Object)RosMessageFlowSegment.SegmentType.SUB_CALLBACK)) {
            return 5;
        }
        if (destination.equals((Object)RosMessageFlowSegment.SegmentType.PUB_QUEUE)) {
            return 6;
        }
        return 7;
    }

    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public @NonNull String getId() {
        return RosMessageFlowDataProvider.getFullDataProviderId();
    }

    public static @NonNull String getFullDataProviderId() {
        return "org.eclipse.tracecompass.incubator.ros.core.analysis.messageflow.dataprovider";
    }
}

