/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.dialogs.offset;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tracecompass.internal.tmf.ui.project.dialogs.offset.Messages;
import org.eclipse.tracecompass.tmf.core.signal.TmfEventSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.viewers.ArrayTreeContentProvider;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class OffsetDialog
extends Dialog {
    private static final int TREE_EDITOR_MIN_WIDTH = 50;
    private static final String EDITOR_KEY = "$editor$";
    private static final String WIDTH_KEY = "$width$";
    private static final TmfTimestampFormat TIME_FORMAT = new TmfTimestampFormat("yyyy-MM-dd HH:mm:ss.SSS SSS SSS");
    private static final TmfTimestampFormat OFFSET_FORMAT = new TmfTimestampFormat("T.SSS SSS SSS");
    private final Map<TmfTraceElement, Long> fOffsetMap;
    private final Map<TmfTraceElement, ITmfTimestamp> fRefTimeMap;
    private final Map<TmfTraceElement, ITmfTimestamp> fTargetTimeMap;
    private Label fBasicMessageLabel;
    private Group fButtonGroup;
    private Label fAdvancedMessageLabel;
    private FilteredTree fViewer;
    private boolean fAdvancedMode = true;
    private TreeViewerColumn fButtonViewerColumn;
    private TreeColumn fRefTimeColumn;
    private TreeColumn fTargetTimeColumn;

    public OffsetDialog(Shell parent, Map<TmfTraceElement, Long> results) {
        super(parent);
        this.setShellStyle(this.getShellStyle() & 0xFFFEFFFF);
        this.fOffsetMap = results;
        this.fRefTimeMap = new HashMap<TmfTraceElement, ITmfTimestamp>();
        this.fTargetTimeMap = new HashMap<TmfTraceElement, ITmfTimestamp>();
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.OffsetDialog_Title);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(area, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)new GridLayout());
        this.createBasicMessage(composite);
        this.createButtonGroup(composite);
        this.createAdvancedMessage(composite);
        this.createViewer(composite);
        int widthHint = this.fViewer.getViewer().getTree().computeSize((int)-1, (int)-1).x;
        GridData gd = (GridData)this.fBasicMessageLabel.getLayoutData();
        gd.widthHint = widthHint;
        gd = (GridData)this.fAdvancedMessageLabel.getLayoutData();
        gd.widthHint = widthHint;
        gd = (GridData)composite.getLayoutData();
        gd.heightHint = composite.computeSize((int)widthHint, (int)-1).y;
        this.setBasicMode();
        TmfSignalManager.register((Object)((Object)this));
        composite.addDisposeListener(e -> TmfSignalManager.deregister((Object)((Object)this)));
        return area;
    }

    private void createBasicMessage(Composite parent) {
        this.fBasicMessageLabel = new Label(parent, 64);
        this.fBasicMessageLabel.setText(Messages.OffsetDialog_BasicMessage);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 0;
        gd.heightHint = -1;
        this.fBasicMessageLabel.setLayoutData((Object)gd);
    }

    private void createButtonGroup(final Composite parent) {
        this.fButtonGroup = new Group(parent, 32);
        this.fButtonGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fButtonGroup.setLayout((Layout)new RowLayout(256));
        final Button basicButton = new Button((Composite)this.fButtonGroup, 16);
        basicButton.setText(Messages.OffsetDialog_BasicButton);
        basicButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!basicButton.getSelection() || !OffsetDialog.this.fAdvancedMode) {
                    return;
                }
                OffsetDialog.this.setBasicMode();
                parent.layout();
            }
        });
        basicButton.setSelection(true);
        final Button advancedButton = new Button((Composite)this.fButtonGroup, 16);
        advancedButton.setText(Messages.OffsetDialog_AdvancedButton);
        advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!advancedButton.getSelection() || OffsetDialog.this.fAdvancedMode) {
                    return;
                }
                OffsetDialog.this.setAdvancedMode();
                parent.layout();
            }
        });
    }

    private void createAdvancedMessage(Composite parent) {
        this.fAdvancedMessageLabel = new Label(parent, 64);
        this.fAdvancedMessageLabel.setText(Messages.OffsetDialog_AdvancedMessage);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 0;
        gd.heightHint = -1;
        this.fAdvancedMessageLabel.setLayoutData((Object)gd);
    }

    private void createViewer(Composite parent) {
        this.fViewer = new FilteredTree(parent, 68354, new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                return this.wordMatches(((TmfTraceElement)element).getElementPath());
            }
        }, true);
        TreeViewer treeViewer = this.fViewer.getViewer();
        treeViewer.setUseHashlookup(true);
        Tree tree = treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeViewerFocusCellManager focusCellManager = new TreeViewerFocusCellManager(this.fViewer.getViewer(), (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.fViewer.getViewer()));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.fViewer.getViewer());
        TreeViewerEditor.create((TreeViewer)this.fViewer.getViewer(), (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        TextCellEditor textCellEditor = new TextCellEditor((Composite)this.fViewer.getViewer().getTree(), 131072);
        this.fViewer.getViewer().setColumnProperties(new String[]{Messages.OffsetDialog_TraceName, Messages.OffsetDialog_ReferenceTime, Messages.OffsetDialog_OffsetTime});
        TreeViewerColumn column = this.createTreeViewerColumn(Messages.OffsetDialog_TraceName, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TmfTraceElement)element).getElementPath();
            }
        });
        column = this.createTreeViewerColumn(Messages.OffsetDialog_OffsetTime, 131072);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Long offset = (Long)OffsetDialog.this.fOffsetMap.get(element);
                if (offset == null || offset == 0L) {
                    return "";
                }
                return super.getText((Object)OFFSET_FORMAT.format(offset.longValue()));
            }
        });
        column.setEditingSupport((EditingSupport)new OffsetEditingSupport((ColumnViewer)this.fViewer.getViewer(), textCellEditor));
        column = this.createTreeViewerColumn("", 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }
        });
        column.getColumn().setWidth(50);
        column.getColumn().setResizable(false);
        this.fButtonViewerColumn = column;
        column = this.createTreeViewerColumn(Messages.OffsetDialog_ReferenceTime, 131072);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return super.getText(OffsetDialog.this.fRefTimeMap.get(element));
            }
        });
        column.setEditingSupport((EditingSupport)new RefTimeEditingSupport((ColumnViewer)this.fViewer.getViewer(), textCellEditor));
        this.fRefTimeColumn = column.getColumn();
        column = this.createTreeViewerColumn(Messages.OffsetDialog_TargetTime, 131072);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return super.getText(OffsetDialog.this.fTargetTimeMap.get(element));
            }
        });
        column.setEditingSupport((EditingSupport)new TargetTimeEditingSupport((ColumnViewer)this.fViewer.getViewer(), textCellEditor));
        this.fTargetTimeColumn = column.getColumn();
        ArrayList<TmfTraceElement> traces = new ArrayList<TmfTraceElement>(this.fOffsetMap.keySet());
        Collections.sort(traces, (o1, o2) -> {
            IPath folder2;
            IPath folder1 = new Path(o1.getElementPath()).removeLastSegments(1);
            if (folder1.equals((Object)(folder2 = new Path(o2.getElementPath()).removeLastSegments(1)))) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
            if (folder1.isPrefixOf(folder2)) {
                return 1;
            }
            if (folder2.isPrefixOf(folder1)) {
                return -1;
            }
            return folder1.toString().compareToIgnoreCase(folder2.toString());
        });
        this.fViewer.getViewer().setContentProvider((IContentProvider)new ArrayTreeContentProvider());
        this.fViewer.getViewer().setInput(traces);
        Object object = tree.getItems();
        int n = ((TreeItem[])object).length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = object[n2];
            TreeEditor treeEditor = new TreeEditor(tree);
            Button applyButton = new Button((Composite)tree, 8);
            applyButton.setText("<<");
            applyButton.setData(treeItem.getData());
            applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TmfTraceElement traceElement = (TmfTraceElement)e.widget.getData();
                    ITmfTimestamp targetTime = (ITmfTimestamp)OffsetDialog.this.fTargetTimeMap.get(traceElement);
                    ITmfTimestamp refTime = (ITmfTimestamp)OffsetDialog.this.fRefTimeMap.get(traceElement);
                    if (targetTime != null && refTime != null) {
                        long offset = targetTime.toNanos() - refTime.toNanos();
                        OffsetDialog.this.fOffsetMap.put(traceElement, offset);
                        OffsetDialog.this.fViewer.getViewer().update((Object)traceElement, null);
                    }
                }
            });
            treeEditor.grabHorizontal = true;
            treeEditor.minimumWidth = 50;
            treeEditor.setEditor((Control)applyButton, treeItem, 2);
            treeItem.setData(EDITOR_KEY, (Object)applyButton);
            ++n2;
        }
        this.fRefTimeMap.put((TmfTraceElement)traces.get(0), TmfTimestamp.fromNanos((long)0L));
        this.fTargetTimeMap.put((TmfTraceElement)traces.get(0), TmfTimestamp.fromNanos((long)0L));
        this.fViewer.getViewer().update(traces.get(0), null);
        object = tree.getColumns();
        n = ((TreeColumn[])object).length;
        n2 = 0;
        while (n2 < n) {
            TreeItem treeColumn = object[n2];
            if (treeColumn.getResizable()) {
                treeColumn.pack();
            }
            ++n2;
        }
        this.fRefTimeMap.clear();
        this.fTargetTimeMap.clear();
        this.fViewer.getViewer().update(traces.get(0), null);
        block2: for (TmfTraceElement traceElement : this.fOffsetMap.keySet()) {
            for (ITmfTrace parentTrace : TmfTraceManager.getInstance().getOpenedTraces()) {
                for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)parentTrace)) {
                    if (!traceElement.getResource().equals((Object)trace.getResource())) continue;
                    this.fRefTimeMap.put(traceElement, trace.getStartTime());
                    this.fViewer.getViewer().update((Object)traceElement, null);
                    break;
                }
                if (this.fRefTimeMap.get(traceElement) != null) continue block2;
            }
        }
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TmfTraceElement traceElement = (TmfTraceElement)e.item.getData();
                TmfOpenTraceHelper.openFromElement(traceElement);
            }
        });
        tree.setFocus();
    }

    private TreeViewerColumn createTreeViewerColumn(String title, int style) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.fViewer.getViewer(), style);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(true);
        return viewerColumn;
    }

    private void setBasicMode() {
        this.fAdvancedMode = false;
        this.fRefTimeColumn.setData(WIDTH_KEY, (Object)this.fRefTimeColumn.getWidth());
        this.fTargetTimeColumn.setData(WIDTH_KEY, (Object)this.fTargetTimeColumn.getWidth());
        TreeItem[] treeItemArray = this.fViewer.getViewer().getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            Control editor = (Control)treeItem.getData(EDITOR_KEY);
            editor.setVisible(false);
            ++n2;
        }
        this.fTargetTimeColumn.setWidth(0);
        this.fTargetTimeColumn.setResizable(false);
        this.fRefTimeColumn.setWidth(0);
        this.fRefTimeColumn.setResizable(false);
        this.fButtonViewerColumn.getColumn().setWidth(0);
        this.fAdvancedMessageLabel.setText("");
    }

    private void setAdvancedMode() {
        this.fAdvancedMode = true;
        this.fButtonViewerColumn.getColumn().setWidth(50);
        this.fRefTimeColumn.setWidth(((Integer)this.fRefTimeColumn.getData(WIDTH_KEY)).intValue());
        this.fRefTimeColumn.setResizable(true);
        this.fTargetTimeColumn.setWidth(((Integer)this.fTargetTimeColumn.getData(WIDTH_KEY)).intValue());
        this.fTargetTimeColumn.setResizable(true);
        TreeItem[] treeItemArray = this.fViewer.getViewer().getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            Control editor = (Control)treeItem.getData(EDITOR_KEY);
            editor.setVisible(true);
            ++n2;
        }
        this.fAdvancedMessageLabel.setText(Messages.OffsetDialog_AdvancedMessage);
    }

    @TmfSignalHandler
    public void eventSelected(TmfEventSelectedSignal signal) {
        Display.getDefault().asyncExec(() -> {
            for (TmfTraceElement traceElement : this.fOffsetMap.keySet()) {
                if (!traceElement.getResource().equals((Object)signal.getEvent().getTrace().getResource())) continue;
                this.fRefTimeMap.put(traceElement, signal.getEvent().getTimestamp());
                this.fViewer.getViewer().update((Object)traceElement, null);
                break;
            }
        });
    }

    @TmfSignalHandler
    public void timeSelected(TmfSelectionRangeUpdatedSignal signal) {
        Display.getDefault().asyncExec(() -> {
            for (TmfTraceElement traceElement : this.fOffsetMap.keySet()) {
                this.fTargetTimeMap.put(traceElement, signal.getBeginTime());
                this.fViewer.getViewer().update((Object)traceElement, null);
            }
        });
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        Display.getDefault().asyncExec(() -> {
            block0: for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)signal.getTrace())) {
                for (TmfTraceElement traceElement : this.fOffsetMap.keySet()) {
                    if (!traceElement.getResource().equals((Object)trace.getResource())) continue;
                    if (this.fRefTimeMap.get(traceElement) != null) continue block0;
                    this.fRefTimeMap.put(traceElement, trace.getStartTime());
                    this.fViewer.getViewer().update((Object)traceElement, null);
                    continue block0;
                }
            }
        });
    }

    private abstract class ColumnEditingSupport
    extends EditingSupport {
        private final TextCellEditor textCellEditor;

        private ColumnEditingSupport(ColumnViewer viewer, TextCellEditor textCellEditor) {
            super(viewer);
            this.textCellEditor = textCellEditor;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.textCellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }
    }

    private class OffsetEditingSupport
    extends ColumnEditingSupport {
        private OffsetEditingSupport(ColumnViewer viewer, TextCellEditor textCellEditor) {
            super(viewer, textCellEditor);
        }

        protected void setValue(Object element, Object value) {
            if (value instanceof String) {
                String string = (String)value;
                if (string.trim().isEmpty()) {
                    OffsetDialog.this.fOffsetMap.put((TmfTraceElement)element, 0L);
                } else {
                    try {
                        Long newVal = OFFSET_FORMAT.parseValue(string);
                        OffsetDialog.this.fOffsetMap.put((TmfTraceElement)element, newVal);
                    }
                    catch (ParseException parseException) {}
                }
                OffsetDialog.this.fViewer.getViewer().update(element, null);
            }
        }

        protected Object getValue(Object element) {
            Long offset = (Long)OffsetDialog.this.fOffsetMap.get(element);
            if (offset == null || offset == 0L) {
                return "";
            }
            return OFFSET_FORMAT.format(offset.longValue());
        }
    }

    private class RefTimeEditingSupport
    extends TimeEditingSupport {
        private RefTimeEditingSupport(ColumnViewer viewer, TextCellEditor textCellEditor) {
            super(viewer, textCellEditor, OffsetDialog.this.fRefTimeMap);
        }
    }

    private class TargetTimeEditingSupport
    extends TimeEditingSupport {
        private TargetTimeEditingSupport(ColumnViewer viewer, TextCellEditor textCellEditor) {
            super(viewer, textCellEditor, OffsetDialog.this.fTargetTimeMap);
        }
    }

    private class TimeEditingSupport
    extends ColumnEditingSupport {
        private Map<TmfTraceElement, ITmfTimestamp> map;

        private TimeEditingSupport(ColumnViewer viewer, TextCellEditor textCellEditor, Map<TmfTraceElement, ITmfTimestamp> map) {
            super(viewer, textCellEditor);
            this.map = map;
        }

        protected void setValue(Object element, Object value) {
            if (value instanceof String) {
                String string = (String)value;
                if (string.trim().isEmpty()) {
                    this.map.remove(element);
                } else {
                    try {
                        ITmfTimestamp refTime = this.map.get(element);
                        long ref = refTime == null ? 0L : refTime.toNanos();
                        Long newVal = TIME_FORMAT.parseValue(string, ref);
                        this.map.put((TmfTraceElement)element, TmfTimestamp.fromNanos((long)newVal));
                    }
                    catch (ParseException parseException) {}
                }
                OffsetDialog.this.fViewer.getViewer().update(element, null);
            }
        }

        protected Object getValue(Object element) {
            ITmfTimestamp ts = this.map.get(element);
            if (ts == null) {
                return "";
            }
            return TIME_FORMAT.format(ts.toNanos());
        }
    }
}

