/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.preferences;

import java.io.File;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarRegistryManager;
import org.eclipse.tm4e.registry.TMEclipseRegistryPlugin;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.TMUIMessages;
import org.eclipse.tm4e.ui.internal.utils.UI;
import org.eclipse.tm4e.ui.internal.widgets.ColumnSelectionAdapter;
import org.eclipse.tm4e.ui.internal.widgets.ColumnViewerComparator;
import org.eclipse.tm4e.ui.internal.widgets.GrammarDefinitionContentProvider;
import org.eclipse.tm4e.ui.internal.widgets.GrammarDefinitionLabelProvider;
import org.eclipse.tm4e.ui.internal.widgets.TMViewer;
import org.eclipse.tm4e.ui.internal.widgets.ThemeContentProvider;
import org.eclipse.tm4e.ui.internal.widgets.ThemeLabelProvider;
import org.eclipse.tm4e.ui.snippets.ISnippet;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.IThemeManager;
import org.eclipse.tm4e.ui.themes.Theme;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public final class ThemePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String PAGE_ID = "org.eclipse.tm4e.ui.preferences.ThemePreferencePage";
    private TableViewer themesTable = (TableViewer)NullSafetyHelper.lazyNonNull();
    private Button themeRemoveButton = (Button)NullSafetyHelper.lazyNonNull();
    private ComboViewer grammarsCombo = (ComboViewer)NullSafetyHelper.lazyNonNull();
    private TMViewer previewViewer = (TMViewer)((Object)NullSafetyHelper.lazyNonNull());
    private final IGrammarRegistryManager grammarRegistryManager = TMEclipseRegistryPlugin.getGrammarRegistryManager();
    private final IThemeManager themeManager = TMUIPlugin.getThemeManager();
    private Button darkThemeButton = (Button)NullSafetyHelper.lazyNonNull();
    private Button defaultThemeButton = (Button)NullSafetyHelper.lazyNonNull();
    private @Nullable ITheme selectedTheme;

    public ThemePreferencePage() {
        this.setDescription(TMUIMessages.ThemePreferencePage_description);
    }

    protected Control createContents(@Nullable Composite ancestor) {
        SashForm parent = new SashForm(ancestor, 66048);
        parent.setBackground(parent.getDisplay().getSystemColor(15));
        parent.setLayout((Layout)new FillLayout());
        Composite innerParent = new Composite((Composite)parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerParent.setLayout((Layout)innerLayout);
        this.createThemesTableContent(innerParent);
        this.createThemeDetailContent(innerParent);
        this.createThemePreviewContent((Composite)parent);
        parent.setSashWidth(3);
        parent.setWeights(new int[]{2, 1});
        this.themesTable.setInput((Object)this.themeManager);
        UI.selectFirstElement(this.themesTable);
        Dialog.applyDialogFont((Control)parent);
        innerParent.layout();
        return parent;
    }

    private void createThemesTableContent(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        GridData data = new GridData(1808);
        data.widthHint = 360;
        data.heightHint = this.convertHeightInCharsToPixels(10);
        tableComposite.setLayoutData((Object)data);
        TableColumnLayout columnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)columnLayout);
        Table table = new Table(tableComposite, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GC gc = new GC((Drawable)this.getShell());
        gc.setFont(JFaceResources.getDialogFont());
        ColumnViewerComparator viewerComparator = new ColumnViewerComparator();
        this.themesTable = new TableViewer(table);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(TMUIMessages.ThemePreferencePage_column_name);
        int minWidth = this.computeMinimumColumnWidth(gc, TMUIMessages.ThemePreferencePage_column_name);
        columnLayout.setColumnData((Widget)column1, (ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        column1.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.themesTable, viewerComparator, new int[0]));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(TMUIMessages.ThemePreferencePage_column_path);
        minWidth = this.computeMinimumColumnWidth(gc, TMUIMessages.ThemePreferencePage_column_path);
        columnLayout.setColumnData((Widget)column2, (ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        column2.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.themesTable, viewerComparator, 0));
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(TMUIMessages.ThemePreferencePage_column_pluginId);
        minWidth = this.computeMinimumColumnWidth(gc, TMUIMessages.ThemePreferencePage_column_pluginId);
        columnLayout.setColumnData((Widget)column3, (ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        column3.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(this.themesTable, viewerComparator, 0));
        gc.dispose();
        this.themesTable.setLabelProvider((IBaseLabelProvider)new ThemeLabelProvider());
        this.themesTable.setContentProvider((IContentProvider)new ThemeContentProvider());
        this.themesTable.setComparator((ViewerComparator)viewerComparator);
        this.themesTable.addSelectionChangedListener(e -> {
            this.selectedTheme = (ITheme)((IStructuredSelection)this.themesTable.getSelection()).getFirstElement();
            ITheme selectedTheme = this.selectedTheme;
            if (selectedTheme != null) {
                this.darkThemeButton.setSelection(selectedTheme.isDark());
                this.defaultThemeButton.setSelection(selectedTheme.isDefault());
                this.themeRemoveButton.setEnabled(selectedTheme.getPluginId() == null);
            }
            this.preview();
        });
        table.setSortColumn(column1);
        table.setSortDirection(viewerComparator.getDirection());
        BidiUtils.applyTextDirection((Control)this.themesTable.getControl(), (String)"default");
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        Button themeNewButton = new Button(buttons, 8);
        themeNewButton.setText(TMUIMessages.Button_new);
        themeNewButton.setLayoutData((Object)ThemePreferencePage.getButtonGridData(themeNewButton));
        themeNewButton.addListener(13, new Listener(){

            public void handleEvent(@Nullable Event e) {
                ITheme newTheme = this.addTheme();
                if (newTheme != null) {
                    ThemePreferencePage.this.themeManager.registerTheme(newTheme);
                    ThemePreferencePage.this.selectedTheme = newTheme;
                    ThemePreferencePage.this.themesTable.refresh();
                    ThemePreferencePage.this.themesTable.setSelection((ISelection)new StructuredSelection((Object)newTheme));
                }
            }

            private @Nullable ITheme addTheme() {
                FileDialog dialog = new FileDialog(ThemePreferencePage.this.getShell());
                dialog.setText("Select textmate theme file");
                dialog.setFilterExtensions(new String[]{"*.css"});
                String res = dialog.open();
                if (res == null) {
                    return null;
                }
                File file = new File(res);
                String name = file.getName().substring(0, file.getName().length() - ".css".length());
                return new Theme(name, file.getAbsolutePath(), name, false, false);
            }
        });
        this.themeRemoveButton = new Button(buttons, 8);
        this.themeRemoveButton.setText(TMUIMessages.Button_remove);
        this.themeRemoveButton.setLayoutData((Object)ThemePreferencePage.getButtonGridData(this.themeRemoveButton));
        this.themeRemoveButton.addListener(13, e -> {
            if (this.selectedTheme != null) {
                this.themeManager.unregisterTheme(this.selectedTheme);
            }
            this.themesTable.refresh();
        });
    }

    private void createThemeDetailContent(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        parent.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        parent.setLayout((Layout)layout);
        this.darkThemeButton = new Button(parent, 32);
        this.darkThemeButton.setText(TMUIMessages.ThemePreferencePage_darkThemeButton_label);
        this.darkThemeButton.setEnabled(false);
        this.defaultThemeButton = new Button(parent, 32);
        this.defaultThemeButton.setText(TMUIMessages.ThemePreferencePage_defaultThemeButton_label);
        this.defaultThemeButton.setEnabled(false);
    }

    private void createThemePreviewContent(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 2;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Label label = new Label(parent, 0);
        label.setText(TMUIMessages.ThemePreferencePage_preview);
        GridData data = new GridData();
        label.setLayoutData((Object)data);
        this.grammarsCombo = new ComboViewer(parent);
        this.grammarsCombo.setContentProvider((IContentProvider)new GrammarDefinitionContentProvider());
        this.grammarsCombo.setLabelProvider((IBaseLabelProvider)new GrammarDefinitionLabelProvider());
        this.grammarsCombo.setComparator(new ViewerComparator());
        this.grammarsCombo.addSelectionChangedListener(e -> this.preview());
        this.grammarsCombo.getControl().setLayoutData((Object)new GridData(768));
        this.grammarsCombo.setInput((Object)this.grammarRegistryManager);
        if (this.grammarsCombo.getCombo().getItemCount() > 0) {
            this.grammarsCombo.getCombo().select(0);
        }
        this.previewViewer = new TMViewer(parent, null, null, false, 2816);
        Control control = this.previewViewer.getControl();
        data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
    }

    private int computeMinimumColumnWidth(GC gc, String string) {
        return gc.stringExtent((String)string).x + 10;
    }

    private static GridData getButtonGridData(Button button) {
        GridData data = new GridData(768);
        return data;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setTitle(TMUIMessages.ThemePreferencePage_title);
        }
    }

    public void init(@Nullable IWorkbench workbench) {
    }

    private void preview() {
        IStructuredSelection selection = (IStructuredSelection)this.themesTable.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        ITheme theme = (ITheme)selection.getFirstElement();
        selection = (IStructuredSelection)this.grammarsCombo.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        IGrammarDefinition definition = (IGrammarDefinition)selection.getFirstElement();
        IGrammar grammar = this.grammarRegistryManager.getGrammarForScope(definition.getScope());
        this.previewViewer.setTheme(theme);
        this.previewViewer.setGrammar(grammar);
        ISnippet[] snippets = TMUIPlugin.getSnippetManager().getSnippets(definition.getScope().getName());
        if (snippets.length == 0) {
            this.previewViewer.setText("");
        } else {
            this.previewViewer.setText(snippets[0].getContent());
        }
    }

    public boolean performOk() {
        try {
            this.themeManager.save();
            this.grammarRegistryManager.save();
            return true;
        }
        catch (BackingStoreException ex) {
            TMUIPlugin.logError((Exception)((Object)ex));
            return false;
        }
    }
}

