/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarRegistryManager;
import org.eclipse.tm4e.registry.ITMScope;
import org.eclipse.tm4e.registry.internal.AbstractGrammarRegistryManager;
import org.osgi.service.prefs.BackingStoreException;

public class WorkingCopyGrammarRegistryManager
extends AbstractGrammarRegistryManager {
    private final IGrammarRegistryManager manager;
    private final List<IGrammarDefinition> added = new ArrayList<IGrammarDefinition>();
    private final List<IGrammarDefinition> removed = new ArrayList<IGrammarDefinition>();

    public WorkingCopyGrammarRegistryManager(IGrammarRegistryManager manager) {
        this.manager = manager;
        IGrammarDefinition[] iGrammarDefinitionArray = manager.getDefinitions();
        int n = iGrammarDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGrammarDefinition definition = iGrammarDefinitionArray[n2];
            super.registerGrammarDefinition(definition);
            ++n2;
        }
    }

    @Override
    public @Nullable Collection<IContentType> getContentTypesForScope(ITMScope scope) {
        return this.manager.getContentTypesForScope(scope);
    }

    @Override
    public @Nullable Collection<String> getInjections(String scopeName) {
        return this.manager.getInjections(scopeName);
    }

    @Override
    public void registerGrammarDefinition(IGrammarDefinition definition) {
        super.registerGrammarDefinition(definition);
        this.added.add(definition);
    }

    @Override
    public void unregisterGrammarDefinition(IGrammarDefinition definition) {
        super.unregisterGrammarDefinition(definition);
        if (this.added.contains(definition)) {
            this.added.remove(definition);
        } else {
            this.removed.add(definition);
        }
    }

    @Override
    public void save() throws BackingStoreException {
        if (!this.added.isEmpty()) {
            for (IGrammarDefinition definition : this.added) {
                this.manager.registerGrammarDefinition(definition);
            }
        }
        if (!this.removed.isEmpty()) {
            for (IGrammarDefinition definition : this.removed) {
                this.manager.unregisterGrammarDefinition(definition);
            }
        }
        if (!this.added.isEmpty() || this.removed.isEmpty()) {
            this.manager.save();
        }
        this.added.clear();
        this.removed.clear();
    }
}

