/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.efs;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.rse.internal.efs.RSEFileStore;

public class RSEFileSystem
extends FileSystem {
    private static RSEFileSystem _instance = new RSEFileSystem();

    public static RSEFileSystem getInstance() {
        return _instance;
    }

    public int attributes() {
        return 102;
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public IFileStore getStore(URI uri) {
        try {
            return RSEFileStore.getInstance(uri);
        }
        catch (Exception exception) {
            return EFS.getNullFileSystem().getStore(uri);
        }
    }

    public static URI getURIFor(String hostNameOrAddr, String absolutePath) {
        if (absolutePath.charAt(0) != '/') {
            absolutePath = "/" + absolutePath.replace('\\', '/');
        }
        try {
            return new URI("rse", hostNameOrAddr, absolutePath, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static URI getURIFor(String hostNameOrAddr, String absolutePath, String alias) {
        if (absolutePath.charAt(0) != '/') {
            absolutePath = "/" + absolutePath.replace('\\', '/');
        }
        try {
            return new URI("rse", hostNameOrAddr, absolutePath, alias, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

