/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui;

import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.logging.LoggerFactory;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageFile;
import org.eclipse.rse.ui.messages.SystemUIMessageFile;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class SystemBasePlugin
extends AbstractUIPlugin {
    private static SystemBasePlugin baseInst = null;
    protected static Logger log = null;
    private static volatile IWorkbenchWindow activeWindow = null;
    private static volatile IWorkbenchWindow previousActiveWindow = null;
    private static IWindowListener windowListener = null;
    private static IWorkbenchListener workbenchListener = null;
    private Hashtable imageDescriptorRegistry = null;

    public static SystemBasePlugin getBaseDefault() {
        return baseInst;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = SystemBasePlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        Display d = Display.getCurrent();
        if (d != null) {
            return d.getActiveShell();
        }
        d = Display.getDefault();
        if (d != null) {
            return d.getActiveShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench wb = null;
        try {
            wb = SystemBasePlugin.getBaseDefault().getWorkbench();
        }
        catch (Exception exception) {
            wb = null;
        }
        if (wb != null) {
            if (Display.getCurrent() != null) {
                return wb.getActiveWorkbenchWindow();
            }
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows != null && windows.length > 0) {
                if (windows.length == 1) {
                    return windows[0];
                }
                IWorkbenchWindow bestCandidate = windows[0];
                int candidateRank = 0;
                int i = 0;
                while (i < windows.length) {
                    if (windows[i] == activeWindow) {
                        return activeWindow;
                    }
                    if (windows[i] == previousActiveWindow) {
                        bestCandidate = previousActiveWindow;
                        candidateRank = 10;
                    } else if (windows[i].getActivePage() != null && candidateRank == 0) {
                        bestCandidate = windows[i];
                        candidateRank = 1;
                    }
                    ++i;
                }
                return bestCandidate;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addWindowListener() {
        Class<WindowListener> clazz = WindowListener.class;
        synchronized (WindowListener.class) {
            if (windowListener == null) {
                try {
                    IWorkbench wb = PlatformUI.getWorkbench();
                    windowListener = new WindowListener();
                    wb.addWindowListener(windowListener);
                    workbenchListener = new WorkbenchListener();
                    wb.addWorkbenchListener(workbenchListener);
                }
                catch (IllegalStateException illegalStateException) {
                    SystemBasePlugin.logWarning("Workbench not yet available");
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return SystemBasePlugin.getWorkspace().getRoot();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getIconPath() {
        return "icons/";
    }

    public static ImageDescriptor getPluginImage(Bundle bundle, String fileName) {
        URL path = bundle.getEntry("/" + fileName);
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)path);
        return descriptor;
    }

    public static final URL resolveBundleNameNL(Bundle bundle, String name) {
        URL result = null;
        Stack<String> candidates = new Stack<String>();
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        candidates.push("/" + name);
        if (language.length() > 0) {
            candidates.push("/nl/" + language + "/" + name);
            if (country.length() > 0) {
                candidates.push("/nl/" + language + "/" + country + "/" + name);
            }
        }
        while (!candidates.isEmpty() && result == null) {
            String candidate = (String)candidates.pop();
            result = bundle.getResource(candidate);
        }
        return result;
    }

    public static final SystemMessageFile loadMessageFile(Bundle bundle, String fileName) {
        SystemUIMessageFile mf = null;
        boolean ok = false;
        try {
            URL url = SystemBasePlugin.resolveBundleNameNL(bundle, fileName);
            if (url != null) {
                mf = SystemUIMessageFile.getMessageFile(fileName, url);
                ok = true;
            }
        }
        catch (Throwable t) {
            SystemBasePlugin.logError("Error loading message file " + fileName + " in " + (String)bundle.getHeaders().get("Bundle-Name"), t);
            ok = false;
        }
        if (!ok) {
            MessageBox mb = new MessageBox(SystemBasePlugin.getActiveWorkbenchShell());
            mb.setText("Unexpected Error");
            mb.setMessage("Unable to load message file " + fileName + " in " + (String)bundle.getHeaders().get("Bundle-Name"));
            mb.open();
        }
        return mf;
    }

    public static final SystemMessageFile loadDefaultMessageFile(Bundle bundle, String fileName) {
        SystemUIMessageFile mf = null;
        boolean ok = false;
        try {
            URL url = bundle.getEntry("/" + fileName);
            if (url != null) {
                mf = SystemUIMessageFile.getMessageFile(fileName, url);
                ok = true;
            }
        }
        catch (Throwable t) {
            SystemBasePlugin.logError("Error loading message file " + fileName + " in " + (String)bundle.getHeaders().get("Bundle-Name"), t);
            ok = false;
        }
        if (!ok) {
            Shell s = SystemBasePlugin.getActiveWorkbenchShell();
            if (s == null) {
                Display d = Display.getCurrent();
                if (d != null) {
                    s = d.getActiveShell();
                } else {
                    d = Display.getDefault();
                    if (d != null) {
                        s = d.getActiveShell();
                    }
                }
            }
            if (s != null) {
                MessageBox mb = new MessageBox(s);
                mb.setText("Unexpected Error");
                mb.setMessage("Unable to load message file " + fileName + " in " + (String)bundle.getHeaders().get("Bundle-Name"));
                mb.open();
            }
        }
        return mf;
    }

    public static SystemMessage getMessage(SystemMessageFile msgFile, String msgId) {
        SystemMessage msg = null;
        if (msgFile != null) {
            msg = msgFile.getMessage(msgId);
        } else {
            SystemBasePlugin.logWarning("No message file set.");
        }
        if (msg == null) {
            SystemBasePlugin.logWarning("Unable to find message ID: " + msgId);
        }
        return msg;
    }

    public static boolean scanForDuplicateMessages(SystemMessageFile msgFile) {
        return msgFile.scanForDuplicates();
    }

    public static boolean printMessages(SystemMessageFile msgFile, String fullyQualifiedTargetFile) {
        return msgFile.printHTML(fullyQualifiedTargetFile);
    }

    public static void logMessage(SystemMessage message) {
        SystemBasePlugin.logMessage(message, null);
    }

    public static void logMessage(SystemMessage message, Throwable ex) {
        char type = message.getIndicator();
        switch (type) {
            case 'E': {
                SystemBasePlugin.getBaseDefault().getLogger().logError(message.toString(), ex);
                break;
            }
            case 'W': {
                SystemBasePlugin.getBaseDefault().getLogger().logWarning(message.toString(), ex);
                break;
            }
            case 'C': 
            case 'I': {
                SystemBasePlugin.getBaseDefault().getLogger().logInfo(message.toString(), ex);
                break;
            }
            default: {
                SystemBasePlugin.getBaseDefault().getLogger().logInfo(message.toString(), ex);
            }
        }
    }

    public static void logInfo(String message) {
        SystemBasePlugin.getBaseDefault().getLogger().logInfo(message);
    }

    public static void logWarning(String message) {
        SystemBasePlugin.getBaseDefault().getLogger().logWarning(message);
    }

    public static void logError(String message) {
        SystemBasePlugin.getBaseDefault().getLogger().logError(message, null);
    }

    public static void logError(String message, Throwable exception) {
        SystemBasePlugin.getBaseDefault().getLogger().logError(message, exception);
    }

    public static void logDebugMessage(String prefix, String message) {
        SystemBasePlugin.getBaseDefault().getLogger().logDebugMessage(prefix, message);
    }

    public SystemBasePlugin() {
        if (baseInst == null) {
            baseInst = this;
        }
    }

    public String getSymbolicName() {
        return this.getBundle().getSymbolicName();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        SystemBasePlugin.addWindowListener();
    }

    public void stop(BundleContext context) throws Exception {
        LoggerFactory.freeLogger((Plugin)this);
        super.stop(context);
    }

    public IWorkbench getWorkbench() {
        IWorkbench wb = null;
        try {
            wb = PlatformUI.getWorkbench();
            if (windowListener == null) {
                SystemBasePlugin.addWindowListener();
            }
        }
        catch (Exception exception) {}
        return wb;
    }

    protected abstract void initializeImageRegistry();

    protected ImageDescriptor putImageInRegistry(String id, String fileName) {
        ImageDescriptor fid = this.getPluginImage(fileName);
        Hashtable t = this.getImageDescriptorRegistry();
        t.put(id, fid);
        return fid;
    }

    public ImageDescriptor getPluginImage(String imagePath) {
        return SystemBasePlugin.getPluginImage(this.getBundle(), imagePath);
    }

    public Image getImage(String key) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null) {
            ImageDescriptor descriptor = this.getImageDescriptor(key);
            if (descriptor != null) {
                imageRegistry.put(key, descriptor);
                image = imageRegistry.get(key);
            } else {
                SystemBasePlugin.logError("...error retrieving image for key: " + key);
            }
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        Hashtable t = this.getImageDescriptorRegistry();
        ImageDescriptor descriptor = (ImageDescriptor)t.get(key);
        return descriptor;
    }

    private Hashtable getImageDescriptorRegistry() {
        if (this.imageDescriptorRegistry == null) {
            this.imageDescriptorRegistry = new Hashtable();
            this.initializeImageRegistry();
        }
        return this.imageDescriptorRegistry;
    }

    public ImageDescriptor getImageDescriptorFromIDE(String relativePath) {
        Hashtable registry = this.getImageDescriptorRegistry();
        ImageDescriptor descriptor = (ImageDescriptor)registry.get(relativePath);
        if (descriptor == null) {
            String iconPath = "icons/full/";
            String key = String.valueOf(iconPath) + relativePath;
            String[] bundleNames = new String[]{"org.eclipse.ui", "org.eclipse.ui.ide"};
            int i = 0;
            while (i < bundleNames.length && descriptor == null) {
                String bundleName = bundleNames[i];
                Bundle bundle = Platform.getBundle((String)bundleName);
                URL url = bundle.getResource(key);
                if (url != null) {
                    descriptor = ImageDescriptor.createFromURL((URL)url);
                }
                ++i;
            }
            if (descriptor == null) {
                descriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            registry.put(relativePath, descriptor);
        }
        return descriptor;
    }

    public Logger getLogger() {
        if (log == null) {
            log = LoggerFactory.getLogger((Plugin)this);
            log.logInfo("Loading " + ((Object)((Object)this)).getClass());
        }
        return log;
    }

    public boolean isHeadless() {
        return this.getWorkbench() == null;
    }

    private static class WindowListener
    implements IWindowListener {
        private WindowListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
            activeWindow = window;
            previousActiveWindow = null;
        }

        public void windowDeactivated(IWorkbenchWindow window) {
            if (window == activeWindow) {
                previousActiveWindow = activeWindow;
                activeWindow = null;
            }
        }

        public void windowClosed(IWorkbenchWindow window) {
            this.windowDeactivated(window);
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }

    private static class WorkbenchListener
    implements IWorkbenchListener {
        private WorkbenchListener() {
        }

        public boolean preShutdown(IWorkbench workbench, boolean forced) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postShutdown(IWorkbench workbench) {
            Class<WindowListener> clazz = WindowListener.class;
            synchronized (WindowListener.class) {
                assert (windowListener != null);
                workbench.removeWindowListener(windowListener);
                workbench.removeWorkbenchListener(workbenchListener);
                workbenchListener = null;
                windowListener = null;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

