/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.tools.ConvertPreferencesWizardPage;
import org.eclipse.swt.widgets.Shell;

public class ConvertPreferencesWizard
extends Wizard {
    private ConvertPreferencesWizardPage page;
    private String fPreferencesFilePath;
    private String fPluginCustomizeFilePath;
    private boolean fOverwrite;

    public ConvertPreferencesWizard(String pluginCustomizationFilePath, String preferencesFilePath, boolean overwrite) {
        this.fPreferencesFilePath = preferencesFilePath;
        this.fPluginCustomizeFilePath = pluginCustomizationFilePath;
        this.fOverwrite = overwrite;
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_PRODUCT_WIZ);
        this.setWindowTitle(PDEUIMessages.ConvertPreferencesWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        this.fPluginCustomizeFilePath = this.page.getPluginCustomizeFile().getFullPath().toString();
        this.fPreferencesFilePath = this.page.getPreferencesFile().getAbsolutePath();
        this.fOverwrite = this.page.getOverwrite();
        try {
            this.getContainer().run(false, false, this.getGenerateOperation());
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)PDEUIMessages.ConvertPreferencesWizard_errorTitle, (String)e.getTargetException().getMessage());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public void addPages() {
        this.page = new ConvertPreferencesWizardPage(this.fPluginCustomizeFilePath, this.fPreferencesFilePath, this.fOverwrite);
        this.addPage((IWizardPage)this.page);
    }

    private IRunnableWithProgress getGenerateOperation() {
        return new IRunnableWithProgress(){

            /*
             * Loose catch block
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                block27: {
                    monitor.beginTask(PDEUIMessages.ConvertPreferencesWizard_progress, 100);
                    File prefsFile = ConvertPreferencesWizard.this.page.getPreferencesFile();
                    if (prefsFile != null) {
                        String sourceFilePath;
                        String errorFilePath = sourceFilePath = prefsFile.getAbsolutePath();
                        if (prefsFile.exists()) {
                            try {
                                try {
                                    Object value;
                                    Object key;
                                    Properties properties = new Properties();
                                    try (BufferedReader in = new BufferedReader(new FileReader(sourceFilePath));){
                                        String line;
                                        while ((line = in.readLine()) != null) {
                                            int keyIndex;
                                            int index;
                                            if (line.length() <= 0 || line.charAt(0) != '/' || (index = line.indexOf(47, 1)) <= -1 || (keyIndex = line.indexOf(61, index)) <= index + 1) continue;
                                            key = line.substring(index + 1, keyIndex).trim();
                                            value = line.substring(keyIndex + 1).trim();
                                            properties.put(key, value);
                                        }
                                    }
                                    monitor.worked(50);
                                    if (properties.size() > 0) {
                                        IFile customizationFile = ConvertPreferencesWizard.this.page.getPluginCustomizeFile();
                                        errorFilePath = customizationFile.getFullPath().toString();
                                        if (!customizationFile.exists()) {
                                            byte[] bytes = "".getBytes();
                                            ByteArrayInputStream source = new ByteArrayInputStream(bytes);
                                            customizationFile.create((InputStream)source, 0, null);
                                        }
                                        StringBuilder out = new StringBuilder();
                                        if (!ConvertPreferencesWizard.this.fOverwrite) {
                                            try (BufferedReader existingFile = new BufferedReader(new InputStreamReader(customizationFile.getContents()));){
                                                String line;
                                                while ((line = existingFile.readLine()) != null) {
                                                    int index = line.indexOf(61);
                                                    if (index > 1) {
                                                        String key2 = line.substring(0, index).trim();
                                                        if (properties.containsKey(key2)) continue;
                                                        out.append(line);
                                                        out.append('\n');
                                                        continue;
                                                    }
                                                    PDEPlugin.log(NLS.bind((String)PDEUIMessages.ConvertPreferencesWizard_skippedInvalidLine, (Object)ConvertPreferencesWizard.this.fPreferencesFilePath));
                                                    PDEPlugin.log("    " + line);
                                                }
                                            }
                                        }
                                        monitor.worked(20);
                                        Enumeration<Object> keys = properties.keys();
                                        while (keys.hasMoreElements()) {
                                            key = keys.nextElement();
                                            value = properties.get(key);
                                            out.append(key + "=" + value);
                                            out.append('\n');
                                        }
                                        ByteArrayInputStream resultStream = new ByteArrayInputStream(out.toString().getBytes());
                                        customizationFile.setContents((InputStream)resultStream, true, true, null);
                                        monitor.worked(30);
                                        break block27;
                                    }
                                    ConvertPreferencesWizard.this.page.setMessage(PDEUIMessages.ConvertPreferencesWizard_errorNoPrefs, 2);
                                    break block27;
                                }
                                catch (FileNotFoundException e) {
                                    ConvertPreferencesWizard.this.page.setErrorMessage(NLS.bind((String)PDEUIMessages.ConvertPreferencesWizard_errorFile, (Object)errorFilePath));
                                    PDEPlugin.logException(e);
                                    monitor.done();
                                    return;
                                }
                                catch (CoreException e) {
                                    ConvertPreferencesWizard.this.page.setErrorMessage(NLS.bind((String)PDEUIMessages.ConvertPreferencesWizard_errorFile, (Object)errorFilePath));
                                    PDEPlugin.logException(e);
                                    monitor.done();
                                    return;
                                }
                                catch (IOException e) {
                                    ConvertPreferencesWizard.this.page.setErrorMessage(NLS.bind((String)PDEUIMessages.ConvertPreferencesWizard_errorFile, (Object)errorFilePath));
                                    PDEPlugin.logException(e);
                                    {
                                        catch (Throwable throwable) {
                                            throw throwable;
                                        }
                                    }
                                    monitor.done();
                                    return;
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }
                        ConvertPreferencesWizard.this.page.setErrorMessage(PDEUIMessages.ConvertPreferencesWizard_errorFileNotFound);
                    } else {
                        ConvertPreferencesWizard.this.page.setErrorMessage(PDEUIMessages.ConvertPreferencesWizard_errorNoFileSpecified);
                    }
                }
            }
        };
    }

    public String getPreferencesFilePath() {
        return this.fPreferencesFilePath;
    }

    public String getPluginCustomizationFilePath() {
        return this.fPluginCustomizeFilePath;
    }

    public boolean getOverwrite() {
        return this.fOverwrite;
    }
}

