/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.contextual.core.provider;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.amalgam.explorer.contextual.core.provider.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.NotifyChangedToViewerRefresh;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractGroupedAdapterFactoryContentProvider
extends AdapterFactoryContentProvider {
    protected ResourceSetListener listener = null;
    protected Collection<Notification> notifications = null;
    protected Collection<EObject> toRefresh = new HashSet<EObject>();

    protected abstract boolean refreshRequired(ResourceSetChangeEvent var1);

    public AbstractGroupedAdapterFactoryContentProvider(AdapterFactory adapterFactory_p) {
        super(adapterFactory_p);
    }

    protected ResourceSetListener getListener() {
        if (this.listener == null) {
            this.listener = new ResourceSetListenerImpl(){

                public boolean isPostcommitOnly() {
                    return true;
                }

                public void resourceSetChanged(ResourceSetChangeEvent event_p) {
                    super.resourceSetChanged(event_p);
                    if (AbstractGroupedAdapterFactoryContentProvider.this.refreshRequired(event_p)) {
                        AbstractGroupedAdapterFactoryContentProvider.this.runRefresh();
                    }
                }
            };
        }
        return this.listener;
    }

    public void notifyChanged2(Notification notification) {
        if (notification instanceof IViewerNotification) {
            this.viewerRefresh.addNotification((IViewerNotification)notification);
        } else {
            new NotifyChangedToViewerRefresh().refresh(this.viewer, notification.getNotifier(), notification.getEventType(), notification.getFeature(), notification.getOldValue(), notification.getNewValue(), notification.getPosition());
        }
    }

    public void runRefresh() {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            UIJob job = new UIJob(this.viewer.getControl().getDisplay(), Messages.GroupedAdapterFactoryContentProvider_RefreshViewer){

                public IStatus runInUIThread(IProgressMonitor monitor_p) {
                    AbstractGroupedAdapterFactoryContentProvider.this.processRefresh();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRefresh() {
        Collection<Notification> currentNotifications = null;
        Collection<EObject> currentRefresh = null;
        AbstractGroupedAdapterFactoryContentProvider abstractGroupedAdapterFactoryContentProvider = this;
        synchronized (abstractGroupedAdapterFactoryContentProvider) {
            currentNotifications = this.notifications;
            this.notifications = null;
            currentRefresh = this.toRefresh;
            this.toRefresh = null;
        }
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            HashSet<ChangeNotification> duplicateNotifications = new HashSet<ChangeNotification>();
            if (currentNotifications != null && currentNotifications.size() > 0) {
                this.viewerRefresh = new AdapterFactoryContentProvider.ViewerRefresh(this.viewer);
                for (Notification notification : currentNotifications) {
                    ChangeNotification changeNotification = new ChangeNotification(notification.getNotifier(), notification.getFeature(), notification.getNewValue(), notification.getEventType());
                    if (duplicateNotifications.contains(changeNotification)) continue;
                    duplicateNotifications.add(changeNotification);
                    this.notifyChanged2(notification);
                }
                duplicateNotifications.clear();
                if (this.viewerRefresh != null) {
                    this.viewerRefresh.run();
                    this.viewerRefresh = null;
                }
                currentNotifications.clear();
            }
            if (currentRefresh != null && currentRefresh.size() > 0) {
                ((StructuredViewer)this.viewer).update(currentRefresh.toArray(), null);
                currentRefresh.clear();
            }
        }
    }

    public synchronized void addNotification(Notification notification_p) {
        if (this.notifications == null) {
            this.notifications = new ArrayList<Notification>();
        }
        this.notifications.add(notification_p);
    }

    protected synchronized void addNotifications(List<Notification> notifications_p) {
        if (this.notifications == null) {
            this.notifications = new ArrayList<Notification>();
        }
        this.notifications.addAll(notifications_p);
    }

    public synchronized void addObject(EObject eObject_p) {
        if (this.toRefresh == null) {
            this.toRefresh = new HashSet<EObject>();
        }
        this.toRefresh.add(eObject_p);
    }

    public void notifyChanged(Notification notification_p) {
        this.addNotification(notification_p);
    }

    protected class ChangeNotification {
        private WeakReference<Object> _notifierReference;
        private WeakReference<Object> _featureReference;
        private WeakReference<Object> _newValueReference;
        private int _eventType;

        public ChangeNotification(Object notifier_p, Object feature_p, Object newValue_p, int eventType_p) {
            this._notifierReference = new WeakReference<Object>(notifier_p);
            this._featureReference = new WeakReference<Object>(feature_p);
            this._newValueReference = new WeakReference<Object>(newValue_p);
            this._eventType = eventType_p;
        }

        public boolean equals(Object object_p) {
            boolean cr = super.equals(object_p);
            if (!cr && object_p instanceof ChangeNotification) {
                ChangeNotification notification = (ChangeNotification)object_p;
                cr = true;
                if (!(this._notifierReference.get() == null && notification._notifierReference.get() == null || this._notifierReference.get() != null && this._notifierReference.get().equals(notification._notifierReference.get()))) {
                    cr = false;
                } else if (!(this._featureReference.get() == null && notification._featureReference.get() == null || this._featureReference.get() != null && this._featureReference.get().equals(notification._featureReference.get()))) {
                    cr = false;
                } else if (!(this._newValueReference.get() == null && notification._newValueReference.get() == null || this._newValueReference.get() != null && this._newValueReference.get().equals(notification._newValueReference.get()))) {
                    cr = false;
                }
                cr = cr ? this._eventType == notification._eventType : false;
            }
            return cr;
        }

        public int hashCode() {
            int result = 17;
            if (this._notifierReference.get() != null) {
                result = 37 * result + this._notifierReference.get().hashCode();
            }
            if (this._featureReference.get() != null) {
                result = 37 * result + this._featureReference.get().hashCode();
            }
            if (this._newValueReference.get() != null) {
                result = 37 * result + this._newValueReference.get().hashCode();
            }
            result = 37 * result + this._eventType;
            return result;
        }
    }
}

