/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.nfp.impl;

import org.eclipse.emf.common.util.Enumerator;
import org.polarsys.time4sys.marte.nfp.Dimension;

public abstract class DimensionImpl<U extends Enumerator>
implements Dimension<U> {
    protected final String name;

    public DimensionImpl(String name) {
        this.name = name;
        assert (name != null);
    }

    @Override
    public U findClosestUnitTo(U unit1, U unit2) {
        return this.get(Math.min(unit1.getValue(), unit2.getValue()));
    }

    @Override
    public double getConversionFactor(U source, U target) {
        double[] factors = this.getFactors();
        double f = 1.0;
        if (source == target) {
            return f;
        }
        if (source.getValue() < target.getValue()) {
            return 1.0 / this.getConversionFactor(target, source);
        }
        assert (source.getValue() > target.getValue());
        int i = source.getValue();
        while (i > target.getValue()) {
            f *= factors[i];
            --i;
        }
        return f;
    }

    @Override
    public abstract double[] getFactors();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public abstract U get(int var1);
}

