/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.builder.design;

import org.polarsys.time4sys.builder.design.CommunicationChannelBuilder;
import org.polarsys.time4sys.builder.design.DesignBuilder;
import org.polarsys.time4sys.builder.design.StepBuilder;
import org.polarsys.time4sys.design.DesignFactory;
import org.polarsys.time4sys.marte.gqam.GqamFactory;
import org.polarsys.time4sys.marte.grm.CommunicationMedia;
import org.polarsys.time4sys.marte.grm.GrmFactory;
import org.polarsys.time4sys.marte.grm.Resource;
import org.polarsys.time4sys.marte.grm.SchedPolicyKind;
import org.polarsys.time4sys.marte.grm.SchedulableResource;
import org.polarsys.time4sys.marte.grm.Scheduler;
import org.polarsys.time4sys.marte.grm.SchedulingPolicy;
import org.polarsys.time4sys.marte.hrm.HrmFactory;
import org.polarsys.time4sys.marte.nfp.NfpFactory;
import org.polarsys.time4sys.marte.srm.SrmFactory;

public class CommunicationMediaBuilder {
    protected static DesignFactory df = DesignFactory.eINSTANCE;
    protected static GqamFactory gqamFactory = GqamFactory.eINSTANCE;
    protected static SrmFactory srmFactory = SrmFactory.eINSTANCE;
    protected static GrmFactory grmFactory = GrmFactory.eINSTANCE;
    protected static HrmFactory hrmFactory = HrmFactory.eINSTANCE;
    protected static NfpFactory nfpFactory = NfpFactory.eINSTANCE;
    private DesignBuilder designBuilder;
    private CommunicationMedia bus;

    public CommunicationMediaBuilder(DesignBuilder designBuilder, CommunicationMedia bus) {
        this.bus = bus;
        this.designBuilder = designBuilder;
    }

    public CommunicationMediaBuilder called(String name) {
        this.bus.setName(name);
        return this;
    }

    public CommunicationMediaBuilder thatEmits(CommunicationChannelBuilder ... packets) {
        CommunicationChannelBuilder[] communicationChannelBuilderArray = packets;
        int n = packets.length;
        int n2 = 0;
        while (n2 < n) {
            CommunicationChannelBuilder tb = communicationChannelBuilderArray[n2];
            this.bus.getOwnedResource().add((Object)tb.build(this.designBuilder));
            ++n2;
        }
        return this;
    }

    public CommunicationMediaBuilder thatEmits(StepBuilder ... steps) {
        StepBuilder[] stepBuilderArray = steps;
        int n = steps.length;
        int n2 = 0;
        while (n2 < n) {
            StepBuilder step = stepBuilderArray[n2];
            this.bus.getOwnedResource().add((Object)step.getTask().build(this.designBuilder));
            ++n2;
        }
        return this;
    }

    public CommunicationMediaBuilder under(SchedPolicyKind polKind) {
        Scheduler sched = grmFactory.createScheduler();
        this.bus.getOwnedResource().add((Object)sched);
        sched.getProcessingUnits().add((Object)this.bus);
        this.bus.setMainScheduler(sched);
        SchedulingPolicy pol = grmFactory.createSchedulingPolicy(polKind);
        sched.setPolicy(pol);
        for (Resource res : this.bus.getOwnedResource()) {
            if (!(res instanceof SchedulableResource)) continue;
            sched.getSchedulableResource().add((Object)((SchedulableResource)res));
        }
        return this;
    }
}

