/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.transformations;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.time4sys.design.DesignModel;
import org.polarsys.time4sys.mapping.Context;
import org.polarsys.time4sys.mapping.Link;
import org.polarsys.time4sys.mapping.MappableArtefact;
import org.polarsys.time4sys.mapping.MappingFactory;
import org.polarsys.time4sys.marte.gqam.Step;
import org.polarsys.time4sys.marte.grm.Resource;
import org.polarsys.time4sys.marte.grm.SchedulableResource;
import org.polarsys.time4sys.marte.srm.SoftwareSchedulableResource;
import org.polarsys.time4sys.model.time4sys.Project;
import org.polarsys.time4sys.model.time4sys.Transformation;
import org.polarsys.time4sys.transformations.AbstractTransformation;
import org.polarsys.time4sys.transformations.IdentityDerivation;

public class TaskDuplicator
extends AbstractTransformation {
    public static final String COPY_TASK_ROLE = "copy-task";
    public static final String ORIGINAL_TASK_ROLE = "original-task";
    public static final String TRANS_NAME = ("One Task per Step Rule " + TaskDuplicator.class.getSimpleName()).intern();
    public static final String STEPNTASK_TRANS_NAME = ("one step to one task AND one step Rule " + TaskDuplicator.class.getSimpleName()).intern();
    public static final String TASK_TRANS_NAME = ("one duplicated task Rule " + TaskDuplicator.class.getSimpleName()).intern();
    private Collection<Link> stepsToBeUpdated = new LinkedHashSet<Link>();
    private Collection<Link> tasksToBeCopied = new LinkedHashSet<Link>();
    private Map<SchedulableResource, Collection<SchedulableResource>> tasksToBeLinked = new HashMap<SchedulableResource, Collection<SchedulableResource>>();
    private Context stepNTaskRule;
    private Context taskDuplicationRule;
    private Collection<SchedulableResource> tasksToBeRemoved = new LinkedHashSet<SchedulableResource>();

    public static Transformation transform(Project project, DesignModel source) {
        return new TaskDuplicator(project, source).transform();
    }

    public TaskDuplicator(Project project, DesignModel source) {
        super(project, source, TRANS_NAME);
    }

    @Override
    public void createRules() {
        super.createRules();
        this.stepNTaskRule = mappingFactory.createContext(STEPNTASK_TRANS_NAME);
        this.taskDuplicationRule = mappingFactory.createContext(TASK_TRANS_NAME);
        this.mapping.getRules().add((Object)this.stepNTaskRule);
        this.mapping.getRules().add((Object)this.taskDuplicationRule);
    }

    @Override
    public void copied(EObject source, Link lnk, EObject theCopy) {
        if (source instanceof Step) {
            this.stepsToBeUpdated.add(lnk);
            SchedulableResource concurRes = ((Step)source).getConcurRes();
            if (concurRes != null) {
                this.tasksToBeRemoved.add(concurRes);
            }
        }
        if (source instanceof SoftwareSchedulableResource) {
            this.tasksToBeCopied.add(lnk);
        }
    }

    @Override
    protected void finalize(DesignModel target) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier(true, true);
        for (Link lnk : this.stepsToBeUpdated) {
            TaskDuplicator.moveStepToNewTask(this.tasksToBeLinked, copier, lnk, this.stepNTaskRule);
        }
        copier.copyReferences();
        TaskDuplicator.deleteCopiedTasks(this.tasksToBeRemoved, this.tasksToBeLinked, this.tasksToBeCopied, this.taskDuplicationRule);
    }

    public static void deleteCopiedTasks(Collection<SchedulableResource> sourceOrTargetTasksToBeRemoved, Map<SchedulableResource, Collection<SchedulableResource>> tasksToBeLinked, Collection<Link> tasksToBeCopied, Context taskDuplicationRule) {
        for (Link lnk : tasksToBeCopied) {
            SoftwareSchedulableResource source = (SoftwareSchedulableResource)lnk.getUniqueSourceValue(IdentityDerivation.ORIGINAL_ROLE);
            SoftwareSchedulableResource copy = (SoftwareSchedulableResource)lnk.getUniqueTargetValue(IdentityDerivation.COPY_ROLE);
            if (!sourceOrTargetTasksToBeRemoved.contains(source) && !sourceOrTargetTasksToBeRemoved.contains(copy)) continue;
            lnk.setRationale(taskDuplicationRule);
            lnk.getTargets().clear();
            for (SchedulableResource targetDup : TaskDuplicator.registeredCopiesOf(tasksToBeLinked, copy)) {
                lnk.getTargets().add((Object)MappingFactory.eINSTANCE.createMappableArtefact(COPY_TASK_ROLE, (EObject)targetDup));
            }
            EcoreUtil.delete((EObject)copy, (boolean)true);
        }
    }

    public static void moveStepToNewTask(Map<SchedulableResource, Collection<SchedulableResource>> tasksToBeLinked, EcoreUtil.Copier copier, Link lnk, Context rule) {
        Step source = (Step)lnk.getUniqueSourceValue("original");
        Step copy = (Step)lnk.getUniqueTargetValue("copy");
        SchedulableResource sourceTask = source.getConcurRes();
        SchedulableResource copyTask = copy.getConcurRes();
        SchedulableResource targetTask = (SchedulableResource)copier.copy((EObject)copyTask);
        targetTask.setHost(copyTask.getHost());
        targetTask.setDependentScheduler(copyTask.getDependentScheduler());
        TaskDuplicator.registerCopyOf(tasksToBeLinked, targetTask, copyTask);
        targetTask.setName(String.valueOf(sourceTask.getName()) + "_x_" + source.getName());
        assert (copyTask.eContainer() != null);
        ((Resource)copyTask.eContainer()).getOwnedResource().add((Object)targetTask);
        assert (targetTask.eContainer() != null);
        assert (copyTask.eContainer() == targetTask.eContainer());
        copy.setConcurRes(targetTask);
        MappableArtefact origTaskMap = MappingFactory.eINSTANCE.createMappableArtefact(ORIGINAL_TASK_ROLE, (EObject)sourceTask);
        MappableArtefact copyTaskMap = MappingFactory.eINSTANCE.createMappableArtefact(COPY_TASK_ROLE, (EObject)targetTask);
        lnk.getSources().add((Object)origTaskMap);
        lnk.getTargets().add((Object)copyTaskMap);
        lnk.setRationale(rule);
    }

    protected static Collection<SchedulableResource> registeredCopiesOf(Map<SchedulableResource, Collection<SchedulableResource>> tasksToBeLinked, SoftwareSchedulableResource copyTask) {
        Collection<SchedulableResource> result = tasksToBeLinked.get(copyTask);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    protected static void registerCopyOf(Map<SchedulableResource, Collection<SchedulableResource>> tasksToBeLinked, SchedulableResource targetTask, SchedulableResource copyTask) {
        Collection<SchedulableResource> copies = tasksToBeLinked.get(copyTask);
        if (copies == null) {
            copies = new LinkedHashSet<SchedulableResource>();
            tasksToBeLinked.put(copyTask, copies);
        }
        copies.add(targetTask);
    }
}

