/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ([
/* 0 */
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.activate = activate;
const extension_telemetry_1 = __importDefault(__webpack_require__(1));
const vscode = __importStar(__webpack_require__(2));
const api_1 = __webpack_require__(169);
const commandManager_1 = __webpack_require__(170);
const index_1 = __webpack_require__(171);
const configuration_browser_1 = __webpack_require__(232);
const experimentTelemetryReporter_1 = __webpack_require__(236);
const ata_1 = __webpack_require__(237);
const lazyClientHost_1 = __webpack_require__(249);
const logger_1 = __webpack_require__(331);
const remoteRepositories_browser_1 = __importDefault(__webpack_require__(332));
const api_2 = __webpack_require__(175);
const cancellation_1 = __webpack_require__(333);
const logDirectoryProvider_1 = __webpack_require__(334);
const plugins_1 = __webpack_require__(335);
const serverProcess_browser_1 = __webpack_require__(336);
const versionProvider_1 = __webpack_require__(350);
const activeJsTsEditorTracker_1 = __webpack_require__(351);
const dispose_1 = __webpack_require__(239);
const packageInfo_1 = __webpack_require__(352);
const platform_1 = __webpack_require__(240);
class StaticVersionProvider {
    constructor(_version) {
        this._version = _version;
        this.globalVersion = undefined;
        this.localVersion = undefined;
        this.localVersions = [];
    }
    updateConfiguration(_configuration) {
        // noop
    }
    get defaultVersion() { return this._version; }
    get bundledVersion() { return this._version; }
}
async function activate(context) {
    const pluginManager = new plugins_1.PluginManager();
    context.subscriptions.push(pluginManager);
    const commandManager = new commandManager_1.CommandManager();
    context.subscriptions.push(commandManager);
    const onCompletionAccepted = new vscode.EventEmitter();
    context.subscriptions.push(onCompletionAccepted);
    const activeJsTsEditorTracker = new activeJsTsEditorTracker_1.ActiveJsTsEditorTracker();
    context.subscriptions.push(activeJsTsEditorTracker);
    const versionProvider = new StaticVersionProvider(new versionProvider_1.TypeScriptVersion("bundled" /* TypeScriptVersionSource.Bundled */, vscode.Uri.joinPath(context.extensionUri, 'dist/browser/typescript/tsserver.web.js').toString(), api_2.API.fromSimpleString('5.6.2')));
    let experimentTelemetryReporter;
    const packageInfo = (0, packageInfo_1.getPackageInfo)(context);
    if (packageInfo) {
        const { aiKey } = packageInfo;
        const vscTelemetryReporter = new extension_telemetry_1.default(aiKey);
        experimentTelemetryReporter = new experimentTelemetryReporter_1.ExperimentationTelemetryReporter(vscTelemetryReporter);
        context.subscriptions.push(experimentTelemetryReporter);
    }
    const logger = new logger_1.Logger();
    const lazyClientHost = (0, lazyClientHost_1.createLazyClientHost)(context, false, {
        pluginManager,
        commandManager,
        logDirectoryProvider: logDirectoryProvider_1.noopLogDirectoryProvider,
        cancellerFactory: cancellation_1.noopRequestCancellerFactory,
        versionProvider,
        processFactory: new serverProcess_browser_1.WorkerServerProcessFactory(context.extensionUri, logger),
        activeJsTsEditorTracker,
        serviceConfigurationProvider: new configuration_browser_1.BrowserServiceConfigurationProvider(),
        experimentTelemetryReporter,
        logger,
    }, item => {
        onCompletionAccepted.fire(item);
    });
    (0, index_1.registerBaseCommands)(commandManager, lazyClientHost, pluginManager, activeJsTsEditorTracker);
    // context.subscriptions.push(task.register(lazyClientHost.map(x => x.serviceClient)));
    Promise.resolve().then(() => __importStar(__webpack_require__(353))).then(module => {
        context.subscriptions.push(module.register());
    });
    context.subscriptions.push((0, lazyClientHost_1.lazilyActivateClient)(lazyClientHost, pluginManager, activeJsTsEditorTracker, async () => {
        await startPreloadWorkspaceContentsIfNeeded(context, logger);
    }));
    context.subscriptions.push((0, ata_1.registerAtaSupport)(logger));
    return (0, api_1.getExtensionApi)(onCompletionAccepted.event, pluginManager);
}
async function startPreloadWorkspaceContentsIfNeeded(context, logger) {
    if (!(0, platform_1.isWebAndHasSharedArrayBuffers)()) {
        return;
    }
    if (!vscode.workspace.workspaceFolders) {
        return;
    }
    await Promise.all(vscode.workspace.workspaceFolders.map(async (folder) => {
        const workspaceUri = folder.uri;
        if (workspaceUri.scheme !== 'vscode-vfs' || !workspaceUri.authority.startsWith('github')) {
            logger.info(`Skipped pre loading workspace contents for repository ${workspaceUri?.toString()}`);
            return;
        }
        const loader = new RemoteWorkspaceContentsPreloader(workspaceUri, logger);
        context.subscriptions.push(loader);
        try {
            await loader.triggerPreload();
        }
        catch (error) {
            console.error(error);
        }
    }));
}
class RemoteWorkspaceContentsPreloader extends dispose_1.Disposable {
    constructor(workspaceUri, logger) {
        super();
        this.workspaceUri = workspaceUri;
        this.logger = logger;
        const fsWatcher = this._register(vscode.workspace.createFileSystemWatcher(new vscode.RelativePattern(workspaceUri, '*')));
        this._register(fsWatcher.onDidChange(uri => {
            if (uri.toString() === workspaceUri.toString()) {
                this._preload = undefined;
                this.triggerPreload();
            }
        }));
    }
    async triggerPreload() {
        this._preload ?? (this._preload = this.doPreload());
        return this._preload;
    }
    async doPreload() {
        try {
            const remoteHubApi = await remoteRepositories_browser_1.default.getApi();
            if (await remoteHubApi.loadWorkspaceContents?.(this.workspaceUri)) {
                this.logger.info(`Successfully loaded workspace content for repository ${this.workspaceUri.toString()}`);
            }
            else {
                this.logger.info(`Failed to load workspace content for repository ${this.workspaceUri.toString()}`);
            }
        }
        catch (error) {
            this.logger.info(`Loading workspace content for repository ${this.workspaceUri.toString()} failed: ${error instanceof Error ? error.toString() : 'Unknown reason'}`);
            console.error(error);
        }
    }
}


/***/ }),
/* 1 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TelemetryReporter)
/* harmony export */ });
/* harmony import */ var vscode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
/* harmony import */ var vscode__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(vscode__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _common_1dsClientFactory__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3);
/* harmony import */ var _common_baseTelemetrySender__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(125);
/* harmony import */ var _common_baseTelemetryReporter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(126);
/* harmony import */ var _common_util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(127);
/* harmony import */ var _common_appInsightsClientFactory__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(128);
/*---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/






function getBrowserRelease(navigator) {
    if (navigator.userAgentData) {
        const browser = navigator.userAgentData.brands[navigator.userAgentData.brands.length - 1];
        return `${navigator.userAgentData.platform} - ${browser?.brand} v${browser?.version}}`;
    }
    else {
        return navigator.appVersion;
    }
}
class TelemetryReporter extends _common_baseTelemetryReporter__WEBPACK_IMPORTED_MODULE_1__.BaseTelemetryReporter {
    constructor(key, replacementOptions) {
        let clientFactory = (key) => (0,_common_appInsightsClientFactory__WEBPACK_IMPORTED_MODULE_2__.appInsightsClientFactory)(key, undefined, replacementOptions);
        // If key is usable by 1DS use the 1DS SDk
        if (_common_util__WEBPACK_IMPORTED_MODULE_3__.TelemetryUtil.shouldUseOneDataSystemSDK(key)) {
            clientFactory = (key) => (0,_common_1dsClientFactory__WEBPACK_IMPORTED_MODULE_4__.oneDataSystemClientFactory)(key, vscode__WEBPACK_IMPORTED_MODULE_0__);
        }
        const osShim = {
            release: getBrowserRelease(navigator),
            platform: "web",
            architecture: "web",
        };
        const sender = new _common_baseTelemetrySender__WEBPACK_IMPORTED_MODULE_5__.BaseTelemetrySender(key, clientFactory);
        // AIF is no longer supported
        if (key && (key.indexOf("AIF") === 0)) {
            throw new Error("AIF keys are no longer supported. Please switch to 1DS keys for 1st party extensions");
        }
        super(sender, vscode__WEBPACK_IMPORTED_MODULE_0__, { additionalCommonProperties: _common_util__WEBPACK_IMPORTED_MODULE_3__.TelemetryUtil.getAdditionalCommonProperties(osShim) });
    }
}
//# sourceMappingURL=telemetryReporter.js.map

/***/ }),
/* 2 */
/***/ ((module) => {

"use strict";
module.exports = require("vscode");

/***/ }),
/* 3 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   oneDataSystemClientFactory: () => (/* binding */ oneDataSystemClientFactory)
/* harmony export */ });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
/**
 * Configures 1DS properly and returns the core client object
 * @param key The ingestion key
 * @param xhrOverride An optional override to use for requests instead of the XHTMLRequest object. Useful for node environments
 * @returns The AI core object
 */
const getAICore = async (key, vscodeAPI, xhrOverride) => {
    const oneDs = await Promise.resolve(/* import() eager */).then(__webpack_require__.bind(__webpack_require__, 4));
    const postPlugin = await Promise.resolve(/* import() eager */).then(__webpack_require__.bind(__webpack_require__, 113));
    const appInsightsCore = new oneDs.AppInsightsCore();
    const collectorChannelPlugin = new postPlugin.PostChannel();
    // Configure the app insights core to send to collector++ and disable logging of debug info
    const coreConfig = {
        instrumentationKey: key,
        endpointUrl: "https://mobile.events.data.microsoft.com/OneCollector/1.0",
        loggingLevelTelemetry: 0,
        loggingLevelConsole: 0,
        disableCookiesUsage: true,
        disableDbgExt: true,
        disableInstrumentationKeyValidation: true,
        channels: [[
                collectorChannelPlugin
            ]]
    };
    if (xhrOverride) {
        coreConfig.extensionConfig = {};
        // Configure the channel to use a XHR Request override since it's not available in node
        const channelConfig = {
            alwaysUseXhrOverride: true,
            httpXHROverride: xhrOverride
        };
        coreConfig.extensionConfig[collectorChannelPlugin.identifier] = channelConfig;
    }
    const config = vscodeAPI.workspace.getConfiguration("telemetry");
    const internalTesting = config.get("internalTesting");
    appInsightsCore.initialize(coreConfig, []);
    appInsightsCore.addTelemetryInitializer((envelope) => {
        // Only add this flag when `telemetry.internalTesting` is enabled
        if (!internalTesting) {
            return;
        }
        envelope["ext"] = envelope["ext"] ?? {};
        envelope["ext"]["utc"] = envelope["ext"]["utc"] ?? {};
        // Sets it to be internal only based on Windows UTC flagging
        envelope["ext"]["utc"]["flags"] = 0x0000811ECD;
    });
    return appInsightsCore;
};
/**
 * Configures and creates a telemetry client using the 1DS sdk
 * @param key The ingestion key
 * @param xhrOverride An optional override to use for requests instead of the XHTMLRequest object. Useful for node environments
 */
const oneDataSystemClientFactory = async (key, vscodeAPI, xhrOverride) => {
    let appInsightsCore = await getAICore(key, vscodeAPI, xhrOverride);
    const flushOneDS = async () => {
        try {
            const flushPromise = new Promise((resolve, reject) => {
                if (!appInsightsCore) {
                    resolve();
                    return;
                }
                appInsightsCore.flush(true, (completedFlush) => {
                    if (!completedFlush) {
                        reject("Failed to flush app 1DS!");
                        return;
                    }
                });
            });
            return flushPromise;
        }
        catch (e) {
            throw new Error("Failed to flush 1DS!\n" + e.message);
        }
    };
    // Shape the app insights core from 1DS into a standard format
    const telemetryClient = {
        logEvent: (eventName, data) => {
            try {
                appInsightsCore?.track({
                    name: eventName,
                    baseData: { name: eventName, properties: data?.properties, measurements: data?.measurements }
                });
            }
            catch (e) {
                throw new Error("Failed to log event to app insights!\n" + e.message);
            }
        },
        flush: flushOneDS,
        dispose: async () => {
            const disposePromise = new Promise((resolve) => {
                if (!appInsightsCore) {
                    resolve();
                    return;
                }
                appInsightsCore.unload(false, () => {
                    resolve();
                    appInsightsCore = undefined;
                    return;
                }, 1000);
            });
            return disposePromise;
        }
    };
    return telemetryClient;
};
//# sourceMappingURL=1dsClientFactory.js.map

/***/ }),
/* 4 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppInsightsCore: () => (/* reexport safe */ _AppInsightsCore__WEBPACK_IMPORTED_MODULE_1__.AppInsightsCore),
/* harmony export */   BaseTelemetryPlugin: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__.BaseTelemetryPlugin),
/* harmony export */   DiagnosticLogger: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__.DiagnosticLogger),
/* harmony export */   EventLatency: () => (/* reexport safe */ _Enums__WEBPACK_IMPORTED_MODULE_0__.EventLatency),
/* harmony export */   EventPersistence: () => (/* reexport safe */ _Enums__WEBPACK_IMPORTED_MODULE_0__.EventPersistence),
/* harmony export */   EventPropertyType: () => (/* reexport safe */ _Enums__WEBPACK_IMPORTED_MODULE_0__.EventPropertyType),
/* harmony export */   EventsDiscardedReason: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__.EventsDiscardedReason),
/* harmony export */   FullVersionString: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.FullVersionString),
/* harmony export */   InternalAppInsightsCore: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_11__.AppInsightsCore),
/* harmony export */   LoggingSeverity: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_9__.LoggingSeverity),
/* harmony export */   MinChannelPriorty: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.MinChannelPriorty),
/* harmony export */   NotificationManager: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.NotificationManager),
/* harmony export */   PerfEvent: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_10__.PerfEvent),
/* harmony export */   PerfManager: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_10__.PerfManager),
/* harmony export */   ProcessTelemetryContext: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.ProcessTelemetryContext),
/* harmony export */   TraceLevel: () => (/* reexport safe */ _Enums__WEBPACK_IMPORTED_MODULE_0__.TraceLevel),
/* harmony export */   Undefined: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_35__.strShimUndefined),
/* harmony export */   ValueKind: () => (/* reexport safe */ _Enums__WEBPACK_IMPORTED_MODULE_0__.ValueKind),
/* harmony export */   ValueSanitizer: () => (/* reexport safe */ _ValueSanitizer__WEBPACK_IMPORTED_MODULE_2__.ValueSanitizer),
/* harmony export */   Version: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.Version),
/* harmony export */   _InternalLogMessage: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__._InternalLogMessage),
/* harmony export */   __getRegisteredEvents: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_15__.__getRegisteredEvents),
/* harmony export */   _logInternalMessage: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__._logInternalMessage),
/* harmony export */   _throwInternal: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__._throwInternal),
/* harmony export */   _warnToConsole: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__._warnToConsole),
/* harmony export */   addEventHandler: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_15__.addEventHandler),
/* harmony export */   addEventListeners: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_15__.addEventListeners),
/* harmony export */   addPageHideEventListener: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_15__.addPageHideEventListener),
/* harmony export */   addPageShowEventListener: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_15__.addPageShowEventListener),
/* harmony export */   addPageUnloadEventListener: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_15__.addPageUnloadEventListener),
/* harmony export */   areCookiesSupported: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_36__.areCookiesSupported),
/* harmony export */   arrForEach: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_21__.arrForEach),
/* harmony export */   arrIndexOf: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__.arrIndexOf),
/* harmony export */   arrMap: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_23__.arrMap),
/* harmony export */   arrReduce: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_24__.arrReduce),
/* harmony export */   attachEvent: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_15__.attachEvent),
/* harmony export */   blockDynamicConversion: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_41__.blockDynamicConversion),
/* harmony export */   cookieAvailable: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_36__.areCookiesSupported),
/* harmony export */   createCookieMgr: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_36__.createCookieMgr),
/* harmony export */   createDynamicConfig: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_40__.createDynamicConfig),
/* harmony export */   createEnumStyle: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_12__.createEnumStyle),
/* harmony export */   createGuid: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.createGuid),
/* harmony export */   createProcessTelemetryContext: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__.createProcessTelemetryContext),
/* harmony export */   createTraceParent: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_39__.createTraceParent),
/* harmony export */   createUniqueNamespace: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_37__.createUniqueNamespace),
/* harmony export */   createUnloadHandlerContainer: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_38__.createUnloadHandlerContainer),
/* harmony export */   dateNow: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_27__.utcNow),
/* harmony export */   detachEvent: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_15__.detachEvent),
/* harmony export */   disallowsSameSiteNone: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_36__.uaDisallowsSameSiteNone),
/* harmony export */   doPerf: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_10__.doPerf),
/* harmony export */   dumpObj: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_34__.dumpObj),
/* harmony export */   eventOff: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_15__.eventOff),
/* harmony export */   eventOn: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_15__.eventOn),
/* harmony export */   extend: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.extend),
/* harmony export */   findW3cTraceParent: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_39__.findW3cTraceParent),
/* harmony export */   forceDynamicConversion: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_41__.forceDynamicConversion),
/* harmony export */   formatTraceParent: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_39__.formatTraceParent),
/* harmony export */   generateW3CId: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_29__.generateW3CId),
/* harmony export */   getCommonSchemaMetaData: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.getCommonSchemaMetaData),
/* harmony export */   getConsole: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_33__.getConsole),
/* harmony export */   getCookieValue: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.getCookieValue),
/* harmony export */   getCrypto: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_33__.getCrypto),
/* harmony export */   getDocument: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_32__.getDocument),
/* harmony export */   getDynamicConfigHandler: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_41__.getDynamicConfigHandler),
/* harmony export */   getExceptionName: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__.getExceptionName),
/* harmony export */   getFieldValueType: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.getFieldValueType),
/* harmony export */   getGlobal: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_32__.getGlobal),
/* harmony export */   getGlobalInst: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_32__.getInst),
/* harmony export */   getHistory: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_32__.getHistory),
/* harmony export */   getIEVersion: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_33__.getIEVersion),
/* harmony export */   getISOString: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__.toISOString),
/* harmony export */   getJSON: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_33__.getJSON),
/* harmony export */   getLocation: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_33__.getLocation),
/* harmony export */   getMsCrypto: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_33__.getMsCrypto),
/* harmony export */   getNavigator: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_32__.getNavigator),
/* harmony export */   getPerformance: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_30__.getPerformance),
/* harmony export */   getSetValue: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__.getSetValue),
/* harmony export */   getTenantId: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.getTenantId),
/* harmony export */   getTime: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.getTime),
/* harmony export */   getWindow: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_32__.getWindow),
/* harmony export */   hasDocument: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_32__.hasDocument),
/* harmony export */   hasHistory: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_32__.hasHistory),
/* harmony export */   hasJSON: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_33__.hasJSON),
/* harmony export */   hasNavigator: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_32__.hasNavigator),
/* harmony export */   hasOwnProperty: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_14__.objHasOwnProperty),
/* harmony export */   hasWindow: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_32__.hasWindow),
/* harmony export */   isArray: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_13__.isArray),
/* harmony export */   isArrayValid: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.isArrayValid),
/* harmony export */   isBeaconsSupported: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_33__.isBeaconsSupported),
/* harmony export */   isBoolean: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_13__.isBoolean),
/* harmony export */   isChromium: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.isChromium),
/* harmony export */   isDate: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_13__.isDate),
/* harmony export */   isDocumentObjectAvailable: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.isDocumentObjectAvailable),
/* harmony export */   isError: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_13__.isError),
/* harmony export */   isFetchSupported: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_33__.isFetchSupported),
/* harmony export */   isFunction: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_13__.isFunction),
/* harmony export */   isGreaterThanZero: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.isGreaterThanZero),
/* harmony export */   isIE: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_33__.isIE),
/* harmony export */   isLatency: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.isLatency),
/* harmony export */   isNotTruthy: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_13__.isNotTruthy),
/* harmony export */   isNullOrUndefined: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_13__.isNullOrUndefined),
/* harmony export */   isNumber: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_13__.isNumber),
/* harmony export */   isObject: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_13__.isObject),
/* harmony export */   isReactNative: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_33__.isReactNative),
/* harmony export */   isSampledFlag: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_39__.isSampledFlag),
/* harmony export */   isString: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_13__.isString),
/* harmony export */   isTruthy: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_13__.isTruthy),
/* harmony export */   isTypeof: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_13__.isTypeof),
/* harmony export */   isUint8ArrayAvailable: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.isUint8ArrayAvailable),
/* harmony export */   isUndefined: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_13__.isUndefined),
/* harmony export */   isValidSpanId: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_39__.isValidSpanId),
/* harmony export */   isValidTraceId: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_39__.isValidTraceId),
/* harmony export */   isValidTraceParent: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_39__.isValidTraceParent),
/* harmony export */   isValueAssigned: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.isValueAssigned),
/* harmony export */   isValueKind: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.isValueKind),
/* harmony export */   isWindowObjectAvailable: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.isWindowObjectAvailable),
/* harmony export */   isXhrSupported: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_33__.isXhrSupported),
/* harmony export */   mergeEvtNamespace: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_15__.mergeEvtNamespace),
/* harmony export */   newGuid: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_29__.newGuid),
/* harmony export */   newId: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_31__.newId),
/* harmony export */   normalizeJsName: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__.normalizeJsName),
/* harmony export */   objDefineAccessors: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_26__.objDefineAccessors),
/* harmony export */   objForEachKey: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_17__.objForEachKey),
/* harmony export */   objFreeze: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_25__.objFreeze),
/* harmony export */   objKeys: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_25__.objKeys),
/* harmony export */   objSeal: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_25__.objSeal),
/* harmony export */   onConfigChange: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_40__.onConfigChange),
/* harmony export */   openXhr: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.openXhr),
/* harmony export */   optimizeObject: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__.optimizeObject),
/* harmony export */   parseTraceParent: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_39__.parseTraceParent),
/* harmony export */   perfNow: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_30__.perfNow),
/* harmony export */   proxyAssign: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__.proxyAssign),
/* harmony export */   proxyFunctionAs: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__.proxyFunctionAs),
/* harmony export */   proxyFunctions: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__.proxyFunctions),
/* harmony export */   random32: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_31__.random32),
/* harmony export */   randomValue: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_31__.randomValue),
/* harmony export */   removeEventHandler: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_15__.removeEventHandler),
/* harmony export */   removeEventListeners: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_15__.removeEventListeners),
/* harmony export */   removePageHideEventListener: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_15__.removePageHideEventListener),
/* harmony export */   removePageShowEventListener: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_15__.removePageShowEventListener),
/* harmony export */   removePageUnloadEventListener: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_15__.removePageUnloadEventListener),
/* harmony export */   safeGetCookieMgr: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_36__.safeGetCookieMgr),
/* harmony export */   safeGetLogger: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__.safeGetLogger),
/* harmony export */   sanitizeProperty: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.sanitizeProperty),
/* harmony export */   setEnableEnvMocks: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_33__.setEnableEnvMocks),
/* harmony export */   setProcessTelemetryTimings: () => (/* reexport safe */ _Utils__WEBPACK_IMPORTED_MODULE_42__.setProcessTelemetryTimings),
/* harmony export */   setValue: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__.setValue),
/* harmony export */   strContains: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__.strContains),
/* harmony export */   strEndsWith: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_19__.strEndsWith),
/* harmony export */   strFunction: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_35__.strShimFunction),
/* harmony export */   strObject: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_35__.strShimObject),
/* harmony export */   strPrototype: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_35__.strShimPrototype),
/* harmony export */   strStartsWith: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__.strStartsWith),
/* harmony export */   strTrim: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_20__.strTrim),
/* harmony export */   strUndefined: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_35__.strShimUndefined),
/* harmony export */   throwError: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_28__.throwError),
/* harmony export */   toISOString: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__.toISOString),
/* harmony export */   useXDomainRequest: () => (/* reexport safe */ _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_33__.useXDomainRequest)
/* harmony export */ });
/* harmony import */ var _AppInsightsCore__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5);
/* harmony import */ var _Enums__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(102);
/* harmony import */ var _ValueSanitizer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(104);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(89);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(94);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(90);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(108);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(109);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(67);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(110);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(46);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(69);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(103);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(13);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(18);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(111);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(33);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(15);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(57);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(88);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(86);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(37);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(58);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(107);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(112);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(35);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(12);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(41);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(19);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(42);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(40);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(43);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(7);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(31);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(26);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(23);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(84);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(48);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(95);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(92);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(47);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(51);
/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(21);
/*
 * 1DS JS SDK Core, 4.0.3
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
* Index.ts
* @author Abhilash Panwar (abpanwar)
* @copyright Microsoft 2018
* File to export public classes, interfaces and enums.
*/






//# sourceMappingURL=Index.js.map

/***/ }),
/* 5 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppInsightsCore: () => (/* binding */ AppInsightsCore)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(44);
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(19);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(46);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(47);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(26);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(67);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(69);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(35);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20);
/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(21);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(22);
/*
 * 1DS JS SDK Core, 4.0.3
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */

/**
* AppInsightsCore.ts
* @author Abhilash Panwar (abpanwar) Hector Hernandez (hectorh)
* @copyright Microsoft 2018
*/






/**
 * The default settings for the config.
 * WE MUST include all defaults here to ensure that the config is created with all of the properties
 * defined as dynamic.
 */
var defaultConfig = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.objDeepFreeze)({
    endpointUrl: _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_DEFAULT_ENDPOINT_URL,
    propertyStorageOverride: { isVal: _chkPropOverride }
});
function _chkPropOverride(propertyStorageOverride) {
    // Validate property storage override
    if (propertyStorageOverride && (!propertyStorageOverride.getProperty || !propertyStorageOverride.setProperty)) {
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_2__.throwError)("Invalid property storage override passed.");
    }
    return true;
}
/**
 * @group Classes
 * @group Entrypoint
 */
var AppInsightsCore = /** @class */ (function (_super) {
    (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_3__.__extendsFn)(AppInsightsCore, _super);
    function AppInsightsCore() {
        var _this = _super.call(this) || this;
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__["default"])(AppInsightsCore, _this, function (_self, _base) {
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_INITIALIZE /* @min:%2einitialize */] = function (config, extensions, logger, notificationManager) {
                (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.doPerf)(_self, function () { return "AppInsightsCore.initialize"; }, function () {
                    try {
                        _base[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_INITIALIZE /* @min:%2einitialize */]((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_7__.createDynamicConfig)(config, defaultConfig, logger || _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */], false).cfg, extensions, logger, notificationManager);
                    }
                    catch (e) {
                        var logger_1 = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */];
                        var message = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__.dumpObj)(e);
                        if (message[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_INDEX_OF /* @min:%2eindexOf */]("channels") !== -1) {
                            // Add some additional context to the underlying reported error
                            message += "\n - Channels must be provided through config.channels only!";
                        }
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_9__._throwInternal)(logger_1, 1 /* eLoggingSeverity.CRITICAL */, 514 /* _eExtendedInternalMessageId.FailedToInitializeSDK */, "SDK Initialization Failed - no telemetry will be sent: " + message);
                    }
                }, function () { return ({ config: config, extensions: extensions, logger: logger, notificationManager: notificationManager }); });
            };
            _self.track = function (item) {
                (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.doPerf)(_self, function () { return "AppInsightsCore.track"; }, function () {
                    var telemetryItem = item;
                    if (telemetryItem) {
                        telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_TIMINGS /* @min:%2etimings */] = telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_TIMINGS /* @min:%2etimings */] || {};
                        telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_TIMINGS /* @min:%2etimings */].trackStart = (0,_Utils__WEBPACK_IMPORTED_MODULE_10__.getTime)();
                        if (!(0,_Utils__WEBPACK_IMPORTED_MODULE_10__.isLatency)(telemetryItem.latency)) {
                            telemetryItem.latency = 1 /* EventLatencyValue.Normal */;
                        }
                        var itemExt = telemetryItem.ext = telemetryItem.ext || {};
                        itemExt.sdk = itemExt.sdk || {};
                        itemExt.sdk.ver = _Utils__WEBPACK_IMPORTED_MODULE_10__.FullVersionString;
                        var baseData = telemetryItem.baseData = telemetryItem.baseData || {};
                        baseData[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_PROPERTIES /* @min:%2eproperties */] = baseData[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_PROPERTIES /* @min:%2eproperties */] || {};
                        var itemProperties = baseData[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_PROPERTIES /* @min:%2eproperties */];
                        itemProperties[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_VERSION] = itemProperties[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_VERSION] || _self.pluginVersionString || _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
                    }
                    _base.track(telemetryItem);
                }, function () { return ({ item: item }); }, !(item.sync));
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_POLL_INTERNAL_LOGS /* @min:%2epollInternalLogs */] = function (eventName) {
                return _base[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_POLL_INTERNAL_LOGS /* @min:%2epollInternalLogs */](eventName || "InternalLog");
            };
        });
        return _this;
    }
// Removed Stub for AppInsightsCore.prototype.initialize.
// Removed Stub for AppInsightsCore.prototype.track.
// Removed Stub for AppInsightsCore.prototype.pollInternalLogs.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    AppInsightsCore.__ieDyn=1;

    return AppInsightsCore;
}(_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_11__.AppInsightsCore));

//# sourceMappingURL=AppInsightsCore.js.map

/***/ }),
/* 6 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ dynamicProto)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(18);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(19);
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var _a;

;
var UNDEFINED = "undefined";
/**
 * Constant string defined to support minimization
 * @ignore
 */
var Constructor = 'constructor';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var Prototype = 'prototype';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var strFunction = 'function';
/**
 * Used to define the name of the instance function lookup table
 * @ignore
 */
var DynInstFuncTable = '_dynInstFuncs';
/**
 * Name used to tag the dynamic prototype function
 * @ignore
 */
var DynProxyTag = '_isDynProxy';
/**
 * Name added to a prototype to define the dynamic prototype "class" name used to lookup the function table
 * @ignore
 */
var DynClassName = '_dynClass';
/**
 * Prefix added to the classname to avoid any name clashes with other instance level properties
 * @ignore
 */
var DynClassNamePrefix = '_dynCls$';
/**
 * A tag which is used to check if we have already to attempted to set the instance function if one is not present
 * @ignore
 */
var DynInstChkTag = '_dynInstChk';
/**
 * A tag which is used to check if we are allows to try and set an instance function is one is not present. Using the same
 * tag name as the function level but a different const name for readability only.
 */
var DynAllowInstChkTag = DynInstChkTag;
/**
 * The global (imported) instances where the global performance options are stored
 */
var DynProtoDefaultOptions = '_dfOpts';
/**
 * Value used as the name of a class when it cannot be determined
 * @ignore
 */
var UnknownValue = '_unknown_';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var str__Proto = "__proto__";
/**
 * The polyfill version of __proto__ so that it doesn't cause issues for anyone not expecting it to exist
 */
var DynProtoBaseProto = "_dyn" + str__Proto;
/**
 * Runtime Global holder for dynamicProto settings
 */
var DynProtoGlobalSettings = "__dynProto$Gbl";
/**
 * Track the current prototype for IE8 as you can't look back to get the prototype
 */
var DynProtoCurrent = "_dynInstProto";
/**
 * Constant string defined to support minimization
 * @ignore
 */
var strUseBaseInst = 'useBaseInst';
/**
 * Constant string defined to support minimization
 * @ignore
 */
var strSetInstFuncs = 'setInstFuncs';
var Obj = Object;
/**
 * Pre-lookup to check if we are running on a modern browser (i.e. not IE8)
 * @ignore
 */
var _objGetPrototypeOf = Obj["getPrototypeOf"];
/**
 * Pre-lookup to check for the existence of this function
 */
var _objGetOwnProps = Obj["getOwnPropertyNames"];
// Since 1.1.7 moving these to the runtime global to work around mixed version and module issues
// See Issue https://github.com/microsoft/DynamicProto-JS/issues/57 for details
var _gbl = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.getGlobal)();
var _gblInst = _gbl[DynProtoGlobalSettings] || (_gbl[DynProtoGlobalSettings] = {
    o: (_a = {},
        _a[strSetInstFuncs] = true,
        _a[strUseBaseInst] = true,
        _a),
    n: 1000 // Start new global index @ 1000 so we "fix" some cases when mixed with 1.1.6 or earlier
});
/**
 * Helper used to check whether the target is an Object prototype or Array prototype
 * @ignore
 */
function _isObjectOrArrayPrototype(target) {
    return target && (target === Obj[Prototype] || target === Array[Prototype]);
}
/**
 * Helper used to check whether the target is an Object prototype, Array prototype or Function prototype
 * @ignore
 */
function _isObjectArrayOrFunctionPrototype(target) {
    return _isObjectOrArrayPrototype(target) || target === Function[Prototype];
}
/**
 * Helper used to get the prototype of the target object as getPrototypeOf is not available in an ES3 environment.
 * @ignore
 */
function _getObjProto(target) {
    var newProto;
    if (target) {
        // This method doesn't exist in older browsers (e.g. IE8)
        if (_objGetPrototypeOf) {
            return _objGetPrototypeOf(target);
        }
        var curProto = target[str__Proto] || target[Prototype] || (target[Constructor] ? target[Constructor][Prototype] : null);
        // Using the pre-calculated value as IE8 doesn't support looking up the prototype of a prototype and thus fails for more than 1 base class
        newProto = target[DynProtoBaseProto] || curProto;
        if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(target, DynProtoBaseProto)) {
            // As this prototype doesn't have this property then this is from an inherited class so newProto is the base to return so save it
            // so we can look it up value (which for a multiple hierarchy dynamicProto will be the base class)
            delete target[DynProtoCurrent]; // Delete any current value allocated to this instance so we pick up the value from prototype hierarchy
            newProto = target[DynProtoBaseProto] = target[DynProtoCurrent] || target[DynProtoBaseProto];
            target[DynProtoCurrent] = curProto;
        }
    }
    return newProto;
}
/**
 * Helper to get the properties of an object, including none enumerable ones as functions on a prototype in ES6
 * are not enumerable.
 * @param target
 */
function _forEachProp(target, func) {
    var props = [];
    if (_objGetOwnProps) {
        props = _objGetOwnProps(target);
    }
    else {
        for (var name_1 in target) {
            if (typeof name_1 === "string" && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(target, name_1)) {
                props.push(name_1);
            }
        }
    }
    if (props && props.length > 0) {
        for (var lp = 0; lp < props.length; lp++) {
            func(props[lp]);
        }
    }
}
/**
 * Helper function to check whether the provided function name is a potential candidate for dynamic
 * callback and prototype generation.
 * @param target The target object, may be a prototype or class object
 * @param funcName The function name
 * @param skipOwn Skips the check for own property
 * @ignore
 */
function _isDynamicCandidate(target, funcName, skipOwn) {
    return (funcName !== Constructor && typeof target[funcName] === strFunction && (skipOwn || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(target, funcName)));
}
/**
 * Helper to throw a TypeError exception
 * @param message the message
 * @ignore
 */
function _throwTypeError(message) {
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.throwTypeError)("DynamicProto: " + message);
}
/**
 * Returns a collection of the instance functions that are defined directly on the thisTarget object, it does
 * not return any inherited functions
 * @param thisTarget The object to get the instance functions from
 * @ignore
 */
function _getInstanceFuncs(thisTarget) {
    // Get the base proto
    var instFuncs = {};
    // Save any existing instance functions
    _forEachProp(thisTarget, function (name) {
        // Don't include any dynamic prototype instances - as we only want the real functions
        if (!instFuncs[name] && _isDynamicCandidate(thisTarget, name, false)) {
            // Create an instance callback for passing the base function to the caller
            instFuncs[name] = thisTarget[name];
        }
    });
    return instFuncs;
}
/**
 * Returns whether the value is included in the array
 * @param values The array of values
 * @param value  The value
 */
function _hasVisited(values, value) {
    for (var lp = values.length - 1; lp >= 0; lp--) {
        if (values[lp] === value) {
            return true;
        }
    }
    return false;
}
/**
 * Returns an object that contains callback functions for all "base/super" functions, this is used to "save"
 * enabling calling super.xxx() functions without requiring that the base "class" has defined a prototype references
 * @param target The current instance
 * @ignore
 */
function _getBaseFuncs(classProto, thisTarget, instFuncs, useBaseInst) {
    function _instFuncProxy(target, funcHost, funcName) {
        var theFunc = funcHost[funcName];
        if (theFunc[DynProxyTag] && useBaseInst) {
            // grab and reuse the hosted looking function (if available) otherwise the original passed function
            var instFuncTable = target[DynInstFuncTable] || {};
            if (instFuncTable[DynAllowInstChkTag] !== false) {
                theFunc = (instFuncTable[funcHost[DynClassName]] || {})[funcName] || theFunc;
            }
        }
        return function () {
            // eslint-disable-next-line prefer-rest-params
            return theFunc.apply(target, arguments);
        };
    }
    // Start creating a new baseFuncs by creating proxies for the instance functions (as they may get replaced)
    var baseFuncs = {};
    _forEachProp(instFuncs, function (name) {
        // Create an instance callback for passing the base function to the caller
        baseFuncs[name] = _instFuncProxy(thisTarget, instFuncs, name);
    });
    // Get the base prototype functions
    var baseProto = _getObjProto(classProto);
    var visited = [];
    // Don't include base object functions for Object, Array or Function
    while (baseProto && !_isObjectArrayOrFunctionPrototype(baseProto) && !_hasVisited(visited, baseProto)) {
        // look for prototype functions
        _forEachProp(baseProto, function (name) {
            // Don't include any dynamic prototype instances - as we only want the real functions
            // For IE 7/8 the prototype lookup doesn't provide the full chain so we need to bypass the 
            // hasOwnProperty check we get all of the methods, main difference is that IE7/8 doesn't return
            // the Object prototype methods while bypassing the check
            if (!baseFuncs[name] && _isDynamicCandidate(baseProto, name, !_objGetPrototypeOf)) {
                // Create an instance callback for passing the base function to the caller
                baseFuncs[name] = _instFuncProxy(thisTarget, baseProto, name);
            }
        });
        // We need to find all possible functions that might be overloaded by walking the entire prototype chain
        // This avoids the caller from needing to check whether it's direct base class implements the function or not
        // by walking the entire chain it simplifies the usage and issues from upgrading any of the base classes.
        visited.push(baseProto);
        baseProto = _getObjProto(baseProto);
    }
    return baseFuncs;
}
function _getInstFunc(target, funcName, proto, currentDynProtoProxy) {
    var instFunc = null;
    // We need to check whether the class name is defined directly on this prototype otherwise
    // it will walk the proto chain and return any parent proto classname.
    if (target && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(proto, DynClassName)) {
        var instFuncTable = target[DynInstFuncTable] || {};
        instFunc = (instFuncTable[proto[DynClassName]] || {})[funcName];
        if (!instFunc) {
            // Avoid stack overflow from recursive calling the same function
            _throwTypeError("Missing [" + funcName + "] " + strFunction);
        }
        // We have the instance function, lets check it we can speed up further calls
        // by adding the instance function back directly on the instance (avoiding the dynamic func lookup)
        if (!instFunc[DynInstChkTag] && instFuncTable[DynAllowInstChkTag] !== false) {
            // If the instance already has an instance function we can't replace it
            var canAddInst = !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(target, funcName);
            // Get current prototype
            var objProto = _getObjProto(target);
            var visited = [];
            // Lookup the function starting at the top (instance level prototype) and traverse down, if the first matching function
            // if nothing is found or if the first hit is a dynamic proto instance then we can safely add an instance shortcut
            while (canAddInst && objProto && !_isObjectArrayOrFunctionPrototype(objProto) && !_hasVisited(visited, objProto)) {
                var protoFunc = objProto[funcName];
                if (protoFunc) {
                    canAddInst = (protoFunc === currentDynProtoProxy);
                    break;
                }
                // We need to find all possible initial functions to ensure that we don't bypass a valid override function
                visited.push(objProto);
                objProto = _getObjProto(objProto);
            }
            try {
                if (canAddInst) {
                    // This instance doesn't have an instance func and the class hierarchy does have a higher level prototype version
                    // so it's safe to directly assign for any subsequent calls (for better performance)
                    target[funcName] = instFunc;
                }
                // Block further attempts to set the instance function for any
                instFunc[DynInstChkTag] = 1;
            }
            catch (e) {
                // Don't crash if the object is readonly or the runtime doesn't allow changing this
                // And set a flag so we don't try again for any function
                instFuncTable[DynAllowInstChkTag] = false;
            }
        }
    }
    return instFunc;
}
function _getProtoFunc(funcName, proto, currentDynProtoProxy) {
    var protoFunc = proto[funcName];
    // Check that the prototype function is not a self reference -- try to avoid stack overflow!
    if (protoFunc === currentDynProtoProxy) {
        // It is so lookup the base prototype
        protoFunc = _getObjProto(proto)[funcName];
    }
    if (typeof protoFunc !== strFunction) {
        _throwTypeError("[" + funcName + "] is not a " + strFunction);
    }
    return protoFunc;
}
/**
 * Add the required dynamic prototype methods to the the class prototype
 * @param proto - The class prototype
 * @param className - The instance classname
 * @param target - The target instance
 * @param baseInstFuncs - The base instance functions
 * @param setInstanceFunc - Flag to allow prototype function to reset the instance function if one does not exist
 * @ignore
 */
function _populatePrototype(proto, className, target, baseInstFuncs, setInstanceFunc) {
    function _createDynamicPrototype(proto, funcName) {
        var dynProtoProxy = function () {
            // Use the instance or prototype function
            var instFunc = _getInstFunc(this, funcName, proto, dynProtoProxy) || _getProtoFunc(funcName, proto, dynProtoProxy);
            // eslint-disable-next-line prefer-rest-params
            return instFunc.apply(this, arguments);
        };
        // Tag this function as a proxy to support replacing dynamic proxy elements (primary use case is for unit testing
        // via which can dynamically replace the prototype function reference)
        dynProtoProxy[DynProxyTag] = 1;
        return dynProtoProxy;
    }
    if (!_isObjectOrArrayPrototype(proto)) {
        var instFuncTable = target[DynInstFuncTable] = target[DynInstFuncTable] || {};
        var instFuncs_1 = instFuncTable[className] = (instFuncTable[className] || {}); // fetch and assign if as it may not exist yet
        // Set whether we are allow to lookup instances, if someone has set to false then do not re-enable
        if (instFuncTable[DynAllowInstChkTag] !== false) {
            instFuncTable[DynAllowInstChkTag] = !!setInstanceFunc;
        }
        _forEachProp(target, function (name) {
            // Only add overridden functions
            if (_isDynamicCandidate(target, name, false) && target[name] !== baseInstFuncs[name]) {
                // Save the instance Function to the lookup table and remove it from the instance as it's not a dynamic proto function
                instFuncs_1[name] = target[name];
                delete target[name];
                // Add a dynamic proto if one doesn't exist or if a prototype function exists and it's not a dynamic one
                if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(proto, name) || (proto[name] && !proto[name][DynProxyTag])) {
                    proto[name] = _createDynamicPrototype(proto, name);
                }
            }
        });
    }
}
/**
 * Checks whether the passed prototype object appears to be correct by walking the prototype hierarchy of the instance
 * @param classProto The class prototype instance
 * @param thisTarget The current instance that will be checked whether the passed prototype instance is in the hierarchy
 * @ignore
 */
function _checkPrototype(classProto, thisTarget) {
    // This method doesn't existing in older browsers (e.g. IE8)
    if (_objGetPrototypeOf) {
        // As this is primarily a coding time check, don't bother checking if running in IE8 or lower
        var visited = [];
        var thisProto = _getObjProto(thisTarget);
        while (thisProto && !_isObjectArrayOrFunctionPrototype(thisProto) && !_hasVisited(visited, thisProto)) {
            if (thisProto === classProto) {
                return true;
            }
            // This avoids the caller from needing to check whether it's direct base class implements the function or not
            // by walking the entire chain it simplifies the usage and issues from upgrading any of the base classes.
            visited.push(thisProto);
            thisProto = _getObjProto(thisProto);
        }
        return false;
    }
    // If objGetPrototypeOf doesn't exist then just assume everything is ok.
    return true;
}
/**
 * Gets the current prototype name using the ES6 name if available otherwise falling back to a use unknown as the name.
 * It's not critical for this to return a name, it's used to decorate the generated unique name for easier debugging only.
 * @param target
 * @param unknownValue
 * @ignore
 */
function _getObjName(target, unknownValue) {
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(target, Prototype)) {
        // Look like a prototype
        return target.name || unknownValue || UnknownValue;
    }
    return (((target || {})[Constructor]) || {}).name || unknownValue || UnknownValue;
}
/**
 * Helper function when creating dynamic (inline) functions for classes, this helper performs the following tasks :-
 * - Saves references to all defined base class functions
 * - Calls the delegateFunc with the current target (this) and a base object reference that can be used to call all "super" functions.
 * - Will populate the class prototype for all overridden functions to support class extension that call the prototype instance.
 * Callers should use this helper when declaring all function within the constructor of a class, as mentioned above the delegateFunc is
 * passed both the target "this" and an object that can be used to call any base (super) functions, using this based object in place of
 * super.XXX() (which gets expanded to _super.prototype.XXX()) provides a better minification outcome and also ensures the correct "this"
 * context is maintained as TypeScript creates incorrect references using super.XXXX() for dynamically defined functions i.e. Functions
 * defined in the constructor or some other function (rather than declared as complete typescript functions).
 * ### Usage
 * ```typescript
 * import dynamicProto from "@microsoft/dynamicproto-js";
 * class ExampleClass extends BaseClass {
 *     constructor() {
 *         dynamicProto(ExampleClass, this, (_self, base) => {
 *             // This will define a function that will be converted to a prototype function
 *             _self.newFunc = () => {
 *                 // Access any "this" instance property
 *                 if (_self.someProperty) {
 *                     ...
 *                 }
 *             }
 *             // This will define a function that will be converted to a prototype function
 *             _self.myFunction = () => {
 *                 // Access any "this" instance property
 *                 if (_self.someProperty) {
 *                     // Call the base version of the function that we are overriding
 *                     base.myFunction();
 *                 }
 *                 ...
 *             }
 *             _self.initialize = () => {
 *                 ...
 *             }
 *             // Warnings: While the following will work as _self is simply a reference to
 *             // this, if anyone overrides myFunction() the overridden will be called first
 *             // as the normal JavaScript method resolution will occur and the defined
 *             // _self.initialize() function is actually gets removed from the instance and
 *             // a proxy prototype version is created to reference the created method.
 *             _self.initialize();
 *         });
 *     }
 * }
 * ```
 * @typeparam DPType This is the generic type of the class, used to keep intellisense valid
 * @typeparam DPCls The type that contains the prototype of the current class
 * @param theClass - This is the current class instance which contains the prototype for the current class
 * @param target - The current "this" (target) reference, when the class has been extended this.prototype will not be the 'theClass' value.
 * @param delegateFunc - The callback function (closure) that will create the dynamic function
 * @param options - Additional options to configure how the dynamic prototype operates
 */
function dynamicProto(theClass, target, delegateFunc, options) {
    // Make sure that the passed theClass argument looks correct
    if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(theClass, Prototype)) {
        _throwTypeError("theClass is an invalid class definition.");
    }
    // Quick check to make sure that the passed theClass argument looks correct (this is a common copy/paste error)
    var classProto = theClass[Prototype];
    if (!_checkPrototype(classProto, target)) {
        _throwTypeError("[" + _getObjName(theClass) + "] not in hierarchy of [" + _getObjName(target) + "]");
    }
    var className = null;
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(classProto, DynClassName)) {
        // Only grab the class name if it's defined on this prototype (i.e. don't walk the prototype chain)
        className = classProto[DynClassName];
    }
    else {
        // As not all browser support name on the prototype creating a unique dynamic one if we have not already
        // assigned one, so we can use a simple string as the lookup rather than an object for the dynamic instance
        // function table lookup.
        className = DynClassNamePrefix + _getObjName(theClass, "_") + "$" + _gblInst.n;
        _gblInst.n++;
        classProto[DynClassName] = className;
    }
    var perfOptions = dynamicProto[DynProtoDefaultOptions];
    var useBaseInst = !!perfOptions[strUseBaseInst];
    if (useBaseInst && options && options[strUseBaseInst] !== undefined) {
        useBaseInst = !!options[strUseBaseInst];
    }
    // Get the current instance functions
    var instFuncs = _getInstanceFuncs(target);
    // Get all of the functions for any base instance (before they are potentially overridden)
    var baseFuncs = _getBaseFuncs(classProto, target, instFuncs, useBaseInst);
    // Execute the delegate passing in both the current target "this" and "base" function references
    // Note casting the same type as we don't actually have the base class here and this will provide some intellisense support
    delegateFunc(target, baseFuncs);
    // Don't allow setting instance functions for older IE instances
    var setInstanceFunc = !!_objGetPrototypeOf && !!perfOptions[strSetInstFuncs];
    if (setInstanceFunc && options) {
        setInstanceFunc = !!options[strSetInstFuncs];
    }
    // Populate the Prototype for any overridden instance functions
    _populatePrototype(classProto, className, target, instFuncs, setInstanceFunc !== false);
}
/**
 * Exposes the default global options to allow global configuration, if the global values are disabled these will override
 * any passed values. This is primarily exposed to support unit-testing without the need for individual classes to expose
 * their internal usage of dynamic proto.
 */
dynamicProto[DynProtoDefaultOptions] = _gblInst.o;
//# sourceMappingURL=DynamicProto.js.map

/***/ }),
/* 7 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getDocument: () => (/* binding */ getDocument),
/* harmony export */   getGlobal: () => (/* binding */ getGlobal),
/* harmony export */   getHistory: () => (/* binding */ getHistory),
/* harmony export */   getInst: () => (/* binding */ getInst),
/* harmony export */   getNavigator: () => (/* binding */ getNavigator),
/* harmony export */   getWindow: () => (/* binding */ getWindow),
/* harmony export */   hasDocument: () => (/* binding */ hasDocument),
/* harmony export */   hasHistory: () => (/* binding */ hasHistory),
/* harmony export */   hasNavigator: () => (/* binding */ hasNavigator),
/* harmony export */   hasWindow: () => (/* binding */ hasWindow),
/* harmony export */   isNode: () => (/* binding */ isNode),
/* harmony export */   isWebWorker: () => (/* binding */ isWebWorker),
/* harmony export */   lazySafeGetInst: () => (/* binding */ lazySafeGetInst)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _internal_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9);
/* harmony import */ var _safe_lazy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10);
/* harmony import */ var _lazy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */




var WINDOW = "window";
var _cachedGlobal;
var _cachedWindow;
var _cachedDocument;
var _cachedNavigator;
var _cachedHistory;
var _isWebWorker;
var _isNode;
/**
 * Create and return an readonly {@link ILazyValue} instance which will cache and return the named global
 * value if available, will return `null` if the named global object is not available or if the runtime
 * throws an exception when attempting to access the global object.
 * Unlike {@link getInst} the value is cached after the first access, so if the global value changes after
 * the initial fetch the original cached value is still returned.
 * @since 0.9.5
 * @group Environment
 * @group Lazy
 * @group Safe
 * @param name The name of the global object to get.
 * @returns A new readonly {@link ILazyValue} instance which will lazily attempt to return the globally
 * available named instance.
 * @example
 * ```ts
 * // This does not cause the evaluation to occur
 * window.myGlobal = "Hello";
 * let cachedValue = lazySafeGetInst("myGlobal");
 * // cachedValue.v === "Hello"
 *
 * window.myGlobal = "Darkness";
 * // cachedValue.v === "Hello"
 *
 * let promiseCls = lazySafeGetInst("Promise");
 * // null if Promise is not supported in the runtime
 * // otherwise the Promise class.
 * ```
 */
var lazySafeGetInst = function (name) { return (0,_safe_lazy__WEBPACK_IMPORTED_MODULE_0__.safeGetLazy)(function () { return getInst(name) || _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE; }, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE); };
/**
 * Returns the current global scope object, for a normal web page this will be the current
 * window, for a Web Worker this will be current worker global scope via "self". The internal
 * implementation returns the first available instance object in the following order
 * - globalThis (New standard)
 * - self (Will return the current window instance for supported browsers)
 * - window (fallback for older browser implementations)
 * - global (NodeJS standard)
 * - <null> (When all else fails)
 * While the return type is a Window for the normal case, not all environments will support all
 * of the properties or functions. And this caches the lookup of the global as in some environments
 * this can be an expensive operation.
 * @group Environment
 * @param useCached - [Optional] used for testing to bypass the cached lookup, when `true` this will
 * cause the cached global to be reset.
 */
var getGlobal = function (useCached) {
    (!_cachedGlobal || useCached === false || (_lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks && _lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks.lzy && !_cachedGlobal.b)) && (_cachedGlobal = (0,_safe_lazy__WEBPACK_IMPORTED_MODULE_0__.safeGetLazy)(_internal_global__WEBPACK_IMPORTED_MODULE_3__._getGlobalValue, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NULL_VALUE));
    return _cachedGlobal.v;
};
/**
 * Return the named global object if available, will return null if the object is not available.
 * @group Environment
 * @param name The globally named object
 * @param useCached - [Optional] used for testing to bypass the cached lookup, when `true` this will
 * cause the cached global to be reset.
 * @example
 * ```ts
 * // This does not cause the evaluation to occur
 * window.myGlobal = "Hello";
 * let cachedValue = getInst("myGlobal");
 * // cachedValue === "Hello"
 *
 * window.myGlobal = "Darkness";
 * // getInst("myGlobal") === "Darkness"
 *
 * let promiseCls = getInst("Promise");
 * // May throw if the global is not supported by the runtime
 * // otherwise the Promise class.
 * ```
 */
var getInst = function (name, useCached) {
    var gbl = (!_cachedGlobal || useCached === false) ? getGlobal(useCached) : _cachedGlobal.v;
    if (gbl && gbl[name]) {
        return gbl[name];
    }
    // Test workaround, for environments where <global>.window (when global == window) doesn't return the base window
    if (name === WINDOW && _cachedWindow) {
        // tslint:disable-next-line: no-angle-bracket-type-assertion
        return _cachedWindow.v;
    }
    return _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NULL_VALUE;
};
/**
 * Identify whether the runtime contains a `document` object
 * @group Environment
 * @returns - True if a `document` exists
 */
var hasDocument = function () { return !!getDocument(); };
/**
 * Return the global `document` instance.
 * @group Environment
 * @returns
 */
var getDocument = function () {
    (!_cachedDocument || (_lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks && _lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks.lzy && !_cachedDocument.b)) && (_cachedDocument = lazySafeGetInst("document"));
    return _cachedDocument.v;
};
/**
 * Identify whether the runtime contains a `window` object
 * @group Environment
 * @returns
 */
var hasWindow = function () { return !!getWindow(); };
/**
 * Return the global `window` instance.
 * @group Environment
 * @returns
 */
var getWindow = function () {
    (!_cachedWindow || (_lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks && _lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks.lzy && !_cachedWindow.b)) && (_cachedWindow = lazySafeGetInst(WINDOW));
    return _cachedWindow.v;
};
/**
 * Identify whether the runtimne contains a `navigator` object
 * @group Environment
 * @returns
 */
var hasNavigator = function () { return !!getNavigator(); };
/**
 * Returns the global `navigator` instance
 * @group Environment
 * @returns
 */
var getNavigator = function () {
    (!_cachedNavigator || (_lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks && _lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks.lzy && !_cachedNavigator.b)) && (_cachedNavigator = lazySafeGetInst("navigator"));
    return _cachedNavigator.v;
};
/**
 * Identifies whether the runtime contains a `history` object
 * @group Environment
 * @returns
 */
var hasHistory = function () { return !!getHistory(); };
/**
 * Returns the global `history` instance
 * @group Environment
 * @returns
 */
var getHistory = function () {
    (!_cachedHistory || (_lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks && _lazy__WEBPACK_IMPORTED_MODULE_2__._globalLazyTestHooks.lzy && !_cachedHistory.b)) && (_cachedHistory = lazySafeGetInst("history"));
    return _cachedHistory.v;
};
/**
 * Simple method to determine if we are running in a node environment
 * @group Environment
 * @returns True if you are
 */
var isNode = function () {
    !_isNode && (_isNode = (0,_safe_lazy__WEBPACK_IMPORTED_MODULE_0__.safeGetLazy)(function () { return !!(process && (process.versions || {}).node); }, false));
    return _isNode.v;
};
/**
 * Helper to identify if you are running as a Dedicated, Shared or Service worker
 * @group Environment
 * @returns True if the environment you are in looks like a Web Worker
 */
var isWebWorker = function () {
    !_isWebWorker && (_isWebWorker = (0,_safe_lazy__WEBPACK_IMPORTED_MODULE_0__.safeGetLazy)(function () { return !!(self && self instanceof WorkerGlobalScope); }, false));
    return _isWebWorker.v;
};
//# sourceMappingURL=environment.js.map

/***/ }),
/* 8 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ArrCls: () => (/* binding */ ArrCls),
/* harmony export */   ArrProto: () => (/* binding */ ArrProto),
/* harmony export */   BOOLEAN: () => (/* binding */ BOOLEAN),
/* harmony export */   CONSTRUCTOR: () => (/* binding */ CONSTRUCTOR),
/* harmony export */   DONE: () => (/* binding */ DONE),
/* harmony export */   EMPTY: () => (/* binding */ EMPTY),
/* harmony export */   FUNCTION: () => (/* binding */ FUNCTION),
/* harmony export */   INDEX_OF: () => (/* binding */ INDEX_OF),
/* harmony export */   LAST_INDEX_OF: () => (/* binding */ LAST_INDEX_OF),
/* harmony export */   LENGTH: () => (/* binding */ LENGTH),
/* harmony export */   MathCls: () => (/* binding */ MathCls),
/* harmony export */   NAME: () => (/* binding */ NAME),
/* harmony export */   NULL_VALUE: () => (/* binding */ NULL_VALUE),
/* harmony export */   NUMBER: () => (/* binding */ NUMBER),
/* harmony export */   OBJECT: () => (/* binding */ OBJECT),
/* harmony export */   ObjClass: () => (/* binding */ ObjClass),
/* harmony export */   ObjProto: () => (/* binding */ ObjProto),
/* harmony export */   POLYFILL_TAG: () => (/* binding */ POLYFILL_TAG),
/* harmony export */   PROTOTYPE: () => (/* binding */ PROTOTYPE),
/* harmony export */   SLICE: () => (/* binding */ SLICE),
/* harmony export */   STRING: () => (/* binding */ STRING),
/* harmony export */   SYMBOL: () => (/* binding */ SYMBOL),
/* harmony export */   StrCls: () => (/* binding */ StrCls),
/* harmony export */   StrProto: () => (/* binding */ StrProto),
/* harmony export */   UNDEFINED: () => (/* binding */ UNDEFINED),
/* harmony export */   UNDEF_VALUE: () => (/* binding */ UNDEF_VALUE),
/* harmony export */   VALUE: () => (/* binding */ VALUE),
/* harmony export */   __PROTO__: () => (/* binding */ __PROTO__)
/* harmony export */ });
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
// These constants are currently NOT exported directly, we may export them later associated with a frozen namespace (maybe)
// For now do NOT expect that we will export these values.
var UNDEF_VALUE = undefined;
var NULL_VALUE = null;
var EMPTY = "";
var BOOLEAN = "boolean";
var FUNCTION = "function";
var NUMBER = "number";
var OBJECT = "object";
var PROTOTYPE = "prototype";
var __PROTO__ = "__proto__";
var STRING = "string";
var UNDEFINED = "undefined";
var CONSTRUCTOR = "constructor";
var SYMBOL = "Symbol";
var POLYFILL_TAG = "_polyfill";
var INDEX_OF = "indexOf";
var LAST_INDEX_OF = "lastIndexOf";
var LENGTH = "length";
var DONE = "done";
var VALUE = "value";
var NAME = "name";
var SLICE = "slice";
/**
 * @ignore
 */
var ObjClass = Object;
/**
 * @ignore
 */
var ObjProto = ObjClass[PROTOTYPE];
/**
 * @ignore
 */
var StrCls = String;
/**
 * @ignore
 */
var StrProto = StrCls[PROTOTYPE];
/**
 * @ignore
 */
var MathCls = Math;
/**
 * @ignore
 */
var ArrCls = Array;
/**
 * @ignore
 */
var ArrProto = ArrCls[PROTOTYPE];
//# sourceMappingURL=constants.js.map

/***/ }),
/* 9 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _getGlobalConfig: () => (/* binding */ _getGlobalConfig),
/* harmony export */   _getGlobalValue: () => (/* binding */ _getGlobalValue)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

var GLOBAL_CONFIG_KEY = "__tsUtils$gblCfg";
var _globalCfg;
/**
 * @internal
 * @ignore
 * Helper to get the current global value
 * @returns
 */
function _getGlobalValue() {
    var result;
    if (typeof globalThis !== _constants__WEBPACK_IMPORTED_MODULE_0__.UNDEFINED) {
        result = globalThis;
    }
    if (!result && typeof self !== _constants__WEBPACK_IMPORTED_MODULE_0__.UNDEFINED) {
        result = self;
    }
    if (!result && typeof window !== _constants__WEBPACK_IMPORTED_MODULE_0__.UNDEFINED) {
        result = window;
    }
    if (!result && typeof __webpack_require__.g !== _constants__WEBPACK_IMPORTED_MODULE_0__.UNDEFINED) {
        result = __webpack_require__.g;
    }
    return result;
}
/**
 * @internal
 * @ignore
 * Gets/Sets the named value from the global config store, this is used to share configuration across
 * multiple modules. Primarily used for poly symbol and test hooks.
 * @returns The globally registered value.
 */
function _getGlobalConfig() {
    if (!_globalCfg) {
        var gbl = _getGlobalValue() || {};
        _globalCfg = gbl[GLOBAL_CONFIG_KEY] = gbl[GLOBAL_CONFIG_KEY] || {};
    }
    return _globalCfg;
}
//# sourceMappingURL=global.js.map

/***/ }),
/* 10 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   safeGetLazy: () => (/* binding */ safeGetLazy)
/* harmony export */ });
/* harmony import */ var _lazy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(11);
/* harmony import */ var _safe_get__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * Create and return an readonly {@link ILazyValue} instance which will cache and return the value returned
 * by the callback function. The callback function will only be called once, multiple access of the value
 * does not cause re-execution of the callback as the result from the first call is cached internally.
 * If the callback throws the default value will be returned.
 * @since 0.9.5
 * @group Lazy
 * @group Safe
 * @param cb - The callback function to fetch the value to be lazily evaluated and cached
 * @param defValue - The default value to return when an exception is thrown
 * @returns A new readonly {@link ILazyValue} instance which wraps the callback and will be used to cache
 * the result of the callback
 * @example
 * ```ts
 * // This does not cause the evaluation to occur
 * let cachedValue = safeGetLazy(() => callSomeExpensiveFunctionWhichMightThrow(), "someDefaultValue");
 * let theValue;
 *
 * // Just checking if there is an object still does not cause the evaluation
 * if (cachedValue) {
 *     // This will cause the evaluation to occur and the result will be cached
 *     theValue = cachedValue.v;
 * }
 *
 * // Accessing the value again will not cause the re-evaluation to occur, it will just return the same
 * // result value again.
 * theValue === cachedValue.v;  // true
 *
 * ```
 */
function safeGetLazy(cb, defValue) {
    return (0,_lazy__WEBPACK_IMPORTED_MODULE_0__.getLazy)(function () { return (0,_safe_get__WEBPACK_IMPORTED_MODULE_1__.safeGet)(cb, defValue); });
}
//# sourceMappingURL=safe_lazy.js.map

/***/ }),
/* 11 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _globalLazyTestHooks: () => (/* binding */ _globalLazyTestHooks),
/* harmony export */   getLazy: () => (/* binding */ getLazy),
/* harmony export */   getWritableLazy: () => (/* binding */ getWritableLazy),
/* harmony export */   setBypassLazyCache: () => (/* binding */ setBypassLazyCache)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _internal_global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9);
/* harmony import */ var _object_define__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */



/**
 * @internal
 * Internal flag which is set by the public {@link setBypassLazyCache}, should not be externally exported
 */
var _globalLazyTestHooks;
var _fetchLazyTestHooks = function () {
    _globalLazyTestHooks = (0,_internal_global__WEBPACK_IMPORTED_MODULE_0__._getGlobalConfig)();
    _fetchLazyTestHooks = _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NULL_VALUE;
};
/**
 * Create and return an readonly {@link ILazyValue} instance which will cache and return the value returned
 * by the callback function. The callback function will only be called once, multiple access of the value
 * does not cause re-execution of the callback as the result from the first call is cached internally.
 * @since 0.4.5
 * @group Lazy
 * @param cb - The callback function to fetch the value to be lazily evaluated and cached
 * @returns A new readonly {@link ILazyValue} instance which wraps the callback and will be used to cache
 * the result of the callback
 * @example
 * ```ts
 * // This does not cause the evaluation to occur
 * let cachedValue = getLazy(() => callSomeExpensiveFunction());
 * let theValue;
 *
 * // Just checking if there is an object still does not cause the evaluation
 * if (cachedValue) {
 *     // This will cause the evaluation to occur and the result will be cached
 *     theValue = cachedValue.v;
 * }
 *
 * // Accessing the value again will not cause the re-evaluation to occur, it will just return the same
 * // result value again.
 * theValue === cachedValue.v;  // true
 *
 * ```
 */
function getLazy(cb) {
    var lazyValue = {};
    _fetchLazyTestHooks && _fetchLazyTestHooks();
    lazyValue.b = _globalLazyTestHooks.lzy;
    (0,_object_define__WEBPACK_IMPORTED_MODULE_2__.objDefineProp)(lazyValue, "v", {
        configurable: true,
        get: function () {
            var result = cb();
            if (!_globalLazyTestHooks.lzy) {
                // Just replace the value
                (0,_object_define__WEBPACK_IMPORTED_MODULE_2__.objDefineProp)(lazyValue, "v", {
                    value: result
                });
                if (lazyValue.b) {
                    delete lazyValue.b;
                }
            }
            if (_globalLazyTestHooks.lzy && lazyValue.b !== _globalLazyTestHooks.lzy) {
                lazyValue.b = _globalLazyTestHooks.lzy;
            }
            return result;
        }
    });
    return lazyValue;
}
/**
 * Test Hook function used to cause the internal caching of objects to be bypassed, this should never
 * be enabled for production as it has additional performance impact caused by the repetitive creation
 * of the lazy wrappers.
 * @group Lazy
 * @since 0.5.0
 * @param newValue - When `true` will cause all new lazy implementations to bypass the cached lookup.
 */
function setBypassLazyCache(newValue) {
    _fetchLazyTestHooks && _fetchLazyTestHooks();
    _globalLazyTestHooks.lzy = newValue;
}
/**
 * Create and return a writable {@link ILazyValue} instance which will cache and return the value returned
 * by the callback function. The callback function will only be called once, multiple access of the value
 * does not cause re-execution of the callback as the result from the first call is cached internally. The
 * value may be set as many times as required, if the callback has not been called when you set the value
 * it will never get called.
 * @since 0.9.4
 * @group Lazy
 * @param cb - The callback function to fetch the value to be lazily evaluated and cached
 * @returns A new writable {@link ILazyValue} instance which wraps the callback and will be used to cache
 * the result of the callback
 * @example
 * ```ts
 * // This does not cause the evaluation to occur
 * let cachedValue = getWritableLazy(() => callSomeExpensiveFunction());
 * let theValue;
 *
 * // Just checking if there is an object still does not cause the evaluation
 * if (cachedValue) {
 *     // This will cause the evaluation to occur and the result will be cached
 *     theValue = cachedValue.v;
 * }
 *
 * // Accessing the value again will not cause the re-evaluation to occur, it will just return the same
 * // result value again.
 * theValue === cachedValue.v;  // true
 *
 * // Setting the value
 * let cachedValue = getWritableLazy(() => callSomeExpensiveFunction());
 * let theValue = "new Value";
 *
 * // Just checking if there is an object still does not cause the evaluation
 * if (cachedValue) {
 *     // This will set the value to be set explicitly and the callback
 *     // will now never occur and the result will be cached
 *     cachedValue.v = theValue;
 * }
 *
 * // Accessing the value again will cause the previously set value to be returned.
 * theValue === cachedValue.v;  // true
 * ```
 */
function getWritableLazy(cb) {
    var lazyValue = {};
    _fetchLazyTestHooks && _fetchLazyTestHooks();
    lazyValue.b = _globalLazyTestHooks.lzy;
    var _setValue = function (newValue) {
        // Just replace the value
        (0,_object_define__WEBPACK_IMPORTED_MODULE_2__.objDefineProp)(lazyValue, "v", {
            value: newValue,
            writable: true
        });
        if (lazyValue.b) {
            delete lazyValue.b;
        }
    };
    (0,_object_define__WEBPACK_IMPORTED_MODULE_2__.objDefineProp)(lazyValue, "v", {
        configurable: true,
        get: function () {
            var result = cb();
            if (!_globalLazyTestHooks.lzy) {
                // Just replace the value
                _setValue(result);
            }
            if (_globalLazyTestHooks.lzy && lazyValue.b !== _globalLazyTestHooks.lzy) {
                lazyValue.b = _globalLazyTestHooks.lzy;
            }
            return result;
        },
        set: _setValue
    });
    return lazyValue;
}
//# sourceMappingURL=lazy.js.map

/***/ }),
/* 12 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   objDefine: () => (/* binding */ objDefine),
/* harmony export */   objDefineAccessors: () => (/* binding */ objDefineAccessors),
/* harmony export */   objDefineGet: () => (/* binding */ objDefineGet),
/* harmony export */   objDefineProp: () => (/* binding */ objDefineProp),
/* harmony export */   objDefineProperties: () => (/* binding */ objDefineProperties),
/* harmony export */   objDefineProps: () => (/* binding */ objDefineProps)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8);
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13);
/* harmony import */ var _for_each_key__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15);
/* harmony import */ var _get_own_prop_desc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */




/**
 * @internal
 * @ignore
 * Mapping from ObjDefinePropDescriptor key to PropertyDescriptor key
 */
var propMap = {
    e: "enumerable",
    c: "configurable",
    v: _internal_constants__WEBPACK_IMPORTED_MODULE_0__.VALUE,
    w: "writable",
    g: "get",
    s: "set"
};
/**
 * @internal
 * @ignore
 * Helper to convert ObjDefinePropDescriptor into PropertyDescriptor
 * @param value - The prop descriptor to convert
 * @returns
 */
function _createProp(value) {
    var prop = {};
    prop[propMap["c"]] = true;
    prop[propMap["e"]] = true;
    if (value.l) {
        // Asign a getter function to return the value when requested
        prop.get = function () { return value.l.v; };
        // If it has a setter then expose it as well
        var desc = (0,_get_own_prop_desc__WEBPACK_IMPORTED_MODULE_1__.objGetOwnPropertyDescriptor)(value.l, "v");
        if (desc && desc.set) {
            prop.set = function (newValue) {
                value.l.v = newValue;
            };
        }
    }
    (0,_for_each_key__WEBPACK_IMPORTED_MODULE_2__.objForEachKey)(value, function (key, value) {
        prop[propMap[key]] = (0,_helpers_base__WEBPACK_IMPORTED_MODULE_3__.isUndefined)(value) ? prop[propMap[key]] : value;
    });
    return prop;
}
/**
 * Defines a new property directly on an object, or modifies an existing property on an object, and returns the object.
 * This is a wrapper for [Object.defineProperty](https://developer.mozilla.org/en-US/docs/web/javascript/reference/global_objects/object/defineproperty)
 *
 * This method allows a precise addition to or modification of a property on an object. Normal property addition through
 * assignment creates properties which show up during property enumeration (for...in loop or objKeys method), whose
 * values may be changed, and which may be deleted. This method allows these extra details to be changed from their
 * defaults. By default, properties added using objDefineProp() are not writable, not enumerable, and not configurable.
 *
 * Property descriptors present in objects come in two main flavors: data descriptors and accessor descriptors. A data
 * descriptor is a property that has a value, which may or may not be writable. An accessor descriptor is a property
 * described by a getter-setter pair of functions. A descriptor must be one of these two flavors; it cannot be both.
 *
 * This is an alias for Object.defineProperty
 * @group Object
 * @param target - The object on which to define the property.
 * @param key - The name or Symbol of the property to be defined or modified.
 * @param descriptor - The descriptor for the property being defined or modified.
 */
var objDefineProp = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass["defineProperty"];
/**
 * The objDefineProperties() method defines new or modifies existing properties directly on an object, returning the object.
 * This is a wrapper for [Object.defineProperties](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/defineProperties)
 * @since 0.6.0
 * @group Object
 * @param target - The object on which to define or modify properties.
 * @param props - An object whose keys represent the names of properties to be defined or modified and whose values are
 * objects describing those properties. Each value in props must be either a data descriptor or an accessor descriptor;
 * it cannot be both (see {@link ObjDefinePropDescriptorMap} for more details).
 * @returns
 */
var objDefineProperties = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass["defineProperties"];
/**
 * Try to define a get object property accessor for the target object, if a function is past as the value this will
 * be assumed to be a getter function and NOT the value.
 * @deprecated It is recommended that you use {@link objDefine} instead {@link objDefineGet} or {@link objDefineAccessors}
 * as it provides a deterministic way for identifying whether the value is a value or a function rather than wrapping any
 * function value in another function.
 * @group Object
 * @param target - The object on which to define the property.
 * @param key - The name of the property to be defined or modified
 * @param value - The value or a function that returns the value
 * @param configurable - Can the value be changed, defaults to true.
 * @param enumerable - Should this get property be enumerable, defaults to true.
 * @returns The object that was passed to the function
 */
function objDefineGet(target, key, value, configurable, enumerable) {
    var _a;
    return objDefineProp(target, key, _createProp((_a = {
            e: enumerable,
            c: configurable
        },
        _a[(0,_helpers_base__WEBPACK_IMPORTED_MODULE_3__.isFunction)(value) ? "g" : "v"] = value,
        _a)));
}
/**
 * Try to define get/set object property accessors for the target object/prototype, this will provide compatibility with
 * existing API definition when run within an ES5+ container that supports accessors but still enable the code to be loaded
 * and executed in an ES3 container, providing basic IE8 compatibility.
 * @deprecated It is recommended that you use {@link objDefine} instead {@link objDefineAccessors} as this internally creates
 * the {@link ObjDefinePropDescriptor} definition based on your provided arguments. And only using a minimum set of functions
 * reduces your overall bundle size.
 * @group Object
 * @param target - The object on which to define the property.
 * @param prop - The name of the property to be defined or modified.
 * @param getProp - The getter function to wire against the getter.
 * @param setProp - The setter function to wire against the setter.
 * @param configurable - Can the value be changed, defaults to true
 * @param enumerable - Should this get property be enumerable, defaults to true.
 * @returns The object that was passed to the function
 */
function objDefineAccessors(target, prop, getProp, setProp, configurable, enumerable) {
    var desc = {
        e: enumerable,
        c: configurable
    };
    if (getProp) {
        desc.g = getProp;
    }
    if (setProp) {
        desc.s = setProp;
    }
    return objDefineProp(target, prop, _createProp(desc));
}
/**
 * The objDefine() method defines a new or modifies an existing single property accessors for the target object based
 * on the configuration defined for the propDesc argument of type {@link ObjDefinePropDescriptor}. This will call
 * {@link objDefineProp} after creating the required PropertyDescriptor populating defaults for the propDesc values.
 * Note, the default values (true) for `configurable` and `enumerable` are different from the defaults provided by objDefineProp.
 * @since 0.6.0
 * @group Object
 * @param target - The object on which to define the property.
 * @param key - The name of the property to be defined or modified
 * @param propDesc - An object which defines the Property Descriptor mappings for the mapping.
 * @returns The target object.
 */
function objDefine(target, key, propDesc) {
    return objDefineProp(target, key, _createProp(propDesc));
}
/**
 * The objDefineProps() method defines new or modifies existing properties directly for the target object using the keys
 * and configuration from the propDescMap argument. This will call {@link objDefineProperties} after creating the required
 * PropertyDescriptorMap from the propDescMap values.
 * Note, the default values (true) for `configurable` and `enumerable` are different from the defaults provided by objDefineProperties.
 * @since 0.6.0
 * @group Object
 * @param target - The object on which to define or modify properties.
 * @param propDescMap - An object whose keys represent the names of properties to be defined or modified and whose values are
 * objects describing those properties. Each value in props must be either a data descriptor or an accessor descriptor;
 * it cannot be both (see {@link ObjDefinePropDescriptorMap} for more details).
 * @returns The target object.
 */
function objDefineProps(target, propDescMap) {
    var props = {};
    (0,_for_each_key__WEBPACK_IMPORTED_MODULE_2__.objForEachKey)(propDescMap, function (key, value) {
        props[key] = _createProp(value);
    });
    return objDefineProperties(target, props);
}
//# sourceMappingURL=define.js.map

/***/ }),
/* 13 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _createIs: () => (/* binding */ _createIs),
/* harmony export */   _createObjIs: () => (/* binding */ _createObjIs),
/* harmony export */   isArray: () => (/* binding */ isArray),
/* harmony export */   isArrayBuffer: () => (/* binding */ isArrayBuffer),
/* harmony export */   isBlob: () => (/* binding */ isBlob),
/* harmony export */   isBoolean: () => (/* binding */ isBoolean),
/* harmony export */   isDate: () => (/* binding */ isDate),
/* harmony export */   isDefined: () => (/* binding */ isDefined),
/* harmony export */   isError: () => (/* binding */ isError),
/* harmony export */   isFile: () => (/* binding */ isFile),
/* harmony export */   isFormData: () => (/* binding */ isFormData),
/* harmony export */   isFunction: () => (/* binding */ isFunction),
/* harmony export */   isNotTruthy: () => (/* binding */ isNotTruthy),
/* harmony export */   isNullOrUndefined: () => (/* binding */ isNullOrUndefined),
/* harmony export */   isNumber: () => (/* binding */ isNumber),
/* harmony export */   isObject: () => (/* binding */ isObject),
/* harmony export */   isPrimitive: () => (/* binding */ isPrimitive),
/* harmony export */   isPrimitiveType: () => (/* binding */ isPrimitiveType),
/* harmony export */   isPromise: () => (/* binding */ isPromise),
/* harmony export */   isPromiseLike: () => (/* binding */ isPromiseLike),
/* harmony export */   isRegExp: () => (/* binding */ isRegExp),
/* harmony export */   isStrictNullOrUndefined: () => (/* binding */ isStrictNullOrUndefined),
/* harmony export */   isStrictUndefined: () => (/* binding */ isStrictUndefined),
/* harmony export */   isString: () => (/* binding */ isString),
/* harmony export */   isThenable: () => (/* binding */ isThenable),
/* harmony export */   isTruthy: () => (/* binding */ isTruthy),
/* harmony export */   isTypeof: () => (/* binding */ isTypeof),
/* harmony export */   isUndefined: () => (/* binding */ isUndefined),
/* harmony export */   objToString: () => (/* binding */ objToString)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8);
/* harmony import */ var _safe_get__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


var PRIMITIVE_TYPES = [_internal_constants__WEBPACK_IMPORTED_MODULE_0__.STRING, _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NUMBER, _internal_constants__WEBPACK_IMPORTED_MODULE_0__.BOOLEAN, _internal_constants__WEBPACK_IMPORTED_MODULE_0__.UNDEFINED, "symbol", "bigint"];
/**
 * @ignore
 * @internal
 * Create and returns a function that will return `true` if the argument passed
 * to it matches the provided type.
 * @param theType - The type to match against the `typeof value`
 * @returns A function which takes a single argument and returns a boolean
 */
function _createIs(theType) {
    return function (value) {
        return typeof value === theType;
    };
}
/**
 * @ignore
 * @internal
 * Create and returns a function that will return `true` if the argument passed
 * to it matches the object type specified based on {@link objToString}.
 * @param - The object name to match for the `objToString(value)`
 * @returns A function which takes a single argument and returns a boolean
 */
function _createObjIs(theName) {
    var theType = "[object " + theName + "]";
    return function (value) {
        return !!(value && objToString(value) === theType);
    };
}
/**
 * The `objToString()` method returns a string representing the object. This explicitly
 * always calls the `Object.prototype.toString()` method.
 *
 * An object's toString() method is most commonly invoked when that object undergoes:
 * - explicit type conversion to a string (for example, String(myObject))
 * - implicit type coercion into a string (for example, myObject + "hello world")
 *
 * @group Object
 * @param value - The object to be converted into a string
 * @returns A string representation of the object
 * @example
 * ```ts
 * objToString(new Date()); // [object Date]
 * objToString(new String()); // [object String]
 *
 * // Math has its Symbol.toStringTag
 * objToString(Math); // [object Math]
 *
 * objToString(undefined); // [object Undefined]
 * objToString(null); // [object Null]
 * ```
 */
function objToString(value) {
    return _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjProto.toString.call(value);
}
/**
 * Validate if the provided value object is of the expected type
 * @group Type Identity
 * @param value - The value to check
 * @param theType - The expected type name as a string
 * @returns `true` if the value matches the provided type
 */
function isTypeof(value, theType) {
    return typeof value === theType;
}
/**
 * Checks if the provided value is undefined or contains the string value "undefined",
 * if you want to consider the string value as undefined see {@link isStrictUndefined}
 * @group Type Identity
 * @group Value Check
 * @param value - The value to check
 * @returns true if the value is undefined or "undefined", otherwise false
 * @example
 * ```ts
 * isUndefined(undefined);              // true
 * isUndefined("undefined");            // true
 *
 * isUndefined(null);                   // false
 * isUndefined("null");                 // false
 * isUndefined("1");                    // false
 * isUndefined("aa");                   // false
 * isUndefined(new Date());             // false
 * isUndefined(1);                      // false
 * isUndefined("");                     // false
 * isUndefined(_dummyFunction);         // false
 * isUndefined([]);                     // false
 * isUndefined(new Array(1));           // false
 * isUndefined(true);                   // false
 * isUndefined(false);                  // false
 * isUndefined("true");                 // false
 * isUndefined("false");                // false
 * isUndefined(new Boolean(true));      // false
 * isUndefined(new Boolean(false));     // false
 * isUndefined(new Boolean("true"));    // false
 * isUndefined(new Boolean("false"));   // false
 * isUndefined(Boolean(true));          // false
 * isUndefined(Boolean(false));         // false
 * isUndefined(Boolean("true"));        // false
 * isUndefined(Boolean("false"));       // false
 * isUndefined(new RegExp(""));         // false
 * isUndefined(new ArrayBuffer(0));     // false
 * isUndefined(new Error("Test Error"));// false
 * isUndefined(new TypeError("Test TypeError"));    // false
 * isUndefined(new TestError("Test TestError"));    // false
 * isUndefined(_dummyError());          // false
 * isUndefined(Promise.reject());       // false
 * isUndefined(Promise.resolve());      // false
 * isUndefined(new Promise(() => {}));  // false
 * isUndefined(_simplePromise());       // false
 * isUndefined(_simplePromiseLike());   // false
 * isUndefined(Object.create(null));    // false
 * isUndefined(polyObjCreate(null));    // false
 * ```
 */
function isUndefined(value) {
    return typeof value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.UNDEFINED || value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.UNDEFINED;
}
/**
 * Checks if the provided value is undefined, a string value of "undefined" is NOT considered
 * to be undefined.
 * @group Type Identity
 * @group Value Check
 * @param value - The value to check
 * @returns true if the typeof value === UNDEFINED
 * @example
 * ```ts
 * isStrictUndefined(undefined);    // true
 *
 * isStrictUndefined(null);         // false
 * isStrictUndefined("null");       // false
 * isStrictUndefined("undefined");  // false
 * isStrictUndefined("1");          // false
 * isStrictUndefined("aa");         // false
 * isStrictUndefined(new Date());   // false
 * isStrictUndefined(0);            // false
 * isStrictUndefined(1);            // false
 * isStrictUndefined("");           // false
 * ```
 */
function isStrictUndefined(arg) {
    return !isDefined(arg);
}
/**
 * Checks if the provided value is null, undefined or contains the string value of "undefined".
 * @group Type Identity
 * @group Value Check
 * @param value - The value to check
 * @returns `true` if the value is `null` or `undefined`
 * @example
 * ```ts
 * isNullOrUndefined(null);         // true
 * isNullOrUndefined(undefined);    // true
 * isNullOrUndefined("undefined");  // true
 *
 * let value = null;
 * isNullOrUndefined(value);        // true
 * let value = undefined;
 * isNullOrUndefined(value);        // true
 *
 * isNullOrUndefined("");           // false
 * isNullOrUndefined(0);            // false
 * isNullOrUndefined(new Date());   // false
 * isNullOrUndefined(true);         // false
 * isNullOrUndefined(false);        // false
 * ```
 */
function isNullOrUndefined(value) {
    return value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE || isUndefined(value);
}
/**
 * Checks if the provided value is null, undefined only, a string value of "undefined" is NOT considered
 * to be undefined.
 * @group Type Identity
 * @group Value Check
 * @param value - The value to check
 * @returns
 * @example
 * ```ts
 * isStrictNullOrUndefined(null);         // true
 * isStrictNullOrUndefined(undefined);    // true
 * isStrictNullOrUndefined("undefined");  // false
 *
 * let value = null;
 * isStrictNullOrUndefined(value);        // true
 * let value = undefined;
 * isStrictNullOrUndefined(value);        // true
 *
 * isStrictNullOrUndefined("");           // false
 * isStrictNullOrUndefined(0);            // false
 * isStrictNullOrUndefined(new Date());   // false
 * isStrictNullOrUndefined(true);         // false
 * isStrictNullOrUndefined(false);        // false
 * ```
 */
function isStrictNullOrUndefined(value) {
    return value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE || !isDefined(value);
}
/**
 * Checks if the passed value is defined, which means it has any value and is not undefined.
 * A string value of "undefined" is considered to be defined.
 * @group Value Check
 * @param arg - The value to check
 * @returns true if arg has a value (is not === undefined)
 * @example
 * ```ts
 * isDefined(null);         // false
 * isDefined(undefined);    // false
 * isDefined("undefined");  // true
 *
 * let value = null;
 * isDefined(value);        // false
 * let value = undefined;
 * isDefined(value);        // false
 *
 * isDefined("");           // true
 * isDefined(0);            // true
 * isDefined(new Date());   // true
 * isDefined(true);         // true
 * isDefined(false);        // true
 * ```
 */
function isDefined(arg) {
    return !!arg || arg !== _internal_constants__WEBPACK_IMPORTED_MODULE_0__.UNDEF_VALUE;
}
/**
 * Identifies whether the provided value is a JavaScript [primitive](https://developer.mozilla.org/en-US/docs/Glossary/Primitive)
 * which is when is it not an object and has no methods or properties. There are 7 primitive data types:
 * - string
 * - number
 * - bigint
 * - boolean
 * - undefined
 * - null
 * - symbol
 *
 * Most of the time, a primitive value is represented directly at the lowest level of the language implementation.
 *
 * All primitives are immutable; that is, they cannot be altered. It is important not to confuse a primitive itself
 * with a variable assigned a primitive value. The variable may be reassigned to a new value, but the existing value
 * can not be changed in the ways that objects, arrays, and functions can be altered. The language does not offer
 * utilities to mutate primitive values.
 * @since 0.4.4
 * @group Type Identity
 * @param value - The value to check whether it's a primitive value
 * @example
 * ```ts
 * isPrimitive(null);                   // true
 * isPrimitive(undefined);              // true
 * isPrimitive("null");                 // true
 * isPrimitive("undefined");            // true
 * isPrimitive("1");                    // true
 * isPrimitive("aa");                   // true
 * isPrimitive(1);                      // true
 * isPrimitive(Number(2));              // true
 * isPrimitive("");                     // true
 * isPrimitive(String(""));             // true
 * isPrimitive(true);                   // true
 * isPrimitive(false);                  // true
 * isPrimitive("true");                 // true
 * isPrimitive("false");                // true
 * isPrimitive(BigInt(42));             // true
 * isPrimitive(Symbol.for("Hello"));    // true
 *
 * isPrimitive(new String("aa"));       // false
 * isPrimitive(new Date());             // false
 * isPrimitive(_dummyFunction);         // false
 * isPrimitive([]);                     // false
 * isPrimitive(new Array(1));           // false
 * isPrimitive(new Boolean(true));      // false
 * isPrimitive(new Boolean(false));     // false
 * isPrimitive(new Boolean("true"));    // false
 * isPrimitive(new Boolean("false"));   // false
 * ```
 */
var isPrimitive = function (value) {
    return value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE || isPrimitiveType(typeof value);
};
/**
 * Identifies whether the provided value is a JavaScript [primitive](https://developer.mozilla.org/en-US/docs/Glossary/Primitive)
 * which is when is it not an object and has no methods or properties. There are 6 primitive data types:
 * - string
 * - number
 * - bigint
 * - boolean
 * - undefined
 * - symbol
 *
 * Most of the time, a primitive value is represented directly at the lowest level of the language implementation.
 *
 * All primitives are immutable; that is, they cannot be altered. It is important not to confuse a primitive itself
 * with a variable assigned a primitive value. The variable may be reassigned to a new value, but the existing value
 * can not be changed in the ways that objects, arrays, and functions can be altered. The language does not offer
 * utilities to mutate primitive values.
 * @since 0.9.6
 * @group Type Identity
 * @param theType - The type as a string value to be checked whther it's a primitive type, this should be the value
 * returned from `typeof value`.
 * @example
 * ```ts
 * isPrimitiveType(null);                   // false
 * isPrimitiveType(undefined);              // false
 * isPrimitiveType("null");                 // false
 * isPrimitiveType("undefined");            // false
 * isPrimitiveType("1");                    // false
 * isPrimitiveType("aa");                   // false
 * isPrimitiveType(1);                      // false
 * isPrimitiveType(Number(2));              // false
 * isPrimitiveType("");                     // false
 * isPrimitiveType(String(""));             // false
 * isPrimitiveType(true);                   // false
 * isPrimitiveType(false);                  // false
 * isPrimitiveType("true");                 // false
 * isPrimitiveType("false");                // false
 * isPrimitiveType(BigInt(42));             // false
 * isPrimitiveType(Symbol.for("Hello"));    // false
 *
 * isPrimitiveType("string");               // true
 * isPrimitiveType("number");               // true
 * isPrimitiveType("boolean");              // true
 * isPrimitiveType("undefined");            // true
 * isPrimitiveType("symbol");               // true
 * isPrimitiveType("bigint");               // true
 * ```
 */
var isPrimitiveType = function (theType) {
    return theType !== _internal_constants__WEBPACK_IMPORTED_MODULE_0__.OBJECT && PRIMITIVE_TYPES.indexOf(theType) !== -1;
};
/**
 * Checks to see if the past value is a string value
 * @group Type Identity
 * @group String
 * @param value - The value to check
 * @returns
 * @example
 * ```ts
 * isString("");            // true
 * isString("null");        // true
 * isString("undefined");   // true
 * isString(String(""));    // true
 *
 * isString(null);          // false
 * isString(undefined);     // false
 * isString(0);             // false
 * ```
 */
var isString = _createIs(_internal_constants__WEBPACK_IMPORTED_MODULE_0__.STRING);
/**
 * Checks to see if the past value is a function value
 * @group Type Identity
 * @param value - The value to check
 * @returns
 * @example
 * ```ts
 * function myFunction() { }
 * isFunction(null);            // false
 * isFunction(undefined);       // false
 * isFunction("null");          // false
 * isFunction("undefined");     // false
 * isFunction("1");             // false
 * isFunction("aa");            // false
 * isFunction(new Date());      // false
 * isFunction(1);               // false
 * isFunction("");              // false
 * isFunction(myFunction);      // true
 * isFunction([]);              // false
 * isFunction(new Array(1));    // false
 * ```
 */
var isFunction = _createIs(_internal_constants__WEBPACK_IMPORTED_MODULE_0__.FUNCTION);
/**
 * Checks to see if the past value is an object value
 * @group Type Identity
 * @group Object
 * @typeParam T - The object type, defaults to any
 * @param value - The value to check
 * @returns
 */
function isObject(value) {
    if (!value && isNullOrUndefined(value)) {
        return false;
    }
    return !!value && typeof value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.OBJECT;
}
/**
 * Checks if the type of value is an Array.
 *
 * @group Type Identity
 * @group Array
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a Array, false otherwise.
 * @example
 * ```ts
 * import { isArray, isObject } from "@nevware21/ts-utils";
 *
 * function performAction(value: any) {
 *     if (isArray(value) || isObject(value)) {
 *         // Do something
 *     } else {
 *         // Do something else
 *     }
 * }
 * ```
 */
var isArray = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ArrCls.isArray;
/**
 * Check if an object is of type Date
 * @group Type Identity
 * @example
 * ```ts
 * import { isDate } from "@nevware21/ts-utils";
 *
 * let _theDate = null;
 *
 * function getSetDate(newDate?: any) {
 *     _theDate = isDate(newDate) ? newDate : new Date();
 *
 *     return _theDate;
 * }
 * ```
 */
var isDate = _createObjIs("Date");
/**
 * Checks if the type of value is a number.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a number, false otherwise.
 */
var isNumber = _createIs(_internal_constants__WEBPACK_IMPORTED_MODULE_0__.NUMBER);
/**
 * Checks if the type of value is a boolean.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a boolean, false otherwise.
 */
var isBoolean = _createIs(_internal_constants__WEBPACK_IMPORTED_MODULE_0__.BOOLEAN);
/**
 * Determines if a value is a regular expression object.
 * @group Type Identity
 * @param {*} value Reference to check.
 * @returns {boolean} True if `value` is a `RegExp`.
 */
var isRegExp = _createObjIs("RegExp");
/**
 * Checks if the type of value is a File object.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a File, false otherwise.
 */
var isFile = _createObjIs("File");
/**
 * Checks if the type of value is a FormData object.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a FormData, false otherwise.
 */
var isFormData = _createObjIs("FormData");
/**
 * Checks if the type of value is a Blob object.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a Blob, false otherwise.
 */
var isBlob = _createObjIs("Blob");
/**
 * Checks if the type of value is a ArrayBuffer object.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a ArrayBuffer, false otherwise.
 */
var isArrayBuffer = _createObjIs("ArrayBuffer");
/**
 * Checks if the type of value is a Error object.
 * @group Type Identity
 * @group Error
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a Error, false otherwise.
 */
var isError = _createObjIs("Error");
/**
 * Checks if the type of value is a PromiseLike instance (contains a then function).
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a PromiseLike, false otherwise.
 */
function isPromiseLike(value) {
    return !!value && isFunction(value.then);
}
/**
 * Checks if the type of value is a PromiseLike instance (contains a then function).
 * This is an alias for {@link isPromiseLike}.
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a PromiseLike, false otherwise.
 */
var isThenable = isPromiseLike;
/**
 * Checks if the type of value is a Promise instance (contains then and catch functions).
 * @group Type Identity
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a Promise, false otherwise.
 */
function isPromise(value) {
    return isPromiseLike(value) && isFunction(value.catch);
}
/**
 * Checks if the type of value does not evaluate to true value, handling some special
 * case usages of Boolean(true/false) and new Boolean(true/false).
 * @group Value Check
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is not truthy, false otherwise.
 */
function isNotTruthy(value) {
    return !value || !(0,_safe_get__WEBPACK_IMPORTED_MODULE_1__.safeGet)(function () { return (value && (0 + value)); }, value);
}
/**
 * Checks if the type of value evaluates to true value, handling some special
 * case usages of Boolean(true/false) and new Boolean(true/false).
 * @group Value Check
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is not truthy, false otherwise.
 */
function isTruthy(value) {
    // Objects created with no prototype (Object.create(null)) cannot be converted to primitives
    // Which causes this code to throw, additionally just using !! also fails for Boolean objects
    // !!(new Boolean(false)) evaluates to true
    return !(!value || (0,_safe_get__WEBPACK_IMPORTED_MODULE_1__.safeGet)(function () { return !(value && (0 + value)); }, !value));
    //return !(!value || !(value && (0 + value)));
}
//# sourceMappingURL=base.js.map

/***/ }),
/* 14 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   safeGet: () => (/* binding */ safeGet)
/* harmony export */ });
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
/**
 * Function to safely execute a callback function, if the function throws the provided default
 * value will be returned.
 * @since 0.9.5
 * @group Safe
 * @param cb - Callback function be wrapped with an exception
 * @param defValue - The default value to return when an exception is thrown
 * @returns The result of the callback function or the default if an exception occurred calling the callback
 * function.
 * @example
 * ```ts
 * let theExpression = "{ invalid: json value";
 *
 * let result = safeGet(() => {
 *     return JSON.parse(theExpression);
 * }, {});
 *
 * // result === {};
 * ```
 */
function safeGet(cb, defValue) {
    var result = defValue;
    try {
        result = cb();
    }
    catch (e) {
        // Do nothing
    }
    return result;
}
//# sourceMappingURL=safe_get.js.map

/***/ }),
/* 15 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   objForEachKey: () => (/* binding */ objForEachKey)
/* harmony export */ });
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13);
/* harmony import */ var _has_own__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * Calls the provided `callbackFn` function once for each key in an object. This is equivelent to `arrForEach(Object.keys(theObject), callbackFn)` or
 * if not using the array helper `Object.keys(theObject).forEach(callbackFn)` except that this helper avoid creating a temporary of the object
 * keys before iterating over them and like the `arrForEach` helper you CAN stop or break the iteration by returning -1 from the `callbackFn` function.
 * @group Object
 * @typeParam T - The object type
 * @param callbackfn  A function that accepts up to two arguments, the key name and the current value of the property represented by the key.
 * @param thisArg  [Optional] An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, null or undefined
 * the object will be used as the this value.
 * @example
 * ```ts
 * function performAction<T>(target: T, source: any) {
 *    if (!isNullOrUndefined(source)) {
 *        objForEachKey(source, (key, value) => {
 *            // Set the target with a reference to the same value with the same name
 *            target[key] = value;
 *        });
 *    }
 *
 *    return target;
 * }
 * ```
 */
function objForEachKey(theObject, callbackfn, thisArg) {
    if (theObject && (0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isObject)(theObject)) {
        for (var prop in theObject) {
            if ((0,_has_own__WEBPACK_IMPORTED_MODULE_1__.objHasOwn)(theObject, prop)) {
                if (callbackfn.call(thisArg || theObject, prop, theObject[prop]) === -1) {
                    break;
                }
            }
        }
    }
}
//# sourceMappingURL=for_each_key.js.map

/***/ }),
/* 16 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   objHasOwn: () => (/* binding */ objHasOwn),
/* harmony export */   polyObjHasOwn: () => (/* binding */ polyObjHasOwn)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8);
/* harmony import */ var _get_own_prop_desc__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(17);
/* harmony import */ var _has_own_prop__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(18);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */



/**
 * The objHasOwn() method returns a boolean indicating whether the object
 * has the specified property as its own property (as opposed to inheriting it).
 * If the property is inherited, or does not exist, the method returns false.
 *
 * The objHasOwn() method returns true if the specified property is a direct property
 * of the object — even if the property value is null or undefined. The method returns
 * false if the property is inherited, or has not been declared at all. Unlike the in operator,
 * this method does not check for the specified property in the object's prototype chain.
 *
 * It is recommended over {@link objHasOwnProperty} () because it works for objects created using
 * objCreate(null) and with objects that have overridden the inherited hasOwnProperty() method.
 * While it is possible to workaround these problems by calling Object.prototype.hasOwnProperty()
 * on an external object, Object.hasOwn() is more intuitive.
 *
 * @since 0.4.3
 * @group Object
 * @param obj - The object being evaluated
 * @param prop - The String or Symbol of the property to test
 * @returns `true` if the object has the specified property as own property; otherwise `false`
 * @example
 * ```ts
 * let example = {};
 * objHasOwn(example, 'prop');   // false
 *
 * example.prop = 'exists';
 * objHasOwn(example, 'prop');   // true - 'prop' has been defined
 *
 * example.prop = null;
 * objHasOwn(example, 'prop');   // true - own property exists with value of null
 *
 * example.prop = undefined;
 * objHasOwn(example, 'prop');   // true - own property exists with value of undefined
 * ```
 */
var objHasOwn = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass["hasOwn"] || polyObjHasOwn;
/**
 * The polyObjHasOwn() method is a polyfill for {@link objHasOwn} when the native
 * [Object.hasOwnreturns](https://caniuse.com/?search=hasOwn) is not supported, it returns a
 * boolean indicating whether the object has the specified property as its own property (as
 * opposed to inheriting it). If the property is inherited, or does not exist, the method
 * returns false.
 *
 * The objHasOwn() method returns true if the specified property is a direct property
 * of the object — even if the property value is null or undefined. The method returns
 * false if the property is inherited, or has not been declared at all. Unlike the in operator,
 * this method does not check for the specified property in the object's prototype chain.
 *
 * It is recommended over objHasOwnProperty() because it works for objects created using
 * objCreate(null) and with objects that have overridden the inherited hasOwnProperty() method.
 * While it is possible to workaround these problems by calling Object.prototype.hasOwnProperty()
 * on an external object, Object.hasOwn() is more intuitive.
 *
 * @since 0.4.3
 * @group Object
 * @group Polyfill
 * @param obj - The object being evaluated
 * @param prop - The String or Symbol of the property to test
 * @returns `true` if the object has the specified property as own property; otherwise `false`
 * @example
 * ```ts
 * let example = {};
 * polyObjHasOwn(example, 'prop');   // false
 *
 * example.prop = 'exists';
 * polyObjHasOwn(example, 'prop');   // true - 'prop' has been defined
 *
 * example.prop = null;
 * polyObjHasOwn(example, 'prop');   // true - own property exists with value of null
 *
 * example.prop = undefined;
 * polyObjHasOwn(example, 'prop');   // true - own property exists with value of undefined
 * ```
 */
function polyObjHasOwn(obj, prop) {
    return (0,_has_own_prop__WEBPACK_IMPORTED_MODULE_1__.objHasOwnProperty)(obj, prop) || !!(0,_get_own_prop_desc__WEBPACK_IMPORTED_MODULE_2__.objGetOwnPropertyDescriptor)(obj, prop);
}
//# sourceMappingURL=has_own.js.map

/***/ }),
/* 17 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   objGetOwnPropertyDescriptor: () => (/* binding */ objGetOwnPropertyDescriptor)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

/**
 * The objGetOwnPropertyDescriptor() method returns an object describing the configuration of a specific property on
 * a given object (that is, one directly present on an object and not in the object's prototype chain). The object
 * returned is mutable but mutating it has no effect on the original property's configuration.
 * @since 0.4.3
 * @group Object
 * @param target - Object that contains the property.
 * @param prop - Name of the property.
 * @returns A property descriptor of the given property if it exists on the object, otherwise undefined.
 *
 * @example
 * ```ts
 * o = {};
 * objDefineProp(o, 'qux', {
 *   value: 8675309,
 *   writable: false,
 *   enumerable: false
 * });
 * d = objGetOwnPropertyDescriptor(o, 'qux');
 * // d is {
 * //   value: 8675309,
 * //   writable: false,
 * //   enumerable: false,
 * //   configurable: false
 * // }
 *
 * objGetOwnPropertyDescriptor('foo', 0);
 * // TypeError: "foo" is not an object  // ES5 code
 *
 * objGetOwnPropertyDescriptor('foo', 0);
 * // Object returned by ES2015 code: {
 * //   configurable: false,
 * //   enumerable: true,
 * //   value: "f",
 * //   writable: false
 * // }
 * ```
 * Note: In ES5, if the first argument to this method is not an object (a primitive), then it will cause a TypeError. In ES2015, a non-object first argument will be coerced to an object at first.
 */
var objGetOwnPropertyDescriptor = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.getOwnPropertyDescriptor;
//# sourceMappingURL=get_own_prop_desc.js.map

/***/ }),
/* 18 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   objHasOwnProperty: () => (/* binding */ objHasOwnProperty)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

/**
 * The objHasOwnProperty() method returns a boolean indicating whether the object
 * has the specified property as its own property (as opposed to inheriting it).
 *
 * The objHasOwnProperty() method returns true if the specified property is a direct
 * property of the object — even if the value is null or undefined. The method returns
 * false if the property is inherited, or has not been declared at all. Unlike the in
 * operator, this method does not check for the specified property in the object's
 * prototype chain.
 *
 * The method can be called on most JavaScript objects, because most objects descend
 * from Object, and hence inherit its methods. For example Array is an Object, so you
 * can use objHasOwnProperty() method to check whether an index exists:
 * @group Object
 * @param obj - The object being evaluated
 * @param prop - The String or Symbol of the property to test
 * @returns `true` if the object has the specified property as own property; otherwise `false`
 * @example
 * ```ts
 * let example = {};
 * objHasOwnProperty(example, 'prop');   // false
 *
 * example.prop = 'exists';
 * objHasOwnProperty(example, 'prop');   // true - 'prop' has been defined
 *
 * example.prop = null;
 * objHasOwnProperty(example, 'prop');   // true - own property exists with value of null
 *
 * example.prop = undefined;
 * objHasOwnProperty(example, 'prop');   // true - own property exists with value of undefined
 * ```
 */
function objHasOwnProperty(obj, prop) {
    return obj && _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjProto.hasOwnProperty.call(obj, prop);
}
//# sourceMappingURL=has_own_prop.js.map

/***/ }),
/* 19 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   throwError: () => (/* binding */ throwError),
/* harmony export */   throwRangeError: () => (/* binding */ throwRangeError),
/* harmony export */   throwTypeError: () => (/* binding */ throwTypeError)
/* harmony export */ });
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
/**
 * Throw an error exception with the specified optional message
 * @group Error
 * @param message
 */
function throwError(message) {
    throw new Error(message);
}
/**
 * Throw a type error with the specified optional message
 * @group Error
 * @param message
 */
function throwTypeError(message) {
    throw new TypeError(message);
}
/**
 * Throw a RangeError with the specified optional message
 * @group Error
 * @param message
 */
function throwRangeError(message) {
    throw new RangeError(message);
}
//# sourceMappingURL=throw.js.map

/***/ }),
/* 20 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STR_DEFAULT_ENDPOINT_URL: () => (/* binding */ STR_DEFAULT_ENDPOINT_URL),
/* harmony export */   STR_EMPTY: () => (/* binding */ STR_EMPTY),
/* harmony export */   STR_PROPERTIES: () => (/* binding */ STR_PROPERTIES),
/* harmony export */   STR_VERSION: () => (/* binding */ STR_VERSION)
/* harmony export */ });
/*
 * 1DS JS SDK Core, 4.0.3
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */

// Licensed under the MIT License.
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Note: DON'T Export these const from the package as we are still targeting ES3 this will export a mutable variables that someone could change!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Generally you should only put values that are used more than 2 times and then only if not already exposed as a constant (such as SdkCoreNames)
// as when using "short" named values from here they will be will be minified smaller than the SdkCoreNames[eSdkCoreNames.xxxx] value.
var STR_EMPTY = "";
var STR_DEFAULT_ENDPOINT_URL = "https://browser.events.data.microsoft.com/OneCollector/1.0/";
var STR_VERSION = "version";
var STR_PROPERTIES = "properties";
//# sourceMappingURL=InternalConstants.js.map

/***/ }),
/* 21 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FullVersionString: () => (/* binding */ FullVersionString),
/* harmony export */   Version: () => (/* binding */ Version),
/* harmony export */   createGuid: () => (/* binding */ createGuid),
/* harmony export */   extend: () => (/* binding */ extend),
/* harmony export */   getCommonSchemaMetaData: () => (/* binding */ getCommonSchemaMetaData),
/* harmony export */   getCookieValue: () => (/* binding */ getCookieValue),
/* harmony export */   getFieldValueType: () => (/* binding */ getFieldValueType),
/* harmony export */   getTenantId: () => (/* binding */ getTenantId),
/* harmony export */   getTime: () => (/* binding */ getTime),
/* harmony export */   isArrayValid: () => (/* binding */ isArrayValid),
/* harmony export */   isChromium: () => (/* binding */ isChromium),
/* harmony export */   isDocumentObjectAvailable: () => (/* binding */ isDocumentObjectAvailable),
/* harmony export */   isGreaterThanZero: () => (/* binding */ isGreaterThanZero),
/* harmony export */   isLatency: () => (/* binding */ isLatency),
/* harmony export */   isUint8ArrayAvailable: () => (/* binding */ isUint8ArrayAvailable),
/* harmony export */   isValueAssigned: () => (/* binding */ isValueAssigned),
/* harmony export */   isValueKind: () => (/* binding */ isValueKind),
/* harmony export */   isWindowObjectAvailable: () => (/* binding */ isWindowObjectAvailable),
/* harmony export */   openXhr: () => (/* binding */ openXhr),
/* harmony export */   sanitizeProperty: () => (/* binding */ sanitizeProperty),
/* harmony export */   setProcessTelemetryTimings: () => (/* binding */ setProcessTelemetryTimings)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(31);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(42);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(15);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(37);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(40);
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(24);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(28);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(22);
/*
 * 1DS JS SDK Core, 4.0.3
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
var _a;
/**
* Utils.ts
* @author  Abhilash Panwar (abpanwar) Hector Hernandez (hectorh)
* @copyright Microsoft 2018
* File containing utility functions.
*/





var Version = '4.0.3';
var FullVersionString = "1DS-Web-JS-" + Version;
var ObjHasOwnProperty = _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.ObjProto.hasOwnProperty;
// Defining here so we don't need to take (import) the ApplicationInsights Common module
var strDisabledPropertyName = "Microsoft_ApplicationInsights_BypassAjaxInstrumentation";
var strWithCredentials = "withCredentials";
var strTimeout = "timeout";
// If value is array just get the type for the first element
var _fieldTypeEventPropMap = (_a = {},
    _a[0 /* FieldValueSanitizerType.NotSet */] = 0 /* eEventPropertyType.Unspecified */,
    _a[2 /* FieldValueSanitizerType.Number */] = 6 /* eEventPropertyType.Double */,
    _a[1 /* FieldValueSanitizerType.String */] = 1 /* eEventPropertyType.String */,
    _a[3 /* FieldValueSanitizerType.Boolean */] = 7 /* eEventPropertyType.Bool */,
    _a[4096 /* FieldValueSanitizerType.Array */ | 2 /* FieldValueSanitizerType.Number */] = 6 /* eEventPropertyType.Double */,
    _a[4096 /* FieldValueSanitizerType.Array */ | 1 /* FieldValueSanitizerType.String */] = 1 /* eEventPropertyType.String */,
    _a[4096 /* FieldValueSanitizerType.Array */ | 3 /* FieldValueSanitizerType.Boolean */] = 7 /* eEventPropertyType.Bool */,
    _a);
/**
 * @ignore
 */
// let _uaDisallowsSameSiteNone = null;
var uInt8ArraySupported = null;
// var _areCookiesAvailable: boolean | undefined;
/**
 * Checks if document object is available
 */
var isDocumentObjectAvailable = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.hasDocument)();
/**
 * Checks if window object is available
 */
var isWindowObjectAvailable = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.hasWindow)();
/**
 * Checks if value is assigned to the given param.
 * @param value - The token from which the tenant id is to be extracted.
 * @returns True/false denoting if value is assigned to the param.
 */
function isValueAssigned(value) {
    /// <summary> takes a value and checks for undefined, null and empty string </summary>
    /// <param type="any"> value to be tested </param>
    /// <returns> true if value is null undefined or emptyString </returns>
    return !(value === _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY || (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(value));
}
/**
 * Gets the tenant id from the tenant token.
 * @param apiKey - The token from which the tenant id is to be extracted.
 * @returns The tenant id.
 */
function getTenantId(apiKey) {
    if (apiKey) {
        var indexTenantId = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.strIndexOf)(apiKey, "-");
        if (indexTenantId > -1) {
            return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.strLeft)(apiKey, indexTenantId);
        }
    }
    return _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY;
}
/**
 * Checks if Uint8Array are available in the current environment. Safari and Firefox along with
 * ReactNative are known to not support Uint8Array properly.
 * @returns True if available, false otherwise.
 */
function isUint8ArrayAvailable() {
    if (uInt8ArraySupported === null) {
        uInt8ArraySupported = !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isUndefined)(Uint8Array) && !isSafariOrFirefox() && !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_6__.isReactNative)();
    }
    return uInt8ArraySupported;
}
/**
 * Checks if the value is a valid EventLatency.
 * @param value - The value that needs to be checked.
 * @returns True if the value is in AWTEventLatency, false otherwise.
 */
function isLatency(value) {
    if (value && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isNumber)(value) && value >= 1 /* EventLatencyValue.Normal */ && value <= 4 /* EventLatencyValue.Immediate */) {
        return true;
    }
    return false;
}
/**
 * Sanitizes the Property. It checks the that the property name and value are valid. It also
 * checks/populates the correct type and pii of the property value.
 * @param name - property name                          - The property name.
 * @param property - The property value or an IEventProperty containing value,
 * type ,pii and customer content.
 * @returns IEventProperty containing valid name, value, pii and type or null if invalid.
 */
function sanitizeProperty(name, property, stringifyObjects) {
    // Check that property is valid
    if ((!property && !isValueAssigned(property)) || typeof name !== "string") {
        return null;
    }
    // Perf optimization -- only need to get the type once not multiple times
    var propType = typeof property;
    // If the property isn't IEventProperty (and is either string, number, boolean or array), convert it into one.
    if (propType === "string" || propType === "number" || propType === "boolean" || (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isArray)(property)) {
        property = { value: property };
    }
    else if (propType === "object" && !ObjHasOwnProperty.call(property, "value")) {
        property = { value: stringifyObjects ? JSON.stringify(property) : property };
    }
    else if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_VALUE /* @min:%2evalue */])
        || property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_VALUE /* @min:%2evalue */] === _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY || (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isString)(property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_VALUE /* @min:%2evalue */])
        && !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isNumber)(property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_VALUE /* @min:%2evalue */]) && !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isBoolean)(property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_VALUE /* @min:%2evalue */])
        && !(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isArray)(property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_VALUE /* @min:%2evalue */]))) {
        // Since property is IEventProperty, we need to validate its value
        return null;
    }
    // We need to check that if the property value is an array, it is valid
    if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isArray)(property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_VALUE /* @min:%2evalue */]) &&
        !isArrayValid(property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_VALUE /* @min:%2evalue */])) {
        return null;
    }
    // If either pii or cc is set convert value to string (since only string pii/cc is allowed).
    // If the value is a complex type like an array that can't be converted to string we will drop
    // the property.
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_KIND /* @min:%2ekind */])) {
        if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isArray)(property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_VALUE /* @min:%2evalue */]) || !isValueKind(property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_KIND /* @min:%2ekind */])) {
            return null;
        }
        property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_VALUE /* @min:%2evalue */] = property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_VALUE /* @min:%2evalue */].toString();
    }
    return property;
}
function getCommonSchemaMetaData(value, kind, type) {
    var encodedTypeValue = -1;
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isUndefined)(value)) {
        if (kind > 0) {
            if (kind === 32) {
                // encode customer content. Value can only be string. bit 13-16 are for cc
                encodedTypeValue = (1 << 13);
            }
            else if (kind <= 13) {
                // encode PII. Value can only be string. bits 5-12 are for Pii
                encodedTypeValue = (kind << 5);
            }
        }
        // isDataType checks that the "type" is a number so we don't need to check for undefined
        if (isDataType(type)) {
            // Data Type is provided and valid, so use that
            if (encodedTypeValue === -1) {
                // Don't return -1
                encodedTypeValue = 0;
            }
            encodedTypeValue |= type;
        }
        else {
            var propType = _fieldTypeEventPropMap[getFieldValueType(value)] || -1;
            if (encodedTypeValue !== -1 && propType !== -1) {
                // pii exists so we must return correct type
                encodedTypeValue |= propType;
            }
            else if (propType === 6 /* eEventPropertyType.Double */) {
                encodedTypeValue = propType;
            }
        }
    }
    return encodedTypeValue;
}
/**
 * Helper to get and decode the cookie value using decodeURIComponent, this is for historical
 * backward compatibility where the document.cookie value was decoded before parsing.
 * @param cookieMgr - The cookie manager to use
 * @param name - The name of the cookie to get
 * @param decode - A flag to indicate whether the cookie value should be decoded
 * @returns The decoded cookie value (if available) otherwise an empty string.
 */
function getCookieValue(cookieMgr, name, decode) {
    if (decode === void 0) { decode = true; }
    var cookieValue;
    if (cookieMgr) {
        cookieValue = cookieMgr.get(name);
        if (decode && cookieValue && decodeURIComponent) {
            cookieValue = decodeURIComponent(cookieValue);
        }
    }
    return cookieValue || _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY;
}
/**
 * Create a new guid.
 * @param style - The style of guid to generated, defaults to Digits
 * Digits (Default) : 32 digits separated by hyphens: 00000000-0000-0000-0000-000000000000
 * Braces - 32 digits separated by hyphens, enclosed in braces: {00000000-0000-0000-0000-000000000000}
 * Parentheses - 32 digits separated by hyphens, enclosed in parentheses: (00000000-0000-0000-0000-000000000000)
 * Numeric - 32 digits: 00000000000000000000000000000000
 * @returns The formatted guid.
 */
function createGuid(style) {
    if (style === void 0) { style = "D" /* GuidStyle.Digits */; }
    var theGuid = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__.newGuid)();
    if (style === "B" /* GuidStyle.Braces */) {
        theGuid = "{" + theGuid + "}";
    }
    else if (style === "P" /* GuidStyle.Parentheses */) {
        theGuid = "(" + theGuid + ")";
    }
    else if (style === "N" /* GuidStyle.Numeric */) {
        theGuid = theGuid.replace(/-/g, _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY);
    }
    return theGuid;
}
/**
 * Pass in the objects to merge as arguments.
 * @param obj1 - object to merge.  Set this argument to 'true' for a deep extend.
 * @param obj2 - object to merge.
 * @param obj3 - object to merge.
 * @param obj4 - object to merge.
 * @param obj5 - object to merge.
 * @returns The extended object.
 */
function extend(obj, obj2, obj3, obj4, obj5) {
    // Variables
    var extended = {};
    var deep = false;
    var i = 0;
    var length = arguments[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_LENGTH /* @min:%2elength */];
    var theArgs = arguments;
    // Check if a deep merge
    if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isBoolean)(theArgs[0])) {
        deep = theArgs[0];
        i++;
    }
    // Loop through each object and conduct a merge
    for (; i < length; i++) {
        var obj = theArgs[i];
        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_9__.objForEachKey)(obj, function (prop, value) {
            // If deep merge and property is an object, merge properties
            if (deep && value && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isObject)(value)) {
                if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isArray)(value)) {
                    extended[prop] = extended[prop] || [];
                    (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_10__.arrForEach)(value, function (arrayValue, arrayIndex) {
                        if (arrayValue && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isObject)(arrayValue)) {
                            extended[prop][arrayIndex] = extend(true, extended[prop][arrayIndex], arrayValue);
                        }
                        else {
                            extended[prop][arrayIndex] = arrayValue;
                        }
                    });
                }
                else {
                    extended[prop] = extend(true, extended[prop], value);
                }
            }
            else {
                extended[prop] = value;
            }
        });
    }
    return extended;
}
var getTime = _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_11__.perfNow;
function isValueKind(value) {
    // Always assume that it's a number (no type checking) for performance as this is used during the JSON serialization
    if (value === 0 /* eValueKind.NotSet */ || ((value > 0 /* eValueKind.NotSet */ && value <= 13 /* eValueKind.Pii_IPV4AddressLegacy */) || value === 32 /* eValueKind.CustomerContent_GenericContent */)) {
        return true;
    }
    return false;
}
function isDataType(value) {
    // Remark: 0 returns false, but it doesn't affect encoding anyways
    // Always assume that it's a number (no type checking) for performance as this is used during the JSON serialization
    if (value >= 0 && value <= 9) {
        return true;
    }
    return false;
}
function isSafariOrFirefox() {
    var nav = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.getNavigator)();
    // If non-browser navigator will be undefined
    if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isUndefined)(nav) && nav.userAgent) {
        var ua = nav.userAgent.toLowerCase();
        if ((ua[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_INDEX_OF /* @min:%2eindexOf */]("safari") >= 0 || ua[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_INDEX_OF /* @min:%2eindexOf */]("firefox") >= 0) && ua[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_INDEX_OF /* @min:%2eindexOf */]("chrome") < 0) {
            return true;
        }
    }
    return false;
}
function isArrayValid(value) {
    return value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_LENGTH /* @min:%2elength */] > 0;
}
function setProcessTelemetryTimings(event, identifier) {
    var evt = event;
    evt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_TIMINGS /* @min:%2etimings */] = evt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_TIMINGS /* @min:%2etimings */] || {};
    evt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_TIMINGS /* @min:%2etimings */][_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_PROCESS_TELEMETRY_ST0 /* @min:%2eprocessTelemetryStart */] = evt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_TIMINGS /* @min:%2etimings */][_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_PROCESS_TELEMETRY_ST0 /* @min:%2eprocessTelemetryStart */] || {};
    evt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_TIMINGS /* @min:%2etimings */][_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_PROCESS_TELEMETRY_ST0 /* @min:%2eprocessTelemetryStart */][identifier] = getTime();
}
/**
 * Returns a bitwise value for the FieldValueSanitizerType enum representing the decoded type of the passed value
 * @param value The value to determine the type
 */
function getFieldValueType(value) {
    var theType = 0 /* FieldValueSanitizerType.NotSet */;
    if (value !== null && value !== undefined) {
        var objType = typeof value;
        if (objType === "string") {
            theType = 1 /* FieldValueSanitizerType.String */;
        }
        else if (objType === "number") {
            theType = 2 /* FieldValueSanitizerType.Number */;
        }
        else if (objType === "boolean") {
            theType = 3 /* FieldValueSanitizerType.Boolean */;
        }
        else if (objType === _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimObject) {
            theType = 4 /* FieldValueSanitizerType.Object */;
            if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_3__.isArray)(value)) {
                theType = 4096 /* FieldValueSanitizerType.Array */;
                if (value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    // Empty arrays are not supported and are considered to be the same as null
                    theType |= getFieldValueType(value[0]);
                }
            }
            else if (ObjHasOwnProperty.call(value, "value")) {
                // Looks like an IEventProperty
                theType = 8192 /* FieldValueSanitizerType.EventProperty */ | getFieldValueType(value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_VALUE /* @min:%2evalue */]);
            }
        }
    }
    return theType;
}
/**
 * Helper to identify whether we are running in a chromium based browser environment
 */
function isChromium() {
    return !!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_1__.getInst)("chrome");
}
/**
 * Create and open an XMLHttpRequest object
 * @param method - The request method
 * @param urlString - The url
 * @param withCredentials - Option flag indicating that credentials should be sent
 * @param disabled - Optional flag indicating that the XHR object should be marked as disabled and not tracked (default is false)
 * @param isSync - Optional flag indicating if the instance should be a synchronous request (defaults to false)
 * @param timeout - Optional value identifying the timeout value that should be assigned to the XHR request
 * @returns A new opened XHR request
 */
function openXhr(method, urlString, withCredentials, disabled, isSync, timeout) {
    if (disabled === void 0) { disabled = false; }
    if (isSync === void 0) { isSync = false; }
    function _wrapSetXhrProp(xhr, prop, value) {
        try {
            xhr[prop] = value;
        }
        catch (e) {
            // - Wrapping as depending on the environment setting the property may fail (non-terminally)
        }
    }
    var xhr = new XMLHttpRequest();
    if (disabled) {
        // Tag the instance so it's not tracked (trackDependency)
        // If the environment has locked down the XMLHttpRequest (preventExtensions and/or freeze), this would
        // cause the request to fail and we no telemetry would be sent
        _wrapSetXhrProp(xhr, strDisabledPropertyName, disabled);
    }
    if (withCredentials) {
        // Some libraries require that the withCredentials flag is set "before" open and
        // - Wrapping as IE 10 has started throwing when setting before open
        _wrapSetXhrProp(xhr, strWithCredentials, withCredentials);
    }
    xhr.open(method, urlString, !isSync);
    if (withCredentials) {
        // withCredentials should be set AFTER open (https://xhr.spec.whatwg.org/#the-withcredentials-attribute)
        // And older firefox instances from 11+ will throw for sync events (current versions don't) which happens during unload processing
        _wrapSetXhrProp(xhr, strWithCredentials, withCredentials);
    }
    // Only set the timeout for asynchronous requests as
    // "Timeout shouldn't be used for synchronous XMLHttpRequests requests used in a document environment or it will throw an InvalidAccessError exception.""
    // https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest/timeout
    if (!isSync && timeout) {
        _wrapSetXhrProp(xhr, strTimeout, timeout);
    }
    return xhr;
}
/**
 * Check to see if the value is > 0
 * @param value - The value to check
 * @returns true if > 0 otherwise false
 */
function isGreaterThanZero(value) {
    return value > 0;
}
//# sourceMappingURL=Utils.js.map

/***/ }),
/* 22 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _DYN_CAN_HANDLE: () => (/* binding */ _DYN_CAN_HANDLE),
/* harmony export */   _DYN_HANDLE_FIELD: () => (/* binding */ _DYN_HANDLE_FIELD),
/* harmony export */   _DYN_INDEX_OF: () => (/* binding */ _DYN_INDEX_OF),
/* harmony export */   _DYN_INITIALIZE: () => (/* binding */ _DYN_INITIALIZE),
/* harmony export */   _DYN_KIND: () => (/* binding */ _DYN_KIND),
/* harmony export */   _DYN_LENGTH: () => (/* binding */ _DYN_LENGTH),
/* harmony export */   _DYN_LOGGER: () => (/* binding */ _DYN_LOGGER),
/* harmony export */   _DYN_POLL_INTERNAL_LOGS: () => (/* binding */ _DYN_POLL_INTERNAL_LOGS),
/* harmony export */   _DYN_PROCESS_TELEMETRY_ST0: () => (/* binding */ _DYN_PROCESS_TELEMETRY_ST0),
/* harmony export */   _DYN_RM_FIELD_SANITIZER: () => (/* binding */ _DYN_RM_FIELD_SANITIZER),
/* harmony export */   _DYN_RM_SANITIZER: () => (/* binding */ _DYN_RM_SANITIZER),
/* harmony export */   _DYN_TIMINGS: () => (/* binding */ _DYN_TIMINGS),
/* harmony export */   _DYN_VALUE: () => (/* binding */ _DYN_VALUE)
/* harmony export */ });
/*
 * 1DS JS SDK Core, 4.0.3
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */

// Licensed under the MIT License.
// @skip-file-minify
// ##############################################################
// AUTO GENERATED FILE: This file is Auto Generated during build.
// ##############################################################
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Note: DON'T Export these const from the package as we are still targeting ES3 this will export a mutable variables that someone could change!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
var _DYN_INITIALIZE = "initialize"; // Count: 4
var _DYN_LOGGER = "logger"; // Count: 4
var _DYN_INDEX_OF = "indexOf"; // Count: 4
var _DYN_TIMINGS = "timings"; // Count: 4
var _DYN_POLL_INTERNAL_LOGS = "pollInternalLogs"; // Count: 4
var _DYN_VALUE = "value"; // Count: 20
var _DYN_KIND = "kind"; // Count: 5
var _DYN_LENGTH = "length"; // Count: 7
var _DYN_PROCESS_TELEMETRY_ST0 = "processTelemetryStart"; // Count: 3
var _DYN_HANDLE_FIELD = "handleField"; // Count: 3
var _DYN_RM_SANITIZER = "rmSanitizer"; // Count: 3
var _DYN_RM_FIELD_SANITIZER = "rmFieldSanitizer"; // Count: 3
var _DYN_CAN_HANDLE = "canHandle"; // Count: 7
//# sourceMappingURL=__DynamicConstants.js.map

/***/ }),
/* 23 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ObjClass: () => (/* binding */ ObjClass),
/* harmony export */   ObjProto: () => (/* binding */ ObjProto),
/* harmony export */   strDefault: () => (/* binding */ strDefault),
/* harmony export */   strShimFunction: () => (/* binding */ strShimFunction),
/* harmony export */   strShimObject: () => (/* binding */ strShimObject),
/* harmony export */   strShimPrototype: () => (/* binding */ strShimPrototype),
/* harmony export */   strShimUndefined: () => (/* binding */ strShimUndefined)
/* harmony export */ });
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var strShimFunction = "function";
var strShimObject = "object";
var strShimUndefined = "undefined";
var strShimPrototype = "prototype";
var strDefault = "default";
var ObjClass = Object;
var ObjProto = ObjClass[strShimPrototype];
//# sourceMappingURL=Constants.js.map

/***/ }),
/* 24 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   strIndexOf: () => (/* binding */ strIndexOf),
/* harmony export */   strLastIndexOf: () => (/* binding */ strLastIndexOf)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * The `strIndexOf()` method, given two arguments: the string and a substring to search for, searches
 * the entire calling string, and returns the index of the first occurrence of the specified substring.
 * Given a thrid argument: a number, the method returns the first occurrence of the specified substring
 * at an index greater than or equal to the specified number.
 * @group String
 * @param value - The value to be checked for the seeach string
 * @param searchString - The substring to search for in the value
 * @param position - The starting position to search from
 * @example
 * ```ts
 * strIndexOf('hello world', '') // returns 0
 * strIndexOf('hello world', '', 0) // returns 0
 * strIndexOf('hello world', '', 3) // returns 3
 * strIndexOf('hello world', '', 8) // returns 8
 *
 * // However, if the thrid argument is greater than the length of the string
 * strIndexOf('hello world', '', 11) // returns 11
 * strIndexOf('hello world', '', 13) // returns 11
 * strIndexOf('hello world', '', 22) // returns 11
 *
 * strIndexOf('Blue Whale', 'Blue')      // returns  0
 * strIndexOf('Blue Whale', 'Blute')     // returns -1
 * strIndexOf('Blue Whale', 'Whale', 0)  // returns  5
 * strIndexOf('Blue Whale', 'Whale', 5)  // returns  5
 * strIndexOf('Blue Whale', 'Whale', 7)  // returns -1
 * strIndexOf('Blue Whale', '')          // returns  0
 * strIndexOf('Blue Whale', '', 9)       // returns  9
 * strIndexOf('Blue Whale', '', 10)      // returns 10
 * strIndexOf('Blue Whale', '', 11)      // returns 10
 * ```
 */
var strIndexOf = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunction)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.INDEX_OF, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto);
/**
 * The `strLastIndexOf()` method, given two arguments: the string and a substring to search for, searches
 * the entire calling string, and returns the index of the last occurrence of the specified substring.
 * Given a third argument: a number, the method returns the last occurrence of the specified substring
 * at an index less than or equal to the specified number.
 * @group String
 * @param value - The value to be checked for the seeach string
 * @param searchString - The substring to search for in the value
 * @param position - The starting position to search from
 * @example
 * ```ts
 * strLastIndexOf('canal', 'a');     // returns 3
 * strLastIndexOf('canal', 'a', 2);  // returns 1
 * strLastIndexOf('canal', 'a', 0);  // returns -1
 * strLastIndexOf('canal', 'x');     // returns -1
 * strLastIndexOf('canal', 'c', -5); // returns 0
 * strLastIndexOf('canal', 'c', 0);  // returns 0
 * strLastIndexOf('canal', '');      // returns 5
 * strLastIndexOf('canal', '', 2);   // returns 2
 * ```
 */
var strLastIndexOf = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunction)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.LAST_INDEX_OF, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto);
//# sourceMappingURL=index_of.js.map

/***/ }),
/* 25 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _unwrapFunction: () => (/* binding */ _unwrapFunction),
/* harmony export */   _unwrapFunctionWithPoly: () => (/* binding */ _unwrapFunctionWithPoly),
/* harmony export */   _unwrapInstFunction: () => (/* binding */ _unwrapInstFunction),
/* harmony export */   _unwrapProp: () => (/* binding */ _unwrapProp)
/* harmony export */ });
/* harmony import */ var _helpers_diagnostics__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(26);
/* harmony import */ var _helpers_throw__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19);
/* harmony import */ var _string_as_string__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(27);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */




var _arrSlice = _constants__WEBPACK_IMPORTED_MODULE_0__.ArrProto[_constants__WEBPACK_IMPORTED_MODULE_0__.SLICE];
var _throwMissingFunction = function (funcName, thisArg) {
    (0,_helpers_throw__WEBPACK_IMPORTED_MODULE_1__.throwTypeError)("'" + (0,_string_as_string__WEBPACK_IMPORTED_MODULE_2__.asString)(funcName) + "' not defined for " + (0,_helpers_diagnostics__WEBPACK_IMPORTED_MODULE_3__.dumpObj)(thisArg));
};
/**
 * @internal
 * @ignore
 * Internal helper to run the named function on the passed first argument, this does not support polyfill
 * or prototype fallback, so the function must exist on the provided first argument.
 * If the first argument is null, undefined or the function does not exist an exception will be thrown
 * by the runtime
 * @param funcName - The function name to call on the first argument passed to the wrapped function
 * @returns A function which will call the funcName against the first passed argument and pass on the remaining arguments
 */
var _unwrapInstFunction = function (funcName) {
    return function (thisArg) {
        return thisArg[funcName].apply(thisArg, _arrSlice.call(arguments, 1));
    };
};
/**
 * @internal
 * @ignore
 * Internal helper to convert an expanded function back into an instance `this` function call
 * @param funcName - The function name to call on the first argument passed to the wrapped function
 * @param clsProto - The Class or class prototype to fallback to if the instance doesn't have the function.
 * @returns A function which will call the funcName against the first passed argument and pass on the remaining arguments
 */
var _unwrapFunction = function (funcName, clsProto) {
    var clsFn = clsProto && clsProto[funcName];
    return function (thisArg) {
        var theFunc = (thisArg && thisArg[funcName]) || clsFn;
        if (theFunc) {
            return theFunc.apply(thisArg, _arrSlice.call(arguments, 1));
        }
        _throwMissingFunction(funcName, thisArg);
    };
};
/**
 * @internal
 * @ignore
 * Internal helper to convert an expanded function back into an instance `this` function call
 * @param funcName - The function name to call on the first argument passed to the wrapped function
 * @param clsProto - The Class or class prototype to fallback to if the instance doesn't have the function.
 * @param polyFunc - The function to call if not available on the thisArg, act like the polyfill
 * @returns A function which will call the funcName against the first passed argument and pass on the remaining arguments
 */
var _unwrapFunctionWithPoly = function (funcName, clsProto, polyFunc) {
    var clsFn = clsProto && clsProto[funcName];
    return function (thisArg) {
        var theFunc = (thisArg && thisArg[funcName]) || clsFn;
        if (theFunc || polyFunc) {
            var theArgs = arguments;
            return (theFunc || polyFunc).apply(thisArg, theFunc ? _arrSlice.call(theArgs, 1) : theArgs);
        }
        _throwMissingFunction(funcName, thisArg);
    };
};
/**
 * @internal
 * @ignore
 * Internal helper to lookup and return the named property from the first argument (which becomes the this)
 *
 * @since 0.4.2
 * @typeParam T - The type of the object which contains the propName
 * @param propName - The property name
 * @returns The value of the property
 */
function _unwrapProp(propName) {
    return function (thisArg) {
        return thisArg[propName];
    };
}
//# sourceMappingURL=unwrapFunction.js.map

/***/ }),
/* 26 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   dumpObj: () => (/* binding */ dumpObj)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8);
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(13);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * Returns string representation of an object suitable for diagnostics logging.
 * @group Error
 * @group Diagnostic
 * @param object - The object to be converted to a diagnostic string value
 * @param format - Identifies whether the JSON value should be formated
 * - `true` - Format with 4 spaces
 * - 'number' - The number of spaces to format with
 * - `false` (or not Truthy) - Do not format
 */
function dumpObj(object, format) {
    var propertyValueDump = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.EMPTY;
    if ((0,_base__WEBPACK_IMPORTED_MODULE_1__.isError)(object)) {
        propertyValueDump = "{ stack: '" + object.stack + "', message: '" + object.message + "', name: '" + object.name + "'";
    }
    else {
        try {
            propertyValueDump = JSON.stringify(object, _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE, format ? ((0,_base__WEBPACK_IMPORTED_MODULE_1__.isNumber)(format) ? format : 4) : _internal_constants__WEBPACK_IMPORTED_MODULE_0__.UNDEF_VALUE);
        }
        catch (e) {
            // Unable to convert object (probably circular)
            propertyValueDump = " - " + dumpObj(e, format);
        }
    }
    return (0,_base__WEBPACK_IMPORTED_MODULE_1__.objToString)(object) + ": " + propertyValueDump;
}
//# sourceMappingURL=diagnostics.js.map

/***/ }),
/* 27 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   asString: () => (/* binding */ asString)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

/**
 * The asString() method returns a string representing the value by
 * explicitly using `String(`value`)`.
 *
 * @since 0.4.3
 * @group String
 * @group Conversion
 * @group Value
 * @param value - The value to get a string representation of
 * @example
 * ```ts
 * const arr = [ 1, 2, 3];
 * asString(arr);       // "1,2,3"
 * asString(null);      // "null"
 * asString(undefined); // "undefined"
 * asString(42);        // "42"
 * asString(Symbol.for("Hello"));   // "Symbol(Hello)"
 * ```
 */
var asString = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.StrCls;
//# sourceMappingURL=as_string.js.map

/***/ }),
/* 28 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   polyStrSubstr: () => (/* binding */ polyStrSubstr),
/* harmony export */   strLeft: () => (/* binding */ strLeft),
/* harmony export */   strRight: () => (/* binding */ strRight),
/* harmony export */   strSubstr: () => (/* binding */ strSubstr),
/* harmony export */   strSubstring: () => (/* binding */ strSubstring)
/* harmony export */ });
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13);
/* harmony import */ var _helpers_diagnostics__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26);
/* harmony import */ var _helpers_throw__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(19);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25);
/* harmony import */ var _math_min_max__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(29);
/* harmony import */ var _slice__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(30);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */







/**
 * The `strSubstring()` method returns the part of the string between the start and end indexes, or to the end of the string.
 *
 * `strSubstring()` extracts characters from indexStart up to but not including indexEnd. In particular:
 * - If `indexEnd` is omitted, strSubstring() extracts characters to the end of the string.
 * - If `indexStart` is equal to indexEnd, strSubstring() returns an empty string.
 * - If `indexStart` is greater than indexEnd, then the effect of strSubstring() is as if the two arguments were swapped; see example below.
 *
 * Any argument value that is less than 0 or greater than `value.length` is treated as if it were 0 and `value.length`, respectively.
 *
 * Any argument value that is NaN is treated as if it were 0.
 * @group String
 * @param value - The string value to return the substring from.
 * @param indexStart - The index of the first character to include in the returned substring.
 * @param indexEnd - The index of the first character to exclude from the returned substring.
 * @return A new string containing the specified part of the given string
 * @example
 * ```ts
 * const anyString = 'Nevware21';
 * // Displays 'N'
 * console.log(strSubstring(anyString, 0, 1));
 * console.log(strSubstring(anyString, 1, 0));
 *
 * // Displays 'Nevwar'
 * console.log(strSubstring(anyString, 0, 6));
 *
 * // Displays 'are21'
 * console.log(strSubstring(anyString, 4));
 *
 * // Displays 'are'
 * console.log(strSubstring(anyString, 4, 7));
 *
 * // Displays '21'
 * console.log(strSubstring(anyString, 7, 4));
 *
 * // Displays 'Nevware'
 * console.log(strSubstring(anyString, 0, 7));
 *
 * // Displays 'Nevware21'
 * console.log(strSubstring(anyString, 0, 10));
 * ```
 */
var strSubstring = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunction)("substring", _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto);
/**
 * The strSubstr() method returns a portion of the string, starting at the specified index and extending for a given
 * number of characters afterwards.
 *
 * @since 0.4.2
 * @group String
 * @param value - The string value to return the substring from.
 * @param start - The index of the first character to include in the returned substring.
 * @param length - The number of characters to extract.
 * @returns A new string containing the specified part of the given string.
 */
var strSubstr = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunctionWithPoly)("substr", _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto, polyStrSubstr);
/**
 * The polyStrSubstr() method returns a portion of the string, starting at the specified index and extending for a given
 * number of characters afterwards.
 *
 * @since 0.4.2
 * @group String
 * @group Polyfill
 * @param value - The string value to return the substring from.
 * @param start - The index of the first character to include in the returned substring.
 * @param length - The number of characters to extract.
 * @returns A new string containing the specified part of the given string.
 */
function polyStrSubstr(value, start, length) {
    if ((0,_helpers_base__WEBPACK_IMPORTED_MODULE_2__.isNullOrUndefined)(value)) {
        (0,_helpers_throw__WEBPACK_IMPORTED_MODULE_3__.throwTypeError)("'polyStrSubstr called with invalid " + (0,_helpers_diagnostics__WEBPACK_IMPORTED_MODULE_4__.dumpObj)(value));
    }
    if (length < 0) {
        return _internal_constants__WEBPACK_IMPORTED_MODULE_1__.EMPTY;
    }
    // If start is omitted or undefined, its treated as zero
    start = start || 0;
    if (start < 0) {
        start = (0,_math_min_max__WEBPACK_IMPORTED_MODULE_5__.mathMax)(start + value[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.LENGTH], 0);
    }
    if ((0,_helpers_base__WEBPACK_IMPORTED_MODULE_2__.isUndefined)(length)) {
        return (0,_slice__WEBPACK_IMPORTED_MODULE_6__.strSlice)(value, start);
    }
    return (0,_slice__WEBPACK_IMPORTED_MODULE_6__.strSlice)(value, start, start + length);
}
/**
 * Returns a substring of the string starting from the left.
 *
 * `strLeft()` extracts the number of characters from left of the string up to the count. In particular:
 * - If `count` is less than zero, strLeft() returns an empty string.
 * - If `count` is less than `value.length', strLeft() returns a new string with the `count` number of characters from the left of the string.
 * - If `count` is greater than `value.length`, then the value original value is returned.
 *
 * Any argument value that is NaN is treated as if it were 0.
 *
 * @since 0.4.2
 * @group String
 * @param value - The string value to return the substring from.
 * @param count - The number of characters to extract
 * @returns The substring based on the count number of characters from the right
 * @example
 * ```ts
 * strLeft("Nevware21", -1); // ""
 * strLeft("Nevware21", 0); // ""
 * strLeft("Nevware21", 1); // "N"
 * strLeft("Nevware21", 3); // "Nev"
 * strLeft("Nevware21", 21); // "Nevware21"
 * ```
 */
function strLeft(value, count) {
    return strSubstring(value, 0, count);
}
/**
 * Returns a substring of the string starting from the right.
 *
 * `strRight()` extracts the number of characters from right of the string up to the count. In particular:
 * - If `count` is less than zero, strRight() returns an empty string.
 * - If `count` is less than `value.length', strRight() returns a new string with the `count` number of characters from the right of the string.
 * - If `count` is greater than `value.length`, then the value original value is returned.
 *
 * Any argument value that is NaN is treated as if it were 0.
 *
 * @since 0.4.2
 * @group String
 * @param value - The string value to return the substring from.
 * @param count - The number of characters to extract
 * @returns The substring based on the count number of characters from the right
 * @example
 * ```ts
 * strRight("Nevware21", -1); // ""
 * strRight("Nevware21", 0); // ""
 * strRight("Nevware21", 1); // "1"
 * strRight("Nevware21", 3); // "e21"
 * strRight("Nevware21", 21); // "Nevware21"
 * ```
 */
function strRight(value, count) {
    var len = value[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.LENGTH];
    if (count <= 0) {
        return _internal_constants__WEBPACK_IMPORTED_MODULE_1__.EMPTY;
    }
    return len > count ? strSubstring(value, len - count) : value;
}
//# sourceMappingURL=substring.js.map

/***/ }),
/* 29 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   mathMax: () => (/* binding */ mathMax),
/* harmony export */   mathMin: () => (/* binding */ mathMin)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

/**
 * The mathMin() function returns the lowest-valued number passed into it, or NaN if any
 * parameter isn't a number and can't be converted into one.
 *
 * If no arguments are given, the result is Infinity.
 *
 * If at least one of arguments cannot be converted to a number, the result is NaN.
 *
 * @since 0.4.2
 * @group Math
 * @param values - Zero or more numbers among which the lowest value will be selected and returned.
 * @returns The smallest of the given numbers. If any one or more of the parameters cannot
 * be converted into a number, NaN is returned. The result is Infinity if no parameters are provided.
 * @example
 * ```ts
 * const x = 10, y = -20;
 * const z = Math.min(x, y); // -20
 * ```
 */
var mathMin = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.MathCls.min;
/**
 * The `mathMax()` function returns the largest of the zero or more numbers given as input
 * parameters, or NaN if any parameter isn't a number and can't be converted into one.
 *
 * If no arguments are given, the result is -Infinity.
 *
 * If at least one of arguments cannot be converted to a number, the result is NaN.
 *
 * @since 0.4.2
 * @group Math
 * @param values - Zero or more numbers among which the largest value will be selected and returned.
 * @returns The largest of the given numbers. If any one or more of the parameters cannot be
 * converted into a number, NaN is returned. The result is -Infinity if no parameters are provided.
 * @example
 * ```ts
 * mathMax(10, 20);   //  20
 * mathMax(-10, -20); // -10
 * mathMax(-10, 20);  //  20
 * ```
 */
var mathMax = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.MathCls.max;
//# sourceMappingURL=min_max.js.map

/***/ }),
/* 30 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   strSlice: () => (/* binding */ strSlice)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * The `strSlice()` method extracts a section of a string and returns it as a new string, without
 * modifying the original string.
 * `strSlice()` extracts the text from one string and returns a new string. Changes to the text in one
 * string do not affect the other string.
 * `strSlice()` extracts up to but not including endIndex. str.slice(1, 4) extracts the second character
 * through the fourth character (characters indexed 1, 2, and 3).
 * As an example, strSlice(2, -1) extracts the third character through the second to last character
 * in the string.
 * @group String
 * @param value - The value to haveextract a number
 * @param beginIndex - The zero-based index at which to begin extraction.
 * If `beginIndex` is negative, `strSlice()` begins extraction from `value.length + beginIndex`.
 * (E.g. `strSlice("test", -2)` returns "st")
 * If `beginIndex` is omitted, undefined, or cannot be converted to a number (using Number(`beginIndex`)),
 * strSlice() begins extraction from the beginning of the string. (E.g. `strSlice("test")` returns "test")
 * If `beginIndex` is greater than or equal to `value.length`, an empty string is returned.
 * (E.g. `strSlice("test", 4)` returns "")
 * @param endIndex - The index of the first character to exclude from the returned substring.
 * If `endIndex` is omitted, undefined, or cannot be converted to a number (using Number(`endIndex`))
 * strSlice() extracts to the end of the string. (E.g. `strSlice("test", 2)` returns "st")
 * If `endIndex` is greater than `value.length`, strSlice() also extracts to the end of the string.
 * (E.g. strSlice("test", 2, 10)` returns "st")
 * If `endIndex` is negative, `strSlice()` treats it as `value.length + endIndex`. (E.g, if `endIndex`
 * is -2, it is treated as `value.length - 2` and `strSlice("test", 1, -2)` returns "e") .
 * If `endIndex` represents a position that is before the one represented by startIndex, `strSlice()`
 * returns "". (E.g `strSlice("test", 2, -10)`, strSlice("test", -1, -2)` or `strSlice("test", 3, 2)`).
 * @returns A new string containing the extracted section of the string.
 */
var strSlice = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunction)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.SLICE, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto);
//# sourceMappingURL=slice.js.map

/***/ }),
/* 31 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createCustomDomEvent: () => (/* binding */ createCustomDomEvent),
/* harmony export */   dispatchEvent: () => (/* binding */ dispatchEvent),
/* harmony export */   findMetaTag: () => (/* binding */ findMetaTag),
/* harmony export */   findNamedServerTiming: () => (/* binding */ findNamedServerTiming),
/* harmony export */   getConsole: () => (/* binding */ getConsole),
/* harmony export */   getCrypto: () => (/* binding */ getCrypto),
/* harmony export */   getIEVersion: () => (/* binding */ getIEVersion),
/* harmony export */   getJSON: () => (/* binding */ getJSON),
/* harmony export */   getLocation: () => (/* binding */ getLocation),
/* harmony export */   getMsCrypto: () => (/* binding */ getMsCrypto),
/* harmony export */   hasJSON: () => (/* binding */ hasJSON),
/* harmony export */   isBeaconsSupported: () => (/* binding */ isBeaconsSupported),
/* harmony export */   isFetchSupported: () => (/* binding */ isFetchSupported),
/* harmony export */   isIE: () => (/* binding */ isIE),
/* harmony export */   isReactNative: () => (/* binding */ isReactNative),
/* harmony export */   isSafari: () => (/* binding */ isSafari),
/* harmony export */   isXhrSupported: () => (/* binding */ isXhrSupported),
/* harmony export */   sendCustomEvent: () => (/* binding */ sendCustomEvent),
/* harmony export */   setEnableEnvMocks: () => (/* binding */ setEnableEnvMocks),
/* harmony export */   useXDomainRequest: () => (/* binding */ useXDomainRequest)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(24);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(40);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(32);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(33);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(34);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */








/**
 * This file exists to hold environment utilities that are required to check and
 * validate the current operating environment. Unless otherwise required, please
 * only use defined methods (functions) in this class so that users of these
 * functions/properties only need to include those that are used within their own modules.
 */
var strDocumentMode = "documentMode";
var strLocation = "location";
var strConsole = "console";
var strJSON = "JSON";
var strCrypto = "crypto";
var strMsCrypto = "msCrypto";
var strReactNative = "ReactNative";
var strMsie = "msie";
var strTrident = "trident/";
var strXMLHttpRequest = "XMLHttpRequest";
var _isTrident = null;
var _navUserAgentCheck = null;
var _enableMocks = false;
var _useXDomainRequest = null;
var _beaconsSupported = null;
function _hasProperty(theClass, property) {
    var supported = false;
    if (theClass) {
        try {
            supported = property in theClass;
            if (!supported) {
                var proto = theClass[_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimPrototype];
                if (proto) {
                    supported = property in proto;
                }
            }
        }
        catch (e) {
            // Do Nothing
        }
        if (!supported) {
            try {
                var tmp = new theClass();
                supported = !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.isUndefined)(tmp[property]);
            }
            catch (e) {
                // Do Nothing
            }
        }
    }
    return supported;
}
/**
 * Enable the lookup of test mock objects if requested
 * @param enabled
 */
function setEnableEnvMocks(enabled) {
    _enableMocks = enabled;
}
/**
 * Returns the global location object if it is present otherwise null.
 * This helper is used to access the location object without causing an exception
 * "Uncaught ReferenceError: location is not defined"
 */
function getLocation(checkForMock) {
    if (checkForMock && _enableMocks) {
        var mockLocation = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)("__mockLocation");
        if (mockLocation) {
            return mockLocation;
        }
    }
    if (typeof location === _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimObject && location) {
        return location;
    }
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)(strLocation);
}
/**
 * Returns the global console object
 */
function getConsole() {
    if (typeof console !== _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimUndefined) {
        return console;
    }
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)(strConsole);
}
/**
 * Checks if JSON object is available, this is required as we support the API running without a
 * window /document (eg. Node server, electron webworkers) and if we attempt to assign a history
 * object to a local variable or pass as an argument an "Uncaught ReferenceError: JSON is not defined"
 * exception will be thrown.
 * Defined as a function to support lazy / late binding environments.
 */
function hasJSON() {
    return Boolean((typeof JSON === _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimObject && JSON) || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)(strJSON) !== null);
}
/**
 * Returns the global JSON object if it is present otherwise null.
 * This helper is used to access the JSON object without causing an exception
 * "Uncaught ReferenceError: JSON is not defined"
 */
function getJSON() {
    if (hasJSON()) {
        return JSON || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)(strJSON);
    }
    return null;
}
/**
 * Returns the crypto object if it is present otherwise null.
 * This helper is used to access the crypto object from the current
 * global instance which could be window or globalThis for a web worker
 */
function getCrypto() {
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)(strCrypto);
}
/**
 * Returns the crypto object if it is present otherwise null.
 * This helper is used to access the crypto object from the current
 * global instance which could be window or globalThis for a web worker
 */
function getMsCrypto() {
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)(strMsCrypto);
}
/**
 * Returns whether the environment is reporting that we are running in a React Native Environment
 */
function isReactNative() {
    // If running in React Native, navigator.product will be populated
    var nav = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getNavigator)();
    if (nav && nav.product) {
        return nav.product === strReactNative;
    }
    return false;
}
/**
 * Identifies whether the current environment appears to be IE
 */
function isIE() {
    var nav = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getNavigator)();
    if (nav && (nav[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_USER_AGENT /* @min:%2euserAgent */] !== _navUserAgentCheck || _isTrident === null)) {
        // Added to support test mocking of the user agent
        _navUserAgentCheck = nav[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_USER_AGENT /* @min:%2euserAgent */];
        var userAgent = (_navUserAgentCheck || _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]();
        _isTrident = ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_5__.strContains)(userAgent, strMsie) || (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_5__.strContains)(userAgent, strTrident));
    }
    return _isTrident;
}
/**
 * Gets IE version returning the document emulation mode if we are running on IE, or null otherwise
 */
function getIEVersion(userAgentStr) {
    if (userAgentStr === void 0) { userAgentStr = null; }
    if (!userAgentStr) {
        var navigator_1 = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getNavigator)() || {};
        userAgentStr = navigator_1 ? (navigator_1.userAgent || _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]() : _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY;
    }
    var ua = (userAgentStr || _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]();
    // Also check for documentMode in case X-UA-Compatible meta tag was included in HTML.
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_5__.strContains)(ua, strMsie)) {
        var doc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getDocument)() || {};
        return Math.max(parseInt(ua[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SPLIT /* @min:%2esplit */](strMsie)[1]), (doc[strDocumentMode] || 0));
    }
    else if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_5__.strContains)(ua, strTrident)) {
        var tridentVer = parseInt(ua[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SPLIT /* @min:%2esplit */](strTrident)[1]);
        if (tridentVer) {
            return tridentVer + 4;
        }
    }
    return null;
}
function isSafari(userAgentStr) {
    if (!userAgentStr || !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.isString)(userAgentStr)) {
        var navigator_2 = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getNavigator)() || {};
        userAgentStr = navigator_2 ? (navigator_2.userAgent || _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]() : _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY;
    }
    var ua = (userAgentStr || _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]();
    return ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.strIndexOf)(ua, "safari") >= 0);
}
/**
 * Checks if HTML5 Beacons are supported in the current environment.
 * @param useCached - [Optional] used for testing to bypass the cached lookup, when `true` this will
 * cause the cached global to be reset.
 * @returns True if supported, false otherwise.
 */
function isBeaconsSupported(useCached) {
    if (_beaconsSupported === null || useCached === false) {
        _beaconsSupported = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.hasNavigator)() && Boolean((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getNavigator)().sendBeacon);
    }
    return _beaconsSupported;
}
/**
 * Checks if the Fetch API is supported in the current environment.
 * @param withKeepAlive - [Optional] If True, check if fetch is available and it supports the keepalive feature, otherwise only check if fetch is supported
 * @returns True if supported, otherwise false
 */
function isFetchSupported(withKeepAlive) {
    var isSupported = false;
    try {
        isSupported = !!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)("fetch");
        var request = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)("Request");
        if (isSupported && withKeepAlive && request) {
            isSupported = _hasProperty(request, "keepalive");
        }
    }
    catch (e) {
        // Just Swallow any failure during availability checks
    }
    return isSupported;
}
function useXDomainRequest() {
    if (_useXDomainRequest === null) {
        _useXDomainRequest = (typeof XDomainRequest !== _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimUndefined);
        if (_useXDomainRequest && isXhrSupported()) {
            _useXDomainRequest = _useXDomainRequest && !_hasProperty((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)(strXMLHttpRequest), "withCredentials");
        }
    }
    return _useXDomainRequest;
}
/**
 * Checks if XMLHttpRequest is supported
 * @returns True if supported, otherwise false
 */
function isXhrSupported() {
    var isSupported = false;
    try {
        var xmlHttpRequest = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)(strXMLHttpRequest);
        isSupported = !!xmlHttpRequest;
    }
    catch (e) {
        // Just Swallow any failure during availability checks
    }
    return isSupported;
}
function _getNamedValue(values, name) {
    if (values) {
        for (var i = 0; i < values[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LENGTH /* @min:%2elength */]; i++) {
            var value = values[i];
            if (value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_NAME /* @min:%2ename */]) {
                if (value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_NAME /* @min:%2ename */] === name) {
                    return value;
                }
            }
        }
    }
    return {};
}
/**
 * Helper function to fetch the named meta-tag from the page.
 * @param name
 */
function findMetaTag(name) {
    var doc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getDocument)();
    if (doc && name) {
        // Look for a meta-tag
        return _getNamedValue(doc.querySelectorAll("meta"), name).content;
    }
    return null;
}
/**
 * Helper function to fetch the named server timing value from the page response (first navigation event).
 * @param name
 */
function findNamedServerTiming(name) {
    var value;
    var perf = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.getPerformance)();
    if (perf) {
        // Try looking for a server-timing header
        var navPerf = perf.getEntriesByType("navigation") || [];
        value = _getNamedValue((navPerf[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LENGTH /* @min:%2elength */] > 0 ? navPerf[0] : {}).serverTiming, name).description;
    }
    return value;
}
// TODO: should reuse this method for analytics plugin
function dispatchEvent(target, evnt) {
    if (target && target.dispatchEvent && evnt) {
        target.dispatchEvent(evnt);
        return true;
    }
    return false;
}
function createCustomDomEvent(eventName, details) {
    var event = null;
    var detail = { detail: details || null };
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.isFunction)(CustomEvent)) { // Use CustomEvent constructor when available
        event = new CustomEvent(eventName, detail);
    }
    else { // CustomEvent has no constructor in IE
        var doc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getDocument)();
        if (doc && doc.createEvent) {
            event = doc.createEvent("CustomEvent");
            event.initCustomEvent(eventName, true, true, detail);
        }
    }
    return event;
}
function sendCustomEvent(evtName, cfg, customDetails) {
    var global = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getGlobal)();
    if (global && global.CustomEvent) {
        try {
            var details = { cfg: cfg || null, customDetails: customDetails || null };
            return dispatchEvent(global, createCustomDomEvent(evtName, details));
        }
        catch (e) {
            // eslint-disable-next-line no-empty
        }
    }
    return false;
}
//# sourceMappingURL=EnvUtils.js.map

/***/ }),
/* 32 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _DYN_ADD_NOTIFICATION_LIS1: () => (/* binding */ _DYN_ADD_NOTIFICATION_LIS1),
/* harmony export */   _DYN_APPLY: () => (/* binding */ _DYN_APPLY),
/* harmony export */   _DYN_BLK_VAL: () => (/* binding */ _DYN_BLK_VAL),
/* harmony export */   _DYN_CANCEL: () => (/* binding */ _DYN_CANCEL),
/* harmony export */   _DYN_COMPLETE: () => (/* binding */ _DYN_COMPLETE),
/* harmony export */   _DYN_CREATE_NEW: () => (/* binding */ _DYN_CREATE_NEW),
/* harmony export */   _DYN_DIAG_LOG: () => (/* binding */ _DYN_DIAG_LOG),
/* harmony export */   _DYN_ENABLED: () => (/* binding */ _DYN_ENABLED),
/* harmony export */   _DYN_GET_CTX: () => (/* binding */ _DYN_GET_CTX),
/* harmony export */   _DYN_GET_NEXT: () => (/* binding */ _DYN_GET_NEXT),
/* harmony export */   _DYN_GET_NOTIFY_MGR: () => (/* binding */ _DYN_GET_NOTIFY_MGR),
/* harmony export */   _DYN_GET_PLUGIN: () => (/* binding */ _DYN_GET_PLUGIN),
/* harmony export */   _DYN_GET_PROCESS_TEL_CONT0: () => (/* binding */ _DYN_GET_PROCESS_TEL_CONT0),
/* harmony export */   _DYN_HANDLER: () => (/* binding */ _DYN_HANDLER),
/* harmony export */   _DYN_HDLR: () => (/* binding */ _DYN_HDLR),
/* harmony export */   _DYN_IDENTIFIER: () => (/* binding */ _DYN_IDENTIFIER),
/* harmony export */   _DYN_INITIALIZE: () => (/* binding */ _DYN_INITIALIZE),
/* harmony export */   _DYN_IS_ASYNC: () => (/* binding */ _DYN_IS_ASYNC),
/* harmony export */   _DYN_IS_CHILD_EVT: () => (/* binding */ _DYN_IS_CHILD_EVT),
/* harmony export */   _DYN_IS_INITIALIZED: () => (/* binding */ _DYN_IS_INITIALIZED),
/* harmony export */   _DYN_LENGTH: () => (/* binding */ _DYN_LENGTH),
/* harmony export */   _DYN_LOGGER: () => (/* binding */ _DYN_LOGGER),
/* harmony export */   _DYN_LOGGING_LEVEL_CONSOL4: () => (/* binding */ _DYN_LOGGING_LEVEL_CONSOL4),
/* harmony export */   _DYN_LOG_INTERNAL_MESSAGE: () => (/* binding */ _DYN_LOG_INTERNAL_MESSAGE),
/* harmony export */   _DYN_MESSAGE: () => (/* binding */ _DYN_MESSAGE),
/* harmony export */   _DYN_MESSAGE_ID: () => (/* binding */ _DYN_MESSAGE_ID),
/* harmony export */   _DYN_NAME: () => (/* binding */ _DYN_NAME),
/* harmony export */   _DYN_NODE_TYPE: () => (/* binding */ _DYN_NODE_TYPE),
/* harmony export */   _DYN_NOTIFY: () => (/* binding */ _DYN_NOTIFY),
/* harmony export */   _DYN_ON_COMPLETE: () => (/* binding */ _DYN_ON_COMPLETE),
/* harmony export */   _DYN_POLL_INTERNAL_LOGS: () => (/* binding */ _DYN_POLL_INTERNAL_LOGS),
/* harmony export */   _DYN_PROCESS_NEXT: () => (/* binding */ _DYN_PROCESS_NEXT),
/* harmony export */   _DYN_PUSH: () => (/* binding */ _DYN_PUSH),
/* harmony export */   _DYN_RD_ONLY: () => (/* binding */ _DYN_RD_ONLY),
/* harmony export */   _DYN_REMOVE_NOTIFICATION_2: () => (/* binding */ _DYN_REMOVE_NOTIFICATION_2),
/* harmony export */   _DYN_REPLACE: () => (/* binding */ _DYN_REPLACE),
/* harmony export */   _DYN_SET_CTX: () => (/* binding */ _DYN_SET_CTX),
/* harmony export */   _DYN_SET_DF: () => (/* binding */ _DYN_SET_DF),
/* harmony export */   _DYN_SET_NEXT_PLUGIN: () => (/* binding */ _DYN_SET_NEXT_PLUGIN),
/* harmony export */   _DYN_SPAN_ID: () => (/* binding */ _DYN_SPAN_ID),
/* harmony export */   _DYN_SPLICE: () => (/* binding */ _DYN_SPLICE),
/* harmony export */   _DYN_SPLIT: () => (/* binding */ _DYN_SPLIT),
/* harmony export */   _DYN_STOP_POLLING_INTERNA3: () => (/* binding */ _DYN_STOP_POLLING_INTERNA3),
/* harmony export */   _DYN_TEARDOWN: () => (/* binding */ _DYN_TEARDOWN),
/* harmony export */   _DYN_THROW_INTERNAL: () => (/* binding */ _DYN_THROW_INTERNAL),
/* harmony export */   _DYN_TIME: () => (/* binding */ _DYN_TIME),
/* harmony export */   _DYN_TO_LOWER_CASE: () => (/* binding */ _DYN_TO_LOWER_CASE),
/* harmony export */   _DYN_TRACE_FLAGS: () => (/* binding */ _DYN_TRACE_FLAGS),
/* harmony export */   _DYN_TRACE_ID: () => (/* binding */ _DYN_TRACE_ID),
/* harmony export */   _DYN_TYPE: () => (/* binding */ _DYN_TYPE),
/* harmony export */   _DYN_UNLOAD: () => (/* binding */ _DYN_UNLOAD),
/* harmony export */   _DYN_UPDATE: () => (/* binding */ _DYN_UPDATE),
/* harmony export */   _DYN_USER_AGENT: () => (/* binding */ _DYN_USER_AGENT),
/* harmony export */   _DYN_VERSION: () => (/* binding */ _DYN_VERSION),
/* harmony export */   _DYN_WARN_TO_CONSOLE: () => (/* binding */ _DYN_WARN_TO_CONSOLE),
/* harmony export */   _DYN_WATCH: () => (/* binding */ _DYN_WATCH),
/* harmony export */   _DYN__DO_TEARDOWN: () => (/* binding */ _DYN__DO_TEARDOWN)
/* harmony export */ });
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


// @skip-file-minify
// ##############################################################
// AUTO GENERATED FILE: This file is Auto Generated during build.
// ##############################################################
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Note: DON'T Export these const from the package as we are still targeting ES3 this will export a mutable variables that someone could change!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
var _DYN_TO_LOWER_CASE = "toLowerCase"; // Count: 9
var _DYN_BLK_VAL = "blkVal"; // Count: 5
var _DYN_LENGTH = "length"; // Count: 43
var _DYN_RD_ONLY = "rdOnly"; // Count: 4
var _DYN_NOTIFY = "notify"; // Count: 4
var _DYN_WARN_TO_CONSOLE = "warnToConsole"; // Count: 4
var _DYN_THROW_INTERNAL = "throwInternal"; // Count: 5
var _DYN_SET_DF = "setDf"; // Count: 6
var _DYN_WATCH = "watch"; // Count: 9
var _DYN_LOGGER = "logger"; // Count: 21
var _DYN_APPLY = "apply"; // Count: 7
var _DYN_PUSH = "push"; // Count: 31
var _DYN_SPLICE = "splice"; // Count: 8
var _DYN_HDLR = "hdlr"; // Count: 6
var _DYN_CANCEL = "cancel"; // Count: 5
var _DYN_INITIALIZE = "initialize"; // Count: 4
var _DYN_IDENTIFIER = "identifier"; // Count: 8
var _DYN_IS_INITIALIZED = "isInitialized"; // Count: 10
var _DYN_GET_PLUGIN = "getPlugin"; // Count: 6
var _DYN_POLL_INTERNAL_LOGS = "pollInternalLogs"; // Count: 2
var _DYN_NAME = "name"; // Count: 11
var _DYN_TIME = "time"; // Count: 6
var _DYN_PROCESS_NEXT = "processNext"; // Count: 15
var _DYN_GET_PROCESS_TEL_CONT0 = "getProcessTelContext"; // Count: 2
var _DYN_GET_NOTIFY_MGR = "getNotifyMgr"; // Count: 5
var _DYN_ADD_NOTIFICATION_LIS1 = "addNotificationListener"; // Count: 4
var _DYN_REMOVE_NOTIFICATION_2 = "removeNotificationListener"; // Count: 4
var _DYN_ENABLED = "enabled"; // Count: 6
var _DYN_STOP_POLLING_INTERNA3 = "stopPollingInternalLogs"; // Count: 2
var _DYN_UNLOAD = "unload"; // Count: 9
var _DYN_ON_COMPLETE = "onComplete"; // Count: 5
var _DYN_VERSION = "version"; // Count: 6
var _DYN_LOGGING_LEVEL_CONSOL4 = "loggingLevelConsole"; // Count: 2
var _DYN_CREATE_NEW = "createNew"; // Count: 7
var _DYN_TEARDOWN = "teardown"; // Count: 9
var _DYN_MESSAGE_ID = "messageId"; // Count: 4
var _DYN_MESSAGE = "message"; // Count: 6
var _DYN_IS_ASYNC = "isAsync"; // Count: 6
var _DYN_DIAG_LOG = "diagLog"; // Count: 10
var _DYN__DO_TEARDOWN = "_doTeardown"; // Count: 4
var _DYN_UPDATE = "update"; // Count: 6
var _DYN_GET_NEXT = "getNext"; // Count: 12
var _DYN_SET_NEXT_PLUGIN = "setNextPlugin"; // Count: 5
var _DYN_USER_AGENT = "userAgent"; // Count: 5
var _DYN_SPLIT = "split"; // Count: 6
var _DYN_NODE_TYPE = "nodeType"; // Count: 3
var _DYN_REPLACE = "replace"; // Count: 8
var _DYN_LOG_INTERNAL_MESSAGE = "logInternalMessage"; // Count: 2
var _DYN_TYPE = "type"; // Count: 14
var _DYN_HANDLER = "handler"; // Count: 5
var _DYN_IS_CHILD_EVT = "isChildEvt"; // Count: 3
var _DYN_GET_CTX = "getCtx"; // Count: 6
var _DYN_SET_CTX = "setCtx"; // Count: 10
var _DYN_COMPLETE = "complete"; // Count: 3
var _DYN_TRACE_ID = "traceId"; // Count: 5
var _DYN_SPAN_ID = "spanId"; // Count: 5
var _DYN_TRACE_FLAGS = "traceFlags"; // Count: 6
//# sourceMappingURL=__DynamicConstants.js.map

/***/ }),
/* 33 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _getObjProto: () => (/* binding */ _getObjProto),
/* harmony export */   asString: () => (/* binding */ asString),
/* harmony export */   createClassFromInterface: () => (/* binding */ createClassFromInterface),
/* harmony export */   deepFreeze: () => (/* binding */ deepFreeze),
/* harmony export */   getExceptionName: () => (/* binding */ getExceptionName),
/* harmony export */   getSetValue: () => (/* binding */ getSetValue),
/* harmony export */   isFeatureEnabled: () => (/* binding */ isFeatureEnabled),
/* harmony export */   isNotNullOrUndefined: () => (/* binding */ isNotNullOrUndefined),
/* harmony export */   isNotUndefined: () => (/* binding */ isNotUndefined),
/* harmony export */   normalizeJsName: () => (/* binding */ normalizeJsName),
/* harmony export */   objExtend: () => (/* binding */ objExtend),
/* harmony export */   optimizeObject: () => (/* binding */ optimizeObject),
/* harmony export */   proxyAssign: () => (/* binding */ proxyAssign),
/* harmony export */   proxyFunctionAs: () => (/* binding */ proxyFunctionAs),
/* harmony export */   proxyFunctions: () => (/* binding */ proxyFunctions),
/* harmony export */   setValue: () => (/* binding */ setValue),
/* harmony export */   strContains: () => (/* binding */ strContains),
/* harmony export */   toISOString: () => (/* binding */ toISOString)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(35);
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(23);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(16);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(12);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(37);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(15);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(38);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(27);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(32);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(34);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






// RESTRICT and AVOID circular dependencies you should not import other contained modules or export the contents of this file directly
// Added to help with minification
var strGetPrototypeOf = "getPrototypeOf";
var rCamelCase = /-([a-z])/g;
var rNormalizeInvalid = /([^\w\d_$])/g;
var rLeadingNumeric = /^(\d+[\w\d_$])/;
var _getObjProto = Object[strGetPrototypeOf];
function isNotUndefined(value) {
    return !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isUndefined)(value);
}
function isNotNullOrUndefined(value) {
    return !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isNullOrUndefined)(value);
}
/**
 * Validates that the string name conforms to the JS IdentifierName specification and if not
 * normalizes the name so that it would. This method does not identify or change any keywords
 * meaning that if you pass in a known keyword the same value will be returned.
 * This is a simplified version
 * @param name - The name to validate
 */
function normalizeJsName(name) {
    var value = name;
    if (value && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isString)(value)) {
        // CamelCase everything after the "-" and remove the dash
        value = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_REPLACE /* @min:%2ereplace */](rCamelCase, function (_all, letter) {
            return letter.toUpperCase();
        });
        value = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_REPLACE /* @min:%2ereplace */](rNormalizeInvalid, "_");
        value = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_REPLACE /* @min:%2ereplace */](rLeadingNumeric, function (_all, match) {
            return "_" + match;
        });
    }
    return value;
}
/**
 * A simple wrapper (for minification support) to check if the value contains the search string.
 * @param value - The string value to check for the existence of the search value
 * @param search - The value search within the value
 */
function strContains(value, search) {
    if (value && search) {
        return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.strIndexOf)(value, search) !== -1;
    }
    return false;
}
/**
 * Convert a date to I.S.O. format in IE8
 */
function toISOString(date) {
    return date && date.toISOString() || "";
}
var deepFreeze = _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.objDeepFreeze;
/**
 * Returns the name of object if it's an Error. Otherwise, returns empty string.
 */
function getExceptionName(object) {
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isError)(object)) {
        return object[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:%2ename */];
    }
    return _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY;
}
/**
 * Sets the provided value on the target instance using the field name when the provided chk function returns true, the chk
 * function will only be called if the new value is no equal to the original value.
 * @param target - The target object
 * @param field - The key of the target
 * @param value - The value to set
 * @param valChk - [Optional] Callback to check the value that if supplied will be called check if the new value can be set
 * @param srcChk - [Optional] Callback to check to original value that if supplied will be called if the new value should be set (if allowed)
 * @returns The existing or new value, depending what was set
 */
function setValue(target, field, value, valChk, srcChk) {
    var theValue = value;
    if (target) {
        theValue = target[field];
        if (theValue !== value && (!srcChk || srcChk(theValue)) && (!valChk || valChk(value))) {
            theValue = value;
            target[field] = theValue;
        }
    }
    return theValue;
}
/**
 * Returns the current value from the target object if not null or undefined otherwise sets the new value and returns it
 * @param target - The target object to return or set the default value
 * @param field - The key for the field to set on the target
 * @param defValue - [Optional] The value to set if not already present, when not provided a empty object will be added
 */
function getSetValue(target, field, defValue) {
    var theValue;
    if (target) {
        theValue = target[field];
        if (!theValue && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isNullOrUndefined)(theValue)) {
            // Supports having the default as null
            theValue = !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isUndefined)(defValue) ? defValue : {};
            target[field] = theValue;
        }
    }
    else {
        // Expanded for performance so we only check defValue if required
        theValue = !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isUndefined)(defValue) ? defValue : {};
    }
    return theValue;
}
function _createProxyFunction(source, funcName) {
    var srcFunc = null;
    var src = null;
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isFunction)(source)) {
        srcFunc = source;
    }
    else {
        src = source;
    }
    return function () {
        // Capture the original arguments passed to the method
        var originalArguments = arguments;
        if (srcFunc) {
            src = srcFunc();
        }
        if (src) {
            return src[funcName][_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_APPLY /* @min:%2eapply */](src, originalArguments);
        }
    };
}
/**
 * Effectively assigns all enumerable properties (not just own properties) and functions (including inherited prototype) from
 * the source object to the target, it attempts to use proxy getters / setters (if possible) and proxy functions to avoid potential
 * implementation issues by assigning prototype functions as instance ones
 *
 * This method is the primary method used to "update" the snippet proxy with the ultimate implementations.
 *
 * Special ES3 Notes:
 * Updates (setting) of direct property values on the target or indirectly on the source object WILL NOT WORK PROPERLY, updates to the
 * properties of "referenced" object will work (target.context.newValue = 10 => will be reflected in the source.context as it's the
 * same object). ES3 Failures: assigning target.myProp = 3 -> Won't change source.myProp = 3, likewise the reverse would also fail.
 * @param target - The target object to be assigned with the source properties and functions
 * @param source - The source object which will be assigned / called by setting / calling the targets proxies
 * @param chkSet - An optional callback to determine whether a specific property/function should be proxied
 */
function proxyAssign(target, source, chkSet) {
    if (target && source && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isObject)(target) && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isObject)(source)) {
        var _loop_1 = function (field) {
            if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isString)(field)) {
                var value = source[field];
                if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isFunction)(value)) {
                    if (!chkSet || chkSet(field, true, source, target)) {
                        // Create a proxy function rather than just copying the (possible) prototype to the new object as an instance function
                        target[field] = _createProxyFunction(source, field);
                    }
                }
                else if (!chkSet || chkSet(field, false, source, target)) {
                    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objHasOwn)(target, field)) {
                        // Remove any previous instance property
                        delete target[field];
                    }
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objDefine)(target, field, {
                        g: function () {
                            return source[field];
                        },
                        s: function (theValue) {
                            source[field] = theValue;
                        }
                    });
                }
            }
        };
        // effectively apply/proxy full source to the target instance
        for (var field in source) {
            _loop_1(field);
        }
    }
    return target;
}
/**
 * Creates a proxy function on the target which internally will call the source version with all arguments passed to the target method.
 *
 * @param target - The target object to be assigned with the source properties and functions
 * @param name - The function name that will be added on the target
 * @param source - The source object which will be assigned / called by setting / calling the targets proxies
 * @param theFunc - The function name on the source that will be proxied on the target
 * @param overwriteTarget - If `false` this will not replace any pre-existing name otherwise (the default) it will overwrite any existing name
 */
function proxyFunctionAs(target, name, source, theFunc, overwriteTarget) {
    if (target && name && source) {
        if (overwriteTarget !== false || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isUndefined)(target[name])) {
            target[name] = _createProxyFunction(source, theFunc);
        }
    }
}
/**
 * Creates proxy functions on the target which internally will call the source version with all arguments passed to the target method.
 *
 * @param target - The target object to be assigned with the source properties and functions
 * @param source - The source object which will be assigned / called by setting / calling the targets proxies
 * @param functionsToProxy - An array of function names that will be proxied on the target
 * @param overwriteTarget - If false this will not replace any pre-existing name otherwise (the default) it will overwrite any existing name
 */
function proxyFunctions(target, source, functionsToProxy, overwriteTarget) {
    if (target && source && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isObject)(target) && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isArray)(functionsToProxy)) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.arrForEach)(functionsToProxy, function (theFuncName) {
            if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isString)(theFuncName)) {
                proxyFunctionAs(target, theFuncName, source, theFuncName, overwriteTarget);
            }
        });
    }
    return target;
}
/**
 * Simpler helper to create a dynamic class that implements the interface and populates the values with the defaults.
 * Only instance properties (hasOwnProperty) values are copied from the defaults to the new instance
 * @param defaults - Simple helper
 */
function createClassFromInterface(defaults) {
    return /** @class */ (function () {
        function class_1() {
            var _this = this;
            if (defaults) {
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__.objForEachKey)(defaults, function (field, value) {
                    _this[field] = value;
                });
            }
        }
        return class_1;
    }());
}
/**
 * A helper function to assist with JIT performance for objects that have properties added / removed dynamically
 * this is primarily for chromium based browsers and has limited effects on Firefox and none of IE. Only call this
 * function after you have finished "updating" the object, calling this within loops reduces or defeats the benefits.
 * This helps when iterating using for..in, objKeys() and objForEach()
 * @param theObject - The object to be optimized if possible
 */
function optimizeObject(theObject) {
    // V8 Optimization to cause the JIT compiler to create a new optimized object for looking up the own properties
    // primarily for object with <= 19 properties for >= 20 the effect is reduced or non-existent
    if (theObject && _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.objAssign) {
        theObject = (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_9__.ObjClass)((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.objAssign)({}, theObject));
    }
    return theObject;
}
function objExtend(obj1, obj2, obj3, obj4, obj5, obj6) {
    // Variables
    var theArgs = arguments;
    var extended = theArgs[0] || {};
    var argLen = theArgs[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */];
    var deep = false;
    var idx = 1;
    // Check for "Deep" flag
    if (argLen > 0 && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isBoolean)(extended)) {
        deep = extended;
        extended = theArgs[idx] || {};
        idx++;
    }
    // Handle case when target is a string or something (possible in deep copy)
    if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isObject)(extended)) {
        extended = {};
    }
    // Loop through each remaining object and conduct a merge
    for (; idx < argLen; idx++) {
        var arg = theArgs[idx];
        var isArgArray = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isArray)(arg);
        var isArgObj = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isObject)(arg);
        for (var prop in arg) {
            var propOk = (isArgArray && (prop in arg)) || (isArgObj && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objHasOwn)(arg, prop));
            if (!propOk) {
                continue;
            }
            var newValue = arg[prop];
            var isNewArray = void 0;
            // If deep merge and property is an object, merge properties
            if (deep && newValue && ((isNewArray = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isArray)(newValue)) || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__.isPlainObject)(newValue))) {
                // Grab the current value of the extended object
                var clone = extended[prop];
                if (isNewArray) {
                    if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isArray)(clone)) {
                        // We can't "merge" an array with a non-array so overwrite the original
                        clone = [];
                    }
                }
                else if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__.isPlainObject)(clone)) {
                    // We can't "merge" an object with a non-object
                    clone = {};
                }
                // Never move the original objects always clone them
                newValue = objExtend(deep, clone, newValue);
            }
            // Assign the new (or previous) value (unless undefined)
            if (newValue !== undefined) {
                extended[prop] = newValue;
            }
        }
    }
    return extended;
}
var asString = _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__.asString;
function isFeatureEnabled(feature, cfg) {
    var rlt = false;
    var ft = cfg && cfg.featureOptIn && cfg.featureOptIn[feature];
    if (feature && ft) {
        var mode = ft.mode;
        // NOTE: None will be considered as true
        rlt = (mode == 3 /* FeatureOptInMode.enable */) || (mode == 1 /* FeatureOptInMode.none */);
    }
    return rlt;
}
//# sourceMappingURL=HelperFuncs.js.map

/***/ }),
/* 34 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STR_CHANNELS: () => (/* binding */ STR_CHANNELS),
/* harmony export */   STR_CORE: () => (/* binding */ STR_CORE),
/* harmony export */   STR_CREATE_PERF_MGR: () => (/* binding */ STR_CREATE_PERF_MGR),
/* harmony export */   STR_DISABLED: () => (/* binding */ STR_DISABLED),
/* harmony export */   STR_DOMAIN: () => (/* binding */ STR_DOMAIN),
/* harmony export */   STR_EMPTY: () => (/* binding */ STR_EMPTY),
/* harmony export */   STR_EVENTS_DISCARDED: () => (/* binding */ STR_EVENTS_DISCARDED),
/* harmony export */   STR_EVENTS_SEND_REQUEST: () => (/* binding */ STR_EVENTS_SEND_REQUEST),
/* harmony export */   STR_EVENTS_SENT: () => (/* binding */ STR_EVENTS_SENT),
/* harmony export */   STR_EXTENSIONS: () => (/* binding */ STR_EXTENSIONS),
/* harmony export */   STR_EXTENSION_CONFIG: () => (/* binding */ STR_EXTENSION_CONFIG),
/* harmony export */   STR_GET_PERF_MGR: () => (/* binding */ STR_GET_PERF_MGR),
/* harmony export */   STR_NOT_DYNAMIC_ERROR: () => (/* binding */ STR_NOT_DYNAMIC_ERROR),
/* harmony export */   STR_PATH: () => (/* binding */ STR_PATH),
/* harmony export */   STR_PERF_EVENT: () => (/* binding */ STR_PERF_EVENT),
/* harmony export */   STR_PRIORITY: () => (/* binding */ STR_PRIORITY),
/* harmony export */   STR_PROCESS_TELEMETRY: () => (/* binding */ STR_PROCESS_TELEMETRY),
/* harmony export */   UNDEFINED_VALUE: () => (/* binding */ UNDEFINED_VALUE)
/* harmony export */ });
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


// ###################################################################################################################################################
// Note: DON'T Export these const from the package as we are still targeting IE/ES5 this will export a mutable variables that someone could change ###
// ###################################################################################################################################################
var UNDEFINED_VALUE = undefined;
var STR_EMPTY = "";
var STR_CHANNELS = "channels";
var STR_CORE = "core";
var STR_CREATE_PERF_MGR = "createPerfMgr";
var STR_DISABLED = "disabled";
var STR_EXTENSION_CONFIG = "extensionConfig";
var STR_EXTENSIONS = "extensions";
var STR_PROCESS_TELEMETRY = "processTelemetry";
var STR_PRIORITY = "priority";
var STR_EVENTS_SENT = "eventsSent";
var STR_EVENTS_DISCARDED = "eventsDiscarded";
var STR_EVENTS_SEND_REQUEST = "eventsSendRequest";
var STR_PERF_EVENT = "perfEvent";
var STR_GET_PERF_MGR = "getPerfMgr";
var STR_DOMAIN = "domain";
var STR_PATH = "path";
var STR_NOT_DYNAMIC_ERROR = "Not dynamic - ";
//# sourceMappingURL=InternalConstants.js.map

/***/ }),
/* 35 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   objAssign: () => (/* binding */ objAssign),
/* harmony export */   objDeepFreeze: () => (/* binding */ objDeepFreeze),
/* harmony export */   objEntries: () => (/* binding */ objEntries),
/* harmony export */   objFreeze: () => (/* binding */ objFreeze),
/* harmony export */   objGetPrototypeOf: () => (/* binding */ objGetPrototypeOf),
/* harmony export */   objKeys: () => (/* binding */ objKeys),
/* harmony export */   objSeal: () => (/* binding */ objSeal),
/* harmony export */   objValues: () => (/* binding */ objValues)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8);
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(13);
/* harmony import */ var _helpers_throw__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(19);
/* harmony import */ var _for_each_key__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(15);
/* harmony import */ var _polyfills_object__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(36);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */





var _objFreeze = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass["freeze"];
var _doNothing = function (value) { return value; };
var _getProto = function (value) { return value[_internal_constants__WEBPACK_IMPORTED_MODULE_0__.__PROTO__] || _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE; };
/**
 * The `objAssign()` method copies all enumerable own properties from one or more source objects
 * to a target object. It returns the modified target object.
 *
 * Properties in the target object are overwritten by properties in the sources if they have the
 * same key. Later sources' properties overwrite earlier ones.
 *
 * The objAssign() method only copies enumerable and own properties from a source object to a
 * target object. It uses `Get` on the source and `Set` on the target, so it will invoke
 * [getters](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/get) and
 * [setters](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/set).
 * Therefore it assigns properties, versus copying or defining new properties. This may make it
 * unsuitable for merging new properties into a prototype if the merge sources contain getters.
 *
 * For copying property definitions (including their enumerability) into prototypes, use
 * {@link objGetOwnPropertyDescriptor} and {@link objDefineProp} instead.
 *
 * Both String and Symbol properties are copied.
 *
 * In case of an error, for example if a property is non-writable, a TypeError is raised, and
 * the target object is changed if any properties are added before the error is raised.
 * @group Object
 * @example
 * ```ts
 * const obj = { a: 1 };
 * const copy = objAssign({}, obj);
 * console.log(copy); // { a: 1 }
 *
 * const o1 = { a: 1 };
 * const o2 = { b: 2 };
 * const o3 = { c: 3 };
 *
 * const obj = objAssign(o1, o2, o3);
 * console.log(obj); // { a: 1, b: 2, c: 3 }
 * console.log(o1);  // { a: 1, b: 2, c: 3 }, target object itself is changed.
 * ```
 */
var objAssign = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass["assign"];
/**
 * The `objKeys()` method returns an array of a given object's own enumerable property names, iterated in
 * the same order that a normal loop would.
 *
 * objKeys() returns an array whose elements are strings corresponding to the enumerable properties found
 * directly upon object. The ordering of the properties is the same as that given by looping over the
 * properties of the object manually.
 * @group Object
 * @param value - The object to obtain a copy of the keys from
 * @returns An array of the properties names for the value object.
 * @example
 * ```ts
 * // simple array
 * const arr = ['a', 'b', 'c'];
 * console.log(objKeys(arr)); // console: ['0', '1', '2']
 *
 * // array-like object
 * const obj = { 0: 'a', 1: 'b', 2: 'c' };
 * console.log(objKeys(obj)); // console: ['0', '1', '2']
 *
 * // array-like object with random key ordering
 * const anObj = { 100: 'a', 2: 'b', 7: 'c' };
 * console.log(objKeys(anObj)); // console: ['2', '7', '100']
 *
 * // getFoo is a property which isn't enumerable
 * const myObj = objCreate({}, {
 *   getFoo: {
 *     value() { return this.foo; }
 *   }
 * });
 * myObj.foo = 1;
 * console.log(objKeys(myObj)); // console: ['foo']
 * ```
 */
function objKeys(value) {
    if (!(0,_helpers_base__WEBPACK_IMPORTED_MODULE_1__.isObject)(value) || value === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE) {
        (0,_helpers_throw__WEBPACK_IMPORTED_MODULE_2__.throwTypeError)("objKeys called on non-object");
    }
    return _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.keys(value);
}
/**
 * Perform a deep freeze on the object and all of it's contained values / properties by recursively calling
 * `objFreeze()` on all enumerable properties of the object and on each property returned.
 * @group Object
 * @param value - the object to be completly frozen.
 * @returns The originally passed in object.
 */
function objDeepFreeze(value) {
    if (_objFreeze) {
        (0,_for_each_key__WEBPACK_IMPORTED_MODULE_3__.objForEachKey)(value, function (key, value) {
            if ((0,_helpers_base__WEBPACK_IMPORTED_MODULE_1__.isArray)(value) || (0,_helpers_base__WEBPACK_IMPORTED_MODULE_1__.isObject)(value)) {
                _objFreeze(value);
            }
        });
    }
    return objFreeze(value);
}
/**
 * The `objFreeze()` method freezes an object. A frozen object can no longer be changed; freezing an object
 * prevents new properties from being added to it, existing properties from being removed, prevents changing the
 * enumerability, configurability, or writability of existing properties, and prevents the values of existing
 * properties from being changed. In addition, freezing an object also prevents its prototype from being changed.
 * `objFreeze()` returns the same object that was passed in.
 *
 * Nothing can be added to or removed from the properties set of a frozen object. Any attempt to do so will fail,
 * either silently or by throwing a TypeError exception (most commonly, but not exclusively, when in strict mode).
 *
 * For data properties of a frozen object, values cannot be changed, the writable and configurable attributes are
 * set to false. Accessor properties (getters and setters) work the same (and still give the illusion that you are
 * changing the value). Note that values that are objects can still be modified, unless they are also frozen. As
 * an object, an array can be frozen; after doing so, its elements cannot be altered and no elements can be added
 * to or removed from the array.
 *
 * `objFreeze()` returns the same object that was passed into the function. It does not create a frozen copy.
 * @group Object
 * @param value - The object to freeze.
 * @returns The object that was passed to the function.
 */
var objFreeze = _objFreeze || _doNothing;
/**
 * The `objSeal()` method seals an object, preventing new properties from being added to it and marking all
 * existing properties as non-configurable. Values of present properties can still be changed as long as they
 * are writable.
 * @group Object
 * @param value - The object which should be sealed.
 * @returns The object being sealed.
 */
var objSeal = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass["seal"] || _doNothing;
/**
 * The objGetPrototypeOf() method returns the prototype (i.e. the value of the internal `Prototype` property)
 * of the specified value.
 * @since 0.4.4
 * @group Object
 * @param value - The object whose prototype is to be returned, which may be null.
 */
var objGetPrototypeOf = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass["getPrototypeOf"] || _getProto;
/**
 * Returns an array of key/values of the enumerable properties of an object
 * @since 0.9.7
 * @group Object
 * @group ArrayLike
 * @param value Object that contains the properties and methods.
 * @example
 * ```ts
 * objEntries({ Hello: "Darkness", my: "old", friend: "." });
 * // [ [ "Hello", "Darkness" ], [ "my", "old"], [ "friend", "." ] ]
 *
 * // Array-like object
 * objEntries({ 0: "a", 1: "b", 2: "c" }));
 * // [ ['0', 'a'], ['1', 'b'], ['2', 'c'] ]
 *
 * // Array-like object with random key ordering
 * objEntries({ 100: "a", 2: "b", 7: "c" });
 * // [ ['2', 'b'], ['7', 'c'], ['100', 'a'] ]*
 * ```
 */
var objEntries = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.entries || _polyfills_object__WEBPACK_IMPORTED_MODULE_4__.polyObjEntries;
/**
 * The objValues() returns an array whose elements are values of enumerable string-keyed properties found
 * directly upon object. This is the same as iterating with a for...in loop, except that a for...in loop
 * enumerates properties in the prototype chain as well. The order of the array returned by objValues()
 * is the same as that provided by a for...in loop.
 *
 * If you need the property keys, use objKeys() instead. If you need both the property keys and values, use objEntries() instead.
 * @since 0.9.7
 * @group Object
 * @group ArrayLike
 * @param value - The object that contains the properties and methods.
 * @returns An array containing the given object's own enumerable string-keyed property values.
 * @example
 * ```ts
 * objValues({ Hello: "Darkness", my: "old", friend: "." });
 * // [ "Darkness", "old", "." ]
 *
 * // Array-like object
 * objValues({ 0: "a", 1: "b", 2: "c" }));
 * // [ 'a', 'b', 'c']
 *
 * // Array-like object with random key ordering
 * objValues({ 100: "a", 2: "b", 7: "c" });
 * // [ 'b', 'c', 'a']
 * ```
 */
var objValues = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass.values || _polyfills_object__WEBPACK_IMPORTED_MODULE_4__.polyObjValues;
//# sourceMappingURL=object.js.map

/***/ }),
/* 36 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   polyObjEntries: () => (/* binding */ polyObjEntries),
/* harmony export */   polyObjKeys: () => (/* binding */ polyObjKeys),
/* harmony export */   polyObjValues: () => (/* binding */ polyObjValues)
/* harmony export */ });
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _object_for_each_key__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(15);
/* harmony import */ var _object_has_own__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */




/**
 * Returns the names of the enumerable string properties and methods of an object. This helper exists to avoid adding a polyfil for older browsers
 * that do not define Object.keys eg. ES3 only, IE8 just in case any page checks for presence/absence of the prototype implementation.
 * Note: For consistency this will not use the Object.keys implementation if it exists as this would cause a testing requirement to test with and without the implementations
 * @group Polyfill
 * @group Object
 * @param obj Object that contains the properties and methods. This can be an object that you created or an existing Document Object Model (DOM) object.
 */
function polyObjKeys(obj) {
    if (!(0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isObject)(obj) || obj === _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NULL_VALUE) {
        throw new TypeError("polyObjKeys called on non-object");
    }
    var result = [];
    for (var prop in obj) {
        if ((0,_object_has_own__WEBPACK_IMPORTED_MODULE_2__.objHasOwn)(obj, prop)) {
            result.push(prop);
        }
    }
    return result;
}
/**
 * Returns an array of key/values of the enumerable properties of an object
 * @since 0.9.7
 * @group Polyfill
 * @group Object
 * @group ArrayLike
 * @param value Object that contains the properties and methods.
 * @example
 * ```ts
 * polyObjEntries({ Hello: "Darkness", my: "old", friend: "." });
 * // [ [ "Hello", "Darkness" ], [ "my", "old"], [ "friend", "." ] ]
 *
 * // Array-like object
 * polyObjEntries({ 0: "a", 1: "b", 2: "c" }));
 * // [ ['0', 'a'], ['1', 'b'], ['2', 'c'] ]
 *
 * // Array-like object with random key ordering
 * polyObjEntries({ 100: "a", 2: "b", 7: "c" });
 * // [ ['2', 'b'], ['7', 'c'], ['100', 'a'] ]*
 * ```
 */
function polyObjEntries(value) {
    var result = [];
    (0,_object_for_each_key__WEBPACK_IMPORTED_MODULE_3__.objForEachKey)(value, function (key, value) {
        result.push([key, value]);
    });
    return result;
}
/**
 * Returns an array of key/values of the enumerable properties of an object
 * @since 0.9.7
 * @group Polyfill
 * @group Object
 * @group ArrayLike
 * @param value Object that contains the properties and methods.
 * @example
 * ```ts
 * polyObjValues({ Hello: "Darkness", my: "old", friend: "." });
 * // [ "Darkness", "old", "." ]
 *
 * // Array-like object
 * polyObjValues({ 0: "a", 1: "b", 2: "c" }));
 * // [ 'a', 'b', 'c']
 *
 * // Array-like object with random key ordering
 * polyObjValues({ 100: "a", 2: "b", 7: "c" });
 * // [ 'b', 'c', 'a']
 * ```
 */
function polyObjValues(value) {
    var result = [];
    (0,_object_for_each_key__WEBPACK_IMPORTED_MODULE_3__.objForEachKey)(value, function (key, value) {
        result.push(value);
    });
    return result;
}
//# sourceMappingURL=object.js.map

/***/ }),
/* 37 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   arrForEach: () => (/* binding */ arrForEach)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

/**
 * Calls the provided `callbackFn` function once for each element in an array in ascending index order. It is not invoked for index properties
 * that have been deleted or are uninitialized. And unlike the ES6 forEach() you CAN stop or break the iteration by returning -1 from the
 * `callbackFn` function.
 *
 * The range (number of elements) processed by arrForEach() is set before the first call to the `callbackFn`. Any elements added beyond the range
 * or elements which as assigned to indexes already processed will not be visited by the `callbackFn`.
 * @group Array
 * @group ArrayLike
 * @typeParam T - Identifies the element type of the array
 * @param theArray - The array or array like object of elements to be searched.
 * @param callbackfn A `synchronous` function that accepts up to three arguments. arrForEach calls the callbackfn function one time for each element in the array.
 * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, null or undefined
 * the array will be used as the this value.
 * @remarks
 * arrForEach expects a `synchronous` function.
 * arrForEach does not wait for promises. Make sure you are aware of the implications while using promises (or async functions) as forEach callback.
 * @example
 * ```ts
 * const items = ['item1', 'item2', 'item3'];
 * const copyItems = [];
 *
 * // before using for loop
 * for (let i = 0; i < items.length; i++) {
 *   copyItems.push(items[i]);
 * }
 *
 * // before using forEach()
 * items.forEach((item) => {
 *   copyItems.push(item);
 * });
 *
 * // after
 * arrForEach(items, (item) => {
 *   copyItems.push(item);
 *   // May return -1 to abort the iteration
 * });
 *
 * // Also supports input as an array like object
 * const items = { length: 3, 0: 'item1', 1: 'item2', 2: 'item3' };
 * ```
 */
function arrForEach(theArray, callbackfn, thisArg) {
    if (theArray) {
        var len = theArray[_internal_constants__WEBPACK_IMPORTED_MODULE_0__.LENGTH] >>> 0;
        for (var idx = 0; idx < len; idx++) {
            if (idx in theArray) {
                if (callbackfn.call(thisArg || theArray, theArray[idx], idx, theArray) === -1) {
                    break;
                }
            }
        }
    }
}
//# sourceMappingURL=forEach.js.map

/***/ }),
/* 38 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isPlainObject: () => (/* binding */ isPlainObject)
/* harmony export */ });
/* harmony import */ var _funcs_fnCall__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(39);
/* harmony import */ var _helpers_environment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8);
/* harmony import */ var _has_own_prop__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(18);
/* harmony import */ var _object__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(35);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */





// Use to cache the result of Object.cont
var _fnToString;
var _objCtrFnString;
var _gblWindow;
/**
 * Checks to see if the past value is a plain object (not a class/array) value.
 * Object are considered to be "plain" if they are created with no prototype `Object.create(null)`
 * or by using the Object global (native) function, all other "objects" ar
 * @since 0.4.4
 * @group Type Identity
 * @group Object
 * @param value - The value to check
 * @returns true if `value` is a normal plain object
 * @example
 * ```ts
 * console.log(isPlainObject({ 0: 'a', 1: 'b', 2: 'c' }));      // true
 * console.log(isPlainObject({ 100: 'a', 2: 'b', 7: 'c' }));    // true
 * console.log(isPlainObject(objCreate(null)));                 // true
 *
 * const myObj = objCreate({}, {
 *   getFoo: {
 *     value() { return this.foo; }
 *   }
 * });
 * myObj.foo = 1;
 * console.log(isPlainObject(myObj));                   // true
 *
 * console.log(isPlainObject(['a', 'b', 'c']));         // false
 * console.log(isPlainObject(new Date()));              // false
 * console.log(isPlainObject(new Error("An Error")));   // false
 * console.log(isPlainObject(null));                    // false
 * console.log(isPlainObject(undefined));               // false
 * console.log(isPlainObject("null"));                  // false
 * console.log(isPlainObject("undefined"));             // false
 * console.log(isPlainObject("1"));                     // false
 * console.log(isPlainObject("aa"));                    // false
 * ```
 */
function isPlainObject(value) {
    if (!value || typeof value !== _internal_constants__WEBPACK_IMPORTED_MODULE_0__.OBJECT) {
        return false;
    }
    if (!_gblWindow) {
        // Lazily cache the current global window value and default it to "true" (so we bypass this check in the future)
        _gblWindow = (0,_helpers_environment__WEBPACK_IMPORTED_MODULE_1__.hasWindow)() ? (0,_helpers_environment__WEBPACK_IMPORTED_MODULE_1__.getWindow)() : true;
    }
    var result = false;
    if (value !== _gblWindow) {
        if (!_objCtrFnString) {
            // Lazily caching what the runtime reports as the object function constructor (as a string)
            // Using an current function lookup to find what this runtime calls a "native" function
            _fnToString = Function[_internal_constants__WEBPACK_IMPORTED_MODULE_0__.PROTOTYPE].toString;
            _objCtrFnString = (0,_funcs_fnCall__WEBPACK_IMPORTED_MODULE_2__.fnCall)(_fnToString, _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass);
        }
        try {
            var proto = (0,_object__WEBPACK_IMPORTED_MODULE_3__.objGetPrototypeOf)(value);
            // No prototype so looks like an object created with Object.create(null)
            result = !proto;
            if (!result) {
                if ((0,_has_own_prop__WEBPACK_IMPORTED_MODULE_4__.objHasOwnProperty)(proto, _internal_constants__WEBPACK_IMPORTED_MODULE_0__.CONSTRUCTOR)) {
                    proto = proto[_internal_constants__WEBPACK_IMPORTED_MODULE_0__.CONSTRUCTOR];
                }
                result = proto && typeof proto === _internal_constants__WEBPACK_IMPORTED_MODULE_0__.FUNCTION && _fnToString.call(proto) === _objCtrFnString;
            }
        }
        catch (ex) {
            // Something went wrong, so it's not an object we are playing with
        }
    }
    return result;
}
//# sourceMappingURL=is_plain_object.js.map

/***/ }),
/* 39 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fnCall: () => (/* binding */ fnCall)
/* harmony export */ });
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2023 Nevware21
 * Licensed under the MIT license.
 */

/**
 * The `fnCall` function calls the function with the given `thisArg` as the `this` value and with
 * al of the `_args` provided as it's `arguments.
 *
 * > This is almost identical to `fnApply`, except that the function arguments are passed to `fnCall`
 * individually as a list, while with `fnApply` that are combined into a single array argument.
 *
 * Normally, when calling a function, the value of `this` inside the function is the object that the
 * function was accessed on. With `fnCall()`, you can pass an arbitrary value as the `this` when calling an
 * existing function, without first attaching the function to the object as a property. This allows you
 * to use methods of one object as generic utility functions.
 *
 * @since 0.9.8
 * @group Function
 *
 * @param fn - The function to be called
 * @param thisArg - The value of `this` provided for the call to `fn`. If the function is not in strict mode,
 * `null` and `undefined` will be replaced with the global object, and primitive values will be converted to objects.
 * @param _args - The zero or more arguments to be passed to the `fn` function.
 * @returns The result of calling the function with the specified `this` value and arguments.
 * @example
 * ```ts
 * // min / max number in an array
 * let max = fnCall(Math.max, null, 21, 42, 84, 168, 7, 3);
 * // 168
 *
 * let min = fnCall(Math.min, null, 21, 42, 84, 168, 7, 3);
 * // 3
 *
 * const module1 = {
 *     prefix: "Hello",
 *     x: 21,
 *     getX() {
 *         return this.x;
 *     },
 *     log(value: string) {
 *         return this.prefix + " " + value + " : " + this.x
 *     }
 * };
 *
 * // The 'this' parameter of 'getX' is bound to 'module'.
 * module1.getX(); // 21
 * module1.log("Darkness"); // Hello Darkness : 21
 *
 * // Create a new function 'boundGetX' with the 'this' parameter bound to 'module'.
 * let module2 = {
 *     prefix: "my",
 *     x: 42
 * };
 *
 * // Call the function of module1 with module2 as it's this
 * fnCall(module1.getX, module2); // 42
 * fnCall(module1.log, module2, "friend"); // my friend : 42
 * ```
 */
var fnCall = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapInstFunction)("call");
//# sourceMappingURL=fnCall.js.map

/***/ }),
/* 40 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   elapsedTime: () => (/* binding */ elapsedTime),
/* harmony export */   getPerformance: () => (/* binding */ getPerformance),
/* harmony export */   hasPerformance: () => (/* binding */ hasPerformance),
/* harmony export */   perfNow: () => (/* binding */ perfNow)
/* harmony export */ });
/* harmony import */ var _date__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(41);
/* harmony import */ var _environment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7);
/* harmony import */ var _lazy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(11);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */



var _perf;
/**
 * Identify whether the runtimne contains a `performance` object
 *
 * @since 0.4.4
 * @group Environment
 * @returns
 */
function hasPerformance() {
    return !!getPerformance();
}
/**
 * Returns the global `performance` Object if available, which can be used to
 * gather performance information about the current document. It serves as the
 * point of exposure for the Performance Timeline API, the High Resolution Time
 * API, the Navigation Timing API, the User Timing API, and the Resource Timing API.
 *
 * @since 0.4.4
 * @group Environment
 * @returns The global performance object if available.
 */
function getPerformance() {
    (!_perf || (!_perf.b && _lazy__WEBPACK_IMPORTED_MODULE_0__._globalLazyTestHooks && _lazy__WEBPACK_IMPORTED_MODULE_0__._globalLazyTestHooks.lzy)) && (_perf = (0,_environment__WEBPACK_IMPORTED_MODULE_1__.lazySafeGetInst)("performance"));
    return _perf.v;
}
/**
 * Returns the number of milliseconds that has elapsed since the time origin, if
 * the runtime does not support the `performance` API it will fallback to return
 * the number of milliseconds since the unix epoch.
 *
 * @since 0.4.4
 * @group Timer
 *
 * @returns The number of milliseconds as a `DOMHighResTimeStamp` double value or
 * an integer depending on the runtime.
 * @example
 * ```ts
 * let now = perfNow();
 * ```
 */
function perfNow() {
    var perf = getPerformance();
    if (perf && perf.now) {
        return perf.now();
    }
    return (0,_date__WEBPACK_IMPORTED_MODULE_2__.utcNow)();
}
/**
 * Return the number of milliseconds that have elapsed since the provided `startTime`
 * the `startTime` MUST be obtained from {@link perfNow} to ensure the correct elapsed
 * value is returned.
 *
 * @since 0.4.4
 * @group Timer
 *
 * @param startTime - The startTime obtained from `perfNow`
 * @returns The number of milliseconds that have elapsed since the startTime.
 * @example
 * ```ts
 * let start = perfNow();
 * // Do some work
 * let totalTime = elapsedTime(start);
 * ```
 */
function elapsedTime(startTime) {
    return perfNow() - startTime;
}
//# sourceMappingURL=perf.js.map

/***/ }),
/* 41 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   polyUtcNow: () => (/* binding */ polyUtcNow),
/* harmony export */   utcNow: () => (/* binding */ utcNow)
/* harmony export */ });
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
/**
 * Return the number of milliseconds that have elapsed since January 1, 1970 00:00:00 UTC.
 *
 * To offer protection against timing attacks and fingerprinting, the precision of dateNow()
 * might get rounded depending on browser settings. In Firefox, the privacy.reduceTimerPrecision
 * preference is enabled by default and defaults to 20µs in Firefox 59; in 60 it will be 2ms.
 *
 * @since 0.4.4
 * @group Timer
 *
 * @returns A Number representing the milliseconds elapsed since the UNIX epoch.
 * @example
 * ```ts
 * let now = utcNow();
 * ```
 */
function utcNow() {
    return (Date.now || polyUtcNow)();
}
/**
 * Polyfill fallback to return the number of milliseconds that have elapsed since January 1, 1970 00:00:00 UTC.
 *
 * To offer protection against timing attacks and fingerprinting, the precision of dateNow()
 * might get rounded depending on browser settings. In Firefox, the privacy.reduceTimerPrecision
 * preference is enabled by default and defaults to 20µs in Firefox 59; in 60 it will be 2ms.
 *
 * @since 0.4.4
 * @group Timer
 * @group Polyfill
 *
 * @returns A Number representing the milliseconds elapsed since the UNIX epoch.
  * @example
 * ```ts
 * let now = polyUtcNow();
 * ```
*/
function polyUtcNow() {
    return new Date().getTime();
}
//# sourceMappingURL=date.js.map

/***/ }),
/* 42 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Undefined: () => (/* binding */ Undefined),
/* harmony export */   generateW3CId: () => (/* binding */ generateW3CId),
/* harmony export */   newGuid: () => (/* binding */ newGuid),
/* harmony export */   strEndsWith: () => (/* binding */ strEndsWith)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(32);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(34);
/* harmony import */ var _RandomHelper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(43);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */








// Added to help with minfication
var Undefined = _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_0__.strShimUndefined;
function newGuid() {
    var uuid = generateW3CId();
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstring)(uuid, 0, 8) + "-" + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstring)(uuid, 8, 12) + "-" + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstring)(uuid, 12, 16) + "-" + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstring)(uuid, 16, 20) + "-" + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstring)(uuid, 20);
}
/**
 * The strEndsWith() method determines whether a string ends with the characters of a specified string, returning true or false as appropriate.
 * @param value - The value to check whether it ends with the search value.
 * @param search - The characters to be searched for at the end of the value.
 * @returns true if the given search value is found at the end of the string, otherwise false.
 */
function strEndsWith(value, search) {
    if (value && search) {
        var len = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */];
        var start = len - search[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */];
        return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstring)(value, start >= 0 ? start : 0, len) === search;
    }
    return false;
}
/**
 * generate W3C trace id
 */
function generateW3CId() {
    var hexValues = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"];
    // rfc4122 version 4 UUID without dashes and with lowercase letters
    var oct = _InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EMPTY, tmp;
    for (var a = 0; a < 4; a++) {
        tmp = (0,_RandomHelper__WEBPACK_IMPORTED_MODULE_4__.random32)();
        oct +=
            hexValues[tmp & 0xF] +
                hexValues[tmp >> 4 & 0xF] +
                hexValues[tmp >> 8 & 0xF] +
                hexValues[tmp >> 12 & 0xF] +
                hexValues[tmp >> 16 & 0xF] +
                hexValues[tmp >> 20 & 0xF] +
                hexValues[tmp >> 24 & 0xF] +
                hexValues[tmp >> 28 & 0xF];
    }
    // "Set the two most significant bits (bits 6 and 7) of the clock_seq_hi_and_reserved to zero and one, respectively"
    var clockSequenceHi = hexValues[8 + ((0,_RandomHelper__WEBPACK_IMPORTED_MODULE_4__.random32)() & 0x03) | 0];
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstr)(oct, 0, 8) + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstr)(oct, 9, 4) + "4" + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstr)(oct, 13, 3) + clockSequenceHi + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstr)(oct, 16, 3) + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.strSubstr)(oct, 19, 12);
}
//# sourceMappingURL=CoreUtils.js.map

/***/ }),
/* 43 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   mwcRandom32: () => (/* binding */ mwcRandom32),
/* harmony export */   mwcRandomSeed: () => (/* binding */ mwcRandomSeed),
/* harmony export */   newId: () => (/* binding */ newId),
/* harmony export */   random32: () => (/* binding */ random32),
/* harmony export */   randomValue: () => (/* binding */ randomValue)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(41);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(32);
/* harmony import */ var _EnvUtils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(34);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






var UInt32Mask = 0x100000000;
var MaxUInt32 = 0xffffffff;
var SEED1 = 123456789;
var SEED2 = 987654321;
// MWC based Random generator (for IE)
var _mwcSeeded = false;
var _mwcW = SEED1;
var _mwcZ = SEED2;
// Takes any integer
function _mwcSeed(seedValue) {
    if (seedValue < 0) {
        // Make sure we end up with a positive number and not -ve one.
        seedValue >>>= 0;
    }
    _mwcW = (SEED1 + seedValue) & MaxUInt32;
    _mwcZ = (SEED2 - seedValue) & MaxUInt32;
    _mwcSeeded = true;
}
function _autoSeedMwc() {
    // Simple initialization using default Math.random() - So we inherit any entropy from the browser
    // and bitwise XOR with the current milliseconds
    try {
        var now = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.utcNow)() & 0x7fffffff;
        _mwcSeed(((Math.random() * UInt32Mask) ^ now) + now);
    }
    catch (e) {
        // Don't crash if something goes wrong
    }
}
/**
 * Generate a random value between 0 and maxValue, max value should be limited to a 32-bit maximum.
 * So maxValue(16) will produce a number from 0..16 (range of 17)
 * @param maxValue
 */
function randomValue(maxValue) {
    if (maxValue > 0) {
        return Math.floor((random32() / MaxUInt32) * (maxValue + 1)) >>> 0;
    }
    return 0;
}
/**
 * generate a random 32-bit number (0x000000..0xFFFFFFFF) or (-0x80000000..0x7FFFFFFF), defaults un-unsigned.
 * @param signed - True to return a signed 32-bit number (-0x80000000..0x7FFFFFFF) otherwise an unsigned one (0x000000..0xFFFFFFFF)
 */
function random32(signed) {
    var value = 0;
    var c = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_1__.getCrypto)() || (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_1__.getMsCrypto)();
    if (c && c.getRandomValues) {
        // Make sure the number is converted into the specified range (-0x80000000..0x7FFFFFFF)
        value = c.getRandomValues(new Uint32Array(1))[0] & MaxUInt32;
    }
    if (value === 0 && (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_1__.isIE)()) {
        // For IE 6, 7, 8 (especially on XP) Math.random is not very random
        if (!_mwcSeeded) {
            // Set the seed for the Mwc algorithm
            _autoSeedMwc();
        }
        // Don't use Math.random for IE
        // Make sure the number is converted into the specified range (-0x80000000..0x7FFFFFFF)
        value = mwcRandom32() & MaxUInt32;
    }
    if (value === 0) {
        // Make sure the number is converted into the specified range (-0x80000000..0x7FFFFFFF)
        value = Math.floor((UInt32Mask * Math.random()) | 0);
    }
    if (!signed) {
        // Make sure we end up with a positive number and not -ve one.
        value >>>= 0;
    }
    return value;
}
/**
 * Seed the MWC random number generator with the specified seed or a random value
 * @param value - optional the number to used as the seed, if undefined, null or zero a random value will be chosen
 */
function mwcRandomSeed(value) {
    if (!value) {
        _autoSeedMwc();
    }
    else {
        _mwcSeed(value);
    }
}
/**
 * Generate a random 32-bit number between (0x000000..0xFFFFFFFF) or (-0x80000000..0x7FFFFFFF), using MWC (Multiply with carry)
 * instead of Math.random() defaults to un-signed.
 * Used as a replacement random generator for IE to avoid issues with older IE instances.
 * @param signed - True to return a signed 32-bit number (-0x80000000..0x7FFFFFFF) otherwise an unsigned one (0x000000..0xFFFFFFFF)
 */
function mwcRandom32(signed) {
    _mwcZ = (36969 * (_mwcZ & 0xFFFF) + (_mwcZ >> 16)) & MaxUInt32;
    _mwcW = (18000 * (_mwcW & 0xFFFF) + (_mwcW >> 16)) & MaxUInt32;
    var value = (((_mwcZ << 16) + (_mwcW & 0xFFFF)) >>> 0) & MaxUInt32 | 0;
    if (!signed) {
        // Make sure we end up with a positive number and not -ve one.
        value >>>= 0;
    }
    return value;
}
/**
 * Generate random base64 id string.
 * The default length is 22 which is 132-bits so almost the same as a GUID but as base64 (the previous default was 5)
 * @param maxLength - Optional value to specify the length of the id to be generated, defaults to 22
 */
function newId(maxLength) {
    if (maxLength === void 0) { maxLength = 22; }
    var base64chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    // Start with an initial random number, consuming the value in reverse byte order
    var number = random32() >>> 0; // Make sure it's a +ve number
    var chars = 0;
    var result = _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY;
    while (result[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LENGTH /* @min:%2elength */] < maxLength) {
        chars++;
        result += base64chars.charAt(number & 0x3F);
        number >>>= 6; // Zero fill with right shift
        if (chars === 5) {
            // 5 base64 characters === 30 bits so we don't have enough bits for another base64 char
            // So add on another 30 bits and make sure it's +ve
            number = (((random32() << 2) & 0xFFFFFFFF) | (number & 0x03)) >>> 0;
            chars = 0; // We need to reset the number every 5 chars (30 bits)
        }
    }
    return result;
}
//# sourceMappingURL=RandomHelper.js.map

/***/ }),
/* 44 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ReflectObj: () => (/* binding */ ReflectObj),
/* harmony export */   SymbolObj: () => (/* binding */ SymbolObj),
/* harmony export */   __assignFn: () => (/* binding */ __assignFn),
/* harmony export */   __createBindingFn: () => (/* binding */ __createBindingFn),
/* harmony export */   __decorateFn: () => (/* binding */ __decorateFn),
/* harmony export */   __exportStarFn: () => (/* binding */ __exportStarFn),
/* harmony export */   __extendsFn: () => (/* binding */ __extendsFn),
/* harmony export */   __hasReflect: () => (/* binding */ __hasReflect),
/* harmony export */   __importDefaultFn: () => (/* binding */ __importDefaultFn),
/* harmony export */   __importStarFn: () => (/* binding */ __importStarFn),
/* harmony export */   __makeTemplateObjectFn: () => (/* binding */ __makeTemplateObjectFn),
/* harmony export */   __metadataFn: () => (/* binding */ __metadataFn),
/* harmony export */   __objAssignFnImpl: () => (/* binding */ __objAssignFnImpl),
/* harmony export */   __paramFn: () => (/* binding */ __paramFn),
/* harmony export */   __readFn: () => (/* binding */ __readFn),
/* harmony export */   __restFn: () => (/* binding */ __restFn),
/* harmony export */   __spreadArrayFn: () => (/* binding */ __spreadArrayFn),
/* harmony export */   __spreadArraysFn: () => (/* binding */ __spreadArraysFn),
/* harmony export */   __valuesFn: () => (/* binding */ __valuesFn)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(35);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(19);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(45);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(18);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(12);
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23);
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.


// Most of these functions have been directly shamelessly "lifted" from the https://github.com/@microsoft/tslib and
// modified to be ES5 compatible and applying several minification and tree-shaking techniques so that Application Insights
// can successfully use TypeScript "importHelpers" which imports tslib during compilation but it will use these at runtime
// Which is also why all of the functions have not been included as Application Insights currently doesn't use or require
// them.
var SymbolObj = ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.getGlobal)() || {})["Symbol"];
var ReflectObj = ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.getGlobal)() || {})["Reflect"];
var __hasReflect = !!ReflectObj;
var strDecorate = "decorate";
var strMetadata = "metadata";
var strGetOwnPropertySymbols = "getOwnPropertySymbols";
var strIterator = "iterator";
var strHasOwnProperty = "hasOwnProperty";
var __objAssignFnImpl = function (t) {
    // tslint:disable-next-line: ban-comma-operator
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) {
            if (_Constants__WEBPACK_IMPORTED_MODULE_1__.ObjProto[strHasOwnProperty].call(s, p)) {
                t[p] = s[p];
            }
        }
    }
    return t;
};
var __assignFn = _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.objAssign || __objAssignFnImpl;
// tslint:disable-next-line: only-arrow-functions
var extendStaticsFn = function (d, b) {
    extendStaticsFn = _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjClass["setPrototypeOf"] ||
        // tslint:disable-next-line: only-arrow-functions
        ({ __proto__: [] } instanceof Array && function (d, b) {
            d.__proto__ = b;
        }) ||
        // tslint:disable-next-line: only-arrow-functions
        function (d, b) {
            for (var p in b) {
                if (b[strHasOwnProperty](p)) {
                    d[p] = b[p];
                }
            }
        };
    return extendStaticsFn(d, b);
};
function __extendsFn(d, b) {
    if (typeof b !== _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction && b !== null) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.throwTypeError)("Class extends value " + String(b) + " is not a constructor or null");
    }
    extendStaticsFn(d, b);
    function __() {
        this.constructor = d;
    }
    // tslint:disable-next-line: ban-comma-operator
    d[_Constants__WEBPACK_IMPORTED_MODULE_1__.strShimPrototype] = b === null ? (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.objCreate)(b) : (__[_Constants__WEBPACK_IMPORTED_MODULE_1__.strShimPrototype] = b[_Constants__WEBPACK_IMPORTED_MODULE_1__.strShimPrototype], new __());
}
function __restFn(s, e) {
    var t = {};
    for (var k in s) {
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objHasOwnProperty)(s, k) && e.indexOf(k) < 0) {
            t[k] = s[k];
        }
    }
    if (s != null && typeof _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjClass[strGetOwnPropertySymbols] === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction) {
        for (var i = 0, p = _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjClass[strGetOwnPropertySymbols](s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjProto["propertyIsEnumerable"].call(s, p[i])) {
                t[p[i]] = s[p[i]];
            }
        }
    }
    return t;
}
function __decorateFn(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = _Constants__WEBPACK_IMPORTED_MODULE_1__.ObjClass["getOwnPropertyDescriptor"](target, key) : desc, d;
    if (__hasReflect && typeof ReflectObj[strDecorate] === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction) {
        r = ReflectObj[strDecorate](decorators, target, key, desc);
    }
    else {
        for (var i = decorators.length - 1; i >= 0; i--) {
            // eslint-disable-next-line no-cond-assign
            if (d = decorators[i]) {
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
            }
        }
    }
    // tslint:disable-next-line:ban-comma-operator
    return c > 3 && r && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objDefineProp)(target, key, r), r;
}
function __paramFn(paramIndex, decorator) {
    return function (target, key) {
        decorator(target, key, paramIndex);
    };
}
function __metadataFn(metadataKey, metadataValue) {
    if (__hasReflect && ReflectObj[strMetadata] === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction) {
        return ReflectObj[strMetadata](metadataKey, metadataValue);
    }
}
function __exportStarFn(m, o) {
    for (var p in m) {
        if (p !== _Constants__WEBPACK_IMPORTED_MODULE_1__.strDefault && !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objHasOwnProperty)(o, p)) {
            __createBindingFn(o, m, p);
        }
    }
}
function __createBindingFn(o, m, k, k2) {
    if (k2 === undefined) {
        k2 = k;
    }
    if (!!_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objDefineProp) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objDefineProp)(o, k2, {
            enumerable: true,
            get: function () {
                return m[k];
            }
        });
    }
    else {
        o[k2] = m[k];
    }
}
function __valuesFn(o) {
    var s = typeof SymbolObj === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction && SymbolObj[strIterator], m = s && o[s], i = 0;
    if (m) {
        return m.call(o);
    }
    if (o && typeof o.length === "number") {
        return {
            next: function () {
                if (o && i >= o.length) {
                    o = void 0;
                }
                return { value: o && o[i++], done: !o };
            }
        };
    }
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.throwTypeError)(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}
function __readFn(o, n) {
    var m = typeof SymbolObj === _Constants__WEBPACK_IMPORTED_MODULE_1__.strShimFunction && o[SymbolObj[strIterator]];
    if (!m) {
        return o;
    }
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) {
            ar.push(r.value);
        }
    }
    catch (error) {
        e = {
            error: error
        };
    }
    finally {
        try {
            // tslint:disable-next-line:no-conditional-assignment
            if (r && !r.done && (m = i["return"])) {
                m.call(i);
            }
        }
        finally {
            if (e) {
                // eslint-disable-next-line no-unsafe-finally
                throw e.error;
            }
        }
    }
    return ar;
}
/** @deprecated */
function __spreadArraysFn() {
    var theArgs = arguments;
    // Calculate new total size
    for (var s = 0, i = 0, il = theArgs.length; i < il; i++) {
        s += theArgs[i].length;
    }
    // Create new full array
    for (var r = Array(s), k = 0, i = 0; i < il; i++) {
        for (var a = theArgs[i], j = 0, jl = a.length; j < jl; j++, k++) {
            r[k] = a[j];
        }
    }
    return r;
}
function __spreadArrayFn(to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++) {
        to[j] = from[i];
    }
    return to;
}
function __makeTemplateObjectFn(cooked, raw) {
    if (_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objDefineProp) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objDefineProp)(cooked, "raw", { value: raw });
    }
    else {
        cooked.raw = raw;
    }
    return cooked;
}
function __importStarFn(mod) {
    if (mod && mod.__esModule) {
        return mod;
    }
    var result = {};
    if (mod != null) {
        for (var k in mod) {
            if (k !== _Constants__WEBPACK_IMPORTED_MODULE_1__.strDefault && Object.prototype.hasOwnProperty.call(mod, k)) {
                __createBindingFn(result, mod, k);
            }
        }
    }
    // Set default module
    if (!!_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objDefineProp) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objDefineProp)(result, _Constants__WEBPACK_IMPORTED_MODULE_1__.strDefault, { enumerable: true, value: mod });
    }
    else {
        result[_Constants__WEBPACK_IMPORTED_MODULE_1__.strDefault] = mod;
    }
    return result;
}
function __importDefaultFn(mod) {
    return (mod && mod.__esModule) ? mod : { strDefault: mod };
}
//# sourceMappingURL=TsLibShims.js.map

/***/ }),
/* 45 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   objCreate: () => (/* binding */ objCreate),
/* harmony export */   polyObjCreate: () => (/* binding */ polyObjCreate)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8);
/* harmony import */ var _helpers_diagnostics__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


var _objCreate = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass["create"];
/**
 * Creates an object that has the specified prototype, and that optionally contains specified properties. This helper exists to avoid adding a polyfil
 * for older browsers that do not define Object.create eg. ES3 only, IE8 just in case any page checks for presence/absence of the prototype implementation.
 * Note: For consistency this will not use the Object.create implementation if it exists as this would cause a testing requirement to test with and without the implementations
 * @group Object
 * @param obj Object to use as a prototype. May be null
 */
var objCreate = _objCreate || polyObjCreate;
/**
 * Creates an object that has the specified prototype, and that optionally contains specified properties. This helper exists to avoid adding a polyfil
 * for older browsers that do not define Object.create eg. ES3 only, IE8 just in case any page checks for presence/absence of the prototype implementation.
 * Note: For consistency this will not use the Object.create implementation if it exists as this would cause a testing requirement to test with and without the implementations
 * @group Polyfill
 * @group Object
 * @param obj Object to use as a prototype. May be null
 */
function polyObjCreate(obj) {
    if (!obj) {
        return {};
    }
    var type = typeof obj;
    if (type !== _internal_constants__WEBPACK_IMPORTED_MODULE_0__.OBJECT && type !== _internal_constants__WEBPACK_IMPORTED_MODULE_0__.FUNCTION) {
        throw new TypeError("Prototype must be an Object or function: " + (0,_helpers_diagnostics__WEBPACK_IMPORTED_MODULE_1__.dumpObj)(obj));
    }
    function tempFunc() { }
    tempFunc[_internal_constants__WEBPACK_IMPORTED_MODULE_0__.PROTOTYPE] = obj;
    return new tempFunc();
}
//# sourceMappingURL=create.js.map

/***/ }),
/* 46 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PerfEvent: () => (/* binding */ PerfEvent),
/* harmony export */   PerfManager: () => (/* binding */ PerfManager),
/* harmony export */   doPerf: () => (/* binding */ doPerf),
/* harmony export */   getGblPerfMgr: () => (/* binding */ getGblPerfMgr),
/* harmony export */   setGblPerfMgr: () => (/* binding */ setGblPerfMgr)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(41);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(32);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(34);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






var strExecutionContextKey = "ctx";
var strParentContextKey = "ParentContextKey";
var strChildrenContextKey = "ChildrenContextKey";
var _defaultPerfManager = null;
var PerfEvent = /** @class */ (function () {
    function PerfEvent(name, payloadDetails, isAsync) {
        var _self = this;
        _self.start = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.utcNow)();
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:%2ename */] = name;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_ASYNC /* @min:%2eisAsync */] = isAsync;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_CHILD_EVT /* @min:%2eisChildEvt */] = function () { return false; };
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isFunction)(payloadDetails)) {
            // Create an accessor to minimize the potential performance impact of executing the payloadDetails callback
            var theDetails_1;
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.objDefine)(_self, "payload", {
                g: function () {
                    // Delay the execution of the payloadDetails until needed
                    if (!theDetails_1 && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isFunction)(payloadDetails)) {
                        theDetails_1 = payloadDetails();
                        // clear it out now so the referenced objects can be garbage collected
                        payloadDetails = null;
                    }
                    return theDetails_1;
                }
            });
        }
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */] = function (key) {
            if (key) {
                // The parent and child links are located directly on the object (for better viewing in the DebugPlugin)
                if (key === PerfEvent[strParentContextKey] || key === PerfEvent[strChildrenContextKey]) {
                    return _self[key];
                }
                return (_self[strExecutionContextKey] || {})[key];
            }
            return null;
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */] = function (key, value) {
            if (key) {
                // Put the parent and child links directly on the object (for better viewing in the DebugPlugin)
                if (key === PerfEvent[strParentContextKey]) {
                    // Simple assumption, if we are setting a parent then we must be a child
                    if (!_self[key]) {
                        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_CHILD_EVT /* @min:%2eisChildEvt */] = function () { return true; };
                    }
                    _self[key] = value;
                }
                else if (key === PerfEvent[strChildrenContextKey]) {
                    _self[key] = value;
                }
                else {
                    var ctx = _self[strExecutionContextKey] = _self[strExecutionContextKey] || {};
                    ctx[key] = value;
                }
            }
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COMPLETE /* @min:%2ecomplete */] = function () {
            var childTime = 0;
            var childEvts = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */](PerfEvent[strChildrenContextKey]);
            if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isArray)(childEvts)) {
                for (var lp = 0; lp < childEvts[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]; lp++) {
                    var childEvt = childEvts[lp];
                    if (childEvt) {
                        childTime += childEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIME /* @min:%2etime */];
                    }
                }
            }
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIME /* @min:%2etime */] = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.utcNow)() - _self.start;
            _self.exTime = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIME /* @min:%2etime */] - childTime;
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COMPLETE /* @min:%2ecomplete */] = function () { };
        };
    }
    PerfEvent.ParentContextKey = "parent";
    PerfEvent.ChildrenContextKey = "childEvts";
    return PerfEvent;
}());

var PerfManager = /** @class */ (function () {
    function PerfManager(manager) {
        /**
         * General bucket used for execution context set and retrieved via setCtx() and getCtx.
         * Defined as private so it can be visualized via the DebugPlugin
         */
        this.ctx = {};
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__["default"])(PerfManager, this, function (_self) {
            _self.create = function (src, payloadDetails, isAsync) {
                // TODO (@MSNev): at some point we will want to add additional configuration to "select" which events to instrument
                // for now this is just a simple do everything.
                return new PerfEvent(src, payloadDetails, isAsync);
            };
            _self.fire = function (perfEvent) {
                if (perfEvent) {
                    perfEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COMPLETE /* @min:%2ecomplete */]();
                    if (manager && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isFunction)(manager[_InternalConstants__WEBPACK_IMPORTED_MODULE_5__.STR_PERF_EVENT /* @min:%2eperfEvent */])) {
                        manager[_InternalConstants__WEBPACK_IMPORTED_MODULE_5__.STR_PERF_EVENT /* @min:%2eperfEvent */](perfEvent);
                    }
                }
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */] = function (key, value) {
                if (key) {
                    var ctx = _self[strExecutionContextKey] = _self[strExecutionContextKey] || {};
                    ctx[key] = value;
                }
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */] = function (key) {
                return (_self[strExecutionContextKey] || {})[key];
            };
        });
    }
// Removed Stub for PerfManager.prototype.create.
// Removed Stub for PerfManager.prototype.fire.
// Removed Stub for PerfManager.prototype.setCtx.
// Removed Stub for PerfManager.prototype.getCtx.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    PerfManager.__ieDyn=1;

    return PerfManager;
}());

var doPerfActiveKey = "CoreUtils.doPerf";
/**
 * Helper function to wrap a function with a perf event
 * @param mgrSource - The Performance Manager or a Performance provider source (may be null)
 * @param getSource - The callback to create the source name for the event (if perf monitoring is enabled)
 * @param func - The function to call and measure
 * @param details - A function to return the payload details
 * @param isAsync - Is the event / function being call asynchronously or synchronously
 */
function doPerf(mgrSource, getSource, func, details, isAsync) {
    if (mgrSource) {
        var perfMgr = mgrSource;
        if (perfMgr[_InternalConstants__WEBPACK_IMPORTED_MODULE_5__.STR_GET_PERF_MGR]) {
            // Looks like a perf manager provider object
            perfMgr = perfMgr[_InternalConstants__WEBPACK_IMPORTED_MODULE_5__.STR_GET_PERF_MGR]();
        }
        if (perfMgr) {
            var perfEvt = void 0;
            var currentActive = perfMgr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */](doPerfActiveKey);
            try {
                perfEvt = perfMgr.create(getSource(), details, isAsync);
                if (perfEvt) {
                    if (currentActive && perfEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */]) {
                        perfEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */](PerfEvent[strParentContextKey], currentActive);
                        if (currentActive[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */] && currentActive[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */]) {
                            var children = currentActive[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CTX /* @min:%2egetCtx */](PerfEvent[strChildrenContextKey]);
                            if (!children) {
                                children = [];
                                currentActive[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */](PerfEvent[strChildrenContextKey], children);
                            }
                            children[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](perfEvt);
                        }
                    }
                    // Set this event as the active event now
                    perfMgr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */](doPerfActiveKey, perfEvt);
                    return func(perfEvt);
                }
            }
            catch (ex) {
                if (perfEvt && perfEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */]) {
                    perfEvt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */]("exception", ex);
                }
            }
            finally {
                // fire the perf event
                if (perfEvt) {
                    perfMgr.fire(perfEvt);
                }
                // Reset the active event to the previous value
                perfMgr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CTX /* @min:%2esetCtx */](doPerfActiveKey, currentActive);
            }
        }
    }
    return func();
}
/**
 * Set the global performance manager to use when there is no core instance or it has not been initialized yet.
 * @param perfManager - The IPerfManager instance to use when no performance manager is supplied.
 */
function setGblPerfMgr(perfManager) {
    _defaultPerfManager = perfManager;
}
/**
 * Get the current global performance manager that will be used with no performance manager is supplied.
 * @returns - The current default manager
 */
function getGblPerfMgr() {
    return _defaultPerfManager;
}
//# sourceMappingURL=PerfManager.js.map

/***/ }),
/* 47 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createDynamicConfig: () => (/* binding */ createDynamicConfig),
/* harmony export */   onConfigChange: () => (/* binding */ onConfigChange)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(15);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(12);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(26);
/* harmony import */ var _JavaScriptSDK_DataCacheHelper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(48);
/* harmony import */ var _JavaScriptSDK_InternalConstants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(34);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(32);
/* harmony import */ var _ConfigDefaults__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(49);
/* harmony import */ var _DynamicProperty__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(50);
/* harmony import */ var _DynamicState__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(59);
/* harmony import */ var _DynamicSupport__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(51);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */










/**
 * Identifies a function which will be re-called whenever any of it's accessed configuration values
 * change.
 * @param configHandler - The callback that will be called for the initial request and then whenever any
 * accessed configuration changes are identified.
 */
function _createAndUseHandler(state, configHandler) {
    var handler = {
        fn: configHandler,
        rm: function () {
            // Clear all references to the handler so it can be garbage collected
            // This will also cause this handler to never get called and eventually removed
            handler.fn = null;
            state = null;
            configHandler = null;
        }
    };
    state.use(handler, configHandler);
    return handler;
}
/**
 * Creates the dynamic config handler and associates with the target config as the root object
 * @param target - The config that you want to be root of the dynamic config
 * @param inPlace - Should the passed config be converted in-place or a new proxy returned
 * @returns The existing dynamic handler or a new instance with the provided config values
 */
function _createDynamicHandler(logger, target, inPlace) {
    var _a;
    var dynamicHandler = (0,_DynamicSupport__WEBPACK_IMPORTED_MODULE_0__.getDynamicConfigHandler)(target);
    if (dynamicHandler) {
        // The passed config is already dynamic so return it's tracker
        return dynamicHandler;
    }
    var uid = (0,_JavaScriptSDK_DataCacheHelper__WEBPACK_IMPORTED_MODULE_1__.createUniqueNamespace)("dyncfg", true);
    var newTarget = (target && inPlace !== false) ? target : (0,_DynamicSupport__WEBPACK_IMPORTED_MODULE_0__._cfgDeepCopy)(target);
    var theState;
    function _notifyWatchers() {
        theState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NOTIFY /* @min:%2enotify */]();
    }
    function _setValue(target, name, value) {
        try {
            target = (0,_DynamicProperty__WEBPACK_IMPORTED_MODULE_3__._setDynamicProperty)(theState, target, name, value);
        }
        catch (e) {
            // Unable to convert to dynamic property so just leave as non-dynamic
            (0,_DynamicProperty__WEBPACK_IMPORTED_MODULE_3__._throwDynamicError)(logger, name, "Setting value", e);
        }
        return target[name];
    }
    function _watch(configHandler) {
        return _createAndUseHandler(theState, configHandler);
    }
    function _block(configHandler, allowUpdate) {
        theState.use(null, function (details) {
            var prevUpd = theState.upd;
            try {
                if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isUndefined)(allowUpdate)) {
                    theState.upd = allowUpdate;
                }
                configHandler(details);
            }
            finally {
                theState.upd = prevUpd;
            }
        });
    }
    function _ref(target, name) {
        var _a;
        // Make sure it's dynamic and mark as referenced with it's current value
        return (0,_DynamicProperty__WEBPACK_IMPORTED_MODULE_3__._setDynamicPropertyState)(theState, target, name, (_a = {}, _a[0 /* _eSetDynamicPropertyFlags.inPlace */] = true, _a))[name];
    }
    function _rdOnly(target, name) {
        var _a;
        // Make sure it's dynamic and mark as readonly with it's current value
        return (0,_DynamicProperty__WEBPACK_IMPORTED_MODULE_3__._setDynamicPropertyState)(theState, target, name, (_a = {}, _a[1 /* _eSetDynamicPropertyFlags.readOnly */] = true, _a))[name];
    }
    function _blkPropValue(target, name) {
        var _a;
        // Make sure it's dynamic and mark as readonly with it's current value
        return (0,_DynamicProperty__WEBPACK_IMPORTED_MODULE_3__._setDynamicPropertyState)(theState, target, name, (_a = {}, _a[2 /* _eSetDynamicPropertyFlags.blockDynamicProperty */] = true, _a))[name];
    }
    function _applyDefaults(theConfig, defaultValues) {
        if (defaultValues) {
            // Resolve/apply the defaults
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objForEachKey)(defaultValues, function (name, value) {
                // Sets the value and makes it dynamic (if it doesn't already exist)
                (0,_ConfigDefaults__WEBPACK_IMPORTED_MODULE_6__._applyDefaultValue)(cfgHandler, theConfig, name, value);
            });
        }
        return theConfig;
    }
    var cfgHandler = (_a = {
            uid: null,
            cfg: newTarget
        },
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LOGGER /* @min:logger */] = logger,
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NOTIFY /* @min:notify */] = _notifyWatchers,
        _a.set = _setValue,
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_SET_DF /* @min:setDf */] = _applyDefaults,
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_WATCH /* @min:watch */] = _watch,
        _a.ref = _ref,
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_RD_ONLY /* @min:rdOnly */] = _rdOnly,
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_BLK_VAL /* @min:blkVal */] = _blkPropValue,
        _a._block = _block,
        _a);
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.objDefine)(cfgHandler, "uid", {
        c: false,
        e: false,
        w: false,
        v: uid
    });
    theState = (0,_DynamicState__WEBPACK_IMPORTED_MODULE_8__._createState)(cfgHandler);
    // Setup tracking for all defined default keys
    (0,_DynamicProperty__WEBPACK_IMPORTED_MODULE_3__._makeDynamicObject)(theState, newTarget, "config", "Creating");
    return cfgHandler;
}
/**
 * Log an invalid access message to the console
 * @param message
 */
function _logInvalidAccess(logger, message) {
    if (logger) {
        logger[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_WARN_TO_CONSOLE /* @min:%2ewarnToConsole */](message);
        logger[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_THROW_INTERNAL /* @min:%2ethrowInternal */](2 /* eLoggingSeverity.WARNING */, 108 /* _eInternalMessageId.DynamicConfigException */, message);
    }
    else {
        // We don't have a logger so just throw an exception
        (0,_DynamicSupport__WEBPACK_IMPORTED_MODULE_0__.throwInvalidAccess)(message);
    }
}
/**
 * Create or return a dynamic version of the passed config, if it is not already dynamic
 * @param config - The config to be converted into a dynamic config
 * @param defaultConfig - The default values to apply on the config if the properties don't already exist
 * @param inPlace - Should the config be converted in-place into a dynamic config or a new instance returned, defaults to true
 * @returns The dynamic config handler for the config (whether new or existing)
 */
function createDynamicConfig(config, defaultConfig, logger, inPlace) {
    var dynamicHandler = _createDynamicHandler(logger, config || {}, inPlace);
    if (defaultConfig) {
        dynamicHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_SET_DF /* @min:%2esetDf */](dynamicHandler.cfg, defaultConfig);
    }
    return dynamicHandler;
}
/**
 * Watch and track changes for accesses to the current config, the provided config MUST already be
 * a dynamic config or a child accessed via the dynamic config
 * @param config
 * @param configHandler
 * @param logger - The logger instance to use if there is no existing handler
 * @returns A watcher handler instance that can be used to remove itself when being unloaded
 * @throws TypeError if the provided config is not a dynamic config instance
 */
function onConfigChange(config, configHandler, logger) {
    var handler = config[_DynamicSupport__WEBPACK_IMPORTED_MODULE_0__.CFG_HANDLER_LINK] || config;
    if (handler.cfg && (handler.cfg === config || handler.cfg[_DynamicSupport__WEBPACK_IMPORTED_MODULE_0__.CFG_HANDLER_LINK] === handler)) {
        return handler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_WATCH /* @min:%2ewatch */](configHandler);
    }
    _logInvalidAccess(logger, _JavaScriptSDK_InternalConstants__WEBPACK_IMPORTED_MODULE_9__.STR_NOT_DYNAMIC_ERROR + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__.dumpObj)(config));
    return createDynamicConfig(config, null, logger)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_WATCH /* @min:%2ewatch */](configHandler);
}
//# sourceMappingURL=DynamicConfig.js.map

/***/ }),
/* 48 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createElmNodeData: () => (/* binding */ createElmNodeData),
/* harmony export */   createUniqueNamespace: () => (/* binding */ createUniqueNamespace)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(32);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(33);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(34);
/* harmony import */ var _RandomHelper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */







var version = '3.0.4';
var instanceName = "." + (0,_RandomHelper__WEBPACK_IMPORTED_MODULE_0__.newId)(6);
var _dataUid = 0;
// Accepts only:
//  - Node
//    - Node.ELEMENT_NODE
//    - Node.DOCUMENT_NODE
//  - Object
//    - Any
function _canAcceptData(target) {
    return target[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NODE_TYPE /* @min:%2enodeType */] === 1 || target[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NODE_TYPE /* @min:%2enodeType */] === 9 || !(+target[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NODE_TYPE /* @min:%2enodeType */]);
}
function _getCache(data, target) {
    var theCache = target[data.id];
    if (!theCache) {
        theCache = {};
        try {
            if (_canAcceptData(target)) {
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.objDefine)(target, data.id, {
                    e: false,
                    v: theCache
                });
            }
        }
        catch (e) {
            // Not all environments allow extending all objects, so just ignore the cache in those cases
        }
    }
    return theCache;
}
function createUniqueNamespace(name, includeVersion) {
    if (includeVersion === void 0) { includeVersion = false; }
    return (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.normalizeJsName)(name + (_dataUid++) + (includeVersion ? "." + version : _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY) + instanceName);
}
function createElmNodeData(name) {
    var data = {
        id: createUniqueNamespace("_aiData-" + (name || _InternalConstants__WEBPACK_IMPORTED_MODULE_4__.STR_EMPTY) + "." + version),
        accept: function (target) {
            return _canAcceptData(target);
        },
        get: function (target, name, defValue, addDefault) {
            var theCache = target[data.id];
            if (!theCache) {
                if (addDefault) {
                    // Side effect is adds the cache
                    theCache = _getCache(data, target);
                    theCache[(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.normalizeJsName)(name)] = defValue;
                }
                return defValue;
            }
            return theCache[(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_3__.normalizeJsName)(name)];
        },
        kill: function (target, name) {
            if (target && target[name]) {
                try {
                    delete target[name];
                }
                catch (e) {
                    // Just cleaning up, so if this fails -- ignore
                }
            }
        }
    };
    return data;
}
//# sourceMappingURL=DataCacheHelper.js.map

/***/ }),
/* 49 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _applyDefaultValue: () => (/* binding */ _applyDefaultValue)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(27);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(38);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(15);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(32);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */




function _isConfigDefaults(value) {
    return (value && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isObject)(value) && (value.isVal || value.fb || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwn)(value, "v") || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwn)(value, "mrg") || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.objHasOwn)(value, "ref") || value.set));
}
function _getDefault(dynamicHandler, theConfig, cfgDefaults) {
    var defValue;
    var isDefaultValid = cfgDefaults.dfVal || _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isDefined;
    // There is a fallback config key so try and grab that first
    if (theConfig && cfgDefaults.fb) {
        var fallbacks = cfgDefaults.fb;
        if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isArray)(fallbacks)) {
            fallbacks = [fallbacks];
        }
        for (var lp = 0; lp < fallbacks[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */]; lp++) {
            var fallback = fallbacks[lp];
            var fbValue = theConfig[fallback];
            if (isDefaultValid(fbValue)) {
                defValue = fbValue;
            }
            else if (dynamicHandler) {
                // Needed to ensure that the fallback value (and potentially) new field is also dynamic even if null/undefined
                fbValue = dynamicHandler.cfg[fallback];
                if (isDefaultValid(fbValue)) {
                    defValue = fbValue;
                }
                // Needed to ensure that the fallback value (and potentially) new field is also dynamic even if null/undefined
                dynamicHandler.set(dynamicHandler.cfg, (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.asString)(fallback), fbValue);
            }
            if (isDefaultValid(defValue)) {
                // We have a valid default so break out of the look
                break;
            }
        }
    }
    // If the value is still not defined and we have a default value then use that
    if (!isDefaultValid(defValue) && isDefaultValid(cfgDefaults.v)) {
        defValue = cfgDefaults.v;
    }
    return defValue;
}
/**
 * Recursively resolve the default value
 * @param dynamicHandler
 * @param theConfig
 * @param cfgDefaults
 * @returns
 */
function _resolveDefaultValue(dynamicHandler, theConfig, cfgDefaults) {
    var theValue = cfgDefaults;
    if (cfgDefaults && _isConfigDefaults(cfgDefaults)) {
        theValue = _getDefault(dynamicHandler, theConfig, cfgDefaults);
    }
    if (theValue) {
        if (_isConfigDefaults(theValue)) {
            theValue = _resolveDefaultValue(dynamicHandler, theConfig, theValue);
        }
        var newValue_1;
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isArray)(theValue)) {
            newValue_1 = [];
            newValue_1[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] = theValue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */];
        }
        else if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isPlainObject)(theValue)) {
            newValue_1 = {};
        }
        if (newValue_1) {
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objForEachKey)(theValue, function (key, value) {
                if (value && _isConfigDefaults(value)) {
                    value = _resolveDefaultValue(dynamicHandler, theConfig, value);
                }
                newValue_1[key] = value;
            });
            theValue = newValue_1;
        }
    }
    return theValue;
}
/**
 * Applies the default value on the config property and makes sure that it's dynamic
 * @param theConfig
 * @param name
 * @param defaultValue
 */
function _applyDefaultValue(dynamicHandler, theConfig, name, defaultValue) {
    // Resolve the initial config value from the provided value or use the defined default
    var isValid;
    var setFn;
    var defValue;
    var cfgDefaults = defaultValue;
    var mergeDf;
    var reference;
    var readOnly;
    var blkDynamicValue;
    if (_isConfigDefaults(cfgDefaults)) {
        // looks like a IConfigDefault
        isValid = cfgDefaults.isVal;
        setFn = cfgDefaults.set;
        readOnly = cfgDefaults[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_RD_ONLY /* @min:%2erdOnly */];
        blkDynamicValue = cfgDefaults[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_BLK_VAL /* @min:%2eblkVal */];
        mergeDf = cfgDefaults.mrg;
        reference = cfgDefaults.ref;
        if (!reference && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isUndefined)(reference)) {
            reference = !!mergeDf;
        }
        defValue = _getDefault(dynamicHandler, theConfig, cfgDefaults);
    }
    else {
        defValue = defaultValue;
    }
    if (blkDynamicValue) {
        // Mark the property so that any value assigned will be blocked from conversion, we need to do this
        // before assigning or fetching the value to ensure it's not converted
        dynamicHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_BLK_VAL /* @min:%2eblkVal */](theConfig, name);
    }
    // Set the value to the default value;
    var theValue;
    var usingDefault = true;
    var cfgValue = theConfig[name];
    // try and get and user provided values
    if (cfgValue || !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isNullOrUndefined)(cfgValue)) {
        // Use the defined theConfig[name] value
        theValue = cfgValue;
        usingDefault = false;
        // The values are different and we have a special default value check, which is used to
        // override config values like empty strings to continue using the default
        if (isValid && theValue !== defValue && !isValid(theValue)) {
            theValue = defValue;
            usingDefault = true;
        }
        if (setFn) {
            theValue = setFn(theValue, defValue, theConfig);
            usingDefault = theValue === defValue;
        }
    }
    if (!usingDefault) {
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isPlainObject)(theValue) || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isArray)(defValue)) {
            // we are using the user supplied value and it's an object
            if (mergeDf && defValue && ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isPlainObject)(defValue) || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isArray)(defValue))) {
                // Resolve/apply the defaults
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objForEachKey)(defValue, function (dfName, dfValue) {
                    // Sets the value and makes it dynamic (if it doesn't already exist)
                    _applyDefaultValue(dynamicHandler, theValue, dfName, dfValue);
                });
            }
        }
    }
    else if (defValue) {
        // Just resolve the default
        theValue = _resolveDefaultValue(dynamicHandler, theConfig, defValue);
    }
    else {
        theValue = defValue;
    }
    // if (theValue && usingDefault && (isPlainObject(theValue) || isArray(theValue))) {
    //     theValue = _cfgDeepCopy(theValue);
    // }
    // Needed to ensure that the (potentially) new field is dynamic even if null/undefined
    dynamicHandler.set(theConfig, name, theValue);
    if (reference) {
        dynamicHandler.ref(theConfig, name);
    }
    if (readOnly) {
        dynamicHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_RD_ONLY /* @min:%2erdOnly */](theConfig, name);
    }
}
//# sourceMappingURL=ConfigDefaults.js.map

/***/ }),
/* 50 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _makeDynamicObject: () => (/* binding */ _makeDynamicObject),
/* harmony export */   _setDynamicProperty: () => (/* binding */ _setDynamicProperty),
/* harmony export */   _setDynamicPropertyState: () => (/* binding */ _setDynamicPropertyState),
/* harmony export */   _throwDynamicError: () => (/* binding */ _throwDynamicError)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(17);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(58);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(15);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(12);
/* harmony import */ var _JavaScriptSDK_InternalConstants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(34);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(32);
/* harmony import */ var _DynamicSupport__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(51);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






var arrayMethodsToPatch = [
    "push",
    "pop",
    "shift",
    "unshift",
    "splice"
];
var _throwDynamicError = function (logger, name, desc, e) {
    logger && logger[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_THROW_INTERNAL /* @min:%2ethrowInternal */](3 /* eLoggingSeverity.DEBUG */, 108 /* _eInternalMessageId.DynamicConfigException */, "".concat(desc, " [").concat(name, "] failed - ") + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.dumpObj)(e));
};
function _patchArray(state, target, name) {
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.isArray)(target)) {
        // Monkey Patch the methods that might change the array
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(arrayMethodsToPatch, function (method) {
            var orgMethod = target[method];
            target[method] = function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var result = orgMethod[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_APPLY /* @min:%2eapply */](this, args);
                // items may be added, removed or moved so need to make some new dynamic properties
                _makeDynamicObject(state, target, name, "Patching");
                return result;
            };
        });
    }
}
function _getOwnPropGetter(target, name) {
    var propDesc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.objGetOwnPropertyDescriptor)(target, name);
    return propDesc && propDesc.get;
}
function _createDynamicProperty(state, theConfig, name, value) {
    // Does not appear to be dynamic so lets make it so
    var detail = {
        n: name,
        h: [],
        trk: function (handler) {
            if (handler && handler.fn) {
                if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.arrIndexOf)(detail.h, handler) === -1) {
                    // Add this handler to the collection that should be notified when the value changes
                    detail.h[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PUSH /* @min:%2epush */](handler);
                }
                state.trk(handler, detail);
            }
        },
        clr: function (handler) {
            var idx = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.arrIndexOf)(detail.h, handler);
            if (idx !== -1) {
                detail.h[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SPLICE /* @min:%2esplice */](idx, 1);
            }
        }
    };
    // Flag to optimize lookup response time by avoiding additional function calls
    var checkDynamic = true;
    var isObjectOrArray = false;
    function _getProperty() {
        if (checkDynamic) {
            isObjectOrArray = isObjectOrArray || (0,_DynamicSupport__WEBPACK_IMPORTED_MODULE_6__._canMakeDynamic)(_getProperty, state, value);
            // Make sure that if it's an object that we make it dynamic
            if (value && !value[_DynamicSupport__WEBPACK_IMPORTED_MODULE_6__.CFG_HANDLER_LINK] && isObjectOrArray) {
                // It doesn't look like it's already dynamic so lets make sure it's converted the object into a dynamic Config as well
                value = _makeDynamicObject(state, value, name, "Converting");
            }
            // If it needed to be converted it now has been
            checkDynamic = false;
        }
        // If there is an active handler then add it to the tracking set of handlers
        var activeHandler = state.act;
        if (activeHandler) {
            detail.trk(activeHandler);
        }
        return value;
    }
    // Tag this getter as our dynamic property and provide shortcut for notifying a change
    _getProperty[state.prop] = {
        chng: function () {
            state.add(detail);
        }
    };
    function _setProperty(newValue) {
        if (value !== newValue) {
            if (!!_getProperty[state.ro] && !state.upd) {
                // field is marked as readonly so return false
                (0,_DynamicSupport__WEBPACK_IMPORTED_MODULE_6__.throwInvalidAccess)("[" + name + "] is read-only:" + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.dumpObj)(theConfig));
            }
            if (checkDynamic) {
                isObjectOrArray = isObjectOrArray || (0,_DynamicSupport__WEBPACK_IMPORTED_MODULE_6__._canMakeDynamic)(_getProperty, state, value);
                checkDynamic = false;
            }
            // The value must be a plain object or an array to enforce the reference (in-place updates)
            var isReferenced = isObjectOrArray && _getProperty[state.rf];
            if (isObjectOrArray) {
                // We are about to replace a plain object or an array
                if (isReferenced) {
                    // Reassign the properties from the current value to the same properties from the newValue
                    // This will set properties not in the newValue to undefined
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.objForEachKey)(value, function (key) {
                        value[key] = newValue ? newValue[key] : _JavaScriptSDK_InternalConstants__WEBPACK_IMPORTED_MODULE_8__.UNDEFINED_VALUE;
                    });
                    // Now assign / re-assign value with all of the keys from newValue
                    try {
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.objForEachKey)(newValue, function (key, theValue) {
                            _setDynamicProperty(state, value, key, theValue);
                        });
                        // Now drop newValue so when we assign value later it keeps the existing reference
                        newValue = value;
                    }
                    catch (e) {
                        // Unable to convert to dynamic property so just leave as non-dynamic
                        _throwDynamicError((state.hdlr || {})[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOGGER /* @min:%2elogger */], name, "Assigning", e);
                        // Mark as not an object or array so we don't try and do this again
                        isObjectOrArray = false;
                    }
                }
                else if (value && value[_DynamicSupport__WEBPACK_IMPORTED_MODULE_6__.CFG_HANDLER_LINK]) {
                    // As we are replacing the value, if it's already dynamic then we need to notify the listeners
                    // for every property it has already
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.objForEachKey)(value, function (key) {
                        // Check if the value is dynamic
                        var getter = _getOwnPropGetter(value, key);
                        if (getter) {
                            // And if it is tell it's listeners that the value has changed
                            var valueState = getter[state.prop];
                            valueState && valueState.chng();
                        }
                    });
                }
            }
            if (newValue !== value) {
                var newIsObjectOrArray = newValue && (0,_DynamicSupport__WEBPACK_IMPORTED_MODULE_6__._canMakeDynamic)(_getProperty, state, newValue);
                if (!isReferenced && newIsObjectOrArray) {
                    // As the newValue is an object/array lets preemptively make it dynamic
                    newValue = _makeDynamicObject(state, newValue, name, "Converting");
                }
                // Now assign the internal "value" to the newValue
                value = newValue;
                isObjectOrArray = newIsObjectOrArray;
            }
            // Cause any listeners to be scheduled for notification
            state.add(detail);
        }
    }
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.objDefine)(theConfig, detail.n, { g: _getProperty, s: _setProperty });
}
function _setDynamicProperty(state, target, name, value) {
    if (target) {
        // To be a dynamic property it needs to have a get function
        var getter = _getOwnPropGetter(target, name);
        var isDynamic = getter && !!getter[state.prop];
        if (!isDynamic) {
            _createDynamicProperty(state, target, name, value);
        }
        else {
            // Looks like it's already dynamic just assign the new value
            target[name] = value;
        }
    }
    return target;
}
function _setDynamicPropertyState(state, target, name, flags) {
    if (target) {
        // To be a dynamic property it needs to have a get function
        var getter = _getOwnPropGetter(target, name);
        var isDynamic = getter && !!getter[state.prop];
        var inPlace = flags && flags[0 /* _eSetDynamicPropertyFlags.inPlace */];
        var rdOnly = flags && flags[1 /* _eSetDynamicPropertyFlags.readOnly */];
        var blkProp = flags && flags[2 /* _eSetDynamicPropertyFlags.blockDynamicProperty */];
        if (!isDynamic) {
            if (blkProp) {
                try {
                    // Attempt to mark the target as blocked from conversion
                    (0,_DynamicSupport__WEBPACK_IMPORTED_MODULE_6__.blockDynamicConversion)(target);
                }
                catch (e) {
                    _throwDynamicError((state.hdlr || {})[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOGGER /* @min:%2elogger */], name, "Blocking", e);
                }
            }
            try {
                // Make sure it's dynamic so that we can tag the property as per the state
                _setDynamicProperty(state, target, name, target[name]);
                getter = _getOwnPropGetter(target, name);
            }
            catch (e) {
                // Unable to convert to dynamic property so just leave as non-dynamic
                _throwDynamicError((state.hdlr || {})[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOGGER /* @min:%2elogger */], name, "State", e);
            }
        }
        // Assign the optional flags if true
        if (inPlace) {
            getter[state.rf] = inPlace;
        }
        if (rdOnly) {
            getter[state.ro] = rdOnly;
        }
        if (blkProp) {
            getter[state.blkVal] = true;
        }
    }
    return target;
}
function _makeDynamicObject(state, target, name, desc) {
    try {
        // Assign target with new value properties (converting into dynamic properties in the process)
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.objForEachKey)(target, function (key, value) {
            // Assign and/or make the property dynamic
            _setDynamicProperty(state, target, key, value);
        });
        if (!target[_DynamicSupport__WEBPACK_IMPORTED_MODULE_6__.CFG_HANDLER_LINK]) {
            // Link the config back to the dynamic config details
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.objDefineProp)(target, _DynamicSupport__WEBPACK_IMPORTED_MODULE_6__.CFG_HANDLER_LINK, {
                get: function () {
                    return state[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_HDLR /* @min:%2ehdlr */];
                }
            });
            _patchArray(state, target, name);
        }
    }
    catch (e) {
        // Unable to convert to dynamic property so just leave as non-dynamic
        _throwDynamicError((state.hdlr || {})[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOGGER /* @min:%2elogger */], name, desc, e);
    }
    return target;
}
//# sourceMappingURL=DynamicProperty.js.map

/***/ }),
/* 51 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CFG_HANDLER_LINK: () => (/* binding */ CFG_HANDLER_LINK),
/* harmony export */   _canMakeDynamic: () => (/* binding */ _canMakeDynamic),
/* harmony export */   _cfgDeepCopy: () => (/* binding */ _cfgDeepCopy),
/* harmony export */   blockDynamicConversion: () => (/* binding */ blockDynamicConversion),
/* harmony export */   forceDynamicConversion: () => (/* binding */ forceDynamicConversion),
/* harmony export */   getDynamicConfigHandler: () => (/* binding */ getDynamicConfigHandler),
/* harmony export */   throwInvalidAccess: () => (/* binding */ throwInvalidAccess)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(52);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(38);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(15);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(19);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(32);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */




// Using Symbol.for so that if the same symbol was already created it would be returned
// To handle multiple instances using potentially different versions we are not using
// createUniqueNamespace()
var CFG_HANDLER_LINK = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.symbolFor)("[[ai_dynCfg_1]]");
/**
 * @internal
 * @ignore
 * The symbol to tag objects / arrays with if they should not be converted
 */
var BLOCK_DYNAMIC = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.symbolFor)("[[ai_blkDynCfg_1]]");
/**
 * @internal
 * @ignore
 * The symbol to tag objects to indicate that when included into the configuration that
 * they should be converted into a trackable dynamic object.
 */
var FORCE_DYNAMIC = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.symbolFor)("[[ai_frcDynCfg_1]]");
function _cfgDeepCopy(source) {
    if (source) {
        var target_1;
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.isArray)(source)) {
            target_1 = [];
            target_1[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] = source[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */];
        }
        else if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isPlainObject)(source)) {
            target_1 = {};
        }
        if (target_1) {
            // Copying index values by property name as the extensionConfig can be an array or object
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.objForEachKey)(source, function (key, value) {
                // Perform a deep copy of the object
                target_1[key] = _cfgDeepCopy(value);
            });
            return target_1;
        }
    }
    return source;
}
/**
 * @internal
 * Get the dynamic config handler if the value is already dynamic
 * @param value
 * @returns
 */
function getDynamicConfigHandler(value) {
    if (value) {
        var handler = value[CFG_HANDLER_LINK] || value;
        if (handler.cfg && (handler.cfg === value || handler.cfg[CFG_HANDLER_LINK] === handler)) {
            return handler;
        }
    }
    return null;
}
/**
 * Mark the provided value so that if it's included into the configuration it will NOT have
 * its properties converted into a dynamic (reactive) object. If the object is not a plain object
 * or an array (ie. a class) this function has not affect as only Objects and Arrays are converted
 * into dynamic objects in the dynamic configuration.
 *
 * When you have tagged a value as both {@link forceDynamicConversion} and blocked force will take precedence.
 *
 * You should only need to use this function, if you are creating dynamic "classes" from objects
 * which confirm to the require interface. A common case for this is during unit testing where it's
 * easier to create mock extensions.
 *
 * If `value` is falsy (null / undefined / 0 / empty string etc) it will not be tagged and
 * if there is an exception adding the property to the value (because its frozen etc) the
 * exception will be swallowed
 *
 * @example
 * ```ts
 * // This is a valid "extension", but it is technically an object
 * // So when included in the config.extensions it WILL be cloned and then
 * // converted into a dynamic object, where all of its properties will become
 * // get/set object properties and will be tracked. While this WILL still
 * // function, when attempt to use a mocking framework on top of this the
 * // functions are now technically get accessors which return a function
 * // and this can cause some mocking frameworks to fail.
 * let mockChannel = {
 *      pause: () => { },
*      resume: () => { },
*      teardown: () => { },
*      flush: (async: any, callBack: any) => { },
*      processTelemetry: (env: any) => { },
*      setNextPlugin: (next: any) => { },
*      initialize: (config: any, core: any, extensions: any) => { },
*      identifier: "testChannel",
*      priority: 1003
* };
 * ```
 * @param value - The object that you want to block from being converted into a
 * trackable dynamic object
 * @returns The original value
 */
function blockDynamicConversion(value) {
    if (value && ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isPlainObject)(value) || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.isArray)(value))) {
        try {
            value[BLOCK_DYNAMIC] = true;
        }
        catch (e) {
            // Don't throw for this case as it's an ask only
        }
    }
    return value;
}
/**
 * This is the reverse case of {@link blockDynamicConversion} in that this will tag an
 * object to indicate that it should always be converted into a dynamic trackable object
 * even when not an object or array. So all properties of this object will become
 * get / set accessor functions.
 *
 * When you have tagged a value as both {@link forceDynamicConversion} and blocked force will take precedence.
 *
 * If `value` is falsy (null / undefined / 0 / empty string etc) it will not be tagged and
 * if there is an exception adding the property to the value (because its frozen etc) the
 * exception will be swallowed.
 * @param value - The object that should be tagged and converted if included into a dynamic
 * configuration.
 * @returns The original value
 */
function forceDynamicConversion(value) {
    if (value) {
        try {
            value[FORCE_DYNAMIC] = true;
        }
        catch (e) {
            // Don't throw for this case as it's an ask only
        }
    }
    return value;
}
/**
 * @internal
 * @ignore
 * Helper function to check whether an object can or should be converted into a dynamic
 * object.
 * @param value - The object to check whether it should be converted
 * @returns `true` if the value should be converted otherwise `false`.
 */
function _canMakeDynamic(getFunc, state, value) {
    var result = false;
    // Object must exist and be truthy
    if (value && !getFunc[state.blkVal]) {
        // Tagged as always convert
        result = value[FORCE_DYNAMIC];
        // Check that it's not explicitly tagged as blocked
        if (!result && !value[BLOCK_DYNAMIC]) {
            // Only convert plain objects or arrays by default
            result = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isPlainObject)(value) || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.isArray)(value);
        }
    }
    return result;
}
/**
 * Throws an invalid access exception
 * @param message - The message to include in the exception
 */
function throwInvalidAccess(message) {
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.throwTypeError)("InvalidAccess:" + message);
}
//# sourceMappingURL=DynamicSupport.js.map

/***/ }),
/* 52 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getKnownSymbol: () => (/* binding */ getKnownSymbol),
/* harmony export */   getSymbol: () => (/* binding */ getSymbol),
/* harmony export */   hasSymbol: () => (/* binding */ hasSymbol),
/* harmony export */   isSymbol: () => (/* binding */ isSymbol),
/* harmony export */   newSymbol: () => (/* binding */ newSymbol),
/* harmony export */   symbolFor: () => (/* binding */ symbolFor),
/* harmony export */   symbolKeyFor: () => (/* binding */ symbolKeyFor)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _polyfills_symbol__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(53);
/* harmony import */ var _well_known__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(54);
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13);
/* harmony import */ var _helpers_lazy__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11);
/* harmony import */ var _helpers_safe_lazy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10);
/* harmony import */ var _helpers_environment__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(7);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */







var _symbol;
var _symbolFor;
var _symbolKeyFor;
function _getSymbolValue(name) {
    return (0,_helpers_safe_lazy__WEBPACK_IMPORTED_MODULE_0__.safeGetLazy)(function () {
        return (_symbol.v ? _symbol.v[name] : _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE);
    }, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE);
}
/**
 * Checks if the type of value is a symbol.
 * @group Symbol
 * @param {any} value - Value to be checked.
 * @return {boolean} True if the value is a symbol, false otherwise.
 */
var isSymbol = (0,_helpers_base__WEBPACK_IMPORTED_MODULE_2__._createIs)("symbol");
/**
 * Helper to identify whether the runtime support the Symbols either via native or an installed polyfill
 * @group Symbol
 * @returns true if Symbol's are support otherwise false
 */
function hasSymbol() {
    return !!getSymbol();
}
/**
 * If Symbols are supported then attempt to return the named Symbol
 * @group Symbol
 * @returns The value of the named Symbol (if available)
 */
function getSymbol() {
    var resetCache = !_symbol || (_helpers_lazy__WEBPACK_IMPORTED_MODULE_3__._globalLazyTestHooks && _helpers_lazy__WEBPACK_IMPORTED_MODULE_3__._globalLazyTestHooks.lzy && !_symbol.b);
    resetCache && (_symbol = (0,_helpers_environment__WEBPACK_IMPORTED_MODULE_4__.lazySafeGetInst)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.SYMBOL));
    (!_symbolFor || resetCache) && (_symbolFor = _getSymbolValue("for"));
    (!_symbolKeyFor || resetCache) && (_symbolKeyFor = _getSymbolValue("keyFor"));
    return _symbol.v;
}
/**
 * If Symbols are supported then get the property of the global Symbol, if Symbol's are
 * not supported and noPoly is true it returns null. Used to access the well known symbols.
 * @group Symbol
 * @param name - The property name to return (if it exists) for Symbol
 * @param noPoly - Flag indicating whether to return a polyfill if symbols are not supported.
 * @returns The value of the property if present
 * @example
 * ```ts
 * // If Symbol is supported in the runtime
 * getKnownSymbol("toStringTag") === Symbol.toStringTag;                // true
 * getKnownSymbol(WellKnownSymbols.toStringTag) === Symbol.toStringTag; // true
 * ```
 */
function getKnownSymbol(name, noPoly) {
    var knownName = _well_known__WEBPACK_IMPORTED_MODULE_5__._wellKnownSymbolMap[name];
    // Cause lazy symbol to get initialized
    (!_symbol || (_helpers_lazy__WEBPACK_IMPORTED_MODULE_3__._globalLazyTestHooks.lzy && !_symbol.b)) && getSymbol();
    return _symbol.v ? _symbol.v[knownName || name] : (!noPoly ? (0,_polyfills_symbol__WEBPACK_IMPORTED_MODULE_6__.polyGetKnownSymbol)(name) : _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE);
}
/**
 * Returns a new unique Symbol value. If noPoly is true and symbols are not supported
 * then this will return null.
 * @group Symbol
 * @param description Description of the new Symbol object.
 * @param noPoly - Flag indicating whether to return a polyfil if symbols are not supported.
 * @returns The new symbol
 */
function newSymbol(description, noPoly) {
    // Cause lazy _symbol to get initialized
    (!_symbol || (_helpers_lazy__WEBPACK_IMPORTED_MODULE_3__._globalLazyTestHooks.lzy && !_symbol.b)) && getSymbol();
    return _symbol.v ? _symbol.v(description) : (!noPoly ? (0,_polyfills_symbol__WEBPACK_IMPORTED_MODULE_6__.polyNewSymbol)(description) : _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NULL_VALUE);
}
/**
 * Returns a Symbol object from the global symbol registry matching the given key if found.
 * Otherwise, returns a new symbol with this key. This will always return a polyfill if symbols
 * are not supported.
 * @group Symbol
 * @param key key to search for.
 */
function symbolFor(key) {
    // Cause lazy symbol to get initialized
    (!_symbolFor || (_helpers_lazy__WEBPACK_IMPORTED_MODULE_3__._globalLazyTestHooks.lzy && !_symbol.b)) && getSymbol();
    return (_symbolFor.v || _polyfills_symbol__WEBPACK_IMPORTED_MODULE_6__.polySymbolFor)(key);
}
/**
 * Returns a key from the global symbol registry matching the given Symbol if found.
 * Otherwise, returns a undefined. This will always attempt to lookup the polyfill
 * implementation if symbols are not supported
 * @group Symbol
 * @param sym Symbol to find the key for.
 */
function symbolKeyFor(sym) {
    // Cause lazy symbol to get initialized
    (!_symbolKeyFor || (_helpers_lazy__WEBPACK_IMPORTED_MODULE_3__._globalLazyTestHooks.lzy && !_symbol.b)) && getSymbol();
    return (_symbolKeyFor.v || _polyfills_symbol__WEBPACK_IMPORTED_MODULE_6__.polySymbolKeyFor)(sym);
}
//# sourceMappingURL=symbol.js.map

/***/ }),
/* 53 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   polyGetKnownSymbol: () => (/* binding */ polyGetKnownSymbol),
/* harmony export */   polyNewSymbol: () => (/* binding */ polyNewSymbol),
/* harmony export */   polySymbolFor: () => (/* binding */ polySymbolFor),
/* harmony export */   polySymbolKeyFor: () => (/* binding */ polySymbolKeyFor)
/* harmony export */ });
/* harmony import */ var _symbol_well_known__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(54);
/* harmony import */ var _helpers_throw__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(19);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8);
/* harmony import */ var _object_has_own__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16);
/* harmony import */ var _string_as_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(27);
/* harmony import */ var _internal_global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9);
/* harmony import */ var _string_starts_with__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(57);
/* harmony import */ var _object_object__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(35);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */








var UNIQUE_REGISTRY_ID = "_urid";
var _polySymbols;
function _globalSymbolRegistry() {
    if (!_polySymbols) {
        var gblCfg = (0,_internal_global__WEBPACK_IMPORTED_MODULE_0__._getGlobalConfig)();
        _polySymbols = gblCfg.gblSym = gblCfg.gblSym || { k: {}, s: {} };
    }
    return _polySymbols;
}
var _wellKnownSymbolCache = {};
/**
 * Returns a new (polyfill) Symbol object for the provided description that's guaranteed to be unique.
 * Symbols are often used to add unique property keys to an object that won't collide with keys any
 * other code might add to the object, and which are hidden from any mechanisms other code will
 * typically use to access the object. That enables a form of weak encapsulation, or a weak form of
 * information hiding.
 * @group Polyfill
 * @group Symbol
 * @param description - The description of the symbol
 * @returns A new polyfill version of a Symbol object
 */
function polyNewSymbol(description) {
    var theSymbol = {
        description: (0,_string_as_string__WEBPACK_IMPORTED_MODULE_1__.asString)(description),
        toString: function () { return _internal_constants__WEBPACK_IMPORTED_MODULE_2__.SYMBOL + "(" + description + ")"; }
    };
    // Tag the symbol so we know it a polyfill
    theSymbol[_internal_constants__WEBPACK_IMPORTED_MODULE_2__.POLYFILL_TAG] = true;
    return theSymbol;
}
/**
 * Returns a Symbol object from the global symbol registry matching the given key if found.
 * Otherwise, returns a new symbol with this key.
 * @group Polyfill
 * @group Symbol
 * @param key key to search for.
 */
function polySymbolFor(key) {
    var registry = _globalSymbolRegistry();
    if (!(0,_object_has_own__WEBPACK_IMPORTED_MODULE_3__.objHasOwn)(registry.k, key)) {
        var newSymbol_1 = polyNewSymbol(key);
        var regId_1 = (0,_object_object__WEBPACK_IMPORTED_MODULE_4__.objKeys)(registry.s).length;
        newSymbol_1[UNIQUE_REGISTRY_ID] = function () { return regId_1 + "_" + newSymbol_1.toString(); };
        registry.k[key] = newSymbol_1;
        registry.s[newSymbol_1[UNIQUE_REGISTRY_ID]()] = (0,_string_as_string__WEBPACK_IMPORTED_MODULE_1__.asString)(key);
    }
    return registry.k[key];
}
/**
 * Returns a key from the global symbol registry matching the given Symbol if found.
 * Otherwise, returns a undefined.
 * @group Polyfill
 * @group Symbol
 * @param sym Symbol to find the key for.
 */
function polySymbolKeyFor(sym) {
    if (!sym || !sym.toString || !(0,_string_starts_with__WEBPACK_IMPORTED_MODULE_5__.strStartsWith)(sym.toString(), _internal_constants__WEBPACK_IMPORTED_MODULE_2__.SYMBOL)) {
        (0,_helpers_throw__WEBPACK_IMPORTED_MODULE_6__.throwTypeError)(sym + " is not a symbol");
    }
    var regId = sym[_internal_constants__WEBPACK_IMPORTED_MODULE_2__.POLYFILL_TAG] && sym[UNIQUE_REGISTRY_ID] && sym[UNIQUE_REGISTRY_ID]();
    return regId ? _globalSymbolRegistry().s[regId] : undefined;
}
/**
 * Returns the polyfill version of a well-known global symbol, this will only return
 * known values.
 * @example
 * ```ts
 * // Always returns the polyfill version, even if Symbols are supported in the runtime
 * polyGetKnownSymbol("toStringTag") === polyGetKnownSymbol("toStringTag");                // true
 * polyGetKnownSymbol(WellKnownSymbols.toStringTag) === polyGetKnownSymbol("toStringTag"); // true
 * polyGetKnownSymbol("toStringTag") !== Symbol.toStringTag;                // true
 * polyGetKnownSymbol(WellKnownSymbols.toStringTag) !== Symbol.toStringTag; // true
 * polyGetKnownSymbol("toStringTag") !== polySymbolFor("toStringTag");      // true
 * polyGetKnownSymbol(WellKnownSymbols.toStringTag) !== polySymbolFor("toStringTag"); // true
 * polyGetKnownSymbol("toStringTag") !== polyNewSymbol("toStringTag");      // true
 * polyGetKnownSymbol(WellKnownSymbols.toStringTag) !== polyNewSymbol("toStringTag"); // true
 * ```
 * @group Polyfill
 * @group Symbol
 * @param name - The property name to return (if it exists) for Symbol
 * @returns The value of the property if present
 */
function polyGetKnownSymbol(name) {
    var result;
    var knownName = _symbol_well_known__WEBPACK_IMPORTED_MODULE_7__._wellKnownSymbolMap[name];
    if (knownName) {
        result = _wellKnownSymbolCache[knownName] = _wellKnownSymbolCache[knownName] || polyNewSymbol(_internal_constants__WEBPACK_IMPORTED_MODULE_2__.SYMBOL + "." + knownName);
    }
    return result;
}
//# sourceMappingURL=symbol.js.map

/***/ }),
/* 54 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _wellKnownSymbolMap: () => (/* binding */ _wellKnownSymbolMap)
/* harmony export */ });
/* harmony import */ var _helpers_enum__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

/**
 * @ignore
 * @internal
 */
var _wellKnownSymbolMap = (0,_helpers_enum__WEBPACK_IMPORTED_MODULE_0__.createEnumKeyMap)({
    asyncIterator: 0 /* WellKnownSymbols.asyncIterator */,
    hasInstance: 1 /* WellKnownSymbols.hasInstance */,
    isConcatSpreadable: 2 /* WellKnownSymbols.isConcatSpreadable */,
    iterator: 3 /* WellKnownSymbols.iterator */,
    match: 4 /* WellKnownSymbols.match */,
    matchAll: 5 /* WellKnownSymbols.matchAll */,
    replace: 6 /* WellKnownSymbols.replace */,
    search: 7 /* WellKnownSymbols.search */,
    species: 8 /* WellKnownSymbols.species */,
    split: 9 /* WellKnownSymbols.split */,
    toPrimitive: 10 /* WellKnownSymbols.toPrimitive */,
    toStringTag: 11 /* WellKnownSymbols.toStringTag */,
    unscopables: 12 /* WellKnownSymbols.unscopables */
});
//# sourceMappingURL=well_known.js.map

/***/ }),
/* 55 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createEnum: () => (/* binding */ createEnum),
/* harmony export */   createEnumKeyMap: () => (/* binding */ createEnumKeyMap),
/* harmony export */   createEnumValueMap: () => (/* binding */ createEnumValueMap),
/* harmony export */   createSimpleMap: () => (/* binding */ createSimpleMap),
/* harmony export */   createTypeMap: () => (/* binding */ createTypeMap)
/* harmony export */ });
/* harmony import */ var _internal_map__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(56);
/* harmony import */ var _object_for_each_key__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15);
/* harmony import */ var _object_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(35);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */



/**
 * Create a TypeScript style enum class which is a mapping that maps from the key -> value and the value -> key.
 * This is effectively the same as defining a non-constant enum, but this only repeats the "Name" of the enum value once.
 * @group Enum
 * @example
 * ```ts
 * const enum Animal {
 *    Dog = 0,
 *    Cat = 1,
 *    Butterfly = 2,
 *    Bear = 3
 * }
 * const Animals = createEnum<typeof Animal>({
 *    Dog: Animal.Dog,
 *    Cat: Animal.Cat,
 *    Butterfly: Animal.Butterfly,
 *    Bear: Animal.Bear
 * });
 * // You end up with an object that maps everything to the name
 * Animals.Dog === 0;           // true
 * Animals[0] === "Dog";        // true
 * Animals["Dog"] === 0;        // true
 * Animals.Cat === 1;           // true
 * Animals[1] === "Cat";        // true
 * Animals["Cat"] === 1;        // true
 * ```

 * @param values - The values to populate on the new object
 * @typeParam E - Identifies the const enum type being mapped
 * @returns A new frozen (immutable) object which looks and acts like a TypeScript Enum class.
 */
function createEnum(values) {
    return (0,_internal_map__WEBPACK_IMPORTED_MODULE_0__._createKeyValueMap)(values, 1 /* eMapValues.Value */, 0 /* eMapValues.Key */, _object_object__WEBPACK_IMPORTED_MODULE_1__.objDeepFreeze);
}
/**
 * Create a map object which contains both the property key and value which both map to the key,
 * E[key] => key and E[value] => key.
 * @group Enum
 * @example
 * ```ts
 * const enum Animal {
 *    Dog = 0,
 *    Cat = 1,
 *    Butterfly = 2,
 *    Bear = 3
 * }
 * const animalMap = createEnumKeyMap<typeof Animal>({
 *    Dog: Animal.Dog,
 *    Cat: Animal.Cat,
 *    Butterfly: Animal.Butterfly,
 *    Bear: Animal.Bear
 * });
 * // You end up with an object that maps everything to the name
 * animalMap.Dog === "Dog";         // true
 * animalMap[0] === "Dog";          // true
 * animalMap["Dog"] === "Dog";      // true
 * animalMap.Cat === "Cat";         // true
 * animalMap[1] === "Cat";          // true
 * animalMap["Cat"] === "Cat";      // true
 * // Helper function to always return the "Name" of the type of animal
 * function getAnimalType(type: string | number | Animal) {
 *     return animalMap[type];
 * }
 * ```
 * @param values - The values to populate on the new object
 * @typeParam E - Identifies the const enum type being mapped
 * @returns A new frozen (immutable) object which contains a property for each key and value that returns the value.
 */
function createEnumKeyMap(values) {
    return (0,_internal_map__WEBPACK_IMPORTED_MODULE_0__._createKeyValueMap)(values, 0 /* eMapValues.Key */, 0 /* eMapValues.Key */, _object_object__WEBPACK_IMPORTED_MODULE_1__.objDeepFreeze);
}
/**
 * Create a map object which contains both the perperty key and value which both map to the resulting value,
 * E[key] => value and E[value] => value.
 * @group Enum
 * @example
 * ```ts
 * const enum Animal {
 *    Dog = 0,
 *    Cat = 1,
 *    Butterfly = 2,
 *    Bear = 3
 * }
 * const animalMap = createEnumValueMap<typeof Animal>({
 *    Dog: Animal.Dog,
 *    Cat: Animal.Cat,
 *    Butterfly: Animal.Butterfly,
 *    Bear: Animal.Bear
 * });
 * // You end up with an object that maps everything to the name
 * animalMap.Dog === 0;     // true
 * animalMap[0] === 0;      // true
 * animalMap["Dog"] === 0;  // true
 * animalMap.Cat === 1;     // true
 * animalMap[1] === 1;      // true
 * animalMap["Cat"] === 1;  // true
 *
 * // Helper function to always return the "Name" of the type of animal
 * function getAnimalValue(type: string | number | Animal) {
 *     return animalMap[type];
 * }
 * ```

 * @param values - The values to populate on the new object
 * @typeParam E - Identifies the const enum type being mapped
 * @returns A new frozen (immutable) object which contains a property for each key and value that returns the value.
 */
function createEnumValueMap(values) {
    return (0,_internal_map__WEBPACK_IMPORTED_MODULE_0__._createKeyValueMap)(values, 1 /* eMapValues.Value */, 1 /* eMapValues.Value */, _object_object__WEBPACK_IMPORTED_MODULE_1__.objDeepFreeze);
}
/**
 * Create a map object which contains both the perperty key and value which both map to the requested
 * generic mapValue with a type of V, E[key] => mapValue and E[value] => mapValue.
 * @group Enum
 * @example
 * ```ts
 * const enum Animal {
 *    Dog = 0,
 *    Cat = 1,
 *    Butterfly = 2,
 *    Bear = 3
 * };
 * // Creates a simple mapping to a string value
 * const animalFamilyMap = createValueMap<typeof Animal, string>({
 *    Dog: [ Animal.Dog, "Canidae"],
 *    Cat: [ Animal.Cat, "Felidae"],
 *    Butterfly: [ Animal.Butterfly, "Papilionidae"],
 *    Bear: [ Animal.Bear, "Ursidae"]
 * });
 * // You end up with an object that maps everything to the name
 * animalMap.Dog === "Canidae";     // true with typeof animalMap.Dog is "string"
 * animalMap[0] === "Canidae";      // true with typeof animalMap[0] is "string"
 * animalMap["Dog"] === "Canidae";  // true with typeof animalMap["Dog"] is "string"
 * animalMap.Cat === "Felidae";     // true with typeof animalMap.Cat is "string"
 * animalMap[1] === "Felidae";      // true with typeof animalMap[1] is "string"
 * animalMap["Cat"] === "Felidae";  // true with typeof animalMap["Cat"] is "string"
 * ```
 * @param values - The values to populate on the new object
 * @typeParam E - Identifies the const enum type (eg. typeof Animal);
 * @typeParam V - Identifies the type of the mapping `string`; `number`; etc is not restructed to primitive types.
 * @returns A new frozen (immutable) object which contains a property for each key and value that returns the defiend mapped value.
 */
function createSimpleMap(values) {
    var mapClass = {};
    (0,_object_for_each_key__WEBPACK_IMPORTED_MODULE_2__.objForEachKey)(values, function (key, value) {
        mapClass[key] = value[1];
        mapClass[value[0]] = value[1];
    });
    return (0,_object_object__WEBPACK_IMPORTED_MODULE_1__.objDeepFreeze)(mapClass);
}
/**
 * Create a strongly types map object which contains both the perperty key and value which both map
 * to the requested mapValue,
 * E[key] => mapValue and E[value] => mapValue.
 * - E = the const enum type (typeof Animal);
 * - V = Identifies the valid values for the keys, this should include both the enum numeric and string key of the type. The
 * resulting "Value" of each entry identifies the valid values withing the assignments.
 * @group Enum
 * @example
 * ```ts
 * // Create a strongly types map
 * const animalFamilyMap = createTypeMap<typeof Animal, {
 *     // Defined the enum lookups
 *     [Animal.Dog]: "Canidae",
 *     [Animal.Cat]: "Felidae",
 *     [Animal.Butterfly]: "Papilionidae",
 *     [Animal.Bear]: "Ursidae",
 *     // Defined Named reference
 *     Dog: "Canidae",
 *     Cat: "Felidae",
 *     Butterfly: "Papilionidae",
 *     Bear: "Ursidae",
 * }>({
 *     Dog: [ Animal.Dog, "Canidae"],
 *     Cat: [ Animal.Cat, "Felidae"],
 *     Butterfly: [ Animal.Butterfly, "Papilionidae"],
 *     Bear: [ Animal.Bear, "Ursidae"]
 * });
 * // You end up with a strongly types result for each value
 * animalMap.Dog === "Canidae";     // true with typeof animalMap.Dog is (const) "Canidae"
 * animalMap[0] === "Canidae";      // true with typeof animalMap[0] is "Canidae"
 * animalMap["Dog"] === "Canidae";  // true with typeof animalMap["Dog"] is "Canidae"
 * animalMap.Cat === "Felidae";     // true with typeof animalMap.Cat is "Felidae"
 * animalMap[1] === "Felidae";      // true with typeof animalMap[1] is "Felidae"
 * animalMap["Cat"] === "Felidae";  // true with typeof animalMap["Cat"] is "Felidae"
 *
 * or using an interface to define the direct string mappings
 *
 * interface IAnimalFamilyMap {
 *     Dog: "Canidae",
 *     Cat: "Felidae",
 *     Butterfly: "Papilionidae",
 *     Bear: "Ursidae"
 * }
 *
 * // Create a strongly types map
 * const animalFamilyMap = createTypeMap<typeof Animal, IAnimalFamilyMap & {
 *     // Defined the enum lookups
 *     [Animal.Dog]: "Canidae",
 *     [Animal.Cat]: "Felidae",
 *     [Animal.Butterfly]: "Papilionidae",
 *     [Animal.Bear]: "Ursidae"
 * }>({
 *     Dog: [ Animal.Dog, "Canidae"],
 *     Cat: [ Animal.Cat, "Felidae"],
 *     Butterfly: [ Animal.Butterfly, "Papilionidae"],
 *     Bear: [ Animal.Bear, "Ursidae"]
 * });
 *
 * // You also end up with a strongly types result for each value
 * animalMap.Dog === "Canidae";     // true with typeof animalMap.Dog is (const) "Canidae"
 * animalMap[0] === "Canidae";      // true with typeof animalMap[0] is "Canidae"
 * animalMap["Dog"] === "Canidae";  // true with typeof animalMap["Dog"] is "Canidae"
 * animalMap.Cat === "Felidae";     // true with typeof animalMap.Cat is "Felidae"
 * animalMap[1] === "Felidae";      // true with typeof animalMap[1] is "Felidae"
 * animalMap["Cat"] === "Felidae";  // true with typeof animalMap["Cat"] is "Felidae"
 * ```
 * @param values - The values to populate on the new object
 * @typeParam E - Identifies the enum type
 * @typeParam T - Identifies the return type that is being created via the mapping.
 * @returns A new frozen (immutable) object which contains a property for each key and value that returns the defined mapped value.
 */
function createTypeMap(values) {
    return createSimpleMap(values);
}
//# sourceMappingURL=enum.js.map

/***/ }),
/* 56 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _createKeyValueMap: () => (/* binding */ _createKeyValueMap)
/* harmony export */ });
/* harmony import */ var _object_for_each_key__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(15);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

/**
 * @internal
 * @ignore
 * Internal Helper function to create a key and value mapped representation of the values
 * @param values - The source values
 * @param keyType - Identifies the value to populate against the key
 * @param valueType - Identifies the value to populate against the value
 * @param completeFn - The function to call to complete the map (used to freeze the instance)
 * @returns
 */
function _createKeyValueMap(values, keyType, valueType, completeFn) {
    var theMap = {};
    (0,_object_for_each_key__WEBPACK_IMPORTED_MODULE_0__.objForEachKey)(values, function (key, value) {
        theMap[key] = keyType ? value : key;
        theMap[value] = valueType ? value : key;
    });
    return completeFn(theMap);
}
//# sourceMappingURL=map.js.map

/***/ }),
/* 57 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   polyStrStartsWith: () => (/* binding */ polyStrStartsWith),
/* harmony export */   strStartsWith: () => (/* binding */ strStartsWith)
/* harmony export */ });
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13);
/* harmony import */ var _helpers_diagnostics__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26);
/* harmony import */ var _helpers_throw__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(19);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25);
/* harmony import */ var _as_string__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(27);
/* harmony import */ var _substring__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(28);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */







/**
 * This method lets you determine whether or not a string begins with another string. This method is case-sensitive.
 * @group String
 * @param value - The value to be checked
 * @param searchString - The characters to be searched for at the start of the string
 * @param position - [Optional] The position in this string at which to begin searching for `searchString`.
 * Defaults to 0
 * @returns `true` if the given characters are found at the beginning of the string; otherwise, `false`.
 */
var strStartsWith = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunctionWithPoly)("startsWith", _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto, polyStrStartsWith);
/**
 * This method lets you determine whether or not a string begins with another string. This method is case-sensitive.
 * @group Polyfill
 * @group String
 * @param value - The value to be checked
 * @param searchString - The characters to be searched for at the start of the string
 * @param position - [Optional] The position in this string at which to begin searching for `searchString`.
 * Defaults to 0
 * @returns `true` if the given characters are found at the beginning of the string; otherwise, `false`.
 */
function polyStrStartsWith(value, searchString, position) {
    if (!(0,_helpers_base__WEBPACK_IMPORTED_MODULE_2__.isString)(value)) {
        (0,_helpers_throw__WEBPACK_IMPORTED_MODULE_3__.throwTypeError)("'" + (0,_helpers_diagnostics__WEBPACK_IMPORTED_MODULE_4__.dumpObj)(value) + "' is not a string");
    }
    var searchValue = (0,_helpers_base__WEBPACK_IMPORTED_MODULE_2__.isString)(searchString) ? searchString : (0,_as_string__WEBPACK_IMPORTED_MODULE_5__.asString)(searchString);
    var chkLen = searchValue[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.LENGTH];
    var pos = position > 0 ? position : 0;
    return (0,_substring__WEBPACK_IMPORTED_MODULE_6__.strSubstring)(value, pos, pos + chkLen) === searchValue;
}
//# sourceMappingURL=starts_with.js.map

/***/ }),
/* 58 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   arrIndexOf: () => (/* binding */ arrIndexOf),
/* harmony export */   arrLastIndexOf: () => (/* binding */ arrLastIndexOf)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * The arrIndexOf() method returns the first index at which a given element can be found in the array,
 * or -1 if it is not present.
 * `arrIndexOf()` compares searchElement to elements of the Array using strict equality (the same
 * method used by the === or triple-equals operator).
 * @group Array
 * @group ArrayLike
 * @typeParam T - Identifies the type of array elements
 * @param theArray - The array or array like object of elements to be searched.
 * @param searchElement - The element to locate in the array.
 * @param fromIndex - The index to start the search at. If the index is greater than or equal to
 * the array's length, -1 is returned, which means the array will not be searched. If the provided
 * index value is a negative number, it is taken as the offset from the end of the array.
 * Note: if the provided index is negative, the array is still searched from front to back. If the
 * provided index is 0, then the whole array will be searched. Default: 0 (entire array is searched).
 * @return The first index of the element in the array; -1 if not found.
 * @example
 * ```ts
 * const array = [2, 9, 9];
 * arrIndexOf(array, 2);     // 0
 * arrIndexOf(array, 7);     // -1
 * arrIndexOf(array, 9, 2);  // 2
 * arrIndexOf(array, 2, -1); // -1
 * arrIndexOf(array, 2, -3); // 0
 *
 * let indices: number[] = [];
 * const array = ['a', 'b', 'a', 'c', 'a', 'd'];
 * const element = 'a';
 * let idx = arrIndexOf(array, element);
 * while (idx !== -1) {
 *   indices.push(idx);
 *   idx = arrIndexOf(array, element, idx + 1);
 * }
 * console.log(indices);
 * // [0, 2, 4]
 *
 * function updateVegetablesCollection (veggies, veggie) {
 *     if (arrIndexOf(veggies, veggie) === -1) {
 *         veggies.push(veggie);
 *         console.log('New veggies collection is : ' + veggies);
 *     } else {
 *         console.log(veggie + ' already exists in the veggies collection.');
 *     }
 * }
 *
 * let veggies = ['potato', 'tomato', 'chillies', 'green-pepper'];
 *
 * updateVegetablesCollection(veggies, 'spinach');
 * // New veggies collection is : potato,tomato,chillies,green-pepper,spinach
 * updateVegetablesCollection(veggies, 'spinach');
 * // spinach already exists in the veggies collection.
 *
 * // Array Like
 * let arrayLike = {
 *   length: 3,
 *   0: "potato",
 *   1: "tomato",
 *   2: "chillies",
 *   3: "green-pepper"  // Not checked as index is > length
 * };
 *
 * arrIndexOf(arrayLike, "potato"); // 0
 * arrIndexOf(arrayLike, "tomato"); // 1
 * arrIndexOf(arrayLike, "chillies"); 2
 * arrIndexOf(arrayLike, "green-pepper"); // -1
 * ```
 */
var arrIndexOf = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunction)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.INDEX_OF, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.ArrProto);
/**
 * The arrLastIndexOf() method returns the last index at which a given element can be found in the array,
 * or -1 if it is not present.
 * `arrLastIndexOf()` compares searchElement to elements of the Array using strict equality (the same
 * method used by the === or triple-equals operator). [NaN](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NaN)
 * values are never compared as equal, so arrLastIndexOf() always returns -1 when searchElement is NaN.
 *
 * The arrLastIndexOf() method skips empty slots in sparse arrays.
 *
 * The arrLastIndexOf() method is generic. It only expects the this value to have a length property and integer-keyed properties.
 *
 * @since 0.8.0
 * @group Array
 * @group ArrayLike
 * @typeParam T - Identifies the type of array elements
 * @param theArray - The array or array like object of elements to be searched.
 * @param searchElement - The element to locate in the array.
 * @param fromIndex - Zero-based index at which to start searching backwards, converted to an integer.
 * - Negative index counts back from the end of the array — if fromIndex < 0, fromIndex + array.length is used.
 * - If fromIndex < -array.length, the array is not searched and -1 is returned. You can think of it conceptually
 * as starting at a nonexistent position before the beginning of the array and going backwards from there. There
 * are no array elements on the way, so searchElement is never found.
 * - If fromIndex >= array.length or fromIndex is omitted, array.length - 1 is used, causing the entire array to
 * be searched. You can think of it conceptually as starting at a nonexistent position beyond the end of the array and going backwards from there. It eventually reaches the real end position of the array, at which point it starts searching backwards through the actual array elements.
 * @return The first index of the element in the array; -1 if not found.
 * @example
 * ```ts
 * const numbers = [2, 5, 9, 2];
 * arrLastIndexOf(numbers, 2); // 3
 * arrLastIndexOf(numbers, 7); // -1
 * arrLastIndexOf(numbers, 2, 3); // 3
 * arrLastIndexOf(numbers, 2, 2); // 0
 * arrLastIndexOf(numbers, 2, -2); // 0
 * arrLastIndexOf(numbers, 2, -1); // 3
 *
 * let indices: number[] = [];
 * const array = ["a", "b", "a", "c", "a", "d"];
 * const element = "a";
 * let idx = arrLastIndexOf(array, element);
 * while (idx !== -1) {
 *   indices.push(idx);
 *   idx = arrLastIndexOf(array, element, idx ? idx - 1 : -(array.length + 1));
 * }
 * console.log(indices);
 * // [4, 2, 0]
 *
 * function updateVegetablesCollection (veggies, veggie) {
 *     if (arrLastIndexOf(veggies, veggie) === -1) {
 *         veggies.push(veggie);
 *         console.log('New veggies collection is : ' + veggies);
 *     } else {
 *         console.log(veggie + ' already exists in the veggies collection.');
 *     }
 * }
 *
 * let veggies = ['potato', 'tomato', 'chillies', 'green-pepper'];
 *
 * updateVegetablesCollection(veggies, 'spinach');
 * // New veggies collection is : potato,tomato,chillies,green-pepper,spinach
 * updateVegetablesCollection(veggies, 'spinach');
 * // spinach already exists in the veggies collection.
 *
 * // Array Like
 * let arrayLike = {
 *   length: 3,
 *   0: "potato",
 *   1: "tomato",
 *   2: "chillies",
 *   3: "green-pepper"  // Not checked as index is > length
 * };
 *
 * arrLastIndexOf(arrayLike, "potato"); // 0
 * arrLastIndexOf(arrayLike, "tomato"); // 1
 * arrLastIndexOf(arrayLike, "chillies"); 2
 * arrLastIndexOf(arrayLike, "green-pepper"); // -1
 * ```
 */
var arrLastIndexOf = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunction)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.LAST_INDEX_OF, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.ArrProto);
//# sourceMappingURL=indexOf.js.map

/***/ }),
/* 59 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _createState: () => (/* binding */ _createState)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(52);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(26);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(65);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(58);
/* harmony import */ var _JavaScriptSDK_AggregationError__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(60);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(32);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





var symPrefix = "[[ai_";
var symPostfix = "]]";
function _createState(cfgHandler) {
    var _a;
    var dynamicPropertySymbol = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.newSymbol)(symPrefix + "get" + cfgHandler.uid + symPostfix);
    var dynamicPropertyReadOnly = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.newSymbol)(symPrefix + "ro" + cfgHandler.uid + symPostfix);
    var dynamicPropertyReferenced = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.newSymbol)(symPrefix + "rf" + cfgHandler.uid + symPostfix);
    var dynamicPropertyBlockValue = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.newSymbol)(symPrefix + "blkVal" + cfgHandler.uid + symPostfix);
    var dynamicPropertyDetail = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.newSymbol)(symPrefix + "dtl" + cfgHandler.uid + symPostfix);
    var _waitingHandlers = null;
    var _watcherTimer = null;
    var theState;
    function _useHandler(activeHandler, callback) {
        var prevWatcher = theState.act;
        try {
            theState.act = activeHandler;
            if (activeHandler && activeHandler[dynamicPropertyDetail]) {
                // Clear out the previously tracked details for this handler, so that access are re-evaluated
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(activeHandler[dynamicPropertyDetail], function (detail) {
                    detail.clr(activeHandler);
                });
                activeHandler[dynamicPropertyDetail] = [];
            }
            callback({
                cfg: cfgHandler.cfg,
                set: cfgHandler.set.bind(cfgHandler),
                setDf: cfgHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_SET_DF /* @min:%2esetDf */].bind(cfgHandler),
                ref: cfgHandler.ref.bind(cfgHandler),
                rdOnly: cfgHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_RD_ONLY /* @min:%2erdOnly */].bind(cfgHandler)
            });
        }
        catch (e) {
            var logger = cfgHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LOGGER /* @min:%2elogger */];
            if (logger) {
                // Don't let one individual failure break everyone
                logger[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_THROW_INTERNAL /* @min:%2ethrowInternal */](1 /* eLoggingSeverity.CRITICAL */, 107 /* _eInternalMessageId.ConfigWatcherException */, (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.dumpObj)(e));
            }
            // Re-throw the exception so that any true "error" is reported back to the called
            throw e;
        }
        finally {
            theState.act = prevWatcher || null;
        }
    }
    function _notifyWatchers() {
        if (_waitingHandlers) {
            var notifyHandlers = _waitingHandlers;
            _waitingHandlers = null;
            // Stop any timer as we are running them now anyway
            _watcherTimer && _watcherTimer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_CANCEL /* @min:%2ecancel */]();
            _watcherTimer = null;
            var watcherFailures_1 = [];
            // Now run the handlers
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(notifyHandlers, function (handler) {
                if (handler) {
                    if (handler[dynamicPropertyDetail]) {
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(handler[dynamicPropertyDetail], function (detail) {
                            // Clear out this handler from  previously tracked details, so that access are re-evaluated
                            detail.clr(handler);
                        });
                        handler[dynamicPropertyDetail] = null;
                    }
                    // The handler may have self removed as part of another handler so re-check
                    if (handler.fn) {
                        try {
                            _useHandler(handler, handler.fn);
                        }
                        catch (e) {
                            // Don't let a single failing watcher cause other watches to fail
                            watcherFailures_1[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](e);
                        }
                    }
                }
            });
            // During notification we may have had additional updates -- so notify those updates as well
            if (_waitingHandlers) {
                try {
                    _notifyWatchers();
                }
                catch (e) {
                    watcherFailures_1[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](e);
                }
            }
            if (watcherFailures_1[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] > 0) {
                (0,_JavaScriptSDK_AggregationError__WEBPACK_IMPORTED_MODULE_4__.throwAggregationError)("Watcher error(s): ", watcherFailures_1);
            }
        }
    }
    function _addWatcher(detail) {
        if (detail && detail.h[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] > 0) {
            if (!_waitingHandlers) {
                _waitingHandlers = [];
            }
            if (!_watcherTimer) {
                _watcherTimer = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.scheduleTimeout)(function () {
                    _watcherTimer = null;
                    _notifyWatchers();
                }, 0);
            }
            // Add all of the handlers for this detail (if not already present) - using normal for-loop for performance
            for (var idx = 0; idx < detail.h[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */]; idx++) {
                var handler = detail.h[idx];
                // Add this handler to the collection of handlers to re-execute
                if (handler && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.arrIndexOf)(_waitingHandlers, handler) === -1) {
                    _waitingHandlers[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](handler);
                }
            }
        }
    }
    function _trackHandler(handler, detail) {
        if (handler) {
            var details = handler[dynamicPropertyDetail] = handler[dynamicPropertyDetail] || [];
            if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.arrIndexOf)(details, detail) === -1) {
                // If this detail is not already listed as tracked then add it so that we re-evaluate it's usage
                details[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](detail);
            }
        }
    }
    theState = (_a = {
            prop: dynamicPropertySymbol,
            ro: dynamicPropertyReadOnly,
            rf: dynamicPropertyReferenced
        },
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_BLK_VAL /* @min:blkVal */] = dynamicPropertyBlockValue,
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_HDLR /* @min:hdlr */] = cfgHandler,
        _a.add = _addWatcher,
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_NOTIFY /* @min:notify */] = _notifyWatchers,
        _a.use = _useHandler,
        _a.trk = _trackHandler,
        _a);
    return theState;
}
//# sourceMappingURL=DynamicState.js.map

/***/ }),
/* 60 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   throwAggregationError: () => (/* binding */ throwAggregationError)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(37);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(26);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(32);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */




var aggregationErrorType;
/**
 * Throws an Aggregation Error which includes all of the errors that led to this error occurring
 * @param message - The message describing the aggregation error (the sourceError details are added to this)
 * @param sourceErrors - An array of the errors that caused this situation
 */
function throwAggregationError(message, sourceErrors) {
    if (!aggregationErrorType) {
        aggregationErrorType = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.createCustomError)("AggregationError", function (self, args) {
            if (args[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 1) {
                // Save the provided errors
                self.errors = args[1];
            }
        });
    }
    var theMessage = message || "One or more errors occurred.";
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.arrForEach)(sourceErrors, function (srcError, idx) {
        theMessage += "\n".concat(idx, " > ").concat((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.dumpObj)(srcError));
    });
    throw new aggregationErrorType(theMessage, sourceErrors || []);
}
//# sourceMappingURL=AggregationError.js.map

/***/ }),
/* 61 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createCustomError: () => (/* binding */ createCustomError),
/* harmony export */   throwUnsupported: () => (/* binding */ throwUnsupported)
/* harmony export */ });
/* harmony import */ var _array_slice__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(62);
/* harmony import */ var _funcs_fnApply__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(63);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _object_create__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45);
/* harmony import */ var _object_define__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12);
/* harmony import */ var _object_object__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(35);
/* harmony import */ var _object_set_proto__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */







/**
 * @internal
 * @ignore
 */
var _createCustomError = function (name, d, b) {
    _safeDefineName(d, name);
    d = (0,_object_set_proto__WEBPACK_IMPORTED_MODULE_0__.objSetPrototypeOf)(d, b);
    function __() {
        this.constructor = d;
        _safeDefineName(this, name);
    }
    d[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.PROTOTYPE] = b === _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NULL_VALUE ? (0,_object_create__WEBPACK_IMPORTED_MODULE_2__.objCreate)(b) : (__[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.PROTOTYPE] = b[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.PROTOTYPE], new __());
    return d;
};
var _safeSetName = function (baseClass, name) {
    try {
        name && (baseClass[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.NAME] = name);
        //name && (baseClass[PROTOTYPE][NAME] = name);
    }
    catch (e) {
        // Do nothing
    }
};
var _safeDefineName = function (target, name) {
    try {
        (0,_object_define__WEBPACK_IMPORTED_MODULE_3__.objDefine)(target, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NAME, { v: name, c: true, e: false });
    }
    catch (e) {
        // Do nothing
    }
};
/**
 * Create a Custom Error class which may be used to throw custom errors.
 * @group Error
 * @param name - The name of the Custom Error
 * @param constructCb - [Optional] An optional callback function to call when a
 * new Customer Error instance is being created.
 * @param errorBase - [Optional] (since v0.9.6) The error class to extend for this class, defaults to Error.
 * @returns A new Error `class`
 * @example
 * ```ts
 * import { createCustomError, isError } from "@nevware21/ts-utils";
 *
 * // For an error that just contains a message
 * let myCustomErrorError = createCustomError("MessageError");
 *
 * try {
 *     throw new myCustomErrorError("Error Message!");
 * } catch(e) {
 *      // e.name === MessageError
 *      // isError(e) === true;
 *      // Object.prototype.toString.call(e) === "[object Error]";
 * }
 *
 * // Or a more complex error object
 * interface MyCriticalErrorConstructor extends CustomErrorConstructor {
 *     new(message: string, file: string, line: number, col: number): MyCriticalError;
 *     (message: string, file: string, line: number, col: number): MyCriticalError;
 * }
 *
 * interface MyCriticalError extends Error {
 *     readonly errorId: number;
 *     readonly args: any[];        // Holds all of the arguments passed during construction
 * }
 *
 * let _totalErrors = 0;
 * let myCustomError = createCustomError<MyCriticalErrorConstructor>("CriticalError", (self, args) => {
 *     _totalErrors++;
 *     self.errorId = _totalErrors;
 *     self.args = args;
 * });
 *
 * try {
 *     throw new myCustomError("Not Again!");
 * } catch(e) {
 *      // e.name === CriticalError
 *      // isError(e) === true;
 *      // Object.prototype.toString.call(e) === "[object Error]";
 * }
 *
 * // ----------------------------------------------------------
 * // Extending another custom error class
 * // ----------------------------------------------------------
 *
 * let AppError = createCustomError("ApplicationError");
 * let theAppError = new appError();
 *
 * isError(theAppError);                    // true
 * theAppError instanceof Error;            // true
 * theAppError instanceof AppError;         // true
 *
 * let StartupError = createCustomError("StartupError", null, AppError);
 * let theStartupError = new StartupError();
 *
 * isError(theStartupError);                // true
 * theStartupError instanceof Error;        // true
 * theStartupError instanceof AppError;     // true
 * theStartupError instanceof StartupError; // true
 * ```
 */
function createCustomError(name, constructCb, errorBase) {
    var theBaseClass = errorBase || Error;
    var orgName = theBaseClass[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.PROTOTYPE][_internal_constants__WEBPACK_IMPORTED_MODULE_1__.NAME];
    var captureFn = Error.captureStackTrace;
    return _createCustomError(name, function () {
        var _this = this;
        try {
            _safeSetName(theBaseClass, name);
            var _self = (0,_funcs_fnApply__WEBPACK_IMPORTED_MODULE_4__.fnApply)(theBaseClass, _this, (0,_array_slice__WEBPACK_IMPORTED_MODULE_5__.arrSlice)(arguments)) || _this;
            if (_self !== _this) {
                // Looks like runtime error constructor reset the prototype chain, so restore it
                var orgProto = (0,_object_object__WEBPACK_IMPORTED_MODULE_6__.objGetPrototypeOf)(_this);
                if (orgProto !== (0,_object_object__WEBPACK_IMPORTED_MODULE_6__.objGetPrototypeOf)(_self)) {
                    (0,_object_set_proto__WEBPACK_IMPORTED_MODULE_0__.objSetPrototypeOf)(_self, orgProto);
                }
            }
            // Make sure we only capture our stack details
            captureFn && captureFn(_self, _this[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.CONSTRUCTOR]);
            // Run the provided construction function
            constructCb && constructCb(_self, arguments);
            return _self;
        }
        finally {
            _safeSetName(theBaseClass, orgName);
        }
    }, theBaseClass);
}
/**
 * @internal
 * @ignore
 */
var _unsupportedError;
/**
 * Throw a custom `UnsupportedError` Error instance with the given message.
 * @group Error
 * @param message - The message to include in the exception
 * @example
 * ```ts
 * import { throwUnsupported } from "@nevware21/ts-utils";
 *
 * if (!window) {
 *     throwUnsupported("A window is needed for this operation");
 * }
 * ```
 */
function throwUnsupported(message) {
    if (!_unsupportedError) {
        // Lazily create the class
        _unsupportedError = createCustomError("UnsupportedError");
    }
    throw new _unsupportedError(message);
}
//# sourceMappingURL=customError.js.map

/***/ }),
/* 62 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   arrSlice: () => (/* binding */ arrSlice)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * The arrSlice() method returns a shallow copy of a portion of an array into a new array object
 * selected from start to end (end not included) where start and end represent the index of items
 * in that array. The original array will not be modified.
 *
 * The `arrSlice()` method is a copying method. It does not alter this but instead returns a shallow
 * copy that contains some of the same elements as the ones from the original array.
 *
 * The `arrSlice()` method preserves empty slots. If the sliced portion is sparse, the returned arra
 * is sparse as well.
 *
 * The `arrSlice()` method is generic. It only expects the this value to have a length property and
 * integer-keyed properties.
 *
 * For both start and end, a negative index can be used to indicate an offset from the end of the array.
 * For example, -2 refers to the second to last element of the array.
 * @since 0.9.3
 * @group Array
 * @group ArrayLike
 * @param start Zero-based index at which to start extraction, converted to an integer.
 * - Negative index counts back from the end of the array — if start < 0, start + array.length is used.
 * - If start < -array.length or start is omitted, 0 is used.
 * - If start >= array.length, nothing is extracted.
 * @param end Zero-based index at which to end extraction, converted to an integer. slice() extracts
 * up to but not including end.
 * - Negative index counts back from the end of the array — if end < 0, end + array.length is used.
 * - If end < -array.length, 0 is used.
 * - If end >= array.length or end is omitted, array.length is used, causing all elements until the
 * end to be extracted.
 * - If end is positioned before or at start after normalization, nothing is extracted.
 * @example
 * ```ts
 * const lyrics = ["Hello", "Darkness", "my", "old", "friend.", "I've", "come", "to", "talk" ];
 *
 * arrSlice(lyrics);        // [ "Hello", "Darkness", "my", "old", "friend.", "I've", "come", "to", "talk" ]
 * arrSlice(lyrics, 1, 3);  // [ "Darkness", "my" ]
 * arrSlicw(lyrics, 2);     // [ "my", "old", "friend.", "I've", "come", "to", "talk" ]
 * arrSlice(lyrics, 2, 4);  // [ "my", "old" ]
 * arrSlice(lyrics, 1, 5);  // [ "Darkness", "my", "old", "friend." ]
 * arrSlice(lyrics, -2);    // [ "to", "talk" ]
 * arrSlice(lyrics, 2, -1); // [ "my", "old", "friend.", "I've", "come", "to" ]
 * ```
 */
var arrSlice = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunction)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.SLICE, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.ArrProto);
//# sourceMappingURL=slice.js.map

/***/ }),
/* 63 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fnApply: () => (/* binding */ fnApply)
/* harmony export */ });
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2023 Nevware21
 * Licensed under the MIT license.
 */

/**
 * The `fnApply` function calls the specified `fn` function with the given `thisArg` as the `this` value,
 * and the optional `argArray` arguments provided as an array (or an Array-Like Object).
 *
 * Normally, when calling a function, the value of `this` inside the function is the object that the
 * function was accessed on. With `fnApply()`, you can assign an arbitrary value as this when calling an
 * existing function, without first attaching the function to the object as a property. This allows you
 * to use methods of one object as generic utility functions.
 *
 * You can also use any kind of object which is ArrayLike as the second parameter. In practice, this means
 * that it needs to have a length property, and integer ("index") properties in the range (0..length - 1).
 * For example, you could use a NodeList, or a custom object like `{ 'length': 2, '0': 'eat', '1': 'bananas' }`.
 * You can also use `arguments`.
 *
 * @since 0.9.8
 * @group Function
 *
 * @param fn - The function to be called
 * @param thisArg - The value of `this` provided for the call to `fn`. If the function is not in strict mode,
 * `null` and `undefined` will be replaced with the global object, and primitive values will be converted to objects.
 * @param argArray - An array-like object, specifying the arguments with which `fn` should be called, or `null` or
 * `undefined` if no arguments should be provided to the function.
 * @returns The result of calling the function with the specified `this` value and arguments.
 * @example
 * ```ts
 * // min / max number in an array
 * let max = fnApply(Math.max, null, [ 21, 42, 84, 168, 7, 3 ]);
 * // 168
 *
 * let min = fnApply(Math.min, null, [ 21, 42, 84, 168, 7, 3 ]);
 * // 3
 *
 * const module1 = {
 *     prefix: "Hello",
 *     x: 21,
 *     getX() {
 *         return this.x;
 *     },
 *     log(value: string) {
 *         return this.prefix + " " + value + " : " + this.x
 *     }
 * };
 *
 * // The 'this' parameter of 'getX' is bound to 'module'.
 * module1.getX(); // 21
 * module1.log("Darkness"); // Hello Darkness : 21
 *
 * // Create a new function 'boundGetX' with the 'this' parameter bound to 'module'.
 * let module2 = {
 *     prefix: "my",
 *     x: 42
 * };
 *
 * // Call the function of module1 with module2 as it's this
 * fnApply(module1.getX, module2); // 42
 * fnApply(module1.log, module2, [ "friend" ]); // my friend : 42
 * ```
 */
var fnApply = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapInstFunction)("apply");
//# sourceMappingURL=fnApply.js.map

/***/ }),
/* 64 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   objSetPrototypeOf: () => (/* binding */ objSetPrototypeOf)
/* harmony export */ });
/* harmony import */ var _helpers_lazy__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8);
/* harmony import */ var _for_each_key__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */



var _isProtoArray;
/**
 * The objSetPrototypeOf() method sets the prototype (i.e., the internal [Prototype] property) of a specified
 * object to another object or null.
 * @group Object
 * @param obj - The object which is to have it's prototype set.
 * @param proto - The object's new prototype (an object or null)
 * @returns The specified object.
 */
function objSetPrototypeOf(obj, proto) {
    var fn = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.ObjClass["setPrototypeOf"] ||
        // tslint:disable-next-line: only-arrow-functions
        function (d, b) {
            !_isProtoArray && (_isProtoArray = (0,_helpers_lazy__WEBPACK_IMPORTED_MODULE_1__.getLazy)(function () {
                var _a;
                return ((_a = {}, _a[_internal_constants__WEBPACK_IMPORTED_MODULE_0__.__PROTO__] = [], _a) instanceof Array);
            }));
            _isProtoArray.v ? d[_internal_constants__WEBPACK_IMPORTED_MODULE_0__.__PROTO__] = b : (0,_for_each_key__WEBPACK_IMPORTED_MODULE_2__.objForEachKey)(b, function (key, value) { return d[key] = value; });
        };
    return fn(obj, proto);
}
//# sourceMappingURL=set_proto.js.map

/***/ }),
/* 65 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createTimeout: () => (/* binding */ createTimeout),
/* harmony export */   createTimeoutWith: () => (/* binding */ createTimeoutWith),
/* harmony export */   scheduleTimeout: () => (/* binding */ scheduleTimeout),
/* harmony export */   scheduleTimeoutWith: () => (/* binding */ scheduleTimeoutWith)
/* harmony export */ });
/* harmony import */ var _array_slice__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(62);
/* harmony import */ var _funcs_fnApply__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(63);
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _handler__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(66);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */





function _createTimeoutWith(self, startTimer, overrideFn, theArgs) {
    var isArr = (0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isArray)(overrideFn);
    var len = isArr ? overrideFn.length : 0;
    var setFn = (len > 0 ? overrideFn[0] : (!isArr ? overrideFn : _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE)) || setTimeout;
    var clearFn = (len > 1 ? overrideFn[1] : _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE) || clearTimeout;
    var timerFn = theArgs[0];
    theArgs[0] = function () {
        handler.dn();
        (0,_funcs_fnApply__WEBPACK_IMPORTED_MODULE_2__.fnApply)(timerFn, self, (0,_array_slice__WEBPACK_IMPORTED_MODULE_3__.arrSlice)(arguments));
    };
    var handler = (0,_handler__WEBPACK_IMPORTED_MODULE_4__._createTimerHandler)(startTimer, function (timerId) {
        if (timerId) {
            if (timerId.refresh) {
                timerId.refresh();
                return timerId;
            }
            (0,_funcs_fnApply__WEBPACK_IMPORTED_MODULE_2__.fnApply)(clearFn, self, [timerId]);
        }
        return (0,_funcs_fnApply__WEBPACK_IMPORTED_MODULE_2__.fnApply)(setFn, self, theArgs);
    }, function (timerId) {
        (0,_funcs_fnApply__WEBPACK_IMPORTED_MODULE_2__.fnApply)(clearFn, self, [timerId]);
    });
    return handler.h;
}
function scheduleTimeout(callback, timeout) {
    return _createTimeoutWith(this, true, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE, (0,_array_slice__WEBPACK_IMPORTED_MODULE_3__.arrSlice)(arguments));
}
function scheduleTimeoutWith(overrideFn, callback, timeout) {
    return _createTimeoutWith(this, true, overrideFn, (0,_array_slice__WEBPACK_IMPORTED_MODULE_3__.arrSlice)(arguments, 1));
}
function createTimeout(callback, timeout) {
    return _createTimeoutWith(this, false, _internal_constants__WEBPACK_IMPORTED_MODULE_1__.UNDEF_VALUE, (0,_array_slice__WEBPACK_IMPORTED_MODULE_3__.arrSlice)(arguments));
}
function createTimeoutWith(overrideFn, callback, timeout) {
    return _createTimeoutWith(this, false, overrideFn, (0,_array_slice__WEBPACK_IMPORTED_MODULE_3__.arrSlice)(arguments, 1));
}
//# sourceMappingURL=timeout.js.map

/***/ }),
/* 66 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _createTimerHandler: () => (/* binding */ _createTimerHandler)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8);
/* harmony import */ var _object_define__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(12);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


var REF = "ref";
var UNREF = "un" + REF;
var HAS_REF = "hasRef";
var ENABLED = "enabled";
/**
 * @ignore
 * @internal
 * Internal function to create and manage an ITimerHandler implementation, the object returned from this function
 * it directly used / returned by the pulic functions used to create timers (idle, interval and timeout)
 * @param startTimer - Should the timer be started as part of creating the handler
 * @param refreshFn - The function used to create/start or refresh the timer
 * @param cancelFn - The function used to cancel the timer.
 * @returns The new ITimerHandler instance
 */
function _createTimerHandler(startTimer, refreshFn, cancelFn) {
    var _a;
    var ref = true;
    var timerId = startTimer ? refreshFn(_internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE) : _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE;
    var theTimerHandler;
    var _unref = function () {
        ref = false;
        timerId && timerId[UNREF] && timerId[UNREF]();
        return theTimerHandler;
    };
    var _ref = function () {
        ref = true;
        timerId && timerId[REF] && timerId[REF]();
        return theTimerHandler;
    };
    var _hasRef = function () {
        if (timerId && timerId[HAS_REF]) {
            return timerId[HAS_REF]();
        }
        return ref;
    };
    var _refresh = function () {
        timerId = refreshFn(timerId);
        if (!ref) {
            _unref();
        }
        return theTimerHandler;
    };
    var _cancel = function () {
        timerId && cancelFn(timerId);
        timerId = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE;
    };
    var _setEnabled = function (value) {
        !value && timerId && _cancel();
        value && !timerId && _refresh();
    };
    theTimerHandler = (_a = {
            cancel: _cancel,
            refresh: _refresh
        },
        _a[HAS_REF] = _hasRef,
        _a[REF] = _ref,
        _a[UNREF] = _unref,
        _a[ENABLED] = false,
        _a);
    (0,_object_define__WEBPACK_IMPORTED_MODULE_1__.objDefineProp)(theTimerHandler, ENABLED, {
        get: function () { return !!timerId; },
        set: _setEnabled
    });
    return {
        h: theTimerHandler,
        dn: function () {
            timerId = _internal_constants__WEBPACK_IMPORTED_MODULE_0__.NULL_VALUE;
        }
    };
}
//# sourceMappingURL=handler.js.map

/***/ }),
/* 67 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DiagnosticLogger: () => (/* binding */ DiagnosticLogger),
/* harmony export */   _InternalLogMessage: () => (/* binding */ _InternalLogMessage),
/* harmony export */   _logInternalMessage: () => (/* binding */ _logInternalMessage),
/* harmony export */   _throwInternal: () => (/* binding */ _throwInternal),
/* harmony export */   _warnToConsole: () => (/* binding */ _warnToConsole),
/* harmony export */   safeGetLogger: () => (/* binding */ safeGetLogger)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(26);
/* harmony import */ var _Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(47);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(32);
/* harmony import */ var _DbgExtensionUtils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(68);
/* harmony import */ var _EnvUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(34);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */



var _a;







var STR_WARN_TO_CONSOLE = "warnToConsole";
/**
 * For user non actionable traces use AI Internal prefix.
 */
var AiNonUserActionablePrefix = "AI (Internal): ";
/**
 * Prefix of the traces in portal.
 */
var AiUserActionablePrefix = "AI: ";
/**
 *  Session storage key for the prefix for the key indicating message type already logged
 */
var AIInternalMessagePrefix = "AITR_";
var defaultValues = {
    loggingLevelConsole: 0,
    loggingLevelTelemetry: 1,
    maxMessageLimit: 25,
    enableDebug: false
};
var _logFuncs = (_a = {},
    _a[0 /* eLoggingSeverity.DISABLED */] = null,
    _a[1 /* eLoggingSeverity.CRITICAL */] = "errorToConsole",
    _a[2 /* eLoggingSeverity.WARNING */] = STR_WARN_TO_CONSOLE,
    _a[3 /* eLoggingSeverity.DEBUG */] = "debugToConsole",
    _a);
function _sanitizeDiagnosticText(text) {
    if (text) {
        return "\"" + text[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_REPLACE /* @min:%2ereplace */](/\"/g, _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY) + "\"";
    }
    return _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
}
function _logToConsole(func, message) {
    var theConsole = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_2__.getConsole)();
    if (!!theConsole) {
        var logFunc = "log";
        if (theConsole[func]) {
            logFunc = func;
        }
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isFunction)(theConsole[logFunc])) {
            theConsole[logFunc](message);
        }
    }
}
var _InternalLogMessage = /** @class */ (function () {
    function _InternalLogMessage(msgId, msg, isUserAct, properties) {
        if (isUserAct === void 0) { isUserAct = false; }
        var _self = this;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE_ID /* @min:%2emessageId */] = msgId;
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE /* @min:%2emessage */] =
            (isUserAct ? AiUserActionablePrefix : AiNonUserActionablePrefix) +
                msgId;
        var strProps = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
        if ((0,_EnvUtils__WEBPACK_IMPORTED_MODULE_2__.hasJSON)()) {
            strProps = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_2__.getJSON)().stringify(properties);
        }
        var diagnosticText = (msg ? " message:" + _sanitizeDiagnosticText(msg) : _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY) +
            (properties ? " props:" + _sanitizeDiagnosticText(strProps) : _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY);
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE /* @min:%2emessage */] += diagnosticText;
    }
    _InternalLogMessage.dataType = "MessageData";
    return _InternalLogMessage;
}());

function safeGetLogger(core, config) {
    return (core || {})[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOGGER /* @min:%2elogger */] || new DiagnosticLogger(config);
}
var DiagnosticLogger = /** @class */ (function () {
    function DiagnosticLogger(config) {
        this.identifier = "DiagnosticLogger";
        /**
         * The internal logging queue
         */
        this.queue = [];
        /**
         * Count of internal messages sent
         */
        var _messageCount = 0;
        /**
         * Holds information about what message types were already logged to console or sent to server.
         */
        var _messageLogged = {};
        var _loggingLevelConsole;
        var _loggingLevelTelemetry;
        var _maxInternalMessageLimit;
        var _enableDebug;
        var _unloadHandler;
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__["default"])(DiagnosticLogger, this, function (_self) {
            _unloadHandler = _setDefaultsFromConfig(config || {});
            _self.consoleLoggingLevel = function () { return _loggingLevelConsole; };
            /**
             * This method will throw exceptions in debug mode or attempt to log the error as a console warning.
             * @param severity - {LoggingSeverity} - The severity of the log message
             * @param message - {_InternalLogMessage} - The log message.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_THROW_INTERNAL /* @min:%2ethrowInternal */] = function (severity, msgId, msg, properties, isUserAct) {
                if (isUserAct === void 0) { isUserAct = false; }
                var message = new _InternalLogMessage(msgId, msg, isUserAct, properties);
                if (_enableDebug) {
                    throw (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.dumpObj)(message);
                }
                else {
                    // Get the logging function and fallback to warnToConsole of for some reason errorToConsole doesn't exist
                    var logFunc = _logFuncs[severity] || STR_WARN_TO_CONSOLE;
                    if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isUndefined)(message[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE /* @min:%2emessage */])) {
                        if (isUserAct) {
                            // check if this message type was already logged to console for this page view and if so, don't log it again
                            var messageKey = +message[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE_ID /* @min:%2emessageId */];
                            if (!_messageLogged[messageKey] && _loggingLevelConsole >= severity) {
                                _self[logFunc](message[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE /* @min:%2emessage */]);
                                _messageLogged[messageKey] = true;
                            }
                        }
                        else {
                            // Only log traces if the console Logging Level is >= the throwInternal severity level
                            if (_loggingLevelConsole >= severity) {
                                _self[logFunc](message[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE /* @min:%2emessage */]);
                            }
                        }
                        _logInternalMessage(severity, message);
                    }
                    else {
                        _debugExtMsg("throw" + (severity === 1 /* eLoggingSeverity.CRITICAL */ ? "Critical" : "Warning"), message);
                    }
                }
            };
            _self.debugToConsole = function (message) {
                _logToConsole("debug", message);
                _debugExtMsg("warning", message);
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_WARN_TO_CONSOLE /* @min:%2ewarnToConsole */] = function (message) {
                _logToConsole("warn", message);
                _debugExtMsg("warning", message);
            };
            _self.errorToConsole = function (message) {
                _logToConsole("error", message);
                _debugExtMsg("error", message);
            };
            _self.resetInternalMessageCount = function () {
                _messageCount = 0;
                _messageLogged = {};
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOG_INTERNAL_MESSAGE /* @min:%2elogInternalMessage */] = _logInternalMessage;
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UNLOAD /* @min:%2eunload */] = function (isAsync) {
                _unloadHandler && _unloadHandler.rm();
                _unloadHandler = null;
            };
            function _logInternalMessage(severity, message) {
                if (_areInternalMessagesThrottled()) {
                    return;
                }
                // check if this message type was already logged for this session and if so, don't log it again
                var logMessage = true;
                var messageKey = AIInternalMessagePrefix + message[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_MESSAGE_ID /* @min:%2emessageId */];
                // if the session storage is not available, limit to only one message type per page view
                if (_messageLogged[messageKey]) {
                    logMessage = false;
                }
                else {
                    _messageLogged[messageKey] = true;
                }
                if (logMessage) {
                    // Push the event in the internal queue
                    if (severity <= _loggingLevelTelemetry) {
                        _self.queue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PUSH /* @min:%2epush */](message);
                        _messageCount++;
                        _debugExtMsg((severity === 1 /* eLoggingSeverity.CRITICAL */ ? "error" : "warn"), message);
                    }
                    // When throttle limit reached, send a special event
                    if (_messageCount === _maxInternalMessageLimit) {
                        var throttleLimitMessage = "Internal events throttle limit per PageView reached for this app.";
                        var throttleMessage = new _InternalLogMessage(23 /* _eInternalMessageId.MessageLimitPerPVExceeded */, throttleLimitMessage, false);
                        _self.queue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PUSH /* @min:%2epush */](throttleMessage);
                        if (severity === 1 /* eLoggingSeverity.CRITICAL */) {
                            _self.errorToConsole(throttleLimitMessage);
                        }
                        else {
                            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_WARN_TO_CONSOLE /* @min:%2ewarnToConsole */](throttleLimitMessage);
                        }
                    }
                }
            }
            function _setDefaultsFromConfig(config) {
                // make sure the config is dynamic
                return (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_6__.onConfigChange)((0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_6__.createDynamicConfig)(config, defaultValues, _self).cfg, function (details) {
                    var config = details.cfg;
                    _loggingLevelConsole = config[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOGGING_LEVEL_CONSOL4 /* @min:%2eloggingLevelConsole */];
                    _loggingLevelTelemetry = config.loggingLevelTelemetry;
                    _maxInternalMessageLimit = config.maxMessageLimit;
                    _enableDebug = config.enableDebug;
                });
            }
            function _areInternalMessagesThrottled() {
                return _messageCount >= _maxInternalMessageLimit;
            }
            function _debugExtMsg(name, data) {
                var dbgExt = (0,_DbgExtensionUtils__WEBPACK_IMPORTED_MODULE_7__.getDebugExt)(config || {});
                if (dbgExt && dbgExt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */]) {
                    dbgExt[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](name, data);
                }
            }
        });
    }
// Removed Stub for DiagnosticLogger.prototype.consoleLoggingLevel.
// Removed Stub for DiagnosticLogger.prototype.throwInternal.
// Removed Stub for DiagnosticLogger.prototype.debugToConsole.
// Removed Stub for DiagnosticLogger.prototype.warnToConsole.
// Removed Stub for DiagnosticLogger.prototype.errorToConsole.
// Removed Stub for DiagnosticLogger.prototype.resetInternalMessageCount.
// Removed Stub for DiagnosticLogger.prototype.logInternalMessage.
// Removed Stub for DiagnosticLogger.prototype.unload.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    DiagnosticLogger.__ieDyn=1;

    return DiagnosticLogger;
}());

function _getLogger(logger) {
    return (logger || new DiagnosticLogger());
}
/**
 * This is a helper method which will call throwInternal on the passed logger, will throw exceptions in
 * debug mode or attempt to log the error as a console warning. This helper is provided mostly to better
 * support minification as logger.throwInternal() will not compress the publish "throwInternal" used throughout
 * the code.
 * @param logger - The Diagnostic Logger instance to use.
 * @param severity - {LoggingSeverity} - The severity of the log message
 * @param message - {_InternalLogMessage} - The log message.
 */
function _throwInternal(logger, severity, msgId, msg, properties, isUserAct) {
    if (isUserAct === void 0) { isUserAct = false; }
    _getLogger(logger)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_THROW_INTERNAL /* @min:%2ethrowInternal */](severity, msgId, msg, properties, isUserAct);
}
/**
 * This is a helper method which will call warnToConsole on the passed logger with the provided message.
 * @param logger - The Diagnostic Logger instance to use.
 * @param message - {_InternalLogMessage} - The log message.
 */
function _warnToConsole(logger, message) {
    _getLogger(logger)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_WARN_TO_CONSOLE /* @min:%2ewarnToConsole */](message);
}
/**
 * Logs a message to the internal queue.
 * @param logger - The Diagnostic Logger instance to use.
 * @param severity - {LoggingSeverity} - The severity of the log message
 * @param message - {_InternalLogMessage} - The message to log.
 */
function _logInternalMessage(logger, severity, message) {
    _getLogger(logger)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOG_INTERNAL_MESSAGE /* @min:%2elogInternalMessage */](severity, message);
}
//# sourceMappingURL=DiagnosticLogger.js.map

/***/ }),
/* 68 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getDebugExt: () => (/* binding */ getDebugExt),
/* harmony export */   getDebugListener: () => (/* binding */ getDebugListener)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(32);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





var listenerFuncs = [_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EVENTS_SENT, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EVENTS_DISCARDED, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EVENTS_SEND_REQUEST, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_PERF_EVENT];
var _aiNamespace = null;
var _debugListener;
function _listenerProxyFunc(name, config) {
    return function () {
        var args = arguments;
        var dbgExt = getDebugExt(config);
        if (dbgExt) {
            var listener = dbgExt.listener;
            if (listener && listener[name]) {
                listener[name][_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_APPLY /* @min:%2eapply */](listener, args);
            }
        }
    };
}
function _getExtensionNamespace() {
    // Cache the lookup of the global namespace object
    var target = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getInst)("Microsoft");
    if (target) {
        _aiNamespace = target["ApplicationInsights"];
    }
    return _aiNamespace;
}
function getDebugExt(config) {
    var ns = _aiNamespace;
    if (!ns && config.disableDbgExt !== true) {
        ns = _aiNamespace || _getExtensionNamespace();
    }
    return ns ? ns["ChromeDbgExt"] : null;
}
function getDebugListener(config) {
    if (!_debugListener) {
        _debugListener = {};
        for (var lp = 0; lp < listenerFuncs[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]; lp++) {
            _debugListener[listenerFuncs[lp]] = _listenerProxyFunc(listenerFuncs[lp], config);
        }
    }
    return _debugListener;
}
//# sourceMappingURL=DbgExtensionUtils.js.map

/***/ }),
/* 69 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppInsightsCore: () => (/* binding */ AppInsightsCore)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(44);
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(6);
/* harmony import */ var _nevware21_ts_async__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(71);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(35);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(19);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(15);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(38);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(65);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(100);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(16);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(7);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(12);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(97);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(58);
/* harmony import */ var _Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(47);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(32);
/* harmony import */ var _AsyncUtils__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(70);
/* harmony import */ var _Constants__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(83);
/* harmony import */ var _CookieMgr__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(84);
/* harmony import */ var _DataCacheHelper__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(48);
/* harmony import */ var _DbgExtensionUtils__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(68);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(67);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(33);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(34);
/* harmony import */ var _NotificationManager__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(89);
/* harmony import */ var _PerfManager__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(46);
/* harmony import */ var _ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(90);
/* harmony import */ var _TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(91);
/* harmony import */ var _TelemetryInitializerPlugin__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(93);
/* harmony import */ var _UnloadHandlerContainer__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(95);
/* harmony import */ var _UnloadHookContainer__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(96);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */



var _a;





















var strValidationError = "Plugins must provide initialize method";
var strNotificationManager = "_notificationManager";
var strSdkUnloadingError = "SDK is still unloading...";
var strSdkNotInitialized = "SDK is not initialized";
// const strPluginUnloadFailed = "Failed to unload plugin";
/**
 * The default settings for the config.
 * WE MUST include all defaults here to ensure that the config is created with all of the properties
 * defined as dynamic.
 */
var defaultConfig = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.objDeepFreeze)((_a = {
        cookieCfg: {}
    },
    _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSIONS] = { rdOnly: true, ref: true, v: [] },
    _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS] = { rdOnly: true, ref: true, v: [] },
    _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSION_CONFIG] = { ref: true, v: {} },
    _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CREATE_PERF_MGR] = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE,
    _a.loggingLevelConsole = 0 /* eLoggingSeverity.DISABLED */,
    _a.diagnosticLogInterval = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE,
    _a));
/**
 * Helper to create the default performance manager
 * @param core
 * @param notificationMgr
 */
function _createPerfManager(core, notificationMgr) {
    return new _PerfManager__WEBPACK_IMPORTED_MODULE_2__.PerfManager(notificationMgr);
}
function _validateExtensions(logger, channelPriority, allExtensions) {
    var _a;
    // Concat all available extensions
    var coreExtensions = [];
    var channels = [];
    // Check if any two extensions have the same priority, then warn to console
    // And extract the local extensions from the
    var extPriorities = {};
    // Extension validation
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(allExtensions, function (ext) {
        // Check for ext.initialize
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isNullOrUndefined)(ext) || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isNullOrUndefined)(ext[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_INITIALIZE /* @min:%2einitialize */])) {
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)(strValidationError);
        }
        var extPriority = ext[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_PRIORITY /* @min:%2epriority */];
        var identifier = ext[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IDENTIFIER /* @min:%2eidentifier */];
        if (ext && extPriority) {
            if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isNullOrUndefined)(extPriorities[extPriority])) {
                (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__._warnToConsole)(logger, "Two extensions have same priority #" + extPriority + " - " + extPriorities[extPriority] + ", " + identifier);
            }
            else {
                // set a value
                extPriorities[extPriority] = identifier;
            }
        }
        // Split extensions to core and channels
        if (!extPriority || extPriority < channelPriority) {
            // Add to core extension that will be managed by AppInsightsCore
            coreExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](ext);
        }
        else {
            channels[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](ext);
        }
    });
    return _a = {},
        _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CORE /* @min:core */] = coreExtensions,
        _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS /* @min:channels */] = channels,
        _a;
}
function _isPluginPresent(thePlugin, plugins) {
    var exists = false;
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(plugins, function (plugin) {
        if (plugin === thePlugin) {
            exists = true;
            return -1;
        }
    });
    return exists;
}
function _deepMergeConfig(details, target, newValues, merge) {
    // Lets assign the new values to the existing config
    if (newValues) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__.objForEachKey)(newValues, function (key, value) {
            if (merge) {
                if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.isPlainObject)(value) && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.isPlainObject)(target[key])) {
                    // The target is an object and it has a value
                    _deepMergeConfig(details, target[key], value, merge);
                }
            }
            if (merge && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.isPlainObject)(value) && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.isPlainObject)(target[key])) {
                // The target is an object and it has a value
                _deepMergeConfig(details, target[key], value, merge);
            }
            else {
                // Just Assign (replace) and/or make the property dynamic
                details.set(target, key, value);
            }
        });
    }
}
function _findWatcher(listeners, newWatcher) {
    var theListener = null;
    var idx = -1;
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(listeners, function (listener, lp) {
        if (listener.w === newWatcher) {
            theListener = listener;
            idx = lp;
            return -1;
        }
    });
    return { i: idx, l: theListener };
}
function _addDelayedCfgListener(listeners, newWatcher) {
    var theListener = _findWatcher(listeners, newWatcher).l;
    if (!theListener) {
        theListener = {
            w: newWatcher,
            rm: function () {
                var fnd = _findWatcher(listeners, newWatcher);
                if (fnd.i !== -1) {
                    listeners[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_SPLICE /* @min:%2esplice */](fnd.i, 1);
                }
            }
        };
        listeners[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](theListener);
    }
    return theListener;
}
function _registerDelayedCfgListener(config, listeners, logger) {
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(listeners, function (listener) {
        var unloadHdl = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_10__.onConfigChange)(config, listener.w, logger);
        delete listener.w; // Clear the listener reference so it will get garbage collected.
        // replace the remove function
        listener.rm = function () {
            unloadHdl.rm();
        };
    });
}
/**
 * @group Classes
 * @group Entrypoint
 */
var AppInsightsCore = /** @class */ (function () {
    function AppInsightsCore() {
        // NOTE!: DON'T set default values here, instead set them in the _initDefaults() function as it is also called during teardown()
        var _configHandler;
        var _isInitialized;
        var _logger;
        var _eventQueue;
        var _notificationManager;
        var _perfManager;
        var _cfgPerfManager;
        var _cookieManager;
        var _pluginChain;
        var _configExtensions;
        var _channelConfig;
        var _channels;
        var _isUnloading;
        var _telemetryInitializerPlugin;
        var _internalLogsEventName;
        var _evtNamespace;
        var _unloadHandlers;
        var _hookContainer;
        var _debugListener;
        var _traceCtx;
        var _instrumentationKey;
        var _cfgListeners;
        var _extensions;
        var _pluginVersionStringArr;
        var _pluginVersionString;
        /**
         * Internal log poller
         */
        var _internalLogPoller;
        var _internalLogPollerListening;
        var _forceStopInternalLogPoller;
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_11__["default"])(AppInsightsCore, this, function (_self) {
            // Set the default values (also called during teardown)
            _initDefaults();
            // Special internal method to allow the unit tests and DebugPlugin to hook embedded objects
            _self["_getDbgPlgTargets"] = function () {
                return [_extensions];
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */] = function () { return _isInitialized; };
            // Creating the self.initialize = ()
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_INITIALIZE /* @min:%2einitialize */] = function (config, extensions, logger, notificationManager) {
                if (_isUnloading) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)(strSdkUnloadingError);
                }
                // Make sure core is only initialized once
                if (_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */]()) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)("Core cannot be initialized more than once");
                }
                _configHandler = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_10__.createDynamicConfig)(config, defaultConfig, logger || _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */], false);
                // Re-assigning the local config property so we don't have any references to the passed value and it can be garbage collected
                config = _configHandler.cfg;
                // This will be "re-run" if the referenced config properties are changed
                _addUnloadHook(_configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_WATCH /* @min:%2ewatch */](function (details) {
                    _instrumentationKey = details.cfg.instrumentationKey;
                    // Mark the extensionConfig and all first level keys as referenced
                    // This is so that calls to getExtCfg() will always return the same object
                    // Even when a user may "re-assign" the plugin properties (or it's unloaded/reloaded)
                    var extCfg = details.ref(details.cfg, _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSION_CONFIG);
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__.objForEachKey)(extCfg, function (key) {
                        details.ref(extCfg, key);
                    });
                    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isNullOrUndefined)(_instrumentationKey)) {
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)("Please provide instrumentation key");
                    }
                }));
                _notificationManager = notificationManager;
                _initDebugListener();
                _initPerfManager();
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */] = logger;
                var cfgExtensions = config[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSIONS /* @min:%2eextensions */];
                // Extension validation
                _configExtensions = [];
                _configExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */].apply(_configExtensions, (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_12__.__spreadArrayFn)((0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_12__.__spreadArrayFn)([], extensions, false), cfgExtensions, false));
                _channelConfig = config[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS /* @min:%2echannels */];
                _initPluginChain(null);
                if (!_channels || _channels[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] === 0) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)("No " + _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS + " available");
                }
                if (_channelConfig && _channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 1) {
                    var teeController = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_PLUGIN /* @min:%2egetPlugin */]("TeeChannelController");
                    if (!teeController || !teeController.plugin) {
                        (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__._throwInternal)(_logger, 1 /* eLoggingSeverity.CRITICAL */, 28 /* _eInternalMessageId.SenderNotInitialized */, "TeeChannel required");
                    }
                }
                _registerDelayedCfgListener(config, _cfgListeners, _logger);
                _cfgListeners = null;
                _isInitialized = true;
                _self.releaseQueue();
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_POLL_INTERNAL_LOGS /* @min:%2epollInternalLogs */]();
            };
            _self.getChannels = function () {
                var controls = [];
                if (_channels) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(_channels, function (channel) {
                        controls[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](channel);
                    });
                }
                return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.objFreeze)(controls);
            };
            _self.track = function (telemetryItem) {
                (0,_PerfManager__WEBPACK_IMPORTED_MODULE_2__.doPerf)(_self[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_GET_PERF_MGR /* @min:%2egetPerfMgr */](), function () { return "AppInsightsCore:track"; }, function () {
                    if (telemetryItem === null) {
                        _notifyInvalidEvent(telemetryItem);
                        // throw error
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)("Invalid telemetry item");
                    }
                    // do basic validation before sending it through the pipeline
                    if (!telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_NAME /* @min:%2ename */] && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isNullOrUndefined)(telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_NAME /* @min:%2ename */])) {
                        _notifyInvalidEvent(telemetryItem);
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)("telemetry name required");
                    }
                    // setup default iKey if not passed in
                    telemetryItem.iKey = telemetryItem.iKey || _instrumentationKey;
                    // add default timestamp if not passed in
                    telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_TIME /* @min:%2etime */] = telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_TIME /* @min:%2etime */] || (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_13__.toISOString)(new Date());
                    // Common Schema 4.0
                    telemetryItem.ver = telemetryItem.ver || "4.0";
                    if (!_isUnloading && _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */]()) {
                        // Process the telemetry plugin chain
                        _createTelCtx()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](telemetryItem);
                    }
                    else {
                        // Queue events until all extensions are initialized
                        _eventQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](telemetryItem);
                    }
                }, function () { return ({ item: telemetryItem }); }, !(telemetryItem.sync));
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_PROCESS_TEL_CONT0 /* @min:%2egetProcessTelContext */] = _createTelCtx;
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_NOTIFY_MGR /* @min:%2egetNotifyMgr */] = function () {
                if (!_notificationManager) {
                    _notificationManager = new _NotificationManager__WEBPACK_IMPORTED_MODULE_14__.NotificationManager(_configHandler.cfg);
                    // For backward compatibility only
                    _self[strNotificationManager] = _notificationManager;
                }
                return _notificationManager;
            };
            /**
             * Adds a notification listener. The SDK calls methods on the listener when an appropriate notification is raised.
             * The added plugins must raise notifications. If the plugins do not implement the notifications, then no methods will be
             * called.
             * @param listener - An INotificationListener object.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ADD_NOTIFICATION_LIS1 /* @min:%2eaddNotificationListener */] = function (listener) {
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_NOTIFY_MGR /* @min:%2egetNotifyMgr */]()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ADD_NOTIFICATION_LIS1 /* @min:%2eaddNotificationListener */](listener);
            };
            /**
             * Removes all instances of the listener.
             * @param listener - INotificationListener to remove.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_REMOVE_NOTIFICATION_2 /* @min:%2eremoveNotificationListener */] = function (listener) {
                if (_notificationManager) {
                    _notificationManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_REMOVE_NOTIFICATION_2 /* @min:%2eremoveNotificationListener */](listener);
                }
            };
            _self.getCookieMgr = function () {
                if (!_cookieManager) {
                    _cookieManager = (0,_CookieMgr__WEBPACK_IMPORTED_MODULE_15__.createCookieMgr)(_configHandler.cfg, _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */]);
                }
                return _cookieManager;
            };
            _self.setCookieMgr = function (cookieMgr) {
                if (_cookieManager !== cookieMgr) {
                    (0,_AsyncUtils__WEBPACK_IMPORTED_MODULE_16__.runTargetUnload)(_cookieManager, false);
                    _cookieManager = cookieMgr;
                }
            };
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_GET_PERF_MGR /* @min:%2egetPerfMgr */] = function () {
                if (!_perfManager && !_cfgPerfManager) {
                    _addUnloadHook(_configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_WATCH /* @min:%2ewatch */](function (details) {
                        if (details.cfg.enablePerfMgr) {
                            var createPerfMgr = details.cfg[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CREATE_PERF_MGR /* @min:%2ecreatePerfMgr */];
                            if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isFunction)(createPerfMgr)) {
                                _cfgPerfManager = createPerfMgr(_self, _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_NOTIFY_MGR /* @min:%2egetNotifyMgr */]());
                            }
                        }
                    }));
                }
                return _perfManager || _cfgPerfManager || (0,_PerfManager__WEBPACK_IMPORTED_MODULE_2__.getGblPerfMgr)();
            };
            _self.setPerfMgr = function (perfMgr) {
                _perfManager = perfMgr;
            };
            _self.eventCnt = function () {
                return _eventQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */];
            };
            _self.releaseQueue = function () {
                if (_isInitialized && _eventQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    var eventQueue = _eventQueue;
                    _eventQueue = [];
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(eventQueue, function (event) {
                        _createTelCtx()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](event);
                    });
                }
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_POLL_INTERNAL_LOGS /* @min:%2epollInternalLogs */] = function (eventName) {
                _internalLogsEventName = eventName || null;
                _forceStopInternalLogPoller = false;
                _internalLogPoller && _internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_CANCEL /* @min:%2ecancel */]();
                return _startLogPoller(true);
            };
            function _startLogPoller(alwaysStart) {
                if ((!_internalLogPoller || !_internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ENABLED /* @min:%2eenabled */]) && !_forceStopInternalLogPoller) {
                    var shouldStart = alwaysStart || (_logger && _logger.queue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 0);
                    if (shouldStart) {
                        if (!_internalLogPollerListening) {
                            _internalLogPollerListening = true;
                            // listen for any configuration changes so that changes to the
                            // interval will cause the timer to be re-initialized
                            _addUnloadHook(_configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_WATCH /* @min:%2ewatch */](function (details) {
                                var interval = details.cfg.diagnosticLogInterval;
                                if (!interval || !(interval > 0)) {
                                    interval = 10000;
                                }
                                var isRunning = false;
                                if (_internalLogPoller) {
                                    // It was already created so remember it's running and cancel
                                    isRunning = _internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ENABLED /* @min:%2eenabled */];
                                    _internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_CANCEL /* @min:%2ecancel */]();
                                }
                                // Create / reconfigure
                                _internalLogPoller = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_17__.createTimeout)(_flushInternalLogs, interval);
                                _internalLogPoller.unref();
                                // Restart if previously running
                                _internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ENABLED /* @min:%2eenabled */] = isRunning;
                            }));
                        }
                        _internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ENABLED /* @min:%2eenabled */] = true;
                    }
                }
                return _internalLogPoller;
            }
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_STOP_POLLING_INTERNA3 /* @min:%2estopPollingInternalLogs */] = function () {
                _forceStopInternalLogPoller = true;
                _internalLogPoller && _internalLogPoller[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_CANCEL /* @min:%2ecancel */]();
                _flushInternalLogs();
            };
            // Add addTelemetryInitializer
            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_13__.proxyFunctions)(_self, function () { return _telemetryInitializerPlugin; }, ["addTelemetryInitializer"]);
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_UNLOAD /* @min:%2eunload */] = function (isAsync, unloadComplete, cbTimeout) {
                var _a;
                if (isAsync === void 0) { isAsync = true; }
                if (!_isInitialized) {
                    // The SDK is not initialized
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)(strSdkNotInitialized);
                }
                // Check if the SDK still unloading so throw
                if (_isUnloading) {
                    // The SDK is already unloading
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)(strSdkUnloadingError);
                }
                var unloadState = (_a = {
                        reason: 50 /* TelemetryUnloadReason.SdkUnload */
                    },
                    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IS_ASYNC /* @min:isAsync */] = isAsync,
                    _a.flushComplete = false,
                    _a);
                var result;
                if (isAsync && !unloadComplete) {
                    result = (0,_nevware21_ts_async__WEBPACK_IMPORTED_MODULE_18__.createPromise)(function (resolve) {
                        // Set the callback to the promise resolve callback
                        unloadComplete = resolve;
                    });
                }
                var processUnloadCtx = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__.createProcessTelemetryUnloadContext)(_getPluginChain(), _self);
                processUnloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ON_COMPLETE /* @min:%2eonComplete */](function () {
                    _hookContainer.run(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */]);
                    // Run any "unload" functions for the _cookieManager, _notificationManager and _logger
                    (0,_AsyncUtils__WEBPACK_IMPORTED_MODULE_16__.doUnloadAll)([_cookieManager, _notificationManager, _logger], isAsync, function () {
                        _initDefaults();
                        unloadComplete && unloadComplete(unloadState);
                    });
                }, _self);
                function _doUnload(flushComplete) {
                    unloadState.flushComplete = flushComplete;
                    _isUnloading = true;
                    // Run all of the unload handlers first (before unloading the plugins)
                    _unloadHandlers.run(processUnloadCtx, unloadState);
                    // Stop polling the internal logs
                    _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_STOP_POLLING_INTERNA3 /* @min:%2estopPollingInternalLogs */]();
                    // Start unloading the components, from this point onwards the SDK should be considered to be in an unstable state
                    processUnloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](unloadState);
                }
                _flushInternalLogs();
                if (!_flushChannels(isAsync, _doUnload, 6 /* SendRequestReason.SdkUnload */, cbTimeout)) {
                    _doUnload(false);
                }
                return result;
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_PLUGIN /* @min:%2egetPlugin */] = _getPlugin;
            _self.addPlugin = function (plugin, replaceExisting, isAsync, addCb) {
                if (!plugin) {
                    addCb && addCb(false);
                    _logOrThrowError(strValidationError);
                    return;
                }
                var existingPlugin = _getPlugin(plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IDENTIFIER /* @min:%2eidentifier */]);
                if (existingPlugin && !replaceExisting) {
                    addCb && addCb(false);
                    _logOrThrowError("Plugin [" + plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IDENTIFIER /* @min:%2eidentifier */] + "] is already loaded!");
                    return;
                }
                var updateState = {
                    reason: 16 /* TelemetryUpdateReason.PluginAdded */
                };
                function _addPlugin(removed) {
                    _configExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](plugin);
                    updateState.added = [plugin];
                    // Re-Initialize the plugin chain
                    _initPluginChain(updateState);
                    addCb && addCb(true);
                }
                if (existingPlugin) {
                    var removedPlugins_1 = [existingPlugin.plugin];
                    var unloadState = {
                        reason: 2 /* TelemetryUnloadReason.PluginReplace */,
                        isAsync: !!isAsync
                    };
                    _removePlugins(removedPlugins_1, unloadState, function (removed) {
                        if (!removed) {
                            // Previous plugin was successfully removed or was not installed
                            addCb && addCb(false);
                        }
                        else {
                            updateState.removed = removedPlugins_1;
                            updateState.reason |= 32 /* TelemetryUpdateReason.PluginRemoved */;
                            _addPlugin(true);
                        }
                    });
                }
                else {
                    _addPlugin(false);
                }
            };
            _self.updateCfg = function (newConfig, mergeExisting) {
                if (mergeExisting === void 0) { mergeExisting = true; }
                var updateState;
                if (_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */]()) {
                    updateState = {
                        reason: 1 /* TelemetryUpdateReason.ConfigurationChanged */,
                        cfg: _configHandler.cfg,
                        oldCfg: (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_20__.deepExtend)({}, _configHandler.cfg),
                        newConfig: (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_20__.deepExtend)({}, newConfig),
                        merge: mergeExisting
                    };
                    newConfig = updateState.newConfig;
                    var cfg = _configHandler.cfg;
                    // replace the immutable (if initialized) values
                    // We don't currently allow updating the extensions and channels via the update config
                    // So overwriting any user provided values to reuse the existing values
                    newConfig[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSIONS /* @min:%2eextensions */] = cfg[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSIONS /* @min:%2eextensions */];
                    newConfig[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS /* @min:%2echannels */] = cfg[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS /* @min:%2echannels */];
                }
                // Explicitly blocking any previous config watchers so that they don't get called because
                // of this bulk update (Probably not necessary)
                _configHandler._block(function (details) {
                    // Lets assign the new values to the existing config either overwriting or re-assigning
                    var theConfig = details.cfg;
                    _deepMergeConfig(details, theConfig, newConfig, mergeExisting);
                    if (!mergeExisting) {
                        // Remove (unassign) the values "missing" from the newConfig and also not in the default config
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__.objForEachKey)(theConfig, function (key) {
                            if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_21__.objHasOwn)(newConfig, key)) {
                                // Set the value to undefined
                                details.set(theConfig, key, _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE);
                            }
                        });
                    }
                    // Apply defaults to the new config
                    details[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_SET_DF /* @min:%2esetDf */](theConfig, defaultConfig);
                }, true);
                // Now execute all of the listeners (synchronously) so they update their values immediately
                _configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_NOTIFY /* @min:%2enotify */]();
                if (updateState) {
                    _doUpdate(updateState);
                }
            };
            _self.evtNamespace = function () {
                return _evtNamespace;
            };
            _self.flush = _flushChannels;
            _self.getTraceCtx = function (createNew) {
                if (!_traceCtx) {
                    _traceCtx = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__.createDistributedTraceContext)();
                }
                return _traceCtx;
            };
            _self.setTraceCtx = function (traceCtx) {
                _traceCtx = traceCtx || null;
            };
            _self.addUnloadHook = _addUnloadHook;
            // Create the addUnloadCb
            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_13__.proxyFunctionAs)(_self, "addUnloadCb", function () { return _unloadHandlers; }, "add");
            _self.onCfgChange = function (handler) {
                var unloadHook;
                if (!_isInitialized) {
                    unloadHook = _addDelayedCfgListener(_cfgListeners, handler);
                }
                else {
                    unloadHook = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_10__.onConfigChange)(_configHandler.cfg, handler, _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */]);
                }
                return {
                    rm: function () {
                        unloadHook.rm();
                    }
                };
            };
            _self.getWParam = function () {
                return ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_23__.hasDocument)() || !!_configHandler.cfg.enableWParam) ? 0 : -1;
            };
            function _setPluginVersions() {
                var thePlugins = {};
                _pluginVersionStringArr = [];
                var _addPluginVersions = function (plugins) {
                    if (plugins) {
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(plugins, function (plugin) {
                            if (plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IDENTIFIER /* @min:%2eidentifier */] && plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_VERSION /* @min:%2eversion */] && !thePlugins[plugin.identifier]) {
                                var ver = plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IDENTIFIER /* @min:%2eidentifier */] + "=" + plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_VERSION /* @min:%2eversion */];
                                _pluginVersionStringArr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](ver);
                                thePlugins[plugin.identifier] = plugin;
                            }
                        });
                    }
                };
                _addPluginVersions(_channels);
                if (_channelConfig) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(_channelConfig, function (channels) {
                        _addPluginVersions(channels);
                    });
                }
                _addPluginVersions(_configExtensions);
            }
            function _initDefaults() {
                _isInitialized = false;
                // Use a default logger so initialization errors are not dropped on the floor with full logging
                _configHandler = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_10__.createDynamicConfig)({}, defaultConfig, _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */]);
                // Set the logging level to critical so that any critical initialization failures are displayed on the console
                _configHandler.cfg[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGING_LEVEL_CONSOL4 /* @min:%2eloggingLevelConsole */] = 1 /* eLoggingSeverity.CRITICAL */;
                // Define _self.config
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_24__.objDefine)(_self, "config", {
                    g: function () { return _configHandler.cfg; },
                    s: function (newValue) {
                        _self.updateCfg(newValue, false);
                    }
                });
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_24__.objDefine)(_self, "pluginVersionStringArr", {
                    g: function () {
                        if (!_pluginVersionStringArr) {
                            _setPluginVersions();
                        }
                        return _pluginVersionStringArr;
                    }
                });
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_24__.objDefine)(_self, "pluginVersionString", {
                    g: function () {
                        if (!_pluginVersionString) {
                            if (!_pluginVersionStringArr) {
                                _setPluginVersions();
                            }
                            _pluginVersionString = _pluginVersionStringArr.join(";");
                        }
                        return _pluginVersionString || _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
                    }
                });
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_24__.objDefine)(_self, "logger", {
                    g: function () {
                        if (!_logger) {
                            _logger = new _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__.DiagnosticLogger(_configHandler.cfg);
                            _configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */] = _logger;
                        }
                        return _logger;
                    },
                    s: function (newLogger) {
                        _configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */] = newLogger;
                        if (_logger !== newLogger) {
                            (0,_AsyncUtils__WEBPACK_IMPORTED_MODULE_16__.runTargetUnload)(_logger, false);
                            _logger = newLogger;
                        }
                    }
                });
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */] = new _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__.DiagnosticLogger(_configHandler.cfg);
                _extensions = [];
                var cfgExtensions = _self.config[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSIONS /* @min:%2eextensions */] || [];
                cfgExtensions.splice(0, cfgExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */]);
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_25__.arrAppend)(cfgExtensions, _extensions);
                _telemetryInitializerPlugin = new _TelemetryInitializerPlugin__WEBPACK_IMPORTED_MODULE_26__.TelemetryInitializerPlugin();
                _eventQueue = [];
                (0,_AsyncUtils__WEBPACK_IMPORTED_MODULE_16__.runTargetUnload)(_notificationManager, false);
                _notificationManager = null;
                _perfManager = null;
                _cfgPerfManager = null;
                (0,_AsyncUtils__WEBPACK_IMPORTED_MODULE_16__.runTargetUnload)(_cookieManager, false);
                _cookieManager = null;
                _pluginChain = null;
                _configExtensions = [];
                _channelConfig = null;
                _channels = null;
                _isUnloading = false;
                _internalLogsEventName = null;
                _evtNamespace = (0,_DataCacheHelper__WEBPACK_IMPORTED_MODULE_27__.createUniqueNamespace)("AIBaseCore", true);
                _unloadHandlers = (0,_UnloadHandlerContainer__WEBPACK_IMPORTED_MODULE_28__.createUnloadHandlerContainer)();
                _traceCtx = null;
                _instrumentationKey = null;
                _hookContainer = (0,_UnloadHookContainer__WEBPACK_IMPORTED_MODULE_29__.createUnloadHookContainer)();
                _cfgListeners = [];
                _pluginVersionString = null;
                _pluginVersionStringArr = null;
                _forceStopInternalLogPoller = false;
            }
            function _createTelCtx() {
                var theCtx = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__.createProcessTelemetryContext)(_getPluginChain(), _configHandler.cfg, _self);
                theCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ON_COMPLETE /* @min:%2eonComplete */](_startLogPoller);
                return theCtx;
            }
            // Initialize or Re-initialize the plugins
            function _initPluginChain(updateState) {
                // Extension validation
                var theExtensions = _validateExtensions(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */], _Constants__WEBPACK_IMPORTED_MODULE_30__.ChannelControllerPriority, _configExtensions);
                _pluginChain = null;
                _pluginVersionString = null;
                _pluginVersionStringArr = null;
                // Get the primary channel queue and include as part of the normal extensions
                _channels = (_channelConfig || [])[0] || [];
                // Add any channels provided in the extensions and sort them
                _channels = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__.sortPlugins)((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_25__.arrAppend)(_channels, theExtensions[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CHANNELS /* @min:%2echannels */]));
                // Create an array of all extensions, including the _channels
                var allExtensions = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_25__.arrAppend)((0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__.sortPlugins)(theExtensions[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CORE /* @min:%2ecore */]), _channels);
                // Required to allow plugins to call core.getPlugin() during their own initialization
                _extensions = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.objFreeze)(allExtensions);
                // This has a side effect of adding the extensions passed during initialization
                // into the config.extensions, so you can see all of the extensions loaded.
                // This will also get updated by the addPlugin() and remove plugin code.
                var cfgExtensions = _self.config[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EXTENSIONS /* @min:%2eextensions */] || [];
                cfgExtensions.splice(0, cfgExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */]);
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_25__.arrAppend)(cfgExtensions, _extensions);
                var rootCtx = _createTelCtx();
                // Initializing the channels first
                if (_channels && _channels[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__.initializePlugins)(rootCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_CREATE_NEW /* @min:%2ecreateNew */](_channels), allExtensions);
                }
                // Now initialize the normal extensions (explicitly not including the _channels as this can cause duplicate initialization)
                (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__.initializePlugins)(rootCtx, allExtensions);
                if (updateState) {
                    _doUpdate(updateState);
                }
            }
            function _getPlugin(pluginIdentifier) {
                var theExt = null;
                var thePlugin = null;
                var channelHosts = [];
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(_extensions, function (ext) {
                    if (ext[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IDENTIFIER /* @min:%2eidentifier */] === pluginIdentifier && ext !== _telemetryInitializerPlugin) {
                        thePlugin = ext;
                        return -1;
                    }
                    if (ext.getChannel) {
                        channelHosts[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](ext);
                    }
                });
                if (!thePlugin && channelHosts[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(channelHosts, function (host) {
                        thePlugin = host.getChannel(pluginIdentifier);
                        if (!thePlugin) {
                            return -1;
                        }
                    });
                }
                if (thePlugin) {
                    theExt = {
                        plugin: thePlugin,
                        setEnabled: function (enabled) {
                            (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__._getPluginState)(thePlugin)[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_DISABLED] = !enabled;
                        },
                        isEnabled: function () {
                            var pluginState = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__._getPluginState)(thePlugin);
                            return !pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_TEARDOWN /* @min:%2eteardown */] && !pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_DISABLED];
                        },
                        remove: function (isAsync, removeCb) {
                            var _a;
                            if (isAsync === void 0) { isAsync = true; }
                            var pluginsToRemove = [thePlugin];
                            var unloadState = (_a = {
                                    reason: 1 /* TelemetryUnloadReason.PluginUnload */
                                },
                                _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_IS_ASYNC /* @min:isAsync */] = isAsync,
                                _a);
                            _removePlugins(pluginsToRemove, unloadState, function (removed) {
                                if (removed) {
                                    // Re-Initialize the plugin chain
                                    _initPluginChain({
                                        reason: 32 /* TelemetryUpdateReason.PluginRemoved */,
                                        removed: pluginsToRemove
                                    });
                                }
                                removeCb && removeCb(removed);
                            });
                        }
                    };
                }
                return theExt;
            }
            function _getPluginChain() {
                if (!_pluginChain) {
                    // copy the collection of extensions
                    var extensions = (_extensions || []).slice();
                    // During add / remove this may get called again, so don't read if already present
                    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_31__.arrIndexOf)(extensions, _telemetryInitializerPlugin) === -1) {
                        extensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](_telemetryInitializerPlugin);
                    }
                    _pluginChain = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__.createTelemetryProxyChain)((0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_22__.sortPlugins)(extensions), _configHandler.cfg, _self);
                }
                return _pluginChain;
            }
            function _removePlugins(thePlugins, unloadState, removeComplete) {
                if (thePlugins && thePlugins[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    var unloadChain = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__.createTelemetryProxyChain)(thePlugins, _configHandler.cfg, _self);
                    var unloadCtx = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__.createProcessTelemetryUnloadContext)(unloadChain, _self);
                    unloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ON_COMPLETE /* @min:%2eonComplete */](function () {
                        var removed = false;
                        // Remove the listed config extensions
                        var newConfigExtensions = [];
                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(_configExtensions, function (plugin, idx) {
                            if (!_isPluginPresent(plugin, thePlugins)) {
                                newConfigExtensions[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](plugin);
                            }
                            else {
                                removed = true;
                            }
                        });
                        _configExtensions = newConfigExtensions;
                        _pluginVersionString = null;
                        _pluginVersionStringArr = null;
                        // Re-Create the channel config
                        var newChannelConfig = [];
                        if (_channelConfig) {
                            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(_channelConfig, function (queue, idx) {
                                var newQueue = [];
                                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(queue, function (channel) {
                                    if (!_isPluginPresent(channel, thePlugins)) {
                                        newQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](channel);
                                    }
                                    else {
                                        removed = true;
                                    }
                                });
                                newChannelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PUSH /* @min:%2epush */](newQueue);
                            });
                            _channelConfig = newChannelConfig;
                        }
                        removeComplete && removeComplete(removed);
                        _startLogPoller();
                    });
                    unloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](unloadState);
                }
                else {
                    removeComplete(false);
                }
            }
            function _flushInternalLogs() {
                if (_logger && _logger.queue) {
                    var queue = _logger.queue.slice(0);
                    _logger.queue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] = 0;
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(queue, function (logMessage) {
                        var _a;
                        var item = (_a = {},
                            _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_NAME /* @min:name */] = _internalLogsEventName ? _internalLogsEventName : "InternalMessageId: " + logMessage[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_MESSAGE_ID /* @min:%2emessageId */],
                            _a.iKey = _instrumentationKey,
                            _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_TIME /* @min:time */] = (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_13__.toISOString)(new Date()),
                            _a.baseType = _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__._InternalLogMessage.dataType,
                            _a.baseData = { message: logMessage[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_MESSAGE /* @min:%2emessage */] },
                            _a);
                        _self.track(item);
                    });
                }
            }
            function _flushChannels(isAsync, callBack, sendReason, cbTimeout) {
                // Setting waiting to one so that we don't call the callBack until we finish iterating
                var waiting = 1;
                var doneIterating = false;
                var cbTimer = null;
                cbTimeout = cbTimeout || 5000;
                function doCallback() {
                    waiting--;
                    if (doneIterating && waiting === 0) {
                        cbTimer && cbTimer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_CANCEL /* @min:%2ecancel */]();
                        cbTimer = null;
                        callBack && callBack(doneIterating);
                        callBack = null;
                    }
                }
                if (_channels && _channels[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    var flushCtx = _createTelCtx()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_CREATE_NEW /* @min:%2ecreateNew */](_channels);
                    flushCtx.iterate(function (plugin) {
                        if (plugin.flush) {
                            waiting++;
                            var handled_1 = false;
                            // Not all channels will call this callback for every scenario
                            if (!plugin.flush(isAsync, function () {
                                handled_1 = true;
                                doCallback();
                            }, sendReason)) {
                                if (!handled_1) {
                                    // If any channel doesn't return true and it didn't call the callback, then we should assume that the callback
                                    // will never be called, so use a timeout to allow the channel(s) some time to "finish" before triggering any
                                    // followup function (such as unloading)
                                    if (isAsync && cbTimer == null) {
                                        cbTimer = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_17__.scheduleTimeout)(function () {
                                            cbTimer = null;
                                            doCallback();
                                        }, cbTimeout);
                                    }
                                    else {
                                        doCallback();
                                    }
                                }
                            }
                        }
                    });
                }
                doneIterating = true;
                doCallback();
                return true;
            }
            function _initDebugListener() {
                // Lazily ensure that the notification manager is created
                !_notificationManager && _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_NOTIFY_MGR /* @min:%2egetNotifyMgr */]();
                // Will get recalled if any referenced config values are changed
                _addUnloadHook(_configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_WATCH /* @min:%2ewatch */](function (details) {
                    var disableDbgExt = details.cfg.disableDbgExt;
                    if (disableDbgExt === true && _debugListener) {
                        // Remove any previously loaded debug listener
                        _notificationManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_REMOVE_NOTIFICATION_2 /* @min:%2eremoveNotificationListener */](_debugListener);
                        _debugListener = null;
                    }
                    if (_notificationManager && !_debugListener && disableDbgExt !== true) {
                        _debugListener = (0,_DbgExtensionUtils__WEBPACK_IMPORTED_MODULE_32__.getDebugListener)(details.cfg);
                        _notificationManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ADD_NOTIFICATION_LIS1 /* @min:%2eaddNotificationListener */](_debugListener);
                    }
                }));
            }
            function _initPerfManager() {
                // Will get recalled if any referenced config values are changed
                _addUnloadHook(_configHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_WATCH /* @min:%2ewatch */](function (details) {
                    var enablePerfMgr = details.cfg.enablePerfMgr;
                    if (!enablePerfMgr && _cfgPerfManager) {
                        // Remove any existing config based performance manager
                        _cfgPerfManager = null;
                    }
                    if (enablePerfMgr) {
                        // Set the performance manager creation function if not defined
                        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_13__.getSetValue)(details.cfg, _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_CREATE_PERF_MGR, _createPerfManager);
                    }
                }));
            }
            function _doUpdate(updateState) {
                var updateCtx = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_19__.createProcessTelemetryUpdateContext)(_getPluginChain(), _self);
                updateCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_ON_COMPLETE /* @min:%2eonComplete */](_startLogPoller);
                if (!_self._updateHook || _self._updateHook(updateCtx, updateState) !== true) {
                    updateCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](updateState);
                }
            }
            function _logOrThrowError(message) {
                var logger = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_LOGGER /* @min:%2elogger */];
                if (logger) {
                    // there should always be a logger
                    (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_7__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 73 /* _eInternalMessageId.PluginException */, message);
                    _startLogPoller();
                }
                else {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.throwError)(message);
                }
            }
            function _notifyInvalidEvent(telemetryItem) {
                var manager = _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_5__._DYN_GET_NOTIFY_MGR /* @min:%2egetNotifyMgr */]();
                if (manager) {
                    manager[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EVENTS_DISCARDED /* @min:%2eeventsDiscarded */]([telemetryItem], 2 /* eEventsDiscardedReason.InvalidEvent */);
                }
            }
            function _addUnloadHook(hooks) {
                _hookContainer.add(hooks);
            }
        });
    }
// Removed Stub for AppInsightsCore.prototype.initialize.
// Removed Stub for AppInsightsCore.prototype.getChannels.
// Removed Stub for AppInsightsCore.prototype.track.
// Removed Stub for AppInsightsCore.prototype.getProcessTelContext.
// Removed Stub for AppInsightsCore.prototype.getNotifyMgr.
// Removed Stub for AppInsightsCore.prototype.addNotificationListener.
// Removed Stub for AppInsightsCore.prototype.removeNotificationListener.
// Removed Stub for AppInsightsCore.prototype.getCookieMgr.
// Removed Stub for AppInsightsCore.prototype.setCookieMgr.
// Removed Stub for AppInsightsCore.prototype.getPerfMgr.
// Removed Stub for AppInsightsCore.prototype.setPerfMgr.
// Removed Stub for AppInsightsCore.prototype.eventCnt.
// Removed Stub for AppInsightsCore.prototype.pollInternalLogs.
// Removed Stub for AppInsightsCore.prototype.stopPollingInternalLogs.
// Removed Stub for AppInsightsCore.prototype.addTelemetryInitializer.
// Removed Stub for AppInsightsCore.prototype.unload.
// Removed Stub for AppInsightsCore.prototype.getPlugin.
// Removed Stub for AppInsightsCore.prototype.addPlugin.
// Removed Stub for AppInsightsCore.prototype.updateCfg.
// Removed Stub for AppInsightsCore.prototype.evtNamespace.
// Removed Stub for AppInsightsCore.prototype.addUnloadCb.
// Removed Stub for AppInsightsCore.prototype.flush.
// Removed Stub for AppInsightsCore.prototype.getTraceCtx.
// Removed Stub for AppInsightsCore.prototype.setTraceCtx.
// Removed Stub for AppInsightsCore.prototype.addUnloadHook.
// Removed Stub for AppInsightsCore.prototype.onCfgChange.
// Removed Stub for AppInsightsCore.prototype.releaseQueue.
// Removed Stub for AppInsightsCore.prototype._updateHook.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    AppInsightsCore.__ieDyn=1;

    return AppInsightsCore;
}());

//# sourceMappingURL=AppInsightsCore.js.map

/***/ }),
/* 70 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   doUnloadAll: () => (/* binding */ doUnloadAll),
/* harmony export */   runTargetUnload: () => (/* binding */ runTargetUnload)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_async__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71);
/* harmony import */ var _nevware21_ts_async__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(73);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(82);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(62);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(32);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





/**
 * Run the unload function of the target object if it exists
 * @param target - The target object that contains the unload function
 * @param isAsync - The caller identifies whether it is expecting the operation to complete synchronously or asynchronously. Even
 * if the caller is not waiting the operation may still be performed asynchronously depending on the component and the reverse is
 * also true.
 * @returns The result of the target function
 */
function runTargetUnload(target, isAsync) {
    if (target && target[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UNLOAD /* @min:%2eunload */]) {
        return target[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UNLOAD /* @min:%2eunload */](isAsync);
    }
}
/**
 * Call the unload function on all targets handling any returned [IPromise](https://nevware21.github.io/ts-async/typedoc/interfaces/IPromise.html)
 * / Promise before calling the next targets unload
 * @param targets - An array of the targets to unload
 * @param isAsync - The caller identifies whether it is expecting the operations to complete synchronously or asynchronously.  Even
 * if the caller is not waiting the operation may still be performed asynchronously depending on the component and the reverse is
 * also true.
 * @param done - Optional callback function to call once all of the unload functions have been called.
 */
function doUnloadAll(targets, isAsync, done) {
    var result;
    if (!done) {
        result = (0,_nevware21_ts_async__WEBPACK_IMPORTED_MODULE_1__.createPromise)(function (resolved) {
            done = resolved;
        });
    }
    if (targets && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.getLength)(targets) > 0) {
        (0,_nevware21_ts_async__WEBPACK_IMPORTED_MODULE_3__.doAwaitResponse)(runTargetUnload(targets[0], isAsync), function () {
            doUnloadAll((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.arrSlice)(targets, 1), isAsync, done);
        });
    }
    else {
        done();
    }
    return result;
}
//# sourceMappingURL=AsyncUtils.js.map

/***/ }),
/* 71 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createAllPromise: () => (/* binding */ createAllPromise),
/* harmony export */   createPromise: () => (/* binding */ createPromise),
/* harmony export */   createRejectedPromise: () => (/* binding */ createRejectedPromise),
/* harmony export */   createResolvedPromise: () => (/* binding */ createResolvedPromise),
/* harmony export */   setCreatePromiseImpl: () => (/* binding */ setCreatePromiseImpl)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(11);
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(72);
/* harmony import */ var _nativePromise__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(78);
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */



var _promiseCreator;
/**
 * Set the default promise implementation to use when calling `createPromise`; `createAllPromise`; `createResolvedPromise`
 * and `createRejectedPromise`. This is effective a global value and changing this will affect ALL callers of these
 * functions, as such these functions should only be used when switching implementations would have not unexpected
 * consequences like switching from a `createSyncPromise` to `createIdlePromise` where idle promises have a possibility
 * of never getting called during application shutdown or during an expected timeframe.
 * @group Alias
 * @group Promise
 * @param creator - The creator function to call when a new promise is required.
 */
function setCreatePromiseImpl(creator) {
    _promiseCreator = creator ? (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.getLazy)(function () { return creator; }) : null;
}
/**
 * Creates a Promise instance using the current default promise creator that when resolved or rejected will execute
 * it's pending chained operations.
 * @group Alias
 * @group Promise
 * @param executor - The function to be executed during the creation of the promise. Any errors thrown in the executor will
 * cause the promise to be rejected. The return value of the executor is always ignored
 * @param timeout - [Optional] timeout to wait before processing the items, defaults to zero.
 */
function createPromise(executor, timeout) {
    !_promiseCreator && (_promiseCreator = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.getLazy)(function () { return _nativePromise__WEBPACK_IMPORTED_MODULE_1__.createNativePromise; }));
    return _promiseCreator.v.call(this, executor, timeout);
}
/**
 * Returns a single asynchronous Promise instance that resolves to an array of the results from the input promises.
 * This returned promise will resolve and execute it's pending chained operations __asynchronously__ using the optional
 * provided timeout value to schedule when the chained items will be executed, or if the input contains no promises.
 * It rejects immediately upon any of the input promises rejected or non-promises throwing an error,
 * and will reject with this first rejection message / error.
 * If the runtime doesn't support the Promise.all it will fallback back to an asynchronous Promise implementation.
 * @group Alias
 * @group All
 * @param input - The array of promises to wait to be resolved / rejected before resolving or rejecting the new promise
 * @param timeout
 * @returns
 * <ul>
 * <li> An already resolved `Promise`, if the input passed is empty.
 * <li> A pending `Promise` in all other cases. This returned promise is then resolved/rejected __synchronously__
 * (as soon as the pending items is empty) when all the promises in the given input have resolved, or if any of the
 * promises reject.
 * </ul>
 */
var createAllPromise = (0,_base__WEBPACK_IMPORTED_MODULE_2__._createAllPromise)(createPromise);
/**
 * Returns a single asynchronous Promise instance that is already resolved with the given value. If the value passed is
 * a promise then that promise is returned instead of creating a new asynchronous promise instance.
 * If a new instance is returned then any chained operations will execute __asynchronously__ using the optional
 * timeout value to schedule when the chained items will be executed.(eg. `then()`; `finally()`).
 * @group Alias
 * @group Resolved
 * @param value - The value to be used by this `Promise`. Can also be a `Promise` or a thenable to resolve.
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 */
var createResolvedPromise = (0,_base__WEBPACK_IMPORTED_MODULE_2__._createResolvedPromise)(createPromise);
/**
 * Returns a single asynchronous Promise instance that is already rejected with the given reason.
 * Any chained operations will execute __asynchronously__ using the optional timeout value to schedule
 * when then chained items will be executed. (eg. `catch()`; `finally()`).
 * @group Alias
 * @group Rejected
 * @param reason - The rejection reason
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 */
var createRejectedPromise = (0,_base__WEBPACK_IMPORTED_MODULE_2__._createRejectedPromise)(createPromise);
//# sourceMappingURL=promise.js.map

/***/ }),
/* 72 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _createAllPromise: () => (/* binding */ _createAllPromise),
/* harmony export */   _createPromise: () => (/* binding */ _createPromise),
/* harmony export */   _createRejectedPromise: () => (/* binding */ _createRejectedPromise),
/* harmony export */   _createResolvedPromise: () => (/* binding */ _createResolvedPromise)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(62);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(65);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(12);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(52);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(19);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(37);
/* harmony import */ var _await__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(73);
/* harmony import */ var _debug__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(74);
/* harmony import */ var _internal_state__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(75);
/* harmony import */ var _event__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(76);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(77);
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */






var NODE_UNHANDLED_REJECTION = "unhandledRejection";
var UNHANDLED_REJECTION = NODE_UNHANDLED_REJECTION.toLowerCase();
var _currentPromiseId = [];
var _uniquePromiseId = 0;
var _unhandledRejectionTimeout = 10;
var _hasPromiseRejectionEvent;
function dumpFnObj(value) {
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isFunction)(value)) {
        return value.toString();
    }
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.dumpObj)(value);
}
function _createPromise(newPromise, processor, executor) {
    var additionalArgs = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.arrSlice)(arguments, 3);
    var _state = 0 /* ePromiseState.Pending */;
    var _hasResolved = false;
    var _settledValue;
    var _queue = [];
    var _id = _uniquePromiseId++;
    var _parentId = _currentPromiseId.length > 0 ? _currentPromiseId[_currentPromiseId.length - 1] : undefined;
    var _handled = false;
    var _unHandledRejectionHandler = null;
    var _thePromise;
    !_hasPromiseRejectionEvent && (_hasPromiseRejectionEvent = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.lazySafeGetInst)(_internal_constants__WEBPACK_IMPORTED_MODULE_4__.STR_PROMISE + "RejectionEvent"));
    // https://tc39.es/ecma262/#sec-promise.prototype.then
    var _then = function (onResolved, onRejected) {
        try {
            _currentPromiseId.push(_id);
            _handled = true;
            _unHandledRejectionHandler && _unHandledRejectionHandler.cancel();
            _unHandledRejectionHandler = null;
            //#ifdef DEBUG
            //#:(!DEBUG) _debugLog(_toString(), "then(" + dumpFnObj(onResolved)+ ", " + dumpFnObj(onResolved) +  ")");
            //#endif
            var thenPromise = newPromise(function (resolve, reject) {
                // Queue the new promise returned to be resolved or rejected
                // when this promise settles.
                _queue.push(function () {
                    // https://tc39.es/ecma262/#sec-newpromisereactionjob
                    //let value: any;
                    try {
                        // First call the onFulfilled or onRejected handler, on the settled value
                        // of this promise. If the corresponding `handler` does not exist, simply
                        // pass through the settled value.
                        //#ifdef DEBUG
                        //#:(!DEBUG) _debugLog(_toString(), "Handling settled value " + dumpFnObj(_settledValue));
                        //#endif
                        var handler = _state === 2 /* ePromiseState.Resolved */ ? onResolved : onRejected;
                        var value = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isUndefined)(handler) ? _settledValue : ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isFunction)(handler) ? handler(_settledValue) : handler);
                        //#ifdef DEBUG
                        //#:(!DEBUG) _debugLog(_toString(), "Handling Result " + dumpFnObj(value));
                        //#endif
                        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isPromiseLike)(value)) {
                            // The called handlers returned a new promise, so the chained promise
                            // will follow the state of this promise.
                            value.then(resolve, reject);
                        }
                        else if (handler) {
                            // If we have a handler then chained promises are always "resolved" with the result returned
                            resolve(value);
                        }
                        else if (_state === 3 /* ePromiseState.Rejected */) {
                            // If this promise is rejected then the chained promise should be rejected
                            // with either the settled value of this promise or the return value of the handler.
                            reject(value);
                        }
                        else {
                            // If this promise is fulfilled, then the chained promise is also fulfilled
                            // with either the settled value of this promise or the return value of the handler.
                            resolve(value);
                        }
                    }
                    catch (e) {
                        reject(e);
                    }
                });
                //#ifdef DEBUG
                //#:(!DEBUG) _debugLog(_toString(), "Added to Queue " + _queue.length);
                //#endif
                // If this promise is already settled, then immediately process the callback we
                // just added to the queue.
                if (_hasResolved) {
                    _processQueue();
                }
            }, additionalArgs);
            //#ifdef DEBUG
            //#:(!DEBUG) _debugLog(_toString(), "Created -> " + thenPromise.toString());
            //#endif
            return thenPromise;
        }
        finally {
            _currentPromiseId.pop();
        }
    };
    // https://tc39.es/ecma262/#sec-promise.prototype.catch
    var _catch = function (onRejected) {
        // Reuse then onRejected to support rejection
        return _then(undefined, onRejected);
    };
    // https://tc39.es/ecma262/#sec-promise.prototype.finally
    var _finally = function (onFinally) {
        var thenFinally = onFinally;
        var catchFinally = onFinally;
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isFunction)(onFinally)) {
            thenFinally = function (value) {
                onFinally && onFinally();
                return value;
            };
            catchFinally = function (reason) {
                onFinally && onFinally();
                throw reason;
            };
        }
        return _then(thenFinally, catchFinally);
    };
    var _strState = function () {
        return _internal_state__WEBPACK_IMPORTED_MODULE_5__.STRING_STATES[_state];
    };
    var _processQueue = function () {
        if (_queue.length > 0) {
            // The onFulfilled and onRejected handlers must be called asynchronously. Thus,
            // we make a copy of the queue and work on it once the current call stack unwinds.
            var pending = _queue.slice();
            _queue = [];
            //#ifdef DEBUG
            //#:(!DEBUG) _debugLog(_toString(), "Processing queue " + pending.length);
            //#endif
            _handled = true;
            processor(pending);
            //#ifdef DEBUG
            //#:(!DEBUG) _debugLog(_toString(), "Processing done");
            //#endif
            _unHandledRejectionHandler && _unHandledRejectionHandler.cancel();
            _unHandledRejectionHandler = null;
        }
        else {
            //#ifdef DEBUG
            //#:(!DEBUG) _debugLog(_toString(), "Empty Processing queue ");
            //#endif
        }
    };
    var _createSettleIfFn = function (newState, allowState) {
        return function (theValue) {
            if (_state === allowState) {
                if (newState === 2 /* ePromiseState.Resolved */ && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isPromiseLike)(theValue)) {
                    _state = 1 /* ePromiseState.Resolving */;
                    //#ifdef DEBUG
                    //#:(!DEBUG) _debugLog(_toString(), "Resolving");
                    //#endif
                    theValue.then(_createSettleIfFn(2 /* ePromiseState.Resolved */, 1 /* ePromiseState.Resolving */), _createSettleIfFn(3 /* ePromiseState.Rejected */, 1 /* ePromiseState.Resolving */));
                    return;
                }
                _state = newState;
                _hasResolved = true;
                _settledValue = theValue;
                //#ifdef DEBUG
                //#:(!DEBUG) _debugLog(_toString(), _strState());
                //#endif
                _processQueue();
                if (!_handled && newState === 3 /* ePromiseState.Rejected */ && !_unHandledRejectionHandler) {
                    _unHandledRejectionHandler = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.scheduleTimeout)(_notifyUnhandledRejection, _unhandledRejectionTimeout);
                }
            }
            else {
                //#ifdef DEBUG
                //#:(!DEBUG) _debugLog(_toString(), "Already " + _strState());
                //#endif
            }
        };
    };
    var _notifyUnhandledRejection = function () {
        if (!_handled) {
            if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isNode)()) {
                //#ifdef DEBUG
                //#:(!DEBUG) _debugLog(_toString(), "Emitting " + NODE_UNHANDLED_REJECTION);
                //#endif
                process.emit(NODE_UNHANDLED_REJECTION, _settledValue, _thePromise);
            }
            else {
                var gbl = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.getWindow)() || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.getGlobal)();
                //#ifdef DEBUG
                //#:(!DEBUG) _debugLog(_toString(), "Emitting " + UNHANDLED_REJECTION);
                //#endif
                (0,_event__WEBPACK_IMPORTED_MODULE_7__.emitEvent)(gbl, UNHANDLED_REJECTION, function (theEvt) {
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__.objDefine)(theEvt, "promise", { g: function () { return _thePromise; } });
                    theEvt.reason = _settledValue;
                    return theEvt;
                }, !!_hasPromiseRejectionEvent.v);
            }
        }
    };
    _thePromise = {
        then: _then,
        "catch": _catch,
        finally: _finally
    };
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__.objDefineProp)(_thePromise, "state", {
        get: _strState
    });
    if (_debug__WEBPACK_IMPORTED_MODULE_9__._promiseDebugEnabled) {
        // eslint-disable-next-line brace-style
        (0,_debug__WEBPACK_IMPORTED_MODULE_9__._addDebugState)(_thePromise, _strState, function () { return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.objToString)(_settledValue); }, function () { return _handled; });
    }
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__.hasSymbol)()) {
        _thePromise[(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__.getKnownSymbol)(11 /* WellKnownSymbols.toStringTag */)] = "IPromise";
    }
    var _toString = function () {
        return "IPromise" + (_debug__WEBPACK_IMPORTED_MODULE_9__._promiseDebugEnabled ? "[" + _id + (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isUndefined)(_parentId) ? (":" + _parentId) : "") + "]" : "") + " " + _strState() + (_hasResolved ? (" - " + dumpFnObj(_settledValue)) : "");
    };
    _thePromise.toString = _toString;
    (function _initialize() {
        if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isFunction)(executor)) {
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__.throwTypeError)(_internal_constants__WEBPACK_IMPORTED_MODULE_4__.STR_PROMISE + ": executor is not a function - " + dumpFnObj(executor));
        }
        var _rejectFn = _createSettleIfFn(3 /* ePromiseState.Rejected */, 0 /* ePromiseState.Pending */);
        try {
            //#ifdef DEBUG
            //#:(!DEBUG) _debugLog(_toString(), "Executing");
            //#endif
            executor.call(_thePromise, _createSettleIfFn(2 /* ePromiseState.Resolved */, 0 /* ePromiseState.Pending */), _rejectFn);
        }
        catch (e) {
            _rejectFn(e);
        }
    })();
    //#ifdef DEBUG
    //#:(!DEBUG) _debugLog(_toString(), "Returning");
    //#endif
    return _thePromise;
}
/**
 * @ignore
 * @internal
 * Returns a function which when called will return a new Promise object that resolves to an array of the
 * results from the input promises. The returned promise will resolve when all of the inputs' promises have
 * resolved, or if the input contains no promises. It rejects immediately upon any of the input promises
 * rejected or non-promises throwing an error, and will reject with this first rejection message / error.
 * @param newPromise - The delegate function used to create a new promise object the new promise instance.
 * @returns A function to create a promise that will be resolved when all arguments are resolved.
 */
function _createAllPromise(newPromise) {
    return function (input) {
        var additionalArgs = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.arrSlice)(arguments, 1);
        return newPromise(function (resolve, reject) {
            try {
                var values_1 = [];
                var pending_1 = 1; // Prefix to 1 so we finish iterating over all of the input promises first
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_12__.arrForEach)(input, function (item, idx) {
                    if (item) {
                        pending_1++;
                        (0,_await__WEBPACK_IMPORTED_MODULE_13__.doAwait)(item, function (value) {
                            // Set the result values
                            values_1[idx] = value;
                            if (--pending_1 === 0) {
                                resolve(values_1);
                            }
                        }, reject);
                    }
                });
                // Now decrement the pending so that we finish correctly
                pending_1--;
                if (pending_1 === 0) {
                    // All promises were either resolved or where not a promise
                    resolve(values_1);
                }
            }
            catch (e) {
                reject(e);
            }
        }, additionalArgs);
    };
}
/**
 * @ignore
 * @internal
 * The createResolvedPromise returns a PromiseLike object that is resolved with a given value. If the value is
 * PromiseLike (i.e. has a "then" method), the returned promise will "follow" that thenable, adopting its eventual
 * state; otherwise the returned promise will be fulfilled with the value. This function flattens nested layers
 * of promise-like objects (e.g. a promise that resolves to a promise that resolves to something) into a single layer.
 * @param newPromise - The delegate function used to create a new promise object
 * @param value Argument to be resolved by this Promise. Can also be a Promise or a thenable to resolve.
 * @param additionalArgs - Any additional arguments that should be passed to the delegate to assist with the creation of
 * the new promise instance.
 */
function _createResolvedPromise(newPromise) {
    return function (value) {
        var additionalArgs = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.arrSlice)(arguments, 1);
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isPromiseLike)(value)) {
            return value;
        }
        return newPromise(function (resolve) {
            resolve(value);
        }, additionalArgs);
    };
}
/**
 * @ignore
 * @internal
 * Return a promise like object that is rejected with the given reason.
 * @param newPromise - The delegate function used to create a new promise object
 * @param reason - The rejection reason
 * @param additionalArgs - Any additional arguments that should be passed to the delegate to assist with the creation of
 * the new promise instance.
 */
function _createRejectedPromise(newPromise) {
    return function (reason) {
        var additionalArgs = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.arrSlice)(arguments, 1);
        return newPromise(function (_resolve, reject) {
            reject(reason);
        }, additionalArgs);
    };
}
//# sourceMappingURL=base.js.map

/***/ }),
/* 73 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   doAwait: () => (/* binding */ doAwait),
/* harmony export */   doAwaitResponse: () => (/* binding */ doAwaitResponse),
/* harmony export */   doFinally: () => (/* binding */ doFinally)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13);
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

function doAwaitResponse(value, cb) {
    return doAwait(value, function (value) {
        cb && cb({
            value: value,
            rejected: false
        });
    }, function (reason) {
        cb && cb({
            rejected: true,
            reason: reason
        });
    });
}
/**
 * Wait for the promise to resolve or reject, if resolved the callback function will be called with it's value and if
 * rejected the rejectFn will be called with the reason. If the passed promise argument is not a promise the callback
 * will be called synchronously with the value.
 * @group Await Helper
 * @param value - The value or promise like value to wait for
 * @param resolveFn - The callback to call on the promise successful resolving.
 * @param rejectFn - The callback to call when the promise rejects
 * @returns The passed value, if it is a promise and there is either a resolve or reject handler
 * then it will return a chained promise with the value from the resolve or reject handler (depending
 * whether it resolve or rejects)
 * @example
 * ```ts
 * let promise = createPromise<number>((resolve, reject) => {
 *     resolve(42);
 * });
 *
 * // Handle via a chained promise
 * let chainedPromise = promise.then((value) => {
 *     // Do something with the value
 * });
 *
 * // Handle via doAwait
 * doAwait(promise, (value) => {
 *     // Do something with the value
 * });
 *
 * // It can also handle the raw value, so you could process the result of either a
 * // synchrounous return of the value or a Promise
 * doAwait(42, (value) => {
 *     // Do something with the value
 * });
 * ```
 */
function doAwait(value, resolveFn, rejectFn, finallyFn) {
    var result = value;
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isPromiseLike)(value)) {
        if (resolveFn || rejectFn) {
            result = value.then(resolveFn, rejectFn);
        }
    }
    else {
        resolveFn && resolveFn(value);
    }
    if (finallyFn) {
        result = doFinally(result, finallyFn);
    }
    return result;
}
/**
 * Wait for the promise to resolve or reject and then call the finallyFn. If the passed promise argument is not a promise the callback
 * will be called synchronously with the value. If the passed promise doesn't implement finally then a finally implementation will be
 * simulated using then(..., ...).
 * @group Await Helper
 * @param value - The value or promise like value to wait for
 * @param finallyFn - The finally function to call once the promise has resolved or rejected
 */
function doFinally(value, finallyFn) {
    var result = value;
    if (finallyFn) {
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isPromiseLike)(value)) {
            if (value.finally) {
                result = value.finally(finallyFn);
            }
            else {
                // Simulate finally if not available
                result = value.then(function (value) {
                    finallyFn();
                    return value;
                }, function (reason) {
                    finallyFn();
                    throw reason;
                });
            }
        }
        else {
            finallyFn();
        }
    }
    return result;
}
//# sourceMappingURL=await.js.map

/***/ }),
/* 74 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _addDebugState: () => (/* binding */ _addDebugState),
/* harmony export */   _debugLog: () => (/* binding */ _debugLog),
/* harmony export */   _promiseDebugEnabled: () => (/* binding */ _promiseDebugEnabled),
/* harmony export */   setPromiseDebugState: () => (/* binding */ setPromiseDebugState)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(12);
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

var _debugState;
var _debugResult;
var _debugHandled;
/**
 * @internal
 * @ignore
 */
var _promiseDebugEnabled = false;
var _theLogger = null;
/**
 * @internal
 * @ignore Internal function enable logging the internal state of the promise during execution, this code and references are
 * removed from the production artifacts
 */
function _debugLog(id, message) {
    //#ifdef DEBUG
    //#:(!DEBUG) if (_theLogger) {
    //#:(!DEBUG)     _theLogger(id, message);
    //#:(!DEBUG) }
    //#endif
}
/**
 * @internal
 * @ignore
 * Internal function to add the debug state to the promise so that it provides simular visibility as you would
 * see from native promises
 * @param thePromise - The Promise implementation
 * @param stateFn - The function to return the state of the promise
 * @param resultFn - The function to return the result (settled value) of the promise
 * @param handledFn - The function to return whether the promise has been handled (used for throwing
 * unhandled rejection events)
 */
function _addDebugState(thePromise, stateFn, resultFn, handledFn) {
    // While the IPromise implementations provide a `state` property, keeping the `[[PromiseState]]`
    // as native promises also have a non-enumerable property of the same name
    _debugState = _debugState || { toString: function () { return "[[PromiseState]]"; } };
    _debugResult = _debugResult || { toString: function () { return "[[PromiseResult]]"; } };
    _debugHandled = _debugHandled || { toString: function () { return "[[PromiseIsHandled]]"; } };
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.objDefineProp)(thePromise, _debugState, { get: stateFn });
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.objDefineProp)(thePromise, _debugResult, { get: resultFn });
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.objDefineProp)(thePromise, _debugHandled, { get: handledFn });
}
/**
 * Debug helper to enable internal debugging of the promise implementations. Disabled by default.
 * For the generated packages included in the npm package the `logger` will not be called as the
 * `_debugLog` function that uses this logger is removed during packaging.
 *
 * It is available directly from the repository for unit testing.
 *
 * @group Debug
 * @param enabled - Should debugging be enabled (defaults `false`, when `true` promises will have
 * additional debug properties and the `toString` will include extra details.
 * @param logger - Optional logger that will log internal state changes, only called in debug
 * builds as the calling function is removed is the production artifacts.
 * @example
 * ```ts
 * // The Id is the id of the promise
 * // The message is the internal debug message
 * function promiseDebugLogger(id: string, message: string) {
 *     if (console && console.log) {
 *         console.log(id, message);
 *     }
 * }
 *
 * setPromiseDebugState(true, promiseDebugLogger);
 *
 * // While the logger will not be called for the production packages
 * // Setting the `enabled` flag to tru will cause each promise to have
 * // the following additional properties added
 * // [[PromiseState]]; => Same as the `state` property
 * // [[PromiseResult]]; => The settled value
 * // [[PromiseIsHandled]] => Identifies if the promise has been handled
 * // It will also cause the `toString` for the promise to include additional
 * // debugging information
 * ```
 */
function setPromiseDebugState(enabled, logger) {
    _promiseDebugEnabled = enabled;
    _theLogger = logger;
}
//# sourceMappingURL=debug.js.map

/***/ }),
/* 75 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STRING_STATES: () => (/* binding */ STRING_STATES)
/* harmony export */ });
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
/**
 * @ignore -- Don't include in the generated documentation
 * @internal
 */
var STRING_STATES = [
    "pending", "resolving", "resolved", "rejected"
];
//# sourceMappingURL=state.js.map

/***/ }),
/* 76 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   emitEvent: () => (/* binding */ emitEvent)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(26);
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

var DISPATCH_EVENT = "dispatchEvent";
var _hasInitEvent;
/**
 * @internal
 * @ignore
 * @param target
 * @param evtName
 * @param populateEvent
 * @param useNewEvent
 */
function emitEvent(target, evtName, populateEvent, useNewEvent) {
    var doc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.getDocument)();
    !_hasInitEvent && (_hasInitEvent = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.safeGetLazy)(function () {
        var evt;
        if (doc && doc.createEvent) {
            evt = doc.createEvent("Event");
        }
        return (!!evt && evt.initEvent);
    }, null));
    var theEvt = _hasInitEvent.v ? doc.createEvent("Event") : (useNewEvent ? new Event(evtName) : {});
    populateEvent && populateEvent(theEvt);
    if (_hasInitEvent.v) {
        theEvt.initEvent(evtName, false, true);
    }
    if (theEvt && target[DISPATCH_EVENT]) {
        target[DISPATCH_EVENT](theEvt);
    }
    else {
        var handler = target["on" + evtName];
        if (handler) {
            handler(theEvt);
        }
        else {
            var theConsole = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.getInst)("console");
            theConsole && (theConsole["error"] || theConsole["log"])(evtName, (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.dumpObj)(theEvt));
        }
    }
}
//# sourceMappingURL=event.js.map

/***/ }),
/* 77 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STR_PROMISE: () => (/* binding */ STR_PROMISE)
/* harmony export */ });
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2023 Nevware21
 * Licensed under the MIT license.
 */
var STR_PROMISE = "Promise";
//# sourceMappingURL=constants.js.map

/***/ }),
/* 78 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createNativeAllPromise: () => (/* binding */ createNativeAllPromise),
/* harmony export */   createNativePromise: () => (/* binding */ createNativePromise),
/* harmony export */   createNativeRejectedPromise: () => (/* binding */ createNativeRejectedPromise),
/* harmony export */   createNativeResolvedPromise: () => (/* binding */ createNativeResolvedPromise)
/* harmony export */ });
/* harmony import */ var _asyncPromise__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(79);
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(72);
/* harmony import */ var _internal_state__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(75);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(19);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(26);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(12);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(77);
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */





var _isPromiseSupported;
/**
 * Creates a Promise instance that when resolved or rejected will execute it's pending chained operations using the
 * available native Promise implementation.
 * If runtime does not support native `Promise` class (or no polyfill is available) this function will fallback to using
 * `createAsyncPromise` which will resolve them __asynchronously__ using the optional provided timeout value to
 * schedule when the chained items will be executed.
 * @group Alias
 * @group Promise
 * @group Native
 * @param executor - The function to be executed during the creation of the promise. Any errors thrown in the executor will
 * cause the promise to be rejected. The return value of the executor is always ignored
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 */
function createNativePromise(executor, timeout) {
    !_isPromiseSupported && (_isPromiseSupported = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.lazySafeGetInst)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.STR_PROMISE));
    var PrmCls = _isPromiseSupported.v;
    if (!PrmCls) {
        return (0,_asyncPromise__WEBPACK_IMPORTED_MODULE_2__.createAsyncPromise)(executor);
    }
    if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isFunction)(executor)) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.throwTypeError)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.STR_PROMISE + ": executor is not a function - " + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.dumpObj)(executor));
    }
    var _state = 0 /* ePromiseState.Pending */;
    function _strState() {
        return _internal_state__WEBPACK_IMPORTED_MODULE_6__.STRING_STATES[_state];
    }
    var thePromise = new PrmCls(function (resolve, reject) {
        function _resolve(value) {
            _state = 2 /* ePromiseState.Resolved */;
            resolve(value);
        }
        function _reject(reason) {
            _state = 3 /* ePromiseState.Rejected */;
            reject(reason);
        }
        executor(_resolve, _reject);
    });
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.objDefineProp)(thePromise, "state", {
        get: _strState
    });
    return thePromise;
}
/**
 * Returns a single asynchronous Promise instance that resolves to an array of the results from the input promises.
 * This returned promise will resolve and execute it's pending chained operations __asynchronously__ using the optional
 * provided timeout value to schedule when the chained items will be executed, or if the input contains no promises.
 * It rejects immediately upon any of the input promises rejected or non-promises throwing an error,
 * and will reject with this first rejection message / error.
 * If the runtime doesn't support the Promise.all it will fallback back to an asynchronous Promise implementation.
 * @group Alias
 * @group All
 * @group Native
 * @param input - The array of promises to wait to be resolved / rejected before resolving or rejecting the new promise
 * @param timeout
 * @returns
 * <ul>
 * <li> An already resolved `Promise`, if the input passed is empty.
 * <li> A pending `Promise` in all other cases. This returned promise is then resolved/rejected __synchronously__
 * (as soon as the pending items is empty) when all the promises in the given input have resolved, or if any of the
 * promises reject.
 * </ul>
 */
var createNativeAllPromise = (0,_base__WEBPACK_IMPORTED_MODULE_8__._createAllPromise)(createNativePromise);
/**
 * Returns a single asynchronous Promise instance that is already resolved with the given value. If the value passed is
 * a promise then that promise is returned instead of creating a new asynchronous promise instance.
 * If a new instance is returned then any chained operations will execute __asynchronously__ using the optional
 * timeout value to schedule when the chained items will be executed.(eg. `then()`; `finally()`).
 * @group Alias
 * @group Resolved
 * @group Native
 * @param value - The value to be used by this `Promise`. Can also be a `Promise` or a thenable to resolve.
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 */
var createNativeResolvedPromise = (0,_base__WEBPACK_IMPORTED_MODULE_8__._createResolvedPromise)(createNativePromise);
/**
 * Returns a single asynchronous Promise instance that is already rejected with the given reason.
 * Any chained operations will execute __asynchronously__ using the optional timeout value to schedule
 * when then chained items will be executed. (eg. `catch()`; `finally()`).
 * @group Alias
 * @group Rejected
 * @group Native
 * @param reason - The rejection reason
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 */
var createNativeRejectedPromise = (0,_base__WEBPACK_IMPORTED_MODULE_8__._createRejectedPromise)(createNativePromise);
//# sourceMappingURL=nativePromise.js.map

/***/ }),
/* 79 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createAsyncAllPromise: () => (/* binding */ createAsyncAllPromise),
/* harmony export */   createAsyncPromise: () => (/* binding */ createAsyncPromise),
/* harmony export */   createAsyncRejectedPromise: () => (/* binding */ createAsyncRejectedPromise),
/* harmony export */   createAsyncResolvedPromise: () => (/* binding */ createAsyncResolvedPromise)
/* harmony export */ });
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(72);
/* harmony import */ var _itemProcessor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(80);
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * Creates an asynchronous Promise instance that when resolved or rejected will execute it's pending chained operations
 * __asynchronously__ using the optional provided timeout value to schedule when the chained items will be ececuted.
 * @group Async
 * @group Promise
 * @param executor - The function to be executed during the creation of the promise. Any errors thrown in the executor will
 * cause the promise to be rejected. The return value of the executor is always ignored
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 */
function createAsyncPromise(executor, timeout) {
    return (0,_base__WEBPACK_IMPORTED_MODULE_0__._createPromise)(createAsyncPromise, (0,_itemProcessor__WEBPACK_IMPORTED_MODULE_1__.timeoutItemProcessor)(timeout), executor, timeout);
}
/**
 * Returns a single asynchronous Promise instance that resolves to an array of the results from the input promises.
 * This returned promise will resolve and execute it's pending chained operations __asynchronously__ using the optional
 * provided timeout value to schedule when the chained items will be executed, or if the input contains no promises.
 * It rejects immediately upon any of the input promises rejected or non-promises throwing an error,
 * and will reject with this first rejection message / error.
 * When resolved or rejected any additional chained operations will execute __asynchronously__ using the optional
 * timeout value to schedul when the chained item will be executed (eg. `then()`; `catch()`; `finally()`).
 * @group Async
 * @group All
 * @param input - The array of promises to wait to be resolved / rejected before resolving or rejecting the new promise
 * @param timeout
 * @returns
 * <ul>
 * <li> An already resolved `Promise`, if the input passed is empty.
 * <li> A pending `Promise` in all other cases. This returned promise is then resolved/rejected __synchronously__
 * (as soon as the pending items is empty) when all the promises in the given input have resolved, or if any of the
 * promises reject.
 * </ul>
 */
var createAsyncAllPromise = (0,_base__WEBPACK_IMPORTED_MODULE_0__._createAllPromise)(createAsyncPromise);
// /**
//  * Creates a Promise that is resolved or rejected when any of the provided Promises are resolved
//  * or rejected.
//  * @param values An array of Promises.
//  * @returns A new Promise.
//  */
//     race<T extends readonly unknown[] | []>(values: T): Promise<Awaited<T[number]>>;
//export const createAsyncRacePromise: <T extends readonly unknown[] | []>(values: T): IPromise<T[number]>;
/**
 * Returns a single asynchronous Promise instance that is already resolved with the given value. If the value passed is
 * a promise then that promise is returned instead of creating a new asynchronous promise instance.
 * If a new instance is returned then any chained operations will execute __asynchronously__ using the optional
 * timeout value to schedule when the chained items will be executed.(eg. `then()`; `finally()`).
 * @group Async
 * @group Resolved
 * @param value - The value to be used by this `Promise`. Can also be a `Promise` or a thenable to resolve.
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 */
var createAsyncResolvedPromise = (0,_base__WEBPACK_IMPORTED_MODULE_0__._createResolvedPromise)(createAsyncPromise);
/**
 * Returns a single asynchronous Promise instance that is already rejected with the given reason.
 * Any chained operations will execute __asynchronously__ using the optional timeout value to schedule
 * when then chained items will be executed. (eg. `catch()`; `finally()`).
 * @group Async
 * @group Rejected
 * @param reason - The rejection reason
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 */
var createAsyncRejectedPromise = (0,_base__WEBPACK_IMPORTED_MODULE_0__._createRejectedPromise)(createAsyncPromise);
//# sourceMappingURL=asyncPromise.js.map

/***/ }),
/* 80 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   idleItemProcessor: () => (/* binding */ idleItemProcessor),
/* harmony export */   syncItemProcessor: () => (/* binding */ syncItemProcessor),
/* harmony export */   timeoutItemProcessor: () => (/* binding */ timeoutItemProcessor)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(81);
/*
 * @nevware21/ts-async
 * https://github.com/nevware21/ts-async
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */

var _processPendingItems = function (pending) {
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(pending, function (fn) {
        try {
            fn();
        }
        catch (e) {
            // Don't let 1 failing handler break all others
            // TODO: Add some form of error reporting (i.e. Call any registered JS error handler so the error is reported)
        }
    });
};
/**
 * @internal
 * @ignore
 * Return an item processor that processes all of the pending items synchronously
 * @return An item processor
 */
function syncItemProcessor() {
    return _processPendingItems;
}
/**
 * @internal
 * @ignore
 * Return an item processor that processes all of the pending items asynchronously using the optional timeout.
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 * @return An item processor
 */
function timeoutItemProcessor(timeout) {
    var callbackTimeout = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.isNumber)(timeout) ? timeout : 0;
    return function (pending) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.scheduleTimeout)(function () {
            _processPendingItems(pending);
        }, callbackTimeout);
    };
}
/**
 * @internal
 * @ignore
 * Return an item processor that processes all of the pending items using an idle callback (if available) or based on
 * a timeout (when `requestIdenCallback` is not supported) using the optional timeout.
 * @param timeout - Optional timeout to wait before processing the items, defaults to zero.
 * @return An item processor
 */
function idleItemProcessor(timeout) {
    var options;
    if (timeout >= 0) {
        options = {
            timeout: +timeout
        };
    }
    return function (pending) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.scheduleIdleCallback)(function (deadline) {
            _processPendingItems(pending);
        }, options);
    };
}
//# sourceMappingURL=itemProcessor.js.map

/***/ }),
/* 81 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   hasIdleCallback: () => (/* binding */ hasIdleCallback),
/* harmony export */   scheduleIdleCallback: () => (/* binding */ scheduleIdleCallback),
/* harmony export */   setDefaultIdleTimeout: () => (/* binding */ setDefaultIdleTimeout),
/* harmony export */   setDefaultMaxExecutionTime: () => (/* binding */ setDefaultMaxExecutionTime)
/* harmony export */ });
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(13);
/* harmony import */ var _helpers_perf__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(40);
/* harmony import */ var _helpers_safe_lazy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10);
/* harmony import */ var _handler__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(66);
/* harmony import */ var _timeout__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */





var _hasIdleCallback;
var _defaultIdleTimeout = 100;
var _maxExecutionTime = 50;
/**
 * Identifies if the runtime supports the `requestIdleCallback` API.
 *
 * @since 0.4.4
 * @group Timer
 * @group Environment
 *
 * @returns True if the runtime supports `requestIdleCallback` otherwise false.
 * @example
 * ```ts
 * let nativeIdleTimeouts = hasIdleCallback();
 * // true === idle timeouts are supported by the runtime otherwise false and the {@linke scheduleIdleCallback}
 * will use `setTimeout` instead.
 * ```
 */
function hasIdleCallback() {
    !_hasIdleCallback && (_hasIdleCallback = (0,_helpers_safe_lazy__WEBPACK_IMPORTED_MODULE_0__.safeGetLazy)(function () { return (0,_helpers_base__WEBPACK_IMPORTED_MODULE_1__.isDefined)(requestIdleCallback); }, false));
    return !!(_hasIdleCallback.v ? requestIdleCallback : false);
}
/**
 * Set the idle timeout fallback timeout which is used when the runtime does not support `requestIdleCallback`
 * the default idle timeout will be used for the scheduled timer. Defaults to 100ms
 *
 * @since 0.4.4
 * @group Timer
 *
 * @param timeout - The time in milliseconds that the timer should wait before calling the idle function.
 */
function setDefaultIdleTimeout(timeout) {
    _defaultIdleTimeout = timeout;
}
/**
 * Set the idle timeout fallback simulated maximum execution time, used when the runtime doesn't
 * support `requestIdleTimeout` to simulate the [IdleDeadline](https://w3c.github.io/requestidlecallback/#dom-idledeadline)
 * `timeRemaining` value.
 * This value is used as the base time of the [IdleDeadline.timeRemaining](https://developer.mozilla.org/en-US/docs/Web/API/IdleDeadline/timeRemaining)
 * less the start time the callback was called. Defaults to 50ms.
 *
 * @since 0.4.4
 * @group Timer
 *
 * @param maxTime - The maximum execution time in milliseconds.
 */
function setDefaultMaxExecutionTime(maxTime) {
    _maxExecutionTime = maxTime;
}
/**
 * Queues a function to be called during a browser's idle periods. This enables developers to
 * perform background and low priority work on the main event loop, without impacting latency-critical
 * events such as animation and input response. Functions are generally called in first-in-first-out
 * order; however, callbacks which have a timeout specified may be called out-of-order if necessary
 * in order to run them before the timeout elapses.
 *
 * You can call scheduledleCallback() within an idle callback function to schedule another callback to
 * take place no sooner than the next pass through the event loop.
 *
 * If the runtime does not support the [requestIdleCallback](https://developer.mozilla.org/en-US/docs/Web/API/Window/requestIdleCallback)
 * it will fallback to use `setTimeout` with either the provided timeout or the current default idle
 * timeout, which can be set via {@link setDefaultIdleTimeout}. It will always supply a deadline which
 * indicates that the request timed out.
 *
 * @since 0.4.4
 * @group Timer
 *
 * @param callback - A reference to a function that should be called in the near future, when the
 * event loop is idle. The callback function is passed an [IdleDeadline](https://w3c.github.io/requestidlecallback/#dom-idledeadline)
 * object describing the amount of time available and whether or not the callback has been run because
 * the timeout period expired.
 * @param options - Contains optional configuration parameters. Currently only one property is defined:
 * `timeout` If the number of milliseconds represented by this parameter has elapsed and the callback
 * has not already been called, then a task to execute the callback is queued in the event loop (even
 * if doing so risks causing a negative performance impact). timeout must be a positive value or it
 * is ignored.
 * @returns A handle which can be used to cancel the callback by passing it into the `cancelIdleCallback()`
 * method.
 * @example
 * ```ts
 * let idleCalled = false;
 * let idleTimedOut = false;
 * let theIdleTimer = scheduleIdleCallback((idleDeadline: IdleDeadline) => {
 *     // This callback will be called when the system is idle (via requestIdleCallback) or after the provided timeout 100ms
 *     idleCalled = true;
 *     idleTimedOut = idleDeadline?.didTimeout;
 *     while ((idleDeadline.timeRemaining() > 0 || deadline.didTimeout)) {
 *         // Do some background operations while there is time remaining or we timed out
 *         // Unlike interval timers this callback will NOT be called again unless you call "refresh"
 *         // to restart it or create a new idle timer
 *     }
 * }, 100);
 *
 * // Instead of calling cancelIdleCallback() with the returned value from requestIdleCallback() the returned
 * // handler instance can be used instead to cancel the idle timer
 * theIdleTimer.cancel();
 * theIdleTimer.enabled;    // false
 *
 * // You can start the timer via enabled
 * theIdleTimer.enabled = true;
 *
 * // You can also "restart" the timer, whether it has previously triggered not not via the `refresh()`
 * theIdleTimer.refresh();
 * ```
 */
function scheduleIdleCallback(callback, options) {
    function _createDeadline(timedOut) {
        var startTime = (0,_helpers_perf__WEBPACK_IMPORTED_MODULE_2__.perfNow)();
        return {
            didTimeout: timedOut,
            timeRemaining: function () {
                return _maxExecutionTime - (0,_helpers_perf__WEBPACK_IMPORTED_MODULE_2__.elapsedTime)(startTime);
            }
        };
    }
    if (hasIdleCallback()) {
        var handler_1 = (0,_handler__WEBPACK_IMPORTED_MODULE_3__._createTimerHandler)(true, function (idleId) {
            idleId && cancelIdleCallback(idleId);
            return requestIdleCallback(function (deadline) {
                handler_1.dn();
                callback(deadline || _createDeadline(false));
            }, options);
        }, function (idleId) {
            cancelIdleCallback(idleId);
        });
        return handler_1.h;
    }
    var timeout = (options || {}).timeout;
    if ((0,_helpers_base__WEBPACK_IMPORTED_MODULE_1__.isUndefined)(timeout)) {
        timeout = _defaultIdleTimeout;
    }
    return (0,_timeout__WEBPACK_IMPORTED_MODULE_4__.scheduleTimeout)(function () {
        callback(_createDeadline(true));
    }, timeout);
}
//# sourceMappingURL=idle.js.map

/***/ }),
/* 82 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getLength: () => (/* binding */ getLength)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * Helper to return the length value of an object, this will return the value
 * of the "length" property. Generally used to return the length of a string or array.
 *
 * @since 0.4.2
 * @group Array
 * @group String
 * @group String
 * @group Array
 * @group Object
 * @param value - The value to return the length property from, must contain a `length` property
 * @example
 * ```ts
 * getLength("");               // returns 0
 * getLength("Hello World");    // returns 11
 * getLength([]);               // returns 0;
 * getLength([0, 1, 2, 3]);     // returns 4;
 * getLength({ length: 42});    // returns 42
 * getLength({ length: () => 53; }); // returns the function that if called would return 53
 * ```
 */
var getLength = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapProp)(_internal_constants__WEBPACK_IMPORTED_MODULE_1__.LENGTH);
//# sourceMappingURL=length.js.map

/***/ }),
/* 83 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ChannelControllerPriority: () => (/* binding */ ChannelControllerPriority)
/* harmony export */ });
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


var ChannelControllerPriority = 500;
//# sourceMappingURL=Constants.js.map

/***/ }),
/* 84 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   areCookiesSupported: () => (/* binding */ areCookiesSupported),
/* harmony export */   createCookieMgr: () => (/* binding */ createCookieMgr),
/* harmony export */   safeGetCookieMgr: () => (/* binding */ safeGetCookieMgr),
/* harmony export */   uaDisallowsSameSiteNone: () => (/* binding */ uaDisallowsSameSiteNone)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(7);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(58);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(86);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(24);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(28);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(41);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(26);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(37);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(15);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(88);
/* harmony import */ var _Config_ConfigDefaultHelpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85);
/* harmony import */ var _Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(47);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(32);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(67);
/* harmony import */ var _EnvUtils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(31);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(33);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(34);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */
var _a, _b;








var strToGMTString = "toGMTString";
var strToUTCString = "toUTCString";
var strCookie = "cookie";
var strExpires = "expires";
var strIsCookieUseDisabled = "isCookieUseDisabled";
var strDisableCookiesUsage = "disableCookiesUsage";
var strConfigCookieMgr = "_ckMgr";
var _supportsCookies = null;
var _allowUaSameSite = null;
var _parsedCookieValue = null;
var _doc;
var _cookieCache = {};
var _globalCookieConfig = {};
// // `isCookieUseDisabled` is deprecated, so explicitly casting as a key of IConfiguration to avoid typing error
// // when both isCookieUseDisabled and disableCookiesUsage are used disableCookiesUsage will take precedent, which is
// // why its listed first
/**
 * Set the supported dynamic config values as undefined (or an empty object) so that
 * any listeners will be informed of any changes.
 * Explicitly NOT including the deprecated `isCookieUseDisabled` as we don't want to support
 * the v1 deprecated field as dynamic for updates
 */
var rootDefaultConfig = (_a = {
        cookieCfg: (0,_Config_ConfigDefaultHelpers__WEBPACK_IMPORTED_MODULE_0__.cfgDfMerge)((_b = {},
            _b[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_DOMAIN] = { fb: "cookieDomain", dfVal: _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isNotNullOrUndefined },
            _b.path = { fb: "cookiePath", dfVal: _HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.isNotNullOrUndefined },
            _b.enabled = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE,
            _b.ignoreCookies = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE,
            _b.blockedCookies = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE,
            _b)),
        cookieDomain: _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE,
        cookiePath: _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE
    },
    _a[strDisableCookiesUsage] = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.UNDEFINED_VALUE,
    _a);
function _getDoc() {
    !_doc && (_doc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.getLazy)(function () { return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.getDocument)(); }));
}
/**
 * @ignore
 * DO NOT USE or export from the module, this is exposed as public to support backward compatibility of previous static utility methods only.
 * If you want to manager cookies either use the ICookieMgr available from the core instance via getCookieMgr() or create
 * your own instance of the CookieMgr and use that.
 * Using this directly for enabling / disabling cookie handling will not only affect your usage but EVERY user of cookies.
 * Example, if you are using a shared component that is also using Application Insights you will affect their cookie handling.
 * @param logger - The DiagnosticLogger to use for reporting errors.
 */
function _gblCookieMgr(config, logger) {
    // Stash the global instance against the BaseCookieMgr class
    var inst = createCookieMgr[strConfigCookieMgr] || _globalCookieConfig[strConfigCookieMgr];
    if (!inst) {
        // Note: not using the getSetValue() helper as that would require always creating a temporary cookieMgr
        // that ultimately is never used
        inst = createCookieMgr[strConfigCookieMgr] = createCookieMgr(config, logger);
        _globalCookieConfig[strConfigCookieMgr] = inst;
    }
    return inst;
}
function _isMgrEnabled(cookieMgr) {
    if (cookieMgr) {
        return cookieMgr.isEnabled();
    }
    return true;
}
function _isIgnoredCookie(cookieMgrCfg, name) {
    if (name && cookieMgrCfg && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isArray)(cookieMgrCfg.ignoreCookies)) {
        return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.arrIndexOf)(cookieMgrCfg.ignoreCookies, name) !== -1;
    }
    return false;
}
function _isBlockedCookie(cookieMgrCfg, name) {
    if (name && cookieMgrCfg && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isArray)(cookieMgrCfg.blockedCookies)) {
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.arrIndexOf)(cookieMgrCfg.blockedCookies, name) !== -1) {
            return true;
        }
    }
    return _isIgnoredCookie(cookieMgrCfg, name);
}
function _isCfgEnabled(rootConfig, cookieMgrConfig) {
    var isCfgEnabled = cookieMgrConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_ENABLED /* @min:%2eenabled */];
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isNullOrUndefined)(isCfgEnabled)) {
        // Set the enabled from the provided setting or the legacy root values
        var cookieEnabled = void 0;
        // This field is deprecated and dynamic updates will not be fully supported
        if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isUndefined)(rootConfig[strIsCookieUseDisabled])) {
            cookieEnabled = !rootConfig[strIsCookieUseDisabled];
        }
        // If this value is defined it takes precedent over the above
        if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isUndefined)(rootConfig[strDisableCookiesUsage])) {
            cookieEnabled = !rootConfig[strDisableCookiesUsage];
        }
        // Not setting the cookieMgrConfig.enabled as that will update (set) the global dynamic config
        // So future "updates" then may not be as expected
        isCfgEnabled = cookieEnabled;
    }
    return isCfgEnabled;
}
/**
 * Helper to return the ICookieMgr from the core (if not null/undefined) or a default implementation
 * associated with the configuration or a legacy default.
 * @param core
 * @param config
 * @returns
 */
function safeGetCookieMgr(core, config) {
    var cookieMgr;
    if (core) {
        // Always returns an instance
        cookieMgr = core.getCookieMgr();
    }
    else if (config) {
        var cookieCfg = config.cookieCfg;
        if (cookieCfg && cookieCfg[strConfigCookieMgr]) {
            cookieMgr = cookieCfg[strConfigCookieMgr];
        }
        else {
            cookieMgr = createCookieMgr(config);
        }
    }
    if (!cookieMgr) {
        // Get or initialize the default global (legacy) cookie manager if we couldn't find one
        cookieMgr = _gblCookieMgr(config, (core || {})[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_LOGGER /* @min:%2elogger */]);
    }
    return cookieMgr;
}
function createCookieMgr(rootConfig, logger) {
    var _a;
    var cookieMgrConfig;
    var _path;
    var _domain;
    var unloadHandler;
    // Explicitly checking against false, so that setting to undefined will === true
    var _enabled;
    var _getCookieFn;
    var _setCookieFn;
    var _delCookieFn;
    // Make sure the root config is dynamic as it may be the global config
    rootConfig = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_8__.createDynamicConfig)(rootConfig || _globalCookieConfig, null, logger).cfg;
    // Will get recalled if the referenced configuration is changed
    unloadHandler = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_8__.onConfigChange)(rootConfig, function (details) {
        // Make sure the root config has all of the the defaults to the root config to ensure they are dynamic
        details[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_SET_DF /* @min:%2esetDf */](details.cfg, rootDefaultConfig);
        // Create and apply the defaults to the cookieCfg element
        cookieMgrConfig = details.ref(details.cfg, "cookieCfg"); // details.setDf(details.cfg.cookieCfg, defaultConfig);
        _path = cookieMgrConfig[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_PATH /* @min:%2epath */] || "/";
        _domain = cookieMgrConfig[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_DOMAIN /* @min:%2edomain */];
        // Explicitly checking against false, so that setting to undefined will === true
        _enabled = _isCfgEnabled(rootConfig, cookieMgrConfig) !== false;
        _getCookieFn = cookieMgrConfig.getCookie || _getCookieValue;
        _setCookieFn = cookieMgrConfig.setCookie || _setCookieValue;
        _delCookieFn = cookieMgrConfig.delCookie || _setCookieValue;
    }, logger);
    var cookieMgr = (_a = {
            isEnabled: function () {
                var enabled = _isCfgEnabled(rootConfig, cookieMgrConfig) !== false && _enabled && areCookiesSupported(logger);
                // Using an indirect lookup for any global cookie manager to support tree shaking for SDK's
                // that don't use the "applicationinsights-core" version of the default cookie function
                var gblManager = _globalCookieConfig[strConfigCookieMgr];
                if (enabled && gblManager && cookieMgr !== gblManager) {
                    // Make sure the GlobalCookie Manager instance (if not this instance) is also enabled.
                    // As the global (deprecated) functions may have been called (for backward compatibility)
                    enabled = _isMgrEnabled(gblManager);
                }
                return enabled;
            },
            setEnabled: function (value) {
                // Explicitly checking against false, so that setting to undefined will === true
                _enabled = value !== false;
                cookieMgrConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_ENABLED /* @min:%2eenabled */] = value;
            },
            set: function (name, value, maxAgeSec, domain, path) {
                var result = false;
                if (_isMgrEnabled(cookieMgr) && !_isBlockedCookie(cookieMgrConfig, name)) {
                    var values = {};
                    var theValue = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.strTrim)(value || _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY);
                    var idx = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__.strIndexOf)(theValue, ";");
                    if (idx !== -1) {
                        theValue = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.strTrim)((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__.strLeft)(value, idx));
                        values = _extractParts((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__.strSubstring)(value, idx + 1));
                    }
                    // Only update domain if not already present (isUndefined) and the value is truthy (not null, undefined or empty string)
                    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(values, _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_DOMAIN, domain || _domain, _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isTruthy, _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isUndefined);
                    if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isNullOrUndefined)(maxAgeSec)) {
                        var _isIE = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_12__.isIE)();
                        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isUndefined)(values[strExpires])) {
                            var nowMs = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_13__.utcNow)();
                            // Only add expires if not already present
                            var expireMs = nowMs + (maxAgeSec * 1000);
                            // Sanity check, if zero or -ve then ignore
                            if (expireMs > 0) {
                                var expiry = new Date();
                                expiry.setTime(expireMs);
                                (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(values, strExpires, _formatDate(expiry, !_isIE ? strToUTCString : strToGMTString) || _formatDate(expiry, _isIE ? strToGMTString : strToUTCString) || _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY, _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isTruthy);
                            }
                        }
                        if (!_isIE) {
                            // Only replace if not already present
                            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(values, "max-age", _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY + maxAgeSec, null, _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isUndefined);
                        }
                    }
                    var location_1 = (0,_EnvUtils__WEBPACK_IMPORTED_MODULE_12__.getLocation)();
                    if (location_1 && location_1.protocol === "https:") {
                        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(values, "secure", null, null, _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isUndefined);
                        // Only set same site if not also secure
                        if (_allowUaSameSite === null) {
                            _allowUaSameSite = !uaDisallowsSameSiteNone(((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.getNavigator)() || {})[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_USER_AGENT /* @min:%2euserAgent */]);
                        }
                        if (_allowUaSameSite) {
                            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(values, "SameSite", "None", null, _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isUndefined);
                        }
                    }
                    (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.setValue)(values, _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_PATH, path || _path, null, _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isUndefined);
                    //let setCookieFn = cookieMgrConfig.setCookie || _setCookieValue;
                    _setCookieFn(name, _formatCookieValue(theValue, values));
                    result = true;
                }
                return result;
            },
            get: function (name) {
                var value = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
                if (_isMgrEnabled(cookieMgr) && !_isIgnoredCookie(cookieMgrConfig, name)) {
                    value = _getCookieFn(name);
                }
                return value;
            },
            del: function (name, path) {
                var result = false;
                if (_isMgrEnabled(cookieMgr)) {
                    // Only remove the cookie if the manager and cookie support has not been disabled
                    result = cookieMgr.purge(name, path);
                }
                return result;
            },
            purge: function (name, path) {
                var _a;
                var result = false;
                if (areCookiesSupported(logger)) {
                    // Setting the expiration date in the past immediately removes the cookie
                    var values = (_a = {},
                        _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_PATH] = path ? path : "/",
                        _a[strExpires] = "Thu, 01 Jan 1970 00:00:01 GMT",
                        _a);
                    if (!(0,_EnvUtils__WEBPACK_IMPORTED_MODULE_12__.isIE)()) {
                        // Set max age to expire now
                        values["max-age"] = "0";
                    }
                    // let delCookie = cookieMgrConfig.delCookie || _setCookieValue;
                    _delCookieFn(name, _formatCookieValue(_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY, values));
                    result = true;
                }
                return result;
            }
        },
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_UNLOAD /* @min:unload */] = function (isAsync) {
            unloadHandler && unloadHandler.rm();
            unloadHandler = null;
        },
        _a);
    // Associated this cookie manager with the config
    cookieMgr[strConfigCookieMgr] = cookieMgr;
    return cookieMgr;
}
/*
* Helper method to tell if document.cookie object is supported by the runtime
*/
function areCookiesSupported(logger) {
    if (_supportsCookies === null) {
        _supportsCookies = false;
        !_doc && _getDoc();
        try {
            var doc = _doc.v || {};
            _supportsCookies = doc[strCookie] !== undefined;
        }
        catch (e) {
            (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_14__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 68 /* _eInternalMessageId.CannotAccessCookie */, "Cannot access document.cookie - " + (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.getExceptionName)(e), { exception: (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_15__.dumpObj)(e) });
        }
    }
    return _supportsCookies;
}
function _extractParts(theValue) {
    var values = {};
    if (theValue && theValue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_LENGTH /* @min:%2elength */]) {
        var parts = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.strTrim)(theValue)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_7__._DYN_SPLIT /* @min:%2esplit */](";");
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_16__.arrForEach)(parts, function (thePart) {
            thePart = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.strTrim)(thePart || _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY);
            if (thePart) {
                var idx = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_10__.strIndexOf)(thePart, "=");
                if (idx === -1) {
                    values[thePart] = null;
                }
                else {
                    values[(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.strTrim)((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__.strLeft)(thePart, idx))] = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.strTrim)((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__.strSubstring)(thePart, idx + 1));
                }
            }
        });
    }
    return values;
}
function _formatDate(theDate, func) {
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isFunction)(theDate[func])) {
        return theDate[func]();
    }
    return null;
}
function _formatCookieValue(value, values) {
    var cookieValue = value || _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_17__.objForEachKey)(values, function (name, theValue) {
        cookieValue += "; " + name + (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isNullOrUndefined)(theValue) ? "=" + theValue : _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY);
    });
    return cookieValue;
}
function _getCookieValue(name) {
    var cookieValue = _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
    !_doc && _getDoc();
    if (_doc.v) {
        var theCookie = _doc.v[strCookie] || _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
        if (_parsedCookieValue !== theCookie) {
            _cookieCache = _extractParts(theCookie);
            _parsedCookieValue = theCookie;
        }
        cookieValue = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_9__.strTrim)(_cookieCache[name] || _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY);
    }
    return cookieValue;
}
function _setCookieValue(name, cookieValue) {
    !_doc && _getDoc();
    if (_doc.v) {
        _doc.v[strCookie] = name + "=" + cookieValue;
    }
}
function uaDisallowsSameSiteNone(userAgent) {
    if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.isString)(userAgent)) {
        return false;
    }
    // Cover all iOS based browsers here. This includes:
    // - Safari on iOS 12 for iPhone, iPod Touch, iPad
    // - WkWebview on iOS 12 for iPhone, iPod Touch, iPad
    // - Chrome on iOS 12 for iPhone, iPod Touch, iPad
    // All of which are broken by SameSite=None, because they use the iOS networking stack
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "CPU iPhone OS 12") || (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "iPad; CPU OS 12")) {
        return true;
    }
    // Cover Mac OS X based browsers that use the Mac OS networking stack. This includes:
    // - Safari on Mac OS X
    // This does not include:
    // - Internal browser on Mac OS X
    // - Chrome on Mac OS X
    // - Chromium on Mac OS X
    // Because they do not use the Mac OS networking stack.
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Macintosh; Intel Mac OS X 10_14") && (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Version/") && (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Safari")) {
        return true;
    }
    // Cover Mac OS X internal browsers that use the Mac OS networking stack. This includes:
    // - Internal browser on Mac OS X
    // This does not include:
    // - Safari on Mac OS X
    // - Chrome on Mac OS X
    // - Chromium on Mac OS X
    // Because they do not use the Mac OS networking stack.
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Macintosh; Intel Mac OS X 10_14") && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_18__.strEndsWith)(userAgent, "AppleWebKit/605.1.15 (KHTML, like Gecko)")) {
        return true;
    }
    // Cover Chrome 50-69, because some versions are broken by SameSite=None, and none in this range require it.
    // Note: this covers some pre-Chromium Edge versions, but pre-Chromim Edge does not require SameSite=None, so this is fine.
    // Note: this regex applies to Windows, Mac OS X, and Linux, deliberately.
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Chrome/5") || (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Chrome/6")) {
        return true;
    }
    // Unreal Engine runs Chromium 59, but does not advertise as Chrome until 4.23. Treat versions of Unreal
    // that don't specify their Chrome version as lacking support for SameSite=None.
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "UnrealEngine") && !(0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "Chrome")) {
        return true;
    }
    // UCBrowser < 12.13.2 ignores Set-Cookie headers with SameSite=None
    // NB: this rule isn't complete - you need regex to make a complete rule.
    // See: https://www.chromium.org/updates/same-site/incompatible-clients
    if ((0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "UCBrowser/12") || (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_2__.strContains)(userAgent, "UCBrowser/11")) {
        return true;
    }
    return false;
}
//# sourceMappingURL=CookieMgr.js.map

/***/ }),
/* 85 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   cfgDfBlockPropValue: () => (/* binding */ cfgDfBlockPropValue),
/* harmony export */   cfgDfBoolean: () => (/* binding */ cfgDfBoolean),
/* harmony export */   cfgDfFunc: () => (/* binding */ cfgDfFunc),
/* harmony export */   cfgDfMerge: () => (/* binding */ cfgDfMerge),
/* harmony export */   cfgDfSet: () => (/* binding */ cfgDfSet),
/* harmony export */   cfgDfString: () => (/* binding */ cfgDfString),
/* harmony export */   cfgDfValidate: () => (/* binding */ cfgDfValidate)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(27);
/* harmony import */ var _JavaScriptSDK_InternalConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(34);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(32);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





/**
 * @internal
 * @ignore
 * @param str
 * @param defaultValue
 * @returns
 */
function _stringToBoolOrDefault(theValue, defaultValue, theConfig) {
    if (!theValue && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isNullOrUndefined)(theValue)) {
        return defaultValue;
    }
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isBoolean)(theValue)) {
        return theValue;
    }
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.asString)(theValue)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]() === "true";
}
/**
 * Helper which returns an IConfigDefaultCheck instance with the field defined as an object
 * that should be merged
 * @param defaultValue - The default value to apply it not provided or it's not valid
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfMerge(defaultValue) {
    return {
        mrg: true,
        v: defaultValue
    };
}
/**
 * Helper which returns an IConfigDefaultCheck instance with the provided field set function
 * @param setter - The IConfigCheckFn function to validate the user provided value
 * @param defaultValue - The default value to apply it not provided or it's not valid
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfSet(setter, defaultValue) {
    return {
        set: setter,
        v: defaultValue
    };
}
/**
 * Helper which returns an IConfigDefaultCheck instance with the provided field validator
 * @param validator - The IConfigCheckFn function to validate the user provided value
 * @param defaultValue - The default value to apply it not provided or it's not valid
 * @param fallBackName - The fallback configuration name if the current value is not available
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfValidate(validator, defaultValue, fallBackName) {
    return {
        fb: fallBackName,
        isVal: validator,
        v: defaultValue
    };
}
/**
 * Helper which returns an IConfigDefaultCheck instance that will validate and convert the user
 * provided value to a boolean from a string or boolean value
 * @param defaultValue - The default value to apply it not provided or it's not valid
 * @param fallBackName - The fallback configuration name if the current value is not available
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfBoolean(defaultValue, fallBackName) {
    return {
        fb: fallBackName,
        set: _stringToBoolOrDefault,
        v: !!defaultValue
    };
}
/**
 * Helper which returns an IConfigDefaultCheck instance that will validate that the user
 * provided value is a function.
 * @param defaultValue - The default value to apply it not provided or it's not valid
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfFunc(defaultValue) {
    return {
        isVal: _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isFunction,
        v: defaultValue || null
    };
}
/**
 * Helper which returns an IConfigDefaultCheck instance that will validate that the user
 * provided value is a function.
 * @param defaultValue - The default string value to apply it not provided or it's not valid, defaults to an empty string
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfString(defaultValue) {
    return {
        isVal: _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.isString,
        v: (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.asString)(defaultValue || _JavaScriptSDK_InternalConstants__WEBPACK_IMPORTED_MODULE_3__.STR_EMPTY)
    };
}
/**
 * Helper which returns an IConfigDefaultCheck instance identifying that value associated with this property
 * should not have it's properties converted into a dynamic config properties.
 * @param defaultValue - The default value to apply it not provided or it's not valid
 * @returns a new IConfigDefaultCheck structure
 */
function cfgDfBlockPropValue(defaultValue) {
    var _a;
    return _a = {},
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_BLK_VAL /* @min:blkVal */] = true,
        _a.v = defaultValue,
        _a;
}
//# sourceMappingURL=ConfigDefaultHelpers.js.map

/***/ }),
/* 86 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   strTrim: () => (/* binding */ strTrim),
/* harmony export */   strTrimEnd: () => (/* binding */ strTrimEnd),
/* harmony export */   strTrimLeft: () => (/* binding */ strTrimLeft),
/* harmony export */   strTrimRight: () => (/* binding */ strTrimRight),
/* harmony export */   strTrimStart: () => (/* binding */ strTrimStart)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25);
/* harmony import */ var _polyfills_trim__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */



/**
 * The trim() method removes whitespace from both ends of a string and returns a new string,
 * without modifying the original string. Whitespace in this context is all the whitespace
 * characters (space, tab, no-break space, etc.) and all the line terminator characters
 * (LF, CR, etc.).
 * @group String
 * @param value - The string value to be trimmed.
 * @returns A new string representing str stripped of whitespace from both its beginning and end.
 * If neither the beginning or end of str has any whitespace, a new string is still returned (essentially
 * a copy of str), with no exception being thrown.
 * To return a new string with whitespace trimmed from just one end, use `strTrimStart()` or `strTrimEnd()`.
 */
var strTrim = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunctionWithPoly)("trim", _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto, _polyfills_trim__WEBPACK_IMPORTED_MODULE_2__.polyStrTrim);
/**
 * The `strTrimStart()` method removes whitespace from the beginning of a string.
 * @group String
 * @param value - The value to be trimmed.
 * @returns A new string representing str stripped of whitespace from its beginning (left side).
 * If the beginning of str has no whitespace, a new string is still returned (essentially a copy of str),
 * with no exception being thrown.
 */
var strTrimStart = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunctionWithPoly)("trimStart", _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto, _polyfills_trim__WEBPACK_IMPORTED_MODULE_2__.polyStrTrimStart);
/**
 * Alias for `strTrimStart()` method removes whitespace from the beginning of a string.
 * @group String
 * @param value - The value to be trimmed.
 * @returns A new string representing str stripped of whitespace from its beginning (left side).
 * If the beginning of str has no whitespace, a new string is still returned (essentially a copy of str),
 * with no exception being thrown.
 */
var strTrimLeft = strTrimStart;
/**
 * The `strTrimEnd()` method removes whitespace from the end of a string.
 * @group String
 * @param value - The value to be trimmed.
 * @returns A new string representing str stripped of whitespace from its end (right side).
 * If the end of str has no whitespace, a new string is still returned (essentially a copy of str),
 * with no exception being thrown.
 */
var strTrimEnd = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunctionWithPoly)("trimEnd", _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto, _polyfills_trim__WEBPACK_IMPORTED_MODULE_2__.polyStrTrimEnd);
/**
 * Alias for `strTrimEnd()` method removes whitespace from the end of a string.
 * @group String
 * @param value - The value to be trimmed.
 * @returns A new string representing str stripped of whitespace from its end (right side).
 * If the end of str has no whitespace, a new string is still returned (essentially a copy of str),
 * with no exception being thrown.
 */
var strTrimRight = strTrimEnd;
//# sourceMappingURL=trim.js.map

/***/ }),
/* 87 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   polyStrTrim: () => (/* binding */ polyStrTrim),
/* harmony export */   polyStrTrimEnd: () => (/* binding */ polyStrTrimEnd),
/* harmony export */   polyStrTrimStart: () => (/* binding */ polyStrTrimStart)
/* harmony export */ });
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13);
/* harmony import */ var _helpers_diagnostics__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(26);
/* harmony import */ var _helpers_throw__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */




function _createTrimFn(exp) {
    return function _doTrim(value) {
        if ((0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isNullOrUndefined)(value)) {
            (0,_helpers_throw__WEBPACK_IMPORTED_MODULE_1__.throwTypeError)("strTrim called [" + (0,_helpers_diagnostics__WEBPACK_IMPORTED_MODULE_2__.dumpObj)(value) + "]");
        }
        if (value && value.replace) {
            value = value.replace(exp, _internal_constants__WEBPACK_IMPORTED_MODULE_3__.EMPTY);
        }
        return value;
    };
}
/**
 * The trim() method removes whitespace from both ends of a string and returns a new string,
 * without modifying the original string. Whitespace in this context is all the whitespace
 * characters (space, tab, no-break space, etc.) and all the line terminator characters
 * (LF, CR, etc.).
 * @group Polyfill
 * @group String
 * @param value - The string value to be trimmed.
 * @returns A new string representing str stripped of whitespace from both its beginning and end.
 * If neither the beginning or end of str has any whitespace, a new string is still returned (essentially
 * a copy of str), with no exception being thrown.
 * To return a new string with whitespace trimmed from just one end, use `strTrimStart()` or `strTrimEnd()`.
 */
var polyStrTrim = _createTrimFn(/^\s+|(?=\s)\s+$/g);
/**
 * The `polyStrTrimStart()` method removes whitespace from the beginning of a string.
 * @group Polyfill
 * @group String
 * @param value - The value to be trimmed.
 * @returns A new string representing str stripped of whitespace from its beginning (left side).
 * If the beginning of str has no whitespace, a new string is still returned (essentially a copy of str),
 * with no exception being thrown.
 */
var polyStrTrimStart = _createTrimFn(/^\s+/g);
/**
 * The `polyStrTrimEnd()` method removes whitespace from the end of a string.
 * @group Polyfill
 * @group String
 * @param value - The value to be trimmed.
 * @returns A new string representing str stripped of whitespace from its end (right side).
 * If the end of str has no whitespace, a new string is still returned (essentially a copy of str),
 * with no exception being thrown.
 */
var polyStrTrimEnd = _createTrimFn(/(?=\s)\s+$/g);
//# sourceMappingURL=trim.js.map

/***/ }),
/* 88 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   polyStrEndsWith: () => (/* binding */ polyStrEndsWith),
/* harmony export */   strEndsWith: () => (/* binding */ strEndsWith)
/* harmony export */ });
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13);
/* harmony import */ var _helpers_diagnostics__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26);
/* harmony import */ var _helpers_throw__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(19);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25);
/* harmony import */ var _as_string__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(27);
/* harmony import */ var _substring__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(28);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */







/**
 * This method lets you determine whether or not a string ends with another string. This method is case-sensitive.
 * @group String
 * @param value - The value to be checked
 * @param searchString - The characters to be searched for at the end of `value` string.
 * @param length - If provided, it is used as the length of `value`. Defaults to value.length.
 */
var strEndsWith = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunctionWithPoly)("endsWith", _internal_constants__WEBPACK_IMPORTED_MODULE_1__.StrProto, polyStrEndsWith);
/**
 * This method lets you determine whether or not a string ends with another string. This method is case-sensitive.
 * @group Polyfill
 * @group String
 * @param value - The value to be checked
 * @param searchString - The characters to be searched for at the end of `value` string.
 * @param length - If provided, it is used as the length of `value`. Defaults to value.length.
 */
function polyStrEndsWith(value, searchString, length) {
    if (!(0,_helpers_base__WEBPACK_IMPORTED_MODULE_2__.isString)(value)) {
        (0,_helpers_throw__WEBPACK_IMPORTED_MODULE_3__.throwTypeError)("'" + (0,_helpers_diagnostics__WEBPACK_IMPORTED_MODULE_4__.dumpObj)(value) + "' is not a string");
    }
    var searchValue = (0,_helpers_base__WEBPACK_IMPORTED_MODULE_2__.isString)(searchString) ? searchString : (0,_as_string__WEBPACK_IMPORTED_MODULE_5__.asString)(searchString);
    var chkLen = searchValue[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.LENGTH];
    var len = value[_internal_constants__WEBPACK_IMPORTED_MODULE_1__.LENGTH];
    var end = !(0,_helpers_base__WEBPACK_IMPORTED_MODULE_2__.isUndefined)(length) && length < len ? length : len;
    return (0,_substring__WEBPACK_IMPORTED_MODULE_6__.strSubstring)(value, end - chkLen, end) === searchValue;
}
//# sourceMappingURL=ends_with.js.map

/***/ }),
/* 89 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NotificationManager: () => (/* binding */ NotificationManager)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6);
/* harmony import */ var _nevware21_ts_async__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(71);
/* harmony import */ var _nevware21_ts_async__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(73);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(12);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(58);
/* harmony import */ var _Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(47);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(32);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(34);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */








var defaultValues = {
    perfEvtsSendAll: false
};
function _runListeners(listeners, name, isAsync, callback) {
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(listeners, function (listener) {
        if (listener && listener[name]) {
            if (isAsync) {
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.scheduleTimeout)(function () { return callback(listener); }, 0);
            }
            else {
                try {
                    callback(listener);
                }
                catch (e) {
                    // Catch errors to ensure we don't block sending the requests
                }
            }
        }
    });
}
/**
 * Class to manage sending notifications to all the listeners.
 */
var NotificationManager = /** @class */ (function () {
    function NotificationManager(config) {
        this.listeners = [];
        var perfEvtsSendAll;
        var unloadHandler;
        var _listeners = [];
        var cfgHandler = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_2__.createDynamicConfig)(config, defaultValues);
        unloadHandler = cfgHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_WATCH /* @min:%2ewatch */](function (details) {
            perfEvtsSendAll = !!details.cfg.perfEvtsSendAll;
        });
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_4__["default"])(NotificationManager, this, function (_self) {
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objDefine)(_self, "listeners", {
                g: function () { return _listeners; }
            });
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_ADD_NOTIFICATION_LIS1 /* @min:%2eaddNotificationListener */] = function (listener) {
                _listeners[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_PUSH /* @min:%2epush */](listener);
            };
            /**
             * Removes all instances of the listener.
             * @param listener - AWTNotificationListener to remove.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_REMOVE_NOTIFICATION_2 /* @min:%2eremoveNotificationListener */] = function (listener) {
                var index = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.arrIndexOf)(_listeners, listener);
                while (index > -1) {
                    _listeners[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SPLICE /* @min:%2esplice */](index, 1);
                    index = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.arrIndexOf)(_listeners, listener);
                }
            };
            /**
             * Notification for events sent.
             * @param events - The array of events that have been sent.
             */
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_EVENTS_SENT /* @min:%2eeventsSent */] = function (events) {
                _runListeners(_listeners, _InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_EVENTS_SENT, true, function (listener) {
                    listener[_InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_EVENTS_SENT /* @min:%2eeventsSent */](events);
                });
            };
            /**
             * Notification for events being discarded.
             * @param events - The array of events that have been discarded by the SDK.
             * @param reason - The reason for which the SDK discarded the events. The EventsDiscardedReason
             * constant should be used to check the different values.
             */
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_EVENTS_DISCARDED /* @min:%2eeventsDiscarded */] = function (events, reason) {
                _runListeners(_listeners, _InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_EVENTS_DISCARDED, true, function (listener) {
                    listener[_InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_EVENTS_DISCARDED /* @min:%2eeventsDiscarded */](events, reason);
                });
            };
            /**
             * [Optional] A function called when the events have been requested to be sent to the sever.
             * @param sendReason - The reason why the event batch is being sent.
             * @param isAsync - A flag which identifies whether the requests are being sent in an async or sync manner.
             */
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_EVENTS_SEND_REQUEST /* @min:%2eeventsSendRequest */] = function (sendReason, isAsync) {
                _runListeners(_listeners, _InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_EVENTS_SEND_REQUEST, isAsync, function (listener) {
                    listener[_InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_EVENTS_SEND_REQUEST /* @min:%2eeventsSendRequest */](sendReason, isAsync);
                });
            };
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_PERF_EVENT /* @min:%2eperfEvent */] = function (perfEvent) {
                if (perfEvent) {
                    // Send all events or only parent events
                    if (perfEvtsSendAll || !perfEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_IS_CHILD_EVT /* @min:%2eisChildEvt */]()) {
                        _runListeners(_listeners, _InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_PERF_EVENT, false, function (listener) {
                            if (perfEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_IS_ASYNC /* @min:%2eisAsync */]) {
                                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.scheduleTimeout)(function () { return listener[_InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_PERF_EVENT /* @min:%2eperfEvent */](perfEvent); }, 0);
                            }
                            else {
                                listener[_InternalConstants__WEBPACK_IMPORTED_MODULE_7__.STR_PERF_EVENT /* @min:%2eperfEvent */](perfEvent);
                            }
                        });
                    }
                }
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_UNLOAD /* @min:%2eunload */] = function (isAsync) {
                var _finishUnload = function () {
                    unloadHandler && unloadHandler.rm();
                    unloadHandler = null;
                    _listeners = [];
                };
                var waiting;
                _runListeners(_listeners, "unload", false, function (listener) {
                    var asyncUnload = listener[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_UNLOAD /* @min:%2eunload */](isAsync);
                    if (asyncUnload) {
                        if (!waiting) {
                            waiting = [];
                        }
                        waiting[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_PUSH /* @min:%2epush */](asyncUnload);
                    }
                });
                if (waiting) {
                    return (0,_nevware21_ts_async__WEBPACK_IMPORTED_MODULE_8__.createPromise)(function (resolve) {
                        return (0,_nevware21_ts_async__WEBPACK_IMPORTED_MODULE_9__.doAwaitResponse)((0,_nevware21_ts_async__WEBPACK_IMPORTED_MODULE_8__.createAllPromise)(waiting), function () {
                            _finishUnload();
                            resolve();
                        });
                    });
                }
                else {
                    _finishUnload();
                }
            };
        });
    }
// Removed Stub for NotificationManager.prototype.addNotificationListener.
// Removed Stub for NotificationManager.prototype.removeNotificationListener.
// Removed Stub for NotificationManager.prototype.eventsSent.
// Removed Stub for NotificationManager.prototype.eventsDiscarded.
// Removed Stub for NotificationManager.prototype.eventsSendRequest.
// Removed Stub for NotificationManager.prototype.perfEvent.
// Removed Stub for NotificationManager.prototype.unload.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    NotificationManager.__ieDyn=1;

    return NotificationManager;
}());

//# sourceMappingURL=NotificationManager.js.map

/***/ }),
/* 90 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ProcessTelemetryContext: () => (/* binding */ ProcessTelemetryContext),
/* harmony export */   createProcessTelemetryContext: () => (/* binding */ createProcessTelemetryContext),
/* harmony export */   createProcessTelemetryUnloadContext: () => (/* binding */ createProcessTelemetryUnloadContext),
/* harmony export */   createProcessTelemetryUpdateContext: () => (/* binding */ createProcessTelemetryUpdateContext),
/* harmony export */   createTelemetryPluginProxy: () => (/* binding */ createTelemetryPluginProxy),
/* harmony export */   createTelemetryProxyChain: () => (/* binding */ createTelemetryProxyChain)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(37);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(26);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(15);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(35);
/* harmony import */ var _Config_ConfigDefaults__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(49);
/* harmony import */ var _Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(47);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(32);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(33);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(34);
/* harmony import */ var _PerfManager__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(46);
/* harmony import */ var _TelemetryHelpers__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(91);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */












var strTelemetryPluginChain = "TelemetryPluginChain";
var strHasRunFlags = "_hasRun";
var strGetTelCtx = "_getTelCtx";
var _chainId = 0;
function _getNextProxyStart(proxy, core, startAt) {
    while (proxy) {
        if (proxy[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_PLUGIN /* @min:%2egetPlugin */]() === startAt) {
            return proxy;
        }
        proxy = proxy[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_NEXT /* @min:%2egetNext */]();
    }
    // This wasn't found in the existing chain so create an isolated one with just this plugin
    return createTelemetryProxyChain([startAt], core.config || {}, core);
}
/**
 * @ignore
 * @param telemetryChain
 * @param dynamicHandler
 * @param core
 * @param startAt - Identifies the next plugin to execute, if null there is no "next" plugin and if undefined it should assume the start of the chain
 * @returns
 */
function _createInternalContext(telemetryChain, dynamicHandler, core, startAt) {
    // We have a special case where we want to start execution from this specific plugin
    // or we simply reuse the existing telemetry plugin chain (normal execution case)
    var _nextProxy = null; // By Default set as no next plugin
    var _onComplete = [];
    if (!dynamicHandler) {
        dynamicHandler = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_1__.createDynamicConfig)({}, null, core[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOGGER /* @min:%2elogger */]);
    }
    if (startAt !== null) {
        // There is no next element (null) vs not defined (undefined) so use the full chain
        _nextProxy = startAt ? _getNextProxyStart(telemetryChain, core, startAt) : telemetryChain;
    }
    var context = {
        _next: _moveNext,
        ctx: {
            core: function () {
                return core;
            },
            diagLog: function () {
                return (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_2__.safeGetLogger)(core, dynamicHandler.cfg);
            },
            getCfg: function () {
                return dynamicHandler.cfg;
            },
            getExtCfg: _resolveExtCfg,
            getConfig: _getConfig,
            hasNext: function () {
                return !!_nextProxy;
            },
            getNext: function () {
                return _nextProxy;
            },
            setNext: function (nextPlugin) {
                _nextProxy = nextPlugin;
            },
            iterate: _iterateChain,
            onComplete: _addOnComplete
        }
    };
    function _addOnComplete(onComplete, that) {
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        if (onComplete) {
            _onComplete[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PUSH /* @min:%2epush */]({
                func: onComplete,
                self: !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isUndefined)(that) ? that : context.ctx,
                args: args
            });
        }
    }
    function _moveNext() {
        var nextProxy = _nextProxy;
        // Automatically move to the next plugin
        _nextProxy = nextProxy ? nextProxy[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_NEXT /* @min:%2egetNext */]() : null;
        if (!nextProxy) {
            var onComplete = _onComplete;
            if (onComplete && onComplete[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 0) {
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.arrForEach)(onComplete, function (completeDetails) {
                    try {
                        completeDetails.func.call(completeDetails.self, completeDetails.args);
                    }
                    catch (e) {
                        (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_2__._throwInternal)(core[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LOGGER /* @min:%2elogger */], 2 /* eLoggingSeverity.WARNING */, 73 /* _eInternalMessageId.PluginException */, "Unexpected Exception during onComplete - " + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.dumpObj)(e));
                    }
                });
                _onComplete = [];
            }
        }
        return nextProxy;
    }
    function _getExtCfg(identifier, createIfMissing) {
        var idCfg = null;
        var cfg = dynamicHandler.cfg;
        if (cfg && identifier) {
            var extCfg = cfg[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_EXTENSION_CONFIG /* @min:%2eextensionConfig */];
            if (!extCfg && createIfMissing) {
                extCfg = {};
            }
            // Always set the value so that the property always exists
            cfg[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_EXTENSION_CONFIG] = extCfg; // Note: it is valid for the "value" to be undefined
            // Calling `ref()` has a side effect of causing the referenced property to become dynamic  (if not already)
            extCfg = dynamicHandler.ref(cfg, _InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_EXTENSION_CONFIG);
            if (extCfg) {
                idCfg = extCfg[identifier];
                if (!idCfg && createIfMissing) {
                    idCfg = {};
                }
                // Always set the value so that the property always exists
                extCfg[identifier] = idCfg; // Note: it is valid for the "value" to be undefined
                // Calling `ref()` has a side effect of causing the referenced property to become dynamic  (if not already)
                idCfg = dynamicHandler.ref(extCfg, identifier);
            }
        }
        return idCfg;
    }
    function _resolveExtCfg(identifier, defaultValues) {
        var newConfig = _getExtCfg(identifier, true);
        if (defaultValues) {
            // Enumerate over the defaultValues and if not already populated attempt to
            // find a value from the root config or use the default value
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.objForEachKey)(defaultValues, function (field, defaultValue) {
                // for each unspecified field, set the default value
                if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(newConfig[field])) {
                    var cfgValue = dynamicHandler.cfg[field];
                    if (cfgValue || !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(cfgValue)) {
                        newConfig[field] = cfgValue;
                    }
                }
                (0,_Config_ConfigDefaults__WEBPACK_IMPORTED_MODULE_8__._applyDefaultValue)(dynamicHandler, newConfig, field, defaultValue);
            });
        }
        return dynamicHandler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SET_DF /* @min:%2esetDf */](newConfig, defaultValues);
    }
    function _getConfig(identifier, field, defaultValue) {
        if (defaultValue === void 0) { defaultValue = false; }
        var theValue;
        var extConfig = _getExtCfg(identifier, false);
        var rootConfig = dynamicHandler.cfg;
        if (extConfig && (extConfig[field] || !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(extConfig[field]))) {
            theValue = extConfig[field];
        }
        else if (rootConfig[field] || !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(rootConfig[field])) {
            theValue = rootConfig[field];
        }
        return (theValue || !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(theValue)) ? theValue : defaultValue;
    }
    function _iterateChain(cb) {
        // Keep processing until we reach the end of the chain
        var nextPlugin;
        while (!!(nextPlugin = context._next())) {
            var plugin = nextPlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_PLUGIN /* @min:%2egetPlugin */]();
            if (plugin) {
                // callback with the current on
                cb(plugin);
            }
        }
    }
    return context;
}
/**
 * Creates a new Telemetry Item context with the current config, core and plugin execution chain
 * @param plugins - The plugin instances that will be executed
 * @param config - The current config
 * @param core - The current core instance
 * @param startAt - Identifies the next plugin to execute, if null there is no "next" plugin and if undefined it should assume the start of the chain
 */
function createProcessTelemetryContext(telemetryChain, cfg, core, startAt) {
    var config = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_1__.createDynamicConfig)(cfg);
    var internalContext = _createInternalContext(telemetryChain, config, core, startAt);
    var context = internalContext.ctx;
    function _processNext(env) {
        var nextPlugin = internalContext._next();
        if (nextPlugin) {
            // Run the next plugin which will call "processNext()"
            nextPlugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */](env, context);
        }
        return !nextPlugin;
    }
    function _createNew(plugins, startAt) {
        if (plugins === void 0) { plugins = null; }
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isArray)(plugins)) {
            plugins = createTelemetryProxyChain(plugins, config.cfg, core, startAt);
        }
        return createProcessTelemetryContext(plugins || context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_NEXT /* @min:%2egetNext */](), config.cfg, core, startAt);
    }
    context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */] = _processNext;
    context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CREATE_NEW /* @min:%2ecreateNew */] = _createNew;
    return context;
}
/**
 * Creates a new Telemetry Item context with the current config, core and plugin execution chain for handling the unloading of the chain
 * @param plugins - The plugin instances that will be executed
 * @param config - The current config
 * @param core - The current core instance
 * @param startAt - Identifies the next plugin to execute, if null there is no "next" plugin and if undefined it should assume the start of the chain
 */
function createProcessTelemetryUnloadContext(telemetryChain, core, startAt) {
    var config = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_1__.createDynamicConfig)(core.config);
    var internalContext = _createInternalContext(telemetryChain, config, core, startAt);
    var context = internalContext.ctx;
    function _processNext(unloadState) {
        var nextPlugin = internalContext._next();
        nextPlugin && nextPlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UNLOAD /* @min:%2eunload */](context, unloadState);
        return !nextPlugin;
    }
    function _createNew(plugins, startAt) {
        if (plugins === void 0) { plugins = null; }
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isArray)(plugins)) {
            plugins = createTelemetryProxyChain(plugins, config.cfg, core, startAt);
        }
        return createProcessTelemetryUnloadContext(plugins || context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_NEXT /* @min:%2egetNext */](), core, startAt);
    }
    context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */] = _processNext;
    context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CREATE_NEW /* @min:%2ecreateNew */] = _createNew;
    return context;
}
/**
 * Creates a new Telemetry Item context with the current config, core and plugin execution chain for updating the configuration
 * @param plugins - The plugin instances that will be executed
 * @param config - The current config
 * @param core - The current core instance
 * @param startAt - Identifies the next plugin to execute, if null there is no "next" plugin and if undefined it should assume the start of the chain
 */
function createProcessTelemetryUpdateContext(telemetryChain, core, startAt) {
    var config = (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_1__.createDynamicConfig)(core.config);
    var internalContext = _createInternalContext(telemetryChain, config, core, startAt);
    var context = internalContext.ctx;
    function _processNext(updateState) {
        return context.iterate(function (plugin) {
            if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isFunction)(plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UPDATE /* @min:%2eupdate */])) {
                plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UPDATE /* @min:%2eupdate */](context, updateState);
            }
        });
    }
    function _createNew(plugins, startAt) {
        if (plugins === void 0) { plugins = null; }
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isArray)(plugins)) {
            plugins = createTelemetryProxyChain(plugins, config.cfg, core, startAt);
        }
        return createProcessTelemetryUpdateContext(plugins || context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_GET_NEXT /* @min:%2egetNext */](), core, startAt);
    }
    context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */] = _processNext;
    context[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_CREATE_NEW /* @min:%2ecreateNew */] = _createNew;
    return context;
}
/**
 * Creates an execution chain from the array of plugins
 * @param plugins - The array of plugins that will be executed in this order
 * @param defItemCtx - The default execution context to use when no telemetry context is passed to processTelemetry(), this
 * should be for legacy plugins only. Currently, only used for passing the current core instance and to provide better error
 * reporting (hasRun) when errors occur.
 */
function createTelemetryProxyChain(plugins, config, core, startAt) {
    var firstProxy = null;
    var add = startAt ? false : true;
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isArray)(plugins) && plugins[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 0) {
        // Create the proxies and wire up the next plugin chain
        var lastProxy_1 = null;
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.arrForEach)(plugins, function (thePlugin) {
            if (!add && startAt === thePlugin) {
                add = true;
            }
            if (add && thePlugin && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isFunction)(thePlugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */])) {
                // Only add plugins that are processors
                var newProxy = createTelemetryPluginProxy(thePlugin, config, core);
                if (!firstProxy) {
                    firstProxy = newProxy;
                }
                if (lastProxy_1) {
                    // Set this new proxy as the next for the previous one
                    lastProxy_1._setNext(newProxy);
                }
                lastProxy_1 = newProxy;
            }
        });
    }
    if (startAt && !firstProxy) {
        // Special case where the "startAt" was not in the original list of plugins
        return createTelemetryProxyChain([startAt], config, core);
    }
    return firstProxy;
}
/**
 * Create the processing telemetry proxy instance, the proxy is used to abstract the current plugin to allow monitoring and
 * execution plugins while passing around the dynamic execution state (IProcessTelemetryContext), the proxy instance no longer
 * contains any execution state and can be reused between requests (this was not the case for 2.7.2 and earlier with the
 * TelemetryPluginChain class).
 * @param plugin - The plugin instance to proxy
 * @param config - The default execution context to use when no telemetry context is passed to processTelemetry(), this
 * should be for legacy plugins only. Currently, only used for passing the current core instance and to provide better error
 * reporting (hasRun) when errors occur.
 * @returns
 */
function createTelemetryPluginProxy(plugin, config, core) {
    var nextProxy = null;
    var hasProcessTelemetry = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isFunction)(plugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */]);
    var hasSetNext = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isFunction)(plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SET_NEXT_PLUGIN /* @min:%2esetNextPlugin */]);
    var chainId;
    if (plugin) {
        chainId = plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_IDENTIFIER /* @min:%2eidentifier */] + "-" + plugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_PRIORITY /* @min:%2epriority */] + "-" + _chainId++;
    }
    else {
        chainId = "Unknown-0-" + _chainId++;
    }
    var proxyChain = {
        getPlugin: function () {
            return plugin;
        },
        getNext: function () {
            return nextProxy;
        },
        processTelemetry: _processTelemetry,
        unload: _unloadPlugin,
        update: _updatePlugin,
        _id: chainId,
        _setNext: function (nextPlugin) {
            nextProxy = nextPlugin;
        }
    };
    function _getTelCtx() {
        var itemCtx;
        // Looks like a plugin didn't pass the (optional) context, so create a new one
        if (plugin && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isFunction)(plugin[strGetTelCtx])) {
            // This plugin extends from the BaseTelemetryPlugin so lets use it
            itemCtx = plugin[strGetTelCtx]();
        }
        if (!itemCtx) {
            // Create a temporary one
            itemCtx = createProcessTelemetryContext(proxyChain, config, core);
        }
        return itemCtx;
    }
    function _processChain(itemCtx, processPluginFn, name, details, isAsync) {
        var hasRun = false;
        var identifier = plugin ? plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_IDENTIFIER /* @min:%2eidentifier */] : strTelemetryPluginChain;
        var hasRunContext = itemCtx[strHasRunFlags];
        if (!hasRunContext) {
            // Assign and populate
            hasRunContext = itemCtx[strHasRunFlags] = {};
        }
        // Ensure that we keep the context in sync
        itemCtx.setNext(nextProxy);
        if (plugin) {
            (0,_PerfManager__WEBPACK_IMPORTED_MODULE_9__.doPerf)(itemCtx[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_CORE /* @min:%2ecore */](), function () { return identifier + ":" + name; }, function () {
                // Mark this component as having run
                hasRunContext[chainId] = true;
                try {
                    // Set a flag on the next plugin so we know if it was attempted to be executed
                    var nextId = nextProxy ? nextProxy._id : _InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_EMPTY;
                    if (nextId) {
                        hasRunContext[nextId] = false;
                    }
                    hasRun = processPluginFn(itemCtx);
                }
                catch (error) {
                    var hasNextRun = nextProxy ? hasRunContext[nextProxy._id] : true;
                    if (hasNextRun) {
                        // The next plugin after us has already run so set this one as complete
                        hasRun = true;
                    }
                    if (!nextProxy || !hasNextRun) {
                        // Either we have no next plugin or the current one did not attempt to call the next plugin
                        // Which means the current one is the root of the failure so log/report this failure
                        (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_2__._throwInternal)(itemCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 1 /* eLoggingSeverity.CRITICAL */, 73 /* _eInternalMessageId.PluginException */, "Plugin [" + identifier + "] failed during " + name + " - " + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.dumpObj)(error) + ", run flags: " + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.dumpObj)(hasRunContext));
                    }
                }
            }, details, isAsync);
        }
        return hasRun;
    }
    function _processTelemetry(env, itemCtx) {
        itemCtx = itemCtx || _getTelCtx();
        function _callProcessTelemetry(itemCtx) {
            if (!plugin || !hasProcessTelemetry) {
                return false;
            }
            var pluginState = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_10__._getPluginState)(plugin);
            if (pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TEARDOWN /* @min:%2eteardown */] || pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_DISABLED]) {
                return false;
            }
            // Ensure that we keep the context in sync (for processNext()), just in case a plugin
            // doesn't calls processTelemetry() instead of itemContext.processNext() or some
            // other form of error occurred
            if (hasSetNext) {
                // Backward compatibility setting the next plugin on the instance
                plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SET_NEXT_PLUGIN /* @min:%2esetNextPlugin */](nextProxy);
            }
            plugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */](env, itemCtx);
            // Process Telemetry is expected to call itemCtx.processNext() or nextPlugin.processTelemetry()
            return true;
        }
        if (!_processChain(itemCtx, _callProcessTelemetry, "processTelemetry", function () { return ({ item: env }); }, !(env.sync))) {
            // The underlying plugin is either not defined, not enabled or does not have a processTelemetry implementation
            // so we still want the next plugin to be executed.
            itemCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](env);
        }
    }
    function _unloadPlugin(unloadCtx, unloadState) {
        function _callTeardown() {
            // Setting default of hasRun as false so the proxyProcessFn() is called as teardown() doesn't have to exist or call unloadNext().
            var hasRun = false;
            if (plugin) {
                var pluginState = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_10__._getPluginState)(plugin);
                var pluginCore = plugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_CORE] || pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_CORE /* @min:%2ecore */];
                // Only teardown the plugin if it was initialized by the current core (i.e. It's not a shared plugin)
                if (plugin && (!pluginCore || pluginCore === unloadCtx.core()) && !pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TEARDOWN /* @min:%2eteardown */]) {
                    // Handle plugins that don't extend from the BaseTelemetryPlugin
                    pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_CORE /* @min:%2ecore */] = null;
                    pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TEARDOWN /* @min:%2eteardown */] = true;
                    pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */] = false;
                    if (plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TEARDOWN /* @min:%2eteardown */] && plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TEARDOWN /* @min:%2eteardown */](unloadCtx, unloadState) === true) {
                        // plugin told us that it was going to (or has) call unloadCtx.processNext()
                        hasRun = true;
                    }
                }
            }
            return hasRun;
        }
        if (!_processChain(unloadCtx, _callTeardown, "unload", function () { }, unloadState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_IS_ASYNC /* @min:%2eisAsync */])) {
            // Only called if we hasRun was not true
            unloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](unloadState);
        }
    }
    function _updatePlugin(updateCtx, updateState) {
        function _callUpdate() {
            // Setting default of hasRun as false so the proxyProcessFn() is called as teardown() doesn't have to exist or call unloadNext().
            var hasRun = false;
            if (plugin) {
                var pluginState = (0,_TelemetryHelpers__WEBPACK_IMPORTED_MODULE_10__._getPluginState)(plugin);
                var pluginCore = plugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_CORE] || pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_CORE /* @min:%2ecore */];
                // Only update the plugin if it was initialized by the current core (i.e. It's not a shared plugin)
                if (plugin && (!pluginCore || pluginCore === updateCtx.core()) && !pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TEARDOWN /* @min:%2eteardown */]) {
                    if (plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UPDATE /* @min:%2eupdate */] && plugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_UPDATE /* @min:%2eupdate */](updateCtx, updateState) === true) {
                        // plugin told us that it was going to (or has) call unloadCtx.processNext()
                        hasRun = true;
                    }
                }
            }
            return hasRun;
        }
        if (!_processChain(updateCtx, _callUpdate, "update", function () { }, false)) {
            // Only called if we hasRun was not true
            updateCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](updateState);
        }
    }
    return (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__.objFreeze)(proxyChain);
}
/**
 * This class will be removed!
 * @deprecated use createProcessTelemetryContext() instead
 */
var ProcessTelemetryContext = /** @class */ (function () {
    /**
     * Creates a new Telemetry Item context with the current config, core and plugin execution chain
     * @param plugins - The plugin instances that will be executed
     * @param config - The current config
     * @param core - The current core instance
     */
    function ProcessTelemetryContext(pluginChain, config, core, startAt) {
        var _self = this;
        var context = createProcessTelemetryContext(pluginChain, config, core, startAt);
        // Proxy all functions of the context to this object
        (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_12__.proxyFunctions)(_self, context, (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_11__.objKeys)(context));
    }
    return ProcessTelemetryContext;
}());

//# sourceMappingURL=ProcessTelemetryContext.js.map

/***/ }),
/* 91 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _getPluginState: () => (/* binding */ _getPluginState),
/* harmony export */   createDistributedTraceContext: () => (/* binding */ createDistributedTraceContext),
/* harmony export */   initializePlugins: () => (/* binding */ initializePlugins),
/* harmony export */   sortPlugins: () => (/* binding */ sortPlugins),
/* harmony export */   unloadComponents: () => (/* binding */ unloadComponents)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(13);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(32);
/* harmony import */ var _DataCacheHelper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(48);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(34);
/* harmony import */ var _W3cTraceParent__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(92);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */








var pluginStateData = (0,_DataCacheHelper__WEBPACK_IMPORTED_MODULE_0__.createElmNodeData)("plugin");
function _getPluginState(plugin) {
    return pluginStateData.get(plugin, "state", {}, true);
}
/**
 * Initialize the queue of plugins
 * @param plugins - The array of plugins to initialize and setting of the next plugin
 * @param config - The current config for the instance
 * @param core - THe current core instance
 * @param extensions - The extensions
 */
function initializePlugins(processContext, extensions) {
    // Set the next plugin and identified the uninitialized plugins
    var initPlugins = [];
    var lastPlugin = null;
    var proxy = processContext[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_NEXT /* @min:%2egetNext */]();
    var pluginState;
    while (proxy) {
        var thePlugin = proxy[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_PLUGIN /* @min:%2egetPlugin */]();
        if (thePlugin) {
            if (lastPlugin && lastPlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_NEXT_PLUGIN /* @min:%2esetNextPlugin */] && thePlugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */]) {
                // Set this plugin as the next for the previous one
                lastPlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_NEXT_PLUGIN /* @min:%2esetNextPlugin */](thePlugin);
            }
            pluginState = _getPluginState(thePlugin);
            var isInitialized = !!pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */];
            if (thePlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */]) {
                isInitialized = thePlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */]();
            }
            if (!isInitialized) {
                initPlugins[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](thePlugin);
            }
            lastPlugin = thePlugin;
            proxy = proxy[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_NEXT /* @min:%2egetNext */]();
        }
    }
    // Now initialize the plugins
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrForEach)(initPlugins, function (thePlugin) {
        var core = processContext[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_CORE /* @min:%2ecore */]();
        thePlugin[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_INITIALIZE /* @min:%2einitialize */](processContext.getCfg(), core, extensions, processContext[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_NEXT /* @min:%2egetNext */]());
        pluginState = _getPluginState(thePlugin);
        // Only add the core to the state if the plugin didn't set it (doesn't extend from BaseTelemetryPlugin)
        if (!thePlugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_CORE] && !pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_CORE]) {
            pluginState[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_CORE] = core;
        }
        pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */] = true;
        delete pluginState[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TEARDOWN /* @min:%2eteardown */];
    });
}
function sortPlugins(plugins) {
    // Sort by priority
    return plugins.sort(function (extA, extB) {
        var result = 0;
        if (extB) {
            var bHasProcess = extB[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_PROCESS_TELEMETRY];
            if (extA[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_PROCESS_TELEMETRY]) {
                result = bHasProcess ? extA[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_PRIORITY] - extB[_InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_PRIORITY] : 1;
            }
            else if (bHasProcess) {
                result = -1;
            }
        }
        else {
            result = extA ? 1 : -1;
        }
        return result;
    });
    // sort complete
}
/**
 * Teardown / Unload helper to perform teardown/unloading operations for the provided components synchronously or asynchronously, this will call any
 * _doTeardown() or _doUnload() functions on the provided components to allow them to finish removal.
 * @param components - The components you want to unload
 * @param unloadCtx - This is the context that should be used during unloading.
 * @param unloadState - The details / state of the unload process, it holds details like whether it should be unloaded synchronously or asynchronously and the reason for the unload.
 * @param asyncCallback - An optional callback that the plugin must call if it returns true to inform the caller that it has completed any async unload/teardown operations.
 * @returns boolean - true if the plugin has or will call asyncCallback, this allows the plugin to perform any asynchronous operations.
 */
function unloadComponents(components, unloadCtx, unloadState, asyncCallback) {
    var idx = 0;
    function _doUnload() {
        while (idx < components[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]) {
            var component = components[idx++];
            if (component) {
                var func = component._doUnload || component[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__DO_TEARDOWN /* @min:%2e_doTeardown */];
                if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.isFunction)(func)) {
                    if (func.call(component, unloadCtx, unloadState, _doUnload) === true) {
                        return true;
                    }
                }
            }
        }
    }
    return _doUnload();
}
/**
 * Creates a IDistributedTraceContext which optionally also "sets" the value on a parent
 * @param parentCtx - An optional parent distributed trace instance
 * @returns A new IDistributedTraceContext instance that uses an internal temporary object
 */
function createDistributedTraceContext(parentCtx) {
    var trace = {};
    return {
        getName: function () {
            return trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:%2ename */];
        },
        setName: function (newValue) {
            parentCtx && parentCtx.setName(newValue);
            trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:%2ename */] = newValue;
        },
        getTraceId: function () {
            return trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TRACE_ID /* @min:%2etraceId */];
        },
        setTraceId: function (newValue) {
            parentCtx && parentCtx.setTraceId(newValue);
            if ((0,_W3cTraceParent__WEBPACK_IMPORTED_MODULE_5__.isValidTraceId)(newValue)) {
                trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TRACE_ID /* @min:%2etraceId */] = newValue;
            }
        },
        getSpanId: function () {
            return trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPAN_ID /* @min:%2espanId */];
        },
        setSpanId: function (newValue) {
            parentCtx && parentCtx.setSpanId(newValue);
            if ((0,_W3cTraceParent__WEBPACK_IMPORTED_MODULE_5__.isValidSpanId)(newValue)) {
                trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPAN_ID /* @min:%2espanId */] = newValue;
            }
        },
        getTraceFlags: function () {
            return trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TRACE_FLAGS /* @min:%2etraceFlags */];
        },
        setTraceFlags: function (newTraceFlags) {
            parentCtx && parentCtx.setTraceFlags(newTraceFlags);
            trace[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TRACE_FLAGS /* @min:%2etraceFlags */] = newTraceFlags;
        }
    };
}
//# sourceMappingURL=TelemetryHelpers.js.map

/***/ }),
/* 92 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createTraceParent: () => (/* binding */ createTraceParent),
/* harmony export */   findW3cTraceParent: () => (/* binding */ findW3cTraceParent),
/* harmony export */   formatTraceParent: () => (/* binding */ formatTraceParent),
/* harmony export */   isSampledFlag: () => (/* binding */ isSampledFlag),
/* harmony export */   isValidSpanId: () => (/* binding */ isValidSpanId),
/* harmony export */   isValidTraceId: () => (/* binding */ isValidTraceId),
/* harmony export */   isValidTraceParent: () => (/* binding */ isValidTraceParent),
/* harmony export */   parseTraceParent: () => (/* binding */ parseTraceParent)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(86);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(32);
/* harmony import */ var _CoreUtils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(42);
/* harmony import */ var _EnvUtils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(31);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(34);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





// using {0,16} for leading and trailing whitespace just to constrain the possible runtime of a random string
var TRACE_PARENT_REGEX = /^([\da-f]{2})-([\da-f]{32})-([\da-f]{16})-([\da-f]{2})(-[^\s]{1,64})?$/i;
var DEFAULT_VERSION = "00";
var INVALID_VERSION = "ff";
var INVALID_TRACE_ID = "00000000000000000000000000000000";
var INVALID_SPAN_ID = "0000000000000000";
var SAMPLED_FLAG = 0x01;
function _isValid(value, len, invalidValue) {
    if (value && value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] === len && value !== invalidValue) {
        return !!value.match(/^[\da-f]*$/i);
    }
    return false;
}
function _formatValue(value, len, defValue) {
    if (_isValid(value, len)) {
        return value;
    }
    return defValue;
}
function _formatFlags(value) {
    if (isNaN(value) || value < 0 || value > 255) {
        value = 0x01;
    }
    var result = value.toString(16);
    while (result[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] < 2) {
        result = "0" + result;
    }
    return result;
}
/**
 * Create a new ITraceParent instance using the provided values.
 * @param traceId - The traceId to use, when invalid a new random W3C id will be generated.
 * @param spanId - The parent/span id to use, a new random value will be generated if it is invalid.
 * @param flags - The traceFlags to use, defaults to zero (0) if not supplied or invalid
 * @param version - The version to used, defaults to version "01" if not supplied or invalid.
 * @returns
 */
function createTraceParent(traceId, spanId, flags, version) {
    var _a;
    return _a = {},
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_VERSION /* @min:version */] = _isValid(version, 2, INVALID_VERSION) ? version : DEFAULT_VERSION,
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRACE_ID /* @min:traceId */] = isValidTraceId(traceId) ? traceId : (0,_CoreUtils__WEBPACK_IMPORTED_MODULE_1__.generateW3CId)(),
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SPAN_ID /* @min:spanId */] = isValidSpanId(spanId) ? spanId : (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.strLeft)((0,_CoreUtils__WEBPACK_IMPORTED_MODULE_1__.generateW3CId)(), 16),
        _a.traceFlags = flags >= 0 && flags <= 0xFF ? flags : 1,
        _a;
}
/**
 * Attempt to parse the provided string as a W3C TraceParent header value (https://www.w3.org/TR/trace-context/#traceparent-header)
 *
 * @param value - The value to be parsed
 * @param selectIdx - If the found value is comma separated which is the preferred entry to select, defaults to the first
 * @returns
 */
function parseTraceParent(value, selectIdx) {
    var _a;
    if (!value) {
        // Don't pass a null/undefined or empty string
        return null;
    }
    if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isArray)(value)) {
        // The value may have been encoded on the page into an array so handle this automatically
        value = value[0] || "";
    }
    if (!value || !(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isString)(value) || value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > 8192) {
        // limit potential processing based on total length
        return null;
    }
    if (value.indexOf(",") !== -1) {
        var values = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SPLIT /* @min:%2esplit */](",");
        value = values[selectIdx > 0 && values[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_LENGTH /* @min:%2elength */] > selectIdx ? selectIdx : 0];
    }
    // See https://www.w3.org/TR/trace-context/#versioning-of-traceparent
    var match = TRACE_PARENT_REGEX.exec((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.strTrim)(value));
    if (!match || // No match
        match[1] === INVALID_VERSION || // version ff is forbidden
        match[2] === INVALID_TRACE_ID || // All zeros is considered to be invalid
        match[3] === INVALID_SPAN_ID) { // All zeros is considered to be invalid
        return null;
    }
    return _a = {
            version: (match[1] || _InternalConstants__WEBPACK_IMPORTED_MODULE_5__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */](),
            traceId: (match[2] || _InternalConstants__WEBPACK_IMPORTED_MODULE_5__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */](),
            spanId: (match[3] || _InternalConstants__WEBPACK_IMPORTED_MODULE_5__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]()
        },
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRACE_FLAGS /* @min:traceFlags */] = parseInt(match[4], 16),
        _a;
}
/**
 * Is the provided W3c Trace Id a valid string representation, it must be a 32-character string
 * of lowercase hexadecimal characters for example, 4bf92f3577b34da6a3ce929d0e0e4736.
 * If all characters as zero (00000000000000000000000000000000) it will be considered an invalid value.
 * @param value - The W3c trace Id to be validated
 * @returns true if valid otherwise false
 */
function isValidTraceId(value) {
    return _isValid(value, 32, INVALID_TRACE_ID);
}
/**
 * Is the provided W3c span id (aka. parent id) a valid string representation, it must be a 16-character
 * string of lowercase hexadecimal characters, for example, 00f067aa0ba902b7.
 * If all characters are zero (0000000000000000) this is considered an invalid value.
 * @param value - The W3c span id to be validated
 * @returns true if valid otherwise false
 */
function isValidSpanId(value) {
    return _isValid(value, 16, INVALID_SPAN_ID);
}
/**
 * Validates that the provided ITraceParent instance conforms to the currently supported specifications
 * @param value
 * @returns
 */
function isValidTraceParent(value) {
    if (!value ||
        !_isValid(value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_VERSION /* @min:%2eversion */], 2, INVALID_VERSION) ||
        !_isValid(value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRACE_ID /* @min:%2etraceId */], 32, INVALID_TRACE_ID) ||
        !_isValid(value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_SPAN_ID /* @min:%2espanId */], 16, INVALID_SPAN_ID) ||
        !_isValid(_formatFlags(value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRACE_FLAGS /* @min:%2etraceFlags */]), 2)) {
        // Each known field must contain a valid value
        return false;
    }
    return true;
}
/**
 * Is the parsed traceParent indicating that the trace is currently sampled.
 * @param value - The parsed traceParent value
 * @returns
 */
function isSampledFlag(value) {
    if (isValidTraceParent(value)) {
        return (value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRACE_FLAGS /* @min:%2etraceFlags */] & SAMPLED_FLAG) === SAMPLED_FLAG;
    }
    return false;
}
/**
 * Format the ITraceParent value as a string using the supported and know version formats.
 * So even if the passed traceParent is a later version the string value returned from this
 * function will convert it to only the known version formats.
 * This currently only supports version "00" and invalid "ff"
 * @param value - The parsed traceParent value
 * @returns
 */
function formatTraceParent(value) {
    if (value) {
        // Special Note: This only supports formatting as version 00, future versions should encode any known supported version
        // So parsing a future version will populate the correct version value but reformatting will reduce it to version 00.
        var flags = _formatFlags(value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_TRACE_FLAGS /* @min:%2etraceFlags */]);
        if (!_isValid(flags, 2)) {
            flags = "01";
        }
        var version = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_VERSION /* @min:%2eversion */] || DEFAULT_VERSION;
        if (version !== "00" && version !== "ff") {
            // Reduce version to "00"
            version = DEFAULT_VERSION;
        }
        // Format as version 00
        return "".concat(version.toLowerCase(), "-").concat(_formatValue(value.traceId, 32, INVALID_TRACE_ID).toLowerCase(), "-").concat(_formatValue(value.spanId, 16, INVALID_SPAN_ID).toLowerCase(), "-").concat(flags.toLowerCase());
    }
    return "";
}
/**
 * Helper function to fetch the passed traceparent from the page, looking for it as a meta-tag or a Server-Timing header.
 * @param selectIdx - If the found value is comma separated which is the preferred entry to select, defaults to the first
 * @returns
 */
function findW3cTraceParent(selectIdx) {
    var name = "traceparent";
    var traceParent = parseTraceParent((0,_EnvUtils__WEBPACK_IMPORTED_MODULE_6__.findMetaTag)(name), selectIdx);
    if (!traceParent) {
        traceParent = parseTraceParent((0,_EnvUtils__WEBPACK_IMPORTED_MODULE_6__.findNamedServerTiming)(name), selectIdx);
    }
    return traceParent;
}
//# sourceMappingURL=W3cTraceParent.js.map

/***/ }),
/* 93 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TelemetryInitializerPlugin: () => (/* binding */ TelemetryInitializerPlugin)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(44);
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(26);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(32);
/* harmony import */ var _BaseTelemetryPlugin__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(94);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(67);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(33);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(34);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */
// 
// 








function _addInitializer(_initializers, id, telemetryInitializer) {
    var theInitializer = {
        id: id,
        fn: telemetryInitializer
    };
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.arrAppend)(_initializers, theInitializer);
    var handler = {
        remove: function () {
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(_initializers, function (initializer, idx) {
                if (initializer.id === theInitializer.id) {
                    _initializers[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_SPLICE /* @min:%2esplice */](idx, 1);
                    return -1;
                }
            });
        }
    };
    return handler;
}
function _runInitializers(_initializers, item, logger) {
    var doNotSendItem = false;
    var telemetryInitializersCount = _initializers[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */];
    for (var i = 0; i < telemetryInitializersCount; ++i) {
        var telemetryInitializer = _initializers[i];
        if (telemetryInitializer) {
            try {
                if (telemetryInitializer.fn[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_APPLY /* @min:%2eapply */](null, [item]) === false) {
                    doNotSendItem = true;
                    break;
                }
            }
            catch (e) {
                // log error but dont stop executing rest of the telemetry initializers
                // doNotSendItem = true;
                (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_3__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 64 /* _eInternalMessageId.TelemetryInitializerFailed */, "Telemetry initializer failed: " + (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_4__.getExceptionName)(e), { exception: (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.dumpObj)(e) }, true);
            }
        }
    }
    return !doNotSendItem;
}
var TelemetryInitializerPlugin = /** @class */ (function (_super) {
    (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_6__.__extendsFn)(TelemetryInitializerPlugin, _super);
    function TelemetryInitializerPlugin() {
        var _this = _super.call(this) || this;
        _this.identifier = "TelemetryInitializerPlugin";
        _this.priority = 199;
        // NOTE!: DON'T set default values here, instead set them in the _initDefaults() function as it is also called during teardown()
        var _id;
        var _initializers;
        _initDefaults();
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_7__["default"])(TelemetryInitializerPlugin, _this, function (_self, _base) {
            _self.addTelemetryInitializer = function (telemetryInitializer) {
                return _addInitializer(_initializers, _id++, telemetryInitializer);
            };
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_8__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */] = function (item, itemCtx) {
                if (_runInitializers(_initializers, item, itemCtx ? itemCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DIAG_LOG /* @min:%2ediagLog */]() : _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_DIAG_LOG /* @min:%2ediagLog */]())) {
                    _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](item, itemCtx);
                }
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN__DO_TEARDOWN /* @min:%2e_doTeardown */] = function () {
                _initDefaults();
            };
        });
        function _initDefaults() {
            _id = 0;
            _initializers = [];
        }
        return _this;
    }
// Removed Stub for TelemetryInitializerPlugin.prototype.addTelemetryInitializer.
// Removed Stub for TelemetryInitializerPlugin.prototype.processTelemetry.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    TelemetryInitializerPlugin.__ieDyn=1;

    return TelemetryInitializerPlugin;
}(_BaseTelemetryPlugin__WEBPACK_IMPORTED_MODULE_9__.BaseTelemetryPlugin));

//# sourceMappingURL=TelemetryInitializerPlugin.js.map

/***/ }),
/* 94 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseTelemetryPlugin: () => (/* binding */ BaseTelemetryPlugin)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(12);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(13);
/* harmony import */ var _Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(47);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(32);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(67);
/* harmony import */ var _HelperFuncs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34);
/* harmony import */ var _ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(90);
/* harmony import */ var _UnloadHandlerContainer__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(95);
/* harmony import */ var _UnloadHookContainer__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(96);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */



var _a;










var strGetPlugin = "getPlugin";
var defaultValues = (_a = {},
    _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EXTENSION_CONFIG] = { isVal: _HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.isNotNullOrUndefined, v: {} },
    _a);
/**
 * BaseTelemetryPlugin provides a basic implementation of the ITelemetryPlugin interface so that plugins
 * can avoid implementation the same set of boiler plate code as well as provide a base
 * implementation so that new default implementations can be added without breaking all plugins.
 */
var BaseTelemetryPlugin = /** @class */ (function () {
    function BaseTelemetryPlugin() {
        var _self = this; // Setting _self here as it's used outside of the dynamicProto as well
        // NOTE!: DON'T set default values here, instead set them in the _initDefaults() function as it is also called during teardown()
        var _isinitialized;
        var _rootCtx; // Used as the root context, holding the current config and initialized core
        var _nextPlugin; // Used for backward compatibility where plugins don't call the main pipeline
        var _unloadHandlerContainer;
        var _hookContainer;
        _initDefaults();
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_2__["default"])(BaseTelemetryPlugin, _self, function (_self) {
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_INITIALIZE /* @min:%2einitialize */] = function (config, core, extensions, pluginChain) {
                _setDefaults(config, core, pluginChain);
                _isinitialized = true;
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_TEARDOWN /* @min:%2eteardown */] = function (unloadCtx, unloadState) {
                var _a;
                // If this plugin has already been torn down (not operational) or is not initialized (core is not set)
                // or the core being used for unload was not the same core used for initialization.
                var core = _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CORE /* @min:%2ecore */];
                if (!core || (unloadCtx && core !== unloadCtx[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CORE /* @min:%2ecore */]())) {
                    // Do Nothing as either the plugin is not initialized or was not initialized by the current core
                    return;
                }
                var result;
                var unloadDone = false;
                var theUnloadCtx = unloadCtx || (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_4__.createProcessTelemetryUnloadContext)(null, core, _nextPlugin && _nextPlugin[strGetPlugin] ? _nextPlugin[strGetPlugin]() : _nextPlugin);
                var theUnloadState = unloadState || (_a = {
                        reason: 0 /* TelemetryUnloadReason.ManualTeardown */
                    },
                    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_IS_ASYNC /* @min:isAsync */] = false,
                    _a);
                function _unloadCallback() {
                    if (!unloadDone) {
                        unloadDone = true;
                        _unloadHandlerContainer.run(theUnloadCtx, unloadState);
                        _hookContainer.run(theUnloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_DIAG_LOG /* @min:%2ediagLog */]());
                        if (result === true) {
                            theUnloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](theUnloadState);
                        }
                        _initDefaults();
                    }
                }
                if (!_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN__DO_TEARDOWN /* @min:%2e_doTeardown */] || _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN__DO_TEARDOWN /* @min:%2e_doTeardown */](theUnloadCtx, theUnloadState, _unloadCallback) !== true) {
                    _unloadCallback();
                }
                else {
                    // Tell the caller that we will be calling processNext()
                    result = true;
                }
                return result;
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_UPDATE /* @min:%2eupdate */] = function (updateCtx, updateState) {
                // If this plugin has already been torn down (not operational) or is not initialized (core is not set)
                // or the core being used for unload was not the same core used for initialization.
                var core = _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CORE /* @min:%2ecore */];
                if (!core || (updateCtx && core !== updateCtx[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CORE /* @min:%2ecore */]())) {
                    // Do Nothing
                    return;
                }
                var result;
                var updateDone = false;
                var theUpdateCtx = updateCtx || (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_4__.createProcessTelemetryUpdateContext)(null, core, _nextPlugin && _nextPlugin[strGetPlugin] ? _nextPlugin[strGetPlugin]() : _nextPlugin);
                var theUpdateState = updateState || {
                    reason: 0 /* TelemetryUpdateReason.Unknown */
                };
                function _updateCallback() {
                    if (!updateDone) {
                        updateDone = true;
                        _setDefaults(theUpdateCtx.getCfg(), theUpdateCtx.core(), theUpdateCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_GET_NEXT /* @min:%2egetNext */]());
                    }
                }
                if (!_self._doUpdate || _self._doUpdate(theUpdateCtx, theUpdateState, _updateCallback) !== true) {
                    _updateCallback();
                }
                else {
                    result = true;
                }
                return result;
            };
            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.proxyFunctionAs)(_self, "_addUnloadCb", function () { return _unloadHandlerContainer; }, "add");
            (0,_HelperFuncs__WEBPACK_IMPORTED_MODULE_1__.proxyFunctionAs)(_self, "_addHook", function () { return _hookContainer; }, "add");
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objDefine)(_self, "_unloadHooks", { g: function () { return _hookContainer; } });
        });
        // These are added after the dynamicProto so that are not moved to the prototype
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_DIAG_LOG /* @min:%2ediagLog */] = function (itemCtx) {
            return _getTelCtx(itemCtx)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_DIAG_LOG /* @min:%2ediagLog */]();
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_IS_INITIALIZED /* @min:%2eisInitialized */] = function () {
            return _isinitialized;
        };
        _self.setInitialized = function (isInitialized) {
            _isinitialized = isInitialized;
        };
        // _self.getNextPlugin = () => DO NOT IMPLEMENT
        // Sub-classes of this base class *should* not be relying on this value and instead
        // should use processNext() function. If you require access to the plugin use the
        // IProcessTelemetryContext.getNext().getPlugin() while in the pipeline, Note getNext() may return null.
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SET_NEXT_PLUGIN /* @min:%2esetNextPlugin */] = function (next) {
            _nextPlugin = next;
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */] = function (env, itemCtx) {
            if (itemCtx) {
                // Normal core execution sequence
                itemCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_PROCESS_NEXT /* @min:%2eprocessNext */](env);
            }
            else if (_nextPlugin && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.isFunction)(_nextPlugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */])) {
                // Looks like backward compatibility or out of band processing. And as it looks
                // like a ITelemetryPlugin or ITelemetryPluginChain, just call processTelemetry
                _nextPlugin[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_PROCESS_TELEMETRY /* @min:%2eprocessTelemetry */](env, null);
            }
        };
        _self._getTelCtx = _getTelCtx;
        function _getTelCtx(currentCtx) {
            if (currentCtx === void 0) { currentCtx = null; }
            var itemCtx = currentCtx;
            if (!itemCtx) {
                var rootCtx = _rootCtx || (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_4__.createProcessTelemetryContext)(null, {}, _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CORE /* @min:%2ecore */]);
                // tslint:disable-next-line: prefer-conditional-expression
                if (_nextPlugin && _nextPlugin[strGetPlugin]) {
                    // Looks like a chain object
                    itemCtx = rootCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_CREATE_NEW /* @min:%2ecreateNew */](null, _nextPlugin[strGetPlugin]);
                }
                else {
                    itemCtx = rootCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_CREATE_NEW /* @min:%2ecreateNew */](null, _nextPlugin);
                }
            }
            return itemCtx;
        }
        function _setDefaults(config, core, pluginChain) {
            // Make sure the extensionConfig exists and the config is dynamic
            (0,_Config_DynamicConfig__WEBPACK_IMPORTED_MODULE_7__.createDynamicConfig)(config, defaultValues, (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_8__.safeGetLogger)(core));
            if (!pluginChain && core) {
                // Get the first plugin from the core
                pluginChain = core[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_GET_PROCESS_TEL_CONT0 /* @min:%2egetProcessTelContext */]()[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_GET_NEXT /* @min:%2egetNext */]();
            }
            var nextPlugin = _nextPlugin;
            if (_nextPlugin && _nextPlugin[strGetPlugin]) {
                // If it looks like a proxy/chain then get the plugin
                nextPlugin = _nextPlugin[strGetPlugin]();
            }
            // Support legacy plugins where core was defined as a property
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CORE /* @min:%2ecore */] = core;
            _rootCtx = (0,_ProcessTelemetryContext__WEBPACK_IMPORTED_MODULE_4__.createProcessTelemetryContext)(pluginChain, config, core, nextPlugin);
        }
        function _initDefaults() {
            _isinitialized = false;
            _self[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CORE /* @min:%2ecore */] = null;
            _rootCtx = null;
            _nextPlugin = null;
            _hookContainer = (0,_UnloadHookContainer__WEBPACK_IMPORTED_MODULE_9__.createUnloadHookContainer)();
            _unloadHandlerContainer = (0,_UnloadHandlerContainer__WEBPACK_IMPORTED_MODULE_10__.createUnloadHandlerContainer)();
        }
    }
// Removed Stub for BaseTelemetryPlugin.prototype.initialize.
// Removed Stub for BaseTelemetryPlugin.prototype.teardown.
// Removed Stub for BaseTelemetryPlugin.prototype.update.
// Removed Stub for BaseTelemetryPlugin.prototype._addUnloadCb.
// Removed Stub for BaseTelemetryPlugin.prototype._addHook.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    BaseTelemetryPlugin.__ieDyn=1;

    return BaseTelemetryPlugin;
}());

//# sourceMappingURL=BaseTelemetryPlugin.js.map

/***/ }),
/* 95 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createUnloadHandlerContainer: () => (/* binding */ createUnloadHandlerContainer)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(26);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(32);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */





function createUnloadHandlerContainer() {
    var handlers = [];
    function _addHandler(handler) {
        if (handler) {
            handlers[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_PUSH /* @min:%2epush */](handler);
        }
    }
    function _runHandlers(unloadCtx, unloadState) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_1__.arrForEach)(handlers, function (handler) {
            try {
                handler(unloadCtx, unloadState);
            }
            catch (e) {
                (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_2__._throwInternal)(unloadCtx[_DynamicConstants__WEBPACK_IMPORTED_MODULE_0__._DYN_DIAG_LOG /* @min:%2ediagLog */](), 2 /* eLoggingSeverity.WARNING */, 73 /* _eInternalMessageId.PluginException */, "Unexpected error calling unload handler - " + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.dumpObj)(e));
            }
        });
        handlers = [];
    }
    return {
        add: _addHandler,
        run: _runHandlers
    };
}
//# sourceMappingURL=UnloadHandlerContainer.js.map

/***/ }),
/* 96 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createUnloadHookContainer: () => (/* binding */ createUnloadHookContainer)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(26);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97);
/* harmony import */ var _DiagnosticLogger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */




/**
 * Create a IUnloadHookContainer which can be used to remember unload hook functions to be executed during the component unloading
 * process.
 * @returns A new IUnloadHookContainer instance
 */
function createUnloadHookContainer() {
    var _hooks = [];
    function _doUnload(logger) {
        var oldHooks = _hooks;
        _hooks = [];
        // Remove all registered unload hooks
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(oldHooks, function (fn) {
            // allow either rm or remove callback function
            try {
                (fn.rm || fn.remove).call(fn);
            }
            catch (e) {
                (0,_DiagnosticLogger__WEBPACK_IMPORTED_MODULE_1__._throwInternal)(logger, 2 /* eLoggingSeverity.WARNING */, 73 /* _eInternalMessageId.PluginException */, "Unloading:" + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.dumpObj)(e));
            }
        });
    }
    function _addHook(hooks) {
        if (hooks) {
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrAppend)(_hooks, hooks);
        }
    }
    return {
        run: _doUnload,
        add: _addHook
    };
}
//# sourceMappingURL=UnloadHookContainer.js.map

/***/ }),
/* 97 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   arrAppend: () => (/* binding */ arrAppend)
/* harmony export */ });
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13);
/* harmony import */ var _iterator_iterator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(98);
/* harmony import */ var _iterator_forOf__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(99);
/* harmony import */ var _funcs_fnApply__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(63);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */




/**
 * Appends the `elms` to the `target` where the elms may be an array, a single object
 * or an iterator object
 * @group Array
 * @group Iterator
 * @example
 * ```ts
 * let theArray = arrAppend([], 1);
 * arrAppend(theArray, [ 2, 3, 4 ]);
 * arrAppend(theArray, [ "a", "b", "c" ]);
 * // theArray is now [ 1, 2, 3, 4, "a", "b", "c" ]
 * ```
 * @param target - The target array
 * @param elms - The item, array of items an iterable or iterator object of items to add to the target
 * @returns The passed in target array
 * @example
 * ```ts
 * // Adding a single value
 * arrAppend([], undefined);            // []
 * arrAppend([], 0);                    // [ 0 ]
 * arrAppend([1], undefined);           // [ 1 ]
 * arrAppend([1], 2);                   // [ 1, 2 ]
 *
 * // Adding an array
 * arrAppend([], [] as number[]);       // []
 * arrAppend([], [0]);                  // [ 0 ]
 * arrAppend([1], []);                  // [ 1 ]
 * arrAppend([1], [2]);                 // [ 1, 2 ]
 *
 * // Adding with an iterator
 * arrAppend([], ([] as number[]).values());    // []
 * arrAppend([], [0].values());         // [ 0 ]
 * arrAppend([1], [].keys());           // [ 1 ]
 * arrAppend([1], [2].values());        // [ 1, 2 ]
 * arrAppend([1], [2].keys());          // [ 1, 0 ] - 0 is from the index from the first element
 * ```
 */
function arrAppend(target, elms) {
    if (!(0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isUndefined)(elms) && target) {
        if ((0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isArray)(elms)) {
            // This is not just "target.push(elms)" but becomes effectively "target.push(elms[0], elms[1], ...)"
            (0,_funcs_fnApply__WEBPACK_IMPORTED_MODULE_1__.fnApply)(target.push, target, elms);
        }
        else if ((0,_iterator_iterator__WEBPACK_IMPORTED_MODULE_2__.isIterator)(elms) || (0,_iterator_iterator__WEBPACK_IMPORTED_MODULE_2__.isIterable)(elms)) {
            (0,_iterator_forOf__WEBPACK_IMPORTED_MODULE_3__.iterForOf)(elms, function (elm) {
                target.push(elm);
            });
        }
        else {
            target.push(elms);
        }
    }
    return target;
}
//# sourceMappingURL=append.js.map

/***/ }),
/* 98 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isIterable: () => (/* binding */ isIterable),
/* harmony export */   isIterator: () => (/* binding */ isIterator)
/* harmony export */ });
/* harmony import */ var _symbol_symbol__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(52);
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * Checks if the type of value looks like an iterator instance (contains a next function).
 *
 * @since 0.4.0
 * @group Type Identity
 * @group Iterator
 * @typeParam T - Identifies the return type of the iterator defaults to any
 * @param value - The value to be checked
 * @returns {boolean} True if the value is an Iterator, otherwise false
 * @example
 * ```ts
 * isIterator(null);        // false
 * isIterator(undefined);   // false
 * isIterator("null");      // false (Strings are iterable but not iterators)
 * isIterator([]);          // false (Arrays are iterable but not iterators)
 * isIterator({
 *     next: function() { return true }
 * });                      // true, iterators must contain a "next" function
 * ```
 */
function isIterator(value) {
    return !!value && (0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isFunction)(value.next);
}
/**
 * Checks if the value looks like it is iterable, contains a [symbol.iterator].
 *
 * @since 0.4.0
 * @group Type Identity
 * @group Iterator
 * @typeParam T - Identifies the return type of the iterator
 * @param value - The value to be checked
 * @returns {boolean} True if the value is an Iterable, otherwise false
 * @example
 * ```ts
 * isIterable(null);        // false
 * isIterable(undefined);   // false
 * isIterable("null");      // true (Strings are iterable)
 * isIterable([]);          // true (Arrays are iterable)
 * ```
 */
function isIterable(value) {
    return !(0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isStrictNullOrUndefined)(value) && (0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isFunction)(value[(0,_symbol_symbol__WEBPACK_IMPORTED_MODULE_1__.getKnownSymbol)(3 /* WellKnownSymbols.iterator */)]);
}
//# sourceMappingURL=iterator.js.map

/***/ }),
/* 99 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   iterForOf: () => (/* binding */ iterForOf)
/* harmony export */ });
/* harmony import */ var _helpers_lazy__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8);
/* harmony import */ var _symbol_symbol__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(52);
/* harmony import */ var _iterator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */




var _iterSymbol;
/**
 * Calls the provided `callbackFn` function once for each element in the iterator or iterator returned by
 * the iterable and processed in the same order as returned by the iterator. As with the {@link arrForEach}
 * you CAN stop / break the iteration by returning -1 from the`callbackFn` function.
 *
 * The order of processing is not reset if you add or remove elements to the iterator, the actual behavior
 * will depend on the iterator imeplementation.
 *
 * If the passed `iter` is both an Iterable<T> and Iterator<T> the Iterator<T> interface takes preceedence.
 * @remarks
 * If Symbols are NOT supported then the iterable MUST be using the same polyFill for the well know symbols,
 * if you are targetting a mixed environment you SHOULD either
 * - only use the polyfill Symbol's provided by this library
 * - ensure that you add any symbol polyfills BEFORE these utilities
 * iterForOf expects a `synchronous` function.
 * iterForOf does not wait for promises. Make sure you are aware of the implications while using
 * promises (or async functions) as forEach callback.
 *
 * @since 0.4.2
 * @group Iterator
 * @typeParam T - Identifies the element type of the iterator
 * @param callbackfn A `synchronous` function that accepts up to three arguments. iterForOf calls the
 * callbackfn function one time for each element returned by the iterator.
 * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is
 * omitted, null or undefined the iterator will be used as the this value.
 * @throws Any exception thrown while processing the iterator
 * @example
 * ```ts
 * const items = {
 *     'item1': 'value1',
 *     'item2': 'value2',
 *     'item3': 'value3
 * };
 * const copyItems = [];
 *
 * iterForOf(items, (item) => {
 *   copyItems.push(item);
 *   // May return -1 to abort the iteration
 * });
 * ```
 */
function iterForOf(iter, callbackfn, thisArg) {
    if (iter) {
        if (!(0,_iterator__WEBPACK_IMPORTED_MODULE_0__.isIterator)(iter)) {
            !_iterSymbol && (_iterSymbol = (0,_helpers_lazy__WEBPACK_IMPORTED_MODULE_1__.getLazy)(function () { return (0,_symbol_symbol__WEBPACK_IMPORTED_MODULE_2__.getKnownSymbol)(3 /* WellKnownSymbols.iterator */); }));
            iter = iter[_iterSymbol.v] ? iter[_iterSymbol.v]() : null;
        }
        if ((0,_iterator__WEBPACK_IMPORTED_MODULE_0__.isIterator)(iter)) {
            var err = void 0;
            var iterResult = void 0;
            try {
                var count = 0;
                while (!(iterResult = iter.next())[_internal_constants__WEBPACK_IMPORTED_MODULE_3__.DONE]) {
                    if (callbackfn.call(thisArg || iter, iterResult[_internal_constants__WEBPACK_IMPORTED_MODULE_3__.VALUE], count, iter) === -1) {
                        break;
                    }
                    count++;
                }
            }
            catch (failed) {
                err = { e: failed };
                if (iter.throw) {
                    iterResult = null;
                    iter.throw(err);
                }
            }
            finally {
                try {
                    if (iterResult && !iterResult[_internal_constants__WEBPACK_IMPORTED_MODULE_3__.DONE]) {
                        iter.return && iter.return(iterResult);
                    }
                }
                finally {
                    if (err) {
                        // eslint-disable-next-line no-unsafe-finally
                        throw err.e;
                    }
                }
            }
        }
    }
}
//# sourceMappingURL=forOf.js.map

/***/ }),
/* 100 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   deepExtend: () => (/* binding */ deepExtend),
/* harmony export */   objExtend: () => (/* binding */ objExtend)
/* harmony export */ });
/* harmony import */ var _array_forEach__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37);
/* harmony import */ var _array_slice__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(62);
/* harmony import */ var _object_copy__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(101);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */



/**
 * @internal
 * @ignore
 */
function _doExtend(target, theArgs) {
    (0,_array_forEach__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(theArgs, function (theArg) {
        (0,_object_copy__WEBPACK_IMPORTED_MODULE_1__.objCopyProps)(target, theArg);
    });
    return target;
}
function deepExtend(target, obj1, obj2, obj3, obj4, obj5, obj6) {
    return _doExtend((0,_object_copy__WEBPACK_IMPORTED_MODULE_1__.objDeepCopy)(target) || {}, (0,_array_slice__WEBPACK_IMPORTED_MODULE_2__.arrSlice)(arguments));
}
function objExtend(target, obj1, obj2, obj3, obj4, obj5, obj6) {
    return _doExtend(target || {}, (0,_array_slice__WEBPACK_IMPORTED_MODULE_2__.arrSlice)(arguments));
}
//# sourceMappingURL=extend.js.map

/***/ }),
/* 101 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   arrayDeepCopyHandler: () => (/* binding */ arrayDeepCopyHandler),
/* harmony export */   dateDeepCopyHandler: () => (/* binding */ dateDeepCopyHandler),
/* harmony export */   functionDeepCopyHandler: () => (/* binding */ functionDeepCopyHandler),
/* harmony export */   objCopyProps: () => (/* binding */ objCopyProps),
/* harmony export */   objDeepCopy: () => (/* binding */ objDeepCopy),
/* harmony export */   plainObjDeepCopyHandler: () => (/* binding */ plainObjDeepCopyHandler)
/* harmony export */ });
/* harmony import */ var _array_forEach__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37);
/* harmony import */ var _funcs_fnCall__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(39);
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _define__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(12);
/* harmony import */ var _is_plain_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(38);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */






/**
 * @internal
 * @ignore
 * Generic Object deep copy handler which creates a new plain object and copies enumerable properties from
 * the source to the new target plain object. The source object does not have to be a plain object.
 * @param details - The details object for the current property being copied
 * @returns true if the handler processed the field.
 */
var _defaultDeepCopyHandler = function (details) {
    // Make sure we at least copy plain objects
    details.value && plainObjDeepCopyHandler(details);
    // Always return true so that the iteration completes
    return true;
};
/**
 * @internal
 * @ignore
 * The ordered default deep copy handlers
 */
var defaultDeepCopyHandlers = [
    arrayDeepCopyHandler,
    plainObjDeepCopyHandler,
    functionDeepCopyHandler,
    dateDeepCopyHandler
];
/**
 * @internal
 * @ignore
 * Helper function used for detecting and handling recursive properties
 * @param visitMap - The current map of objects that have been visited
 * @param source - The value (object) to be copied
 * @param newPath - The new access path from the origin to the current property
 * @param cb - The callback function to call if the current object has not already been processed.
 * @returns The new deep copied property, may be incomplete as the object is recursive and is still in the process of being copied
 */
function _getSetVisited(visitMap, source, newPath, cb) {
    var theEntry;
    (0,_array_forEach__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(visitMap, function (entry) {
        if (entry.k === source) {
            theEntry = entry;
            return -1;
        }
    });
    if (!theEntry) {
        // Add the target to the visit map so that deep nested objects refer to the single instance
        // Even if we have not finished processing it yet.
        theEntry = { k: source, v: source };
        visitMap.push(theEntry);
        // Now call the copy callback so that it populates the target
        cb(theEntry);
    }
    return theEntry.v;
}
/**
 * @internal
 * @ignore
 * Internal helper which performs the recursive deep copy
 * @param visitMap - The current map of objects that have been visited
 * @param value - The value being copied
 * @param ctx - The current copy context
 * @param key - [Optional] the current `key` for the value from the source object
 * @returns The new deep copied instance of the value.
 */
function _deepCopy(visitMap, value, ctx, key) {
    var userHandler = ctx.handler;
    var newPath = ctx.path ? (key ? ctx.path.concat(key) : ctx.path) : [];
    var newCtx = {
        handler: ctx.handler,
        src: ctx.src,
        path: newPath
    };
    var theType = typeof value;
    var isPlain = false;
    var isPrim = false;
    if (value && theType === _internal_constants__WEBPACK_IMPORTED_MODULE_1__.OBJECT) {
        isPlain = (0,_is_plain_object__WEBPACK_IMPORTED_MODULE_2__.isPlainObject)(value);
    }
    else {
        isPrim = value === _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NULL_VALUE || (0,_helpers_base__WEBPACK_IMPORTED_MODULE_3__.isPrimitiveType)(theType);
    }
    var details = {
        type: theType,
        isPrim: isPrim,
        isPlain: isPlain,
        value: value,
        result: value,
        path: newPath,
        origin: ctx.src,
        copy: function (source, newKey) {
            return _deepCopy(visitMap, source, newKey ? newCtx : ctx, newKey);
        },
        copyTo: function (target, source) {
            return _copyProps(visitMap, target, source, newCtx);
        }
    };
    if (!details.isPrim) {
        return _getSetVisited(visitMap, value, newPath, function (newEntry) {
            // Use an accessor to set the new value onto the new entry
            (0,_define__WEBPACK_IMPORTED_MODULE_4__.objDefine)(details, "result", {
                g: function () {
                    return newEntry.v;
                },
                s: function (newValue) {
                    newEntry.v = newValue;
                }
            });
            var idx = 0;
            var handler = userHandler;
            while (!(0,_funcs_fnCall__WEBPACK_IMPORTED_MODULE_5__.fnCall)(handler || (idx < defaultDeepCopyHandlers.length ? defaultDeepCopyHandlers[idx++] : _defaultDeepCopyHandler), ctx, details)) {
                handler = _internal_constants__WEBPACK_IMPORTED_MODULE_1__.NULL_VALUE;
            }
        });
    }
    // Allow the user handler to override the provided value
    if (userHandler && (0,_funcs_fnCall__WEBPACK_IMPORTED_MODULE_5__.fnCall)(userHandler, ctx, details)) {
        return details.result;
    }
    return value;
}
/**
 * @internal
 * @ignore
 * Internal helper to copy all of the enumerable properties from the source object to the new target object
 * @param visitMap - The current map of objects that have been visited
 * @param target - The target object to copy the properties to.
 * @param source - The source object to copy the properties from.
 * @param ctx - The current deep copy context
 * @returns The populated target object
 */
function _copyProps(visitMap, target, source, ctx) {
    if (!(0,_helpers_base__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(source)) {
        // Copy all properties (not just own properties)
        for (var key in source) {
            // Perform a deep copy of the object
            target[key] = _deepCopy(visitMap, source[key], ctx, key);
        }
    }
    return target;
}
/**
 * Object helper to copy all of the enumerable properties from the source object to the target, the
 * properties are copied via {@link objDeepCopy}. Automatic handling of recursive properties was added in v0.4.4
 * @group Object
 * @param target - The target object to populated
 * @param source - The source object to copy the properties from
 * @param handler - An optional callback that lets you provide / overide the deep cloning (Since 0.4.4)
 * @returns The target object
 * @example
 * ```ts
 * let a: any = { a: 1 };
 * let b: any = { b: 2, d: new Date(), e: new TestClass("Hello Darkness") };
 * a.b = b;        // { a: 1, b: { b: 2} }
 * b.a = a;        // { a: 1, b: { b: 2, a: { a: 1, { b: 2, a: ... }}}}
 *
 * function copyHandler(details: IObjDeepCopyHandlerDetails) {
 *     // details.origin === a
 *     // details.path[] is the path to the current value
 *     if (details.value && isDate(details.value)) {
 *         // So for the date path === [ "b", "d" ] which represents
 *         // details.origin["b"]["d"] === The Date
 *
 *         // Create a clone the Date object and set as the "newValue"
 *         details.value = new Date(details.value.getTime());
 *
 *         // Return true to indicate that we have "handled" the conversion
 *         // See objDeepCopy example for just reusing the original value (just don't replace details.value)
 *         return true;
 *     }
 *
 *     return false;
 * }
 *
 * let c: any = objCopyProps({}, a, copyHandler);
 *
 * assert.notEqual(a, c, "check a and c are not the same");
 * assert.ok(c !== c.b.a, "The root object won't be the same for the target reference as are are copying properties to our target");
 * assert.ok(c.b === c.b.a.b, "Check that the 2 'b' references are the same object");
 * assert.ok(c.b.a === c.b.a.b.a, "Check that the 2 'a' references are the same object");
 * assert.ok(c.b.d === c.b.a.b.d, "Check that the 2 'd' references are the same object");
 * assert.ok(isDate(c.b.d), "The copied date is still real 'Date' instance");
 * assert.notEqual(c.b.d, a.b.d, "And the copied date is not the same as the original");
 * assert.equal(c.b.d.getTime(), a.b.d.getTime(), "But the dates are the same");
 *
 * assert.ok(isObject(c.b.d), "The copied date is now an object");
 * ```
 */
function objCopyProps(target, source, handler) {
    var ctx = {
        handler: handler,
        src: source,
        path: []
    };
    return _copyProps([], target, source, ctx);
}
/**
 * Performs a deep copy of the source object, this is designed to work with base (plain) objects, arrays and primitives
 * if the source object contains class objects they will either be not cloned or may be considered non-operational after
 * performing a deep copy. ie. This is performing a deep copy of the objects properties so that altering the copy will
 * not mutate the source object hierarchy.
 * Automatic handling of recursive properties was added in v0.4.4.
 * @group Object
 * @group Object - Deep Copy
 * @param source - The source object to be copied
 * @param handler - An optional callback that lets you provide / overide the deep cloning (Since 0.4.4)
 * @return A new object which contains a deep copy of the source properties
 * @example
 * ```ts
 * let a: any = { a: 1 };
 * let b: any = { b: 2, d: new Date(), e: new TestClass("Hello Darkness") };
 * a.b = b;        // { a: 1, b: { b: 2} }
 * b.a = a;        // { a: 1, b: { b: 2, a: { a: 1, { b: 2, a: ... }}}}
 *
 * function copyHandler(details: IObjDeepCopyHandlerDetails) {
 *     // details.origin === a
 *     // details.path[] is the path to the current value
 *     if (details.value && isDate(details.value)) {
 *         // So for the date path === [ "b", "d" ] which represents
 *         // details.origin["b"]["d"] === The Date
 *
 *         // Return true to indicate that we have "handled" the conversion
 *         // Which in this case will reuse the existing instance (as we didn't replace details.value)
 *         // See objCopyProps example for replacing the Date instance
 *         return true;
 *     }
 *
 *     return false;
 * }
 *
 * let c: any = objDeepCopy(a, copyHandler);
 *
 * assert.notEqual(a, c, "check a and c are not the same");
 * assert.ok(c === c.b.a, "The root object won't be the same for the target reference");
 * assert.ok(c.b === c.b.a.b, "Check that the 2 'b' references are the same object");
 * assert.ok(c.b.a === c.b.a.b.a, "Check that the 2 'a' references are the same object");
 * assert.ok(c.b.d === c.b.a.b.d, "Check that the 2 'd' references are the same object");
 * assert.ok(isDate(c.b.d), "The copied date is still real 'Date' instance");
 * assert.equal(c.b.d, a.b.d, "And the copied date is the original date");
 * assert.equal(c.b.d.getTime(), a.b.d.getTime(), "But the dates are the same");
 * assert.ok(isObject(c.b.d), "The copied date is now an object");
 * assert.ok(!isError(c.b.e), "The copied error is no longer a real 'Error' instance");
 * assert.ok(isObject(c.b.e), "The copied error is now an object");
 * assert.equal(42, c.b.e.value, "Expect that the local property was copied");
 * ```
 */
function objDeepCopy(source, handler) {
    var ctx = {
        handler: handler,
        src: source
    };
    return _deepCopy([], source, ctx);
}
/**
 * Deep copy handler to identify and copy arrays.
 * @since 0.4.4
 * @group Object - Deep Copy
 * @param details - The details object for the current property being copied
 * @returns `true` if the current value is a function otherwise `false`
 */
function arrayDeepCopyHandler(details) {
    var value = details.value;
    if ((0,_helpers_base__WEBPACK_IMPORTED_MODULE_3__.isArray)(value)) {
        // Assign the "result" value before performing any additional deep Copying, so any recursive object get a reference to this instance
        var target = details.result = [];
        target.length = value.length;
        // Copying all properties as arrays can contain non-indexed based properties
        details.copyTo(target, value);
        return true;
    }
    return false;
}
/**
 * Deep copy handler to identify and copy Date instances.
 * @since 0.4.4
 * @group Object - Deep Copy
 * @param details - The details object for the current property being copied
 * @returns `true` if the current value is a function otherwise `false`
 */
function dateDeepCopyHandler(details) {
    var value = details.value;
    if ((0,_helpers_base__WEBPACK_IMPORTED_MODULE_3__.isDate)(value)) {
        details.result = new Date(value.getTime());
        return true;
    }
    return false;
}
/**
 * Deep copy handler to identify and copy functions. This handler just returns the original
 * function so the original function will be assigned to any new deep copied instance.
 * @since 0.4.4
 * @group Object - Deep Copy
 * @param details - The details object for the current property being copied
 * @returns `true` if the current value is a function otherwise `false`
 */
function functionDeepCopyHandler(details) {
    if (details.type === _internal_constants__WEBPACK_IMPORTED_MODULE_1__.FUNCTION) {
        return true;
    }
    return false;
}
/**
 * Deep copy handler to identify and copy plain objects.
 * @since 0.4.4
 * @group Object - Deep Copy
 * @param details - The details object for the current property being copied
 * @returns `true` if the current value is a function otherwise `false`
 */
function plainObjDeepCopyHandler(details) {
    var value = details.value;
    if (value && details.isPlain) {
        // Assign the "result" value before performing any additional deep Copying, so any recursive object get a reference to this instance
        var target = details.result = {};
        details.copyTo(target, value);
        return true;
    }
    return false;
}
//# sourceMappingURL=copy.js.map

/***/ }),
/* 102 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EventLatency: () => (/* binding */ EventLatency),
/* harmony export */   EventPersistence: () => (/* binding */ EventPersistence),
/* harmony export */   EventPropertyType: () => (/* binding */ EventPropertyType),
/* harmony export */   TraceLevel: () => (/* binding */ TraceLevel),
/* harmony export */   ValueKind: () => (/* binding */ ValueKind)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(103);
/*
 * 1DS JS SDK Core, 4.0.3
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
* Enums.ts
* @author Abhilash Panwar (abpanwar)
* @copyright Microsoft 2018
* File containing the enums as constants.
*/

/**
 * The ValueKind contains a set of values that specify value kind of the property.
 * Either PII (Personal Identifiable Information) or customer content.
 */
var ValueKind = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.createEnumStyle)({
    NotSet: 0 /* eValueKind.NotSet */,
    Pii_DistinguishedName: 1 /* eValueKind.Pii_DistinguishedName */,
    Pii_GenericData: 2 /* eValueKind.Pii_GenericData */,
    Pii_IPV4Address: 3 /* eValueKind.Pii_IPV4Address */,
    Pii_IPv6Address: 4 /* eValueKind.Pii_IPv6Address */,
    Pii_MailSubject: 5 /* eValueKind.Pii_MailSubject */,
    Pii_PhoneNumber: 6 /* eValueKind.Pii_PhoneNumber */,
    Pii_QueryString: 7 /* eValueKind.Pii_QueryString */,
    Pii_SipAddress: 8 /* eValueKind.Pii_SipAddress */,
    Pii_SmtpAddress: 9 /* eValueKind.Pii_SmtpAddress */,
    Pii_Identity: 10 /* eValueKind.Pii_Identity */,
    Pii_Uri: 11 /* eValueKind.Pii_Uri */,
    Pii_Fqdn: 12 /* eValueKind.Pii_Fqdn */,
    Pii_IPV4AddressLegacy: 13 /* eValueKind.Pii_IPV4AddressLegacy */,
    CustomerContent_GenericContent: 32 /* eValueKind.CustomerContent_GenericContent */
});
/**
 * The EventLatency contains a set of values that specify the latency with which an event is sent.
 */
var EventLatency = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.createEnumStyle)({
    /**
     * Normal latency.
     */
    Normal: 1 /* EventLatencyValue.Normal */,
    /**
     * Cost deferred latency. At the moment this latency is treated as Normal latency.
     */
    CostDeferred: 2 /* EventLatencyValue.CostDeferred */,
    /**
     * Real time latency.
     */
    RealTime: 3 /* EventLatencyValue.RealTime */,
    /**
     * Bypass normal batching/timing and send as soon as possible, this will still send asynchronously.
     * Added in v3.1.1
     */
    Immediate: 4 /* EventLatencyValue.Immediate */
});
/**
 * Enum for property types.
 */
var EventPropertyType = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.createEnumStyle)({
    Unspecified: 0 /* eEventPropertyType.Unspecified */,
    String: 1 /* eEventPropertyType.String */,
    Int32: 2 /* eEventPropertyType.Int32 */,
    UInt32: 3 /* eEventPropertyType.UInt32 */,
    Int64: 4 /* eEventPropertyType.Int64 */,
    UInt64: 5 /* eEventPropertyType.UInt64 */,
    Double: 6 /* eEventPropertyType.Double */,
    Bool: 7 /* eEventPropertyType.Bool */,
    Guid: 8 /* eEventPropertyType.Guid */,
    DateTime: 9 /* eEventPropertyType.DateTime */
});
/**
 * The EventPersistence contains a set of values that specify the event's persistence.
 */
var EventPersistence = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.createEnumStyle)({
    /**
     * Normal persistence.
     */
    Normal: 1 /* EventPersistenceValue.Normal */,
    /**
     * Critical persistence.
     */
    Critical: 2 /* EventPersistenceValue.Critical */
});
var TraceLevel = (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.createEnumStyle)({
    NONE: 0 /* eTraceLevel.NONE */,
    ERROR: 1 /* eTraceLevel.ERROR */,
    WARNING: 2 /* eTraceLevel.WARNING */,
    INFORMATION: 3 /* eTraceLevel.INFORMATION */
});
//# sourceMappingURL=Enums.js.map

/***/ }),
/* 103 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createEnumStyle: () => (/* binding */ createEnumStyle),
/* harmony export */   createValueMap: () => (/* binding */ createValueMap)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */



/**
 * Create an enum style object which has both the key => value and value => key mappings
 * @param values - The values to populate on the new object
 * @returns
 */
var createEnumStyle = _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.createEnum;
/**
 * Create a 2 index map that maps an enum's key and value to the defined map value, X["key"] => mapValue and X[0] => mapValue.
 * Generic values
 * - E = the const enum type (typeof eRequestHeaders);
 * - V = Identifies the valid values for the keys, this should include both the enum numeric and string key of the type. The
 * resulting "Value" of each entry identifies the valid values withing the assignments.
 * @param values - The values to populate on the new object
 * @returns
 */
var createValueMap = _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.createTypeMap;
//# sourceMappingURL=EnumHelperFuncs.js.map

/***/ }),
/* 104 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ValueSanitizer: () => (/* binding */ ValueSanitizer)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13);
/* harmony import */ var _microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(15);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(105);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(58);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(37);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(82);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(20);
/* harmony import */ var _Utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(21);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22);
/*
 * 1DS JS SDK Core, 4.0.3
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */





var ValueSanitizer = /** @class */ (function () {
    function ValueSanitizer(fieldSanitizerProvider) {
        var _self = this;
        // To aid with performance this is a lookup map to check if the field value sanitizer supports this field
        var _sanitizerMap = {};
        var _sanitizers = [];
        var _fieldSanitizers = [];
        if (fieldSanitizerProvider) {
            _fieldSanitizers.push(fieldSanitizerProvider);
        }
        function _getFieldSanitizer(path, name) {
            var result;
            var fieldLookup = _sanitizerMap[path];
            if (fieldLookup) {
                result = fieldLookup[name];
            }
            if (!result && result !== null) {
                // Null is a valid result indicating that the value sanitizer does not support this field
                if ((0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isString)(path) && (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isString)(name)) {
                    if (_fieldSanitizers[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
                        for (var lp = 0; lp < _fieldSanitizers[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]; lp++) {
                            if (_fieldSanitizers[lp][_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HANDLE_FIELD /* @min:%2ehandleField */](path, name)) {
                                result = {
                                    canHandle: true,
                                    fieldHandler: _fieldSanitizers[lp]
                                };
                                break;
                            }
                        }
                    }
                    else if (_sanitizers[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] === 0) {
                        // Special use-case where there is no sanitizer to pass on to, so just resolving the field
                        // and returning the resulting value (same as sanitizeProperty())
                        result = {
                            canHandle: true
                        };
                    }
                }
                // We still don't have a handler so lets lookup the providers
                if (!result && result !== null) {
                    // Setting the result to null -- which means we and any contained sanitizers can't handle this field
                    result = null;
                    for (var lp = 0; lp < _sanitizers[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]; lp++) {
                        if (_sanitizers[lp][_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HANDLE_FIELD /* @min:%2ehandleField */](path, name)) {
                            result = {
                                canHandle: true,
                                handler: _sanitizers[lp],
                                fieldHandler: null
                            };
                            break;
                        }
                    }
                }
                if (!fieldLookup) {
                    fieldLookup = _sanitizerMap[path] = {};
                }
                fieldLookup[name] = result;
            }
            return result;
        }
        _self.clearCache = function () {
            _sanitizerMap = {};
        };
        _self.addSanitizer = function (newSanitizer) {
            if (newSanitizer) {
                if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.arrIncludes)(_sanitizers, newSanitizer)) {
                    _sanitizers.push(newSanitizer);
                }
                // Invalidate any previously mapped fields
                _sanitizerMap = {};
            }
        };
        _self.addFieldSanitizer = function (fieldSanitizer) {
            if (fieldSanitizer) {
                if (!(0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_2__.arrIncludes)(_fieldSanitizers, fieldSanitizer)) {
                    _fieldSanitizers.push(fieldSanitizer);
                }
                // Invalidate any previously mapped fields
                _sanitizerMap = {};
            }
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_RM_SANITIZER /* @min:%2ermSanitizer */] = function (theSanitizer) {
            if (theSanitizer) {
                var idx = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrIndexOf)(_sanitizers, theSanitizer);
                if (idx !== -1) {
                    _sanitizers.splice(idx, 1);
                    // Invalidate any previously mapped fields
                    _sanitizerMap = {};
                }
                // Try and remove the sanitizer from any chained sanitizer as well
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.arrForEach)(_sanitizers, function (sanitizer) {
                    sanitizer && sanitizer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_RM_SANITIZER /* @min:%2ermSanitizer */] && sanitizer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_RM_SANITIZER /* @min:%2ermSanitizer */](theSanitizer);
                });
            }
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_RM_FIELD_SANITIZER /* @min:%2ermFieldSanitizer */] = function (theFieldSanitizer) {
            if (theFieldSanitizer) {
                var idx = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.arrIndexOf)(_fieldSanitizers, theFieldSanitizer);
                if (idx !== -1) {
                    _fieldSanitizers.splice(idx, 1);
                    // Invalidate any previously mapped fields
                    _sanitizerMap = {};
                }
                // Try and remove the field sanitizer from any chained sanitizer as well
                (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.arrForEach)(_sanitizers, function (sanitizer) {
                    sanitizer && sanitizer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_RM_FIELD_SANITIZER /* @min:%2ermFieldSanitizer */] && sanitizer[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_RM_FIELD_SANITIZER /* @min:%2ermFieldSanitizer */](theFieldSanitizer);
                });
            }
        };
        _self.isEmpty = function () {
            return ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.getLength)(_sanitizers) + (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.getLength)(_fieldSanitizers)) === 0;
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HANDLE_FIELD /* @min:%2ehandleField */] = function (path, name) {
            var mapValue = _getFieldSanitizer(path, name);
            return mapValue ? mapValue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CAN_HANDLE /* @min:%2ecanHandle */] : false;
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_VALUE /* @min:%2evalue */] = function (path, name, value, stringifyObjects) {
            var mapValue = _getFieldSanitizer(path, name);
            if (mapValue && mapValue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CAN_HANDLE /* @min:%2ecanHandle */]) {
                if (!mapValue || !mapValue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CAN_HANDLE /* @min:%2ecanHandle */]) {
                    return null;
                }
                if (mapValue.handler) {
                    // This value sanitizer can't handle this field so pass it only the next one
                    return mapValue.handler[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_VALUE /* @min:%2evalue */](path, name, value, stringifyObjects);
                }
                // Check that property is valid
                if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isString)(name) || (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isNullOrUndefined)(value) || value === _InternalConstants__WEBPACK_IMPORTED_MODULE_6__.STR_EMPTY) {
                    return null;
                }
                var property = null;
                var fieldType = (0,_Utils__WEBPACK_IMPORTED_MODULE_7__.getFieldValueType)(value);
                if ((fieldType & 8192 /* FieldValueSanitizerType.EventProperty */) === 8192 /* FieldValueSanitizerType.EventProperty */) {
                    var subType = fieldType & ~8192 /* FieldValueSanitizerType.EventProperty */;
                    property = value;
                    if (!(0,_Utils__WEBPACK_IMPORTED_MODULE_7__.isValueAssigned)(property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_VALUE /* @min:%2evalue */]) ||
                        (subType !== 1 /* FieldValueSanitizerType.String */ &&
                            subType !== 2 /* FieldValueSanitizerType.Number */ &&
                            subType !== 3 /* FieldValueSanitizerType.Boolean */ &&
                            (subType & 4096 /* FieldValueSanitizerType.Array */) !== 4096 /* FieldValueSanitizerType.Array */)) {
                        // Not a supported IEventProperty type to be able to sanitize
                        return null;
                    }
                }
                else if (fieldType === 1 /* FieldValueSanitizerType.String */ ||
                    fieldType === 2 /* FieldValueSanitizerType.Number */ ||
                    fieldType === 3 /* FieldValueSanitizerType.Boolean */ ||
                    (fieldType & 4096 /* FieldValueSanitizerType.Array */) === 4096 /* FieldValueSanitizerType.Array */) {
                    // If the property isn't IEventProperty (and is either string, number, boolean or array), convert it into one.
                    property = _convertToProperty(path, name, value);
                }
                else if (fieldType === 4 /* FieldValueSanitizerType.Object */) {
                    property = _convertToProperty(path, name, !!stringifyObjects ? JSON.stringify(value) : value);
                }
                if (property) {
                    return _handleProperty(mapValue, path, name, fieldType, property, stringifyObjects);
                }
            }
            return null;
        };
        _self.property = function (path, name, property, stringifyObjects) {
            var mapValue = _getFieldSanitizer(path, name);
            if (!mapValue || !mapValue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CAN_HANDLE /* @min:%2ecanHandle */]) {
                return null;
            }
            // Check that property is valid
            if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isString)(name) || (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isNullOrUndefined)(property) || !(0,_Utils__WEBPACK_IMPORTED_MODULE_7__.isValueAssigned)(property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_VALUE /* @min:%2evalue */])) {
                return null;
            }
            var fieldType = (0,_Utils__WEBPACK_IMPORTED_MODULE_7__.getFieldValueType)(property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_VALUE /* @min:%2evalue */]);
            if (fieldType === 0 /* FieldValueSanitizerType.NotSet */) {
                // Not a supported field that we can sanitize or serialize
                return null;
            }
            return _handleProperty(mapValue, path, name, fieldType, property, stringifyObjects);
        };
        function _handleProperty(mapValue, path, name, fieldType, property, stringifyObjects) {
            if (mapValue.handler) {
                // This value sanitizer can't handle this field so pass it only the next one
                return mapValue.handler.property(path, name, property, stringifyObjects);
            }
            // If either pii or cc is set convert value to string (since only string pii/cc is allowed).
            // If the value is a complex type like an array that can't be converted to string we will drop
            // the property.
            if (!(0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_0__.isNullOrUndefined)(property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_KIND /* @min:%2ekind */])) {
                if ((fieldType & 4096 /* FieldValueSanitizerType.Array */) === 4096 /* FieldValueSanitizerType.Array */ || !(0,_Utils__WEBPACK_IMPORTED_MODULE_7__.isValueKind)(property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_KIND /* @min:%2ekind */])) {
                    return null;
                }
                // Convert the value to a string and assign back to the original value
                property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_VALUE /* @min:%2evalue */] = property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_VALUE /* @min:%2evalue */].toString();
            }
            return _callFieldSanitizer(mapValue.fieldHandler, path, name, fieldType, property);
        }
        function _convertToProperty(path, name, value) {
            if ((0,_Utils__WEBPACK_IMPORTED_MODULE_7__.isValueAssigned)(value)) {
                return { value: value };
            }
            return null;
        }
        function _callFieldSanitizer(fieldProvider, path, name, theType, property) {
            if (property && fieldProvider) {
                var sanitizer = fieldProvider.getSanitizer(path, name, theType, property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_KIND /* @min:%2ekind */], property.propertyType);
                if (sanitizer) {
                    // This is where we the field will call the handler to "scrub" the value. This the primary hook for the ClientHashing Plugin to
                    // be able to apply the hashFunc() / Sha256 conversion of the properties value
                    if (theType === 4 /* FieldValueSanitizerType.Object */) {
                        // Special case of an embedded object (ext.metadata, data.properties)
                        var newValue_1 = {};
                        var propValue = property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_VALUE /* @min:%2evalue */];
                        (0,_microsoft_applicationinsights_core_js__WEBPACK_IMPORTED_MODULE_8__.objForEachKey)(propValue, function (propKey, theValue) {
                            var newPath = path + "." + name;
                            if ((0,_Utils__WEBPACK_IMPORTED_MODULE_7__.isValueAssigned)(theValue)) {
                                var newProp = _convertToProperty(newPath, propKey, theValue);
                                newProp = _callFieldSanitizer(fieldProvider, newPath, propKey, (0,_Utils__WEBPACK_IMPORTED_MODULE_7__.getFieldValueType)(theValue), newProp);
                                if (newProp) {
                                    newValue_1[propKey] = newProp[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_VALUE /* @min:%2evalue */];
                                }
                            }
                        });
                        property[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_VALUE /* @min:%2evalue */] = newValue_1;
                    }
                    else {
                        var details = {
                            path: path,
                            name: name,
                            type: theType,
                            prop: property,
                            sanitizer: _self
                        };
                        property = sanitizer.call(_self, details);
                    }
                }
            }
            return property;
        }
    }
    ValueSanitizer.getFieldType = _Utils__WEBPACK_IMPORTED_MODULE_7__.getFieldValueType;
    return ValueSanitizer;
}());

//# sourceMappingURL=ValueSanitizer.js.map

/***/ }),
/* 105 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   arrContains: () => (/* binding */ arrContains),
/* harmony export */   arrIncludes: () => (/* binding */ arrIncludes)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25);
/* harmony import */ var _polyfills_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(106);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */



/**
 * The arrIncludes() method determines whether an array includes a certain value among its
 * entries, returning true or false as appropriate.
 * @since 0.8.0
 * @group Array
 * @group ArrayLike
 * @param theArray - The array or array like object of elements to be searched.
 * @param searchElement - The value to search for
 * @param fromIndex - The optional Zero-based index at which to start searching, converted to an integer.
 * - Negative index counts back from the end of the array — if fromIndex < 0, fromIndex + array.length
 * is used. However, the array is still searched from front to back in this case.
 * - If fromIndex < -array.length or fromIndex is omitted, 0 is used, causing the entire array to be searched.
 * - If fromIndex >= array.length, the array is not searched and false is returned.
 * @returns A boolean value which is true if the value searchElement is found within the array (or the part of
 * the array indicated by the index fromIndex, if specified).
 * @example
 * ```ts
 * arrIncludes([1, 2, 3], 2);       // true
 * arrIncludes([1, 2, 3], 4);       // false
 * arrIncludes([1, 2, 3], 3, 3);    // false
 * arrIncludes([1, 2, 3], 3, -1);   // true
 * arrIncludes([1, 2, NaN], NaN);   // true
 * arrIncludes(["1", "2", "3"], 3 as any); // false
 *
 * // Array Like
 * arrIncludes({ length: 3, 0: 1, 1: 2, 2: 3 }, 2);       // true
 * arrIncludes({ length: 3, 0: 1, 1: 2, 2: 3 }, 4);       // false
 * arrIncludes({ length: 3, 0: 1, 1: 2, 2: 3 }, 3, 3);    // false
 * arrIncludes({ length: 3, 0: 1, 1: 2, 2: 3 }, 3, -1);   // true
 * arrIncludes({ length: 3, 0: 1, 1: 2, 2: NaN }, NaN);   // true
 * arrIncludes({ length: 3, 0: "1", 1: "2", 2: "3" }, 3 as any); // false
 * ```
 */
var arrIncludes = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunctionWithPoly)("includes", _internal_constants__WEBPACK_IMPORTED_MODULE_1__.ArrProto, _polyfills_array__WEBPACK_IMPORTED_MODULE_2__.polyArrIncludes);
/**
 * The arrContains() method determines whether an array contains a certain value among its
 * entries, returning true or false as appropriate.
 * @since 0.8.0
 * @group Array
 * @group ArrayLike
 * @param theArray - The array or array like object of elements to be searched.
 * @param searchElement - The value to search for
 * @param fromIndex - The optional Zero-based index at which to start searching, converted to an integer.
 * - Negative index counts back from the end of the array — if fromIndex < 0, fromIndex + array.length
 * is used. However, the array is still searched from front to back in this case.
 * - If fromIndex < -array.length or fromIndex is omitted, 0 is used, causing the entire array to be searched.
 * - If fromIndex >= array.length, the array is not searched and false is returned.
 * @returns A boolean value which is true if the value searchElement is found within the array (or the part of
 * the array indicated by the index fromIndex, if specified).
 * @example
 * ```ts
 * arrContains([1, 2, 3], 2);       // true
 * arrContains([1, 2, 3], 4);       // false
 * arrContains([1, 2, 3], 3, 3);    // false
 * arrContains([1, 2, 3], 3, -1);   // true
 * arrContains([1, 2, NaN], NaN);   // true
 * arrContains(["1", "2", "3"], 3 as any); // false
 *
 * // Array Like
 * arrContains({ length: 3, 0: 1, 1: 2, 2: 3 }, 2);       // true
 * arrContains({ length: 3, 0: 1, 1: 2, 2: 3 }, 4);       // false
 * arrContains({ length: 3, 0: 1, 1: 2, 2: 3 }, 3, 3);    // false
 * arrContains({ length: 3, 0: 1, 1: 2, 2: 3 }, 3, -1);   // true
 * arrContains({ length: 3, 0: 1, 1: 2, 2: NaN }, NaN);   // true
 * arrContains({ length: 3, 0: "1", 1: "2", 2: "3" }, 3 as any); // false
 * ```
 */
var arrContains = arrIncludes;
//# sourceMappingURL=includes.js.map

/***/ }),
/* 106 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   polyArrFind: () => (/* binding */ polyArrFind),
/* harmony export */   polyArrFindIndex: () => (/* binding */ polyArrFindIndex),
/* harmony export */   polyArrFindLast: () => (/* binding */ polyArrFindLast),
/* harmony export */   polyArrFindLastIndex: () => (/* binding */ polyArrFindLastIndex),
/* harmony export */   polyArrFrom: () => (/* binding */ polyArrFrom),
/* harmony export */   polyArrIncludes: () => (/* binding */ polyArrIncludes),
/* harmony export */   polyIsArray: () => (/* binding */ polyIsArray)
/* harmony export */ });
/* harmony import */ var _array_forEach__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(37);
/* harmony import */ var _array_indexOf__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(58);
/* harmony import */ var _array_map__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(107);
/* harmony import */ var _array_slice__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(62);
/* harmony import */ var _funcs_fnCall__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(39);
/* harmony import */ var _helpers_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13);
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8);
/* harmony import */ var _iterator_forOf__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(99);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */








/**
 * Polyfill support function for Array.isArray
 * @group Polyfill
 * @group Array
 * @param value - The value to be checked
 * @returns true if the value is an array otherwise false.
 */
function polyIsArray(value) {
    if ((0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isNullOrUndefined)(value)) {
        return false;
    }
    return (0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.objToString)(value) === "[object Array]";
}
/**
 * The polyArrIncludes() method determines whether an array includes a certain value among its
 * entries, returning true or false as appropriate.
 * Note: The polyfill does not handle NaN correctly.
 * @since 0.8.0
 * @group Array
 * @group Polyfill
 * @param theArray - The array or array like object of elements to be searched.
 * @param searchElement - The value to search for
 * @param fromIndex - The optional Zero-based index at which to start searching, converted to an integer.
 * - Negative index counts back from the end of the array — if fromIndex < 0, fromIndex + array.length
 * is used. However, the array is still searched from front to back in this case.
 * - If fromIndex < -array.length or fromIndex is omitted, 0 is used, causing the entire array to be searched.
 * - If fromIndex >= array.length, the array is not searched and false is returned.
 * @returns A boolean value which is true if the value searchElement is found within the array (or the part of
 * the array indicated by the index fromIndex, if specified).
 */
function polyArrIncludes(theArray, searchElement, fromIndex) {
    return (0,_array_indexOf__WEBPACK_IMPORTED_MODULE_1__.arrIndexOf)(theArray, searchElement, fromIndex) !== -1;
}
/**
 * The polyArrFind() method returns the first element in the provided array that satisfies
 * the provided testing function. If no values satisfy the testing function, undefined
 * is returned.
 * - If you need the index of the found element in the array, use {@link arrFindIndex}.
 * - If you need to find the index of a value, use arrIndexOf(). (It's similar to {@link arrFindIndex}, but checks
 * each element for equality with the value instead of using a testing function.)
 * - If you need to find if a value exists in an array, use arrIncludes(). Again, it checks each element for
 * equality with the value instead of using a testing function.
 * - If you need to find if any element satisfies the provided testing function, use {@link arrSome}.
 *
 * The polyArrFind() method is an iterative method. It calls a provided `callbackFn` function once for each element
 * in an array in ascending-index order, until `callbackFn` returns a truthy value. polyArrFind() then returns that
 * element and stops iterating through the array. If callbackFn never returns a truthy value, polyArrFind() returns
 * undefined.
 *
 * `callbackFn` is invoked for every index of the array, not just those with assigned values. Empty slots in
 * sparse arrays behave the same as undefined.
 *
 * polyArrFind() does not mutate the array on which it is called, but the function provided as callbackFn can.
 * Note, however, that the length of the array is saved before the first invocation of `callbackFn`. Therefore:
 * - `callbackFn` will not visit any elements added beyond the array's initial length when the call to polyArrFind() began.
 * - Changes to already-visited indexes do not cause callbackFn to be invoked on them again.
 * - If an existing, yet-unvisited element of the array is changed by callbackFn, its value passed to the
 * `callbackFn` will be the value at the time that element gets visited. Deleted elements are visited as if they
 * were undefined.
 * @since 0.8.0
 * @group Polyfill
 * @group Array
 * @typeParam T - Identifies the base type of array elements
 * @typeParam E - Identifies a more specific instance of the base array type
 * @param theArray - The array or array like object of elements to be searched.
 * @param callbackFn A function that accepts up to three arguments of type {@link ArrPredicateCallbackFn} or
 * {@link ArrPredicateCallbackFn2}. The predicate function is called for each element in the thArray until
 * the predicate returns a value which is coercible to the Boolean value false, or until the end of the array.
 * @return The first element in the array that satisfies the provided testing function. Otherwise, undefined
 * is returned.
 * @example
 * ```ts
 * const inventory = [
 *   { name: "apples", quantity: 2 },
 *   { name: "bananas", quantity: 0 },
 *   { name: "cherries", quantity: 5 },
 * ];
 *
 * function isCherries(fruit) {
 *   return fruit.name === "cherries";
 * }
 *
 * console.log(polyArrFind(inventory, isCherries));
 * // { name: 'cherries', quantity: 5 }
 *
 * function isPrime(element, index, array) {
 *   let start = 2;
 *   while (start <= Math.sqrt(element)) {
 *     if (element % start++ < 1) {
 *       return false;
 *     }
 *   }
 *   return element > 1;
 * }
 *
 * console.log(polyArrFind([4, 6, 8, 12], isPrime)); // undefined, not found
 * console.log(polyArrFind([4, 5, 8, 12], isPrime)); // 5
 * ```
 */
function polyArrFind(theArray, callbackFn, thisArg) {
    var result;
    var idx = polyArrFindIndex(theArray, callbackFn, thisArg);
    return idx !== -1 ? theArray[idx] : result;
}
/**
 * The polyArrFindIndex() method returns the index of the first element in an array that satisfies the provided testing
 * function. If no elements satisfy the testing function, -1 is returned.
 *
 * The polyArrFindIndex() is an iterative method. It calls a provided callbackFn function once for each element in an
 * array in ascending-index order, until callbackFn returns a truthy value. polyArrFindIndex() then returns the index
 * of that element and stops iterating through the array. If `callbackFn` never returns a truthy value, polyArrFindIndex()
 * returns -1.
 *
 * `callbackFn` is invoked for every index of the array, not just those with assigned values. Empty slots in sparse
 * arrays behave the same as undefined.
 *
 * polyArrFindIndex() does not mutate the array on which it is called, but the function provided as `callbackFn` can.
 * Note, however, that the length of the array is saved before the first invocation of callbackFn. Therefore:
 * - `callbackFn` will not visit any elements added beyond the array's initial length when the call to polyArrFindIndex() began.
 * - Changes to already-visited indexes do not cause `callbackFn` to be invoked on them again.
 * If an existing, yet-unvisited element of the array is changed by `callbackFn`, its value passed to the `callbackFn`
 * will be the value at the time that element gets visited. Deleted elements are visited as if they were undefined.
 * @since 0.8.0
 * @group Polyfill
 * @group Array
 * @typeParam T - Identifies the base type of array elements
 * @typeParam E - Identifies a more specific instance of the base array type
 * @param theArray - The array or array like object of elements to be searched.
 * @param callbackFn A function that accepts up to three arguments of type {@link ArrPredicateCallbackFn} or
 * {@link ArrPredicateCallbackFn2}. The predicate function is called for each element in the thArray until
 * the predicate returns a value which is coercible to the Boolean value false, or until the end of the array.
 * @param thisArg - A value to use as this when executing callbackFn. Defaults to the array if not provided.
 * @return The index of the first element in the array that passes the test. Otherwise, -1.
 * @example
 * ```ts
 * ```
 */
function polyArrFindIndex(theArray, callbackFn, thisArg) {
    var result = -1;
    (0,_array_forEach__WEBPACK_IMPORTED_MODULE_2__.arrForEach)(theArray, function (value, index) {
        if ((0,_funcs_fnCall__WEBPACK_IMPORTED_MODULE_3__.fnCall)(callbackFn, thisArg | theArray, value, index, theArray)) {
            result = index;
            return -1;
        }
    });
    return result;
}
/**
 * The polyArrFindLast() method iterates the array in reverse order and returns the value of the first element that
 * satisfies the provided testing function. If no elements satisfy the testing function, undefined is returned.
 * - If you need the index of the found element in the array, use {@link arrFindLastIndex}.
 * - If you need to find the index of a value, use arrLastIndexOf(). (It's similar to {@link arrFindLastIndex}, but checks
 * each element for equality with the value instead of using a testing function.)
 * - If you need to find if a value exists in an array, use arrIncludes(). Again, it checks each element for
 * equality with the value instead of using a testing function.
 * - If you need to find if any element satisfies the provided testing function, use {@link arrSome}.
 *
 * The polyArrFindLast() method is an iterative method. It calls a provided callbackFn function once for each element
 * in an array in descending-index order, until callbackFn returns a truthy value. polyArrFindLast() then returns that
 * element and stops iterating through the array. If `callbackFn` never returns a truthy value, polyArrFindLast() returns
 * undefined.
 *
 * `callbackFn` is invoked for every index of the array, not just those with assigned values. Empty slots in sparse
 * arrays behave the same as undefined.
 *
 * polyArrFindLast() does not mutate the array on which it is called, but the function provided as `callbackFn` can.
 * Note, however, that the length of the array is saved before the first invocation of `callbackFn`. Therefore:
 * - `callbackFn` will not visit any elements added beyond the array's initial length when the call to polyArrFindLast() began.
 * - Changes to already-visited indexes do not cause callbackFn to be invoked on them again.
 * - If an existing, yet-unvisited element of the array is changed by `callbackFn`, its value passed to the `callbackFn`
 * will be the value at the time that element gets visited. Deleted elements are visited as if they were undefined.
 * @since 0.8.0
 * @group Polyfill
 * @group Array
 * @typeParam T - Identifies the base type of array elements
 * @typeParam E - Identifies a more specific instance of the base array type
 * @param theArray - The array or array like object of elements to be searched.
 * @param callbackFn A function that accepts up to three arguments of type {@link ArrPredicateCallbackFn} or
 * {@link ArrPredicateCallbackFn2}. The predicate function is called for each element in the thArray until
 * the predicate returns a value which is coercible to the Boolean value false, or until the end of the array.
 * @param thisArg - A value to use as this when executing callbackFn. Defaults to the array if not provided.
 * @return The last element in the array that satisfies the provided testing function. Otherwise, undefined
 * is returned.
 * @example
 * ```ts
 * const inventory = [
 *   { name: "apples", quantity: 2 },
 *   { name: "bananas", quantity: 0 },
 *   { name: "cherries", quantity: 5 },
 * ];
 *
 * function isCherries(fruit) {
 *   return fruit.name === "cherries";
 * }
 *
 * console.log(polyArrFindLast(inventory, isCherries));
 * // { name: 'cherries', quantity: 5 }
 *
 * function isPrime(element, index, array) {
 *   let start = 2;
 *   while (start <= Math.sqrt(element)) {
 *     if (element % start++ < 1) {
 *       return false;
 *     }
 *   }
 *   return element > 1;
 * }
 *
 * console.log(polyArrFindLast([4, 6, 8, 12], isPrime)); // undefined, not found
 * console.log(polyArrFindLast([4, 5, 7, 12], isPrime)); // 7
 * ```
 */
function polyArrFindLast(theArray, callbackFn, thisArg) {
    var result;
    var idx = polyArrFindLastIndex(theArray, callbackFn, thisArg);
    return idx !== -1 ? theArray[idx] : result;
}
/**
 * The polyArrFindLastIndex() method iterates the array in reverse order and returns the index of the first element that
 * satisfies the provided testing function. If no elements satisfy the testing function, -1 is returned.
 *
 * The polyArrFindLastIndex() method is an iterative method. It calls a provided `callbackFn` function once for each element
 * in an array in descending-index order, until callbackFn returns a truthy value. polyArrFindLastIndex() then returns the
 * index of that element and stops iterating through the array. If callbackFn never returns a truthy value, returns -1.
 *
 * `callbackFn` is invoked for every index of the array, not just those with assigned values. Empty slots in sparse arrays
 * behave the same as undefined.
 *
 * polyArrFindLastIndex() does not mutate the array on which it is called, but the function provided as callbackFn can.
 * Note, however, that the length of the array is saved before the first invocation of callbackFn. Therefore:
 * - `callbackFn` will not visit any elements added beyond the array's initial length when the call to polyArrFindLastIndex() began.
 * - Changes to already-visited indexes do not cause callbackFn to be invoked on them again.
 * - If an existing, yet-unvisited element of the array is changed by `callbackFn`, its value passed to the callbackFn
 * will be the value at the time that element gets visited. Deleted elements are visited as if they were undefined.
 * @since 0.8.0
 * @group Polyfill
 * @group Array
 * @typeParam T - Identifies the base type of array elements
 * @typeParam E - Identifies a more specific instance of the base array type
 * @param theArray - The array or array like object of elements to be searched.
 * @param callbackFn A function that accepts up to three arguments of type {@link ArrPredicateCallbackFn} or
 * {@link ArrPredicateCallbackFn2}. The predicate function is called for each element in the thArray until
 * the predicate returns a value which is coercible to the Boolean value false, or until the end of the array.
 * @param thisArg - A value to use as this when executing callbackFn. Defaults to the array if not provided.
 * @return The index of the last (highest-index) element in the array that passes the test. Otherwise -1 if
 * no matching element is found.
 */
function polyArrFindLastIndex(theArray, callbackFn, thisArg) {
    var result = -1;
    var len = theArray[_internal_constants__WEBPACK_IMPORTED_MODULE_4__.LENGTH] >>> 0;
    for (var idx = len - 1; idx >= 0; idx--) {
        if (idx in theArray && (0,_funcs_fnCall__WEBPACK_IMPORTED_MODULE_3__.fnCall)(callbackFn, thisArg | theArray, theArray[idx], idx, theArray)) {
            result = idx;
            break;
        }
    }
    return result;
}
/**
 * The polyArrFrom creates an new shallow-copied array from an array-like object or an iterable.
 * @since 0.9.7
 * @group Polyfill
 * @group ArrayLike
 * @group Array
 * @group Iterator
 * @typeParam T - Identifies the element type of the array-like or iterable.
 * @typeParam U - Identifies returned type of the array
 * @param theValue - An array-like object or iterable to convert to an array.
 * @param mapfn - A {@link ArrFromMapFn | mapping function} to call on every element of the array. If provided, every
 * value to be added to the array is first passed through this map function, and the return
 * value is added to the array instead. The function is called with the following arguments:
 * @param thisArg Value of 'this' used to invoke the mapfn.
 * @example
 * ```ts
 * polyArrFrom("Hello");
 * // [ "H", "e", "l", "l", "o" ]
 *
 * polyArrFrom(new Set(["Hello", "Darkness", "my", "old", "friend"]));
 * // ["Hello", "Darkness", "my", "old", "friend"]
 *
 * let map = new Map([
 *   [ 1, "Hello" ],
 *   [ 2, "Darkness" ],
 *   [ 3, "my" ],
 *   [ 4, "old" ],
 *   [ 5, "friend"]
 * ]);
 *
 * polyArrFrom(map.values());
 * // ["Hello", "Darkness", "my", "old", "friend"]
 *
 * polyArrFrom(map.keys());
 * // [ 1, 2, 3, 4, 5 ]
 *
 * polyArrFrom(map.entries());
 * // [ [ 1, "Hello" ], [ 2, "Darkness" ], [ 3, "my" ], [ 4, "old" ], [ 5, "friend"] ]
 *
 * polyArrFrom(map, ([ key, value ]) => ({ [key]: value }));
 * // [ {"1": "Hello"}, {"2": "Darkness"}, {"3": "my"}, {"4": "old"}, {"5": "friend"} ]
 * ```
 */
function polyArrFrom(theValue, mapFn, thisArg) {
    if ((0,_helpers_base__WEBPACK_IMPORTED_MODULE_0__.isArray)(theValue)) {
        var result_1 = (0,_array_slice__WEBPACK_IMPORTED_MODULE_5__.arrSlice)(theValue);
        return mapFn ? (0,_array_map__WEBPACK_IMPORTED_MODULE_6__.arrMap)(result_1, mapFn, thisArg) : result_1;
    }
    var result = [];
    (0,_iterator_forOf__WEBPACK_IMPORTED_MODULE_7__.iterForOf)(theValue, function (value, cnt) {
        return result.push(mapFn ? (0,_funcs_fnCall__WEBPACK_IMPORTED_MODULE_3__.fnCall)(mapFn, thisArg, value, cnt) : value);
    });
    return result;
}
//# sourceMappingURL=array.js.map

/***/ }),
/* 107 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   arrMap: () => (/* binding */ arrMap)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * The arrMap() method creates a new array populated with the results of calling a provided function on every
 * element in the calling array.
 *
 * `arrMap` calls a provided callbackFn function once for each element in an array, in order, and constructs
 * a new array from the results. callbackFn is invoked only for indexes of the array which have assigned
 * values (including undefined).
 *
 * It is not called for missing elements of the array; that is:
 * - indexes that have never been set;
 * - indexes which have been deleted.
 *
 * @since 0.3.3
 * @group Array
 * @group ArrayLike
 * @typeParam T - Identifies the type of the array elements
 * @typeParam R - Identifies the type of the elements returned by the callback function, defaults to T.
 * @param theArray - The array or array like object of elements to be searched.
 * @param callbackFn - The function that is called for evetn element of `theArray`.
 * @param thisArg - The value to use as the `this` when executing the `callbackFn`.
 * @example
 * ```ts
 * const numbers = [1, 4, 9];
 * const roots = arrMap(numbers, (num) => Math.sqrt(num));
 *
 * // roots is now     [1, 2, 3]
 * // numbers is still [1, 4, 9]
 *
 * const kvArray = [{ key: 1, value: 10 },
 *                  { key: 2, value: 20 },
 *                  { key: 3, value: 30 }];
 *
 * const reformattedArray = arrMap(kvArray, ({ key, value}) => ({ [key]: value }));
 *
 * // reformattedArray is now [{1: 10}, {2: 20}, {3: 30}],
 *
 * // kvArray is still:
 * // [{key: 1, value: 10},
 * //  {key: 2, value: 20},
 * //  {key: 3, value: 30}]
 *
 * // Also supports Array Like objects with same output
 * const kvArray = {
 *   length: 3,
 *   0: { key: 1, value: 10 },
 *   1: { key: 2, value: 20 },
 *   2: { key: 3, value: 30 }
 * };
 * ```
 */
var arrMap = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunction)("map", _internal_constants__WEBPACK_IMPORTED_MODULE_1__.ArrProto);
//# sourceMappingURL=map.js.map

/***/ }),
/* 108 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MinChannelPriorty: () => (/* binding */ MinChannelPriorty)
/* harmony export */ });
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */

var MinChannelPriorty = 100;
//# sourceMappingURL=IChannelControls.js.map

/***/ }),
/* 109 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EventsDiscardedReason: () => (/* binding */ EventsDiscardedReason)
/* harmony export */ });
/* harmony import */ var _JavaScriptSDK_Enums_EnumHelperFuncs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(103);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */



/**
 * The EventsDiscardedReason enumeration contains a set of values that specify the reason for discarding an event.
 */
var EventsDiscardedReason = (0,_JavaScriptSDK_Enums_EnumHelperFuncs__WEBPACK_IMPORTED_MODULE_0__.createEnumStyle)({
    /**
     * Unknown.
     */
    Unknown: 0 /* eEventsDiscardedReason.Unknown */,
    /**
     * Status set to non-retryable.
     */
    NonRetryableStatus: 1 /* eEventsDiscardedReason.NonRetryableStatus */,
    /**
     * The event is invalid.
     */
    InvalidEvent: 2 /* eEventsDiscardedReason.InvalidEvent */,
    /**
     * The size of the event is too large.
     */
    SizeLimitExceeded: 3 /* eEventsDiscardedReason.SizeLimitExceeded */,
    /**
     * The server is not accepting events from this instrumentation key.
     */
    KillSwitch: 4 /* eEventsDiscardedReason.KillSwitch */,
    /**
     * The event queue is full.
     */
    QueueFull: 5 /* eEventsDiscardedReason.QueueFull */
});
//# sourceMappingURL=EventsDiscardedReason.js.map

/***/ }),
/* 110 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LoggingSeverity: () => (/* binding */ LoggingSeverity)
/* harmony export */ });
/* harmony import */ var _JavaScriptSDK_Enums_EnumHelperFuncs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(103);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


//  @skip-file-minify

var LoggingSeverity = (0,_JavaScriptSDK_Enums_EnumHelperFuncs__WEBPACK_IMPORTED_MODULE_0__.createEnumStyle)({
    DISABLED: 0 /* eLoggingSeverity.DISABLED */,
    CRITICAL: 1 /* eLoggingSeverity.CRITICAL */,
    WARNING: 2 /* eLoggingSeverity.WARNING */,
    DEBUG: 3 /* eLoggingSeverity.DEBUG */
});
//# sourceMappingURL=LoggingEnums.js.map

/***/ }),
/* 111 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __getRegisteredEvents: () => (/* binding */ __getRegisteredEvents),
/* harmony export */   addEventHandler: () => (/* binding */ addEventHandler),
/* harmony export */   addEventListeners: () => (/* binding */ addEventListeners),
/* harmony export */   addPageHideEventListener: () => (/* binding */ addPageHideEventListener),
/* harmony export */   addPageShowEventListener: () => (/* binding */ addPageShowEventListener),
/* harmony export */   addPageUnloadEventListener: () => (/* binding */ addPageUnloadEventListener),
/* harmony export */   attachEvent: () => (/* binding */ attachEvent),
/* harmony export */   detachEvent: () => (/* binding */ detachEvent),
/* harmony export */   eventOff: () => (/* binding */ eventOff),
/* harmony export */   eventOn: () => (/* binding */ eventOn),
/* harmony export */   mergeEvtNamespace: () => (/* binding */ mergeEvtNamespace),
/* harmony export */   removeEventHandler: () => (/* binding */ removeEventHandler),
/* harmony export */   removeEventListeners: () => (/* binding */ removeEventListeners),
/* harmony export */   removePageHideEventListener: () => (/* binding */ removePageHideEventListener),
/* harmony export */   removePageShowEventListener: () => (/* binding */ removePageShowEventListener),
/* harmony export */   removePageUnloadEventListener: () => (/* binding */ removePageUnloadEventListener)
/* harmony export */ });
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(37);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(15);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(35);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(7);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(58);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(32);
/* harmony import */ var _DataCacheHelper__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(48);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(34);
/*
 * Application Insights JavaScript SDK - Core, 3.0.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */






// Added to help with minfication
var strOnPrefix = "on";
var strAttachEvent = "attachEvent";
var strAddEventHelper = "addEventListener";
var strDetachEvent = "detachEvent";
var strRemoveEventListener = "removeEventListener";
var strEvents = "events";
var strVisibilityChangeEvt = "visibilitychange";
var strPageHide = "pagehide";
var strPageShow = "pageshow";
var strUnload = "unload";
var strBeforeUnload = "beforeunload";
var strPageHideNamespace = (0,_DataCacheHelper__WEBPACK_IMPORTED_MODULE_0__.createUniqueNamespace)("aiEvtPageHide");
var strPageShowNamespace = (0,_DataCacheHelper__WEBPACK_IMPORTED_MODULE_0__.createUniqueNamespace)("aiEvtPageShow");
var rRemoveEmptyNs = /\.[\.]+/g;
var rRemoveTrailingEmptyNs = /[\.]+$/;
var _guid = 1;
var elmNodeData = (0,_DataCacheHelper__WEBPACK_IMPORTED_MODULE_0__.createElmNodeData)("events");
var eventNamespace = /^([^.]*)(?:\.(.+)|)/;
function _normalizeNamespace(name) {
    if (name && name[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_REPLACE /* @min:%2ereplace */]) {
        return name[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_REPLACE /* @min:%2ereplace */](/^[\s\.]+|(?=[\s\.])[\.\s]+$/g, _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY);
    }
    return name;
}
function _getEvtNamespace(eventName, evtNamespace) {
    var _a;
    if (evtNamespace) {
        var theNamespace_1 = _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY;
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isArray)(evtNamespace)) {
            theNamespace_1 = _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY;
            (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.arrForEach)(evtNamespace, function (name) {
                name = _normalizeNamespace(name);
                if (name) {
                    if (name[0] !== ".") {
                        name = "." + name;
                    }
                    theNamespace_1 += name;
                }
            });
        }
        else {
            theNamespace_1 = _normalizeNamespace(evtNamespace);
        }
        if (theNamespace_1) {
            if (theNamespace_1[0] !== ".") {
                theNamespace_1 = "." + theNamespace_1;
            }
            // We may only have the namespace and not an eventName
            eventName = (eventName || _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY) + theNamespace_1;
        }
    }
    var parsedEvent = (eventNamespace.exec(eventName || _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY) || []);
    return _a = {},
        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:type */] = parsedEvent[1],
        _a.ns = ((parsedEvent[2] || _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY).replace(rRemoveEmptyNs, ".").replace(rRemoveTrailingEmptyNs, _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPLIT /* @min:%2esplit */](".").sort()).join("."),
        _a;
}
/**
 * Get all of the registered events on the target object, this is primarily used for testing cleanup but may also be used by
 * applications to remove their own events
 * @param target - The EventTarget that has registered events
 * @param eventName - [Optional] The name of the event to return the registered handlers and full name (with namespaces)
 * @param evtNamespace - [Optional] Additional namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace,
 * if the eventName also includes a namespace the namespace(s) are merged into a single namespace
 */
function __getRegisteredEvents(target, eventName, evtNamespace) {
    var theEvents = [];
    var eventCache = elmNodeData.get(target, strEvents, {}, false);
    var evtName = _getEvtNamespace(eventName, evtNamespace);
    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objForEachKey)(eventCache, function (evtType, registeredEvents) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.arrForEach)(registeredEvents, function (value) {
            var _a;
            if (!evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */] || evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */] === value.evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */]) {
                if (!evtName.ns || evtName.ns === evtName.ns) {
                    theEvents[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */]((_a = {},
                        _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_NAME /* @min:name */] = value.evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */] + (value.evtName.ns ? "." + value.evtName.ns : _InternalConstants__WEBPACK_IMPORTED_MODULE_2__.STR_EMPTY),
                        _a.handler = value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HANDLER /* @min:%2ehandler */],
                        _a));
                }
            }
        });
    });
    return theEvents;
}
// Exported for internal unit testing only
function _getRegisteredEvents(target, evtName, addDefault) {
    if (addDefault === void 0) { addDefault = true; }
    var aiEvts = elmNodeData.get(target, strEvents, {}, addDefault);
    var registeredEvents = aiEvts[evtName];
    if (!registeredEvents) {
        registeredEvents = aiEvts[evtName] = [];
    }
    return registeredEvents;
}
function _doDetach(obj, evtName, handlerRef, useCapture) {
    if (obj && evtName && evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */]) {
        if (obj[strRemoveEventListener]) {
            obj[strRemoveEventListener](evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */], handlerRef, useCapture);
        }
        else if (obj[strDetachEvent]) {
            obj[strDetachEvent](strOnPrefix + evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */], handlerRef);
        }
    }
}
function _doAttach(obj, evtName, handlerRef, useCapture) {
    var result = false;
    if (obj && evtName && evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */] && handlerRef) {
        if (obj[strAddEventHelper]) {
            // all browsers except IE before version 9
            obj[strAddEventHelper](evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */], handlerRef, useCapture);
            result = true;
        }
        else if (obj[strAttachEvent]) {
            // IE before version 9
            obj[strAttachEvent](strOnPrefix + evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */], handlerRef);
            result = true;
        }
    }
    return result;
}
function _doUnregister(target, events, evtName, unRegFn) {
    var idx = events[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */];
    while (idx--) {
        var theEvent = events[idx];
        if (theEvent) {
            if (!evtName.ns || evtName.ns === theEvent.evtName.ns) {
                if (!unRegFn || unRegFn(theEvent)) {
                    _doDetach(target, theEvent.evtName, theEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HANDLER /* @min:%2ehandler */], theEvent.capture);
                    // Remove the registered event
                    events[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPLICE /* @min:%2esplice */](idx, 1);
                }
            }
        }
    }
}
function _unregisterEvents(target, evtName, unRegFn) {
    if (evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */]) {
        _doUnregister(target, _getRegisteredEvents(target, evtName[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TYPE /* @min:%2etype */]), evtName, unRegFn);
    }
    else {
        var eventCache = elmNodeData.get(target, strEvents, {});
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_5__.objForEachKey)(eventCache, function (evtType, events) {
            _doUnregister(target, events, evtName, unRegFn);
        });
        // Cleanup
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_6__.objKeys)(eventCache)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] === 0) {
            elmNodeData.kill(target, strEvents);
        }
    }
}
function mergeEvtNamespace(theNamespace, namespaces) {
    var newNamespaces;
    if (namespaces) {
        if ((0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isArray)(namespaces)) {
            newNamespaces = [theNamespace].concat(namespaces);
        }
        else {
            newNamespaces = [theNamespace, namespaces];
        }
        // resort the namespaces so they are always in order
        newNamespaces = (_getEvtNamespace("xx", newNamespaces).ns)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPLIT /* @min:%2esplit */](".");
    }
    else {
        newNamespaces = theNamespace;
    }
    return newNamespaces;
}
/**
 * Binds the specified function to an event, so that the function gets called whenever the event fires on the object
 * @param obj - Object to add the event too.
 * @param eventName - String that specifies any of the standard DHTML Events without "on" prefix, if may also include an optional (dot "." prefixed)
 * namespaces "click" "click.mynamespace" in addition to specific namespaces.
 * @param handlerRef - Pointer that specifies the function to call when event fires
 * @param evtNamespace - [Optional] Additional namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace,
 * if the eventName also includes a namespace the namespace(s) are merged into a single namespace
 * @param useCapture - [Optional] Defaults to false
 * @returns True if the function was bound successfully to the event, otherwise false
 */
function eventOn(target, eventName, handlerRef, evtNamespace, useCapture) {
    var _a;
    if (useCapture === void 0) { useCapture = false; }
    var result = false;
    if (target) {
        try {
            var evtName = _getEvtNamespace(eventName, evtNamespace);
            result = _doAttach(target, evtName, handlerRef, useCapture);
            if (result && elmNodeData.accept(target)) {
                var registeredEvent = (_a = {
                        guid: _guid++,
                        evtName: evtName
                    },
                    _a[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HANDLER /* @min:handler */] = handlerRef,
                    _a.capture = useCapture,
                    _a);
                _getRegisteredEvents(target, evtName.type)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](registeredEvent);
            }
        }
        catch (e) {
            // Just Ignore any error so that we don't break any execution path
        }
    }
    return result;
}
/**
 * Removes an event handler for the specified event
 * @param Object - to remove the event from
 * @param eventName - {string} - The name of the event, with optional namespaces or just the namespaces,
 * such as "click", "click.mynamespace" or ".mynamespace"
 * @param handlerRef - {any} - The callback function that needs to be removed from the given event, when using a
 * namespace (with or without a qualifying event) this may be null to remove all previously attached event handlers
 * otherwise this will only remove events with this specific handler.
 * @param evtNamespace - [Optional] Additional namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace,
 * if the eventName also includes a namespace the namespace(s) are merged into a single namespace
 * @param useCapture - [Optional] Defaults to false
 */
function eventOff(target, eventName, handlerRef, evtNamespace, useCapture) {
    if (useCapture === void 0) { useCapture = false; }
    if (target) {
        try {
            var evtName_1 = _getEvtNamespace(eventName, evtNamespace);
            var found_1 = false;
            _unregisterEvents(target, evtName_1, function (regEvent) {
                if ((evtName_1.ns && !handlerRef) || regEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HANDLER /* @min:%2ehandler */] === handlerRef) {
                    found_1 = true;
                    return true;
                }
                return false;
            });
            if (!found_1) {
                // fallback to try and remove as requested
                _doDetach(target, evtName_1, handlerRef, useCapture);
            }
        }
        catch (e) {
            // Just Ignore any error so that we don't break any execution path
        }
    }
}
/**
 * Binds the specified function to an event, so that the function gets called whenever the event fires on the object
 * @param obj - Object to add the event too.
 * @param eventNameWithoutOn - String that specifies any of the standard DHTML Events without "on" prefix and optional (dot "." prefixed) namespaces "click" "click.mynamespace".
 * @param handlerRef - Pointer that specifies the function to call when event fires
 * @param useCapture - [Optional] Defaults to false
 * @returns True if the function was bound successfully to the event, otherwise false
 */
function attachEvent(obj, eventNameWithoutOn, handlerRef, useCapture) {
    if (useCapture === void 0) { useCapture = false; }
    return eventOn(obj, eventNameWithoutOn, handlerRef, null, useCapture);
}
/**
 * Removes an event handler for the specified event
 * @param Object - to remove the event from
 * @param eventNameWithoutOn - {string} - The name of the event, with optional namespaces or just the namespaces,
 * such as "click", "click.mynamespace" or ".mynamespace"
 * @param handlerRef - {any} - The callback function that needs to be removed from the given event, when using a
 * namespace (with or without a qualifying event) this may be null to remove all previously attached event handlers
 * otherwise this will only remove events with this specific handler.
 * @param useCapture - [Optional] Defaults to false
 */
function detachEvent(obj, eventNameWithoutOn, handlerRef, useCapture) {
    if (useCapture === void 0) { useCapture = false; }
    eventOff(obj, eventNameWithoutOn, handlerRef, null, useCapture);
}
/**
 * Trys to add an event handler for the specified event to the window, body and document
 * @param eventName - {string} - The name of the event
 * @param callback - {any} - The callback function that needs to be executed for the given event
 * @param evtNamespace - [Optional] Namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace.
 * @return {boolean} - true if the handler was successfully added
 */
function addEventHandler(eventName, callback, evtNamespace) {
    var result = false;
    var w = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.getWindow)();
    if (w) {
        result = eventOn(w, eventName, callback, evtNamespace);
        result = eventOn(w["body"], eventName, callback, evtNamespace) || result;
    }
    var doc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.getDocument)();
    if (doc) {
        result = eventOn(doc, eventName, callback, evtNamespace) || result;
    }
    return result;
}
/**
 * Trys to remove event handler(s) for the specified event/namespace to the window, body and document
 * @param eventName - {string} - The name of the event, with optional namespaces or just the namespaces,
 * such as "click", "click.mynamespace" or ".mynamespace"
 * @param callback - {any} - - The callback function that needs to be removed from the given event, when using a
 * namespace (with or without a qualifying event) this may be null to remove all previously attached event handlers
 * otherwise this will only remove events with this specific handler.
 * @param evtNamespace - [Optional] Namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace.
 */
function removeEventHandler(eventName, callback, evtNamespace) {
    var w = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.getWindow)();
    if (w) {
        eventOff(w, eventName, callback, evtNamespace);
        eventOff(w["body"], eventName, callback, evtNamespace);
    }
    var doc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.getDocument)();
    if (doc) {
        eventOff(doc, eventName, callback, evtNamespace);
    }
}
/**
 * Bind the listener to the array of events
 * @param events - An string array of event names to bind the listener to
 * @param listener - The event callback to call when the event is triggered
 * @param excludeEvents - [Optional] An array of events that should not be hooked (if possible), unless no other events can be.
 * @param evtNamespace - [Optional] Namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace.
 * @returns true - when at least one of the events was registered otherwise false
 */
function _addEventListeners(events, listener, excludeEvents, evtNamespace) {
    var added = false;
    if (listener && events && events[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.arrForEach)(events, function (name) {
            if (name) {
                if (!excludeEvents || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__.arrIndexOf)(excludeEvents, name) === -1) {
                    added = addEventHandler(name, listener, evtNamespace) || added;
                }
            }
        });
    }
    return added;
}
/**
 * Bind the listener to the array of events
 * @param events - An string array of event names to bind the listener to
 * @param listener - The event callback to call when the event is triggered
 * @param excludeEvents - [Optional] An array of events that should not be hooked (if possible), unless no other events can be.
 * @param evtNamespace - [Optional] Namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace.
 * @returns true - when at least one of the events was registered otherwise false
 */
function addEventListeners(events, listener, excludeEvents, evtNamespace) {
    var added = false;
    if (listener && events && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isArray)(events)) {
        added = _addEventListeners(events, listener, excludeEvents, evtNamespace);
        if (!added && excludeEvents && excludeEvents[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
            // Failed to add any listeners and we excluded some, so just attempt to add the excluded events
            added = _addEventListeners(events, listener, null, evtNamespace);
        }
    }
    return added;
}
/**
 * Remove the listener from the array of events
 * @param events - An string array of event names to bind the listener to
 * @param listener - The event callback to call when the event is triggered
 * @param evtNamespace - [Optional] Namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace.
 */
function removeEventListeners(events, listener, evtNamespace) {
    if (events && (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.isArray)(events)) {
        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_4__.arrForEach)(events, function (name) {
            if (name) {
                removeEventHandler(name, listener, evtNamespace);
            }
        });
    }
}
/**
 * Listen to the 'beforeunload', 'unload' and 'pagehide' events which indicates a page unload is occurring,
 * this does NOT listen to the 'visibilitychange' event as while it does indicate that the page is being hidden
 * it does not *necessarily* mean that the page is being completely unloaded, it can mean that the user is
 * just navigating to a different Tab and may come back (without unloading the page). As such you may also
 * need to listen to the 'addPageHideEventListener' and 'addPageShowEventListener' events.
 * @param listener - The event callback to call when a page unload event is triggered
 * @param excludeEvents - [Optional] An array of events that should not be hooked, unless no other events can be.
 * @param evtNamespace - [Optional] Namespace(s) to append to the event listeners so they can be uniquely identified and removed based on this namespace.
 * @returns true - when at least one of the events was registered otherwise false
 */
function addPageUnloadEventListener(listener, excludeEvents, evtNamespace) {
    // Hook the unload event for the document, window and body to ensure that the client events are flushed to the server
    // As just hooking the window does not always fire (on chrome) for page navigation's.
    return addEventListeners([strBeforeUnload, strUnload, strPageHide], listener, excludeEvents, evtNamespace);
}
/**
 * Remove any matching 'beforeunload', 'unload' and 'pagehide' events that may have been added via addEventListener,
 * addEventListeners, addPageUnloadEventListener or addPageHideEventListener.
 * @param listener - The specific event callback to to be removed
 * @param evtNamespace - [Optional] Namespace(s) uniquely identified and removed based on this namespace.
 * @returns true - when at least one of the events was registered otherwise false
 */
function removePageUnloadEventListener(listener, evtNamespace) {
    removeEventListeners([strBeforeUnload, strUnload, strPageHide], listener, evtNamespace);
}
/**
 * Listen to the pagehide and visibility changing to 'hidden' events, because the 'visibilitychange' uses
 * an internal proxy to detect the visibility state you SHOULD use a unique namespace when if you plan to call
 * removePageShowEventListener as the remove ignores the listener argument for the 'visibilitychange' event.
 * @param listener - The event callback to call when a page hide event is triggered
 * @param excludeEvents - [Optional] An array of events that should not be hooked (if possible), unless no other events can be.
 * @param evtNamespace - [Optional] A Namespace to append to the event listeners so they can be uniquely identified and removed
 * based on this namespace. This call also adds an additional unique "pageshow" namespace to the events
 * so that only the matching "removePageHideEventListener" can remove these events.
 * Suggestion: pass as true if you are also calling addPageUnloadEventListener as that also hooks pagehide
 * @returns true - when at least one of the events was registered otherwise false
 */
function addPageHideEventListener(listener, excludeEvents, evtNamespace) {
    function _handlePageVisibility(evt) {
        var doc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.getDocument)();
        if (listener && doc && doc.visibilityState === "hidden") {
            listener(evt);
        }
    }
    // add the unique page show namespace to any provided namespace so we can only remove the ones added by "pagehide"
    var newNamespaces = mergeEvtNamespace(strPageHideNamespace, evtNamespace);
    var pageUnloadAdded = _addEventListeners([strPageHide], listener, excludeEvents, newNamespaces);
    if (!excludeEvents || (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__.arrIndexOf)(excludeEvents, strVisibilityChangeEvt) === -1) {
        pageUnloadAdded = _addEventListeners([strVisibilityChangeEvt], _handlePageVisibility, excludeEvents, newNamespaces) || pageUnloadAdded;
    }
    if (!pageUnloadAdded && excludeEvents) {
        // Failed to add any listeners and we where requested to exclude some, so just call again without excluding anything
        pageUnloadAdded = addPageHideEventListener(listener, null, evtNamespace);
    }
    return pageUnloadAdded;
}
/**
 * Removes the pageHide event listeners added by addPageHideEventListener, because the 'visibilitychange' uses
 * an internal proxy to detect the visibility state you SHOULD use a unique namespace when calling addPageHideEventListener
 * as the remove ignores the listener argument for the 'visibilitychange' event.
 * @param listener - The specific listener to remove for the 'pageshow' event only (ignored for 'visibilitychange')
 * @param evtNamespace - The unique namespace used when calling addPageShowEventListener
 */
function removePageHideEventListener(listener, evtNamespace) {
    // add the unique page show namespace to any provided namespace so we only remove the ones added by "pagehide"
    var newNamespaces = mergeEvtNamespace(strPageHideNamespace, evtNamespace);
    removeEventListeners([strPageHide], listener, newNamespaces);
    removeEventListeners([strVisibilityChangeEvt], null, newNamespaces);
}
/**
 * Listen to the pageshow and visibility changing to 'visible' events, because the 'visibilitychange' uses
 * an internal proxy to detect the visibility state you SHOULD use a unique namespace when if you plan to call
 * removePageShowEventListener as the remove ignores the listener argument for the 'visibilitychange' event.
 * @param listener - The event callback to call when a page is show event is triggered
 * @param excludeEvents - [Optional] An array of events that should not be hooked (if possible), unless no other events can be.
 * @param evtNamespace - [Optional/Recommended] A Namespace to append to the event listeners so they can be uniquely
 * identified and removed based on this namespace. This call also adds an additional unique "pageshow" namespace to the events
 * so that only the matching "removePageShowEventListener" can remove these events.
 * @returns true - when at least one of the events was registered otherwise false
 */
function addPageShowEventListener(listener, excludeEvents, evtNamespace) {
    function _handlePageVisibility(evt) {
        var doc = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_7__.getDocument)();
        if (listener && doc && doc.visibilityState === "visible") {
            listener(evt);
        }
    }
    // add the unique page show namespace to any provided namespace so we can only remove the ones added by "pageshow"
    var newNamespaces = mergeEvtNamespace(strPageShowNamespace, evtNamespace);
    var pageShowAdded = _addEventListeners([strPageShow], listener, excludeEvents, newNamespaces);
    pageShowAdded = _addEventListeners([strVisibilityChangeEvt], _handlePageVisibility, excludeEvents, newNamespaces) || pageShowAdded;
    if (!pageShowAdded && excludeEvents) {
        // Failed to add any listeners and we where requested to exclude some, so just call again without excluding anything
        pageShowAdded = addPageShowEventListener(listener, null, evtNamespace);
    }
    return pageShowAdded;
}
/**
 * Removes the pageShow event listeners added by addPageShowEventListener, because the 'visibilitychange' uses
 * an internal proxy to detect the visibility state you SHOULD use a unique namespace when calling addPageShowEventListener
 * as the remove ignores the listener argument for the 'visibilitychange' event.
 * @param listener - The specific listener to remove for the 'pageshow' event only (ignored for 'visibilitychange')
 * @param evtNamespace - The unique namespace used when calling addPageShowEventListener
 */
function removePageShowEventListener(listener, evtNamespace) {
    // add the unique page show namespace to any provided namespace so we only remove the ones added by "pageshow"
    var newNamespaces = mergeEvtNamespace(strPageShowNamespace, evtNamespace);
    removeEventListeners([strPageShow], listener, newNamespaces);
    removeEventListeners([strVisibilityChangeEvt], null, newNamespaces);
}
//# sourceMappingURL=EventHelpers.js.map

/***/ }),
/* 112 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   arrReduce: () => (/* binding */ arrReduce)
/* harmony export */ });
/* harmony import */ var _internal_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8);
/* harmony import */ var _internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25);
/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */


/**
 * The arrReduce() method executes a user-supplied "reducer" callback function on each element of the array,
 * in order, passing in the return value from the calculation on the preceding element. The final result of
 * running the reducer across all elements of the array is a single value.
 *
 * The first time that the callback is run there is no "return value of the previous calculation". If supplied,
 * an initial value may be used in its place. Otherwise the array element at index 0 is used as the initial
 * value and iteration starts from the next element (index 1 instead of index 0).
 * @group Array
 * @group ArrayLike
 * @typeParam T - Identifies the type of array elements
 * @param theArray - The array or array like object of elements to be searched.
 * @param callbackfn A function that accepts up to four arguments. The reduce method calls the callbackfn function one time for each element in the array.
 * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.
 * @returns The value that results from running the "reducer" callback function to completion over the entire array.
 * @example
 * ```ts
 * const getMax = (a: number, b: number) => Math.max(a, b);
 *
 * // callback is invoked for each element in the array starting at index 0
 * arrReduce([1, 100], getMax, 50); // 100
 * arrReduce([    50], getMax, 10); // 50
 *
 * // callback is invoked once for element at index 1
 * arrReduce([1, 100], getMax);     // 100
 *
 * // callback is not invoked
 * arrReduce([    50], getMax);     // 50
 * arrReduce([      ], getMax, 1);  // 1
 *
 * arrReduce([      ], getMax);     // throws TypeError
 *
 * // Also supports Array like objects
 * arrReduce({ length: 2, 0: 1, 1: 100 }, getMax, 50); // 100
 * arrReduce({ length: 1, 0: 50 }, getMax, 10); // 50
 *
 * // callback is invoked once for element at index 1
 * arrReduce({ length: 2, 0: 1, 1: 100 }, getMax);     // 100
 *
 * // callback is not invoked
 * arrReduce({ length: 1, 0: 50 }, getMax);     // 50
 * arrReduce({ length: 0 }, getMax, 1);  // 1
  * ```
 */
var arrReduce = (0,_internal_unwrapFunction__WEBPACK_IMPORTED_MODULE_0__._unwrapFunction)("reduce", _internal_constants__WEBPACK_IMPORTED_MODULE_1__.ArrProto);
//# sourceMappingURL=reduce.js.map

/***/ }),
/* 113 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BE_PROFILE: () => (/* reexport safe */ _DataModels__WEBPACK_IMPORTED_MODULE_1__.BE_PROFILE),
/* harmony export */   NRT_PROFILE: () => (/* reexport safe */ _DataModels__WEBPACK_IMPORTED_MODULE_1__.NRT_PROFILE),
/* harmony export */   PostChannel: () => (/* reexport safe */ _PostChannel__WEBPACK_IMPORTED_MODULE_0__.PostChannel),
/* harmony export */   RT_PROFILE: () => (/* reexport safe */ _DataModels__WEBPACK_IMPORTED_MODULE_1__.RT_PROFILE)
/* harmony export */ });
/* harmony import */ var _DataModels__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(114);
/* harmony import */ var _PostChannel__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(115);
/*
 * 1DS JS SDK POST plugin, 4.0.3
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
* @name Index.ts
* @author Abhilash Panwar (abpanwar)
* @copyright Microsoft 2018
* File to export public classes.
*/



//# sourceMappingURL=Index.js.map

/***/ }),
/* 114 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BE_PROFILE: () => (/* binding */ BE_PROFILE),
/* harmony export */   NRT_PROFILE: () => (/* binding */ NRT_PROFILE),
/* harmony export */   RT_PROFILE: () => (/* binding */ RT_PROFILE)
/* harmony export */ });
/*
 * 1DS JS SDK POST plugin, 4.0.3
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
 * Real Time profile (default profile). RealTime Latency events are sent every 1 sec and
 * Normal Latency events are sent every 2 sec.
 */
var RT_PROFILE = "REAL_TIME";
/**
 * Near Real Time profile. RealTime Latency events are sent every 3 sec and
 * Normal Latency events are sent every 6 sec.
 */
var NRT_PROFILE = "NEAR_REAL_TIME";
/**
 * Best Effort. RealTime Latency events are sent every 9 sec and
 * Normal Latency events are sent every 18 sec.
 */
var BE_PROFILE = "BEST_EFFORT";
//# sourceMappingURL=DataModels.js.map

/***/ }),
/* 115 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PostChannel: () => (/* binding */ PostChannel)
/* harmony export */ });
/* harmony import */ var _microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(44);
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(21);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(46);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(111);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(48);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(47);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(90);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(7);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(33);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(109);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(37);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(15);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(67);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(94);
/* harmony import */ var _nevware21_ts_async__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(71);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(35);
/* harmony import */ var _DataModels__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(114);
/* harmony import */ var _EventBatch__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(116);
/* harmony import */ var _HttpManager__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(119);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(117);
/* harmony import */ var _RetryPolicy__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(122);
/* harmony import */ var _TimeoutOverrideWrapper__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(124);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(118);
/*
 * 1DS JS SDK POST plugin, 4.0.3
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */

/**
* PostManager.ts
* @author Abhilash Panwar (abpanwar); Hector Hernandez (hectorh); Nev Wylie (newylie)
* @copyright Microsoft 2018-2020
*/











var FlushCheckTimer = 0.250; // This needs to be in seconds, so this is 250ms
var MaxNumberEventPerBatch = 500;
var EventsDroppedAtOneTime = 20;
var MaxSendAttempts = 6;
var MaxSyncUnloadSendAttempts = 2; // Assuming 2 based on beforeunload and unload
var MaxBackoffCount = 4;
var MaxConnections = 2;
var MaxRequestRetriesBeforeBackoff = 1;
var MaxEventsLimitInMem = 10000;
var strEventsDiscarded = "eventsDiscarded";
var undefValue = undefined;
/**
 * The default settings for the config.
 * WE MUST include all defaults here to ensure that the config is created with all of the properties
 * defined as dynamic.
 */
var defaultPostChannelConfig = (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_0__.objDeepFreeze)({
    eventsLimitInMem: { isVal: _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.isGreaterThanZero, v: MaxEventsLimitInMem },
    immediateEventLimit: { isVal: _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.isGreaterThanZero, v: 500 },
    autoFlushEventsLimit: { isVal: _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.isGreaterThanZero, v: 0 },
    disableAutoBatchFlushLimit: false,
    httpXHROverride: { isVal: isOverrideFn, v: undefValue },
    overrideInstrumentationKey: undefValue,
    overrideEndpointUrl: undefValue,
    disableTelemetry: false,
    ignoreMc1Ms0CookieProcessing: false,
    setTimeoutOverride: undefValue,
    clearTimeoutOverride: undefValue,
    payloadPreprocessor: undefValue,
    payloadListener: undefValue,
    disableEventTimings: undefValue,
    valueSanitizer: undefValue,
    stringifyObjects: undefValue,
    enableCompoundKey: undefValue,
    disableOptimizeObj: false,
    // disableCacheHeader: undefValue, // See Task #7178858 - Collector requires a change to support this
    transports: undefValue,
    unloadTransports: undefValue,
    useSendBeacon: undefValue,
    disableFetchKeepAlive: undefValue,
    avoidOptions: false,
    xhrTimeout: undefValue,
    disableXhrSync: undefValue,
    alwaysUseXhrOverride: false,
    maxEventRetryAttempts: { isVal: _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_2__.isNumber, v: MaxSendAttempts },
    maxUnloadEventRetryAttempts: { isVal: _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_2__.isNumber, v: MaxSyncUnloadSendAttempts },
    addNoResponse: undefValue
});
function isOverrideFn(httpXHROverride) {
    return httpXHROverride && httpXHROverride[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SEND_POST /* @min:%2esendPOST */];
}
/**
 * Class that manages adding events to inbound queues and batching of events
 * into requests.
 * @group Classes
 * @group Entrypoint
 */
var PostChannel = /** @class */ (function (_super) {
    (0,_microsoft_applicationinsights_shims__WEBPACK_IMPORTED_MODULE_4__.__extendsFn)(PostChannel, _super);
    function PostChannel() {
        var _this = _super.call(this) || this;
        _this.identifier = "PostChannel";
        _this.priority = 1011;
        _this.version = '4.0.3';
        var _postConfig;
        var _isTeardownCalled = false;
        var _flushCallbackQueue = [];
        var _flushCallbackTimer;
        var _paused = false;
        var _immediateQueueSize = 0;
        var _immediateQueueSizeLimit;
        var _queueSize = 0;
        var _queueSizeLimit;
        var _profiles = {};
        var _currentProfile = _DataModels__WEBPACK_IMPORTED_MODULE_5__.RT_PROFILE;
        var _scheduledTimer;
        var _immediateTimer;
        var _currentBackoffCount;
        var _timerCount;
        var _httpManager;
        var _batchQueues;
        var _autoFlushEventsLimit;
        // either MaxBatchSize * (1+ Max Connections) or _queueLimit / 6 (where 3 latency Queues [normal, realtime, cost deferred] * 2 [allow half full -- allow for retry])
        var _autoFlushBatchLimit;
        var _delayedBatchSendLatency;
        var _delayedBatchReason;
        var _optimizeObject;
        var _isPageUnloadTriggered;
        var _maxEventSendAttempts;
        var _maxUnloadEventSendAttempts;
        var _evtNamespace;
        var _timeoutWrapper;
        var _ignoreMc1Ms0CookieProcessing;
        var _disableAutoBatchFlushLimit;
        var _notificationManager;
        var _unloadHandlersAdded;
        var _overrideInstrumentationKey;
        var _disableTelemetry;
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_6__["default"])(PostChannel, _this, function (_self, _base) {
            _initDefaults();
            // Special internal method to allow the DebugPlugin to hook embedded objects
            _self["_getDbgPlgTargets"] = function () {
                return [_httpManager, _postConfig];
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_INITIALIZE /* @min:%2einitialize */] = function (theConfig, core, extensions) {
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_7__.doPerf)(core, function () { return "PostChannel:initialize"; }, function () {
                    _base[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_INITIALIZE /* @min:%2einitialize */](theConfig, core, extensions);
                    _notificationManager = core.getNotifyMgr();
                    try {
                        _evtNamespace = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.mergeEvtNamespace)((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_9__.createUniqueNamespace)(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_IDENTIFIER /* @min:%2eidentifier */]), core.evtNamespace && core.evtNamespace());
                        _self._addHook((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_10__.onConfigChange)(theConfig, function (details) {
                            var coreConfig = details.cfg;
                            var ctx = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__.createProcessTelemetryContext)(null, coreConfig, core);
                            _postConfig = ctx.getExtCfg(_self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_IDENTIFIER /* @min:%2eidentifier */], defaultPostChannelConfig);
                            _timeoutWrapper = (0,_TimeoutOverrideWrapper__WEBPACK_IMPORTED_MODULE_12__.createTimeoutWrapper)(_postConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SET_TIMEOUT_OVERRIDE /* @min:%2esetTimeoutOverride */], _postConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_CLEAR_TIMEOUT_OVERRI3 /* @min:%2eclearTimeoutOverride */]);
                            // Only try and use the optimizeObject() if this appears to be a chromium based browser and it has not been explicitly disabled
                            _optimizeObject = !_postConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_DISABLE_OPTIMIZE_OBJ /* @min:%2edisableOptimizeObj */] && (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.isChromium)();
                            _ignoreMc1Ms0CookieProcessing = _postConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_IGNORE_MC1_MS0_COOKI12 /* @min:%2eignoreMc1Ms0CookieProcessing */];
                            _hookWParam(core); // _hookWParam uses _ignoreMc1Ms0CookieProcessing
                            _queueSizeLimit = _postConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_EVENTS_LIMIT_IN_MEM /* @min:%2eeventsLimitInMem */];
                            _immediateQueueSizeLimit = _postConfig.immediateEventLimit;
                            _autoFlushEventsLimit = _postConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_AUTO_FLUSH_EVENTS_LI13 /* @min:%2eautoFlushEventsLimit */];
                            _maxEventSendAttempts = _postConfig.maxEventRetryAttempts;
                            _maxUnloadEventSendAttempts = _postConfig.maxUnloadEventRetryAttempts;
                            _disableAutoBatchFlushLimit = _postConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_DISABLE_AUTO_BATCH_F14 /* @min:%2edisableAutoBatchFlushLimit */];
                            _setAutoLimits();
                            // Override iKey if provided in Post config if provided for during initialization
                            _overrideInstrumentationKey = _postConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_OVERRIDE_INSTRUMENTA15 /* @min:%2eoverrideInstrumentationKey */];
                            // DisableTelemetry was defined in the config provided during initialization
                            _disableTelemetry = !!_postConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_DISABLE_TELEMETRY /* @min:%2edisableTelemetry */];
                            if (_unloadHandlersAdded) {
                                _removeUnloadHandlers();
                            }
                            var excludePageUnloadEvents = coreConfig.disablePageUnloadEvents || [];
                            // When running in Web browsers try to send all telemetry if page is unloaded
                            _unloadHandlersAdded = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.addPageUnloadEventListener)(_handleUnloadEvents, excludePageUnloadEvents, _evtNamespace);
                            _unloadHandlersAdded = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.addPageHideEventListener)(_handleUnloadEvents, excludePageUnloadEvents, _evtNamespace) || _unloadHandlersAdded;
                            _unloadHandlersAdded = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.addPageShowEventListener)(_handleShowEvents, coreConfig.disablePageShowEvents, _evtNamespace) || _unloadHandlersAdded;
                        }));
                        // only initialize the manager once
                        _httpManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_INITIALIZE /* @min:%2einitialize */](theConfig, _self.core, _self);
                    }
                    catch (e) {
                        // resetting the initialized state because of failure
                        _self.setInitialized(false);
                        throw e;
                    }
                }, function () { return ({ theConfig: theConfig, core: core, extensions: extensions }); });
            };
            _self.processTelemetry = function (ev, itemCtx) {
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.setProcessTelemetryTimings)(ev, _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_IDENTIFIER /* @min:%2eidentifier */]);
                itemCtx = itemCtx || _self._getTelCtx(itemCtx);
                var event = ev;
                if (!_disableTelemetry && !_isTeardownCalled) {
                    // Override iKey if provided in Post config if provided for during initialization
                    if (_overrideInstrumentationKey) {
                        event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_I_KEY /* @min:%2eiKey */] = _overrideInstrumentationKey;
                    }
                    _addEventToQueues(event, true);
                    if (_isPageUnloadTriggered) {
                        // Unload event has been received so we need to try and flush new events
                        _releaseAllQueues(2 /* EventSendType.SendBeacon */, 2 /* SendRequestReason.Unload */);
                    }
                    else {
                        _scheduleTimer();
                    }
                }
                _self.processNext(event, itemCtx);
            };
            _self._doTeardown = function (unloadCtx, unloadState) {
                _releaseAllQueues(2 /* EventSendType.SendBeacon */, 2 /* SendRequestReason.Unload */);
                _isTeardownCalled = true;
                _httpManager.teardown();
                _removeUnloadHandlers();
                // Just register to remove all events associated with this namespace
                _initDefaults();
            };
            function _removeUnloadHandlers() {
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.removePageUnloadEventListener)(null, _evtNamespace);
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.removePageHideEventListener)(null, _evtNamespace);
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__.removePageShowEventListener)(null, _evtNamespace);
            }
            function _hookWParam(core) {
                var existingGetWParamMethod = core[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_GET_WPARAM /* @min:%2egetWParam */];
                core[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_GET_WPARAM /* @min:%2egetWParam */] = function () {
                    var wparam = 0;
                    if (_ignoreMc1Ms0CookieProcessing) {
                        wparam = wparam | 2;
                    }
                    return wparam | existingGetWParamMethod.call(core);
                };
            }
            // Moving event handlers out from the initialize closure so that any local variables can be garbage collected
            function _handleUnloadEvents(evt) {
                var theEvt = evt || (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_13__.getWindow)().event; // IE 8 does not pass the event
                if (theEvt.type !== "beforeunload") {
                    // Only set the unload trigger if not beforeunload event as beforeunload can be cancelled while the other events can't
                    _isPageUnloadTriggered = true;
                    _httpManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SET_UNLOADING /* @min:%2esetUnloading */](_isPageUnloadTriggered);
                }
                _releaseAllQueues(2 /* EventSendType.SendBeacon */, 2 /* SendRequestReason.Unload */);
            }
            function _handleShowEvents(evt) {
                // Handle the page becoming visible again
                _isPageUnloadTriggered = false;
                _httpManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SET_UNLOADING /* @min:%2esetUnloading */](_isPageUnloadTriggered);
            }
            function _addEventToQueues(event, append) {
                // If send attempt field is undefined we should set it to 0.
                if (!event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SEND_ATTEMPT /* @min:%2esendAttempt */]) {
                    event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SEND_ATTEMPT /* @min:%2esendAttempt */] = 0;
                }
                // Add default latency
                if (!event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LATENCY /* @min:%2elatency */]) {
                    event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LATENCY /* @min:%2elatency */] = 1 /* EventLatencyValue.Normal */;
                }
                // Remove extra AI properties if present
                if (event.ext && event.ext[_InternalConstants__WEBPACK_IMPORTED_MODULE_14__.STR_TRACE]) {
                    delete (event.ext[_InternalConstants__WEBPACK_IMPORTED_MODULE_14__.STR_TRACE]);
                }
                if (event.ext && event.ext[_InternalConstants__WEBPACK_IMPORTED_MODULE_14__.STR_USER] && event.ext[_InternalConstants__WEBPACK_IMPORTED_MODULE_14__.STR_USER]["id"]) {
                    delete (event.ext[_InternalConstants__WEBPACK_IMPORTED_MODULE_14__.STR_USER]["id"]);
                }
                // v8 performance optimization for iterating over the keys
                if (_optimizeObject) {
                    event.ext = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_15__.optimizeObject)(event.ext);
                    if (event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_BASE_DATA /* @min:%2ebaseData */]) {
                        event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_BASE_DATA /* @min:%2ebaseData */] = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_15__.optimizeObject)(event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_BASE_DATA /* @min:%2ebaseData */]);
                    }
                    if (event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_DATA /* @min:%2edata */]) {
                        event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_DATA /* @min:%2edata */] = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_15__.optimizeObject)(event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_DATA /* @min:%2edata */]);
                    }
                }
                if (event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SYNC /* @min:%2esync */]) {
                    // If the transmission is backed off then do not send synchronous events.
                    // We will convert these events to Real time latency instead.
                    if (_currentBackoffCount || _paused) {
                        event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LATENCY /* @min:%2elatency */] = 3 /* EventLatencyValue.RealTime */;
                        event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SYNC /* @min:%2esync */] = false;
                    }
                    else {
                        // Log the event synchronously
                        if (_httpManager) {
                            // v8 performance optimization for iterating over the keys
                            if (_optimizeObject) {
                                event = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_15__.optimizeObject)(event);
                            }
                            _httpManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SEND_SYNCHRONOUS_BAT9 /* @min:%2esendSynchronousBatch */](_EventBatch__WEBPACK_IMPORTED_MODULE_16__.EventBatch.create(event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_I_KEY /* @min:%2eiKey */], [event]), event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SYNC /* @min:%2esync */] === true ? 1 /* EventSendType.Synchronous */ : event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SYNC /* @min:%2esync */], 3 /* SendRequestReason.SyncEvent */);
                            return;
                        }
                    }
                }
                var evtLatency = event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LATENCY /* @min:%2elatency */];
                var queueSize = _queueSize;
                var queueLimit = _queueSizeLimit;
                if (evtLatency === 4 /* EventLatencyValue.Immediate */) {
                    queueSize = _immediateQueueSize;
                    queueLimit = _immediateQueueSizeLimit;
                }
                var eventDropped = false;
                // Only add the event if the queue isn't full or it's a direct event (which don't add to the queue sizes)
                if (queueSize < queueLimit) {
                    eventDropped = !_addEventToProperQueue(event, append);
                }
                else {
                    var dropLatency = 1 /* EventLatencyValue.Normal */;
                    var dropNumber = EventsDroppedAtOneTime;
                    if (evtLatency === 4 /* EventLatencyValue.Immediate */) {
                        // Only drop other immediate events as they are not technically sharing the general queue
                        dropLatency = 4 /* EventLatencyValue.Immediate */;
                        dropNumber = 1;
                    }
                    // Drop old event from lower or equal latency
                    eventDropped = true;
                    if (_dropEventWithLatencyOrLess(event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_I_KEY /* @min:%2eiKey */], event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LATENCY /* @min:%2elatency */], dropLatency, dropNumber)) {
                        eventDropped = !_addEventToProperQueue(event, append);
                    }
                }
                if (eventDropped) {
                    // Can't drop events from current queues because the all the slots are taken by queues that are being flushed.
                    _notifyEvents(strEventsDiscarded, [event], _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_17__.EventsDiscardedReason.QueueFull);
                }
            }
            _self.setEventQueueLimits = function (eventLimit, autoFlushLimit) {
                _postConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_EVENTS_LIMIT_IN_MEM /* @min:%2eeventsLimitInMem */] = _queueSizeLimit = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.isGreaterThanZero)(eventLimit) ? eventLimit : MaxEventsLimitInMem;
                _postConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_AUTO_FLUSH_EVENTS_LI13 /* @min:%2eautoFlushEventsLimit */] = _autoFlushEventsLimit = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.isGreaterThanZero)(autoFlushLimit) ? autoFlushLimit : 0;
                _setAutoLimits();
                // We only do this check here as during normal event addition if the queue is > then events start getting dropped
                var doFlush = _queueSize > eventLimit;
                if (!doFlush && _autoFlushBatchLimit > 0) {
                    // Check the auto flush max batch size
                    for (var latency = 1 /* EventLatencyValue.Normal */; !doFlush && latency <= 3 /* EventLatencyValue.RealTime */; latency++) {
                        var batchQueue = _batchQueues[latency];
                        if (batchQueue && batchQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_BATCHES /* @min:%2ebatches */]) {
                            (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_18__.arrForEach)(batchQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_BATCHES /* @min:%2ebatches */], function (theBatch) {
                                if (theBatch && theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_COUNT /* @min:%2ecount */]() >= _autoFlushBatchLimit) {
                                    // If any 1 batch is > than the limit then trigger an auto flush
                                    doFlush = true;
                                }
                            });
                        }
                    }
                }
                _performAutoFlush(true, doFlush);
            };
            _self.pause = function () {
                _clearScheduledTimer();
                _paused = true;
                _httpManager.pause();
            };
            _self.resume = function () {
                _paused = false;
                _httpManager.resume();
                _scheduleTimer();
            };
            _self._loadTransmitProfiles = function (profiles) {
                _resetTransmitProfiles();
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_19__.objForEachKey)(profiles, function (profileName, profileValue) {
                    var profLen = profileValue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LENGTH /* @min:%2elength */];
                    if (profLen >= 2) {
                        var directValue = (profLen > 2 ? profileValue[2] : 0);
                        profileValue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SPLICE /* @min:%2esplice */](0, profLen - 2);
                        // Make sure if a higher latency is set to not send then don't send lower latency
                        if (profileValue[1] < 0) {
                            profileValue[0] = -1;
                        }
                        // Make sure each latency is multiple of the latency higher then it. If not a multiple
                        // we round up so that it becomes a multiple.
                        if (profileValue[1] > 0 && profileValue[0] > 0) {
                            var timerMultiplier = profileValue[0] / profileValue[1];
                            profileValue[0] = Math.ceil(timerMultiplier) * profileValue[1];
                        }
                        // Add back the direct profile timeout
                        if (directValue >= 0 && profileValue[1] >= 0 && directValue > profileValue[1]) {
                            // Make sure if it's not disabled (< 0) then make sure it's not larger than RealTime
                            directValue = profileValue[1];
                        }
                        profileValue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_PUSH /* @min:%2epush */](directValue);
                        _profiles[profileName] = profileValue;
                    }
                });
            };
            _self.flush = function (async, callback, sendReason) {
                if (async === void 0) { async = true; }
                var result;
                if (!_paused) {
                    sendReason = sendReason || 1 /* SendRequestReason.ManualFlush */;
                    if (async) {
                        if (!callback) {
                            result = (0,_nevware21_ts_async__WEBPACK_IMPORTED_MODULE_20__.createPromise)(function (resolve) {
                                // Set the callback to the promise resolve callback
                                callback = resolve;
                            });
                        }
                        if (_flushCallbackTimer == null) {
                            // Clear the normal schedule timer as we are going to try and flush ASAP
                            _clearScheduledTimer();
                            // Move all queued events to the HttpManager so that we don't discard new events (Auto flush scenario)
                            _queueBatches(1 /* EventLatencyValue.Normal */, 0 /* EventSendType.Batched */, sendReason);
                            _flushCallbackTimer = _createTimer(function () {
                                _flushCallbackTimer = null;
                                _flushImpl(callback, sendReason);
                            }, 0);
                        }
                        else {
                            // Even if null (no callback) this will ensure after the flushImpl finishes waiting
                            // for a completely idle connection it will attempt to re-flush any queued events on the next cycle
                            _flushCallbackQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_PUSH /* @min:%2epush */](callback);
                        }
                    }
                    else {
                        // Clear the normal schedule timer as we are going to try and flush ASAP
                        var cleared = _clearScheduledTimer();
                        // Now cause all queued events to be sent synchronously
                        _sendEventsForLatencyAndAbove(1 /* EventLatencyValue.Normal */, 1 /* EventSendType.Synchronous */, sendReason);
                        callback && callback();
                        if (cleared) {
                            // restart the normal event timer if it was cleared
                            _scheduleTimer();
                        }
                    }
                }
                return result;
            };
            _self.setMsaAuthTicket = function (ticket) {
                _httpManager.addHeader(_InternalConstants__WEBPACK_IMPORTED_MODULE_14__.STR_MSA_DEVICE_TICKET, ticket);
            };
            _self.hasEvents = _hasEvents;
            _self._setTransmitProfile = function (profileName) {
                if (_currentProfile !== profileName && _profiles[profileName] !== undefined) {
                    _clearScheduledTimer();
                    _currentProfile = profileName;
                    _scheduleTimer();
                }
            };
            (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_15__.proxyFunctions)(_self, function () { return _httpManager; }, ["addResponseHandler"]);
            /**
             * Batch and send events currently in the queue for the given latency.
             * @param latency - Latency for which to send events.
             */
            function _sendEventsForLatencyAndAbove(latency, sendType, sendReason) {
                var queued = _queueBatches(latency, sendType, sendReason);
                // Always trigger the request as while the post channel may not have queued additional events, the httpManager may already have waiting events
                _httpManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SEND_QUEUED_REQUESTS /* @min:%2esendQueuedRequests */](sendType, sendReason);
                return queued;
            }
            function _hasEvents() {
                return _queueSize > 0;
            }
            /**
             * Try to schedule the timer after which events will be sent. If there are
             * no events to be sent, or there is already a timer scheduled, or the
             * http manager doesn't have any idle connections this method is no-op.
             */
            function _scheduleTimer() {
                // If we had previously attempted to send requests, but the http manager didn't have any idle connections then the requests where delayed
                // so try and requeue then again now
                if (_delayedBatchSendLatency >= 0 && _queueBatches(_delayedBatchSendLatency, 0 /* EventSendType.Batched */, _delayedBatchReason)) {
                    _httpManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SEND_QUEUED_REQUESTS /* @min:%2esendQueuedRequests */](0 /* EventSendType.Batched */, _delayedBatchReason);
                }
                if (_immediateQueueSize > 0 && !_immediateTimer && !_paused) {
                    // During initialization _profiles enforce that the direct [2] is less than real time [1] timer value
                    // If the immediateTimeout is disabled the immediate events will be sent with Real Time events
                    var immediateTimeOut = _profiles[_currentProfile][2];
                    if (immediateTimeOut >= 0) {
                        _immediateTimer = _createTimer(function () {
                            _immediateTimer = null;
                            // Only try to send direct events
                            _sendEventsForLatencyAndAbove(4 /* EventLatencyValue.Immediate */, 0 /* EventSendType.Batched */, 1 /* SendRequestReason.NormalSchedule */);
                            _scheduleTimer();
                        }, immediateTimeOut);
                    }
                }
                // During initialization the _profiles enforce that the normal [0] is a multiple of the real time [1] timer value
                var timeOut = _profiles[_currentProfile][1];
                if (!_scheduledTimer && !_flushCallbackTimer && timeOut >= 0 && !_paused) {
                    if (_hasEvents()) {
                        _scheduledTimer = _createTimer(function () {
                            _scheduledTimer = null;
                            _sendEventsForLatencyAndAbove(_timerCount === 0 ? 3 /* EventLatencyValue.RealTime */ : 1 /* EventLatencyValue.Normal */, 0 /* EventSendType.Batched */, 1 /* SendRequestReason.NormalSchedule */);
                            // Increment the count for next cycle
                            _timerCount++;
                            _timerCount %= 2;
                            _scheduleTimer();
                        }, timeOut);
                    }
                    else {
                        _timerCount = 0;
                    }
                }
            }
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN__BACK_OFF_TRANSMISSI11 /* @min:%2e_backOffTransmission */] = function () {
                if (_currentBackoffCount < MaxBackoffCount) {
                    _currentBackoffCount++;
                    _clearScheduledTimer();
                    _scheduleTimer();
                }
            };
            _self._clearBackOff = function () {
                if (_currentBackoffCount) {
                    _currentBackoffCount = 0;
                    _clearScheduledTimer();
                    _scheduleTimer();
                }
            };
            function _initDefaults() {
                _postConfig = null;
                _isTeardownCalled = false;
                _flushCallbackQueue = [];
                _flushCallbackTimer = null;
                _paused = false;
                _immediateQueueSize = 0;
                _immediateQueueSizeLimit = 500;
                _queueSize = 0;
                _queueSizeLimit = MaxEventsLimitInMem;
                _profiles = {};
                _currentProfile = _DataModels__WEBPACK_IMPORTED_MODULE_5__.RT_PROFILE;
                _scheduledTimer = null;
                _immediateTimer = null;
                _currentBackoffCount = 0;
                _timerCount = 0;
                _batchQueues = {};
                _autoFlushEventsLimit = 0;
                _unloadHandlersAdded = false;
                // either MaxBatchSize * (1+ Max Connections) or _queueLimit / 6 (where 3 latency Queues [normal, realtime, cost deferred] * 2 [allow half full -- allow for retry])
                _autoFlushBatchLimit = 0;
                _delayedBatchSendLatency = -1;
                _delayedBatchReason = null;
                _optimizeObject = true;
                _isPageUnloadTriggered = false;
                _maxEventSendAttempts = MaxSendAttempts;
                _maxUnloadEventSendAttempts = MaxSyncUnloadSendAttempts;
                _evtNamespace = null;
                _overrideInstrumentationKey = null;
                _disableTelemetry = false;
                _timeoutWrapper = (0,_TimeoutOverrideWrapper__WEBPACK_IMPORTED_MODULE_12__.createTimeoutWrapper)();
                _httpManager = new _HttpManager__WEBPACK_IMPORTED_MODULE_21__.HttpManager(MaxNumberEventPerBatch, MaxConnections, MaxRequestRetriesBeforeBackoff, {
                    requeue: _requeueEvents,
                    send: _sendingEvent,
                    sent: _eventsSentEvent,
                    drop: _eventsDropped,
                    rspFail: _eventsResponseFail,
                    oth: _otherEvent
                });
                _initializeProfiles();
                _clearQueues();
                _setAutoLimits();
            }
            function _createTimer(theTimerFunc, timeOut) {
                // If the transmission is backed off make the timer at least 1 sec to allow for back off.
                if (timeOut === 0 && _currentBackoffCount) {
                    timeOut = 1;
                }
                var timerMultiplier = 1000;
                if (_currentBackoffCount) {
                    timerMultiplier = (0,_RetryPolicy__WEBPACK_IMPORTED_MODULE_22__.retryPolicyGetMillisToBackoffForRetry)(_currentBackoffCount - 1);
                }
                return _timeoutWrapper.set(theTimerFunc, timeOut * timerMultiplier);
            }
            function _clearScheduledTimer() {
                if (_scheduledTimer !== null) {
                    _scheduledTimer.cancel();
                    _scheduledTimer = null;
                    _timerCount = 0;
                    return true;
                }
                return false;
            }
            // Try to send all queued events using beacons if available
            function _releaseAllQueues(sendType, sendReason) {
                _clearScheduledTimer();
                // Cancel all flush callbacks
                if (_flushCallbackTimer) {
                    _flushCallbackTimer.cancel();
                    _flushCallbackTimer = null;
                }
                if (!_paused) {
                    // Queue all the remaining requests to be sent. The requests will be sent using HTML5 Beacons if they are available.
                    _sendEventsForLatencyAndAbove(1 /* EventLatencyValue.Normal */, sendType, sendReason);
                }
            }
            /**
             * Add empty queues for all latencies in the inbound queues map. This is called
             * when Transmission Manager is being flushed. This ensures that new events added
             * after flush are stored separately till we flush the current events.
             */
            function _clearQueues() {
                _batchQueues[4 /* EventLatencyValue.Immediate */] = {
                    batches: [],
                    iKeyMap: {}
                };
                _batchQueues[3 /* EventLatencyValue.RealTime */] = {
                    batches: [],
                    iKeyMap: {}
                };
                _batchQueues[2 /* EventLatencyValue.CostDeferred */] = {
                    batches: [],
                    iKeyMap: {}
                };
                _batchQueues[1 /* EventLatencyValue.Normal */] = {
                    batches: [],
                    iKeyMap: {}
                };
            }
            function _getEventBatch(iKey, latency, create) {
                var batchQueue = _batchQueues[latency];
                if (!batchQueue) {
                    latency = 1 /* EventLatencyValue.Normal */;
                    batchQueue = _batchQueues[latency];
                }
                var eventBatch = batchQueue.iKeyMap[iKey];
                if (!eventBatch && create) {
                    eventBatch = _EventBatch__WEBPACK_IMPORTED_MODULE_16__.EventBatch.create(iKey);
                    batchQueue.batches[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_PUSH /* @min:%2epush */](eventBatch);
                    batchQueue.iKeyMap[iKey] = eventBatch;
                }
                return eventBatch;
            }
            function _performAutoFlush(isAsync, doFlush) {
                // Only perform the auto flush check if the httpManager has an idle connection and we are not in a backoff situation
                if (_httpManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_CAN_SEND_REQUEST /* @min:%2ecanSendRequest */]() && !_currentBackoffCount) {
                    if (_autoFlushEventsLimit > 0 && _queueSize > _autoFlushEventsLimit) {
                        // Force flushing
                        doFlush = true;
                    }
                    if (doFlush && _flushCallbackTimer == null) {
                        // Auto flush the queue, adding a callback to avoid the creation of a promise
                        _self.flush(isAsync, function () { }, 20 /* SendRequestReason.MaxQueuedEvents */);
                    }
                }
            }
            function _addEventToProperQueue(event, append) {
                // v8 performance optimization for iterating over the keys
                if (_optimizeObject) {
                    event = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_15__.optimizeObject)(event);
                }
                var latency = event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LATENCY /* @min:%2elatency */];
                var eventBatch = _getEventBatch(event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_I_KEY /* @min:%2eiKey */], latency, true);
                if (eventBatch.addEvent(event)) {
                    if (latency !== 4 /* EventLatencyValue.Immediate */) {
                        _queueSize++;
                        // Check for auto flushing based on total events in the queue, but not for requeued or retry events
                        if (append && event[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SEND_ATTEMPT /* @min:%2esendAttempt */] === 0) {
                            // Force the flushing of the batch if the batch (specific iKey / latency combination) reaches it's auto flush limit
                            _performAutoFlush(!event.sync, _autoFlushBatchLimit > 0 && eventBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_COUNT /* @min:%2ecount */]() >= _autoFlushBatchLimit);
                        }
                    }
                    else {
                        // Direct events don't need auto flushing as they are scheduled (by default) for immediate delivery
                        _immediateQueueSize++;
                    }
                    return true;
                }
                return false;
            }
            function _dropEventWithLatencyOrLess(iKey, latency, currentLatency, dropNumber) {
                while (currentLatency <= latency) {
                    var eventBatch = _getEventBatch(iKey, latency, true);
                    if (eventBatch && eventBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_COUNT /* @min:%2ecount */]() > 0) {
                        // Dropped oldest events from lowest possible latency
                        var droppedEvents = eventBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SPLIT /* @min:%2esplit */](0, dropNumber);
                        var droppedCount = droppedEvents[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_COUNT /* @min:%2ecount */]();
                        if (droppedCount > 0) {
                            if (currentLatency === 4 /* EventLatencyValue.Immediate */) {
                                _immediateQueueSize -= droppedCount;
                            }
                            else {
                                _queueSize -= droppedCount;
                            }
                            _notifyBatchEvents(strEventsDiscarded, [droppedEvents], _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_17__.EventsDiscardedReason.QueueFull);
                            return true;
                        }
                    }
                    currentLatency++;
                }
                // Unable to drop any events -- lets just make sure the queue counts are correct to avoid exhaustion
                _resetQueueCounts();
                return false;
            }
            /**
             * Internal helper to reset the queue counts, used as a backstop to avoid future queue exhaustion errors
             * that might occur because of counting issues.
             */
            function _resetQueueCounts() {
                var immediateQueue = 0;
                var normalQueue = 0;
                var _loop_1 = function (latency) {
                    var batchQueue = _batchQueues[latency];
                    if (batchQueue && batchQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_BATCHES /* @min:%2ebatches */]) {
                        (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_18__.arrForEach)(batchQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_BATCHES /* @min:%2ebatches */], function (theBatch) {
                            if (latency === 4 /* EventLatencyValue.Immediate */) {
                                immediateQueue += theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_COUNT /* @min:%2ecount */]();
                            }
                            else {
                                normalQueue += theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_COUNT /* @min:%2ecount */]();
                            }
                        });
                    }
                };
                for (var latency = 1 /* EventLatencyValue.Normal */; latency <= 4 /* EventLatencyValue.Immediate */; latency++) {
                    _loop_1(latency);
                }
                _queueSize = normalQueue;
                _immediateQueueSize = immediateQueue;
            }
            function _queueBatches(latency, sendType, sendReason) {
                var eventsQueued = false;
                var isAsync = sendType === 0 /* EventSendType.Batched */;
                // Only queue batches (to the HttpManager) if this is a sync request or the httpManager has an idle connection
                // Thus keeping the events within the PostChannel until the HttpManager has a connection available
                // This is so we can drop "old" events if the queue is getting full because we can't successfully send events
                if (!isAsync || _httpManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_CAN_SEND_REQUEST /* @min:%2ecanSendRequest */]()) {
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_7__.doPerf)(_self.core, function () { return "PostChannel._queueBatches"; }, function () {
                        var droppedEvents = [];
                        var latencyToProcess = 4 /* EventLatencyValue.Immediate */;
                        while (latencyToProcess >= latency) {
                            var batchQueue = _batchQueues[latencyToProcess];
                            if (batchQueue && batchQueue.batches && batchQueue.batches[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LENGTH /* @min:%2elength */] > 0) {
                                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_18__.arrForEach)(batchQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_BATCHES /* @min:%2ebatches */], function (theBatch) {
                                    // Add the batch to the http manager to send the requests
                                    if (!_httpManager.addBatch(theBatch)) {
                                        // The events from this iKey are being dropped (killed)
                                        droppedEvents = droppedEvents[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_CONCAT /* @min:%2econcat */](theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_EVENTS /* @min:%2eevents */]());
                                    }
                                    else {
                                        eventsQueued = eventsQueued || (theBatch && theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_COUNT /* @min:%2ecount */]() > 0);
                                    }
                                    if (latencyToProcess === 4 /* EventLatencyValue.Immediate */) {
                                        _immediateQueueSize -= theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_COUNT /* @min:%2ecount */]();
                                    }
                                    else {
                                        _queueSize -= theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_COUNT /* @min:%2ecount */]();
                                    }
                                });
                                // Remove all batches from this Queue
                                batchQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_BATCHES /* @min:%2ebatches */] = [];
                                batchQueue.iKeyMap = {};
                            }
                            latencyToProcess--;
                        }
                        if (droppedEvents[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LENGTH /* @min:%2elength */] > 0) {
                            _notifyEvents(strEventsDiscarded, droppedEvents, _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_17__.EventsDiscardedReason.KillSwitch);
                        }
                        if (eventsQueued && _delayedBatchSendLatency >= latency) {
                            // We have queued events at the same level as the delayed values so clear the setting
                            _delayedBatchSendLatency = -1;
                            _delayedBatchReason = 0 /* SendRequestReason.Undefined */;
                        }
                    }, function () { return ({ latency: latency, sendType: sendType, sendReason: sendReason }); }, !isAsync);
                }
                else {
                    // remember the min latency so that we can re-trigger later
                    _delayedBatchSendLatency = _delayedBatchSendLatency >= 0 ? Math.min(_delayedBatchSendLatency, latency) : latency;
                    _delayedBatchReason = Math.max(_delayedBatchReason, sendReason);
                }
                return eventsQueued;
            }
            /**
             * This is the callback method is called as part of the manual flushing process.
             * @param callback
             * @param sendReason
             */
            function _flushImpl(callback, sendReason) {
                // Add any additional queued events and cause all queued events to be sent asynchronously
                _sendEventsForLatencyAndAbove(1 /* EventLatencyValue.Normal */, 0 /* EventSendType.Batched */, sendReason);
                // All events (should) have been queue -- lets just make sure the queue counts are correct to avoid queue exhaustion (previous bug #9685112)
                _resetQueueCounts();
                _waitForIdleManager(function () {
                    // Only called AFTER the httpManager does not have any outstanding requests
                    if (callback) {
                        callback();
                    }
                    if (_flushCallbackQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LENGTH /* @min:%2elength */] > 0) {
                        _flushCallbackTimer = _createTimer(function () {
                            _flushCallbackTimer = null;
                            _flushImpl(_flushCallbackQueue.shift(), sendReason);
                        }, 0);
                    }
                    else {
                        // No more flush requests
                        _flushCallbackTimer = null;
                        // Restart the normal timer schedule
                        _scheduleTimer();
                    }
                });
            }
            function _waitForIdleManager(callback) {
                if (_httpManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_IS_COMPLETELY_IDLE /* @min:%2eisCompletelyIdle */]()) {
                    callback();
                }
                else {
                    _flushCallbackTimer = _createTimer(function () {
                        _flushCallbackTimer = null;
                        _waitForIdleManager(callback);
                    }, FlushCheckTimer);
                }
            }
            /**
             * Resets the transmit profiles to the default profiles of Real Time, Near Real Time
             * and Best Effort. This removes all the custom profiles that were loaded.
             */
            function _resetTransmitProfiles() {
                _clearScheduledTimer();
                _initializeProfiles();
                _currentProfile = _DataModels__WEBPACK_IMPORTED_MODULE_5__.RT_PROFILE;
                _scheduleTimer();
            }
            function _initializeProfiles() {
                _profiles = {};
                _profiles[_DataModels__WEBPACK_IMPORTED_MODULE_5__.RT_PROFILE] = [2, 1, 0];
                _profiles[_DataModels__WEBPACK_IMPORTED_MODULE_5__.NRT_PROFILE] = [6, 3, 0];
                _profiles[_DataModels__WEBPACK_IMPORTED_MODULE_5__.BE_PROFILE] = [18, 9, 0];
            }
            /**
             * The notification handler for requeue events
             * @ignore
             */
            function _requeueEvents(batches, reason) {
                var droppedEvents = [];
                var maxSendAttempts = _maxEventSendAttempts;
                if (_isPageUnloadTriggered) {
                    // If a page unlaod has been triggered reduce the number of times we try to "retry"
                    maxSendAttempts = _maxUnloadEventSendAttempts;
                }
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_18__.arrForEach)(batches, function (theBatch) {
                    if (theBatch && theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_COUNT /* @min:%2ecount */]() > 0) {
                        (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_18__.arrForEach)(theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_EVENTS /* @min:%2eevents */](), function (theEvent) {
                            if (theEvent) {
                                // Check if the request being added back is for a sync event in which case mark it no longer a sync event
                                if (theEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SYNC /* @min:%2esync */]) {
                                    theEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LATENCY /* @min:%2elatency */] = 4 /* EventLatencyValue.Immediate */;
                                    theEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SYNC /* @min:%2esync */] = false;
                                }
                                if (theEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_SEND_ATTEMPT /* @min:%2esendAttempt */] < maxSendAttempts) {
                                    // Reset the event timings
                                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_1__.setProcessTelemetryTimings)(theEvent, _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_IDENTIFIER /* @min:%2eidentifier */]);
                                    _addEventToQueues(theEvent, false);
                                }
                                else {
                                    droppedEvents[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_PUSH /* @min:%2epush */](theEvent);
                                }
                            }
                        });
                    }
                });
                if (droppedEvents[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    _notifyEvents(strEventsDiscarded, droppedEvents, _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_17__.EventsDiscardedReason.NonRetryableStatus);
                }
                if (_isPageUnloadTriggered) {
                    // Unload event has been received so we need to try and flush new events
                    _releaseAllQueues(2 /* EventSendType.SendBeacon */, 2 /* SendRequestReason.Unload */);
                }
            }
            function _callNotification(evtName, theArgs) {
                var manager = (_notificationManager || {});
                var notifyFunc = manager[evtName];
                if (notifyFunc) {
                    try {
                        notifyFunc.apply(manager, theArgs);
                    }
                    catch (e) {
                        (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_23__._throwInternal)(_self.diagLog(), 1 /* eLoggingSeverity.CRITICAL */, 74 /* _eInternalMessageId.NotificationException */, evtName + " notification failed: " + e);
                    }
                }
            }
            function _notifyEvents(evtName, theEvents) {
                var extraArgs = [];
                for (var _i = 2; _i < arguments.length; _i++) {
                    extraArgs[_i - 2] = arguments[_i];
                }
                if (theEvents && theEvents[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    _callNotification(evtName, [theEvents][_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_CONCAT /* @min:%2econcat */](extraArgs));
                }
            }
            function _notifyBatchEvents(evtName, batches) {
                var extraArgs = [];
                for (var _i = 2; _i < arguments.length; _i++) {
                    extraArgs[_i - 2] = arguments[_i];
                }
                if (batches && batches[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_18__.arrForEach)(batches, function (theBatch) {
                        if (theBatch && theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_COUNT /* @min:%2ecount */]() > 0) {
                            _callNotification(evtName, [theBatch.events()][_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_CONCAT /* @min:%2econcat */](extraArgs));
                        }
                    });
                }
            }
            /**
             * The notification handler for when batches are about to be sent
             * @ignore
             */
            function _sendingEvent(batches, reason, isSyncRequest) {
                if (batches && batches[_DynamicConstants__WEBPACK_IMPORTED_MODULE_3__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    _callNotification("eventsSendRequest", [(reason >= 1000 /* EventBatchNotificationReason.SendingUndefined */ && reason <= 1999 /* EventBatchNotificationReason.SendingEventMax */ ?
                            reason - 1000 /* EventBatchNotificationReason.SendingUndefined */ :
                            0 /* SendRequestReason.Undefined */), isSyncRequest !== true]);
                }
            }
            /**
             * This event represents that a batch of events have been successfully sent and a response received
             * @param batches The notification handler for when the batches have been successfully sent
             * @param reason For this event the reason will always be EventBatchNotificationReason.Complete
             */
            function _eventsSentEvent(batches, reason) {
                _notifyBatchEvents("eventsSent", batches, reason);
                // Try and schedule the processing timer if we have events
                _scheduleTimer();
            }
            function _eventsDropped(batches, reason) {
                _notifyBatchEvents(strEventsDiscarded, batches, (reason >= 8000 /* EventBatchNotificationReason.EventsDropped */ && reason <= 8999 /* EventBatchNotificationReason.EventsDroppedMax */ ?
                    reason - 8000 /* EventBatchNotificationReason.EventsDropped */ :
                    _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_17__.EventsDiscardedReason.Unknown));
            }
            function _eventsResponseFail(batches) {
                _notifyBatchEvents(strEventsDiscarded, batches, _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_17__.EventsDiscardedReason.NonRetryableStatus);
                // Try and schedule the processing timer if we have events
                _scheduleTimer();
            }
            function _otherEvent(batches, reason) {
                _notifyBatchEvents(strEventsDiscarded, batches, _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_17__.EventsDiscardedReason.Unknown);
                // Try and schedule the processing timer if we have events
                _scheduleTimer();
            }
            function _setAutoLimits() {
                if (!_disableAutoBatchFlushLimit) {
                    _autoFlushBatchLimit = Math.max(MaxNumberEventPerBatch * (MaxConnections + 1), _queueSizeLimit / 6);
                }
                else {
                    _autoFlushBatchLimit = 0;
                }
            }
        });
        return _this;
    }
// Removed Stub for PostChannel.prototype.initialize.
// Removed Stub for PostChannel.prototype.processTelemetry.
// Removed Stub for PostChannel.prototype.setEventQueueLimits.
// Removed Stub for PostChannel.prototype.pause.
// Removed Stub for PostChannel.prototype.resume.
// Removed Stub for PostChannel.prototype.addResponseHandler.
// Removed Stub for PostChannel.prototype.flush.
// Removed Stub for PostChannel.prototype.setMsaAuthTicket.
// Removed Stub for PostChannel.prototype.hasEvents.
// Removed Stub for PostChannel.prototype._loadTransmitProfiles.
// Removed Stub for PostChannel.prototype._setTransmitProfile.
// Removed Stub for PostChannel.prototype._backOffTransmission.
// Removed Stub for PostChannel.prototype._clearBackOff.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    PostChannel.__ieDyn=1;

    return PostChannel;
}(_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_24__.BaseTelemetryPlugin));

//# sourceMappingURL=PostChannel.js.map

/***/ }),
/* 116 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EventBatch: () => (/* binding */ EventBatch)
/* harmony export */ });
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(21);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(117);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(118);
/*
 * 1DS JS SDK POST plugin, 4.0.3
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
* EventBatch.ts
* @author Nev Wylie (newylie)
* @copyright Microsoft 2020
*/



function _getEventMsfpc(theEvent) {
    var intWeb = ((theEvent.ext || {})["intweb"]);
    if (intWeb && (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_0__.isValueAssigned)(intWeb[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_MSFPC])) {
        return intWeb[_InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_MSFPC];
    }
    return null;
}
function _getMsfpc(theEvents) {
    var msfpc = null;
    for (var lp = 0; msfpc === null && lp < theEvents[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */]; lp++) {
        msfpc = _getEventMsfpc(theEvents[lp]);
    }
    return msfpc;
}
/**
* This class defines a "batch" events related to a specific iKey, it is used by the PostChannel and HttpManager
* to collect and transfer ownership of events without duplicating them in-memory. This reduces the previous
* array duplication and shared ownership issues that occurred due to race conditions caused by the async nature
* of sending requests.
*/
var EventBatch = /** @class */ (function () {
    /**
     * Private constructor so that caller is forced to use the static create method.
     * @param iKey - The iKey to associate with the events (not validated)
     * @param addEvents - The optional collection of events to assign to this batch - defaults to an empty array.
     */
    function EventBatch(iKey, addEvents) {
        var events = addEvents ? [][_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_CONCAT /* @min:%2econcat */](addEvents) : [];
        var _self = this;
        var _msfpc = _getMsfpc(events);
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_I_KEY /* @min:%2eiKey */] = function () {
            return iKey;
        };
        _self.Msfpc = function () {
            // return the cached value unless it's undefined -- used to avoid cpu
            return _msfpc || _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY;
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_COUNT /* @min:%2ecount */] = function () {
            return events[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */];
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_EVENTS /* @min:%2eevents */] = function () {
            return events;
        };
        _self.addEvent = function (theEvent) {
            if (theEvent) {
                events[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_PUSH /* @min:%2epush */](theEvent);
                if (!_msfpc) {
                    // Not found so try and find one
                    _msfpc = _getEventMsfpc(theEvent);
                }
                return true;
            }
            return false;
        };
        _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_SPLIT /* @min:%2esplit */] = function (fromEvent, numEvents) {
            // Create a new batch with the same iKey
            var theEvents;
            if (fromEvent < events[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */]) {
                var cnt = events[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_LENGTH /* @min:%2elength */] - fromEvent;
                if (!(0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_3__.isNullOrUndefined)(numEvents)) {
                    cnt = numEvents < cnt ? numEvents : cnt;
                }
                theEvents = events[_DynamicConstants__WEBPACK_IMPORTED_MODULE_2__._DYN_SPLICE /* @min:%2esplice */](fromEvent, cnt);
                // reset the fetched msfpc value
                _msfpc = _getMsfpc(events);
            }
            return new EventBatch(iKey, theEvents);
        };
    }
    /**
     * Creates a new Event Batch object
     * @param iKey The iKey associated with this batch of events
     */
    EventBatch.create = function (iKey, theEvents) {
        return new EventBatch(iKey, theEvents);
    };
    return EventBatch;
}());

//# sourceMappingURL=EventBatch.js.map

/***/ }),
/* 117 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DEFAULT_CACHE_CONTROL: () => (/* binding */ DEFAULT_CACHE_CONTROL),
/* harmony export */   DEFAULT_CONTENT_TYPE: () => (/* binding */ DEFAULT_CONTENT_TYPE),
/* harmony export */   STR_API_KEY: () => (/* binding */ STR_API_KEY),
/* harmony export */   STR_AUTH_XTOKEN: () => (/* binding */ STR_AUTH_XTOKEN),
/* harmony export */   STR_CACHE_CONTROL: () => (/* binding */ STR_CACHE_CONTROL),
/* harmony export */   STR_CLIENT_ID: () => (/* binding */ STR_CLIENT_ID),
/* harmony export */   STR_CLIENT_VERSION: () => (/* binding */ STR_CLIENT_VERSION),
/* harmony export */   STR_CONTENT_TYPE_HEADER: () => (/* binding */ STR_CONTENT_TYPE_HEADER),
/* harmony export */   STR_DISABLED_PROPERTY_NAME: () => (/* binding */ STR_DISABLED_PROPERTY_NAME),
/* harmony export */   STR_DROPPED: () => (/* binding */ STR_DROPPED),
/* harmony export */   STR_EMPTY: () => (/* binding */ STR_EMPTY),
/* harmony export */   STR_KILL_DURATION_HEADER: () => (/* binding */ STR_KILL_DURATION_HEADER),
/* harmony export */   STR_KILL_DURATION_SECONDS_HEADER: () => (/* binding */ STR_KILL_DURATION_SECONDS_HEADER),
/* harmony export */   STR_KILL_TOKENS_HEADER: () => (/* binding */ STR_KILL_TOKENS_HEADER),
/* harmony export */   STR_MSA_DEVICE_TICKET: () => (/* binding */ STR_MSA_DEVICE_TICKET),
/* harmony export */   STR_MSFPC: () => (/* binding */ STR_MSFPC),
/* harmony export */   STR_NO_RESPONSE_BODY: () => (/* binding */ STR_NO_RESPONSE_BODY),
/* harmony export */   STR_OTHER: () => (/* binding */ STR_OTHER),
/* harmony export */   STR_POST_METHOD: () => (/* binding */ STR_POST_METHOD),
/* harmony export */   STR_REQUEUE: () => (/* binding */ STR_REQUEUE),
/* harmony export */   STR_RESPONSE_FAIL: () => (/* binding */ STR_RESPONSE_FAIL),
/* harmony export */   STR_SDK_VERSION: () => (/* binding */ STR_SDK_VERSION),
/* harmony export */   STR_SENDING: () => (/* binding */ STR_SENDING),
/* harmony export */   STR_TIME_DELTA_HEADER: () => (/* binding */ STR_TIME_DELTA_HEADER),
/* harmony export */   STR_TIME_DELTA_TO_APPLY: () => (/* binding */ STR_TIME_DELTA_TO_APPLY),
/* harmony export */   STR_TRACE: () => (/* binding */ STR_TRACE),
/* harmony export */   STR_UPLOAD_TIME: () => (/* binding */ STR_UPLOAD_TIME),
/* harmony export */   STR_USER: () => (/* binding */ STR_USER)
/* harmony export */ });
/*
 * 1DS JS SDK POST plugin, 4.0.3
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */

// Licensed under the MIT License.
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Note: DON'T Export these const from the package as we are still targeting ES3 this will export a mutable variables that someone could change!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Generally you should only put values that are used more than 2 times and then only if not already exposed as a constant (such as SdkCoreNames)
// as when using "short" named values from here they will be will be minified smaller than the SdkCoreNames[eSdkCoreNames.xxxx] value.
var STR_EMPTY = "";
var STR_POST_METHOD = "POST";
var STR_DISABLED_PROPERTY_NAME = "Microsoft_ApplicationInsights_BypassAjaxInstrumentation";
var STR_DROPPED = "drop";
var STR_SENDING = "send";
var STR_REQUEUE = "requeue";
var STR_RESPONSE_FAIL = "rspFail";
var STR_OTHER = "oth";
var DEFAULT_CACHE_CONTROL = "no-cache, no-store";
var DEFAULT_CONTENT_TYPE = "application/x-json-stream";
var STR_CACHE_CONTROL = "cache-control";
var STR_CONTENT_TYPE_HEADER = "content-type";
var STR_KILL_TOKENS_HEADER = "kill-tokens";
var STR_KILL_DURATION_HEADER = "kill-duration";
var STR_KILL_DURATION_SECONDS_HEADER = "kill-duration-seconds";
var STR_TIME_DELTA_HEADER = "time-delta-millis";
var STR_CLIENT_VERSION = "client-version";
var STR_CLIENT_ID = "client-id";
var STR_TIME_DELTA_TO_APPLY = "time-delta-to-apply-millis";
var STR_UPLOAD_TIME = "upload-time";
var STR_API_KEY = "apikey";
var STR_MSA_DEVICE_TICKET = "AuthMsaDeviceTicket";
var STR_AUTH_XTOKEN = "AuthXToken";
var STR_SDK_VERSION = "sdk-version";
var STR_NO_RESPONSE_BODY = "NoResponseBody";
var STR_MSFPC = "msfpc";
var STR_TRACE = "trace";
var STR_USER = "user";
//# sourceMappingURL=InternalConstants.js.map

/***/ }),
/* 118 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _DYN_ALLOW_REQUEST_SENDIN0: () => (/* binding */ _DYN_ALLOW_REQUEST_SENDIN0),
/* harmony export */   _DYN_ALWAYS_USE_XHR_OVERR7: () => (/* binding */ _DYN_ALWAYS_USE_XHR_OVERR7),
/* harmony export */   _DYN_AUTO_FLUSH_EVENTS_LI13: () => (/* binding */ _DYN_AUTO_FLUSH_EVENTS_LI13),
/* harmony export */   _DYN_AVOID_OPTIONS: () => (/* binding */ _DYN_AVOID_OPTIONS),
/* harmony export */   _DYN_BASE_DATA: () => (/* binding */ _DYN_BASE_DATA),
/* harmony export */   _DYN_BATCHES: () => (/* binding */ _DYN_BATCHES),
/* harmony export */   _DYN_CAN_SEND_REQUEST: () => (/* binding */ _DYN_CAN_SEND_REQUEST),
/* harmony export */   _DYN_CLEAR_TIMEOUT_OVERRI3: () => (/* binding */ _DYN_CLEAR_TIMEOUT_OVERRI3),
/* harmony export */   _DYN_CONCAT: () => (/* binding */ _DYN_CONCAT),
/* harmony export */   _DYN_COUNT: () => (/* binding */ _DYN_COUNT),
/* harmony export */   _DYN_DATA: () => (/* binding */ _DYN_DATA),
/* harmony export */   _DYN_DISABLE_AUTO_BATCH_F14: () => (/* binding */ _DYN_DISABLE_AUTO_BATCH_F14),
/* harmony export */   _DYN_DISABLE_EVENT_TIMING5: () => (/* binding */ _DYN_DISABLE_EVENT_TIMING5),
/* harmony export */   _DYN_DISABLE_FETCH_KEEP_A6: () => (/* binding */ _DYN_DISABLE_FETCH_KEEP_A6),
/* harmony export */   _DYN_DISABLE_OPTIMIZE_OBJ: () => (/* binding */ _DYN_DISABLE_OPTIMIZE_OBJ),
/* harmony export */   _DYN_DISABLE_TELEMETRY: () => (/* binding */ _DYN_DISABLE_TELEMETRY),
/* harmony export */   _DYN_DISABLE_XHR_SYNC: () => (/* binding */ _DYN_DISABLE_XHR_SYNC),
/* harmony export */   _DYN_ENABLE_COMPOUND_KEY: () => (/* binding */ _DYN_ENABLE_COMPOUND_KEY),
/* harmony export */   _DYN_EVENTS: () => (/* binding */ _DYN_EVENTS),
/* harmony export */   _DYN_EVENTS_LIMIT_IN_MEM: () => (/* binding */ _DYN_EVENTS_LIMIT_IN_MEM),
/* harmony export */   _DYN_FIRST_REQUEST_SENT: () => (/* binding */ _DYN_FIRST_REQUEST_SENT),
/* harmony export */   _DYN_GET_ALL_RESPONSE_HEA8: () => (/* binding */ _DYN_GET_ALL_RESPONSE_HEA8),
/* harmony export */   _DYN_GET_CLOCK_SKEW_HEADE2: () => (/* binding */ _DYN_GET_CLOCK_SKEW_HEADE2),
/* harmony export */   _DYN_GET_RESPONSE_HEADER: () => (/* binding */ _DYN_GET_RESPONSE_HEADER),
/* harmony export */   _DYN_GET_WPARAM: () => (/* binding */ _DYN_GET_WPARAM),
/* harmony export */   _DYN_HDRS: () => (/* binding */ _DYN_HDRS),
/* harmony export */   _DYN_HEADERS: () => (/* binding */ _DYN_HEADERS),
/* harmony export */   _DYN_IDENTIFIER: () => (/* binding */ _DYN_IDENTIFIER),
/* harmony export */   _DYN_IGNORE_MC1_MS0_COOKI12: () => (/* binding */ _DYN_IGNORE_MC1_MS0_COOKI12),
/* harmony export */   _DYN_INITIALIZE: () => (/* binding */ _DYN_INITIALIZE),
/* harmony export */   _DYN_IS_BEACON: () => (/* binding */ _DYN_IS_BEACON),
/* harmony export */   _DYN_IS_COMPLETELY_IDLE: () => (/* binding */ _DYN_IS_COMPLETELY_IDLE),
/* harmony export */   _DYN_IS_SYNC: () => (/* binding */ _DYN_IS_SYNC),
/* harmony export */   _DYN_IS_TEARDOWN: () => (/* binding */ _DYN_IS_TEARDOWN),
/* harmony export */   _DYN_IS_TENANT_KILLED: () => (/* binding */ _DYN_IS_TENANT_KILLED),
/* harmony export */   _DYN_I_KEY: () => (/* binding */ _DYN_I_KEY),
/* harmony export */   _DYN_LATENCY: () => (/* binding */ _DYN_LATENCY),
/* harmony export */   _DYN_LENGTH: () => (/* binding */ _DYN_LENGTH),
/* harmony export */   _DYN_ONTIMEOUT: () => (/* binding */ _DYN_ONTIMEOUT),
/* harmony export */   _DYN_OVERRIDE_ENDPOINT_UR4: () => (/* binding */ _DYN_OVERRIDE_ENDPOINT_UR4),
/* harmony export */   _DYN_OVERRIDE_INSTRUMENTA15: () => (/* binding */ _DYN_OVERRIDE_INSTRUMENTA15),
/* harmony export */   _DYN_PAYLOAD_PREPROCESSOR: () => (/* binding */ _DYN_PAYLOAD_PREPROCESSOR),
/* harmony export */   _DYN_PUSH: () => (/* binding */ _DYN_PUSH),
/* harmony export */   _DYN_SEND_ATTEMPT: () => (/* binding */ _DYN_SEND_ATTEMPT),
/* harmony export */   _DYN_SEND_POST: () => (/* binding */ _DYN_SEND_POST),
/* harmony export */   _DYN_SEND_QUEUED_REQUESTS: () => (/* binding */ _DYN_SEND_QUEUED_REQUESTS),
/* harmony export */   _DYN_SEND_SYNCHRONOUS_BAT9: () => (/* binding */ _DYN_SEND_SYNCHRONOUS_BAT9),
/* harmony export */   _DYN_SEND_TYPE: () => (/* binding */ _DYN_SEND_TYPE),
/* harmony export */   _DYN_SET_CLOCK_SKEW: () => (/* binding */ _DYN_SET_CLOCK_SKEW),
/* harmony export */   _DYN_SET_KILL_SWITCH_TENA10: () => (/* binding */ _DYN_SET_KILL_SWITCH_TENA10),
/* harmony export */   _DYN_SET_TIMEOUT_OVERRIDE: () => (/* binding */ _DYN_SET_TIMEOUT_OVERRIDE),
/* harmony export */   _DYN_SET_UNLOADING: () => (/* binding */ _DYN_SET_UNLOADING),
/* harmony export */   _DYN_SHOULD_ADD_CLOCK_SKE1: () => (/* binding */ _DYN_SHOULD_ADD_CLOCK_SKE1),
/* harmony export */   _DYN_SPLICE: () => (/* binding */ _DYN_SPLICE),
/* harmony export */   _DYN_SPLIT: () => (/* binding */ _DYN_SPLIT),
/* harmony export */   _DYN_STRINGIFY_OBJECTS: () => (/* binding */ _DYN_STRINGIFY_OBJECTS),
/* harmony export */   _DYN_SYNC: () => (/* binding */ _DYN_SYNC),
/* harmony export */   _DYN_TIMEOUT: () => (/* binding */ _DYN_TIMEOUT),
/* harmony export */   _DYN_TIMINGS: () => (/* binding */ _DYN_TIMINGS),
/* harmony export */   _DYN_TO_LOWER_CASE: () => (/* binding */ _DYN_TO_LOWER_CASE),
/* harmony export */   _DYN_UNLOAD_TRANSPORTS: () => (/* binding */ _DYN_UNLOAD_TRANSPORTS),
/* harmony export */   _DYN_URL_STRING: () => (/* binding */ _DYN_URL_STRING),
/* harmony export */   _DYN_USE_HDRS: () => (/* binding */ _DYN_USE_HDRS),
/* harmony export */   _DYN_USE_SEND_BEACON: () => (/* binding */ _DYN_USE_SEND_BEACON),
/* harmony export */   _DYN__BACK_OFF_TRANSMISSI11: () => (/* binding */ _DYN__BACK_OFF_TRANSMISSI11),
/* harmony export */   _DYN__SEND_REASON: () => (/* binding */ _DYN__SEND_REASON),
/* harmony export */   _DYN__THE_PAYLOAD: () => (/* binding */ _DYN__THE_PAYLOAD),
/* harmony export */   _DYN__TRANSPORT: () => (/* binding */ _DYN__TRANSPORT)
/* harmony export */ });
/*
 * 1DS JS SDK POST plugin, 4.0.3
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */

// Licensed under the MIT License.
// @skip-file-minify
// ##############################################################
// AUTO GENERATED FILE: This file is Auto Generated during build.
// ##############################################################
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// Note: DON'T Export these const from the package as we are still targeting ES3 this will export a mutable variables that someone could change!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
var _DYN_ALLOW_REQUEST_SENDIN0 = "allowRequestSending"; // Count: 3
var _DYN_FIRST_REQUEST_SENT = "firstRequestSent"; // Count: 2
var _DYN_SHOULD_ADD_CLOCK_SKE1 = "shouldAddClockSkewHeaders"; // Count: 2
var _DYN_GET_CLOCK_SKEW_HEADE2 = "getClockSkewHeaderValue"; // Count: 2
var _DYN_SET_CLOCK_SKEW = "setClockSkew"; // Count: 3
var _DYN_LENGTH = "length"; // Count: 37
var _DYN_CONCAT = "concat"; // Count: 9
var _DYN_I_KEY = "iKey"; // Count: 10
var _DYN_COUNT = "count"; // Count: 18
var _DYN_EVENTS = "events"; // Count: 8
var _DYN_PUSH = "push"; // Count: 13
var _DYN_SPLIT = "split"; // Count: 7
var _DYN_SPLICE = "splice"; // Count: 4
var _DYN_TO_LOWER_CASE = "toLowerCase"; // Count: 5
var _DYN_HDRS = "hdrs"; // Count: 6
var _DYN_USE_HDRS = "useHdrs"; // Count: 5
var _DYN_INITIALIZE = "initialize"; // Count: 4
var _DYN_SET_TIMEOUT_OVERRIDE = "setTimeoutOverride"; // Count: 3
var _DYN_CLEAR_TIMEOUT_OVERRI3 = "clearTimeoutOverride"; // Count: 3
var _DYN_PAYLOAD_PREPROCESSOR = "payloadPreprocessor"; // Count: 2
var _DYN_OVERRIDE_ENDPOINT_UR4 = "overrideEndpointUrl"; // Count: 3
var _DYN_AVOID_OPTIONS = "avoidOptions"; // Count: 3
var _DYN_DISABLE_EVENT_TIMING5 = "disableEventTimings"; // Count: 2
var _DYN_STRINGIFY_OBJECTS = "stringifyObjects"; // Count: 2
var _DYN_ENABLE_COMPOUND_KEY = "enableCompoundKey"; // Count: 4
var _DYN_DISABLE_XHR_SYNC = "disableXhrSync"; // Count: 6
var _DYN_DISABLE_FETCH_KEEP_A6 = "disableFetchKeepAlive"; // Count: 5
var _DYN_USE_SEND_BEACON = "useSendBeacon"; // Count: 3
var _DYN_ALWAYS_USE_XHR_OVERR7 = "alwaysUseXhrOverride"; // Count: 3
var _DYN_UNLOAD_TRANSPORTS = "unloadTransports"; // Count: 2
var _DYN_URL_STRING = "urlString"; // Count: 7
var _DYN_TIMEOUT = "timeout"; // Count: 9
var _DYN_ONTIMEOUT = "ontimeout"; // Count: 3
var _DYN_DATA = "data"; // Count: 11
var _DYN__SEND_REASON = "_sendReason"; // Count: 5
var _DYN_HEADERS = "headers"; // Count: 12
var _DYN_GET_RESPONSE_HEADER = "getResponseHeader"; // Count: 2
var _DYN_GET_ALL_RESPONSE_HEA8 = "getAllResponseHeaders"; // Count: 2
var _DYN__THE_PAYLOAD = "_thePayload"; // Count: 6
var _DYN_BATCHES = "batches"; // Count: 15
var _DYN_SEND_TYPE = "sendType"; // Count: 13
var _DYN_CAN_SEND_REQUEST = "canSendRequest"; // Count: 3
var _DYN_SEND_QUEUED_REQUESTS = "sendQueuedRequests"; // Count: 5
var _DYN_IS_COMPLETELY_IDLE = "isCompletelyIdle"; // Count: 2
var _DYN_SET_UNLOADING = "setUnloading"; // Count: 3
var _DYN_IS_TENANT_KILLED = "isTenantKilled"; // Count: 3
var _DYN_SEND_SYNCHRONOUS_BAT9 = "sendSynchronousBatch"; // Count: 2
var _DYN__TRANSPORT = "_transport"; // Count: 4
var _DYN_GET_WPARAM = "getWParam"; // Count: 4
var _DYN_IS_BEACON = "isBeacon"; // Count: 4
var _DYN_TIMINGS = "timings"; // Count: 4
var _DYN_IS_TEARDOWN = "isTeardown"; // Count: 3
var _DYN_IS_SYNC = "isSync"; // Count: 4
var _DYN_SEND_POST = "sendPOST"; // Count: 3
var _DYN_SET_KILL_SWITCH_TENA10 = "setKillSwitchTenants"; // Count: 2
var _DYN__BACK_OFF_TRANSMISSI11 = "_backOffTransmission"; // Count: 2
var _DYN_IDENTIFIER = "identifier"; // Count: 4
var _DYN_DISABLE_OPTIMIZE_OBJ = "disableOptimizeObj"; // Count: 2
var _DYN_IGNORE_MC1_MS0_COOKI12 = "ignoreMc1Ms0CookieProcessing"; // Count: 2
var _DYN_EVENTS_LIMIT_IN_MEM = "eventsLimitInMem"; // Count: 2
var _DYN_AUTO_FLUSH_EVENTS_LI13 = "autoFlushEventsLimit"; // Count: 2
var _DYN_DISABLE_AUTO_BATCH_F14 = "disableAutoBatchFlushLimit"; // Count: 2
var _DYN_OVERRIDE_INSTRUMENTA15 = "overrideInstrumentationKey"; // Count: 2
var _DYN_DISABLE_TELEMETRY = "disableTelemetry"; // Count: 2
var _DYN_SEND_ATTEMPT = "sendAttempt"; // Count: 4
var _DYN_LATENCY = "latency"; // Count: 7
var _DYN_BASE_DATA = "baseData"; // Count: 3
var _DYN_SYNC = "sync"; // Count: 7
//# sourceMappingURL=__DynamicConstants.js.map

/***/ }),
/* 119 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HttpManager: () => (/* binding */ HttpManager)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(35);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(18);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(13);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(47);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(21);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(31);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(67);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(86);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(15);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(26);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(7);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(37);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(46);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(41);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(23);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(97);
/* harmony import */ var _ClockSkewManager__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(120);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(117);
/* harmony import */ var _KillSwitch__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(121);
/* harmony import */ var _RetryPolicy__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(122);
/* harmony import */ var _Serializer__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(123);
/* harmony import */ var _TimeoutOverrideWrapper__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(124);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(118);
/*
 * 1DS JS SDK POST plugin, 4.0.3
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
var _a;
/**
* HttpManager.ts
* @author Abhilash Panwar (abpanwar); Hector Hernandez (hectorh); Nev Wylie (newylie)
* @copyright Microsoft 2018-2020
*/










var strSendAttempt = "sendAttempt";
var _noResponseQs = "&" + _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_NO_RESPONSE_BODY + "=true";
var UrlQueryString = "?cors=true&" + _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CONTENT_TYPE_HEADER[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]() + "=" + _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.DEFAULT_CONTENT_TYPE;
/**
 * Identifies the default notification reason to the action names
 */
var _eventActionMap = (_a = {},
    _a[1 /* EventBatchNotificationReason.Paused */] = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_REQUEUE,
    _a[100 /* EventBatchNotificationReason.RequeueEvents */] = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_REQUEUE,
    _a[200 /* EventBatchNotificationReason.Complete */] = "sent",
    _a[8004 /* EventBatchNotificationReason.KillSwitch */] = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_DROPPED,
    _a[8003 /* EventBatchNotificationReason.SizeLimitExceeded */] = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_DROPPED,
    _a);
var _collectorQsHeaders = {};
var _collectorHeaderToQs = {};
function _addCollectorHeaderQsMapping(qsName, headerName, allowQs) {
    _collectorQsHeaders[qsName] = headerName;
    if (allowQs !== false) {
        _collectorHeaderToQs[headerName] = qsName;
    }
}
_addCollectorHeaderQsMapping(_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_MSA_DEVICE_TICKET, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_MSA_DEVICE_TICKET, false);
_addCollectorHeaderQsMapping(_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CLIENT_VERSION, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CLIENT_VERSION);
_addCollectorHeaderQsMapping(_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CLIENT_ID, "Client-Id");
_addCollectorHeaderQsMapping(_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_API_KEY, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_API_KEY);
_addCollectorHeaderQsMapping(_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_TIME_DELTA_TO_APPLY, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_TIME_DELTA_TO_APPLY);
_addCollectorHeaderQsMapping(_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_UPLOAD_TIME, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_UPLOAD_TIME);
_addCollectorHeaderQsMapping(_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_AUTH_XTOKEN, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_AUTH_XTOKEN);
function _getResponseText(xhr) {
    try {
        return xhr.responseText;
    }
    catch (e) {
        // Best effort, as XHR may throw while XDR wont so just ignore
    }
    return _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EMPTY;
}
function _hasHeader(headers, header) {
    var hasHeader = false;
    if (headers && header) {
        var keys = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_2__.objKeys)(headers);
        if (keys && keys[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
            var lowerHeader = header[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]();
            for (var lp = 0; lp < keys[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]; lp++) {
                var value = keys[lp];
                if (value && (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_3__.objHasOwnProperty)(header, value) &&
                    value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]() === lowerHeader) {
                    hasHeader = true;
                    break;
                }
            }
        }
    }
    return hasHeader;
}
function _addRequestDetails(details, name, value, useHeaders) {
    if (name && value && value[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
        if (useHeaders && _collectorQsHeaders[name]) {
            details[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HDRS /* @min:%2ehdrs */][_collectorQsHeaders[name]] = value;
            details[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_USE_HDRS /* @min:%2euseHdrs */] = true;
        }
        else {
            details.url += "&" + name + "=" + value;
        }
    }
}
function _prependTransports(theTransports, newTransports) {
    if (newTransports) {
        if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.isNumber)(newTransports)) {
            theTransports = [newTransports][_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CONCAT /* @min:%2econcat */](theTransports);
        }
        else if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.isArray)(newTransports)) {
            theTransports = newTransports[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CONCAT /* @min:%2econcat */](theTransports);
        }
    }
    return theTransports;
}
function _addQueryStringParameter(qsParams, name, value) {
    for (var i = 0; i < qsParams[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]; i++) {
        if (qsParams[i].name === name) {
            qsParams[i].value = value;
            return;
        }
    }
    qsParams[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */]({ name: name, value: value });
}
function _removeQueryStringParameter(qsParams, name) {
    for (var i = 0; i < qsParams[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]; i++) {
        if (qsParams[i].name === name) {
            qsParams[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPLICE /* @min:%2esplice */](i, 1);
            return;
        }
    }
}
/**
 * Class managing the sending of requests.
 */
var HttpManager = /** @class */ (function () {
    /**
     * @constructor
     * @param requestQueue   - The queue that contains the requests to be sent.
     */
    function HttpManager(maxEventsPerBatch, maxConnections, maxRequestRetriesBeforeBackoff, actions) {
        var _urlString;
        var _killSwitch = new _KillSwitch__WEBPACK_IMPORTED_MODULE_5__.KillSwitch();
        var _paused = false;
        var _clockSkewManager = new _ClockSkewManager__WEBPACK_IMPORTED_MODULE_6__.ClockSkewManager();
        var _useBeacons = false;
        var _outstandingRequests = 0; // Holds the number of outstanding async requests that have not returned a response yet
        var _postManager;
        var _logger;
        var _sendInterfaces;
        var _core;
        var _customHttpInterface = true;
        var _queryStringParameters = [];
        var _headers = {};
        var _batchQueue = [];
        var _serializer = null;
        var _enableEventTimings = false;
        var _cookieMgr;
        var _isUnloading = false;
        var _useHeaders = false;
        var _xhrTimeout;
        var _disableXhrSync;
        var _disableFetchKeepAlive;
        var _canHaveReducedPayload;
        var _addNoResponse;
        var _unloadHooks = [];
        var _sendHook;
        var _sendListener;
        var _responseHandlers = [];
        var _isInitialized;
        var _timeoutWrapper;
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_7__["default"])(HttpManager, this, function (_self) {
            _initDefaults();
            var _sendCredentials = true;
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_INITIALIZE /* @min:%2einitialize */] = function (theConfig, core, postChannel) {
                if (!_isInitialized) {
                    _core = core;
                    _cookieMgr = core.getCookieMgr();
                    _postManager = postChannel;
                    _logger = _postManager.diagLog();
                    (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_8__.arrAppend)(_unloadHooks, (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_9__.onConfigChange)(theConfig, function (details) {
                        var _a;
                        var coreConfig = details.cfg;
                        var channelConfig = details.cfg.extensionConfig[postChannel.identifier];
                        _timeoutWrapper = (0,_TimeoutOverrideWrapper__WEBPACK_IMPORTED_MODULE_10__.createTimeoutWrapper)(channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_TIMEOUT_OVERRIDE /* @min:%2esetTimeoutOverride */], channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CLEAR_TIMEOUT_OVERRI3 /* @min:%2eclearTimeoutOverride */]);
                        if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__.isValueAssigned)(coreConfig.anonCookieName)) {
                            _addQueryStringParameter(_queryStringParameters, "anoncknm", coreConfig.anonCookieName);
                        }
                        else {
                            _removeQueryStringParameter(_queryStringParameters, "anoncknm");
                        }
                        _sendHook = channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PAYLOAD_PREPROCESSOR /* @min:%2epayloadPreprocessor */];
                        _sendListener = channelConfig.payloadListener;
                        var httpInterface = channelConfig.httpXHROverride;
                        // Override endpointUrl if provided in Post config
                        var endpointUrl = channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_OVERRIDE_ENDPOINT_UR4 /* @min:%2eoverrideEndpointUrl */] ? channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_OVERRIDE_ENDPOINT_UR4 /* @min:%2eoverrideEndpointUrl */] : coreConfig.endpointUrl;
                        _urlString = endpointUrl + UrlQueryString;
                        _useHeaders = !(0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.isUndefined)(channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_AVOID_OPTIONS /* @min:%2eavoidOptions */]) ? !channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_AVOID_OPTIONS /* @min:%2eavoidOptions */] : true;
                        _enableEventTimings = !channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_DISABLE_EVENT_TIMING5 /* @min:%2edisableEventTimings */];
                        var valueSanitizer = channelConfig.valueSanitizer;
                        var stringifyObjects = channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_STRINGIFY_OBJECTS /* @min:%2estringifyObjects */];
                        var enableCompoundKey = !!coreConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_ENABLE_COMPOUND_KEY /* @min:%2eenableCompoundKey */];
                        if (!(0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.isUndefined)(channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_ENABLE_COMPOUND_KEY /* @min:%2eenableCompoundKey */])) {
                            enableCompoundKey = !!channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_ENABLE_COMPOUND_KEY /* @min:%2eenableCompoundKey */];
                        }
                        _xhrTimeout = channelConfig.xhrTimeout;
                        _disableXhrSync = !!channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_DISABLE_XHR_SYNC /* @min:%2edisableXhrSync */];
                        _disableFetchKeepAlive = !!channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_DISABLE_FETCH_KEEP_A6 /* @min:%2edisableFetchKeepAlive */];
                        _addNoResponse = channelConfig.addNoResponse !== false;
                        _useBeacons = !(0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_12__.isReactNative)(); // Only use beacons if not running in React Native
                        _serializer = new _Serializer__WEBPACK_IMPORTED_MODULE_13__.Serializer(_core, valueSanitizer, stringifyObjects, enableCompoundKey);
                        if (!(0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.isNullOrUndefined)(channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_USE_SEND_BEACON /* @min:%2euseSendBeacon */])) {
                            _useBeacons = !!channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_USE_SEND_BEACON /* @min:%2euseSendBeacon */];
                        }
                        var syncHttpInterface = httpInterface;
                        var beaconHttpInterface = channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_ALWAYS_USE_XHR_OVERR7 /* @min:%2ealwaysUseXhrOverride */] ? httpInterface : null;
                        var fetchSyncHttpInterface = channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_ALWAYS_USE_XHR_OVERR7 /* @min:%2ealwaysUseXhrOverride */] ? httpInterface : null;
                        var beaconUnloadTransports = [3 /* TransportType.Beacon */, 2 /* TransportType.Fetch */];
                        if (!httpInterface) {
                            _customHttpInterface = false;
                            var location_1 = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_12__.getLocation)();
                            if (location_1 && location_1.protocol && location_1.protocol[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]() === "file:") {
                                // Special case where a local html file fails with a CORS error on Chromium browsers
                                _sendCredentials = false;
                            }
                            var theTransports = [];
                            if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_12__.isReactNative)()) {
                                // Use Fetch or XDR/XHR
                                theTransports = [2 /* TransportType.Fetch */, 1 /* TransportType.Xhr */];
                                beaconUnloadTransports = [2 /* TransportType.Fetch */, 1 /* TransportType.Xhr */, 3 /* TransportType.Beacon */];
                            }
                            else {
                                // Use XDR/XHR, Fetch or beacons
                                theTransports = [1 /* TransportType.Xhr */, 2 /* TransportType.Fetch */, 3 /* TransportType.Beacon */];
                            }
                            // Prefix any user requested transport(s) values
                            theTransports = _prependTransports(theTransports, channelConfig.transports);
                            httpInterface = _getSenderInterface(theTransports, false);
                            if (!httpInterface) {
                                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_14__._warnToConsole)(_logger, "No available transport to send events");
                            }
                            syncHttpInterface = _getSenderInterface(theTransports, true);
                        }
                        if (!beaconHttpInterface) {
                            // Allow overriding the usage of sendBeacon
                            beaconUnloadTransports = _prependTransports(beaconUnloadTransports, channelConfig[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_UNLOAD_TRANSPORTS /* @min:%2eunloadTransports */]);
                            beaconHttpInterface = _getSenderInterface(beaconUnloadTransports, true);
                        }
                        _canHaveReducedPayload = !_customHttpInterface && ((_useBeacons && (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_12__.isBeaconsSupported)()) || (!_disableFetchKeepAlive && (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_12__.isFetchSupported)(true)));
                        _sendInterfaces = (_a = {},
                            _a[0 /* EventSendType.Batched */] = httpInterface,
                            _a[1 /* EventSendType.Synchronous */] = syncHttpInterface || _getSenderInterface([1 /* TransportType.Xhr */, 2 /* TransportType.Fetch */, 3 /* TransportType.Beacon */], true),
                            _a[2 /* EventSendType.SendBeacon */] = beaconHttpInterface || syncHttpInterface || _getSenderInterface([1 /* TransportType.Xhr */], true),
                            _a[3 /* EventSendType.SyncFetch */] = fetchSyncHttpInterface || _getSenderInterface([2 /* TransportType.Fetch */, 3 /* TransportType.Beacon */], true) || syncHttpInterface || _getSenderInterface([1 /* TransportType.Xhr */], true),
                            _a);
                    }));
                    _isInitialized = true;
                }
            };
            _self.addResponseHandler = function (responseHandler) {
                _responseHandlers[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](responseHandler);
                return {
                    rm: function () {
                        var index = _responseHandlers.indexOf(responseHandler);
                        if (index >= 0) {
                            _responseHandlers[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPLICE /* @min:%2esplice */](index, 1);
                        }
                    }
                };
            };
            // Special internal method to allow the DebugPlugin to hook embedded objects
            function _getSenderInterface(transports, syncSupport) {
                var transportType = 0 /* TransportType.NotSet */;
                var sendPostFunc = null;
                var lp = 0;
                while (sendPostFunc == null && lp < transports[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]) {
                    transportType = transports[lp];
                    if (transportType === 1 /* TransportType.Xhr */) {
                        if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_12__.useXDomainRequest)()) {
                            sendPostFunc = _xdrSendPost;
                        }
                        else if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_12__.isXhrSupported)()) {
                            sendPostFunc = _xhrSendPost;
                        }
                    }
                    else if (transportType === 2 /* TransportType.Fetch */ && (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_12__.isFetchSupported)(syncSupport) && (!syncSupport || (syncSupport && !_disableFetchKeepAlive))) {
                        sendPostFunc = _fetchSendPost;
                    }
                    else if (_useBeacons && transportType === 3 /* TransportType.Beacon */ && (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_12__.isBeaconsSupported)()) {
                        sendPostFunc = _beaconSendPost;
                    }
                    lp++;
                }
                if (sendPostFunc) {
                    return {
                        _transport: transportType,
                        _isSync: syncSupport,
                        sendPOST: sendPostFunc
                    };
                }
                return null;
            }
            _self["_getDbgPlgTargets"] = function () {
                return [_sendInterfaces[0 /* EventSendType.Batched */], _killSwitch, _serializer, _sendInterfaces];
            };
            function _xdrSendPost(payload, oncomplete, sync) {
                // It doesn't support custom headers, so no action is taken with current requestHeaders
                var xdr = new XDomainRequest();
                xdr.open(_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_POST_METHOD, payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_URL_STRING /* @min:%2eurlString */]);
                if (payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIMEOUT /* @min:%2etimeout */]) {
                    xdr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIMEOUT /* @min:%2etimeout */] = payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIMEOUT /* @min:%2etimeout */];
                }
                // can't get the status code in xdr.
                xdr.onload = function () {
                    // we will assume onload means the request succeeded.
                    var response = _getResponseText(xdr);
                    _doOnComplete(oncomplete, 200, {}, response);
                    _handleCollectorResponse(response);
                };
                // we will assume onerror means we need to drop the events.
                xdr.onerror = function () {
                    _doOnComplete(oncomplete, 400, {});
                };
                // we will assume ontimeout means we need to retry the events.
                xdr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_ONTIMEOUT /* @min:%2eontimeout */] = function () {
                    _doOnComplete(oncomplete, 500, {});
                };
                // https://cypressnorth.com/web-programming-and-development/internet-explorer-aborting-ajax-requests-fixed/
                // tslint:disable-next-line:no-empty
                xdr.onprogress = function () { };
                if (sync) {
                    xdr.send(payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_DATA /* @min:%2edata */]);
                }
                else {
                    _timeoutWrapper.set(function () {
                        xdr.send(payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_DATA /* @min:%2edata */]);
                    }, 0);
                }
            }
            function _initDefaults() {
                var undefValue;
                _urlString = null;
                _killSwitch = new _KillSwitch__WEBPACK_IMPORTED_MODULE_5__.KillSwitch();
                _paused = false;
                _clockSkewManager = new _ClockSkewManager__WEBPACK_IMPORTED_MODULE_6__.ClockSkewManager();
                _useBeacons = false;
                _outstandingRequests = 0; // Holds the number of outstanding async requests that have not returned a response yet
                _postManager = null;
                _logger = null;
                _sendInterfaces = null;
                _core = null;
                _customHttpInterface = true;
                _queryStringParameters = [];
                _headers = {};
                _batchQueue = [];
                _serializer = null;
                _enableEventTimings = false;
                _cookieMgr = null;
                _isUnloading = false;
                _useHeaders = false;
                _xhrTimeout = undefValue;
                _disableXhrSync = undefValue;
                _disableFetchKeepAlive = undefValue;
                _canHaveReducedPayload = undefValue;
                _addNoResponse = undefValue;
                _unloadHooks = [];
                _sendHook = undefValue;
                _sendListener = undefValue;
                _responseHandlers = [];
                _isInitialized = false;
                _timeoutWrapper = (0,_TimeoutOverrideWrapper__WEBPACK_IMPORTED_MODULE_10__.createTimeoutWrapper)();
            }
            function _fetchSendPost(payload, oncomplete, sync) {
                var _a;
                var theUrl = payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_URL_STRING /* @min:%2eurlString */];
                var ignoreResponse = false;
                var responseHandled = false;
                var requestInit = (_a = {
                        body: payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_DATA /* @min:%2edata */],
                        method: _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_POST_METHOD
                    },
                    _a[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_DISABLED_PROPERTY_NAME] = true,
                    _a);
                if (sync) {
                    requestInit.keepalive = true;
                    if (payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__SEND_REASON /* @min:%2e_sendReason */] === 2 /* SendRequestReason.Unload */) {
                        // As a sync request (during unload), it is unlikely that we will get a chance to process the response so
                        // just like beacon send assume that the events have been accepted and processed
                        ignoreResponse = true;
                        if (_addNoResponse) {
                            theUrl += _noResponseQs;
                        }
                    }
                }
                if (_sendCredentials) {
                    // Don't send credentials when URL is file://
                    requestInit.credentials = "include";
                }
                // Only add headers if there are headers to add, due to issue with some polyfills
                if (payload.headers && (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_2__.objKeys)(payload.headers)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    requestInit[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HEADERS /* @min:%2eheaders */] = payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HEADERS /* @min:%2eheaders */];
                }
                fetch(theUrl, requestInit).then(function (response) {
                    var headerMap = {};
                    var responseText = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EMPTY;
                    var headers = response[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HEADERS /* @min:%2eheaders */];
                    if (headers) {
                        headers["forEach"](function (value, name) {
                            headerMap[name] = value;
                        });
                    }
                    if (response.body) {
                        response.text().then(function (text) {
                            responseText = text;
                        });
                    }
                    if (!responseHandled) {
                        responseHandled = true;
                        _doOnComplete(oncomplete, response.status, headerMap, responseText);
                        _handleCollectorResponse(responseText);
                    }
                }).catch(function (error) {
                    // In case there is an error in the request. Set the status to 0
                    // so that the events can be retried later.
                    if (!responseHandled) {
                        responseHandled = true;
                        _doOnComplete(oncomplete, 0, {});
                    }
                });
                if (ignoreResponse && !responseHandled) {
                    // Assume success during unload processing
                    responseHandled = true;
                    _doOnComplete(oncomplete, 200, {});
                }
                if (!responseHandled && payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIMEOUT /* @min:%2etimeout */] > 0) {
                    // Simulate timeout
                    _timeoutWrapper.set(function () {
                        if (!responseHandled) {
                            // Assume a 500 response (which will cause a retry)
                            responseHandled = true;
                            _doOnComplete(oncomplete, 500, {});
                        }
                    }, payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIMEOUT /* @min:%2etimeout */]);
                }
            }
            function _xhrSendPost(payload, oncomplete, sync) {
                var theUrl = payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_URL_STRING /* @min:%2eurlString */];
                function _appendHeader(theHeaders, xhr, name) {
                    if (!theHeaders[name] && xhr && xhr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_RESPONSE_HEADER /* @min:%2egetResponseHeader */]) {
                        var value = xhr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_RESPONSE_HEADER /* @min:%2egetResponseHeader */](name);
                        if (value) {
                            theHeaders[name] = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_15__.strTrim)(value);
                        }
                    }
                    return theHeaders;
                }
                function _getAllResponseHeaders(xhr) {
                    var theHeaders = {};
                    if (!xhr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_ALL_RESPONSE_HEA8 /* @min:%2egetAllResponseHeaders */]) {
                        // Firefox 2-63 doesn't have getAllResponseHeaders function but it does have getResponseHeader
                        // Only call these if getAllResponseHeaders doesn't exist, otherwise we can get invalid response errors
                        // as collector is not currently returning the correct header to allow JS to access these headers
                        theHeaders = _appendHeader(theHeaders, xhr, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_TIME_DELTA_HEADER);
                        theHeaders = _appendHeader(theHeaders, xhr, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_KILL_DURATION_HEADER);
                        theHeaders = _appendHeader(theHeaders, xhr, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_KILL_DURATION_SECONDS_HEADER);
                    }
                    else {
                        theHeaders = _convertAllHeadersToMap(xhr[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_ALL_RESPONSE_HEA8 /* @min:%2egetAllResponseHeaders */]());
                    }
                    return theHeaders;
                }
                function xhrComplete(xhr, responseTxt) {
                    _doOnComplete(oncomplete, xhr.status, _getAllResponseHeaders(xhr), responseTxt);
                }
                if (sync && payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_DISABLE_XHR_SYNC /* @min:%2edisableXhrSync */]) {
                    sync = false;
                }
                var xhrRequest = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__.openXhr)(_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_POST_METHOD, theUrl, _sendCredentials, true, sync, payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIMEOUT /* @min:%2etimeout */]);
                // Set custom headers (e.g. gzip) here (after open())
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_16__.objForEachKey)(payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HEADERS /* @min:%2eheaders */], function (name, value) {
                    xhrRequest.setRequestHeader(name, value);
                });
                xhrRequest.onload = function () {
                    var response = _getResponseText(xhrRequest);
                    xhrComplete(xhrRequest, response);
                    _handleCollectorResponse(response);
                };
                xhrRequest.onerror = function () {
                    xhrComplete(xhrRequest);
                };
                xhrRequest[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_ONTIMEOUT /* @min:%2eontimeout */] = function () {
                    xhrComplete(xhrRequest);
                };
                xhrRequest.send(payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_DATA /* @min:%2edata */]);
            }
            function _doOnComplete(oncomplete, status, headers, response) {
                try {
                    oncomplete(status, headers, response);
                }
                catch (e) {
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_14__._throwInternal)(_logger, 2 /* eLoggingSeverity.WARNING */, 518 /* _eExtendedInternalMessageId.SendPostOnCompleteFailure */, (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_17__.dumpObj)(e));
                }
            }
            function _beaconSendPost(payload, oncomplete, sync) {
                // Custom headers not supported in sendBeacon payload.headers would be ignored
                var internalPayloadData = payload;
                var status = 200;
                var thePayload = internalPayloadData[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__THE_PAYLOAD /* @min:%2e_thePayload */];
                var theUrl = payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_URL_STRING /* @min:%2eurlString */] + (_addNoResponse ? _noResponseQs : _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EMPTY);
                try {
                    var nav_1 = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_18__.getNavigator)();
                    if (!nav_1.sendBeacon(theUrl, payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_DATA /* @min:%2edata */])) {
                        if (thePayload) {
                            // Failed to send entire payload so try and split data and try to send as much events as possible
                            var droppedBatches_1 = [];
                            (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_19__.arrForEach)(thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_BATCHES /* @min:%2ebatches */], function (theBatch) {
                                if (droppedBatches_1 && theBatch && theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COUNT /* @min:%2ecount */]() > 0) {
                                    var theEvents = theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_EVENTS /* @min:%2eevents */]();
                                    for (var lp = 0; lp < theEvents[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]; lp++) {
                                        if (!nav_1.sendBeacon(theUrl, _serializer.getEventBlob(theEvents[lp]))) {
                                            // Can't send anymore, so split the batch and drop the rest
                                            droppedBatches_1[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPLIT /* @min:%2esplit */](lp));
                                            break;
                                        }
                                    }
                                }
                                else {
                                    // Remove all of the events from the existing batch in the payload as the copy includes the original
                                    droppedBatches_1[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPLIT /* @min:%2esplit */](0));
                                }
                            });
                            _sendBatchesNotification(droppedBatches_1, 8003 /* EventBatchNotificationReason.SizeLimitExceeded */, thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEND_TYPE /* @min:%2esendType */], true);
                        }
                        else {
                            status = 0;
                        }
                    }
                }
                catch (ex) {
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_14__._warnToConsole)(_logger, "Failed to send telemetry using sendBeacon API. Ex:" + (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_17__.dumpObj)(ex));
                    status = 0;
                }
                finally {
                    _doOnComplete(oncomplete, status, {}, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EMPTY);
                }
            }
            function _isBeaconPayload(sendType) {
                // Sync Fetch has the same payload limitation as sendBeacon -- 64kb limit, so treat both as a beacon send
                return sendType === 2 /* EventSendType.SendBeacon */ || sendType === 3 /* EventSendType.SyncFetch */;
            }
            function _adjustSendType(sendType) {
                if (_isUnloading && _isBeaconPayload(sendType)) {
                    sendType = 2 /* EventSendType.SendBeacon */;
                }
                return sendType;
            }
            _self.addHeader = function (name, value) {
                _headers[name] = value;
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CAN_SEND_REQUEST /* @min:%2ecanSendRequest */] = function () {
                return _hasIdleConnection() && _clockSkewManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_ALLOW_REQUEST_SENDIN0 /* @min:%2eallowRequestSending */]();
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEND_QUEUED_REQUESTS /* @min:%2esendQueuedRequests */] = function (sendType, sendReason) {
                if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.isUndefined)(sendType)) {
                    sendType = 0 /* EventSendType.Batched */;
                }
                if (_isUnloading) {
                    sendType = _adjustSendType(sendType);
                    sendReason = 2 /* SendRequestReason.Unload */;
                }
                if (_canSendPayload(_batchQueue, sendType, 0)) {
                    _sendBatches(_clearQueue(), 0, false, sendType, sendReason || 0 /* SendRequestReason.Undefined */);
                }
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_COMPLETELY_IDLE /* @min:%2eisCompletelyIdle */] = function () {
                return !_paused && _outstandingRequests === 0 && _batchQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] === 0;
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_UNLOADING /* @min:%2esetUnloading */] = function (value) {
                _isUnloading = value;
            };
            _self.addBatch = function (theBatch) {
                if (theBatch && theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COUNT /* @min:%2ecount */]() > 0) {
                    // Try and kill the event faster
                    if (_killSwitch.isTenantKilled(theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_I_KEY /* @min:%2eiKey */]())) {
                        return false;
                    }
                    _batchQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](theBatch);
                }
                return true;
            };
            /**
             * Queue all the remaining requests to be sent. The requests will be
             * sent using HTML5 Beacons if they are available.
             */
            _self.teardown = function () {
                if (_batchQueue[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    _sendBatches(_clearQueue(), 0, true, 2 /* EventSendType.SendBeacon */, 2 /* SendRequestReason.Unload */);
                }
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_19__.arrForEach)(_unloadHooks, function (hook) {
                    hook && hook.rm && hook.rm();
                });
                _unloadHooks = [];
            };
            /**
             * Pause the sending of requests. No new requests will be sent.
             */
            _self.pause = function () {
                _paused = true;
            };
            /**
             * Resume the sending of requests.
             */
            _self.resume = function () {
                _paused = false;
                _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEND_QUEUED_REQUESTS /* @min:%2esendQueuedRequests */](0 /* EventSendType.Batched */, 4 /* SendRequestReason.Resumed */);
            };
            /**
             * Sends a request synchronously to the Aria collector. This api is used to send
             * a request containing a single immediate event.
             *
             * @param batch - The request to be sent.
             * @param sendReason   - The token used to send the request.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEND_SYNCHRONOUS_BAT9 /* @min:%2esendSynchronousBatch */] = function (batch, sendType, sendReason) {
                // This will not take into account the max connections restriction. Since this is sync, we can
                // only send one of this request at a time and thus should not worry about multiple connections
                // being used to send synchronous events.
                // Increment active connection since we are still going to use a connection to send the request.
                if (batch && batch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COUNT /* @min:%2ecount */]() > 0) {
                    if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.isNullOrUndefined)(sendType)) {
                        sendType = 1 /* EventSendType.Synchronous */;
                    }
                    if (_isUnloading) {
                        sendType = _adjustSendType(sendType);
                        sendReason = 2 /* SendRequestReason.Unload */;
                    }
                    // For sync requests we will not wait for the clock skew.
                    _sendBatches([batch], 0, false, sendType, sendReason || 0 /* SendRequestReason.Undefined */);
                }
            };
            function _hasIdleConnection() {
                return !_paused && _outstandingRequests < maxConnections;
            }
            function _clearQueue() {
                var theQueue = _batchQueue;
                _batchQueue = [];
                return theQueue;
            }
            function _canSendPayload(theBatches, sendType, retryCnt) {
                var result = false;
                if (theBatches && theBatches[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0 && !_paused && _sendInterfaces[sendType] && _serializer) {
                    // Always attempt to send synchronous events don't wait for idle or clockSkew
                    // and don't block retry requests if clockSkew is not yet set
                    result = (sendType !== 0 /* EventSendType.Batched */) || (_hasIdleConnection() && (retryCnt > 0 || _clockSkewManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_ALLOW_REQUEST_SENDIN0 /* @min:%2eallowRequestSending */]()));
                }
                return result;
            }
            function _createDebugBatches(theBatches) {
                var values = {};
                if (theBatches) {
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_19__.arrForEach)(theBatches, function (theBatch, idx) {
                        values[idx] = {
                            iKey: theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_I_KEY /* @min:%2eiKey */](),
                            evts: theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_EVENTS /* @min:%2eevents */]()
                        };
                    });
                }
                return values;
            }
            function _sendBatches(theBatches, retryCount, isTeardown, sendType, sendReason) {
                if (!theBatches || theBatches[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] === 0) {
                    // Nothing to do
                    return;
                }
                if (_paused) {
                    _sendBatchesNotification(theBatches, 1 /* EventBatchNotificationReason.Paused */, sendType);
                    return;
                }
                // Make sure that if we are unloading the sendType is a supported version
                sendType = _adjustSendType(sendType);
                try {
                    var orgBatches_1 = theBatches;
                    var isSynchronous_1 = sendType !== 0 /* EventSendType.Batched */;
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_20__.doPerf)(_core, function () { return "HttpManager:_sendBatches"; }, function (perfEvt) {
                        if (perfEvt) {
                            // Perf Monitoring is enabled, so create a "Quick" copy of the original batches so we still report
                            // the original values as part of the perfEvent. This is because theBatches uses .shift() to remove each
                            // batch as they are processed - removing from the original array, so by the time the _createDebugBatches()
                            // function is called the passed in value has changed and therefore the reported value for the perfEvent is incorrect
                            theBatches = theBatches.slice(0);
                        }
                        var droppedBatches = [];
                        var thePayload = null;
                        var serializationStart = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__.getTime)();
                        var sendInterface = _sendInterfaces[sendType] || (isSynchronous_1 ? _sendInterfaces[1 /* EventSendType.Synchronous */] : _sendInterfaces[0 /* EventSendType.Batched */]);
                        var sendTransport = sendInterface && sendInterface[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__TRANSPORT /* @min:%2e_transport */];
                        // Sync Fetch has the same payload limitation as sendBeacon -- 64kb limit
                        var isReducedPayload = _canHaveReducedPayload && (_isUnloading || _isBeaconPayload(sendType) || (sendTransport === 3 /* TransportType.Beacon */ || (sendInterface._isSync && sendTransport === 2 /* TransportType.Fetch */)));
                        while (_canSendPayload(theBatches, sendType, retryCount)) {
                            var theBatch = theBatches.shift();
                            if (theBatch && theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COUNT /* @min:%2ecount */]() > 0) {
                                if (!_killSwitch.isTenantKilled(theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_I_KEY /* @min:%2eiKey */]())) {
                                    // Make sure we have a payload object
                                    thePayload = thePayload || _serializer.createPayload(retryCount, isTeardown, isSynchronous_1, isReducedPayload, sendReason, sendType);
                                    // Add the batch to the current payload
                                    if (!_serializer.appendPayload(thePayload, theBatch, maxEventsPerBatch)) {
                                        // Entire batch was not added so send the payload and retry adding this batch
                                        _doPayloadSend(thePayload, serializationStart, (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__.getTime)(), sendReason);
                                        serializationStart = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__.getTime)();
                                        theBatches = [theBatch][_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CONCAT /* @min:%2econcat */](theBatches);
                                        thePayload = null;
                                    }
                                    else if (thePayload.overflow !== null) {
                                        // Total Payload size was exceeded so send the payload and add the unsent as the next batch to send
                                        theBatches = [thePayload.overflow][_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CONCAT /* @min:%2econcat */](theBatches);
                                        thePayload.overflow = null;
                                        _doPayloadSend(thePayload, serializationStart, (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__.getTime)(), sendReason);
                                        serializationStart = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__.getTime)();
                                        thePayload = null;
                                    }
                                }
                                else {
                                    droppedBatches[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](theBatch);
                                }
                            }
                        }
                        // Make sure to flush any remaining payload
                        if (thePayload) {
                            _doPayloadSend(thePayload, serializationStart, (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__.getTime)(), sendReason);
                        }
                        if (theBatches[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
                            // Add any unsent batches back to the head of the queue
                            _batchQueue = theBatches[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_CONCAT /* @min:%2econcat */](_batchQueue);
                        }
                        // Now send notification about any dropped events
                        _sendBatchesNotification(droppedBatches, 8004 /* EventBatchNotificationReason.KillSwitch */, sendType);
                    }, function () { return ({ batches: _createDebugBatches(orgBatches_1), retryCount: retryCount, isTeardown: isTeardown, isSynchronous: isSynchronous_1, sendReason: sendReason, useSendBeacon: _isBeaconPayload(sendType), sendType: sendType }); }, !isSynchronous_1);
                }
                catch (ex) {
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_14__._throwInternal)(_logger, 2 /* eLoggingSeverity.WARNING */, 48 /* _eInternalMessageId.CannotSerializeObject */, "Unexpected Exception sending batch: " + (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_17__.dumpObj)(ex));
                }
            }
            function _buildRequestDetails(thePayload, useHeaders) {
                var requestDetails = {
                    url: _urlString,
                    hdrs: {},
                    useHdrs: false // Assume no headers
                };
                if (!useHeaders) {
                    // Attempt to map headers to a query string if possible
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_16__.objForEachKey)(_headers, function (name, value) {
                        if (_collectorHeaderToQs[name]) {
                            _addRequestDetails(requestDetails, _collectorHeaderToQs[name], value, false);
                        }
                        else {
                            // No mapping, so just include in the headers anyway (may not get sent if using sendBeacon())
                            requestDetails[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HDRS /* @min:%2ehdrs */][name] = value;
                            requestDetails[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_USE_HDRS /* @min:%2euseHdrs */] = true;
                        }
                    });
                }
                else {
                    // Copy the pre-defined headers into the payload headers
                    requestDetails[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HDRS /* @min:%2ehdrs */] = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__.extend)(requestDetails[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HDRS /* @min:%2ehdrs */], _headers);
                    requestDetails.useHdrs = ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_2__.objKeys)(requestDetails.hdrs)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0);
                }
                _addRequestDetails(requestDetails, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CLIENT_ID, "NO_AUTH", useHeaders);
                _addRequestDetails(requestDetails, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CLIENT_VERSION, _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__.FullVersionString, useHeaders);
                var apiQsKeys = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EMPTY;
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_19__.arrForEach)(thePayload.apiKeys, function (apiKey) {
                    if (apiQsKeys[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
                        apiQsKeys += ",";
                    }
                    apiQsKeys += apiKey;
                });
                _addRequestDetails(requestDetails, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_API_KEY, apiQsKeys, useHeaders);
                _addRequestDetails(requestDetails, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_UPLOAD_TIME, (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_21__.utcNow)().toString(), useHeaders);
                var msfpc = _getMsfpc(thePayload);
                if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__.isValueAssigned)(msfpc)) {
                    requestDetails.url += "&ext.intweb.msfpc=" + msfpc;
                }
                if (_clockSkewManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SHOULD_ADD_CLOCK_SKE1 /* @min:%2eshouldAddClockSkewHeaders */]()) {
                    _addRequestDetails(requestDetails, _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_TIME_DELTA_TO_APPLY, _clockSkewManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CLOCK_SKEW_HEADE2 /* @min:%2egetClockSkewHeaderValue */](), useHeaders);
                }
                if (_core[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_WPARAM /* @min:%2egetWParam */]) {
                    var wParam = _core[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_WPARAM /* @min:%2egetWParam */]();
                    if (wParam >= 0) {
                        requestDetails.url += "&w=" + wParam;
                    }
                }
                for (var i = 0; i < _queryStringParameters[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]; i++) {
                    requestDetails.url += "&" + _queryStringParameters[i].name + "=" + _queryStringParameters[i].value;
                }
                return requestDetails;
            }
            function _setTimingValue(timings, name, value) {
                timings[name] = timings[name] || {};
                timings[name][_postManager.identifier] = value;
            }
            function _doPayloadSend(thePayload, serializationStart, serializationCompleted, sendReason) {
                if (thePayload && thePayload.payloadBlob && thePayload.payloadBlob[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    var useSendHook_1 = !!_sendHook;
                    var sendInterface_1 = _sendInterfaces[thePayload.sendType];
                    // Send all data using a beacon style transport if closing mode is on or channel was teared down
                    if (!_isBeaconPayload(thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEND_TYPE /* @min:%2esendType */]) && thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_BEACON /* @min:%2eisBeacon */] && thePayload.sendReason === 2 /* SendRequestReason.Unload */) {
                        sendInterface_1 = _sendInterfaces[2 /* EventSendType.SendBeacon */] || _sendInterfaces[3 /* EventSendType.SyncFetch */] || sendInterface_1;
                    }
                    var useHeaders_1 = _useHeaders;
                    // Disable header usage if we know we are using sendBeacon as additional headers are not supported
                    if (thePayload.isBeacon || sendInterface_1[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__TRANSPORT /* @min:%2e_transport */] === 3 /* TransportType.Beacon */) {
                        useHeaders_1 = false;
                    }
                    var requestDetails_1 = _buildRequestDetails(thePayload, useHeaders_1);
                    useHeaders_1 = useHeaders_1 || requestDetails_1[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_USE_HDRS /* @min:%2euseHdrs */];
                    var sendEventStart_1 = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__.getTime)();
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_20__.doPerf)(_core, function () { return "HttpManager:_doPayloadSend"; }, function () {
                        // Increment the send attempt count and add timings after packaging (So it's not serialized in the 1st attempt)
                        for (var batchLp = 0; batchLp < thePayload.batches[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]; batchLp++) {
                            var theBatch = thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_BATCHES /* @min:%2ebatches */][batchLp];
                            var theEvents = theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_EVENTS /* @min:%2eevents */]();
                            for (var evtLp = 0; evtLp < theEvents[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]; evtLp++) {
                                var telemetryItem = theEvents[evtLp];
                                if (_enableEventTimings) {
                                    var timings = telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIMINGS /* @min:%2etimings */] = telemetryItem[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIMINGS /* @min:%2etimings */] || {};
                                    _setTimingValue(timings, "sendEventStart", sendEventStart_1);
                                    _setTimingValue(timings, "serializationStart", serializationStart);
                                    _setTimingValue(timings, "serializationCompleted", serializationCompleted);
                                }
                                telemetryItem[strSendAttempt] > 0 ? telemetryItem[strSendAttempt]++ : telemetryItem[strSendAttempt] = 1;
                            }
                        }
                        // Note: always sending this notification in a synchronous manner.
                        _sendBatchesNotification(thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_BATCHES /* @min:%2ebatches */], (1000 /* EventBatchNotificationReason.SendingUndefined */ + (sendReason || 0 /* SendRequestReason.Undefined */)), thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEND_TYPE /* @min:%2esendType */], true);
                        // Disabling the use of const because of Issue:
                        // - Task 9227844: [1DS] Some environments and packagers automatically "freeze" objects which are defined as const which causes any mutations to throw
                        // eslint-disable-next-line prefer-const
                        var orgPayloadData = {
                            data: thePayload.payloadBlob,
                            urlString: requestDetails_1.url,
                            headers: requestDetails_1[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HDRS /* @min:%2ehdrs */],
                            _thePayload: thePayload,
                            _sendReason: sendReason,
                            timeout: _xhrTimeout,
                            disableXhrSync: _disableXhrSync,
                            disableFetchKeepAlive: _disableFetchKeepAlive
                        };
                        // Only automatically add the following headers if already sending headers and we are not attempting to avoid an options call
                        if (useHeaders_1) {
                            if (!_hasHeader(orgPayloadData[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HEADERS /* @min:%2eheaders */], _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CACHE_CONTROL)) {
                                orgPayloadData[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HEADERS /* @min:%2eheaders */][_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CACHE_CONTROL] = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.DEFAULT_CACHE_CONTROL;
                            }
                            if (!_hasHeader(orgPayloadData[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HEADERS /* @min:%2eheaders */], _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CONTENT_TYPE_HEADER)) {
                                orgPayloadData[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HEADERS /* @min:%2eheaders */][_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_CONTENT_TYPE_HEADER] = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.DEFAULT_CONTENT_TYPE;
                            }
                        }
                        var sender = null;
                        if (sendInterface_1) {
                            // Send sync requests if the request is immediate or we are tearing down telemetry.
                            sender = function (payload) {
                                // Notify the clock skew manager that we are sending the first request (Potentially blocking all further requests)
                                _clockSkewManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_FIRST_REQUEST_SENT /* @min:%2efirstRequestSent */]();
                                var onComplete = function (status, headers) {
                                    _retryRequestIfNeeded(status, headers, thePayload, sendReason);
                                };
                                var isSync = thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_TEARDOWN /* @min:%2eisTeardown */] || thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_SYNC /* @min:%2eisSync */];
                                try {
                                    sendInterface_1[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEND_POST /* @min:%2esendPOST */](payload, onComplete, isSync);
                                    if (_sendListener) {
                                        // Send the original payload to the listener
                                        _sendListener(orgPayloadData, payload, isSync, thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_BEACON /* @min:%2eisBeacon */]);
                                    }
                                }
                                catch (ex) {
                                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_14__._warnToConsole)(_logger, "Unexpected exception sending payload. Ex:" + (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_17__.dumpObj)(ex));
                                    _doOnComplete(onComplete, 0, {});
                                }
                            };
                        }
                        (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_20__.doPerf)(_core, function () { return "HttpManager:_doPayloadSend.sender"; }, function () {
                            if (sender) {
                                if (thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEND_TYPE /* @min:%2esendType */] === 0 /* EventSendType.Batched */) {
                                    _outstandingRequests++;
                                }
                                // Only call the hook if it's defined and we are not using sendBeacon as additional headers are not supported
                                if (useSendHook_1 && !thePayload.isBeacon && sendInterface_1[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__TRANSPORT /* @min:%2e_transport */] !== 3 /* TransportType.Beacon */) {
                                    // Create a new IPayloadData that is sent into the hook method, so that the hook method
                                    // can't change the object references to the orgPayloadData (it can still change the content -- mainly the headers)
                                    // Disabling the use of const because of Issue:
                                    // - Task 9227844: [1DS] Some environments and packagers automatically "freeze" objects which are defined as const which causes any mutations to throw
                                    // eslint-disable-next-line prefer-const
                                    var hookData_1 = {
                                        data: orgPayloadData[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_DATA /* @min:%2edata */],
                                        urlString: orgPayloadData[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_URL_STRING /* @min:%2eurlString */],
                                        headers: (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__.extend)({}, orgPayloadData[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_HEADERS /* @min:%2eheaders */]),
                                        timeout: orgPayloadData[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIMEOUT /* @min:%2etimeout */],
                                        disableXhrSync: orgPayloadData[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_DISABLE_XHR_SYNC /* @min:%2edisableXhrSync */],
                                        disableFetchKeepAlive: orgPayloadData[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_DISABLE_FETCH_KEEP_A6 /* @min:%2edisableFetchKeepAlive */]
                                    };
                                    var senderCalled_1 = false;
                                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_20__.doPerf)(_core, function () { return "HttpManager:_doPayloadSend.sendHook"; }, function () {
                                        try {
                                            _sendHook(hookData_1, function (payload) {
                                                senderCalled_1 = true;
                                                // Add back the internal properties
                                                if (!_customHttpInterface && !payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__THE_PAYLOAD /* @min:%2e_thePayload */]) {
                                                    payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__THE_PAYLOAD /* @min:%2e_thePayload */] = payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__THE_PAYLOAD /* @min:%2e_thePayload */] || orgPayloadData[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__THE_PAYLOAD /* @min:%2e_thePayload */];
                                                    payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__SEND_REASON /* @min:%2e_sendReason */] = payload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__SEND_REASON /* @min:%2e_sendReason */] || orgPayloadData[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__SEND_REASON /* @min:%2e_sendReason */];
                                                }
                                                sender(payload);
                                            }, thePayload.isSync || thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_TEARDOWN /* @min:%2eisTeardown */]);
                                        }
                                        catch (ex) {
                                            if (!senderCalled_1) {
                                                // The hook never called the sender -- assume that it never will
                                                sender(orgPayloadData);
                                            }
                                        }
                                    });
                                }
                                else {
                                    sender(orgPayloadData);
                                }
                            }
                        });
                    }, function () { return ({ thePayload: thePayload, serializationStart: serializationStart, serializationCompleted: serializationCompleted, sendReason: sendReason }); }, thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_SYNC /* @min:%2eisSync */]);
                }
                if (thePayload.sizeExceed && thePayload.sizeExceed[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    // Ensure that we send any discard events for oversize events even when there was no payload to send
                    _sendBatchesNotification(thePayload.sizeExceed, 8003 /* EventBatchNotificationReason.SizeLimitExceeded */, thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEND_TYPE /* @min:%2esendType */]);
                }
                if (thePayload.failedEvts && thePayload.failedEvts[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0) {
                    // Ensure that we send any discard events for events that could not be serialized even when there was no payload to send
                    _sendBatchesNotification(thePayload.failedEvts, 8002 /* EventBatchNotificationReason.InvalidEvent */, thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEND_TYPE /* @min:%2esendType */]);
                }
            }
            function _addEventCompletedTimings(theEvents, sendEventCompleted) {
                if (_enableEventTimings) {
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_19__.arrForEach)(theEvents, function (theEvent) {
                        var timings = theEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIMINGS /* @min:%2etimings */] = theEvent[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TIMINGS /* @min:%2etimings */] || {};
                        _setTimingValue(timings, "sendEventCompleted", sendEventCompleted);
                    });
                }
            }
            function _retryRequestIfNeeded(status, headers, thePayload, sendReason) {
                var reason = 9000 /* EventBatchNotificationReason.ResponseFailure */;
                var droppedBatches = null;
                var isRetrying = false;
                var backOffTrans = false;
                try {
                    var shouldRetry = true;
                    if (typeof status !== _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_22__.strShimUndefined) {
                        if (headers) {
                            _clockSkewManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CLOCK_SKEW /* @min:%2esetClockSkew */](headers[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_TIME_DELTA_HEADER]);
                            var killDuration = headers[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_KILL_DURATION_HEADER] || headers["kill-duration-seconds"];
                            (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_19__.arrForEach)(_killSwitch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_KILL_SWITCH_TENA10 /* @min:%2esetKillSwitchTenants */](headers[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_KILL_TOKENS_HEADER], killDuration), function (killToken) {
                                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_19__.arrForEach)(thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_BATCHES /* @min:%2ebatches */], function (theBatch) {
                                    if (theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_I_KEY /* @min:%2eiKey */]() === killToken) {
                                        // Make sure we have initialized the array
                                        droppedBatches = droppedBatches || [];
                                        // Create a copy of the batch with all of the events (and more importantly the action functions)
                                        var removedEvents = theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPLIT /* @min:%2esplit */](0);
                                        // And then remove the events for the payload batch and reduce the actual number of processed
                                        thePayload.numEvents -= removedEvents[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COUNT /* @min:%2ecount */]();
                                        droppedBatches[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */](removedEvents);
                                    }
                                });
                            });
                        }
                        // Disabling triple-equals rule to avoid httpOverrides from failing because they are returning a string value
                        // tslint:disable-next-line:triple-equals
                        if (status == 200 || status == 204) {
                            // Response was successfully sent
                            reason = 200 /* EventBatchNotificationReason.Complete */;
                            return;
                        }
                        if (!(0,_RetryPolicy__WEBPACK_IMPORTED_MODULE_23__.retryPolicyShouldRetryForStatus)(status) || thePayload.numEvents <= 0) {
                            // Only retry for specific response codes and if there is still events after kill switch processing
                            shouldRetry = false;
                        }
                        // Derive the notification response from the HttpStatus Code
                        reason = 9000 /* EventBatchNotificationReason.ResponseFailure */ + (status % 1000);
                    }
                    if (shouldRetry) {
                        // The events should be retried -- so change notification to requeue them
                        reason = 100 /* EventBatchNotificationReason.RequeueEvents */;
                        var retryCount_1 = thePayload.retryCnt;
                        if (thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEND_TYPE /* @min:%2esendType */] === 0 /* EventSendType.Batched */) {
                            // attempt to resend the entire batch
                            if (retryCount_1 < maxRequestRetriesBeforeBackoff) {
                                isRetrying = true;
                                _doAction(function () {
                                    // try to resend the same batches
                                    if (thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEND_TYPE /* @min:%2esendType */] === 0 /* EventSendType.Batched */) {
                                        // Reduce the outstanding request count (if this was an async request) as we didn't reduce the count
                                        // previously and we are about to reschedule our retry attempt and we want an attempt to send
                                        // to occur, it's also required to ensure that a follow up handleRequestFinished() call occurs
                                        _outstandingRequests--;
                                    }
                                    _sendBatches(thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_BATCHES /* @min:%2ebatches */], retryCount_1 + 1, thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_TEARDOWN /* @min:%2eisTeardown */], _isUnloading ? 2 /* EventSendType.SendBeacon */ : thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEND_TYPE /* @min:%2esendType */], 5 /* SendRequestReason.Retry */);
                                }, _isUnloading, (0,_RetryPolicy__WEBPACK_IMPORTED_MODULE_23__.retryPolicyGetMillisToBackoffForRetry)(retryCount_1));
                            }
                            else {
                                backOffTrans = true;
                                if (_isUnloading) {
                                    // we are unloading so don't try and requeue the events otherwise let the events get requeued and resent during the backoff sending
                                    // This will also cause the events to be purged based on the priority (if necessary)
                                    reason = 8001 /* EventBatchNotificationReason.NonRetryableStatus */;
                                }
                            }
                        }
                    }
                }
                finally {
                    if (!isRetrying) {
                        // Make sure the clockSkewManager doesn't blocking further sending of requests once we have a proper response
                        // This won't override any previously sent clock Skew value
                        _clockSkewManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CLOCK_SKEW /* @min:%2esetClockSkew */]();
                        _handleRequestFinished(thePayload, reason, sendReason, backOffTrans);
                    }
                    _sendBatchesNotification(droppedBatches, 8004 /* EventBatchNotificationReason.KillSwitch */, thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEND_TYPE /* @min:%2esendType */]);
                }
            }
            function _handleRequestFinished(thePayload, batchReason, sendReason, backOffTrans) {
                try {
                    if (backOffTrans) {
                        // Slow down the transmission requests
                        _postManager[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN__BACK_OFF_TRANSMISSI11 /* @min:%2e_backOffTransmission */]();
                    }
                    if (batchReason === 200 /* EventBatchNotificationReason.Complete */) {
                        if (!backOffTrans && !thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_SYNC /* @min:%2eisSync */]) {
                            // We have a successful async response, so the lets open the floodgates
                            // The reason for checking isSync is to avoid unblocking if beacon send occurred as it
                            // doesn't wait for a response.
                            _postManager._clearBackOff();
                        }
                        _addCompleteTimings(thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_BATCHES /* @min:%2ebatches */]);
                    }
                    // Send the notifications synchronously
                    _sendBatchesNotification(thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_BATCHES /* @min:%2ebatches */], batchReason, thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEND_TYPE /* @min:%2esendType */], true);
                }
                finally {
                    if (thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEND_TYPE /* @min:%2esendType */] === 0 /* EventSendType.Batched */) {
                        // we always need to decrement this value otherwise the httpmanager locks up and won't send any more events
                        _outstandingRequests--;
                        // Don't try to send additional queued events if this is a retry operation as the retried
                        // response will eventually call _handleRequestFinished for the retried event
                        if (sendReason !== 5 /* SendRequestReason.Retry */) {
                            // Try and send any other queued batched events
                            _self.sendQueuedRequests(thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SEND_TYPE /* @min:%2esendType */], sendReason);
                        }
                    }
                }
            }
            function _addCompleteTimings(theBatches) {
                if (_enableEventTimings) {
                    var sendEventCompleted_1 = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__.getTime)();
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_19__.arrForEach)(theBatches, function (theBatch) {
                        if (theBatch && theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_COUNT /* @min:%2ecount */]() > 0) {
                            _addEventCompletedTimings(theBatch[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_EVENTS /* @min:%2eevents */](), sendEventCompleted_1);
                        }
                    });
                }
            }
            function _doAction(cb, isSync, interval) {
                if (isSync) {
                    cb();
                }
                else {
                    _timeoutWrapper.set(cb, interval);
                }
            }
            /**
            * Converts the XHR getAllResponseHeaders to a map containing the header key and value.
            */
            // tslint:disable-next-line: align
            function _convertAllHeadersToMap(headersString) {
                var headers = {};
                if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.isString)(headersString)) {
                    var headersArray = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_15__.strTrim)(headersString)[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPLIT /* @min:%2esplit */](/[\r\n]+/);
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_19__.arrForEach)(headersArray, function (headerEntry) {
                        if (headerEntry) {
                            var idx = headerEntry.indexOf(": ");
                            if (idx !== -1) {
                                // The new spec has the headers returning all as lowercase -- but not all browsers do this yet
                                var header = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_15__.strTrim)(headerEntry.substring(0, idx))[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_TO_LOWER_CASE /* @min:%2etoLowerCase */]();
                                var value = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_15__.strTrim)(headerEntry.substring(idx + 1));
                                headers[header] = value;
                            }
                            else {
                                headers[(0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_15__.strTrim)(headerEntry)] = 1;
                            }
                        }
                    });
                }
                return headers;
            }
            function _getMsfpc(thePayload) {
                for (var lp = 0; lp < thePayload.batches[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]; lp++) {
                    var msfpc = thePayload[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_BATCHES /* @min:%2ebatches */][lp].Msfpc();
                    if (msfpc) {
                        return encodeURIComponent(msfpc);
                    }
                }
                return _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_EMPTY;
            }
            function _handleCollectorResponse(responseText) {
                var responseHandlers = _responseHandlers;
                try {
                    for (var i = 0; i < responseHandlers[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]; i++) {
                        try {
                            responseHandlers[i](responseText);
                        }
                        catch (e) {
                            (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_14__._throwInternal)(_logger, 1 /* eLoggingSeverity.CRITICAL */, 519 /* _eExtendedInternalMessageId.PostResponseHandler */, "Response handler failed: " + e);
                        }
                    }
                    if (responseText) {
                        var response = JSON.parse(responseText);
                        if ((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__.isValueAssigned)(response.webResult) && (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__.isValueAssigned)(response.webResult[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_MSFPC])) {
                            // Set cookie
                            _cookieMgr.set("MSFPC", response.webResult[_InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_MSFPC], 365 * 86400);
                        }
                    }
                }
                catch (ex) {
                    // Doing nothing
                }
            }
            function _sendBatchesNotification(theBatches, batchReason, sendType, sendSync) {
                if (theBatches && theBatches[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */] > 0 && actions) {
                    var theAction_1 = actions[_getNotificationAction(batchReason)];
                    if (theAction_1) {
                        var isSyncRequest_1 = sendType !== 0 /* EventSendType.Batched */;
                        (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_20__.doPerf)(_core, function () { return "HttpManager:_sendBatchesNotification"; }, function () {
                            _doAction(function () {
                                try {
                                    theAction_1.call(actions, theBatches, batchReason, isSyncRequest_1, sendType);
                                }
                                catch (e) {
                                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_14__._throwInternal)(_logger, 1 /* eLoggingSeverity.CRITICAL */, 74 /* _eInternalMessageId.NotificationException */, "send request notification failed: " + e);
                                }
                            }, sendSync || isSyncRequest_1, 0);
                        }, function () { return ({ batches: _createDebugBatches(theBatches), reason: batchReason, isSync: isSyncRequest_1, sendSync: sendSync, sendType: sendType }); }, !isSyncRequest_1);
                    }
                }
            }
            function _getNotificationAction(reason) {
                var action = _eventActionMap[reason];
                if (!(0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_11__.isValueAssigned)(action)) {
                    action = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_OTHER;
                    if (reason >= 9000 /* EventBatchNotificationReason.ResponseFailure */ && reason <= 9999 /* EventBatchNotificationReason.ResponseFailureMax */) {
                        action = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_RESPONSE_FAIL;
                    }
                    else if (reason >= 8000 /* EventBatchNotificationReason.EventsDropped */ && reason <= 8999 /* EventBatchNotificationReason.EventsDroppedMax */) {
                        action = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_DROPPED;
                    }
                    else if (reason >= 1000 /* EventBatchNotificationReason.SendingUndefined */ && reason <= 1999 /* EventBatchNotificationReason.SendingEventMax */) {
                        action = _InternalConstants__WEBPACK_IMPORTED_MODULE_0__.STR_SENDING;
                    }
                }
                return action;
            }
        });
    }
// Removed Stub for HttpManager.prototype.initialize.
// Removed Stub for HttpManager.prototype.addHeader.
// Removed Stub for HttpManager.prototype.addResponseHandler.
// Removed Stub for HttpManager.prototype.addBatch.
// Removed Stub for HttpManager.prototype.canSendRequest.
// Removed Stub for HttpManager.prototype.sendQueuedRequests.
// Removed Stub for HttpManager.prototype.isCompletelyIdle.
// Removed Stub for HttpManager.prototype.setUnloading.
// Removed Stub for HttpManager.prototype.teardown.
// Removed Stub for HttpManager.prototype.pause.
// Removed Stub for HttpManager.prototype.resume.
// Removed Stub for HttpManager.prototype.sendSynchronousBatch.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    HttpManager.__ieDyn=1;

    return HttpManager;
}());

//# sourceMappingURL=HttpManager.js.map

/***/ }),
/* 120 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ClockSkewManager: () => (/* binding */ ClockSkewManager)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(118);
/*
 * 1DS JS SDK POST plugin, 4.0.3
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
* ClockSkewManager.ts
* @author Abhilash Panwar (abpanwar)
* @copyright Microsoft 2018
*/


/**
* Class to manage clock skew correction.
*/
var ClockSkewManager = /** @class */ (function () {
    function ClockSkewManager() {
        var _allowRequestSending = true;
        var _shouldAddClockSkewHeaders = true;
        var _isFirstRequest = true;
        var _clockSkewHeaderValue = "use-collector-delta";
        var _clockSkewSet = false;
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_0__["default"])(ClockSkewManager, this, function (_self) {
            /**
             * Determine if requests can be sent.
             * @returns True if requests can be sent, false otherwise.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_ALLOW_REQUEST_SENDIN0 /* @min:%2eallowRequestSending */] = function () {
                return _allowRequestSending;
            };
            /**
             * Tells the ClockSkewManager that it should assume that the first request has now been sent,
             * If this method had not yet been called AND the clock Skew had not been set this will set
             * allowRequestSending to false until setClockSet() is called.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_FIRST_REQUEST_SENT /* @min:%2efirstRequestSent */] = function () {
                if (_isFirstRequest) {
                    _isFirstRequest = false;
                    if (!_clockSkewSet) {
                        // Block sending until we get the first clock Skew
                        _allowRequestSending = false;
                    }
                }
            };
            /**
             * Determine if clock skew headers should be added to the request.
             * @returns True if clock skew headers should be added, false otherwise.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SHOULD_ADD_CLOCK_SKE1 /* @min:%2eshouldAddClockSkewHeaders */] = function () {
                return _shouldAddClockSkewHeaders;
            };
            /**
             * Gets the clock skew header value.
             * @returns The clock skew header value.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_GET_CLOCK_SKEW_HEADE2 /* @min:%2egetClockSkewHeaderValue */] = function () {
                return _clockSkewHeaderValue;
            };
            /**
             * Sets the clock skew header value. Once clock skew is set this method
             * is no-op.
             * @param timeDeltaInMillis - Time delta to be saved as the clock skew header value.
             */
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_CLOCK_SKEW /* @min:%2esetClockSkew */] = function (timeDeltaInMillis) {
                if (!_clockSkewSet) {
                    if (timeDeltaInMillis) {
                        _clockSkewHeaderValue = timeDeltaInMillis;
                        _shouldAddClockSkewHeaders = true;
                        _clockSkewSet = true;
                    }
                    else {
                        _shouldAddClockSkewHeaders = false;
                    }
                    // Unblock sending
                    _allowRequestSending = true;
                }
            };
        });
    }
// Removed Stub for ClockSkewManager.prototype.allowRequestSending.
// Removed Stub for ClockSkewManager.prototype.firstRequestSent.
// Removed Stub for ClockSkewManager.prototype.shouldAddClockSkewHeaders.
// Removed Stub for ClockSkewManager.prototype.getClockSkewHeaderValue.
// Removed Stub for ClockSkewManager.prototype.setClockSkew.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    ClockSkewManager.__ieDyn=1;

    return ClockSkewManager;
}());

//# sourceMappingURL=ClockSkewManager.js.map

/***/ }),
/* 121 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   KillSwitch: () => (/* binding */ KillSwitch)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(86);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(41);
/* harmony import */ var _DynamicConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(118);
/*
 * 1DS JS SDK POST plugin, 4.0.3
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
* KillSwitch.ts
* @author Abhilash Panwar (abpanwar)
* @copyright Microsoft 2018
*/



var SecToMsMultiplier = 1000;
/**
* Class to stop certain tenants sending events.
*/
var KillSwitch = /** @class */ (function () {
    function KillSwitch() {
        var _killedTokenDictionary = {};
        function _normalizeTenants(values) {
            var result = [];
            if (values) {
                (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_0__.arrForEach)(values, function (value) {
                    result[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_PUSH /* @min:%2epush */]((0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_2__.strTrim)(value));
                });
            }
            return result;
        }
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_3__["default"])(KillSwitch, this, function (_self) {
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SET_KILL_SWITCH_TENA10 /* @min:%2esetKillSwitchTenants */] = function (killTokens, killDuration) {
                if (killTokens && killDuration) {
                    try {
                        var killedTokens = _normalizeTenants(killTokens[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_SPLIT /* @min:%2esplit */](","));
                        if (killDuration === "this-request-only") {
                            return killedTokens;
                        }
                        var durationMs = parseInt(killDuration, 10) * SecToMsMultiplier;
                        for (var i = 0; i < killedTokens[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_LENGTH /* @min:%2elength */]; ++i) {
                            _killedTokenDictionary[killedTokens[i]] = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.utcNow)() + durationMs;
                        }
                    }
                    catch (ex) {
                        return [];
                    }
                }
                return [];
            };
            _self[_DynamicConstants__WEBPACK_IMPORTED_MODULE_1__._DYN_IS_TENANT_KILLED /* @min:%2eisTenantKilled */] = function (tenantToken) {
                var killDictionary = _killedTokenDictionary;
                var name = (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_2__.strTrim)(tenantToken);
                if (killDictionary[name] !== undefined && killDictionary[name] > (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_4__.utcNow)()) {
                    return true;
                }
                delete killDictionary[name];
                return false;
            };
        });
    }
// Removed Stub for KillSwitch.prototype.setKillSwitchTenants.
// Removed Stub for KillSwitch.prototype.isTenantKilled.
    // This is a workaround for an IE bug when using dynamicProto() with classes that don't have any
    // non-dynamic functions or static properties/functions when using uglify-js to minify the resulting code.
    KillSwitch.__ieDyn=1;

    return KillSwitch;
}());

//# sourceMappingURL=KillSwitch.js.map

/***/ }),
/* 122 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   retryPolicyGetMillisToBackoffForRetry: () => (/* binding */ retryPolicyGetMillisToBackoffForRetry),
/* harmony export */   retryPolicyShouldRetryForStatus: () => (/* binding */ retryPolicyShouldRetryForStatus)
/* harmony export */ });
/*
 * 1DS JS SDK POST plugin, 4.0.3
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
* RetryPolicy.ts
* @author Abhilash Panwar (abpanwar)
* @copyright Microsoft 2018
*/
var RandomizationLowerThreshold = 0.8;
var RandomizationUpperThreshold = 1.2;
var BaseBackoff = 3000;
var MaxBackoff = 600000;
/**
 * Determine if the request should be retried for the given status code.
 * The below expression reads that we should only retry for:
 *      - HttpStatusCodes that are smaller than 300.
 *      - HttpStatusCodes greater or equal to 500 (except for 501-NotImplement
 *        and 505-HttpVersionNotSupport).
 *      - HttpStatusCode 408-RequestTimeout.
 *      - HttpStatusCode 429.
 * This is based on Microsoft.WindowsAzure.Storage.RetryPolicies.ExponentialRetry class
 * @param httpStatusCode - The status code returned for the request.
 * @returns True if request should be retried, false otherwise.
 */
function retryPolicyShouldRetryForStatus(httpStatusCode) {
    /* tslint:disable:triple-equals */
    // Disabling triple-equals rule to avoid httpOverrides from failing because they are returning a string value
    return !((httpStatusCode >= 300 && httpStatusCode < 500 && httpStatusCode != 408 && httpStatusCode != 429)
        || (httpStatusCode == 501)
        || (httpStatusCode == 505));
    /* tslint:enable:triple-equals */
}
/**
 * Gets the number of milliseconds to back off before retrying the request. The
 * back off duration is exponentially scaled based on the number of retries already
 * done for the request.
 * @param retriesSoFar - The number of times the request has already been retried.
 * @returns The back off duration for the request before it can be retried.
 */
function retryPolicyGetMillisToBackoffForRetry(retriesSoFar) {
    var waitDuration = 0;
    var minBackoff = BaseBackoff * RandomizationLowerThreshold;
    var maxBackoff = BaseBackoff * RandomizationUpperThreshold;
    var randomBackoff = Math.floor(Math.random() * (maxBackoff - minBackoff)) + minBackoff;
    waitDuration = Math.pow(2, retriesSoFar) * randomBackoff;
    return Math.min(waitDuration, MaxBackoff);
}
//# sourceMappingURL=RetryPolicy.js.map

/***/ }),
/* 123 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Serializer: () => (/* binding */ Serializer)
/* harmony export */ });
/* harmony import */ var _microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(46);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(58);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(21);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(15);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(57);
/* harmony import */ var _microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(13);
/* harmony import */ var _EventBatch__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(116);
/* harmony import */ var _InternalConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(117);
/* harmony import */ var _nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(28);
/*
 * 1DS JS SDK POST plugin, 4.0.3
 * Copyright (c) Microsoft and contributors. All rights reserved.
 * (Microsoft Internal Only)
 */
/**
* Serializer.ts
* @author Abhilash Panwar (abpanwar); Hector Hernandez (hectorh); Nev Wylie (newylie)
* @copyright Microsoft 2018-2020
*/
// @skip-file-minify





/**
 * Note: This is an optimization for V8-based browsers. When V8 concatenates a string,
 * the strings are only joined logically using a "cons string" or "constructed/concatenated
 * string". These containers keep references to one another and can result in very large
 * memory usage. For example, if a 2MB string is constructed by concatenating 4 bytes
 * together at a time, the memory usage will be ~44MB; so ~22x increase. The strings are
 * only joined together when an operation requiring their joining takes place, such as
 * substr(). This function is called when adding data to this buffer to ensure these
 * types of strings are periodically joined to reduce the memory footprint.
 * Setting to every 20 events as the JSON.stringify() may have joined many strings
 * and calling this too much causes a minor delay while processing.
 */
var _MAX_STRING_JOINS = 20;
var RequestSizeLimitBytes = 3984588; // approx 3.8 Mb
var BeaconRequestSizeLimitBytes = 65000; // approx 64kb (the current Edge, Firefox and Chrome max limit)
var MaxRecordSize = 2000000; // approx 2 Mb
var MaxBeaconRecordSize = Math.min(MaxRecordSize, BeaconRequestSizeLimitBytes);
var metadata = "metadata";
var f = "f";
var rCheckDot = /\./;
/**
* Class to handle serialization of event and request.
* Currently uses Bond for serialization. Please note that this may be subject to change.
*/
var Serializer = /** @class */ (function () {
    function Serializer(perfManager, valueSanitizer, stringifyObjects, enableCompoundKey) {
        var strData = "data";
        var strBaseData = "baseData";
        var strExt = "ext";
        var _checkForCompoundkey = !!enableCompoundKey;
        var _processSubMetaData = true;
        var _theSanitizer = valueSanitizer;
        var _isReservedCache = {};
        (0,_microsoft_dynamicproto_js__WEBPACK_IMPORTED_MODULE_0__["default"])(Serializer, this, function (_self) {
            _self.createPayload = function (retryCnt, isTeardown, isSync, isReducedPayload, sendReason, sendType) {
                return {
                    apiKeys: [],
                    payloadBlob: _InternalConstants__WEBPACK_IMPORTED_MODULE_1__.STR_EMPTY,
                    overflow: null,
                    sizeExceed: [],
                    failedEvts: [],
                    batches: [],
                    numEvents: 0,
                    retryCnt: retryCnt,
                    isTeardown: isTeardown,
                    isSync: isSync,
                    isBeacon: isReducedPayload,
                    sendType: sendType,
                    sendReason: sendReason
                };
            };
            _self.appendPayload = function (payload, theBatch, maxEventsPerBatch) {
                var canAddEvents = payload && theBatch && !payload.overflow;
                if (canAddEvents) {
                    (0,_microsoft_1ds_core_js__WEBPACK_IMPORTED_MODULE_2__.doPerf)(perfManager, function () { return "Serializer:appendPayload"; }, function () {
                        var theEvents = theBatch.events();
                        var payloadBlob = payload.payloadBlob;
                        var payloadEvents = payload.numEvents;
                        var eventsAdded = false;
                        var sizeExceeded = [];
                        var failedEvts = [];
                        var isBeaconPayload = payload.isBeacon;
                        var requestMaxSize = isBeaconPayload ? BeaconRequestSizeLimitBytes : RequestSizeLimitBytes;
                        var recordMaxSize = isBeaconPayload ? MaxBeaconRecordSize : MaxRecordSize;
                        var lp = 0;
                        var joinCount = 0;
                        while (lp < theEvents.length) {
                            var theEvent = theEvents[lp];
                            if (theEvent) {
                                if (payloadEvents >= maxEventsPerBatch) {
                                    // Maximum events per payload reached, so don't add any more
                                    payload.overflow = theBatch.split(lp);
                                    break;
                                }
                                var eventBlob = _self.getEventBlob(theEvent);
                                if (eventBlob && eventBlob.length <= recordMaxSize) {
                                    // This event will fit into the payload
                                    var blobLength = eventBlob.length;
                                    var currentSize = payloadBlob.length;
                                    if (currentSize + blobLength > requestMaxSize) {
                                        // Request or batch size exceeded, so don't add any more to the payload
                                        payload.overflow = theBatch.split(lp);
                                        break;
                                    }
                                    if (payloadBlob) {
                                        payloadBlob += "\n";
                                    }
                                    payloadBlob += eventBlob;
                                    joinCount++;
                                    // v8 memory optimization only
                                    if (joinCount > _MAX_STRING_JOINS) {
                                        // this substr() should cause the constructed string to join
                                        (0,_nevware21_ts_utils__WEBPACK_IMPORTED_MODULE_3__.strSubstr)(payloadBlob, 0, 1);
                                        joinCount = 0;
                                    }
                                    eventsAdded = true;
                                    payloadEvents++;
                                }
                                else {
                                    if (eventBlob) {
                                        // Single event size exceeded so remove from the batch
                                        sizeExceeded.push(theEvent);
                                    }
                                    el