/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.MultiTaskListener;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Pair;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.CompilerConfiguration;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.builder.SourceFile;
import org.eclipse.jdt.internal.javac.JavacClassFile;
import org.eclipse.jdt.internal.javac.JavacCompilationResult;
import org.eclipse.jdt.internal.javac.JavacConfig;
import org.eclipse.jdt.internal.javac.JavacProblem;
import org.eclipse.jdt.internal.javac.JavacProblemConverter;
import org.eclipse.jdt.internal.javac.JavacTaskListener;
import org.eclipse.jdt.internal.javac.JavacUtils;

public class JavacCompiler
extends Compiler {
    JavacConfig compilerConfig;
    IProblemFactory problemFactory;
    Map<JavaFileObject, ICompilationUnit> fileObjectToCUMap = new HashMap<JavaFileObject, ICompilationUnit>();

    public JavacCompiler(INameEnvironment environment, IErrorHandlingPolicy policy, CompilerConfiguration compilerConfig, ICompilerRequestor requestor, IProblemFactory problemFactory) {
        super(environment, policy, compilerConfig.compilerOptions(), requestor, problemFactory);
        this.compilerConfig = JavacConfig.createFrom(compilerConfig);
        this.problemFactory = problemFactory;
    }

    public void compile(ICompilationUnit[] sourceUnits) {
        Context javacContext = new Context();
        HashMap javacProblems = new HashMap();
        final JavacProblemConverter problemConverter = new JavacProblemConverter(this.compilerConfig.compilerOptions(), javacContext);
        javacContext.put(DiagnosticListener.class, diagnostic -> {
            Object patt0$temp = diagnostic.getSource();
            if (patt0$temp instanceof JavaFileObject) {
                JavaFileObject fileObject = (JavaFileObject)patt0$temp;
                JavacProblem javacProblem = problemConverter.createJavacProblem(diagnostic);
                if (javacProblem != null) {
                    ICompilationUnit originalUnit = this.fileObjectToCUMap.get(fileObject);
                    if (originalUnit == null) {
                        return;
                    }
                    ArrayList<JavacProblem> previous = (ArrayList<JavacProblem>)javacProblems.get(originalUnit);
                    if (previous == null) {
                        previous = new ArrayList<JavacProblem>();
                        javacProblems.put(originalUnit, previous);
                    }
                    previous.add(javacProblem);
                }
            }
        });
        IJavaProject javaProject = Stream.of(sourceUnits).filter(SourceFile.class::isInstance).map(SourceFile.class::cast).map(source -> source.resource).map(IResource::getProject).filter(JavaProject::hasJavaNature).map(JavaCore::create).findFirst().orElse(null);
        Map<IContainer, java.util.List<ICompilationUnit>> outputSourceMapping = Arrays.stream(sourceUnits).filter(unit -> {
            if (unit instanceof SourceFile) {
                SourceFile sf = (SourceFile)unit;
                File sourceFile = sf.resource.getLocation().toFile();
                if (this.compilerConfig != null && !JavacUtils.isEmpty(this.compilerConfig.generatedSourcePaths())) {
                    return !this.compilerConfig.generatedSourcePaths().stream().anyMatch(path -> sourceFile.toPath().startsWith(Path.of(path, new String[0])));
                }
            }
            return true;
        }).collect(Collectors.groupingBy(this::computeOutputDirectory));
        JavacTaskListener javacListener = new JavacTaskListener(this.compilerConfig, outputSourceMapping, this.problemFactory, this.fileObjectToCUMap);
        MultiTaskListener mtl = MultiTaskListener.instance(javacContext);
        mtl.add(javacListener);
        mtl.add(new TaskListener(){
            final /* synthetic */ JavacCompiler this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void finished(TaskEvent e) {
                ICompilationUnit iCompilationUnit;
                if (e.getSourceFile() != null && (iCompilationUnit = this.this$0.fileObjectToCUMap.get(e.getSourceFile())) instanceof JCTree.JCCompilationUnit) {
                    JCTree.JCCompilationUnit u = (JCTree.JCCompilationUnit)iCompilationUnit;
                    problemConverter.registerUnit(e.getSourceFile(), u);
                }
            }
        });
        for (Map.Entry<IContainer, java.util.List<ICompilationUnit>> outputSourceSet : outputSourceMapping.entrySet()) {
            File outputDir = JavacClassFile.getMappedTempOutput(outputSourceSet.getKey()).toFile();
            javacListener.setOutputDir(outputSourceSet.getKey());
            JavacUtils.configureJavacContext(javacContext, this.compilerConfig, javaProject, outputDir, true);
            JavaCompiler javac = new JavaCompiler(this, javacContext){
                boolean isInGeneration = false;

                @Override
                protected boolean shouldStop(CompileStates.CompileState cs) {
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void generate(Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>> queue, Queue<JavaFileObject> results) {
                    try {
                        this.isInGeneration = true;
                        super.generate(queue, results);
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        this.isInGeneration = false;
                    }
                }

                @Override
                protected void desugar(Env<AttrContext> env, Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>> results) {
                    try {
                        super.desugar(env, results);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }

                @Override
                public int errorCount() {
                    return this.isInGeneration ? 0 : super.errorCount();
                }
            };
            javacContext.put(JavaCompiler.compilerKey, javac);
            javac.shouldStopPolicyIfError = CompileStates.CompileState.GENERATE;
            JavacFileManager fileManager = (JavacFileManager)javacContext.get(JavaFileManager.class);
            try {
                javac.compile(List.from(outputSourceSet.getValue().stream().filter(SourceFile.class::isInstance).map(SourceFile.class::cast).map(source -> {
                    IResource asResource = javaProject.getProject().getParent().findMember(new String(source.getFileName()));
                    File unitFile = asResource != null ? asResource.getLocation().toFile() : new File(new String(source.getFileName()));
                    JavaFileObject jfo = fileManager.getJavaFileObject(unitFile.getAbsolutePath());
                    this.fileObjectToCUMap.put(jfo, (ICompilationUnit)source);
                    return jfo;
                }).toList()));
            }
            catch (Throwable e) {
                ILog.get().error("compilation failed", e);
            }
            for (int i = 0; i < sourceUnits.length; ++i) {
                ICompilationUnit in = sourceUnits[i];
                CompilationResult result = new CompilationResult(in, i, sourceUnits.length, Integer.MAX_VALUE);
                ArrayList<CategorizedProblem> problems = new ArrayList<CategorizedProblem>();
                if (javacListener.getResults().containsKey(in)) {
                    result = javacListener.getResults().get(in);
                    ((JavacCompilationResult)result).migrateReferenceInfo();
                    result.unitIndex = i;
                    result.totalUnitsKnown = sourceUnits.length;
                    java.util.List<CategorizedProblem> additionalProblems = ((JavacCompilationResult)result).getAdditionalProblems();
                    if (additionalProblems != null && !additionalProblems.isEmpty()) {
                        problems.addAll(additionalProblems);
                    }
                }
                if (javacProblems.containsKey(in)) {
                    problems.addAll((Collection)javacProblems.get(in));
                }
                result.problems = problems.toArray(new CategorizedProblem[0]);
                result.problemCount = problems.size();
                this.requestor.acceptResult(result);
                if (result.compiledTypes == null) continue;
                for (Object type : result.compiledTypes.values()) {
                    if (!(type instanceof JavacClassFile)) continue;
                    JavacClassFile classFile = (JavacClassFile)((Object)type);
                    classFile.deleteTempClassFile();
                    if (classFile.getBytes().length != 0) continue;
                    classFile.deleteExpectedClassFile();
                }
            }
        }
    }

    private IContainer computeOutputDirectory(ICompilationUnit unit) {
        if (unit instanceof SourceFile) {
            SourceFile sf = (SourceFile)unit;
            for (IContainer sourceDirectory = sf.resource.getParent(); sourceDirectory != null; sourceDirectory = sourceDirectory.getParent()) {
                IContainer mappedOutput = this.compilerConfig.sourceOutputMapping().get(sourceDirectory);
                if (mappedOutput == null) continue;
                return mappedOutput;
            }
        }
        return null;
    }
}

