/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.buildship.core.FixedVersionGradleDistribution;
import org.eclipse.buildship.core.LocalGradleDistribution;
import org.eclipse.buildship.core.RemoteGradleDistribution;
import org.eclipse.buildship.core.WrapperGradleDistribution;
import org.gradle.tooling.GradleConnector;

public abstract class GradleDistribution {
    private static final WrapperGradleDistribution WRAPPER_DISTRIBUTION = new WrapperGradleDistribution();

    public static LocalGradleDistribution forLocalInstallation(File installationDir) {
        return new LocalGradleDistribution(installationDir);
    }

    public static RemoteGradleDistribution forRemoteDistribution(URI distributionUri) {
        return new RemoteGradleDistribution(distributionUri);
    }

    public static FixedVersionGradleDistribution forVersion(String version) {
        return new FixedVersionGradleDistribution(version);
    }

    public static WrapperGradleDistribution fromBuild() {
        return WRAPPER_DISTRIBUTION;
    }

    public static GradleDistribution fromString(String distributionString) {
        Preconditions.checkNotNull((Object)distributionString);
        String localInstallationPrefix = "GRADLE_DISTRIBUTION(LOCAL_INSTALLATION(";
        if (distributionString.startsWith(localInstallationPrefix) && distributionString.endsWith("))")) {
            String configuration = distributionString.substring(localInstallationPrefix.length(), distributionString.length() - 2);
            return GradleDistribution.forLocalInstallation(new File(configuration));
        }
        String remoteDistributionPrefix = "GRADLE_DISTRIBUTION(REMOTE_DISTRIBUTION(";
        if (distributionString.startsWith(remoteDistributionPrefix) && distributionString.endsWith("))")) {
            String configuration = distributionString.substring(remoteDistributionPrefix.length(), distributionString.length() - 2);
            return GradleDistribution.forRemoteDistribution(GradleDistribution.createUrl(configuration));
        }
        String versionPrefix = "GRADLE_DISTRIBUTION(VERSION(";
        if (distributionString.startsWith(versionPrefix) && distributionString.endsWith("))")) {
            String configuration = distributionString.substring(versionPrefix.length(), distributionString.length() - 2);
            return GradleDistribution.forVersion(configuration);
        }
        String wrapperString = "GRADLE_DISTRIBUTION(WRAPPER)";
        if (distributionString.equals(wrapperString)) {
            return WRAPPER_DISTRIBUTION;
        }
        throw new IllegalArgumentException("Unrecognized Gradle distribution type: " + distributionString);
    }

    private static URI createUrl(String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    GradleDistribution() {
    }

    public abstract void apply(GradleConnector var1);

    public abstract String getDisplayName();
}

