/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.core.manipulation.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.core.manipulation.search.OccurrencesFinder;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corrections.InnovationContext;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;

public class PrepareRenameHandler {
    private PreferenceManager preferenceManager;

    public PrepareRenameHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    /*
     * WARNING - void declaration
     */
    public Range prepareRename(TextDocumentPositionParams params, IProgressMonitor monitor) {
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (unit != null) {
            try {
                IOccurrencesFinder.OccurrenceLocation[] occurrences;
                int offset;
                String error;
                OccurrencesFinder finder = new OccurrencesFinder();
                CompilationUnit ast = CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, monitor);
                if (ast != null && (error = finder.initialize(ast, offset = JsonRpcHelpers.toOffset(unit.getBuffer(), params.getPosition().getLine(), params.getPosition().getCharacter()), 0)) == null && (occurrences = finder.getOccurrences()) != null) {
                    IOccurrencesFinder.OccurrenceLocation[] occurrenceLocationArray = occurrences;
                    int n = occurrences.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IOccurrencesFinder.OccurrenceLocation loc = occurrenceLocationArray[n2];
                        if (monitor.isCanceled()) {
                            return new Range();
                        }
                        if (loc.getOffset() <= offset && loc.getOffset() + loc.getLength() >= offset) {
                            IJavaElement element;
                            IJavaElement iJavaElement;
                            IJavaElement[] elements = JDTUtils.findElementsAtSelection((ITypeRoot)unit, params.getPosition().getLine(), params.getPosition().getCharacter(), this.preferenceManager, monitor);
                            if (elements.length == 1 && (iJavaElement = (element = elements[0])) instanceof IMethod) {
                                void method;
                                IMethod cfr_ignored_0 = (IMethod)iJavaElement;
                                IMethod cfr_ignored_1 = (IMethod)iJavaElement;
                                if (JDTUtils.isGenerated((IMember)method)) {
                                    throw new ResponseErrorException(new ResponseError(ResponseErrorCode.InvalidRequest, "Renaming this element is not supported.", null));
                                }
                            }
                            InnovationContext context = new InnovationContext(unit, loc.getOffset(), loc.getLength());
                            context.setASTRoot(ast);
                            ASTNode node = context.getCoveredNode();
                            if (!this.isBinaryOrPackage(node)) {
                                return JDTUtils.toRange((IOpenable)unit, loc.getOffset(), loc.getLength());
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Problem computing occurrences for" + unit.getElementName() + " in prepareRename", e);
            }
        }
        throw new ResponseErrorException(new ResponseError(ResponseErrorCode.InvalidRequest, "Renaming this element is not supported.", null));
    }

    /*
     * WARNING - void declaration
     */
    private boolean isBinaryOrPackage(ASTNode node) {
        ASTNode aSTNode = node;
        if (aSTNode instanceof Name) {
            void name;
            Name name2 = (Name)aSTNode;
            Name cfr_ignored_0 = (Name)aSTNode;
            IBinding resolvedBinding = name.resolveBinding();
            IJavaElement element = resolvedBinding != null ? resolvedBinding.getJavaElement() : null;
            try {
                if (element == null || element.getElementType() == 4 || !RefactoringAvailabilityTesterCore.isRenameElementAvailable((IJavaElement)element)) {
                    return true;
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
                return true;
            }
        }
        return false;
    }
}

