/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.ImplementationCollector;
import org.eclipse.jdt.ls.core.internal.handlers.ImplementationToLocationMapper;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.handlers.NavigateToDefinitionHandler;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class ImplementationsHandler {
    private PreferenceManager preferenceManager;

    public ImplementationsHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<? extends Location> findImplementations(TextDocumentPositionParams param, IProgressMonitor monitor) {
        Region region;
        ITypeRoot typeRoot;
        IJavaElement elementToSearch;
        List<Location> locations;
        block7: {
            locations = null;
            elementToSearch = null;
            typeRoot = null;
            region = null;
            boolean returnCompilationUnit = this.preferenceManager == null ? false : this.preferenceManager.isClientSupportsClassFileContent() && this.preferenceManager.getPreferences().isIncludeDecompiledSources();
            typeRoot = JDTUtils.resolveTypeRoot(param.getTextDocument().getUri(), returnCompilationUnit, monitor);
            if (typeRoot != null) {
                elementToSearch = JDTUtils.findElementAtSelection(typeRoot, param.getPosition().getLine(), param.getPosition().getCharacter(), this.preferenceManager, monitor);
            }
            if (elementToSearch instanceof IType || elementToSearch instanceof IMethod) break block7;
            List list = Collections.emptyList();
            JDTUtils.discardClassFileWorkingCopy(typeRoot);
            return list;
        }
        try {
            try {
                Location definition;
                int offset = this.getOffset(param, typeRoot);
                region = new Region(offset, 0);
                IType primaryType = typeRoot.findPrimaryType();
                boolean useDefaultLocation = primaryType == null ? false : "java.lang.Object".equals(primaryType.getFullyQualifiedName());
                ImplementationToLocationMapper mapper = new ImplementationToLocationMapper(this.preferenceManager.isClientSupportsClassFileContent(), useDefaultLocation);
                ImplementationCollector<Location> collector = new ImplementationCollector<Location>(typeRoot, (IRegion)region, elementToSearch, mapper);
                locations = collector.findImplementations(monitor);
                if (this.shouldIncludeDefinition(typeRoot, (IRegion)region, elementToSearch, locations) && (definition = NavigateToDefinitionHandler.computeDefinitionNavigation(elementToSearch, typeRoot.getJavaProject())) != null) {
                    locations = locations == null ? new ArrayList<Location>() : new ArrayList<Location>(locations);
                    locations.add(0, definition);
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Problem computing definition for" + typeRoot.getElementName(), e);
                List list = Collections.emptyList();
                JDTUtils.discardClassFileWorkingCopy(typeRoot);
                return list;
            }
        }
        catch (Throwable throwable) {
            JDTUtils.discardClassFileWorkingCopy(typeRoot);
            throw throwable;
        }
        JDTUtils.discardClassFileWorkingCopy(typeRoot);
        return locations;
    }

    private int getOffset(TextDocumentPositionParams param, ITypeRoot typeRoot) {
        int offset = 0;
        try {
            IDocument document = JsonRpcHelpers.toDocument(typeRoot.getBuffer());
            offset = document.getLineOffset(param.getPosition().getLine()) + param.getPosition().getCharacter();
        }
        catch (JavaModelException | BadLocationException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        return offset;
    }

    private boolean shouldIncludeDefinition(ITypeRoot typeRoot, IRegion region, IJavaElement elementToSearch, List<Location> implementations) {
        boolean isUnimplemented = false;
        try {
            isUnimplemented = this.isUnimplementedMember(elementToSearch);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (isUnimplemented && implementations != null && !implementations.isEmpty()) {
            return false;
        }
        CompilationUnit ast = CoreASTProvider.getInstance().getAST(typeRoot, CoreASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
        if (ast == null) {
            return false;
        }
        ASTNode node = NodeFinder.perform((ASTNode)ast, (int)region.getOffset(), (int)region.getLength());
        return node instanceof SimpleName && !(node.getParent() instanceof MethodDeclaration) && !(node.getParent() instanceof SuperMethodInvocation) && !(node.getParent() instanceof AbstractTypeDeclaration);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isUnimplementedMember(IJavaElement element) throws JavaModelException {
        IJavaElement iJavaElement = element;
        if (iJavaElement instanceof IMethod) {
            void method;
            IMethod iMethod = (IMethod)iJavaElement;
            IMethod cfr_ignored_0 = (IMethod)iJavaElement;
            return this.isUnimplementedMethod((IMethod)method);
        }
        IJavaElement iJavaElement2 = element;
        if (iJavaElement2 instanceof IType) {
            void type;
            IType iType = (IType)iJavaElement2;
            IType cfr_ignored_1 = (IType)iJavaElement2;
            return this.isUnimplementedType((IType)type);
        }
        return false;
    }

    private boolean isUnimplementedMethod(IMethod method) throws JavaModelException {
        return JdtFlags.isAbstract((IMember)method) || method.getDeclaringType() != null && method.getDeclaringType().isInterface();
    }

    private boolean isUnimplementedType(IType type) throws JavaModelException {
        return JdtFlags.isAbstract((IMember)type) || type.isInterface();
    }
}

