/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.commands;

import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.commands.ProjectClasspathEntry;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;

public class ProjectCommand {
    public static final String NATURE_IDS = "org.eclipse.jdt.ls.core.natureIds";
    public static final String VM_LOCATION = "org.eclipse.jdt.ls.core.vm.location";
    public static final String SOURCE_PATHS = "org.eclipse.jdt.ls.core.sourcePaths";
    public static final String OUTPUT_PATH = "org.eclipse.jdt.ls.core.outputPath";
    public static final String CLASSPATH_ENTRIES = "org.eclipse.jdt.ls.core.classpathEntries";
    public static final String REFERENCED_LIBRARIES = "org.eclipse.jdt.ls.core.referencedLibraries";
    private static final String TEST_SCOPE_VALUE = "test";

    /*
     * Unable to fully structure code
     */
    public static Map<String, Object> getProjectSettings(String uri, List<String> settingKeys) throws CoreException, URISyntaxException {
        javaProject = ProjectCommand.getJavaProjectFromUri(uri);
        project = javaProject.getProject();
        settings = new HashMap<String, Object>();
        var6_5 = settingKeys.iterator();
        block16: while (var6_5.hasNext()) {
            var7_7 = key = var6_5.next();
            tmp = -1;
            switch (var7_7.hashCode()) {
                case -1935625856: {
                    if (var7_7.equals("org.eclipse.jdt.ls.core.classpathEntries")) {
                        tmp = 1;
                    }
                    break;
                }
                case -451838029: {
                    if (var7_7.equals("org.eclipse.jdt.ls.core.referencedLibraries")) {
                        tmp = 2;
                    }
                    break;
                }
                case -72255516: {
                    if (var7_7.equals("org.eclipse.jdt.ls.core.natureIds")) {
                        tmp = 3;
                    }
                    break;
                }
                case 26576851: {
                    if (var7_7.equals("org.eclipse.jdt.ls.core.outputPath")) {
                        tmp = 4;
                    }
                    break;
                }
                case 493224863: {
                    if (var7_7.equals("org.eclipse.jdt.ls.core.vm.location")) {
                        tmp = 5;
                    }
                    break;
                }
                case 1563657254: {
                    if (var7_7.equals("org.eclipse.jdt.ls.core.sourcePaths")) {
                        tmp = 6;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 3: {
                    settings.putIfAbsent(key, project.getDescription().getNatureIds());
                    break;
                }
                case 5: {
                    vmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
                    if (vmInstall == null || (location = vmInstall.getInstallLocation()) == null) continue block16;
                    settings.putIfAbsent(key, location.getAbsolutePath());
                    break;
                }
                case 6: {
                    sourcePaths = (String[])Arrays.stream(ProjectUtils.listSourcePaths(javaProject)).map((Function<IPath, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$0(org.eclipse.core.resources.IProject org.eclipse.core.runtime.IPath ), (Lorg/eclipse/core/runtime/IPath;)Ljava/lang/String;)((IProject)project)).toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$1(int ), (I)[Ljava/lang/String;)());
                    settings.putIfAbsent(key, sourcePaths);
                    break;
                }
                case 4: {
                    outputPath = javaProject.getOutputLocation();
                    if (outputPath == null) {
                        settings.putIfAbsent(key, "");
                        break;
                    }
                    settings.putIfAbsent(key, project.getFolder(outputPath.makeRelativeTo(project.getFullPath())).getLocation().toOSString());
                    break;
                }
                case 2: {
                    referencedLibraries = (String[])Arrays.stream(ProjectUtils.listReferencedLibraries(javaProject)).map((Function<IPath, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$2(org.eclipse.core.runtime.IPath ), (Lorg/eclipse/core/runtime/IPath;)Ljava/lang/String;)()).toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$1(int ), (I)[Ljava/lang/String;)());
                    settings.putIfAbsent(key, referencedLibraries);
                    break;
                }
                case 1: {
                    entriesToBeScan = new LinkedList<IClasspathEntry>();
                    Collections.addAll(entriesToBeScan, javaProject.getRawClasspath());
                    classpathEntries = new LinkedList<ProjectClasspathEntry>();
                    i = 0;
                    while (i < entriesToBeScan.size()) {
                        entry = (IClasspathEntry)entriesToBeScan.get(i);
                        path = entry.getPath();
                        output = entry.getOutputLocation();
                        entryKind = entry.getEntryKind();
                        if (entryKind != 3) ** GOTO lbl89
                        relativePath = path.makeRelativeTo(project.getFullPath());
                        if (relativePath.isEmpty()) ** GOTO lbl108
                        path = project.getFolder(path.makeRelativeTo(project.getFullPath())).getLocation();
                        if (output != null) {
                            output = project.getFolder(output.makeRelativeTo(project.getFullPath())).getLocation();
                        }
                        ** GOTO lbl96
lbl89:
                        // 1 sources

                        if (entryKind == 5) {
                            if (!path.toString().startsWith(JavaRuntime.JRE_CONTAINER)) {
                                entriesToBeScan.addAll(ProjectCommand.expandContainerEntry(javaProject, entry));
                            }
                        } else {
                            if (entryKind == 1 && !path.toFile().exists() && (filePath = project.getFile(path.makeRelativeTo(project.getFullPath())).getLocation()) != null && filePath.toFile().exists()) {
                                path = filePath;
                            }
lbl96:
                            // 4 sources

                            attributes = new HashMap<String, String>();
                            var24_24 = entry.getExtraAttributes();
                            var23_23 = var24_24.length;
                            var22_22 = 0;
                            while (var22_22 < var23_23) {
                                attribute = var24_24[var22_22];
                                attributes.put(attribute.getName(), attribute.getValue());
                                ++var22_22;
                            }
                            classpathEntries.add(new ProjectClasspathEntry(entryKind, path.toOSString(), output == null ? null : output.toOSString(), attributes));
                        }
lbl108:
                        // 3 sources

                        ++i;
                    }
                    settings.putIfAbsent(key, classpathEntries);
                    break;
                }
                default: {
                    settings.putIfAbsent(key, javaProject.getOption(key, true));
                }
            }
        }
        return settings;
    }

    public static void updateClasspaths(String uri, List<ProjectClasspathEntry> entries, IProgressMonitor monitor) throws CoreException, URISyntaxException {
        IJavaProject javaProject = ProjectCommand.getJavaProjectFromUri(uri);
        IProject project = javaProject.getProject();
        HashMap<IPath, IPath> sourceAndOutput = new HashMap<IPath, IPath>();
        LinkedList<IClasspathEntry> newEntries = new LinkedList<IClasspathEntry>();
        LinkedList<IClasspathEntry> newDependencyEntries = new LinkedList<IClasspathEntry>();
        for (ProjectClasspathEntry entry : entries) {
            if (entry.getKind() == 3) {
                IPath path = project.getFolder(entry.getPath()).getFullPath();
                IPath outputLocation = null;
                String output = entry.getOutput();
                if (output != null) {
                    outputLocation = ".".equals(output) ? project.getFullPath() : project.getFolder(output).getFullPath();
                }
                sourceAndOutput.put(path, outputLocation);
                continue;
            }
            if (entry.getKind() == 5) {
                if (entry.getPath().startsWith(JavaRuntime.JRE_CONTAINER)) {
                    String jdkPath = entry.getPath().substring(JavaRuntime.JRE_CONTAINER.length());
                    newEntries.add(ProjectCommand.getNewJdkEntry(javaProject, jdkPath));
                    continue;
                }
                JavaLanguageServerPlugin.logInfo("The container entry " + entry.getPath() + " is not supported to be updated.");
                continue;
            }
            newDependencyEntries.add(ProjectCommand.convertClasspathEntry(entry));
        }
        IClasspathEntry[] sources = ProjectUtils.resolveSourceClasspathEntries(javaProject, sourceAndOutput, Collections.emptyList(), javaProject.getOutputLocation());
        newEntries.addAll(Arrays.asList(sources));
        newEntries.addAll(ProjectCommand.resolveDependencyEntries(javaProject, newDependencyEntries));
        IClasspathEntry[] rawClasspath = (IClasspathEntry[])newEntries.toArray(IClasspathEntry[]::new);
        IJavaModelStatus checkStatus = ClasspathEntry.validateClasspath((IJavaProject)javaProject, (IClasspathEntry[])rawClasspath, (IPath)javaProject.getOutputLocation());
        if (!checkStatus.isOK()) {
            throw new CoreException((IStatus)checkStatus);
        }
        javaProject.setRawClasspath(rawClasspath, monitor);
    }

    private static List<IClasspathEntry> resolveDependencyEntries(IJavaProject javaProject, List<IClasspathEntry> newEntries) throws JavaModelException {
        LinkedList<IClasspathEntry> currentDependencyEntries = new LinkedList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() != 3 && !entry.getPath().toString().startsWith(JavaRuntime.JRE_CONTAINER)) {
                currentDependencyEntries.add(entry);
            }
            ++n2;
        }
        HashMap<IPath, IClasspathEntry> currentEntryMapping = new HashMap<IPath, IClasspathEntry>();
        for (IClasspathEntry entry : currentDependencyEntries) {
            if (entry.getEntryKind() == 5) {
                List<IClasspathEntry> expandedContainerEntry = ProjectCommand.expandContainerEntry(javaProject, entry);
                for (IClasspathEntry containerEntry : expandedContainerEntry) {
                    currentEntryMapping.put(containerEntry.getPath(), containerEntry);
                }
                continue;
            }
            currentEntryMapping.put(entry.getPath(), entry);
        }
        if (newEntries.size() != currentEntryMapping.size()) {
            return newEntries;
        }
        for (IClasspathEntry entry : newEntries) {
            IClasspathEntry currentEntry = (IClasspathEntry)currentEntryMapping.get(entry.getPath());
            if (currentEntry != null) continue;
            return newEntries;
        }
        return currentDependencyEntries;
    }

    private static List<IClasspathEntry> expandContainerEntry(IJavaProject javaProject, IClasspathEntry entry) throws JavaModelException {
        if (entry.getEntryKind() != 5) {
            return Collections.singletonList(entry);
        }
        LinkedList<IClasspathEntry> resolvedEntries = new LinkedList<IClasspathEntry>();
        LinkedList<IClasspathEntry> entriesToScan = new LinkedList<IClasspathEntry>();
        entriesToScan.add(entry);
        int i = 0;
        while (i < entriesToScan.size()) {
            IClasspathEntry currentEntry = (IClasspathEntry)entriesToScan.get(i);
            if (currentEntry.getEntryKind() != 5) {
                resolvedEntries.add(currentEntry);
            } else {
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)currentEntry.getPath(), (IJavaProject)javaProject);
                if (container != null) {
                    IClasspathEntry[] containerEntries;
                    IClasspathEntry[] iClasspathEntryArray = containerEntries = container.getClasspathEntries();
                    int n = containerEntries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry containerEntry = iClasspathEntryArray[n2];
                        if (containerEntry.getEntryKind() == 5) {
                            entriesToScan.add(containerEntry);
                        } else {
                            resolvedEntries.add(containerEntry);
                        }
                        ++n2;
                    }
                }
            }
            ++i;
        }
        return resolvedEntries;
    }

    private static IClasspathEntry convertClasspathEntry(ProjectClasspathEntry entry) {
        LinkedList<IClasspathAttribute> attributes = new LinkedList<IClasspathAttribute>();
        if (entry.getAttributes() != null) {
            for (Map.Entry<String, String> attributeEntry : entry.getAttributes().entrySet()) {
                attributes.add(JavaCore.newClasspathAttribute((String)attributeEntry.getKey(), (String)attributeEntry.getValue()));
            }
        }
        switch (entry.getKind()) {
            case 5: {
                return JavaCore.newContainerEntry((IPath)IPath.fromOSString((String)entry.getPath()), (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, (IClasspathAttribute[])((IClasspathAttribute[])attributes.toArray(IClasspathAttribute[]::new)), (boolean)false);
            }
            case 1: {
                return JavaCore.newLibraryEntry((IPath)IPath.fromOSString((String)entry.getPath()), null, null, (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, (IClasspathAttribute[])((IClasspathAttribute[])attributes.toArray(IClasspathAttribute[]::new)), (boolean)false);
            }
            case 2: {
                return JavaCore.newProjectEntry((IPath)IPath.fromOSString((String)entry.getPath()), (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, (boolean)false, (IClasspathAttribute[])((IClasspathAttribute[])attributes.toArray(IClasspathAttribute[]::new)), (boolean)false);
            }
        }
        return null;
    }

    public static void updateSourcePaths(String uri, Map<String, String> sourceAndOutput) throws CoreException, URISyntaxException {
        IJavaProject javaProject = ProjectCommand.getJavaProjectFromUri(uri);
        IProject project = javaProject.getProject();
        HashMap<IPath, IPath> sourceAndOutputWithFullPath = new HashMap<IPath, IPath>();
        for (Map.Entry<String, String> entry : sourceAndOutput.entrySet()) {
            IPath path = project.getFolder(entry.getKey()).getFullPath();
            IPath outputLocation = null;
            String output = entry.getValue();
            if (output != null) {
                outputLocation = ".".equals(output) ? project.getFullPath() : project.getFolder(output).getFullPath();
            }
            sourceAndOutputWithFullPath.put(path, outputLocation);
        }
        IClasspathEntry[] newEntries = ProjectUtils.resolveClassPathEntries(javaProject, sourceAndOutputWithFullPath, Collections.emptyList(), null);
        javaProject.setRawClasspath(newEntries, (IProgressMonitor)new NullProgressMonitor());
    }

    public static ClasspathResult getClasspaths(String uri, ClasspathOptions options) throws CoreException, URISyntaxException {
        return ProjectCommand.getClasspathsFromJavaProject(ProjectCommand.getJavaProjectFromUri(uri), options);
    }

    public static ClasspathResult getClasspathsFromJavaProject(IJavaProject javaProject, ClasspathOptions options) throws CoreException, URISyntaxException {
        Optional<IBuildSupport> bs = JavaLanguageServerPlugin.getProjectsManager().getBuildSupport(javaProject.getProject());
        if (!bs.isPresent()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "No BuildSupport for the project: " + javaProject.getElementName()));
        }
        ILaunchConfiguration launchConfig = bs.get().getLaunchConfiguration(javaProject, options.scope);
        JavaLaunchDelegate delegate = new JavaLaunchDelegate();
        ClasspathResult[] result = new ClasspathResult[1];
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ISchedulingRule currentRule = Job.getJobManager().currentRule();
        Object schedulingRule = currentRule != null && currentRule.contains(javaProject.getSchedulingRule()) ? null : javaProject.getSchedulingRule();
        workspace.run(monitor -> {
            String[][] paths = delegate.getClasspathAndModulepath(launchConfig);
            classpathResultArray[0] = new ClasspathResult(javaProject.getProject().getLocationURI(), paths[0], paths[1]);
        }, schedulingRule, 1, (IProgressMonitor)new NullProgressMonitor());
        if (result[0] != null) {
            return result[0];
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "Failed to get the classpaths."));
    }

    public static boolean isTestFile(String uri) throws CoreException {
        ICompilationUnit compilationUnit = JDTUtils.resolveCompilationUnit(uri);
        if (compilationUnit == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "Given URI does not belong to an existing Java source file."));
        }
        IJavaProject javaProject = compilationUnit.getJavaProject();
        if (javaProject == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "Given URI does not belong to an existing Java project."));
        }
        if ("jdt.ls-java-project".equals(javaProject.getProject().getName())) {
            return false;
        }
        IPath compilationUnitPath = compilationUnit.getPath();
        IPath[] iPathArray = ProjectCommand.listTestSourcePaths(javaProject);
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath testpath = iPathArray[n2];
            if (testpath.isPrefixOf(compilationUnitPath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static List<URI> getAllJavaProjects() {
        return ProjectCommand.getProjectUris((IProject[])Arrays.stream(ProjectUtils.getJavaProjects()).map(IJavaProject::getProject).toArray(IProject[]::new));
    }

    public static List<URI> getAllProjects() {
        return ProjectCommand.getProjectUris(ProjectUtils.getAllProjects());
    }

    private static List<URI> getProjectUris(IProject[] projects) {
        LinkedList<URI> projectUris = new LinkedList<URI>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            projectUris.add(ProjectUtils.getProjectRealFolder(project).toFile().toURI());
            ++n2;
        }
        return projectUris;
    }

    public static void importProject(IProgressMonitor monitor) {
        JavaLanguageServerPlugin.getProjectsManager().importProjects(monitor);
    }

    public static void changeImportedProjects(Collection<String> toUpdate, Collection<String> toImport, Collection<String> toDelete, IProgressMonitor monitor) {
        JavaLanguageServerPlugin.getProjectsManager().changeImportedProjects(toUpdate, toImport, toDelete, monitor);
    }

    private static IPath[] listTestSourcePaths(IJavaProject project) throws JavaModelException {
        ArrayList<IPath> result = new ArrayList<IPath>();
        IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (ProjectCommand.isTestClasspathEntry(entry)) {
                result.add(entry.getPath());
            }
            ++n2;
        }
        return result.toArray(new IPath[0]);
    }

    private static boolean isTestClasspathEntry(IClasspathEntry entry) {
        if (entry.getEntryKind() != 3) {
            return false;
        }
        if (entry.isTest()) {
            return true;
        }
        IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            String attributeName = attribute.getName();
            if (attributeName.contains("scope")) {
                return attribute.getValue() != null && attribute.getValue().toLowerCase().contains(TEST_SCOPE_VALUE);
            }
            ++n2;
        }
        return false;
    }

    public static IJavaProject getJavaProjectFromUri(String uri) throws CoreException, URISyntaxException {
        ITypeRoot typeRoot = JDTUtils.resolveTypeRoot(uri);
        if (typeRoot != null) {
            IJavaProject javaProject = typeRoot.getJavaProject();
            if (javaProject == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "Given URI does not belong to an existing Java project."));
            }
            return javaProject;
        }
        IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(new URI(uri));
        if (containers == null || containers.length == 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "Given URI does not belong to any Java project."));
        }
        Arrays.sort(containers, (a, b) -> a.getFullPath().segmentCount() - b.getFullPath().segmentCount());
        IJavaProject targetElement = null;
        IContainer[] iContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer container = iContainerArray[n2];
            targetElement = JavaCore.create((IProject)container.getProject());
            if (targetElement != null && targetElement.exists()) break;
            ++n2;
        }
        if (targetElement == null || targetElement.getJavaProject() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "Given URI does not belong to any Java project."));
        }
        return targetElement.getJavaProject();
    }

    public static SymbolInformation resolveWorkspaceSymbol(SymbolInformation request) {
        ITypeRoot unit = JDTUtils.resolveTypeRoot(request.getLocation().getUri());
        if (unit == null || !unit.exists()) {
            return null;
        }
        Location location = request.getLocation();
        try {
            ArrayDeque<IJavaElement> children = new ArrayDeque<IJavaElement>(Arrays.asList(unit.getChildren()));
            while (!children.isEmpty()) {
                IJavaElement child = (IJavaElement)children.pop();
                if (!(child instanceof IType)) continue;
                if (request.getName().equals(child.getElementName())) {
                    location = JDTUtils.toLocation(child);
                    break;
                }
                children.addAll(Arrays.asList(((IParent)child).getChildren()));
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logError("Problem resolving symbol information for " + unit.getElementName());
        }
        SymbolInformation si = new SymbolInformation();
        si.setName(request.getName());
        si.setContainerName(request.getContainerName());
        si.setLocation(location);
        si.setKind(request.getKind());
        return si;
    }

    public static JdkUpdateResult updateProjectJdk(String projectUri, String jdkPath, IProgressMonitor monitor) throws CoreException, URISyntaxException {
        IJavaProject javaProject = ProjectCommand.getJavaProjectFromUri(projectUri);
        ArrayList<IClasspathEntry> newClasspathEntries = new ArrayList<IClasspathEntry>();
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 5 && entry.getPath().toString().startsWith(JavaRuntime.JRE_CONTAINER)) {
                    newClasspathEntries.add(ProjectCommand.getNewJdkEntry(javaProject, jdkPath));
                } else {
                    newClasspathEntries.add(entry);
                }
                ++n2;
            }
            javaProject.setRawClasspath((IClasspathEntry[])newClasspathEntries.toArray(IClasspathEntry[]::new), monitor);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.log(e);
            return new JdkUpdateResult(false, e.getMessage());
        }
        return new JdkUpdateResult(true, jdkPath);
    }

    private static IClasspathEntry getNewJdkEntry(IJavaProject javaProject, String jdkPath) throws CoreException {
        IVMInstall vmInstall = ProjectCommand.getVmInstallByPath(jdkPath);
        ArrayList<IClasspathAttribute> extraAttributes = new ArrayList<IClasspathAttribute>();
        if (vmInstall == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", "The select JDK path is not valid."));
        }
        if (javaProject.getOwnModuleDescription() != null) {
            extraAttributes.add(JavaCore.newClasspathAttribute((String)"module", (String)"true"));
        }
        return JavaCore.newContainerEntry((IPath)JavaRuntime.newJREContainerPath((IVMInstall)vmInstall), (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, (IClasspathAttribute[])((IClasspathAttribute[])extraAttributes.toArray(IClasspathAttribute[]::new)), (boolean)false);
    }

    private static IVMInstall getVmInstallByPath(String path) {
        IVMInstall2 vm;
        IVMInstallType[] vmInstallTypes;
        java.nio.file.Path vmPath = new Path(path).toPath();
        IVMInstallType[] iVMInstallTypeArray = vmInstallTypes = JavaRuntime.getVMInstallTypes();
        int n = vmInstallTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstall[] vmInstalls;
            IVMInstallType vmInstallType = iVMInstallTypeArray[n2];
            IVMInstall[] iVMInstallArray = vmInstalls = vmInstallType.getVMInstalls();
            int n3 = vmInstalls.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall vmInstall = iVMInstallArray[n4];
                if (vmInstall.getInstallLocation().toPath().normalize().compareTo(vmPath) == 0) {
                    return vmInstall;
                }
                ++n4;
            }
            ++n2;
        }
        StandardVMType standardType = (StandardVMType)JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
        VMStandin vmStandin = new VMStandin((IVMInstallType)standardType, path);
        File jdkHomeFile = vmPath.toFile();
        vmStandin.setInstallLocation(jdkHomeFile);
        Object name = jdkHomeFile.getName();
        int i = 1;
        while (ProjectCommand.isDuplicateName((String)name)) {
            name = jdkHomeFile.getName() + "(" + i++ + ")";
        }
        vmStandin.setName((String)name);
        IVMInstall install = vmStandin.convertToRealVM();
        if (!(install instanceof IVMInstall2) || (vm = (IVMInstall2)install).getJavaVersion() == null) {
            standardType.disposeVMInstall(install.getId());
            return null;
        }
        return install;
    }

    private static boolean isDuplicateName(String name) {
        return Stream.of(JavaRuntime.getVMInstallTypes()).flatMap(vmType -> Arrays.stream(vmType.getVMInstalls())).map(IVMInstall::getName).anyMatch(name::equals);
    }

    private static /* synthetic */ String lambda$0(IProject iProject, IPath p) {
        return iProject.getFolder(p.makeRelativeTo(iProject.getFullPath())).getLocation().toOSString();
    }

    private static /* synthetic */ String[] lambda$1(int n) {
        return new String[n];
    }

    private static /* synthetic */ String lambda$2(IPath p) {
        return p.toOSString();
    }

    public static class ClasspathOptions {
        public String scope;
    }

    public static class ClasspathResult {
        public URI projectRoot;
        public String[] classpaths;
        public String[] modulepaths;

        public ClasspathResult(URI projectRoot, String[] classpaths, String[] modulepaths) {
            this.projectRoot = projectRoot;
            this.classpaths = classpaths;
            this.modulepaths = modulepaths;
        }
    }

    public static class GetAllProjectOptions {
        public boolean includeNonJava;
    }

    public static final class JdkUpdateResult {
        public boolean success;
        public String message;

        public JdkUpdateResult(boolean success, String message) {
            this.success = success;
            this.message = message;
        }
    }
}

