(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_notebook_lib_browser_service_notebook-model-resolver-service_js-no-a94865"],{

/***/ "../../node_modules/@theia/notebook/lib/browser/contributions/cell-operations.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/contributions/cell-operations.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.changeCellType = void 0;
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/notebook/lib/common/index.js");
/**
 * a collection of different reusable notbook cell operations
 */
function changeCellType(notebookModel, cell, type, language) {
    if (cell.cellKind === type) {
        return;
    }
    if (type === common_1.CellKind.Markup) {
        language = 'markdown';
    }
    else {
        language !== null && language !== void 0 ? language : (language = cell.language);
    }
    notebookModel.applyEdits([{
            editType: 1 /* CellEditType.Replace */,
            index: notebookModel.cells.indexOf(cell),
            count: 1,
            cells: [{
                    ...cell.getData(),
                    cellKind: type,
                    language
                }]
        }], true);
}
exports.changeCellType = changeCellType;


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-actions-contribution.js":
/*!*****************************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/contributions/notebook-actions-contribution.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookMenus = exports.NotebookActionsContribution = exports.CellChangeDirection = exports.NotebookCommands = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const notebook_service_1 = __webpack_require__(/*! ../service/notebook-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-service.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/notebook/lib/common/index.js");
const notebook_kernel_quick_pick_service_1 = __webpack_require__(/*! ../service/notebook-kernel-quick-pick-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-kernel-quick-pick-service.js");
const notebook_execution_service_1 = __webpack_require__(/*! ../service/notebook-execution-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-execution-service.js");
const notebook_editor_widget_service_1 = __webpack_require__(/*! ../service/notebook-editor-widget-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-editor-widget-service.js");
const notebook_context_keys_1 = __webpack_require__(/*! ./notebook-context-keys */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-context-keys.js");
const notebook_clipboard_service_1 = __webpack_require__(/*! ../service/notebook-clipboard-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-clipboard-service.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
var NotebookCommands;
(function (NotebookCommands) {
    NotebookCommands.ADD_NEW_CELL_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.add-new-cell',
        iconClass: (0, browser_1.codicon)('add')
    });
    NotebookCommands.ADD_NEW_MARKDOWN_CELL_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.add-new-markdown-cell',
        iconClass: (0, browser_1.codicon)('add'),
        tooltip: core_1.nls.localizeByDefault('Add Markdown Cell')
    });
    NotebookCommands.ADD_NEW_CODE_CELL_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.add-new-code-cell',
        iconClass: (0, browser_1.codicon)('add'),
        tooltip: core_1.nls.localizeByDefault('Add Code Cell')
    });
    NotebookCommands.SELECT_KERNEL_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.selectKernel',
        category: 'Notebook',
        iconClass: (0, browser_1.codicon)('server-environment')
    });
    NotebookCommands.EXECUTE_NOTEBOOK_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.execute',
        category: 'Notebook',
        iconClass: (0, browser_1.codicon)('run-all')
    });
    NotebookCommands.CLEAR_ALL_OUTPUTS_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.clear-all-outputs',
        category: 'Notebook',
        iconClass: (0, browser_1.codicon)('clear-all')
    });
    NotebookCommands.CHANGE_SELECTED_CELL = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.change-selected-cell',
        category: 'Notebook',
    });
    NotebookCommands.CUT_SELECTED_CELL = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.cell.cut',
        category: 'Notebook',
    });
    NotebookCommands.COPY_SELECTED_CELL = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.cell.copy',
        category: 'Notebook',
    });
    NotebookCommands.PASTE_CELL = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.cell.paste',
        category: 'Notebook',
    });
    NotebookCommands.NOTEBOOK_FIND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.find',
        category: 'Notebook',
    });
    NotebookCommands.CENTER_ACTIVE_CELL = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.centerActiveCell',
        category: 'Notebook',
    });
})(NotebookCommands || (exports.NotebookCommands = NotebookCommands = {}));
var CellChangeDirection;
(function (CellChangeDirection) {
    CellChangeDirection["Up"] = "up";
    CellChangeDirection["Down"] = "down";
})(CellChangeDirection || (exports.CellChangeDirection = CellChangeDirection = {}));
let NotebookActionsContribution = class NotebookActionsContribution {
    registerCommands(commands) {
        commands.registerCommand(NotebookCommands.ADD_NEW_CELL_COMMAND, {
            execute: (notebookModel, cellKind = common_1.CellKind.Markup, index, focusContainer) => {
                var _a, _b;
                notebookModel = notebookModel !== null && notebookModel !== void 0 ? notebookModel : (_a = this.notebookEditorWidgetService.focusedEditor) === null || _a === void 0 ? void 0 : _a.model;
                let insertIndex = 0;
                if (typeof index === 'number' && index >= 0) {
                    insertIndex = index;
                }
                else if (notebookModel.selectedCell && typeof index === 'string') {
                    // if index is -1 insert below otherwise at the index of the selected cell which is above the selected.
                    insertIndex = notebookModel.cells.indexOf(notebookModel.selectedCell) + (index === 'below' ? 1 : 0);
                }
                let cellLanguage = 'markdown';
                if (cellKind === common_1.CellKind.Code) {
                    cellLanguage = this.notebookService.getCodeCellLanguage(notebookModel);
                }
                notebookModel.applyEdits([{
                        editType: 1 /* CellEditType.Replace */,
                        index: insertIndex,
                        count: 0,
                        cells: [{
                                cellKind,
                                language: cellLanguage,
                                source: '',
                                outputs: [],
                                metadata: {},
                            }]
                    }], true);
                if (focusContainer) {
                    (_b = notebookModel.selectedCell) === null || _b === void 0 ? void 0 : _b.requestBlurEditor();
                }
            }
        });
        commands.registerCommand(NotebookCommands.ADD_NEW_MARKDOWN_CELL_COMMAND, this.editableCommandHandler(notebookModel => commands.executeCommand(NotebookCommands.ADD_NEW_CELL_COMMAND.id, notebookModel, common_1.CellKind.Markup, 'below')));
        commands.registerCommand(NotebookCommands.ADD_NEW_CODE_CELL_COMMAND, this.editableCommandHandler(notebookModel => commands.executeCommand(NotebookCommands.ADD_NEW_CELL_COMMAND.id, notebookModel, common_1.CellKind.Code, 'below')));
        commands.registerCommand(NotebookCommands.SELECT_KERNEL_COMMAND, this.editableCommandHandler(notebookModel => this.notebookKernelQuickPickService.showQuickPick(notebookModel)));
        commands.registerCommand(NotebookCommands.EXECUTE_NOTEBOOK_COMMAND, this.editableCommandHandler(notebookModel => this.notebookExecutionService.executeNotebookCells(notebookModel, notebookModel.cells)));
        commands.registerCommand(NotebookCommands.CLEAR_ALL_OUTPUTS_COMMAND, this.editableCommandHandler(notebookModel => notebookModel.applyEdits(notebookModel.cells.map(cell => ({
            editType: 2 /* CellEditType.Output */,
            handle: cell.handle, deleteCount: cell.outputs.length, outputs: []
        })), false)));
        commands.registerCommand(NotebookCommands.CHANGE_SELECTED_CELL, {
            execute: (change) => {
                var _a, _b, _c, _d, _e, _f;
                const focusedEditor = this.notebookEditorWidgetService.focusedEditor;
                const model = focusedEditor === null || focusedEditor === void 0 ? void 0 : focusedEditor.model;
                if (model && typeof change === 'number') {
                    model.setSelectedCell(model.cells[change]);
                }
                else if (model && model.selectedCell) {
                    const currentIndex = model.cells.indexOf(model.selectedCell);
                    const shouldFocusEditor = this.contextKeyService.match('editorTextFocus');
                    if (change === CellChangeDirection.Up && currentIndex > 0) {
                        model.setSelectedCell(model.cells[currentIndex - 1]);
                        if ((((_a = model.selectedCell) === null || _a === void 0 ? void 0 : _a.cellKind) === common_1.CellKind.Code
                            || (((_b = model.selectedCell) === null || _b === void 0 ? void 0 : _b.cellKind) === common_1.CellKind.Markup && ((_c = model.selectedCell) === null || _c === void 0 ? void 0 : _c.editing))) && shouldFocusEditor) {
                            model.selectedCell.requestFocusEditor('lastLine');
                        }
                    }
                    else if (change === CellChangeDirection.Down && currentIndex < model.cells.length - 1) {
                        model.setSelectedCell(model.cells[currentIndex + 1]);
                        if ((((_d = model.selectedCell) === null || _d === void 0 ? void 0 : _d.cellKind) === common_1.CellKind.Code
                            || (((_e = model.selectedCell) === null || _e === void 0 ? void 0 : _e.cellKind) === common_1.CellKind.Markup && ((_f = model.selectedCell) === null || _f === void 0 ? void 0 : _f.editing))) && shouldFocusEditor) {
                            model.selectedCell.requestFocusEditor();
                        }
                    }
                    if (model.selectedCell.cellKind === common_1.CellKind.Markup) {
                        // since were losing focus from the cell editor, we need to focus the notebook editor again
                        focusedEditor === null || focusedEditor === void 0 ? void 0 : focusedEditor.node.focus();
                    }
                }
            }
        });
        commands.registerCommand({ id: 'list.focusUp' }, {
            execute: () => commands.executeCommand(NotebookCommands.CHANGE_SELECTED_CELL.id, CellChangeDirection.Up)
        });
        commands.registerCommand({ id: 'list.focusDown' }, {
            execute: () => commands.executeCommand(NotebookCommands.CHANGE_SELECTED_CELL.id, CellChangeDirection.Down)
        });
        commands.registerCommand(NotebookCommands.CUT_SELECTED_CELL, this.editableCommandHandler(() => {
            var _a;
            const model = (_a = this.notebookEditorWidgetService.focusedEditor) === null || _a === void 0 ? void 0 : _a.model;
            const selectedCell = model === null || model === void 0 ? void 0 : model.selectedCell;
            if (selectedCell) {
                model.applyEdits([{ editType: 1 /* CellEditType.Replace */, index: model.cells.indexOf(selectedCell), count: 1, cells: [] }], true);
                this.notebookClipboardService.copyCell(selectedCell);
            }
        }));
        commands.registerCommand(NotebookCommands.COPY_SELECTED_CELL, {
            execute: () => {
                var _a;
                const model = (_a = this.notebookEditorWidgetService.focusedEditor) === null || _a === void 0 ? void 0 : _a.model;
                const selectedCell = model === null || model === void 0 ? void 0 : model.selectedCell;
                if (selectedCell) {
                    this.notebookClipboardService.copyCell(selectedCell);
                }
            }
        });
        commands.registerCommand(NotebookCommands.PASTE_CELL, {
            isEnabled: () => { var _a, _b; return !Boolean((_b = (_a = this.notebookEditorWidgetService.focusedEditor) === null || _a === void 0 ? void 0 : _a.model) === null || _b === void 0 ? void 0 : _b.readOnly); },
            isVisible: () => { var _a, _b; return !Boolean((_b = (_a = this.notebookEditorWidgetService.focusedEditor) === null || _a === void 0 ? void 0 : _a.model) === null || _b === void 0 ? void 0 : _b.readOnly); },
            execute: (position) => {
                var _a;
                const copiedCell = this.notebookClipboardService.getCell();
                if (copiedCell) {
                    const model = (_a = this.notebookEditorWidgetService.focusedEditor) === null || _a === void 0 ? void 0 : _a.model;
                    const insertIndex = (model === null || model === void 0 ? void 0 : model.selectedCell) ? model.cells.indexOf(model.selectedCell) + (position === 'above' ? 0 : 1) : 0;
                    model === null || model === void 0 ? void 0 : model.applyEdits([{ editType: 1 /* CellEditType.Replace */, index: insertIndex, count: 0, cells: [copiedCell] }], true);
                }
            }
        });
        commands.registerCommand(NotebookCommands.NOTEBOOK_FIND, {
            execute: () => {
                var _a;
                (_a = this.notebookEditorWidgetService.focusedEditor) === null || _a === void 0 ? void 0 : _a.showFindWidget();
            }
        });
        commands.registerCommand(NotebookCommands.CENTER_ACTIVE_CELL, {
            execute: (editor) => {
                var _a, _b;
                const model = editor ? editor.model : (_a = this.notebookEditorWidgetService.focusedEditor) === null || _a === void 0 ? void 0 : _a.model;
                (_b = model === null || model === void 0 ? void 0 : model.selectedCell) === null || _b === void 0 ? void 0 : _b.requestCenterEditor();
            }
        });
    }
    editableCommandHandler(execute) {
        return {
            isEnabled: (item) => this.withModel(item, model => !Boolean(model === null || model === void 0 ? void 0 : model.readOnly), false),
            isVisible: (item) => this.withModel(item, model => !Boolean(model === null || model === void 0 ? void 0 : model.readOnly), false),
            execute: (uri) => {
                this.withModel(uri, execute, undefined);
            }
        };
    }
    withModel(item, execute, defaultValue) {
        if (item instanceof core_1.URI) {
            const model = this.notebookService.getNotebookEditorModel(item);
            if (!model) {
                return defaultValue;
            }
            item = model;
        }
        return execute(item);
    }
    registerMenus(menus) {
        // independent submenu for plugins to add commands
        menus.registerIndependentSubmenu(NotebookMenus.NOTEBOOK_MAIN_TOOLBAR, 'Notebook Main Toolbar');
        // Add Notebook Cell items
        menus.registerSubmenu(NotebookMenus.NOTEBOOK_MAIN_TOOLBAR_CELL_ADD_GROUP, 'Add Notebook Cell', { role: 1 /* CompoundMenuNodeRole.Group */ });
        menus.registerMenuAction(NotebookMenus.NOTEBOOK_MAIN_TOOLBAR_CELL_ADD_GROUP, {
            commandId: NotebookCommands.ADD_NEW_CODE_CELL_COMMAND.id,
            label: core_1.nls.localizeByDefault('Code'),
            icon: (0, browser_1.codicon)('add'),
        });
        menus.registerMenuAction(NotebookMenus.NOTEBOOK_MAIN_TOOLBAR_CELL_ADD_GROUP, {
            commandId: NotebookCommands.ADD_NEW_MARKDOWN_CELL_COMMAND.id,
            label: core_1.nls.localizeByDefault('Markdown'),
            icon: (0, browser_1.codicon)('add'),
        });
        // Execution related items
        menus.registerSubmenu(NotebookMenus.NOTEBOOK_MAIN_TOOLBAR_EXECUTION_GROUP, 'Cell Execution', { role: 1 /* CompoundMenuNodeRole.Group */ });
        menus.registerMenuAction(NotebookMenus.NOTEBOOK_MAIN_TOOLBAR_EXECUTION_GROUP, {
            commandId: NotebookCommands.EXECUTE_NOTEBOOK_COMMAND.id,
            label: core_1.nls.localizeByDefault('Run All'),
            icon: (0, browser_1.codicon)('run-all'),
            order: '10'
        });
        menus.registerMenuAction(NotebookMenus.NOTEBOOK_MAIN_TOOLBAR_EXECUTION_GROUP, {
            commandId: NotebookCommands.CLEAR_ALL_OUTPUTS_COMMAND.id,
            label: core_1.nls.localizeByDefault('Clear All Outputs'),
            icon: (0, browser_1.codicon)('clear-all'),
            order: '30',
            when: notebook_context_keys_1.NOTEBOOK_HAS_OUTPUTS
        });
        menus.registerIndependentSubmenu(NotebookMenus.NOTEBOOK_MAIN_TOOLBAR_HIDDEN_ITEMS_CONTEXT_MENU, '');
    }
    registerKeybindings(keybindings) {
        keybindings.registerKeybindings({
            command: NotebookCommands.CHANGE_SELECTED_CELL.id,
            keybinding: 'up',
            args: CellChangeDirection.Up,
            when: `(!editorTextFocus || ${notebook_context_keys_1.NOTEBOOK_CELL_CURSOR_FIRST_LINE}) && !suggestWidgetVisible && ${notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_CELL_FOCUSED}`
        }, {
            command: NotebookCommands.CHANGE_SELECTED_CELL.id,
            keybinding: 'down',
            args: CellChangeDirection.Down,
            when: `(!editorTextFocus || ${notebook_context_keys_1.NOTEBOOK_CELL_CURSOR_LAST_LINE}) && !suggestWidgetVisible && ${notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_CELL_FOCUSED}`
        }, {
            command: NotebookCommands.CUT_SELECTED_CELL.id,
            keybinding: 'ctrlcmd+x',
            when: `${notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED} && !inputFocus && !${notebook_context_keys_1.NOTEBOOK_OUTPUT_FOCUSED}`
        }, {
            command: NotebookCommands.COPY_SELECTED_CELL.id,
            keybinding: 'ctrlcmd+c',
            when: `${notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED} && !inputFocus && !${notebook_context_keys_1.NOTEBOOK_OUTPUT_FOCUSED}`
        }, {
            command: NotebookCommands.PASTE_CELL.id,
            keybinding: 'ctrlcmd+v',
            when: `${notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED} && !inputFocus && !${notebook_context_keys_1.NOTEBOOK_OUTPUT_FOCUSED}`
        }, {
            command: NotebookCommands.NOTEBOOK_FIND.id,
            keybinding: 'ctrlcmd+f',
            when: `${notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED}`
        }, {
            command: NotebookCommands.CENTER_ACTIVE_CELL.id,
            keybinding: 'ctrlcmd+l',
            when: `${notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED}`
        });
    }
};
exports.NotebookActionsContribution = NotebookActionsContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_service_1.NotebookService),
    tslib_1.__metadata("design:type", notebook_service_1.NotebookService)
], NotebookActionsContribution.prototype, "notebookService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_kernel_quick_pick_service_1.NotebookKernelQuickPickService),
    tslib_1.__metadata("design:type", notebook_kernel_quick_pick_service_1.NotebookKernelQuickPickService)
], NotebookActionsContribution.prototype, "notebookKernelQuickPickService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_execution_service_1.NotebookExecutionService),
    tslib_1.__metadata("design:type", notebook_execution_service_1.NotebookExecutionService)
], NotebookActionsContribution.prototype, "notebookExecutionService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ApplicationShell),
    tslib_1.__metadata("design:type", browser_1.ApplicationShell)
], NotebookActionsContribution.prototype, "shell", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_editor_widget_service_1.NotebookEditorWidgetService),
    tslib_1.__metadata("design:type", notebook_editor_widget_service_1.NotebookEditorWidgetService)
], NotebookActionsContribution.prototype, "notebookEditorWidgetService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_clipboard_service_1.NotebookClipboardService),
    tslib_1.__metadata("design:type", notebook_clipboard_service_1.NotebookClipboardService)
], NotebookActionsContribution.prototype, "notebookClipboardService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    tslib_1.__metadata("design:type", Object)
], NotebookActionsContribution.prototype, "contextKeyService", void 0);
exports.NotebookActionsContribution = NotebookActionsContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookActionsContribution);
var NotebookMenus;
(function (NotebookMenus) {
    NotebookMenus.NOTEBOOK_MAIN_TOOLBAR = 'notebook/toolbar';
    NotebookMenus.NOTEBOOK_MAIN_TOOLBAR_CELL_ADD_GROUP = [NotebookMenus.NOTEBOOK_MAIN_TOOLBAR, 'cell-add-group'];
    NotebookMenus.NOTEBOOK_MAIN_TOOLBAR_EXECUTION_GROUP = [NotebookMenus.NOTEBOOK_MAIN_TOOLBAR, 'cell-execution-group'];
    NotebookMenus.NOTEBOOK_MAIN_TOOLBAR_HIDDEN_ITEMS_CONTEXT_MENU = 'notebook-main-toolbar-hidden-items-context-menu';
})(NotebookMenus || (exports.NotebookMenus = NotebookMenus = {}));


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-cell-actions-contribution.js":
/*!**********************************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/contributions/notebook-cell-actions-contribution.js ***!
  \**********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var NotebookCellActionContribution_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookCellActionContribution = exports.NotebookCellCommands = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const notebook_context_keys_1 = __webpack_require__(/*! ./notebook-context-keys */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-context-keys.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
const notebook_execution_service_1 = __webpack_require__(/*! ../service/notebook-execution-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-execution-service.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/notebook/lib/common/index.js");
const notebook_editor_widget_service_1 = __webpack_require__(/*! ../service/notebook-editor-widget-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-editor-widget-service.js");
const notebook_actions_contribution_1 = __webpack_require__(/*! ./notebook-actions-contribution */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-actions-contribution.js");
const cell_operations_1 = __webpack_require__(/*! ./cell-operations */ "../../node_modules/@theia/notebook/lib/browser/contributions/cell-operations.js");
const editor_language_quick_pick_service_1 = __webpack_require__(/*! @theia/editor/lib/browser/editor-language-quick-pick-service */ "../../node_modules/@theia/editor/lib/browser/editor-language-quick-pick-service.js");
const notebook_service_1 = __webpack_require__(/*! ../service/notebook-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-service.js");
const selection_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/common/core/selection */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/common/core/selection.js");
const notebook_editor_widget_1 = __webpack_require__(/*! ../notebook-editor-widget */ "../../node_modules/@theia/notebook/lib/browser/notebook-editor-widget.js");
var NotebookCellCommands;
(function (NotebookCellCommands) {
    /** Parameters: notebookModel: NotebookModel | undefined, cell: NotebookCellModel */
    NotebookCellCommands.EDIT_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.cell.edit',
        category: 'Notebook',
        iconClass: (0, browser_1.codicon)('edit')
    });
    /** Parameters: notebookModel: NotebookModel | undefined, cell: NotebookCellModel */
    NotebookCellCommands.STOP_EDIT_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.cell.stop-edit',
        category: 'Notebook',
        iconClass: (0, browser_1.codicon)('check')
    });
    /** Parameters: notebookModel: NotebookModel, cell: NotebookCellModel */
    NotebookCellCommands.DELETE_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.cell.delete',
        iconClass: (0, browser_1.codicon)('trash')
    });
    /** Parameters: notebookModel: NotebookModel, cell: NotebookCellModel */
    NotebookCellCommands.SPLIT_CELL_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.cell.split',
        iconClass: (0, browser_1.codicon)('split-vertical'),
    });
    /** Parameters: notebookModel: NotebookModel, cell: NotebookCellModel */
    NotebookCellCommands.EXECUTE_SINGLE_CELL_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.cell.execute-cell',
        category: 'Notebook',
        label: 'Execute Cell',
        iconClass: (0, browser_1.codicon)('play'),
    });
    /** Parameters: notebookModel: NotebookModel, cell: NotebookCellModel */
    NotebookCellCommands.EXECUTE_SINGLE_CELL_AND_FOCUS_NEXT_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.cell.execute-cell-and-focus-next',
        label: 'Execute Notebook Cell and Select Below',
        category: 'Notebook',
    });
    /** Parameters: notebookModel: NotebookModel, cell: NotebookCellModel */
    NotebookCellCommands.EXECUTE_SINGLE_CELL_AND_INSERT_BELOW_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.cell.execute-cell-and-insert-below',
        label: 'Execute Notebook Cell and Insert Below',
        category: 'Notebook',
    });
    NotebookCellCommands.EXECUTE_ABOVE_CELLS_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebookActions.executeAbove',
        label: 'Execute Above Cells',
        iconClass: (0, browser_1.codicon)('run-above')
    });
    NotebookCellCommands.EXECUTE_CELL_AND_BELOW_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebookActions.executeBelow',
        label: 'Execute Cell and Below',
        iconClass: (0, browser_1.codicon)('run-below')
    });
    /** Parameters: notebookModel: NotebookModel, cell: NotebookCellModel */
    NotebookCellCommands.STOP_CELL_EXECUTION_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.cell.stop-cell-execution',
        iconClass: (0, browser_1.codicon)('stop'),
    });
    /** Parameters: notebookModel: NotebookModel | undefined, cell: NotebookCellModel */
    NotebookCellCommands.CLEAR_OUTPUTS_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.cell.clear-outputs',
        category: 'Notebook',
        label: 'Clear Cell Outputs',
    });
    /** Parameters: notebookModel: NotebookModel | undefined, cell: NotebookCellModel | undefined, output: NotebookCellOutputModel */
    NotebookCellCommands.CHANGE_OUTPUT_PRESENTATION_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.cell.change-presentation',
        category: 'Notebook',
        label: 'Change Presentation',
    });
    NotebookCellCommands.INSERT_NEW_CELL_ABOVE_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.cell.insertCodeCellAboveAndFocusContainer',
        label: 'Insert Code Cell Above and Focus Container'
    });
    NotebookCellCommands.INSERT_NEW_CELL_BELOW_COMMAND = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.cell.insertCodeCellBelowAndFocusContainer',
        label: 'Insert Code Cell Below and Focus Container'
    });
    NotebookCellCommands.INSERT_MARKDOWN_CELL_ABOVE_COMMAND = core_1.Command.toLocalizedCommand({
        id: 'notebook.cell.insertMarkdownCellAbove',
        label: 'Insert Markdown Cell Above'
    });
    NotebookCellCommands.INSERT_MARKDOWN_CELL_BELOW_COMMAND = core_1.Command.toLocalizedCommand({
        id: 'notebook.cell.insertMarkdownCellBelow',
        label: 'Insert Markdown Cell Below'
    });
    NotebookCellCommands.TO_CODE_CELL_COMMAND = core_1.Command.toLocalizedCommand({
        id: 'notebook.cell.changeToCode',
        category: 'Notebook',
        label: 'Change Cell to Code'
    });
    NotebookCellCommands.TO_MARKDOWN_CELL_COMMAND = core_1.Command.toLocalizedCommand({
        id: 'notebook.cell.changeToMarkdown',
        category: 'Notebook',
        label: 'Change Cell to Markdown'
    });
    NotebookCellCommands.TOGGLE_CELL_OUTPUT = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.cell.toggleOutputs',
        category: 'Notebook',
        label: 'Collapse Cell Output',
    });
    NotebookCellCommands.CHANGE_CELL_LANGUAGE = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.cell.changeLanguage',
        category: 'Notebook',
        label: 'Change Cell Language',
    });
    NotebookCellCommands.TOGGLE_LINE_NUMBERS = core_1.Command.toDefaultLocalizedCommand({
        id: 'notebook.cell.toggleLineNumbers',
        category: 'Notebook',
        label: 'Show Cell Line Numbers',
    });
})(NotebookCellCommands || (exports.NotebookCellCommands = NotebookCellCommands = {}));
let NotebookCellActionContribution = NotebookCellActionContribution_1 = class NotebookCellActionContribution {
    init() {
        notebook_context_keys_1.NotebookContextKeys.initNotebookContextKeys(this.contextKeyService);
    }
    registerMenus(menus) {
        menus.registerMenuAction(NotebookCellActionContribution_1.ACTION_MENU, {
            commandId: NotebookCellCommands.EDIT_COMMAND.id,
            icon: NotebookCellCommands.EDIT_COMMAND.iconClass,
            when: `${notebook_context_keys_1.NOTEBOOK_CELL_TYPE} == 'markdown' && !${notebook_context_keys_1.NOTEBOOK_CELL_MARKDOWN_EDIT_MODE}`,
            label: core_1.nls.localizeByDefault('Edit Cell'),
            order: '10'
        });
        menus.registerMenuAction(NotebookCellActionContribution_1.ACTION_MENU, {
            commandId: NotebookCellCommands.STOP_EDIT_COMMAND.id,
            icon: NotebookCellCommands.STOP_EDIT_COMMAND.iconClass,
            when: `${notebook_context_keys_1.NOTEBOOK_CELL_TYPE} == 'markdown' && ${notebook_context_keys_1.NOTEBOOK_CELL_MARKDOWN_EDIT_MODE}`,
            label: core_1.nls.localizeByDefault('Stop Editing Cell'),
            order: '10'
        });
        menus.registerMenuAction(NotebookCellActionContribution_1.ACTION_MENU, {
            commandId: NotebookCellCommands.EXECUTE_ABOVE_CELLS_COMMAND.id,
            icon: NotebookCellCommands.EXECUTE_ABOVE_CELLS_COMMAND.iconClass,
            when: `${notebook_context_keys_1.NOTEBOOK_CELL_TYPE} == 'code'`,
            label: core_1.nls.localizeByDefault('Execute Above Cells'),
            order: '10'
        });
        menus.registerMenuAction(NotebookCellActionContribution_1.ACTION_MENU, {
            commandId: NotebookCellCommands.EXECUTE_CELL_AND_BELOW_COMMAND.id,
            icon: NotebookCellCommands.EXECUTE_CELL_AND_BELOW_COMMAND.iconClass,
            when: `${notebook_context_keys_1.NOTEBOOK_CELL_TYPE} == 'code'`,
            label: core_1.nls.localizeByDefault('Execute Cell and Below'),
            order: '20'
        });
        menus.registerMenuAction(NotebookCellActionContribution_1.ACTION_MENU, {
            commandId: NotebookCellCommands.SPLIT_CELL_COMMAND.id,
            icon: NotebookCellCommands.SPLIT_CELL_COMMAND.iconClass,
            label: core_1.nls.localizeByDefault('Split Cell'),
            order: '20'
        });
        menus.registerMenuAction(NotebookCellActionContribution_1.ACTION_MENU, {
            commandId: NotebookCellCommands.DELETE_COMMAND.id,
            icon: NotebookCellCommands.DELETE_COMMAND.iconClass,
            label: core_1.nls.localizeByDefault('Delete Cell'),
            order: '999'
        });
        menus.registerSubmenu(NotebookCellActionContribution_1.ADDITIONAL_ACTION_MENU, core_1.nls.localizeByDefault('More'), {
            icon: (0, browser_1.codicon)('ellipsis'),
            role: 0 /* CompoundMenuNodeRole.Submenu */,
            order: '30'
        });
        menus.registerIndependentSubmenu(NotebookCellActionContribution_1.CONTRIBUTED_CELL_ACTION_MENU, '', { role: 2 /* CompoundMenuNodeRole.Flat */ });
        // since contributions are adding to an independent submenu we have to manually add it to the more submenu
        menus.getMenu(NotebookCellActionContribution_1.ADDITIONAL_ACTION_MENU).addNode(menus.getMenuNode(NotebookCellActionContribution_1.CONTRIBUTED_CELL_ACTION_MENU));
        // code cell sidebar menu
        menus.registerMenuAction(NotebookCellActionContribution_1.CODE_CELL_SIDEBAR_MENU, {
            commandId: NotebookCellCommands.EXECUTE_SINGLE_CELL_COMMAND.id,
            icon: NotebookCellCommands.EXECUTE_SINGLE_CELL_COMMAND.iconClass,
            label: core_1.nls.localizeByDefault('Execute Cell'),
            when: `!${notebook_context_keys_1.NOTEBOOK_CELL_EXECUTING}`
        });
        menus.registerMenuAction(NotebookCellActionContribution_1.CODE_CELL_SIDEBAR_MENU, {
            commandId: NotebookCellCommands.STOP_CELL_EXECUTION_COMMAND.id,
            icon: NotebookCellCommands.STOP_CELL_EXECUTION_COMMAND.iconClass,
            label: core_1.nls.localizeByDefault('Stop Cell Execution'),
            when: notebook_context_keys_1.NOTEBOOK_CELL_EXECUTING
        });
        // Notebook Cell extra execution options
        menus.registerIndependentSubmenu(NotebookCellActionContribution_1.CONTRIBUTED_CELL_EXECUTION_MENU, core_1.nls.localizeByDefault('More...'), { role: 2 /* CompoundMenuNodeRole.Flat */, icon: (0, browser_1.codicon)('chevron-down') });
        // menus.getMenu(NotebookCellActionContribution.CODE_CELL_SIDEBAR_MENU).addNode(menus.getMenuNode(NotebookCellActionContribution.CONTRIBUTED_CELL_EXECUTION_MENU));
        // code cell output sidebar menu
        menus.registerSubmenu(NotebookCellActionContribution_1.ADDITIONAL_OUTPUT_SIDEBAR_MENU, core_1.nls.localizeByDefault('More'), {
            icon: (0, browser_1.codicon)('ellipsis'),
            role: 0 /* CompoundMenuNodeRole.Submenu */
        });
        menus.registerMenuAction(NotebookCellActionContribution_1.ADDITIONAL_OUTPUT_SIDEBAR_MENU, {
            commandId: NotebookCellCommands.CLEAR_OUTPUTS_COMMAND.id,
            label: core_1.nls.localizeByDefault('Clear Cell Outputs'),
        });
        menus.registerMenuAction(NotebookCellActionContribution_1.ADDITIONAL_OUTPUT_SIDEBAR_MENU, {
            commandId: NotebookCellCommands.CHANGE_OUTPUT_PRESENTATION_COMMAND.id,
            label: core_1.nls.localizeByDefault('Change Presentation'),
        });
    }
    registerCommands(commands) {
        commands.registerCommand(NotebookCellCommands.EDIT_COMMAND, this.editableCellCommandHandler((_, cell) => cell.requestFocusEditor()));
        commands.registerCommand(NotebookCellCommands.STOP_EDIT_COMMAND, { execute: (_, cell) => (cell !== null && cell !== void 0 ? cell : this.getSelectedCell()).requestBlurEditor() });
        commands.registerCommand(NotebookCellCommands.DELETE_COMMAND, this.editableCellCommandHandler((notebookModel, cell) => {
            notebookModel.applyEdits([{
                    editType: 1 /* CellEditType.Replace */,
                    index: notebookModel.cells.indexOf(cell),
                    count: 1,
                    cells: []
                }], true);
        }));
        commands.registerCommand(NotebookCellCommands.SPLIT_CELL_COMMAND, this.editableCellCommandHandler(async (notebookModel, cell) => {
            var _a;
            // selection (0,0,0,0) should also be used in !cell.editing mode, but `cell.editing`
            // is not properly implemented for Code cells.
            const cellSelection = (_a = cell.selection) !== null && _a !== void 0 ? _a : { start: { line: 0, character: 0 }, end: { line: 0, character: 0 } };
            const textModel = await cell.resolveTextModel();
            // Create new cell with the text after the cursor
            const splitOffset = textModel.offsetAt({
                line: cellSelection.start.line,
                character: cellSelection.start.character
            });
            const newCell = {
                cellKind: cell.cellKind,
                language: cell.language,
                outputs: [],
                source: textModel.getText().substring(splitOffset),
            };
            // add new cell below
            const index = notebookModel.cells.indexOf(cell);
            notebookModel.applyEdits([{ editType: 1 /* CellEditType.Replace */, index: index + 1, count: 0, cells: [newCell] }], true);
            // update current cell text (undo-able)
            const selection = new selection_1.Selection(cellSelection.start.line + 1, cellSelection.start.character + 1, cellSelection.end.line + 1, cellSelection.end.character + 1);
            const endPosition = textModel.positionAt(textModel.getText().length);
            const deleteOp = {
                range: {
                    startLineNumber: selection.startLineNumber,
                    startColumn: selection.startColumn,
                    endLineNumber: endPosition.line + 1,
                    endColumn: endPosition.character + 1
                },
                // eslint-disable-next-line no-null/no-null
                text: null
            };
            // Create a new undo/redo stack entry
            textModel.textEditorModel.pushStackElement();
            textModel.textEditorModel.pushEditOperations([selection], [deleteOp], () => [selection]);
        }));
        commands.registerCommand(NotebookCellCommands.EXECUTE_SINGLE_CELL_COMMAND, this.editableCellCommandHandler((notebookModel, cell) => {
            this.notebookExecutionService.executeNotebookCells(notebookModel, [cell]);
        }));
        commands.registerCommand(NotebookCellCommands.EXECUTE_SINGLE_CELL_AND_FOCUS_NEXT_COMMAND, this.editableCellCommandHandler((notebookModel, cell) => {
            if (cell.cellKind === common_1.CellKind.Code) {
                commands.executeCommand(NotebookCellCommands.EXECUTE_SINGLE_CELL_COMMAND.id, notebookModel, cell);
            }
            else {
                commands.executeCommand(NotebookCellCommands.STOP_EDIT_COMMAND.id, notebookModel, cell);
            }
            const index = notebookModel.cells.indexOf(cell);
            if (index < notebookModel.cells.length - 1) {
                notebookModel.setSelectedCell(notebookModel.cells[index + 1]);
            }
            else if (cell.cellKind === common_1.CellKind.Code) {
                commands.executeCommand(NotebookCellCommands.INSERT_NEW_CELL_BELOW_COMMAND.id);
            }
            else {
                commands.executeCommand(NotebookCellCommands.INSERT_MARKDOWN_CELL_BELOW_COMMAND.id);
            }
        }));
        commands.registerCommand(NotebookCellCommands.EXECUTE_SINGLE_CELL_AND_INSERT_BELOW_COMMAND, this.editableCellCommandHandler(async (notebookModel, cell) => {
            if (cell.cellKind === common_1.CellKind.Code) {
                await commands.executeCommand(NotebookCellCommands.EXECUTE_SINGLE_CELL_COMMAND.id, notebookModel, cell);
            }
            await commands.executeCommand(NotebookCellCommands.STOP_EDIT_COMMAND.id, notebookModel, cell);
            if (cell.cellKind === common_1.CellKind.Code) {
                await commands.executeCommand(NotebookCellCommands.INSERT_NEW_CELL_BELOW_COMMAND.id);
            }
            else {
                await commands.executeCommand(NotebookCellCommands.INSERT_MARKDOWN_CELL_BELOW_COMMAND.id);
            }
            const index = notebookModel.cells.indexOf(cell);
            notebookModel.setSelectedCell(notebookModel.cells[index + 1]);
        }));
        commands.registerCommand(NotebookCellCommands.EXECUTE_ABOVE_CELLS_COMMAND, this.editableCellCommandHandler((notebookModel, cell) => {
            const index = notebookModel.cells.indexOf(cell);
            if (index > 0) {
                this.notebookExecutionService.executeNotebookCells(notebookModel, notebookModel.cells.slice(0, index).filter(c => c.cellKind === common_1.CellKind.Code));
            }
        }));
        commands.registerCommand(NotebookCellCommands.EXECUTE_CELL_AND_BELOW_COMMAND, this.editableCellCommandHandler((notebookModel, cell) => {
            const index = notebookModel.cells.indexOf(cell);
            if (index >= 0) {
                this.notebookExecutionService.executeNotebookCells(notebookModel, notebookModel.cells.slice(index).filter(c => c.cellKind === common_1.CellKind.Code));
            }
        }));
        commands.registerCommand(NotebookCellCommands.STOP_CELL_EXECUTION_COMMAND, {
            execute: (notebookModel, cell) => {
                var _a;
                notebookModel = notebookModel !== null && notebookModel !== void 0 ? notebookModel : (_a = this.notebookEditorWidgetService.focusedEditor) === null || _a === void 0 ? void 0 : _a.model;
                cell = cell !== null && cell !== void 0 ? cell : this.getSelectedCell();
                this.notebookExecutionService.cancelNotebookCells(notebookModel, [cell]);
            }
        });
        commands.registerCommand(NotebookCellCommands.CLEAR_OUTPUTS_COMMAND, this.editableCellCommandHandler((notebook, cell) => {
            var _a, _b;
            return (_b = (notebook !== null && notebook !== void 0 ? notebook : (_a = this.notebookEditorWidgetService.focusedEditor) === null || _a === void 0 ? void 0 : _a.model)) === null || _b === void 0 ? void 0 : _b.applyEdits([{
                    editType: 2 /* CellEditType.Output */,
                    handle: cell.handle,
                    outputs: [],
                    deleteCount: cell.outputs.length,
                    append: false
                }], true);
        }));
        commands.registerCommand(NotebookCellCommands.CHANGE_OUTPUT_PRESENTATION_COMMAND, this.editableCellCommandHandler((notebook, cell, output) => {
            var _a;
            (_a = this.notebookEditorWidgetService.getNotebookEditor(notebook_editor_widget_1.NOTEBOOK_EDITOR_ID_PREFIX + notebook.uri.toString())) === null || _a === void 0 ? void 0 : _a.requestOuputPresentationChange(cell.handle, output);
        }));
        const insertCommand = (type, index, focusContainer) => this.editableCellCommandHandler(() => commands.executeCommand(notebook_actions_contribution_1.NotebookCommands.ADD_NEW_CELL_COMMAND.id, undefined, type, index, focusContainer));
        commands.registerCommand(NotebookCellCommands.INSERT_NEW_CELL_ABOVE_COMMAND, insertCommand(common_1.CellKind.Code, 'above', true));
        commands.registerCommand(NotebookCellCommands.INSERT_NEW_CELL_BELOW_COMMAND, insertCommand(common_1.CellKind.Code, 'below', true));
        commands.registerCommand(NotebookCellCommands.INSERT_MARKDOWN_CELL_ABOVE_COMMAND, insertCommand(common_1.CellKind.Markup, 'above', false));
        commands.registerCommand(NotebookCellCommands.INSERT_MARKDOWN_CELL_BELOW_COMMAND, insertCommand(common_1.CellKind.Markup, 'below', false));
        commands.registerCommand(NotebookCellCommands.TO_CODE_CELL_COMMAND, this.editableCellCommandHandler((notebookModel, cell) => {
            (0, cell_operations_1.changeCellType)(notebookModel, cell, common_1.CellKind.Code, this.notebookService.getCodeCellLanguage(notebookModel));
        }));
        commands.registerCommand(NotebookCellCommands.TO_MARKDOWN_CELL_COMMAND, this.editableCellCommandHandler((notebookModel, cell) => {
            (0, cell_operations_1.changeCellType)(notebookModel, cell, common_1.CellKind.Markup);
        }));
        commands.registerCommand(NotebookCellCommands.TOGGLE_CELL_OUTPUT, {
            execute: () => {
                var _a, _b;
                const selectedCell = (_b = (_a = this.notebookEditorWidgetService.focusedEditor) === null || _a === void 0 ? void 0 : _a.model) === null || _b === void 0 ? void 0 : _b.selectedCell;
                if (selectedCell) {
                    selectedCell.outputVisible = !selectedCell.outputVisible;
                }
            }
        });
        commands.registerCommand(NotebookCellCommands.CHANGE_CELL_LANGUAGE, {
            isVisible: () => { var _a, _b; return !!((_b = (_a = this.notebookEditorWidgetService.focusedEditor) === null || _a === void 0 ? void 0 : _a.model) === null || _b === void 0 ? void 0 : _b.selectedCell); },
            execute: async (notebook, cell) => {
                var _a, _b, _c, _d, _e;
                const selectedCell = cell !== null && cell !== void 0 ? cell : (_b = (_a = this.notebookEditorWidgetService.focusedEditor) === null || _a === void 0 ? void 0 : _a.model) === null || _b === void 0 ? void 0 : _b.selectedCell;
                const activeNotebook = notebook !== null && notebook !== void 0 ? notebook : (_c = this.notebookEditorWidgetService.focusedEditor) === null || _c === void 0 ? void 0 : _c.model;
                if (!selectedCell || !activeNotebook) {
                    return;
                }
                const language = await this.languageQuickPickService.pickEditorLanguage(selectedCell.language);
                if (!(language === null || language === void 0 ? void 0 : language.value) || language.value === 'autoDetect' || language.value.id === selectedCell.language) {
                    return;
                }
                const isMarkdownCell = selectedCell.cellKind === common_1.CellKind.Markup;
                const isMarkdownLanguage = language.value.id === 'markdown';
                if (isMarkdownLanguage) {
                    (0, cell_operations_1.changeCellType)(activeNotebook, selectedCell, common_1.CellKind.Markup, language.value.id);
                }
                else {
                    if (isMarkdownCell) {
                        (0, cell_operations_1.changeCellType)(activeNotebook, selectedCell, common_1.CellKind.Code, language.value.id);
                    }
                    else {
                        (_e = (_d = this.notebookEditorWidgetService.focusedEditor) === null || _d === void 0 ? void 0 : _d.model) === null || _e === void 0 ? void 0 : _e.applyEdits([{
                                editType: 4 /* CellEditType.CellLanguage */,
                                index: activeNotebook.cells.indexOf(selectedCell),
                                language: language.value.id
                            }], true);
                    }
                }
            }
        });
        commands.registerCommand(NotebookCellCommands.TOGGLE_LINE_NUMBERS, {
            execute: () => {
                var _a, _b, _c;
                const selectedCell = (_b = (_a = this.notebookEditorWidgetService.focusedEditor) === null || _a === void 0 ? void 0 : _a.model) === null || _b === void 0 ? void 0 : _b.selectedCell;
                if (selectedCell) {
                    const currentLineNumber = (_c = selectedCell.editorOptions) === null || _c === void 0 ? void 0 : _c.lineNumbers;
                    selectedCell.editorOptions = { ...selectedCell.editorOptions, lineNumbers: !currentLineNumber || currentLineNumber === 'off' ? 'on' : 'off' };
                }
            }
        });
    }
    editableCellCommandHandler(execute) {
        return {
            isEnabled: (notebookModel) => !Boolean(notebookModel === null || notebookModel === void 0 ? void 0 : notebookModel.readOnly),
            isVisible: (notebookModel) => !Boolean(notebookModel === null || notebookModel === void 0 ? void 0 : notebookModel.readOnly),
            execute: (notebookModel, cell, output) => {
                var _a;
                notebookModel = notebookModel !== null && notebookModel !== void 0 ? notebookModel : (_a = this.notebookEditorWidgetService.focusedEditor) === null || _a === void 0 ? void 0 : _a.model;
                cell = cell !== null && cell !== void 0 ? cell : this.getSelectedCell();
                execute(notebookModel, cell, output);
            }
        };
    }
    getSelectedCell() {
        var _a, _b;
        return (_b = (_a = this.notebookEditorWidgetService.focusedEditor) === null || _a === void 0 ? void 0 : _a.model) === null || _b === void 0 ? void 0 : _b.selectedCell;
    }
    registerKeybindings(keybindings) {
        keybindings.registerKeybindings({
            command: NotebookCellCommands.EDIT_COMMAND.id,
            keybinding: 'Enter',
            when: `!editorTextFocus && !inputFocus && ${notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_CELL_FOCUSED}`,
        }, {
            command: NotebookCellCommands.STOP_EDIT_COMMAND.id,
            keybinding: browser_1.KeyCode.createKeyCode({ first: browser_1.Key.ENTER, modifiers: [browser_1.KeyModifier.Alt, browser_1.KeyModifier.CtrlCmd] }).toString(),
            when: `editorTextFocus && ${notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_CELL_TYPE} == 'markdown'`,
        }, {
            command: NotebookCellCommands.STOP_EDIT_COMMAND.id,
            keybinding: 'esc',
            when: `editorTextFocus && ${notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED} && !suggestWidgetVisible`,
        }, {
            command: NotebookCellCommands.EXECUTE_SINGLE_CELL_COMMAND.id,
            keybinding: browser_1.KeyCode.createKeyCode({ first: browser_1.Key.ENTER, modifiers: [browser_1.KeyModifier.CtrlCmd] }).toString(),
            when: `${notebook_context_keys_1.NOTEBOOK_CELL_LIST_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_CELL_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_CELL_TYPE} == 'code'`,
        }, {
            command: NotebookCellCommands.EXECUTE_SINGLE_CELL_AND_FOCUS_NEXT_COMMAND.id,
            keybinding: browser_1.KeyCode.createKeyCode({ first: browser_1.Key.ENTER, modifiers: [browser_1.KeyModifier.Shift] }).toString(),
            when: `${notebook_context_keys_1.NOTEBOOK_CELL_LIST_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_CELL_FOCUSED}`,
        }, {
            command: NotebookCellCommands.EXECUTE_SINGLE_CELL_AND_INSERT_BELOW_COMMAND.id,
            keybinding: browser_1.KeyCode.createKeyCode({ first: browser_1.Key.ENTER, modifiers: [browser_1.KeyModifier.Alt] }).toString(),
            when: `${notebook_context_keys_1.NOTEBOOK_CELL_LIST_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_CELL_FOCUSED}`,
        }, {
            command: NotebookCellCommands.CLEAR_OUTPUTS_COMMAND.id,
            keybinding: browser_1.KeyCode.createKeyCode({ first: browser_1.Key.KEY_O, modifiers: [browser_1.KeyModifier.Alt] }).toString(),
            when: `${notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_CELL_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_CELL_TYPE} == 'code'`,
        }, {
            command: NotebookCellCommands.CHANGE_OUTPUT_PRESENTATION_COMMAND.id,
            keybinding: browser_1.KeyCode.createKeyCode({ first: browser_1.Key.KEY_P, modifiers: [browser_1.KeyModifier.Alt] }).toString(),
            when: `${notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_CELL_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_CELL_TYPE} == 'code'`,
        }, {
            command: NotebookCellCommands.TO_CODE_CELL_COMMAND.id,
            keybinding: 'Y',
            when: `!editorTextFocus && ${notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_CELL_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_CELL_TYPE} == 'markdown'`,
        }, {
            command: NotebookCellCommands.TO_MARKDOWN_CELL_COMMAND.id,
            keybinding: 'M',
            when: `!editorTextFocus && ${notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_CELL_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_CELL_TYPE} == 'code'`,
        }, {
            command: NotebookCellCommands.SPLIT_CELL_COMMAND.id,
            keybinding: browser_1.KeyCode.createKeyCode({ first: browser_1.Key.MINUS, modifiers: [browser_1.KeyModifier.CtrlCmd, browser_1.KeyModifier.Shift] }).toString(),
            when: `editorTextFocus && ${notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED} && ${notebook_context_keys_1.NOTEBOOK_CELL_FOCUSED}`,
        });
    }
};
exports.NotebookCellActionContribution = NotebookCellActionContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    tslib_1.__metadata("design:type", Object)
], NotebookCellActionContribution.prototype, "contextKeyService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_service_1.NotebookService),
    tslib_1.__metadata("design:type", notebook_service_1.NotebookService)
], NotebookCellActionContribution.prototype, "notebookService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_execution_service_1.NotebookExecutionService),
    tslib_1.__metadata("design:type", notebook_execution_service_1.NotebookExecutionService)
], NotebookCellActionContribution.prototype, "notebookExecutionService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_editor_widget_service_1.NotebookEditorWidgetService),
    tslib_1.__metadata("design:type", notebook_editor_widget_service_1.NotebookEditorWidgetService)
], NotebookCellActionContribution.prototype, "notebookEditorWidgetService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(editor_language_quick_pick_service_1.EditorLanguageQuickPickService),
    tslib_1.__metadata("design:type", editor_language_quick_pick_service_1.EditorLanguageQuickPickService)
], NotebookCellActionContribution.prototype, "languageQuickPickService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], NotebookCellActionContribution.prototype, "init", null);
exports.NotebookCellActionContribution = NotebookCellActionContribution = NotebookCellActionContribution_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookCellActionContribution);
(function (NotebookCellActionContribution) {
    NotebookCellActionContribution.ACTION_MENU = ['notebook-cell-actions-menu'];
    NotebookCellActionContribution.ADDITIONAL_ACTION_MENU = [...NotebookCellActionContribution.ACTION_MENU, 'more'];
    NotebookCellActionContribution.CONTRIBUTED_CELL_ACTION_MENU = 'notebook/cell/title';
    NotebookCellActionContribution.CONTRIBUTED_CELL_EXECUTION_MENU = 'notebook/cell/execute';
    NotebookCellActionContribution.CODE_CELL_SIDEBAR_MENU = ['code-cell-sidebar-menu'];
    NotebookCellActionContribution.OUTPUT_SIDEBAR_MENU = ['code-cell-output-sidebar-menu'];
    NotebookCellActionContribution.ADDITIONAL_OUTPUT_SIDEBAR_MENU = [...NotebookCellActionContribution.OUTPUT_SIDEBAR_MENU, 'more'];
})(NotebookCellActionContribution || (exports.NotebookCellActionContribution = NotebookCellActionContribution = {}));


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-context-keys.js":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/contributions/notebook-context-keys.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookContextKeys = exports.NOTEBOOK_CELL_CURSOR_LAST_LINE = exports.NOTEBOOK_CELL_CURSOR_FIRST_LINE = exports.NOTEBOOK_HAS_OUTPUTS = exports.NOTEBOOK_MISSING_KERNEL_EXTENSION = exports.NOTEBOOK_INTERRUPTIBLE_KERNEL = exports.NOTEBOOK_KERNEL_SELECTED = exports.NOTEBOOK_KERNEL_SOURCE_COUNT = exports.NOTEBOOK_KERNEL_COUNT = exports.NOTEBOOK_KERNEL = exports.NOTEBOOK_CELL_RESOURCE = exports.NOTEBOOK_CELL_OUTPUT_COLLAPSED = exports.NOTEBOOK_CELL_INPUT_COLLAPSED = exports.NOTEBOOK_CELL_HAS_OUTPUTS = exports.NOTEBOOK_CELL_EXECUTING = exports.NOTEBOOK_CELL_EXECUTION_STATE = exports.NOTEBOOK_CELL_LINE_NUMBERS = exports.NOTEBOOK_CELL_MARKDOWN_EDIT_MODE = exports.NOTEBOOK_CELL_EDITOR_FOCUSED = exports.NOTEBOOK_CELL_FOCUSED = exports.NOTEBOOK_CELL_EDITABLE = exports.NOTEBOOK_CELL_TYPE = exports.NOTEBOOK_VIEW_TYPE = exports.NOTEBOOK_LAST_CELL_FAILED = exports.NOTEBOOK_CURSOR_NAVIGATION_MODE = exports.NOTEBOOK_CELL_TOOLBAR_LOCATION = exports.NOTEBOOK_BREAKPOINT_MARGIN_ACTIVE = exports.NOTEBOOK_USE_CONSOLIDATED_OUTPUT_BUTTON = exports.NOTEBOOK_HAS_RUNNING_CELL = exports.NOTEBOOK_EDITOR_EDITABLE = exports.NOTEBOOK_OUTPUT_INPUT_FOCUSED = exports.NOTEBOOK_OUTPUT_FOCUSED = exports.NOTEBOOK_CELL_LIST_FOCUSED = exports.NOTEBOOK_EDITOR_FOCUSED = exports.KEYBINDING_CONTEXT_NOTEBOOK_FIND_WIDGET_FOCUSED = exports.HAS_OPENED_NOTEBOOK = void 0;
/**
 * Context Keys for the Notebook Editor as defined by vscode in https://github.com/microsoft/vscode/blob/main/src/vs/workbench/contrib/notebook/common/notebookContextKeys.ts
 */
exports.HAS_OPENED_NOTEBOOK = 'userHasOpenedNotebook';
exports.KEYBINDING_CONTEXT_NOTEBOOK_FIND_WIDGET_FOCUSED = 'notebookFindWidgetFocused';
exports.NOTEBOOK_EDITOR_FOCUSED = 'notebookEditorFocused';
exports.NOTEBOOK_CELL_LIST_FOCUSED = 'notebookCellListFocused';
exports.NOTEBOOK_OUTPUT_FOCUSED = 'notebookOutputFocused';
exports.NOTEBOOK_OUTPUT_INPUT_FOCUSED = 'notebookOutputInputFocused';
exports.NOTEBOOK_EDITOR_EDITABLE = 'notebookEditable';
exports.NOTEBOOK_HAS_RUNNING_CELL = 'notebookHasRunningCell';
exports.NOTEBOOK_USE_CONSOLIDATED_OUTPUT_BUTTON = 'notebookUseConsolidatedOutputButton';
exports.NOTEBOOK_BREAKPOINT_MARGIN_ACTIVE = 'notebookBreakpointMargin';
exports.NOTEBOOK_CELL_TOOLBAR_LOCATION = 'notebookCellToolbarLocation';
exports.NOTEBOOK_CURSOR_NAVIGATION_MODE = 'notebookCursorNavigationMode';
exports.NOTEBOOK_LAST_CELL_FAILED = 'notebookLastCellFailed';
exports.NOTEBOOK_VIEW_TYPE = 'notebookType';
exports.NOTEBOOK_CELL_TYPE = 'notebookCellType';
exports.NOTEBOOK_CELL_EDITABLE = 'notebookCellEditable';
exports.NOTEBOOK_CELL_FOCUSED = 'notebookCellFocused';
exports.NOTEBOOK_CELL_EDITOR_FOCUSED = 'notebookCellEditorFocused';
exports.NOTEBOOK_CELL_MARKDOWN_EDIT_MODE = 'notebookCellMarkdownEditMode';
exports.NOTEBOOK_CELL_LINE_NUMBERS = 'notebookCellLineNumbers';
exports.NOTEBOOK_CELL_EXECUTION_STATE = 'notebookCellExecutionState';
exports.NOTEBOOK_CELL_EXECUTING = 'notebookCellExecuting';
exports.NOTEBOOK_CELL_HAS_OUTPUTS = 'notebookCellHasOutputs';
exports.NOTEBOOK_CELL_INPUT_COLLAPSED = 'notebookCellInputIsCollapsed';
exports.NOTEBOOK_CELL_OUTPUT_COLLAPSED = 'notebookCellOutputIsCollapsed';
exports.NOTEBOOK_CELL_RESOURCE = 'notebookCellResource';
exports.NOTEBOOK_KERNEL = 'notebookKernel';
exports.NOTEBOOK_KERNEL_COUNT = 'notebookKernelCount';
exports.NOTEBOOK_KERNEL_SOURCE_COUNT = 'notebookKernelSourceCount';
exports.NOTEBOOK_KERNEL_SELECTED = 'notebookKernelSelected';
exports.NOTEBOOK_INTERRUPTIBLE_KERNEL = 'notebookInterruptibleKernel';
exports.NOTEBOOK_MISSING_KERNEL_EXTENSION = 'notebookMissingKernelExtension';
exports.NOTEBOOK_HAS_OUTPUTS = 'notebookHasOutputs';
exports.NOTEBOOK_CELL_CURSOR_FIRST_LINE = 'cellEditorCursorPositionFirstLine';
exports.NOTEBOOK_CELL_CURSOR_LAST_LINE = 'cellEditorCursorPositionLastLine';
var NotebookContextKeys;
(function (NotebookContextKeys) {
    function initNotebookContextKeys(service) {
        service.createKey(exports.HAS_OPENED_NOTEBOOK, false);
        service.createKey(exports.KEYBINDING_CONTEXT_NOTEBOOK_FIND_WIDGET_FOCUSED, false);
        // // Is Notebook
        // export const NOTEBOOK_IS_ACTIVE_EDITOR = ContextKeyExpr.equals('activeEditor', NOTEBOOK_EDITOR_ID);
        // export const INTERACTIVE_WINDOW_IS_ACTIVE_EDITOR = ContextKeyExpr.equals('activeEditor', INTERACTIVE_WINDOW_EDITOR_ID);
        // Editor keys
        service.createKey(exports.NOTEBOOK_EDITOR_FOCUSED, false);
        service.createKey(exports.NOTEBOOK_CELL_LIST_FOCUSED, false);
        service.createKey(exports.NOTEBOOK_OUTPUT_FOCUSED, false);
        service.createKey(exports.NOTEBOOK_OUTPUT_INPUT_FOCUSED, false);
        service.createKey(exports.NOTEBOOK_EDITOR_EDITABLE, true);
        service.createKey(exports.NOTEBOOK_HAS_RUNNING_CELL, false);
        service.createKey(exports.NOTEBOOK_USE_CONSOLIDATED_OUTPUT_BUTTON, false);
        service.createKey(exports.NOTEBOOK_BREAKPOINT_MARGIN_ACTIVE, false);
        service.createKey(exports.NOTEBOOK_CELL_TOOLBAR_LOCATION, 'left');
        service.createKey(exports.NOTEBOOK_CURSOR_NAVIGATION_MODE, false);
        service.createKey(exports.NOTEBOOK_LAST_CELL_FAILED, false);
        // Cell keys
        service.createKey(exports.NOTEBOOK_VIEW_TYPE, undefined);
        service.createKey(exports.NOTEBOOK_CELL_TYPE, undefined);
        service.createKey(exports.NOTEBOOK_CELL_EDITABLE, false);
        service.createKey(exports.NOTEBOOK_CELL_FOCUSED, false);
        service.createKey(exports.NOTEBOOK_CELL_EDITOR_FOCUSED, false);
        service.createKey(exports.NOTEBOOK_CELL_MARKDOWN_EDIT_MODE, false);
        service.createKey(exports.NOTEBOOK_CELL_LINE_NUMBERS, 'inherit');
        service.createKey(exports.NOTEBOOK_CELL_EXECUTION_STATE, undefined);
        service.createKey(exports.NOTEBOOK_CELL_EXECUTING, false);
        service.createKey(exports.NOTEBOOK_CELL_HAS_OUTPUTS, false);
        service.createKey(exports.NOTEBOOK_CELL_INPUT_COLLAPSED, false);
        service.createKey(exports.NOTEBOOK_CELL_OUTPUT_COLLAPSED, false);
        service.createKey(exports.NOTEBOOK_CELL_RESOURCE, '');
        service.createKey(exports.NOTEBOOK_CELL_CURSOR_FIRST_LINE, false);
        service.createKey(exports.NOTEBOOK_CELL_CURSOR_LAST_LINE, false);
        // Kernels
        service.createKey(exports.NOTEBOOK_KERNEL, undefined);
        service.createKey(exports.NOTEBOOK_KERNEL_COUNT, 0);
        service.createKey(exports.NOTEBOOK_KERNEL_SOURCE_COUNT, 0);
        service.createKey(exports.NOTEBOOK_KERNEL_SELECTED, false);
        service.createKey(exports.NOTEBOOK_INTERRUPTIBLE_KERNEL, false);
        service.createKey(exports.NOTEBOOK_MISSING_KERNEL_EXTENSION, false);
        service.createKey(exports.NOTEBOOK_HAS_OUTPUTS, false);
    }
    NotebookContextKeys.initNotebookContextKeys = initNotebookContextKeys;
})(NotebookContextKeys || (exports.NotebookContextKeys = NotebookContextKeys = {}));


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-preferences.js":
/*!********************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/contributions/notebook-preferences.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.bindNotebookPreferences = exports.NotebookPreferenceContribution = exports.notebookPreferenceSchema = exports.NotebookPreferences = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
var NotebookPreferences;
(function (NotebookPreferences) {
    NotebookPreferences.NOTEBOOK_LINE_NUMBERS = 'notebook.lineNumbers';
    NotebookPreferences.OUTPUT_LINE_HEIGHT = 'notebook.output.lineHeight';
    NotebookPreferences.OUTPUT_FONT_SIZE = 'notebook.output.fontSize';
    NotebookPreferences.OUTPUT_FONT_FAMILY = 'notebook.output.fontFamily';
    NotebookPreferences.OUTPUT_SCROLLING = 'notebook.output.scrolling';
    NotebookPreferences.OUTPUT_WORD_WRAP = 'notebook.output.wordWrap';
    NotebookPreferences.OUTPUT_LINE_LIMIT = 'notebook.output.textLineLimit';
})(NotebookPreferences || (exports.NotebookPreferences = NotebookPreferences = {}));
exports.notebookPreferenceSchema = {
    properties: {
        [NotebookPreferences.NOTEBOOK_LINE_NUMBERS]: {
            type: 'string',
            enum: ['on', 'off'],
            default: 'off',
            description: core_1.nls.localizeByDefault('Controls the display of line numbers in the cell editor.')
        },
        [NotebookPreferences.OUTPUT_LINE_HEIGHT]: {
            // eslint-disable-next-line max-len
            markdownDescription: core_1.nls.localizeByDefault('Line height of the output text within notebook cells.\n - When set to 0, editor line height is used.\n - Values between 0 and 8 will be used as a multiplier with the font size.\n - Values greater than or equal to 8 will be used as effective values.'),
            type: 'number',
            default: 0,
            tags: ['notebookLayout', 'notebookOutputLayout']
        },
        [NotebookPreferences.OUTPUT_FONT_SIZE]: {
            markdownDescription: core_1.nls.localizeByDefault('Font size for the output text within notebook cells. When set to 0, {0} is used.', '`#editor.fontSize#`'),
            type: 'number',
            default: 0,
            tags: ['notebookLayout', 'notebookOutputLayout']
        },
        [NotebookPreferences.OUTPUT_FONT_FAMILY]: {
            markdownDescription: core_1.nls.localizeByDefault('The font family of the output text within notebook cells. When set to empty, the {0} is used.', '`#editor.fontFamily#`'),
            type: 'string',
            tags: ['notebookLayout', 'notebookOutputLayout']
        },
        [NotebookPreferences.OUTPUT_SCROLLING]: {
            markdownDescription: core_1.nls.localizeByDefault('Initially render notebook outputs in a scrollable region when longer than the limit.'),
            type: 'boolean',
            tags: ['notebookLayout', 'notebookOutputLayout'],
            default: false
        },
        [NotebookPreferences.OUTPUT_WORD_WRAP]: {
            markdownDescription: core_1.nls.localizeByDefault('Controls whether the lines in output should wrap.'),
            type: 'boolean',
            tags: ['notebookLayout', 'notebookOutputLayout'],
            default: false
        },
        [NotebookPreferences.OUTPUT_LINE_LIMIT]: {
            markdownDescription: core_1.nls.localizeByDefault('Controls how many lines of text are displayed in a text output. If {0} is enabled, this setting is used to determine the scroll height of the output.', '`#notebook.output.scrolling#`'),
            type: 'number',
            default: 30,
            tags: ['notebookLayout', 'notebookOutputLayout'],
            minimum: 1,
        },
    }
};
exports.NotebookPreferenceContribution = Symbol('NotebookPreferenceContribution');
function bindNotebookPreferences(bind) {
    // We don't need a NotebookPreferenceConfiguration class, so there's no preference proxy to bind
    bind(exports.NotebookPreferenceContribution).toConstantValue({ schema: exports.notebookPreferenceSchema });
    bind(browser_1.PreferenceContribution).toService(exports.NotebookPreferenceContribution);
}
exports.bindNotebookPreferences = bindNotebookPreferences;


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/notebook-editor-widget.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/notebook-editor-widget.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookEditorWidget = exports.NOTEBOOK_EDITOR_ID_PREFIX = exports.NotebookEditorProps = exports.createNotebookEditorWidgetContainer = exports.NotebookEditorWidgetContainerFactory = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const common_1 = __webpack_require__(/*! ../common */ "../../node_modules/@theia/notebook/lib/common/index.js");
const notebook_cell_list_view_1 = __webpack_require__(/*! ./view/notebook-cell-list-view */ "../../node_modules/@theia/notebook/lib/browser/view/notebook-cell-list-view.js");
const notebook_code_cell_view_1 = __webpack_require__(/*! ./view/notebook-code-cell-view */ "../../node_modules/@theia/notebook/lib/browser/view/notebook-code-cell-view.js");
const notebook_markdown_cell_view_1 = __webpack_require__(/*! ./view/notebook-markdown-cell-view */ "../../node_modules/@theia/notebook/lib/browser/view/notebook-markdown-cell-view.js");
const notebook_cell_toolbar_factory_1 = __webpack_require__(/*! ./view/notebook-cell-toolbar-factory */ "../../node_modules/@theia/notebook/lib/browser/view/notebook-cell-toolbar-factory.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const vscode_languageserver_protocol_1 = __webpack_require__(/*! @theia/core/shared/vscode-languageserver-protocol */ "../../node_modules/@theia/core/shared/vscode-languageserver-protocol/index.js");
const notebook_editor_widget_service_1 = __webpack_require__(/*! ./service/notebook-editor-widget-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-editor-widget-service.js");
const notebook_main_toolbar_1 = __webpack_require__(/*! ./view/notebook-main-toolbar */ "../../node_modules/@theia/notebook/lib/browser/view/notebook-main-toolbar.js");
const promise_util_1 = __webpack_require__(/*! @theia/core/lib/common/promise-util */ "../../node_modules/@theia/core/lib/common/promise-util.js");
const notebook_context_manager_1 = __webpack_require__(/*! ./service/notebook-context-manager */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-context-manager.js");
const notebook_viewport_service_1 = __webpack_require__(/*! ./view/notebook-viewport-service */ "../../node_modules/@theia/notebook/lib/browser/view/notebook-viewport-service.js");
const notebook_cell_actions_contribution_1 = __webpack_require__(/*! ./contributions/notebook-cell-actions-contribution */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-cell-actions-contribution.js");
const notebook_find_widget_1 = __webpack_require__(/*! ./view/notebook-find-widget */ "../../node_modules/@theia/notebook/lib/browser/view/notebook-find-widget.js");
const debounce = __webpack_require__(/*! lodash/debounce */ "../../node_modules/lodash/debounce.js");
const cell_output_webview_1 = __webpack_require__(/*! ./renderers/cell-output-webview */ "../../node_modules/@theia/notebook/lib/browser/renderers/cell-output-webview.js");
const PerfectScrollbar = __webpack_require__(/*! react-perfect-scrollbar */ "../../node_modules/react-perfect-scrollbar/lib/index.js");
exports.NotebookEditorWidgetContainerFactory = Symbol('NotebookEditorWidgetContainerFactory');
function createNotebookEditorWidgetContainer(parent, props) {
    const child = parent.createChild();
    child.bind(exports.NotebookEditorProps).toConstantValue(props);
    const cellOutputWebviewFactory = parent.get(cell_output_webview_1.CellOutputWebviewFactory);
    child.bind(cell_output_webview_1.CellOutputWebview).toConstantValue(cellOutputWebviewFactory());
    child.bind(notebook_context_manager_1.NotebookContextManager).toSelf().inSingletonScope();
    child.bind(notebook_main_toolbar_1.NotebookMainToolbarRenderer).toSelf().inSingletonScope();
    child.bind(notebook_cell_toolbar_factory_1.NotebookCellToolbarFactory).toSelf().inSingletonScope();
    child.bind(notebook_code_cell_view_1.NotebookCodeCellRenderer).toSelf().inSingletonScope();
    child.bind(notebook_markdown_cell_view_1.NotebookMarkdownCellRenderer).toSelf().inSingletonScope();
    child.bind(notebook_viewport_service_1.NotebookViewportService).toSelf().inSingletonScope();
    child.bind(NotebookEditorWidget).toSelf();
    return child;
}
exports.createNotebookEditorWidgetContainer = createNotebookEditorWidgetContainer;
exports.NotebookEditorProps = Symbol('NotebookEditorProps');
exports.NOTEBOOK_EDITOR_ID_PREFIX = 'notebook:';
let NotebookEditorWidget = class NotebookEditorWidget extends browser_1.ReactWidget {
    constructor() {
        super(...arguments);
        this.saveable = new browser_1.DelegatingSaveable();
        this.onDidChangeModelEmitter = new vscode_languageserver_protocol_1.Emitter();
        this.onDidChangeModel = this.onDidChangeModelEmitter.event;
        this.onDidChangeReadOnlyEmitter = new vscode_languageserver_protocol_1.Emitter();
        this.onDidChangeReadOnly = this.onDidChangeReadOnlyEmitter.event;
        this.onPostKernelMessageEmitter = new vscode_languageserver_protocol_1.Emitter();
        this.onPostKernelMessage = this.onPostKernelMessageEmitter.event;
        this.onDidPostKernelMessageEmitter = new vscode_languageserver_protocol_1.Emitter();
        this.onDidPostKernelMessage = this.onDidPostKernelMessageEmitter.event;
        this.onPostRendererMessageEmitter = new vscode_languageserver_protocol_1.Emitter();
        this.onPostRendererMessage = this.onPostRendererMessageEmitter.event;
        this.onDidReceiveKernelMessageEmitter = new vscode_languageserver_protocol_1.Emitter();
        this.onDidReceiveKernelMessage = this.onDidReceiveKernelMessageEmitter.event;
        this.onDidChangeOutputInputFocusEmitter = new vscode_languageserver_protocol_1.Emitter();
        this.onDidChangeOutputInputFocus = this.onDidChangeOutputInputFocusEmitter.event;
        this.renderers = new Map();
        this._ready = new promise_util_1.Deferred();
        this._findWidgetVisible = false;
        this._findWidgetRef = React.createRef();
        this.scrollBarRef = React.createRef();
        this.debounceFind = debounce(() => {
            var _a;
            (_a = this._findWidgetRef.current) === null || _a === void 0 ? void 0 : _a.search({});
        }, 30, {
            trailing: true,
            maxWait: 100,
            leading: false
        });
    }
    get notebookType() {
        return this.props.notebookType;
    }
    get ready() {
        return this._ready.promise;
    }
    get model() {
        return this._model;
    }
    init() {
        var _a;
        this.id = exports.NOTEBOOK_EDITOR_ID_PREFIX + this.props.uri.toString();
        this.scrollOptions = {
            suppressScrollY: true
        };
        this.title.closable = true;
        this.update();
        this.toDispose.push(this.onDidChangeModelEmitter);
        this.toDispose.push(this.onDidChangeReadOnlyEmitter);
        this.renderers.set(common_1.CellKind.Markup, this.markdownCellRenderer);
        this.renderers.set(common_1.CellKind.Code, this.codeCellRenderer);
        this._ready.resolve(this.waitForData());
        this.ready.then(model => {
            if (model.cells.length === 1 && model.cells[0].source === '') {
                this.commandRegistry.executeCommand(notebook_cell_actions_contribution_1.NotebookCellCommands.EDIT_COMMAND.id, model, model.cells[0]);
                model.setSelectedCell(model.cells[0]);
            }
            model.onDidChangeContent(changeEvents => {
                const cellEvent = changeEvents.filter(event => event.kind === common_1.NotebookCellsChangeType.Move || event.kind === common_1.NotebookCellsChangeType.ModelChange);
                if (cellEvent.length > 0) {
                    this.cellOutputWebview.cellsChanged(cellEvent);
                }
            });
        });
        (_a = this.props.error) === null || _a === void 0 ? void 0 : _a.then(error => {
            this.error = error;
            this.update();
        });
    }
    async waitForData() {
        this._model = await this.props.notebookData;
        this.cellOutputWebview.init(this._model, this);
        this.saveable.delegate = this._model;
        this.toDispose.push(this._model);
        this.toDispose.push(this._model.onDidChangeContent(() => {
            // Update the scroll bar content after the content has changed
            // Wait one frame to ensure that the content has been rendered
            (0, browser_1.animationFrame)().then(() => { var _a; return (_a = this.scrollBarRef.current) === null || _a === void 0 ? void 0 : _a.updateScroll(); });
        }));
        this.toDispose.push(this._model.onContentChanged(() => {
            if (this._findWidgetVisible) {
                this.debounceFind();
            }
        }));
        this.toDispose.push(this._model.onDidChangeReadOnly(readOnly => {
            if (readOnly) {
                (0, browser_1.lock)(this.title);
            }
            else {
                (0, browser_1.unlock)(this.title);
            }
            this.onDidChangeReadOnlyEmitter.fire(readOnly);
            this.update();
        }));
        if (this._model.readOnly) {
            (0, browser_1.lock)(this.title);
        }
        // Ensure that the model is loaded before adding the editor
        this.notebookEditorService.addNotebookEditor(this);
        this._model.selectedCell = this._model.cells[0];
        this.update();
        this.notebookContextManager.init(this);
        return this._model;
    }
    onActivateRequest(msg) {
        var _a;
        super.onActivateRequest(msg);
        (_a = this.node.getElementsByClassName('theia-notebook-main-container')[0]) === null || _a === void 0 ? void 0 : _a.focus();
    }
    getResourceUri() {
        return this.props.uri;
    }
    createMoveToUri(resourceUri) {
        var _a;
        return (_a = this.model) === null || _a === void 0 ? void 0 : _a.uri.withPath(resourceUri.path);
    }
    undo() {
        var _a;
        (_a = this._model) === null || _a === void 0 ? void 0 : _a.undo();
    }
    redo() {
        var _a;
        (_a = this._model) === null || _a === void 0 ? void 0 : _a.redo();
    }
    render() {
        if (this._model) {
            return React.createElement("div", { className: 'theia-notebook-main-container', tabIndex: -1 },
                React.createElement("div", { className: 'theia-notebook-overlay' },
                    React.createElement(notebook_find_widget_1.NotebookFindWidget, { ref: this._findWidgetRef, hidden: !this._findWidgetVisible, onClose: () => {
                            var _a;
                            this._findWidgetVisible = false;
                            (_a = this._model) === null || _a === void 0 ? void 0 : _a.findMatches({
                                activeFilters: [],
                                matchCase: false,
                                regex: false,
                                search: '',
                                wholeWord: false
                            });
                            this.update();
                        }, onSearch: options => { var _a, _b; return (_b = (_a = this._model) === null || _a === void 0 ? void 0 : _a.findMatches(options)) !== null && _b !== void 0 ? _b : []; }, onReplace: (matches, replaceText) => { var _a; return (_a = this._model) === null || _a === void 0 ? void 0 : _a.replaceAll(matches, replaceText); } })),
                this.notebookMainToolbarRenderer.render(this._model, this.node),
                React.createElement("div", { className: 'theia-notebook-viewport', ref: (ref) => this.viewportService.viewportElement = ref },
                    React.createElement(PerfectScrollbar, { className: 'theia-notebook-scroll-container', ref: this.scrollBarRef, onScrollY: (e) => this.viewportService.onScroll(e) },
                        React.createElement("div", { className: 'theia-notebook-scroll-area' },
                            this.cellOutputWebview.render(),
                            React.createElement(notebook_cell_list_view_1.NotebookCellListView, { renderers: this.renderers, notebookModel: this._model, notebookContext: this.notebookContextManager, toolbarRenderer: this.cellToolbarFactory, commandRegistry: this.commandRegistry, menuRegistry: this.menuRegistry })))));
        }
        else if (this.error) {
            return React.createElement("div", { className: 'theia-notebook-main-container error-message', tabIndex: -1 },
                React.createElement("span", { className: (0, browser_1.codicon)('error') }),
                React.createElement("h3", null, core_1.nls.localizeByDefault('The editor could not be opened because the file was not found.')));
        }
        else {
            return React.createElement("div", { className: 'theia-notebook-main-container', tabIndex: -1 },
                React.createElement("div", { className: 'theia-notebook-main-loading-indicator' }));
        }
    }
    onCloseRequest(msg) {
        super.onCloseRequest(msg);
        this.notebookEditorService.removeNotebookEditor(this);
    }
    requestOuputPresentationChange(cellHandle, output) {
        if (output) {
            this.cellOutputWebview.requestOutputPresentationUpdate(cellHandle, output);
        }
    }
    postKernelMessage(message) {
        this.onDidPostKernelMessageEmitter.fire(message);
    }
    postRendererMessage(rendererId, message) {
        this.onPostRendererMessageEmitter.fire({ rendererId, message });
    }
    recieveKernelMessage(message) {
        this.onDidReceiveKernelMessageEmitter.fire(message);
    }
    outputInputFocusChanged(focused) {
        this.onDidChangeOutputInputFocusEmitter.fire(focused);
    }
    showFindWidget() {
        var _a, _b;
        if (!this._findWidgetVisible) {
            this._findWidgetVisible = true;
            this.update();
        }
        (_a = this._findWidgetRef.current) === null || _a === void 0 ? void 0 : _a.focusSearch((_b = this._model) === null || _b === void 0 ? void 0 : _b.selectedText);
    }
    dispose() {
        var _a;
        this.cellOutputWebview.dispose();
        this.notebookContextManager.dispose();
        this.onDidChangeModelEmitter.dispose();
        this.onDidPostKernelMessageEmitter.dispose();
        this.onDidReceiveKernelMessageEmitter.dispose();
        this.onPostRendererMessageEmitter.dispose();
        this.onDidChangeOutputInputFocusEmitter.dispose();
        this.viewportService.dispose();
        (_a = this._model) === null || _a === void 0 ? void 0 : _a.dispose();
        super.dispose();
    }
    onAfterShow(msg) {
        super.onAfterShow(msg);
        this.notebookEditorService.notebookEditorFocusChanged(this, true);
    }
    onAfterHide(msg) {
        super.onAfterHide(msg);
        this.notebookEditorService.notebookEditorFocusChanged(this, false);
    }
};
exports.NotebookEditorWidget = NotebookEditorWidget;
NotebookEditorWidget.ID = 'notebook';
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_cell_toolbar_factory_1.NotebookCellToolbarFactory),
    tslib_1.__metadata("design:type", notebook_cell_toolbar_factory_1.NotebookCellToolbarFactory)
], NotebookEditorWidget.prototype, "cellToolbarFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.CommandRegistry),
    tslib_1.__metadata("design:type", core_1.CommandRegistry)
], NotebookEditorWidget.prototype, "commandRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.MenuModelRegistry),
    tslib_1.__metadata("design:type", core_1.MenuModelRegistry)
], NotebookEditorWidget.prototype, "menuRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_editor_widget_service_1.NotebookEditorWidgetService),
    tslib_1.__metadata("design:type", notebook_editor_widget_service_1.NotebookEditorWidgetService)
], NotebookEditorWidget.prototype, "notebookEditorService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_main_toolbar_1.NotebookMainToolbarRenderer),
    tslib_1.__metadata("design:type", notebook_main_toolbar_1.NotebookMainToolbarRenderer)
], NotebookEditorWidget.prototype, "notebookMainToolbarRenderer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_context_manager_1.NotebookContextManager),
    tslib_1.__metadata("design:type", notebook_context_manager_1.NotebookContextManager)
], NotebookEditorWidget.prototype, "notebookContextManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_code_cell_view_1.NotebookCodeCellRenderer),
    tslib_1.__metadata("design:type", notebook_code_cell_view_1.NotebookCodeCellRenderer)
], NotebookEditorWidget.prototype, "codeCellRenderer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_markdown_cell_view_1.NotebookMarkdownCellRenderer),
    tslib_1.__metadata("design:type", notebook_markdown_cell_view_1.NotebookMarkdownCellRenderer)
], NotebookEditorWidget.prototype, "markdownCellRenderer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(exports.NotebookEditorProps),
    tslib_1.__metadata("design:type", Object)
], NotebookEditorWidget.prototype, "props", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_viewport_service_1.NotebookViewportService),
    tslib_1.__metadata("design:type", notebook_viewport_service_1.NotebookViewportService)
], NotebookEditorWidget.prototype, "viewportService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(cell_output_webview_1.CellOutputWebview),
    tslib_1.__metadata("design:type", Object)
], NotebookEditorWidget.prototype, "cellOutputWebview", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], NotebookEditorWidget.prototype, "init", null);
exports.NotebookEditorWidget = NotebookEditorWidget = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookEditorWidget);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/notebook-open-handler.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/notebook-open-handler.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookOpenHandler = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const notebook_editor_widget_1 = __webpack_require__(/*! ./notebook-editor-widget */ "../../node_modules/@theia/notebook/lib/browser/notebook-editor-widget.js");
const glob_1 = __webpack_require__(/*! @theia/core/lib/common/glob */ "../../node_modules/@theia/core/lib/common/glob.js");
let NotebookOpenHandler = class NotebookOpenHandler extends browser_1.NavigatableWidgetOpenHandler {
    constructor() {
        super(...arguments);
        this.id = notebook_editor_widget_1.NotebookEditorWidget.ID;
        this.notebookTypes = [];
    }
    registerNotebookType(notebookType) {
        this.notebookTypes.push(notebookType);
        return core_1.Disposable.create(() => {
            this.notebookTypes.splice(this.notebookTypes.indexOf(notebookType), 1);
        });
    }
    canHandle(uri, options) {
        const defaultHandler = (0, browser_1.getDefaultHandler)(uri, this.preferenceService);
        if (options === null || options === void 0 ? void 0 : options.notebookType) {
            return this.canHandleType(uri, this.notebookTypes.find(type => type.type === options.notebookType), defaultHandler);
        }
        return Math.max(...this.notebookTypes.map(type => this.canHandleType(uri, type), defaultHandler));
    }
    canHandleType(uri, notebookType, defaultHandler) {
        if ((notebookType === null || notebookType === void 0 ? void 0 : notebookType.selector) && this.matches(notebookType.selector, uri)) {
            return notebookType.type === defaultHandler ? browser_1.defaultHandlerPriority : this.calculatePriority(notebookType);
        }
        else {
            return 0;
        }
    }
    calculatePriority(notebookType) {
        if (!notebookType) {
            return 0;
        }
        return notebookType.priority === 'option' ? 100 : 200;
    }
    findHighestPriorityType(uri) {
        const matchingTypes = this.notebookTypes
            .filter(notebookType => notebookType.selector && this.matches(notebookType.selector, uri))
            .map(notebookType => ({ descriptor: notebookType, priority: this.calculatePriority(notebookType) }));
        if (matchingTypes.length === 0) {
            return undefined;
        }
        let type = matchingTypes[0];
        for (let i = 1; i < matchingTypes.length; i++) {
            const notebookType = matchingTypes[i];
            if (notebookType.priority > type.priority) {
                type = notebookType;
            }
        }
        return type.descriptor;
    }
    // Override for better options typing
    open(uri, options) {
        return super.open(uri, options);
    }
    createWidgetOptions(uri, options) {
        const widgetOptions = super.createWidgetOptions(uri, options);
        if (options === null || options === void 0 ? void 0 : options.notebookType) {
            return {
                notebookType: options.notebookType,
                ...widgetOptions
            };
        }
        const defaultHandler = (0, browser_1.getDefaultHandler)(uri, this.preferenceService);
        const notebookType = this.notebookTypes.find(type => type.type === defaultHandler)
            || this.findHighestPriorityType(uri);
        if (!notebookType) {
            throw new Error('No notebook types registered for uri: ' + uri.toString());
        }
        return {
            notebookType: notebookType.type,
            ...widgetOptions
        };
    }
    matches(selectors, resource) {
        return selectors.some(selector => this.selectorMatches(selector, resource));
    }
    selectorMatches(selector, resource) {
        return !!selector.filenamePattern
            && (0, glob_1.match)(selector.filenamePattern, resource.path.name + resource.path.ext);
    }
};
exports.NotebookOpenHandler = NotebookOpenHandler;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], NotebookOpenHandler.prototype, "preferenceService", void 0);
exports.NotebookOpenHandler = NotebookOpenHandler = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookOpenHandler);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/notebook-output-utils.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/notebook-output-utils.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *  Copied from commit 18b2c92451b076943e5b508380e0eba66ba7d934 from file src\vs\workbench\contrib\notebook\common\notebookCommon.ts
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MOVE_CURSOR_1_LINE_COMMAND = exports.compressOutputItemStreams = void 0;
const buffer_1 = __webpack_require__(/*! @theia/core/lib/common/buffer */ "../../node_modules/@theia/core/lib/common/buffer.js");
const textDecoder = new TextDecoder();
/**
 * Given a stream of individual stdout outputs, this function will return the compressed lines, escaping some of the common terminal escape codes.
 * E.g. some terminal escape codes would result in the previous line getting cleared, such if we had 3 lines and
 * last line contained such a code, then the result string would be just the first two lines.
 * @returns a single VSBuffer with the concatenated and compressed data, and whether any compression was done.
 */
function compressOutputItemStreams(outputs) {
    const buffers = [];
    let startAppending = false;
    // Pick the first set of outputs with the same mime type.
    for (const output of outputs) {
        if ((buffers.length === 0 || startAppending)) {
            buffers.push(output);
            startAppending = true;
        }
    }
    let didCompression = compressStreamBuffer(buffers);
    const concatenated = buffer_1.BinaryBuffer.concat(buffers.map(buffer => buffer_1.BinaryBuffer.wrap(buffer)));
    const data = formatStreamText(concatenated);
    didCompression = didCompression || data.byteLength !== concatenated.byteLength;
    return { data, didCompression };
}
exports.compressOutputItemStreams = compressOutputItemStreams;
exports.MOVE_CURSOR_1_LINE_COMMAND = `${String.fromCharCode(27)}[A`;
const MOVE_CURSOR_1_LINE_COMMAND_BYTES = exports.MOVE_CURSOR_1_LINE_COMMAND.split('').map(c => c.charCodeAt(0));
const LINE_FEED = 10;
function compressStreamBuffer(streams) {
    let didCompress = false;
    streams.forEach((stream, index) => {
        if (index === 0 || stream.length < exports.MOVE_CURSOR_1_LINE_COMMAND.length) {
            return;
        }
        const previousStream = streams[index - 1];
        // Remove the previous line if required.
        const command = stream.subarray(0, exports.MOVE_CURSOR_1_LINE_COMMAND.length);
        if (command[0] === MOVE_CURSOR_1_LINE_COMMAND_BYTES[0] && command[1] === MOVE_CURSOR_1_LINE_COMMAND_BYTES[1] && command[2] === MOVE_CURSOR_1_LINE_COMMAND_BYTES[2]) {
            const lastIndexOfLineFeed = previousStream.lastIndexOf(LINE_FEED);
            if (lastIndexOfLineFeed === -1) {
                return;
            }
            didCompress = true;
            streams[index - 1] = previousStream.subarray(0, lastIndexOfLineFeed);
            streams[index] = stream.subarray(exports.MOVE_CURSOR_1_LINE_COMMAND.length);
        }
    });
    return didCompress;
}
const BACKSPACE_CHARACTER = '\b'.charCodeAt(0);
const CARRIAGE_RETURN_CHARACTER = '\r'.charCodeAt(0);
function formatStreamText(buffer) {
    // We have special handling for backspace and carriage return characters.
    // Don't unnecessary decode the bytes if we don't need to perform any processing.
    if (!buffer.buffer.includes(BACKSPACE_CHARACTER) && !buffer.buffer.includes(CARRIAGE_RETURN_CHARACTER)) {
        return buffer;
    }
    // Do the same thing jupyter is doing
    return buffer_1.BinaryBuffer.fromString(fixCarriageReturn(fixBackspace(textDecoder.decode(buffer.buffer))));
}
/**
 * Took this from jupyter/notebook
 * https://github.com/jupyter/notebook/blob/b8b66332e2023e83d2ee04f83d8814f567e01a4e/notebook/static/base/js/utils.js
 * Remove characters that are overridden by backspace characters
 */
function fixBackspace(txt) {
    let tmp = txt;
    do {
        txt = tmp;
        // Cancel out anything-but-newline followed by backspace
        tmp = txt.replace(/[^\n]\x08/gm, '');
    } while (tmp.length < txt.length);
    return txt;
}
/**
 * Remove chunks that should be overridden by the effect of carriage return characters
 * From https://github.com/jupyter/notebook/blob/master/notebook/static/base/js/utils.js
 */
function fixCarriageReturn(txt) {
    txt = txt.replace(/\r+\n/gm, '\n'); // \r followed by \n --> newline
    while (txt.search(/\r[^$]/g) > -1) {
        const base = txt.match(/^(.*)\r+/m)[1];
        let insert = txt.match(/\r+(.*)$/m)[1];
        insert = insert + base.slice(insert.length, base.length);
        txt = txt.replace(/\r+.*$/m, '\r').replace(/^.*\r/m, insert);
    }
    return txt;
}


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/notebook-renderer-registry.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/notebook-renderer-registry.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookRendererRegistry = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
let NotebookRendererRegistry = class NotebookRendererRegistry {
    constructor() {
        this._notebookRenderers = [];
        this._staticNotebookPreloads = [];
    }
    get notebookRenderers() {
        return this._notebookRenderers;
    }
    get staticNotebookPreloads() {
        return this._staticNotebookPreloads;
    }
    registerNotebookRenderer(type, basePath) {
        let entrypoint;
        if (typeof type.entrypoint === 'string') {
            entrypoint = {
                uri: new core_1.Path(basePath).join(type.entrypoint).toString()
            };
        }
        else {
            entrypoint = {
                uri: new core_1.Path(basePath).join(type.entrypoint.path).toString(),
                extends: type.entrypoint.extends
            };
        }
        this._notebookRenderers.push({
            ...type,
            mimeTypes: type.mimeTypes || [],
            requiresMessaging: type.requiresMessaging === 'always' || type.requiresMessaging === 'optional',
            entrypoint
        });
        return core_1.Disposable.create(() => {
            this._notebookRenderers.splice(this._notebookRenderers.findIndex(renderer => renderer.id === type.id), 1);
        });
    }
    registerStaticNotebookPreload(type, entrypoint, basePath) {
        const staticPreload = { type, entrypoint: new core_1.Path(basePath).join(entrypoint).toString() };
        this._staticNotebookPreloads.push(staticPreload);
        return core_1.Disposable.create(() => {
            this._staticNotebookPreloads.splice(this._staticNotebookPreloads.indexOf(staticPreload), 1);
        });
    }
};
exports.NotebookRendererRegistry = NotebookRendererRegistry;
exports.NotebookRendererRegistry = NotebookRendererRegistry = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookRendererRegistry);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/notebook-type-registry.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/notebook-type-registry.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookTypeRegistry = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const notebook_open_handler_1 = __webpack_require__(/*! ./notebook-open-handler */ "../../node_modules/@theia/notebook/lib/browser/notebook-open-handler.js");
let NotebookTypeRegistry = class NotebookTypeRegistry {
    constructor() {
        this._notebookTypes = [];
    }
    get notebookTypes() {
        return this._notebookTypes;
    }
    registerNotebookType(type, providerName) {
        const toDispose = new core_1.DisposableCollection();
        toDispose.push(core_1.Disposable.create(() => {
            this._notebookTypes.splice(this._notebookTypes.indexOf(type), 1);
        }));
        this._notebookTypes.push(type);
        toDispose.push(this.notebookOpenHandler.registerNotebookType(type));
        toDispose.push(this.openWithService.registerHandler({
            id: type.type,
            label: type.displayName,
            providerName,
            canHandle: uri => this.notebookOpenHandler.canHandleType(uri, type),
            open: uri => this.notebookOpenHandler.open(uri, { notebookType: type.type })
        }));
        return toDispose;
    }
};
exports.NotebookTypeRegistry = NotebookTypeRegistry;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenWithService),
    tslib_1.__metadata("design:type", browser_1.OpenWithService)
], NotebookTypeRegistry.prototype, "openWithService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_open_handler_1.NotebookOpenHandler),
    tslib_1.__metadata("design:type", notebook_open_handler_1.NotebookOpenHandler)
], NotebookTypeRegistry.prototype, "notebookOpenHandler", void 0);
exports.NotebookTypeRegistry = NotebookTypeRegistry = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookTypeRegistry);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/renderers/cell-output-webview.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/renderers/cell-output-webview.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CellOutputWebview = exports.CellOutputWebviewFactory = void 0;
exports.CellOutputWebviewFactory = Symbol('outputWebviewFactory');
exports.CellOutputWebview = Symbol('outputWebview');


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/service/notebook-cell-editor-service.js":
/*!**********************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/service/notebook-cell-editor-service.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 Typefox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookCellEditorService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const notebook_editor_widget_service_1 = __webpack_require__(/*! ./notebook-editor-widget-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-editor-widget-service.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/notebook/lib/common/index.js");
let NotebookCellEditorService = class NotebookCellEditorService {
    constructor() {
        this.onDidChangeCellEditorsEmitter = new core_1.Emitter();
        this.onDidChangeCellEditors = this.onDidChangeCellEditorsEmitter.event;
        this.onDidChangeFocusedCellEditorEmitter = new core_1.Emitter();
        this.onDidChangeFocusedCellEditor = this.onDidChangeFocusedCellEditorEmitter.event;
        this.currentCellEditors = new Map();
    }
    init() {
        this.notebookEditorWidgetService.onDidChangeCurrentEditor(editor => {
            var _a, _b;
            // if defocus notebook editor or another notebook editor is focused, clear the active cell
            if (!editor || (this.currentActiveCell && ((_a = common_1.CellUri.parse(this.currentActiveCell.uri)) === null || _a === void 0 ? void 0 : _a.notebook.toString()) !== ((_b = editor === null || editor === void 0 ? void 0 : editor.model) === null || _b === void 0 ? void 0 : _b.uri.toString()))) {
                this.currentActiveCell = undefined;
                this.onDidChangeFocusedCellEditorEmitter.fire(undefined);
            }
        });
    }
    get allCellEditors() {
        return Array.from(this.currentCellEditors.values());
    }
    editorCreated(uri, editor) {
        this.currentCellEditors.set(uri.toString(), editor);
        this.onDidChangeCellEditorsEmitter.fire();
    }
    editorDisposed(uri) {
        this.currentCellEditors.delete(uri.toString());
        this.onDidChangeCellEditorsEmitter.fire();
    }
    editorFocusChanged(editor) {
        if (editor) {
            this.currentActiveCell = editor;
            this.onDidChangeFocusedCellEditorEmitter.fire(editor);
        }
    }
    getActiveCell() {
        return this.currentActiveCell;
    }
};
exports.NotebookCellEditorService = NotebookCellEditorService;
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_editor_widget_service_1.NotebookEditorWidgetService),
    tslib_1.__metadata("design:type", notebook_editor_widget_service_1.NotebookEditorWidgetService)
], NotebookCellEditorService.prototype, "notebookEditorWidgetService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], NotebookCellEditorService.prototype, "init", null);
exports.NotebookCellEditorService = NotebookCellEditorService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookCellEditorService);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/service/notebook-cell-status-bar-service.js":
/*!**************************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/service/notebook-cell-status-bar-service.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookCellStatusBarService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
let NotebookCellStatusBarService = class NotebookCellStatusBarService {
    constructor() {
        this.onDidChangeProvidersEmitter = new core_1.Emitter();
        this.onDidChangeProviders = this.onDidChangeProvidersEmitter.event;
        this.onDidChangeItemsEmitter = new core_1.Emitter();
        this.onDidChangeItems = this.onDidChangeItemsEmitter.event;
        this.providers = [];
    }
    registerCellStatusBarItemProvider(provider) {
        this.providers.push(provider);
        let changeListener;
        if (provider.onDidChangeStatusBarItems) {
            changeListener = provider.onDidChangeStatusBarItems(() => this.onDidChangeItemsEmitter.fire());
        }
        this.onDidChangeProvidersEmitter.fire();
        return core_1.Disposable.create(() => {
            changeListener === null || changeListener === void 0 ? void 0 : changeListener.dispose();
            const idx = this.providers.findIndex(p => p === provider);
            this.providers.splice(idx, 1);
        });
    }
    async getStatusBarItemsForCell(notebookUri, cellIndex, viewType, token) {
        const providers = this.providers.filter(p => p.viewType === viewType || p.viewType === '*');
        return Promise.all(providers.map(async (p) => {
            var _a;
            try {
                return (_a = await p.provideCellStatusBarItems(notebookUri, cellIndex, token)) !== null && _a !== void 0 ? _a : { items: [] };
            }
            catch (e) {
                console.error(e);
                return { items: [] };
            }
        }));
    }
    dispose() {
        this.onDidChangeItemsEmitter.dispose();
        this.onDidChangeProvidersEmitter.dispose();
    }
};
exports.NotebookCellStatusBarService = NotebookCellStatusBarService;
exports.NotebookCellStatusBarService = NotebookCellStatusBarService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookCellStatusBarService);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/service/notebook-clipboard-service.js":
/*!********************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/service/notebook-clipboard-service.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 Typefox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookClipboardService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const clipboard_service_1 = __webpack_require__(/*! @theia/core/lib/browser/clipboard-service */ "../../node_modules/@theia/core/lib/browser/clipboard-service.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
let NotebookClipboardService = class NotebookClipboardService {
    copyCell(cell) {
        this.copiedCell = cell.getData();
        if (core_1.environment.electron.is()) {
            this.clipboardService.writeText(cell.text);
        }
    }
    getCell() {
        return this.copiedCell;
    }
};
exports.NotebookClipboardService = NotebookClipboardService;
tslib_1.__decorate([
    (0, inversify_1.inject)(clipboard_service_1.ClipboardService),
    tslib_1.__metadata("design:type", Object)
], NotebookClipboardService.prototype, "clipboardService", void 0);
exports.NotebookClipboardService = NotebookClipboardService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookClipboardService);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/service/notebook-context-manager.js":
/*!******************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/service/notebook-context-manager.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookContextManager = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const notebook_kernel_service_1 = __webpack_require__(/*! ./notebook-kernel-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-kernel-service.js");
const notebook_context_keys_1 = __webpack_require__(/*! ../contributions/notebook-context-keys */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-context-keys.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/notebook/lib/common/index.js");
const notebook_execution_state_service_1 = __webpack_require__(/*! ./notebook-execution-state-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-execution-state-service.js");
let NotebookContextManager = class NotebookContextManager {
    constructor() {
        this.toDispose = new core_1.DisposableCollection();
        this.onDidChangeContextEmitter = new core_1.Emitter();
        this.onDidChangeContext = this.onDidChangeContextEmitter.event;
        this.cellContexts = new Map();
        this.cellDisposables = new core_1.DisposableCollection();
    }
    get context() {
        return this._context;
    }
    init(widget) {
        var _a, _b, _c, _d, _e;
        this._context = widget.node;
        this.scopedStore = this.contextKeyService.createScoped(widget.node);
        this.toDispose.dispose();
        this.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_VIEW_TYPE, widget === null || widget === void 0 ? void 0 : widget.notebookType);
        // Kernel related keys
        const kernel = (widget === null || widget === void 0 ? void 0 : widget.model) ? this.notebookKernelService.getSelectedNotebookKernel(widget.model) : undefined;
        this.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_KERNEL_SELECTED, !!kernel);
        this.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_KERNEL, kernel === null || kernel === void 0 ? void 0 : kernel.id);
        this.toDispose.push(this.notebookKernelService.onDidChangeSelectedKernel(e => {
            var _a;
            if (e.notebook.toString() === ((_a = widget === null || widget === void 0 ? void 0 : widget.getResourceUri()) === null || _a === void 0 ? void 0 : _a.toString())) {
                this.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_KERNEL_SELECTED, !!e.newKernel);
                this.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_KERNEL, e.newKernel);
                this.onDidChangeContextEmitter.fire(this.createContextKeyChangedEvent([notebook_context_keys_1.NOTEBOOK_KERNEL_SELECTED, notebook_context_keys_1.NOTEBOOK_KERNEL]));
            }
        }));
        (_a = widget.model) === null || _a === void 0 ? void 0 : _a.onDidChangeContent(events => {
            var _a;
            if (events.some(e => e.kind === common_1.NotebookCellsChangeType.ModelChange || e.kind === common_1.NotebookCellsChangeType.Output)) {
                this.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_HAS_OUTPUTS, (_a = widget.model) === null || _a === void 0 ? void 0 : _a.cells.some(cell => cell.outputs.length > 0));
                this.onDidChangeContextEmitter.fire(this.createContextKeyChangedEvent([notebook_context_keys_1.NOTEBOOK_HAS_OUTPUTS]));
            }
        });
        this.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_HAS_OUTPUTS, !!((_b = widget.model) === null || _b === void 0 ? void 0 : _b.cells.find(cell => cell.outputs.length > 0)));
        // Cell Selection related keys
        this.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_CELL_FOCUSED, !!((_c = widget.model) === null || _c === void 0 ? void 0 : _c.selectedCell));
        this.selectedCellChanged((_d = widget.model) === null || _d === void 0 ? void 0 : _d.selectedCell);
        (_e = widget.model) === null || _e === void 0 ? void 0 : _e.onDidChangeSelectedCell(e => {
            this.selectedCellChanged(e.cell);
            this.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_CELL_FOCUSED, !!e);
            this.onDidChangeContextEmitter.fire(this.createContextKeyChangedEvent([notebook_context_keys_1.NOTEBOOK_CELL_FOCUSED]));
        });
        this.toDispose.push(this.executionStateService.onDidChangeExecution(e => {
            var _a, _b, _c;
            if (e.notebook.toString() === ((_a = widget.model) === null || _a === void 0 ? void 0 : _a.uri.toString())) {
                this.setCellContext(e.cellHandle, notebook_context_keys_1.NOTEBOOK_CELL_EXECUTING, !!e.changed);
                this.setCellContext(e.cellHandle, notebook_context_keys_1.NOTEBOOK_CELL_EXECUTION_STATE, (_c = (_b = e.changed) === null || _b === void 0 ? void 0 : _b.state) !== null && _c !== void 0 ? _c : 'idle');
                this.onDidChangeContextEmitter.fire(this.createContextKeyChangedEvent([notebook_context_keys_1.NOTEBOOK_CELL_EXECUTING, notebook_context_keys_1.NOTEBOOK_CELL_EXECUTION_STATE]));
            }
        }));
        widget.onDidChangeOutputInputFocus(focus => {
            this.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_OUTPUT_INPUT_FOCUSED, focus);
            this.onDidChangeContextEmitter.fire(this.createContextKeyChangedEvent([notebook_context_keys_1.NOTEBOOK_OUTPUT_INPUT_FOCUSED]));
        });
        this.onDidChangeContextEmitter.fire(this.createContextKeyChangedEvent([notebook_context_keys_1.NOTEBOOK_VIEW_TYPE, notebook_context_keys_1.NOTEBOOK_KERNEL_SELECTED, notebook_context_keys_1.NOTEBOOK_KERNEL]));
    }
    selectedCellChanged(cell) {
        this.cellDisposables.dispose();
        this.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_CELL_TYPE, cell ? cell.cellKind === common_1.CellKind.Code ? 'code' : 'markdown' : undefined);
        if (cell) {
            this.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_CELL_MARKDOWN_EDIT_MODE, cell.editing);
            this.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_CELL_EDITABLE, cell.cellKind === common_1.CellKind.Markup && !cell.editing);
            this.cellDisposables.push(cell.onDidRequestCellEditChange(cellEdit => {
                this.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_CELL_MARKDOWN_EDIT_MODE, cellEdit);
                this.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_CELL_EDITABLE, cell.cellKind === common_1.CellKind.Markup && !cellEdit);
                this.onDidChangeContextEmitter.fire(this.createContextKeyChangedEvent([notebook_context_keys_1.NOTEBOOK_CELL_MARKDOWN_EDIT_MODE]));
            }));
        }
        this.onDidChangeContextEmitter.fire(this.createContextKeyChangedEvent([notebook_context_keys_1.NOTEBOOK_CELL_TYPE]));
    }
    setCellContext(cellHandle, key, value) {
        let cellContext = this.cellContexts.get(cellHandle);
        if (!cellContext) {
            cellContext = {};
            this.cellContexts.set(cellHandle, cellContext);
        }
        cellContext[key] = value;
    }
    getCellContext(cellHandle) {
        var _a;
        return this.contextKeyService.createOverlay(Object.entries((_a = this.cellContexts.get(cellHandle)) !== null && _a !== void 0 ? _a : {}));
    }
    changeCellFocus(focus) {
        this.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_CELL_FOCUSED, focus);
    }
    changeCellListFocus(focus) {
        this.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_CELL_LIST_FOCUSED, focus);
    }
    createContextKeyChangedEvent(affectedKeys) {
        return { affects: keys => affectedKeys.some(key => keys.has(key)) };
    }
    dispose() {
        this.toDispose.dispose();
    }
};
exports.NotebookContextManager = NotebookContextManager;
tslib_1.__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    tslib_1.__metadata("design:type", Object)
], NotebookContextManager.prototype, "contextKeyService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_kernel_service_1.NotebookKernelService),
    tslib_1.__metadata("design:type", notebook_kernel_service_1.NotebookKernelService)
], NotebookContextManager.prototype, "notebookKernelService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_execution_state_service_1.NotebookExecutionStateService),
    tslib_1.__metadata("design:type", notebook_execution_state_service_1.NotebookExecutionStateService)
], NotebookContextManager.prototype, "executionStateService", void 0);
exports.NotebookContextManager = NotebookContextManager = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookContextManager);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/service/notebook-editor-widget-service.js":
/*!************************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/service/notebook-editor-widget-service.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookEditorWidgetService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const notebook_editor_widget_1 = __webpack_require__(/*! ../notebook-editor-widget */ "../../node_modules/@theia/notebook/lib/browser/notebook-editor-widget.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
const notebook_context_keys_1 = __webpack_require__(/*! ../contributions/notebook-context-keys */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-context-keys.js");
let NotebookEditorWidgetService = class NotebookEditorWidgetService {
    constructor() {
        this.notebookEditors = new Map();
        this.onNotebookEditorAddEmitter = new core_1.Emitter();
        this.onNotebookEditorRemoveEmitter = new core_1.Emitter();
        this.onDidAddNotebookEditor = this.onNotebookEditorAddEmitter.event;
        this.onDidRemoveNotebookEditor = this.onNotebookEditorRemoveEmitter.event;
        this.onDidChangeFocusedEditorEmitter = new core_1.Emitter();
        this.onDidChangeFocusedEditor = this.onDidChangeFocusedEditorEmitter.event;
        this.onDidChangeCurrentEditorEmitter = new core_1.Emitter();
        this.onDidChangeCurrentEditor = this.onDidChangeCurrentEditorEmitter.event;
        this.focusedEditor = undefined;
        this.currentEditor = undefined;
    }
    init() {
        this.applicationShell.onDidChangeActiveWidget(event => {
            this.notebookEditorFocusChanged(event.newValue, event.newValue instanceof notebook_editor_widget_1.NotebookEditorWidget);
        });
        this.applicationShell.onDidChangeCurrentWidget(event => {
            if (event.newValue instanceof notebook_editor_widget_1.NotebookEditorWidget || event.oldValue instanceof notebook_editor_widget_1.NotebookEditorWidget) {
                this.currentNotebookEditorChanged(event.newValue);
            }
        });
    }
    // --- editor management
    addNotebookEditor(editor) {
        if (this.notebookEditors.has(editor.id)) {
            console.warn('Attempting to add duplicated notebook editor: ' + editor.id);
        }
        this.notebookEditors.set(editor.id, editor);
        this.onNotebookEditorAddEmitter.fire(editor);
        if (editor.isVisible) {
            this.notebookEditorFocusChanged(editor, true);
        }
    }
    removeNotebookEditor(editor) {
        if (this.notebookEditors.has(editor.id)) {
            this.notebookEditors.delete(editor.id);
            this.onNotebookEditorRemoveEmitter.fire(editor);
        }
        else {
            console.warn('Attempting to remove not registered editor: ' + editor.id);
        }
    }
    getNotebookEditor(editorId) {
        return this.notebookEditors.get(editorId);
    }
    getNotebookEditors() {
        return Array.from(this.notebookEditors.values());
    }
    notebookEditorFocusChanged(editor, focus) {
        if (focus) {
            if (editor !== this.focusedEditor) {
                this.focusedEditor = editor;
                this.contextKeyService.setContext(notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED, true);
                this.onDidChangeFocusedEditorEmitter.fire(this.focusedEditor);
            }
        }
        else if (this.focusedEditor) {
            this.focusedEditor = undefined;
            this.contextKeyService.setContext(notebook_context_keys_1.NOTEBOOK_EDITOR_FOCUSED, false);
            this.onDidChangeFocusedEditorEmitter.fire(undefined);
        }
    }
    currentNotebookEditorChanged(newEditor) {
        var _a, _b;
        if (newEditor instanceof notebook_editor_widget_1.NotebookEditorWidget) {
            this.currentEditor = newEditor;
            this.onDidChangeCurrentEditorEmitter.fire(newEditor);
        }
        else if (((_a = this.currentEditor) === null || _a === void 0 ? void 0 : _a.isDisposed) || !((_b = this.currentEditor) === null || _b === void 0 ? void 0 : _b.isVisible)) {
            this.currentEditor = undefined;
            this.onDidChangeCurrentEditorEmitter.fire(undefined);
        }
    }
};
exports.NotebookEditorWidgetService = NotebookEditorWidgetService;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ApplicationShell),
    tslib_1.__metadata("design:type", browser_1.ApplicationShell)
], NotebookEditorWidgetService.prototype, "applicationShell", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    tslib_1.__metadata("design:type", Object)
], NotebookEditorWidgetService.prototype, "contextKeyService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], NotebookEditorWidgetService.prototype, "init", null);
exports.NotebookEditorWidgetService = NotebookEditorWidgetService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookEditorWidgetService);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/service/notebook-execution-service.js":
/*!********************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/service/notebook-execution-service.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookExecutionService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const notebook_execution_state_service_1 = __webpack_require__(/*! ../service/notebook-execution-state-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-execution-state-service.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/notebook/lib/common/index.js");
const notebook_kernel_service_1 = __webpack_require__(/*! ./notebook-kernel-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-kernel-service.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const notebook_kernel_quick_pick_service_1 = __webpack_require__(/*! ./notebook-kernel-quick-pick-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-kernel-quick-pick-service.js");
const notebook_kernel_history_service_1 = __webpack_require__(/*! ./notebook-kernel-history-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-kernel-history-service.js");
let NotebookExecutionService = class NotebookExecutionService {
    constructor() {
        this.cellExecutionParticipants = new Set();
    }
    async executeNotebookCells(notebook, cells) {
        const cellsArr = Array.from(cells)
            .filter(c => c.cellKind === common_1.CellKind.Code);
        if (!cellsArr.length) {
            return;
        }
        this.logger.debug('Executing notebook cells', {
            notebook: notebook.uri.toString(),
            cells: cellsArr.map(c => c.handle)
        });
        // create cell executions
        const cellExecutions = [];
        for (const cell of cellsArr) {
            const cellExe = this.notebookExecutionStateService.getCellExecution(cell.uri);
            if (!cellExe) {
                cellExecutions.push([cell, this.notebookExecutionStateService.getOrCreateCellExecution(notebook.uri, cell.handle)]);
            }
        }
        const kernel = await this.notebookKernelHistoryService.resolveSelectedKernel(notebook);
        if (!kernel) {
            this.logger.debug('Failed to resolve kernel for execution', notebook.uri.toString());
            // clear all pending cell executions
            cellExecutions.forEach(cellExe => cellExe[1].complete({}));
            return;
        }
        // filter cell executions based on selected kernel
        const validCellExecutions = [];
        for (const [cell, cellExecution] of cellExecutions) {
            if (!kernel.supportedLanguages.includes(cell.language)) {
                cellExecution.complete({});
            }
            else {
                validCellExecutions.push(cellExecution);
            }
        }
        // request execution
        if (validCellExecutions.length > 0) {
            const cellRemoveListener = notebook.onDidAddOrRemoveCell(e => {
                if (e.rawEvent.changes.some(c => c.deleteCount > 0)) {
                    const executionsToCancel = validCellExecutions.filter(exec => !notebook.cells.find(cell => cell.handle === exec.cellHandle));
                    if (executionsToCancel.length > 0) {
                        kernel.cancelNotebookCellExecution(notebook.uri, executionsToCancel.map(c => c.cellHandle));
                        executionsToCancel.forEach(exec => exec.complete({}));
                    }
                }
            });
            await this.runExecutionParticipants(validCellExecutions);
            this.logger.debug('Selecting kernel for cell execution', {
                notebook: notebook.uri.toString(),
                kernel: kernel.id
            });
            this.notebookKernelService.selectKernelForNotebook(kernel, notebook);
            this.logger.debug('Running cell execution request', {
                notebook: notebook.uri.toString(),
                cells: validCellExecutions.map(c => c.cellHandle)
            });
            await kernel.executeNotebookCellsRequest(notebook.uri, validCellExecutions.map(c => c.cellHandle));
            // the connecting state can change before the kernel resolves executeNotebookCellsRequest
            const unconfirmed = validCellExecutions.filter(exe => exe.state === common_1.NotebookCellExecutionState.Unconfirmed);
            if (unconfirmed.length) {
                unconfirmed.forEach(exe => exe.complete({}));
            }
            cellRemoveListener.dispose();
        }
    }
    registerExecutionParticipant(participant) {
        this.cellExecutionParticipants.add(participant);
        return core_1.Disposable.create(() => this.cellExecutionParticipants.delete(participant));
    }
    async runExecutionParticipants(executions) {
        for (const participant of this.cellExecutionParticipants) {
            await participant.onWillExecuteCell(executions);
        }
        return;
    }
    async cancelNotebookCellHandles(notebook, cells) {
        const cellsArr = Array.from(cells);
        const kernel = this.notebookKernelService.getSelectedOrSuggestedKernel(notebook);
        if (kernel) {
            await kernel.cancelNotebookCellExecution(notebook.uri, cellsArr);
        }
    }
    async cancelNotebookCells(notebook, cells) {
        this.cancelNotebookCellHandles(notebook, Array.from(cells, cell => cell.handle));
    }
};
exports.NotebookExecutionService = NotebookExecutionService;
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_execution_state_service_1.NotebookExecutionStateService),
    tslib_1.__metadata("design:type", notebook_execution_state_service_1.NotebookExecutionStateService)
], NotebookExecutionService.prototype, "notebookExecutionStateService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_kernel_service_1.NotebookKernelService),
    tslib_1.__metadata("design:type", notebook_kernel_service_1.NotebookKernelService)
], NotebookExecutionService.prototype, "notebookKernelService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_kernel_history_service_1.NotebookKernelHistoryService),
    tslib_1.__metadata("design:type", notebook_kernel_history_service_1.NotebookKernelHistoryService)
], NotebookExecutionService.prototype, "notebookKernelHistoryService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.CommandService),
    tslib_1.__metadata("design:type", Object)
], NotebookExecutionService.prototype, "commandService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_kernel_quick_pick_service_1.NotebookKernelQuickPickService),
    tslib_1.__metadata("design:type", notebook_kernel_quick_pick_service_1.NotebookKernelQuickPickService)
], NotebookExecutionService.prototype, "notebookKernelQuickPickService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ILogger),
    (0, inversify_1.named)('notebook'),
    tslib_1.__metadata("design:type", Object)
], NotebookExecutionService.prototype, "logger", void 0);
exports.NotebookExecutionService = NotebookExecutionService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookExecutionService);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/service/notebook-execution-state-service.js":
/*!**************************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/service/notebook-execution-state-service.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.updateToEdit = exports.CellExecutionStateChangedEvent = exports.CellExecution = exports.NotebookExecutionStateService = exports.NotebookExecutionType = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const notebook_service_1 = __webpack_require__(/*! ./notebook-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-service.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/notebook/lib/common/index.js");
var NotebookExecutionType;
(function (NotebookExecutionType) {
    NotebookExecutionType[NotebookExecutionType["cell"] = 0] = "cell";
    NotebookExecutionType[NotebookExecutionType["notebook"] = 1] = "notebook";
})(NotebookExecutionType || (exports.NotebookExecutionType = NotebookExecutionType = {}));
let NotebookExecutionStateService = class NotebookExecutionStateService {
    constructor() {
        this.toDispose = new core_1.DisposableCollection();
        this.executions = new Map();
        this.onDidChangeExecutionEmitter = new core_1.Emitter();
        this.onDidChangeExecution = this.onDidChangeExecutionEmitter.event;
        this.onDidChangeLastRunFailStateEmitter = new core_1.Emitter();
        this.onDidChangeLastRunFailState = this.onDidChangeLastRunFailStateEmitter.event;
    }
    getOrCreateCellExecution(notebookUri, cellHandle) {
        var _a, _b;
        const notebook = this.notebookService.getNotebookEditorModel(notebookUri);
        if (!notebook) {
            throw new Error(`Notebook not found: ${notebookUri.toString()}`);
        }
        let execution = (_a = this.executions.get(notebookUri.toString())) === null || _a === void 0 ? void 0 : _a.get(cellHandle);
        if (!execution) {
            execution = this.createNotebookCellExecution(notebook, cellHandle);
            if (!this.executions.has(notebookUri.toString())) {
                this.executions.set(notebookUri.toString(), new Map());
            }
            (_b = this.executions.get(notebookUri.toString())) === null || _b === void 0 ? void 0 : _b.set(cellHandle, execution);
            execution.initialize();
            this.onDidChangeExecutionEmitter.fire(new CellExecutionStateChangedEvent(notebookUri, cellHandle, execution));
        }
        return execution;
    }
    createNotebookCellExecution(notebook, cellHandle) {
        const notebookUri = notebook.uri;
        const execution = new CellExecution(cellHandle, notebook);
        execution.toDispose.push(execution.onDidUpdate(() => this.onDidChangeExecutionEmitter.fire(new CellExecutionStateChangedEvent(notebookUri, cellHandle, execution))));
        execution.toDispose.push(execution.onDidComplete(lastRunSuccess => this.onCellExecutionDidComplete(notebookUri, cellHandle, execution, lastRunSuccess)));
        return execution;
    }
    onCellExecutionDidComplete(notebookUri, cellHandle, exe, lastRunSuccess) {
        var _a, _b;
        const notebookExecutions = (_a = this.executions.get(notebookUri.toString())) === null || _a === void 0 ? void 0 : _a.get(cellHandle);
        if (!notebookExecutions) {
            throw new Error('Notebook Cell Execution not found while trying to complete it');
        }
        exe.dispose();
        (_b = this.executions.get(notebookUri.toString())) === null || _b === void 0 ? void 0 : _b.delete(cellHandle);
        this.onDidChangeExecutionEmitter.fire(new CellExecutionStateChangedEvent(notebookUri, cellHandle));
    }
    getCellExecution(cellUri) {
        var _a;
        const parsed = common_1.CellUri.parse(cellUri);
        if (!parsed) {
            throw new Error(`Not a cell URI: ${cellUri}`);
        }
        return (_a = this.executions.get(parsed.notebook.toString())) === null || _a === void 0 ? void 0 : _a.get(parsed.handle);
    }
    dispose() {
        this.onDidChangeExecutionEmitter.dispose();
        this.onDidChangeLastRunFailStateEmitter.dispose();
        this.executions.forEach(notebookExecutions => notebookExecutions.forEach(execution => execution.dispose()));
    }
};
exports.NotebookExecutionStateService = NotebookExecutionStateService;
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_service_1.NotebookService),
    tslib_1.__metadata("design:type", notebook_service_1.NotebookService)
], NotebookExecutionStateService.prototype, "notebookService", void 0);
exports.NotebookExecutionStateService = NotebookExecutionStateService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookExecutionStateService);
class CellExecution {
    get state() {
        return this._state;
    }
    get notebookURI() {
        return this.notebook.uri;
    }
    get didPause() {
        return this._didPause;
    }
    get isPaused() {
        return this._isPaused;
    }
    constructor(cellHandle, notebook) {
        this.cellHandle = cellHandle;
        this.notebook = notebook;
        this.onDidUpdateEmitter = new core_1.Emitter();
        this.onDidUpdate = this.onDidUpdateEmitter.event;
        this.onDidCompleteEmitter = new core_1.Emitter();
        this.onDidComplete = this.onDidCompleteEmitter.event;
        this.toDispose = new core_1.DisposableCollection();
        this._state = common_1.NotebookCellExecutionState.Unconfirmed;
        this._didPause = false;
        this._isPaused = false;
    }
    initialize() {
        const startExecuteEdit = {
            editType: 9 /* CellEditType.PartialInternalMetadata */,
            handle: this.cellHandle,
            internalMetadata: {
                executionId: (0, core_1.generateUuid)(),
                runStartTime: undefined,
                runEndTime: undefined,
                lastRunSuccess: undefined,
                executionOrder: undefined,
                renderDuration: undefined,
            }
        };
        this.applyCellExecutionEditsToNotebook([startExecuteEdit]);
    }
    confirm() {
        this._state = common_1.NotebookCellExecutionState.Pending;
        this.onDidUpdateEmitter.fire();
    }
    update(updates) {
        if (updates.some(u => u.editType === common_1.CellExecutionUpdateType.ExecutionState)) {
            this._state = common_1.NotebookCellExecutionState.Executing;
        }
        if (!this._didPause && updates.some(u => u.editType === common_1.CellExecutionUpdateType.ExecutionState && u.didPause)) {
            this._didPause = true;
        }
        const lastIsPausedUpdate = [...updates].reverse().find(u => u.editType === common_1.CellExecutionUpdateType.ExecutionState && typeof u.isPaused === 'boolean');
        if (lastIsPausedUpdate) {
            this._isPaused = lastIsPausedUpdate.isPaused;
        }
        const cellModel = this.notebook.cells.find(c => c.handle === this.cellHandle);
        if (!cellModel) {
            console.debug(`CellExecution#update, updating cell not in notebook: ${this.notebook.uri.toString()}, ${this.cellHandle}`);
        }
        else {
            const edits = updates.map(update => updateToEdit(update, this.cellHandle));
            this.applyCellExecutionEditsToNotebook(edits);
        }
        if (updates.some(u => u.editType === common_1.CellExecutionUpdateType.ExecutionState)) {
            this.onDidUpdateEmitter.fire();
        }
    }
    complete(completionData) {
        const cellModel = this.notebook.cells.find(c => c.handle === this.cellHandle);
        if (!cellModel) {
            console.debug(`CellExecution#complete, completing cell not in notebook: ${this.notebook.uri.toString()}, ${this.cellHandle}`);
        }
        else {
            const edit = {
                editType: 9 /* CellEditType.PartialInternalMetadata */,
                handle: this.cellHandle,
                internalMetadata: {
                    lastRunSuccess: completionData.lastRunSuccess,
                    // eslint-disable-next-line no-null/no-null
                    runStartTime: this._didPause ? null : cellModel.internalMetadata.runStartTime,
                    // eslint-disable-next-line no-null/no-null
                    runEndTime: this._didPause ? null : completionData.runEndTime,
                }
            };
            this.applyCellExecutionEditsToNotebook([edit]);
        }
        this.onDidCompleteEmitter.fire(completionData.lastRunSuccess);
    }
    dispose() {
        this.onDidUpdateEmitter.dispose();
        this.onDidCompleteEmitter.dispose();
        this.toDispose.dispose();
    }
    applyCellExecutionEditsToNotebook(edits) {
        this.notebook.applyEdits(edits, false);
    }
}
exports.CellExecution = CellExecution;
class CellExecutionStateChangedEvent {
    constructor(notebook, cellHandle, changed) {
        this.notebook = notebook;
        this.cellHandle = cellHandle;
        this.changed = changed;
        this.type = NotebookExecutionType.cell;
    }
    affectsCell(cell) {
        const parsedUri = common_1.CellUri.parse(cell);
        return !!parsedUri && this.notebook.isEqual(parsedUri.notebook) && this.cellHandle === parsedUri.handle;
    }
    affectsNotebook(notebook) {
        return this.notebook.toString() === notebook.toString();
    }
}
exports.CellExecutionStateChangedEvent = CellExecutionStateChangedEvent;
function updateToEdit(update, cellHandle) {
    if (update.editType === common_1.CellExecutionUpdateType.Output) {
        return {
            editType: 2 /* CellEditType.Output */,
            handle: update.cellHandle,
            append: update.append,
            outputs: update.outputs,
        };
    }
    else if (update.editType === common_1.CellExecutionUpdateType.OutputItems) {
        return {
            editType: 7 /* CellEditType.OutputItems */,
            items: update.items,
            outputId: update.outputId,
            append: update.append,
        };
    }
    else if (update.editType === common_1.CellExecutionUpdateType.ExecutionState) {
        const newInternalMetadata = {};
        if (typeof update.executionOrder !== 'undefined') {
            newInternalMetadata.executionOrder = update.executionOrder;
        }
        if (typeof update.runStartTime !== 'undefined') {
            newInternalMetadata.runStartTime = update.runStartTime;
        }
        return {
            editType: 9 /* CellEditType.PartialInternalMetadata */,
            handle: cellHandle,
            internalMetadata: newInternalMetadata
        };
    }
    throw new Error('Unknown cell update type');
}
exports.updateToEdit = updateToEdit;


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/service/notebook-kernel-history-service.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/service/notebook-kernel-history-service.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var NotebookKernelHistoryService_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookKernelHistoryService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const notebook_kernel_service_1 = __webpack_require__(/*! ./notebook-kernel-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-kernel-service.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const notebook_actions_contribution_1 = __webpack_require__(/*! ../contributions/notebook-actions-contribution */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-actions-contribution.js");
const MAX_KERNELS_IN_HISTORY = 5;
let NotebookKernelHistoryService = NotebookKernelHistoryService_1 = class NotebookKernelHistoryService {
    constructor() {
        this.mostRecentKernelsMap = {};
    }
    init() {
        this.loadState();
    }
    getKernels(notebook) {
        const allAvailableKernels = this.notebookKernelService.getMatchingKernel(notebook);
        const allKernels = allAvailableKernels.all;
        const selectedKernel = allAvailableKernels.selected;
        // We will suggest the only kernel
        const suggested = allAvailableKernels.all.length === 1 ? allAvailableKernels.all[0] : undefined;
        const mostRecentKernelIds = this.mostRecentKernelsMap[notebook.viewType] ? this.mostRecentKernelsMap[notebook.viewType].map(kernel => kernel[1]) : [];
        const all = mostRecentKernelIds.map(kernelId => allKernels.find(kernel => kernel.id === kernelId)).filter(kernel => !!kernel);
        return {
            selected: selectedKernel !== null && selectedKernel !== void 0 ? selectedKernel : suggested,
            all
        };
    }
    async resolveSelectedKernel(notebook) {
        const alreadySelected = this.getKernels(notebook);
        if (alreadySelected.selected) {
            return alreadySelected.selected;
        }
        await this.commandService.executeCommand(notebook_actions_contribution_1.NotebookCommands.SELECT_KERNEL_COMMAND.id, notebook);
        const { selected } = this.getKernels(notebook);
        return selected;
    }
    addMostRecentKernel(kernel) {
        var _a;
        const viewType = kernel.viewType;
        const recentKernels = (_a = this.mostRecentKernelsMap[viewType]) !== null && _a !== void 0 ? _a : [kernel.id];
        if (recentKernels.length > MAX_KERNELS_IN_HISTORY) {
            recentKernels.splice(MAX_KERNELS_IN_HISTORY);
        }
        this.mostRecentKernelsMap[viewType] = recentKernels;
        this.saveState();
    }
    saveState() {
        let notEmpty = false;
        for (const kernels of Object.values(this.mostRecentKernelsMap)) {
            notEmpty = notEmpty || Object.entries(kernels).length > 0;
        }
        this.storageService.setData(NotebookKernelHistoryService_1.STORAGE_KEY, notEmpty ? this.mostRecentKernelsMap : undefined);
    }
    async loadState() {
        const kernelMap = await this.storageService.getData(NotebookKernelHistoryService_1.STORAGE_KEY);
        if (kernelMap) {
            this.mostRecentKernelsMap = kernelMap;
        }
        else {
            this.mostRecentKernelsMap = {};
        }
    }
    clear() {
        this.mostRecentKernelsMap = {};
        this.saveState();
    }
    dispose() {
    }
};
exports.NotebookKernelHistoryService = NotebookKernelHistoryService;
NotebookKernelHistoryService.STORAGE_KEY = 'notebook.kernelHistory';
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.StorageService),
    tslib_1.__metadata("design:type", Object)
], NotebookKernelHistoryService.prototype, "storageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_kernel_service_1.NotebookKernelService),
    tslib_1.__metadata("design:type", notebook_kernel_service_1.NotebookKernelService)
], NotebookKernelHistoryService.prototype, "notebookKernelService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.CommandService),
    tslib_1.__metadata("design:type", Object)
], NotebookKernelHistoryService.prototype, "commandService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], NotebookKernelHistoryService.prototype, "init", null);
exports.NotebookKernelHistoryService = NotebookKernelHistoryService = NotebookKernelHistoryService_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookKernelHistoryService);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/service/notebook-kernel-quick-pick-service.js":
/*!****************************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/service/notebook-kernel-quick-pick-service.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookKernelQuickPickService = exports.JUPYTER_EXTENSION_ID = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const notebook_kernel_service_1 = __webpack_require__(/*! ./notebook-kernel-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-kernel-service.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const notebook_kernel_history_service_1 = __webpack_require__(/*! ./notebook-kernel-history-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-kernel-history-service.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/notebook/lib/common/index.js");
const debounce = __webpack_require__(/*! @theia/core/shared/lodash.debounce */ "../../node_modules/@theia/core/shared/lodash.debounce/index.js");
exports.JUPYTER_EXTENSION_ID = 'ms-toolsai.jupyter';
function isKernelPick(item) {
    return 'kernel' in item;
}
function isGroupedKernelsPick(item) {
    return 'kernels' in item;
}
function isSourcePick(item) {
    return 'action' in item;
}
function isKernelSourceQuickPickItem(item) {
    return 'command' in item;
}
function supportAutoRun(item) {
    return 'autoRun' in item && !!item.autoRun;
}
const KERNEL_PICKER_UPDATE_DEBOUNCE = 200;
function toKernelQuickPick(kernel, selected) {
    const res = {
        kernel,
        label: kernel.label,
        description: kernel.description,
        detail: kernel.detail
    };
    if (kernel.id === (selected === null || selected === void 0 ? void 0 : selected.id)) {
        if (!res.description) {
            res.description = core_1.nls.localizeByDefault('Currently Selected');
        }
        else {
            res.description = core_1.nls.localizeByDefault('{0} - Currently Selected', res.description);
        }
    }
    return res;
}
let NotebookKernelQuickPickService = class NotebookKernelQuickPickService {
    async showQuickPick(editor, wantedId, skipAutoRun) {
        const notebook = editor;
        const matchResult = this.getMatchingResult(notebook);
        const { selected, all } = matchResult;
        let newKernel;
        if (wantedId) {
            for (const candidate of all) {
                if (candidate.id === wantedId) {
                    newKernel = candidate;
                    break;
                }
            }
            if (!newKernel) {
                console.warn(`wanted kernel DOES NOT EXIST, wanted: ${wantedId}, all: ${all.map(k => k.id)}`);
                return false;
            }
        }
        if (newKernel) {
            this.selectKernel(notebook, newKernel);
            return true;
        }
        const quickPick = this.quickInputService.createQuickPick();
        const quickPickItems = this.getKernelPickerQuickPickItems(matchResult);
        if (quickPickItems.length === 1 && supportAutoRun(quickPickItems[0]) && !skipAutoRun) {
            return this.handleQuickPick(editor, quickPickItems[0], quickPickItems);
        }
        quickPick.items = quickPickItems;
        quickPick.canSelectMany = false;
        quickPick.placeholder = selected
            ? core_1.nls.localizeByDefault("Change kernel for '{0}'", 'current') // TODO get label for current notebook from a label provider
            : core_1.nls.localizeByDefault("Select kernel for '{0}'", 'current');
        quickPick.busy = this.notebookKernelService.getKernelDetectionTasks(notebook).length > 0;
        const kernelDetectionTaskListener = this.notebookKernelService.onDidChangeKernelDetectionTasks(() => {
            quickPick.busy = this.notebookKernelService.getKernelDetectionTasks(notebook).length > 0;
        });
        const kernelChangeEventListener = debounce(core_1.Event.any(this.notebookKernelService.onDidChangeSourceActions, this.notebookKernelService.onDidAddKernel, this.notebookKernelService.onDidRemoveKernel, this.notebookKernelService.onDidChangeNotebookAffinity), KERNEL_PICKER_UPDATE_DEBOUNCE)(async () => {
            // reset quick pick progress
            quickPick.busy = false;
            const currentActiveItems = quickPick.activeItems;
            const newMatchResult = this.getMatchingResult(notebook);
            const newQuickPickItems = this.getKernelPickerQuickPickItems(newMatchResult);
            quickPick.keepScrollPosition = true;
            // recalculate active items
            const activeItems = [];
            for (const item of currentActiveItems) {
                if (isKernelPick(item)) {
                    const kernelId = item.kernel.id;
                    const sameItem = newQuickPickItems.find(pi => isKernelPick(pi) && pi.kernel.id === kernelId);
                    if (sameItem) {
                        activeItems.push(sameItem);
                    }
                }
                else if (isSourcePick(item)) {
                    const sameItem = newQuickPickItems.find(pi => isSourcePick(pi) && pi.action.command.id === item.action.command.id);
                    if (sameItem) {
                        activeItems.push(sameItem);
                    }
                }
            }
            quickPick.items = newQuickPickItems;
            quickPick.activeItems = activeItems;
        }, this);
        const pick = await new Promise((resolve, reject) => {
            quickPick.onDidAccept(() => {
                const item = quickPick.selectedItems[0];
                if (item) {
                    resolve({ selected: item, items: quickPick.items });
                }
                else {
                    resolve({ selected: undefined, items: quickPick.items });
                }
                quickPick.hide();
            });
            quickPick.onDidHide(() => {
                kernelDetectionTaskListener.dispose();
                kernelChangeEventListener === null || kernelChangeEventListener === void 0 ? void 0 : kernelChangeEventListener.dispose();
                quickPick.dispose();
                resolve({ selected: undefined, items: quickPick.items });
            });
            quickPick.show();
        });
        if (pick.selected) {
            return this.handleQuickPick(editor, pick.selected, pick.items);
        }
        return false;
    }
    getKernelPickerQuickPickItems(matchResult) {
        const quickPickItems = [];
        if (matchResult.selected) {
            const kernelItem = toKernelQuickPick(matchResult.selected, matchResult.selected);
            quickPickItems.push(kernelItem);
        }
        // TODO use suggested here when kernel affinity is implemented. For now though show all kernels
        matchResult.all.filter(kernel => { var _a; return kernel.id !== ((_a = matchResult.selected) === null || _a === void 0 ? void 0 : _a.id); }).map(kernel => toKernelQuickPick(kernel, matchResult.selected))
            .forEach(kernel => {
            quickPickItems.push(kernel);
        });
        const shouldAutoRun = quickPickItems.length === 0;
        if (quickPickItems.length > 0) {
            quickPickItems.push({
                type: 'separator'
            });
        }
        // select another kernel quick pick
        quickPickItems.push({
            id: 'selectAnother',
            label: core_1.nls.localizeByDefault('Select Another Kernel...'),
            autoRun: shouldAutoRun
        });
        return quickPickItems;
    }
    selectKernel(notebook, kernel) {
        this.logger.debug('Selected notebook kernel', {
            notebook: notebook.uri.toString(),
            kernel: kernel.id
        });
        const currentInfo = this.notebookKernelService.getMatchingKernel(notebook);
        if (currentInfo.selected) {
            // there is already a selected kernel
            this.notebookKernelHistoryService.addMostRecentKernel(currentInfo.selected);
        }
        this.notebookKernelService.selectKernelForNotebook(kernel, notebook);
        this.notebookKernelHistoryService.addMostRecentKernel(kernel);
    }
    getMatchingResult(notebook) {
        const { selected, all } = this.notebookKernelHistoryService.getKernels(notebook);
        const matchingResult = this.notebookKernelService.getMatchingKernel(notebook);
        return {
            selected: selected,
            all: matchingResult.all,
            suggestions: all,
            hidden: []
        };
    }
    async handleQuickPick(editor, pick, items) {
        if (pick.id === 'selectAnother') {
            return this.displaySelectAnotherQuickPick(editor, items.length === 1 && items[0] === pick);
        }
        if (isKernelPick(pick)) {
            const newKernel = pick.kernel;
            this.selectKernel(editor, newKernel);
            return true;
        }
        if (isSourcePick(pick)) {
            this.logger.debug('Selected notebook kernel command', {
                notebook: editor.uri.toString(),
                command: pick.action.command.id
            });
            // selected explicitly, it should trigger the execution?
            pick.action.run(this.commandService);
        }
        return true;
    }
    async displaySelectAnotherQuickPick(editor, kernelListEmpty) {
        const notebook = editor;
        const disposables = new core_1.DisposableCollection();
        const quickPick = this.quickInputService.createQuickPick();
        const quickPickItem = await new Promise(resolve => {
            // select from kernel sources
            quickPick.title = kernelListEmpty ? core_1.nls.localizeByDefault('Select Kernel') : core_1.nls.localizeByDefault('Select Another Kernel');
            quickPick.placeholder = core_1.nls.localizeByDefault('Type to choose a kernel source');
            quickPick.busy = true;
            // quickPick.buttons = [this.quickInputService.backButton];
            quickPick.show();
            disposables.push(quickPick.onDidTriggerButton(button => {
                if (button === this.quickInputService.backButton) {
                    resolve(button);
                }
            }));
            quickPick.onDidTriggerItemButton(async (e) => {
                if (isKernelSourceQuickPickItem(e.item) && e.item.documentation !== undefined) {
                    const uri = this.isUri(e.item.documentation) ? new core_1.URI(e.item.documentation) : await this.commandService.executeCommand(e.item.documentation);
                    if (uri) {
                        (await this.openerService.getOpener(uri, { openExternal: true })).open(uri, { openExternal: true });
                    }
                }
            });
            disposables.push(quickPick.onDidAccept(async () => {
                resolve(quickPick.selectedItems[0]);
            }));
            disposables.push(quickPick.onDidHide(() => {
                resolve(undefined);
            }));
            this.calculateKernelSources(editor).then(quickPickItems => {
                quickPick.items = quickPickItems;
                if (quickPick.items.length > 0) {
                    quickPick.busy = false;
                }
            });
            debounce(core_1.Event.any(this.notebookKernelService.onDidChangeSourceActions, this.notebookKernelService.onDidAddKernel, this.notebookKernelService.onDidRemoveKernel), KERNEL_PICKER_UPDATE_DEBOUNCE)(async () => {
                quickPick.busy = true;
                const quickPickItems = await this.calculateKernelSources(editor);
                quickPick.items = quickPickItems;
                quickPick.busy = false;
            });
        });
        quickPick.hide();
        disposables.dispose();
        if (quickPickItem === this.quickInputService.backButton) {
            return this.showQuickPick(editor, undefined, true);
        }
        if (quickPickItem) {
            const selectedKernelPickItem = quickPickItem;
            if (isKernelSourceQuickPickItem(selectedKernelPickItem)) {
                try {
                    const selectedKernelId = await this.executeCommand(notebook, selectedKernelPickItem.command);
                    if (selectedKernelId) {
                        const { all } = this.getMatchingResult(notebook);
                        const notebookKernel = all.find(kernel => kernel.id === `ms-toolsai.jupyter/${selectedKernelId}`);
                        if (notebookKernel) {
                            this.selectKernel(notebook, notebookKernel);
                            return true;
                        }
                        return true;
                    }
                    else {
                        return this.displaySelectAnotherQuickPick(editor, false);
                    }
                }
                catch (ex) {
                    console.error('Failed to select notebook kernel', ex);
                    return false;
                }
            }
            else if (isKernelPick(selectedKernelPickItem)) {
                this.selectKernel(notebook, selectedKernelPickItem.kernel);
                return true;
            }
            else if (isGroupedKernelsPick(selectedKernelPickItem)) {
                await this.selectOneKernel(notebook, selectedKernelPickItem.source, selectedKernelPickItem.kernels);
                return true;
            }
            else if (isSourcePick(selectedKernelPickItem)) {
                // selected explicitly, it should trigger the execution?
                try {
                    await selectedKernelPickItem.action.run(this.commandService);
                    return true;
                }
                catch (ex) {
                    console.error('Failed to select notebook kernel', ex);
                    return false;
                }
            }
            // } else if (isSearchMarketplacePick(selectedKernelPickItem)) {
            //     await this.showKernelExtension(
            //         this.paneCompositePartService,
            //         this.extensionWorkbenchService,
            //         this.extensionService,
            //         editor.textModel.viewType,
            //         []
            //     );
            //     return true;
            // } else if (isInstallExtensionPick(selectedKernelPickItem)) {
            //     await this.showKernelExtension(
            //         this.paneCompositePartService,
            //         this.extensionWorkbenchService,
            //         this.extensionService,
            //         editor.textModel.viewType,
            //         selectedKernelPickItem.extensionIds,
            //     );
            //     return true;
            // }
        }
        return false;
    }
    isUri(value) {
        return /^(?<scheme>\w[\w\d+.-]*):/.test(value);
    }
    async calculateKernelSources(editor) {
        const notebook = editor;
        const actions = await this.notebookKernelService.getKernelSourceActionsFromProviders(notebook);
        const matchResult = this.getMatchingResult(notebook);
        const others = matchResult.all.filter(item => item.extensionId !== exports.JUPYTER_EXTENSION_ID);
        const quickPickItems = [];
        // group controllers by extension
        for (const group of core_1.ArrayUtils.groupBy(others, (a, b) => a.extensionId === b.extensionId ? 0 : 1)) {
            const source = group[0].extensionId;
            if (group.length > 1) {
                quickPickItems.push({
                    label: source,
                    kernels: group
                });
            }
            else {
                quickPickItems.push({
                    label: group[0].label,
                    kernel: group[0]
                });
            }
        }
        const validActions = actions.filter(action => action.command);
        quickPickItems.push(...validActions.map(action => {
            const buttons = action.documentation ? [{
                    iconClass: (0, browser_1.codicon)('info'),
                    tooltip: core_1.nls.localizeByDefault('Learn More'),
                }] : [];
            return {
                id: typeof action.command === 'string' ? action.command : action.command.id,
                label: action.label,
                description: action.description,
                command: action.command,
                documentation: action.documentation,
                buttons
            };
        }));
        return quickPickItems;
    }
    async selectOneKernel(notebook, source, kernels) {
        const quickPickItems = kernels.map(kernel => toKernelQuickPick(kernel, undefined));
        const quickPick = this.quickInputService.createQuickPick();
        quickPick.items = quickPickItems;
        quickPick.canSelectMany = false;
        quickPick.title = core_1.nls.localizeByDefault('Select Kernel from {0}', source);
        quickPick.onDidAccept(async () => {
            if (quickPick.selectedItems && quickPick.selectedItems.length > 0 && isKernelPick(quickPick.selectedItems[0])) {
                this.selectKernel(notebook, quickPick.selectedItems[0].kernel);
            }
            quickPick.hide();
            quickPick.dispose();
        });
        quickPick.onDidHide(() => {
            quickPick.dispose();
        });
        quickPick.show();
    }
    async executeCommand(notebook, command) {
        const args = (command.arguments || []).concat([common_1.NotebookModelResource.create(notebook.uri)]);
        return this.commandService.executeCommand(command.id, ...args);
    }
};
exports.NotebookKernelQuickPickService = NotebookKernelQuickPickService;
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_kernel_service_1.NotebookKernelService),
    tslib_1.__metadata("design:type", notebook_kernel_service_1.NotebookKernelService)
], NotebookKernelQuickPickService.prototype, "notebookKernelService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.QuickInputService),
    tslib_1.__metadata("design:type", Object)
], NotebookKernelQuickPickService.prototype, "quickInputService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.CommandService),
    tslib_1.__metadata("design:type", Object)
], NotebookKernelQuickPickService.prototype, "commandService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], NotebookKernelQuickPickService.prototype, "openerService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_kernel_history_service_1.NotebookKernelHistoryService),
    tslib_1.__metadata("design:type", notebook_kernel_history_service_1.NotebookKernelHistoryService)
], NotebookKernelQuickPickService.prototype, "notebookKernelHistoryService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ILogger),
    (0, inversify_1.named)('notebook'),
    tslib_1.__metadata("design:type", Object)
], NotebookKernelQuickPickService.prototype, "logger", void 0);
exports.NotebookKernelQuickPickService = NotebookKernelQuickPickService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookKernelQuickPickService);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/service/notebook-kernel-service.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/service/notebook-kernel-service.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var NotebookKernelService_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookKernelService = exports.SourceCommand = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const notebook_service_1 = __webpack_require__(/*! ./notebook-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-service.js");
class KernelInfo {
    constructor(kernel) {
        this.kernel = kernel;
        this.score = -1;
        this.handle = KernelInfo.instanceCounter++;
    }
}
KernelInfo.instanceCounter = 0;
class SourceCommand {
    constructor(command, model) {
        this.command = command;
        this.model = model;
        this.onDidChangeStateEmitter = new core_1.Emitter();
        this.onDidChangeState = this.onDidChangeStateEmitter.event;
    }
    async run(commandService) {
        if (this.execution) {
            return this.execution;
        }
        this.execution = this.runCommand(commandService);
        this.onDidChangeStateEmitter.fire();
        await this.execution;
        this.execution = undefined;
        this.onDidChangeStateEmitter.fire();
    }
    async runCommand(commandService) {
        try {
            await commandService.executeCommand(this.command.id, {
                uri: this.model.uri,
            });
        }
        catch (error) {
            console.warn(`Kernel source command failed: ${error}`);
        }
    }
    dispose() {
        this.onDidChangeStateEmitter.dispose();
    }
}
exports.SourceCommand = SourceCommand;
const NOTEBOOK_KERNEL_BINDING_STORAGE_KEY = 'notebook.kernel.bindings';
let NotebookKernelService = NotebookKernelService_1 = class NotebookKernelService {
    constructor() {
        this.kernels = new Map();
        this.notebookBindings = {};
        this.kernelDetectionTasks = new Map();
        this.onDidChangeKernelDetectionTasksEmitter = new core_1.Emitter();
        this.onDidChangeKernelDetectionTasks = this.onDidChangeKernelDetectionTasksEmitter.event;
        this.onDidChangeSourceActionsEmitter = new core_1.Emitter();
        this.kernelSourceActionProviders = new Map();
        this.onDidChangeSourceActions = this.onDidChangeSourceActionsEmitter.event;
        this.onDidAddKernelEmitter = new core_1.Emitter();
        this.onDidAddKernel = this.onDidAddKernelEmitter.event;
        this.onDidRemoveKernelEmitter = new core_1.Emitter();
        this.onDidRemoveKernel = this.onDidRemoveKernelEmitter.event;
        this.onDidChangeSelectedNotebookKernelBindingEmitter = new core_1.Emitter();
        this.onDidChangeSelectedKernel = this.onDidChangeSelectedNotebookKernelBindingEmitter.event;
        this.onDidChangeNotebookAffinityEmitter = new core_1.Emitter();
        this.onDidChangeNotebookAffinity = this.onDidChangeNotebookAffinityEmitter.event;
    }
    init() {
        this.notebookService.onDidAddNotebookDocument(model => this.tryAutoBindNotebook(model));
        this.storageService.getData(NOTEBOOK_KERNEL_BINDING_STORAGE_KEY).then((value) => {
            if (value) {
                this.notebookBindings = value;
            }
        });
    }
    registerKernel(kernel) {
        if (this.kernels.has(kernel.id)) {
            throw new Error(`Notebook Controller with id '${kernel.id}' already exists`);
        }
        this.kernels.set(kernel.id, new KernelInfo(kernel));
        this.onDidAddKernelEmitter.fire(kernel);
        // auto associate the new kernel to existing notebooks it was
        // associated to in the past.
        for (const notebook of this.notebookService.getNotebookModels()) {
            this.tryAutoBindNotebook(notebook, kernel);
        }
        return core_1.Disposable.create(() => {
            if (this.kernels.delete(kernel.id)) {
                this.onDidRemoveKernelEmitter.fire(kernel);
            }
        });
    }
    /**
     * Helps to find the best matching kernel for a notebook.
     * @param notebook notebook to get the matching kernel for
     * @returns and object containing:
     *  all kernels sorted to match the notebook best first (affinity ascending, score descending, label))
     *  the selected kernel (if any)
     *  specific suggested kernels (if any)
     *  hidden kernels (if any)
     */
    getMatchingKernel(notebook) {
        const kernels = [];
        for (const info of this.kernels.values()) {
            const score = NotebookKernelService_1.score(info.kernel, notebook);
            if (score) {
                kernels.push({
                    score,
                    kernel: info.kernel,
                    instanceAffinity: 1 /* vscode.NotebookControllerPriority.Default */,
                });
            }
        }
        kernels
            .sort((a, b) => b.instanceAffinity - a.instanceAffinity || a.score - b.score || a.kernel.label.localeCompare(b.kernel.label));
        const all = kernels.map(obj => obj.kernel);
        // bound kernel
        const selected = this.getSelectedNotebookKernel(notebook);
        const suggestions = kernels.filter(item => item.instanceAffinity > 1).map(item => item.kernel); // TODO implement notebookAffinity
        const hidden = kernels.filter(item => item.instanceAffinity < 0).map(item => item.kernel);
        return { all, selected, suggestions, hidden };
    }
    getSelectedNotebookKernel(notebook) {
        var _a;
        const selectedId = this.notebookBindings[`${notebook.viewType}/${notebook.uri}`];
        return selectedId ? (_a = this.kernels.get(selectedId)) === null || _a === void 0 ? void 0 : _a.kernel : undefined;
    }
    selectKernelForNotebook(kernel, notebook) {
        const key = `${notebook.viewType}/${notebook.uri}`;
        const oldKernel = this.notebookBindings[key];
        if (oldKernel !== (kernel === null || kernel === void 0 ? void 0 : kernel.id)) {
            if (kernel) {
                this.notebookBindings[key] = kernel.id;
            }
            else {
                delete this.notebookBindings[key];
            }
            this.storageService.setData(NOTEBOOK_KERNEL_BINDING_STORAGE_KEY, this.notebookBindings);
            this.onDidChangeSelectedNotebookKernelBindingEmitter.fire({ notebook: notebook.uri, oldKernel, newKernel: kernel === null || kernel === void 0 ? void 0 : kernel.id });
        }
    }
    getSelectedOrSuggestedKernel(notebook) {
        const info = this.getMatchingKernel(notebook);
        if (info.selected) {
            return info.selected;
        }
        return info.all.length === 1 ? info.all[0] : undefined;
    }
    getKernel(id) {
        var _a;
        return (_a = this.kernels.get(id)) === null || _a === void 0 ? void 0 : _a.kernel;
    }
    static score(kernel, notebook) {
        if (kernel.viewType === notebook.viewType) {
            return 10;
        }
        else if (kernel.viewType === '*') {
            return 5;
        }
        else {
            return 0;
        }
    }
    tryAutoBindNotebook(notebook, onlyThisKernel) {
        const id = this.notebookBindings[`${notebook.viewType}/${notebook.uri}`];
        if (!id) {
            // no kernel associated
            return;
        }
        const existingKernel = this.kernels.get(id);
        if (!existingKernel || !NotebookKernelService_1.score(existingKernel.kernel, notebook)) {
            // associated kernel not known, not matching
            return;
        }
        if (!onlyThisKernel || existingKernel.kernel === onlyThisKernel) {
            this.onDidChangeSelectedNotebookKernelBindingEmitter.fire({ notebook: notebook.uri, oldKernel: undefined, newKernel: existingKernel.kernel.id });
        }
    }
    registerNotebookKernelDetectionTask(notebookType) {
        var _a;
        const all = (_a = this.kernelDetectionTasks.get(notebookType)) !== null && _a !== void 0 ? _a : [];
        all.push(notebookType);
        this.kernelDetectionTasks.set(notebookType, all);
        this.onDidChangeKernelDetectionTasksEmitter.fire(notebookType);
        return core_1.Disposable.create(() => {
            var _a;
            const allTasks = (_a = this.kernelDetectionTasks.get(notebookType)) !== null && _a !== void 0 ? _a : [];
            const taskIndex = allTasks.indexOf(notebookType);
            if (taskIndex >= 0) {
                allTasks.splice(taskIndex, 1);
                this.kernelDetectionTasks.set(notebookType, allTasks);
                this.onDidChangeKernelDetectionTasksEmitter.fire(notebookType);
            }
        });
    }
    getKernelDetectionTasks(notebook) {
        var _a;
        return (_a = this.kernelDetectionTasks.get(notebook.viewType)) !== null && _a !== void 0 ? _a : [];
    }
    registerKernelSourceActionProvider(viewType, provider) {
        var _a, _b;
        const providers = (_a = this.kernelSourceActionProviders.get(viewType)) !== null && _a !== void 0 ? _a : [];
        providers.push(provider);
        this.kernelSourceActionProviders.set(viewType, providers);
        this.onDidChangeSourceActionsEmitter.fire({ viewType: viewType });
        const eventEmitterDisposable = (_b = provider.onDidChangeSourceActions) === null || _b === void 0 ? void 0 : _b.call(provider, () => {
            this.onDidChangeSourceActionsEmitter.fire({ viewType: viewType });
        });
        return core_1.Disposable.create(() => {
            var _a;
            const sourceProviders = (_a = this.kernelSourceActionProviders.get(viewType)) !== null && _a !== void 0 ? _a : [];
            const providerIndex = sourceProviders.indexOf(provider);
            if (providerIndex >= 0) {
                sourceProviders.splice(providerIndex, 1);
                this.kernelSourceActionProviders.set(viewType, sourceProviders);
            }
            eventEmitterDisposable === null || eventEmitterDisposable === void 0 ? void 0 : eventEmitterDisposable.dispose();
        });
    }
    async getKernelSourceActionsFromProviders(notebook) {
        var _a;
        const viewType = notebook.viewType;
        const providers = (_a = this.kernelSourceActionProviders.get(viewType)) !== null && _a !== void 0 ? _a : [];
        const promises = providers.map(provider => provider.provideKernelSourceActions());
        const allActions = await Promise.all(promises);
        return allActions.flat();
    }
};
exports.NotebookKernelService = NotebookKernelService;
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_service_1.NotebookService),
    tslib_1.__metadata("design:type", notebook_service_1.NotebookService)
], NotebookKernelService.prototype, "notebookService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.StorageService),
    tslib_1.__metadata("design:type", Object)
], NotebookKernelService.prototype, "storageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], NotebookKernelService.prototype, "init", null);
exports.NotebookKernelService = NotebookKernelService = NotebookKernelService_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookKernelService);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/service/notebook-model-resolver-service.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/service/notebook-model-resolver-service.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookModelResolverService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const notebook_service_1 = __webpack_require__(/*! ./notebook-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-service.js");
const notebook_type_registry_1 = __webpack_require__(/*! ../notebook-type-registry */ "../../node_modules/@theia/notebook/lib/browser/notebook-type-registry.js");
const glob_1 = __webpack_require__(/*! @theia/core/lib/common/glob */ "../../node_modules/@theia/core/lib/common/glob.js");
let NotebookModelResolverService = class NotebookModelResolverService {
    constructor() {
        this.onDidChangeDirtyEmitter = new core_1.Emitter();
        this.onDidChangeDirty = this.onDidChangeDirtyEmitter.event;
        this.onDidSaveNotebookEmitter = new core_1.Emitter();
        this.onDidSaveNotebook = this.onDidSaveNotebookEmitter.event;
    }
    async resolve(resource, viewType) {
        const existingModel = this.notebookService.getNotebookEditorModel(resource);
        if (!viewType) {
            if (existingModel) {
                return existingModel;
            }
            else {
                viewType = this.findViewTypeForResource(resource);
            }
        }
        else if ((existingModel === null || existingModel === void 0 ? void 0 : existingModel.viewType) === viewType) {
            return existingModel;
        }
        if (!viewType) {
            throw new Error(`Missing viewType for '${resource}'`);
        }
        try {
            const actualResource = await this.resourceProvider(resource);
            const notebookData = await this.resolveExistingNotebookData(actualResource, viewType);
            const notebookModel = await this.notebookService.createNotebookModel(notebookData, viewType, actualResource);
            notebookModel.onDirtyChanged(() => this.onDidChangeDirtyEmitter.fire(notebookModel));
            notebookModel.onDidSaveNotebook(() => this.onDidSaveNotebookEmitter.fire(notebookModel.uri.toComponents()));
            return notebookModel;
        }
        catch (e) {
            const message = `Error resolving notebook model for: \n ${resource.path.fsPath()} \n with view type ${viewType}. \n ${e}`;
            console.error(message);
            throw new Error(message);
        }
    }
    async resolveUntitledResource(arg, viewType) {
        var _a, _b;
        let resource;
        // let hasAssociatedFilePath = false;
        arg = arg;
        if (!arg.untitledResource) {
            const notebookTypeInfo = this.notebookTypeRegistry.notebookTypes.find(info => info.type === viewType);
            if (!notebookTypeInfo) {
                throw new Error('UNKNOWN view type: ' + viewType);
            }
            const suffix = (_b = this.getPossibleFileEnding((_a = notebookTypeInfo.selector) !== null && _a !== void 0 ? _a : [])) !== null && _b !== void 0 ? _b : '';
            for (let counter = 1;; counter++) {
                const candidate = new core_1.URI()
                    .withScheme(core_1.UNTITLED_SCHEME)
                    .withPath(`Untitled-notebook-${counter}${suffix}`)
                    .withQuery(viewType);
                if (!this.notebookService.getNotebookEditorModel(candidate)) {
                    resource = candidate;
                    break;
                }
            }
        }
        else if (arg.untitledResource.scheme === core_1.UNTITLED_SCHEME) {
            resource = arg.untitledResource;
        }
        else {
            throw new Error('Invalid untitled resource: ' + arg.untitledResource.toString() + ' untitled resources with associated file path are not supported yet');
            // TODO implement associated file path support
            // resource = arg.untitledResource.withScheme('untitled');
            // hasAssociatedFilePath = true;
        }
        return this.resolve(resource, viewType);
    }
    async resolveExistingNotebookData(resource, viewType) {
        if (resource.uri.scheme === 'untitled') {
            return {
                cells: [],
                metadata: {}
            };
        }
        else {
            const [dataProvider, contents] = await Promise.all([
                this.notebookService.getNotebookDataProvider(viewType),
                this.fileService.readFile(resource.uri)
            ]);
            const notebook = await dataProvider.serializer.toNotebook(contents.value);
            return notebook;
        }
    }
    getPossibleFileEnding(selectors) {
        for (const selector of selectors) {
            const ending = this.possibleFileEnding(selector);
            if (ending) {
                return ending;
            }
        }
        return undefined;
    }
    possibleFileEnding(selector) {
        const pattern = /^.*(\.[a-zA-Z0-9_-]+)$/;
        const candidate = typeof selector === 'string' ? selector : selector.filenamePattern;
        if (candidate) {
            const matches = pattern.exec(candidate);
            if (matches) {
                return matches[1];
            }
        }
        return undefined;
    }
    findViewTypeForResource(resource) {
        var _a;
        return (_a = this.notebookTypeRegistry.notebookTypes.find(info => { var _a; return (_a = info.selector) === null || _a === void 0 ? void 0 : _a.some(selector => selector.filenamePattern && (0, glob_1.match)(selector.filenamePattern, resource.path.name + resource.path.ext)); })) === null || _a === void 0 ? void 0 : _a.type;
    }
};
exports.NotebookModelResolverService = NotebookModelResolverService;
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], NotebookModelResolverService.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ResourceProvider),
    tslib_1.__metadata("design:type", Function)
], NotebookModelResolverService.prototype, "resourceProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_service_1.NotebookService),
    tslib_1.__metadata("design:type", notebook_service_1.NotebookService)
], NotebookModelResolverService.prototype, "notebookService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_type_registry_1.NotebookTypeRegistry),
    tslib_1.__metadata("design:type", notebook_type_registry_1.NotebookTypeRegistry)
], NotebookModelResolverService.prototype, "notebookTypeRegistry", void 0);
exports.NotebookModelResolverService = NotebookModelResolverService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookModelResolverService);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/service/notebook-monaco-text-model-service.js":
/*!****************************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/service/notebook-monaco-text-model-service.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookMonacoTextModelService = exports.NotebookMonacoEditorModelFilter = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const monaco_text_model_service_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-text-model-service */ "../../node_modules/@theia/monaco/lib/browser/monaco-text-model-service.js");
const notebook_common_1 = __webpack_require__(/*! ../../common/notebook-common */ "../../node_modules/@theia/notebook/lib/common/notebook-common.js");
let NotebookMonacoEditorModelFilter = class NotebookMonacoEditorModelFilter {
    constructor() {
        this.onDidCreateCellModelEmitter = new core_1.Emitter();
    }
    get onDidCreateCellModel() {
        return this.onDidCreateCellModelEmitter.event;
    }
    filter(model) {
        const applies = model.uri.startsWith(notebook_common_1.CellUri.cellUriScheme);
        if (applies) {
            // If the model is for a notebook cell, we emit the event to notify the listeners.
            // We create our own event here, as we don't want to propagate the creation of the cell to the plugin host.
            // Instead, we want to do that ourselves once the notebook model is completely initialized.
            this.onDidCreateCellModelEmitter.fire(model);
        }
        return applies;
    }
};
exports.NotebookMonacoEditorModelFilter = NotebookMonacoEditorModelFilter;
exports.NotebookMonacoEditorModelFilter = NotebookMonacoEditorModelFilter = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookMonacoEditorModelFilter);
/**
 * special service for creating monaco textmodels for notebook cells.
 * Its for optimization purposes since there is alot of overhead otherwise with calling the backend to create a document for each cell and other smaller things.
 */
let NotebookMonacoTextModelService = class NotebookMonacoTextModelService {
    getOrCreateNotebookCellModelReference(uri) {
        return this.monacoTextModelService.createModelReference(uri);
    }
    async createTextModelsForNotebook(notebook) {
        await Promise.all(notebook.cells.map(cell => cell.resolveTextModel()));
    }
    get onDidCreateNotebookCellModel() {
        return this.notebookMonacoEditorModelFilter.onDidCreateCellModel;
    }
};
exports.NotebookMonacoTextModelService = NotebookMonacoTextModelService;
tslib_1.__decorate([
    (0, inversify_1.inject)(monaco_text_model_service_1.MonacoTextModelService),
    tslib_1.__metadata("design:type", monaco_text_model_service_1.MonacoTextModelService)
], NotebookMonacoTextModelService.prototype, "monacoTextModelService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(NotebookMonacoEditorModelFilter),
    tslib_1.__metadata("design:type", NotebookMonacoEditorModelFilter)
], NotebookMonacoTextModelService.prototype, "notebookMonacoEditorModelFilter", void 0);
exports.NotebookMonacoTextModelService = NotebookMonacoTextModelService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookMonacoTextModelService);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/service/notebook-options.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/service/notebook-options.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookOptionsService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const notebook_preferences_1 = __webpack_require__(/*! ../contributions/notebook-preferences */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-preferences.js");
const browser_2 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const fontInfo_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/common/config/fontInfo */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/common/config/fontInfo.js");
const pixelRatio_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/base/browser/pixelRatio */ "../../node_modules/@theia/monaco-editor-core/esm/vs/base/browser/pixelRatio.js");
const notebookOutputOptionsRelevantPreferences = [
    'editor.fontSize',
    'editor.fontFamily',
    notebook_preferences_1.NotebookPreferences.NOTEBOOK_LINE_NUMBERS,
    notebook_preferences_1.NotebookPreferences.OUTPUT_LINE_HEIGHT,
    notebook_preferences_1.NotebookPreferences.OUTPUT_FONT_SIZE,
    notebook_preferences_1.NotebookPreferences.OUTPUT_FONT_FAMILY,
    notebook_preferences_1.NotebookPreferences.OUTPUT_SCROLLING,
    notebook_preferences_1.NotebookPreferences.OUTPUT_WORD_WRAP,
    notebook_preferences_1.NotebookPreferences.OUTPUT_LINE_LIMIT
];
let NotebookOptionsService = class NotebookOptionsService {
    constructor() {
        this.outputOptionsChangedEmitter = new core_1.Emitter();
        this.onDidChangeOutputOptions = this.outputOptionsChangedEmitter.event;
    }
    get editorFontInfo() {
        return this.getOrCreateMonacoFontInfo();
    }
    init() {
        this.preferenceService.onPreferencesChanged(async (preferenceChanges) => {
            if (notebookOutputOptionsRelevantPreferences.some(p => p in preferenceChanges)) {
                this.outputOptionsChangedEmitter.fire(this.computeOutputOptions());
            }
        });
    }
    computeOutputOptions() {
        const outputLineHeight = this.getNotebookPreferenceWithDefault(notebook_preferences_1.NotebookPreferences.OUTPUT_LINE_HEIGHT);
        const fontSize = this.preferenceService.get('editor.fontSize');
        const outputFontSize = this.getNotebookPreferenceWithDefault(notebook_preferences_1.NotebookPreferences.OUTPUT_FONT_SIZE);
        return {
            fontSize,
            outputFontSize: outputFontSize,
            fontFamily: this.preferenceService.get('editor.fontFamily'),
            outputNodeLeftPadding: 8,
            outputFontFamily: this.getNotebookPreferenceWithDefault(notebook_preferences_1.NotebookPreferences.OUTPUT_FONT_FAMILY),
            outputLineHeight: this.computeOutputLineHeight(outputLineHeight, outputFontSize !== null && outputFontSize !== void 0 ? outputFontSize : fontSize),
            outputScrolling: this.getNotebookPreferenceWithDefault(notebook_preferences_1.NotebookPreferences.OUTPUT_SCROLLING),
            outputWordWrap: this.getNotebookPreferenceWithDefault(notebook_preferences_1.NotebookPreferences.OUTPUT_WORD_WRAP),
            outputLineLimit: this.getNotebookPreferenceWithDefault(notebook_preferences_1.NotebookPreferences.OUTPUT_LINE_LIMIT)
        };
    }
    getNotebookPreferenceWithDefault(key) {
        var _a, _b;
        return this.preferenceService.get(key, (_b = (_a = notebook_preferences_1.notebookPreferenceSchema.properties) === null || _a === void 0 ? void 0 : _a[key]) === null || _b === void 0 ? void 0 : _b.default);
    }
    computeOutputLineHeight(lineHeight, outputFontSize) {
        const minimumLineHeight = 9;
        if (lineHeight === 0) {
            // use editor line height
            lineHeight = this.editorFontInfo.lineHeight;
        }
        else if (lineHeight < minimumLineHeight) {
            // Values too small to be line heights in pixels are in ems.
            let fontSize = outputFontSize;
            if (fontSize === 0) {
                fontSize = this.preferenceService.get('editor.fontSize');
            }
            lineHeight = lineHeight * fontSize;
        }
        // Enforce integer, minimum constraints
        lineHeight = Math.round(lineHeight);
        if (lineHeight < minimumLineHeight) {
            lineHeight = minimumLineHeight;
        }
        return lineHeight;
    }
    getOrCreateMonacoFontInfo() {
        if (!this.fontInfo) {
            this.fontInfo = this.createFontInfo();
            this.editorPreferences.onPreferenceChanged(e => this.fontInfo = this.createFontInfo());
        }
        return this.fontInfo;
    }
    createFontInfo() {
        return fontInfo_1.BareFontInfo.createFromRawSettings({
            fontFamily: this.editorPreferences['editor.fontFamily'],
            fontWeight: String(this.editorPreferences['editor.fontWeight']),
            fontSize: this.editorPreferences['editor.fontSize'],
            fontLigatures: this.editorPreferences['editor.fontLigatures'],
            lineHeight: this.editorPreferences['editor.lineHeight'],
            letterSpacing: this.editorPreferences['editor.letterSpacing'],
        }, pixelRatio_1.PixelRatio.getInstance(window).value);
    }
};
exports.NotebookOptionsService = NotebookOptionsService;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], NotebookOptionsService.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.EditorPreferences),
    tslib_1.__metadata("design:type", Object)
], NotebookOptionsService.prototype, "editorPreferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], NotebookOptionsService.prototype, "init", null);
exports.NotebookOptionsService = NotebookOptionsService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookOptionsService);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/service/notebook-renderer-messaging-service.js":
/*!*****************************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/service/notebook-renderer-messaging-service.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookRendererMessagingService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const notebook_editor_widget_service_1 = __webpack_require__(/*! ./notebook-editor-widget-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-editor-widget-service.js");
;
let NotebookRendererMessagingService = class NotebookRendererMessagingService {
    constructor() {
        this.postMessageEmitter = new core_1.Emitter();
        this.onPostMessage = this.postMessageEmitter.event;
        this.willActivateRendererEmitter = new core_1.Emitter();
        this.onWillActivateRenderer = this.willActivateRendererEmitter.event;
        this.activations = new Map();
        this.scopedMessaging = new Map();
    }
    receiveMessage(editorId, rendererId, message) {
        var _a, _b, _c;
        if (editorId === undefined) {
            const sends = [...this.scopedMessaging.values()].map(e => { var _a; return (_a = e.receiveMessage) === null || _a === void 0 ? void 0 : _a.call(e, rendererId, message); });
            return Promise.all(sends).then(values => values.some(value => !!value));
        }
        return (_c = (_b = (_a = this.scopedMessaging.get(editorId)) === null || _a === void 0 ? void 0 : _a.receiveMessage) === null || _b === void 0 ? void 0 : _b.call(_a, rendererId, message)) !== null && _c !== void 0 ? _c : Promise.resolve(false);
    }
    prepare(rendererId) {
        if (this.activations.has(rendererId)) {
            return;
        }
        const queue = [];
        this.activations.set(rendererId, queue);
        Promise.all(this.willActivateRendererEmitter.fire(rendererId)).then(() => {
            for (const message of queue) {
                this.postMessageEmitter.fire(message);
            }
            this.activations.set(rendererId, undefined);
        });
    }
    getScoped(editorId) {
        const existing = this.scopedMessaging.get(editorId);
        if (existing) {
            return existing;
        }
        const messaging = {
            postMessage: (rendererId, message) => this.postMessage(editorId, rendererId, message),
            receiveMessage: async (rendererId, message) => {
                var _a;
                (_a = this.editorWidgetService.getNotebookEditor(editorId)) === null || _a === void 0 ? void 0 : _a.postRendererMessage(rendererId, message);
                return true;
            },
            dispose: () => this.scopedMessaging.delete(editorId),
        };
        this.scopedMessaging.set(editorId, messaging);
        return messaging;
    }
    postMessage(editorId, rendererId, message) {
        if (!this.activations.has(rendererId)) {
            this.prepare(rendererId);
        }
        const activation = this.activations.get(rendererId);
        const toSend = { rendererId, editorId, message };
        if (activation === undefined) {
            this.postMessageEmitter.fire(toSend);
        }
        else {
            activation.push(toSend);
        }
    }
    dispose() {
        this.postMessageEmitter.dispose();
    }
};
exports.NotebookRendererMessagingService = NotebookRendererMessagingService;
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_editor_widget_service_1.NotebookEditorWidgetService),
    tslib_1.__metadata("design:type", notebook_editor_widget_service_1.NotebookEditorWidgetService)
], NotebookRendererMessagingService.prototype, "editorWidgetService", void 0);
exports.NotebookRendererMessagingService = NotebookRendererMessagingService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookRendererMessagingService);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/service/notebook-service.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/service/notebook-service.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookService = exports.NotebookProvider = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/notebook/lib/common/index.js");
const notebook_model_1 = __webpack_require__(/*! ../view-model/notebook-model */ "../../node_modules/@theia/notebook/lib/browser/view-model/notebook-model.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const notebook_cell_model_1 = __webpack_require__(/*! ../view-model/notebook-cell-model */ "../../node_modules/@theia/notebook/lib/browser/view-model/notebook-cell-model.js");
const promise_util_1 = __webpack_require__(/*! @theia/core/lib/common/promise-util */ "../../node_modules/@theia/core/lib/common/promise-util.js");
const notebook_monaco_text_model_service_1 = __webpack_require__(/*! ./notebook-monaco-text-model-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-monaco-text-model-service.js");
exports.NotebookProvider = Symbol('notebook provider');
let NotebookService = class NotebookService {
    constructor() {
        this.willUseNotebookSerializerEmitter = new core_1.Emitter();
        this.onWillUseNotebookSerializer = this.willUseNotebookSerializerEmitter.event;
        this.disposables = new core_1.DisposableCollection();
        this.notebookProviders = new Map();
        this.notebookModels = new Map();
        this.didRegisterNotebookSerializerEmitter = new core_1.Emitter();
        this.onDidRegisterNotebookSerializer = this.didRegisterNotebookSerializerEmitter.event;
        this.didRemoveViewTypeEmitter = new core_1.Emitter();
        this.onDidRemoveViewType = this.didRemoveViewTypeEmitter.event;
        this.willOpenNotebookTypeEmitter = new core_1.Emitter();
        this.onWillOpenNotebook = this.willOpenNotebookTypeEmitter.event;
        this.didAddNotebookDocumentEmitter = new core_1.Emitter();
        this.onDidAddNotebookDocument = this.didAddNotebookDocumentEmitter.event;
        this.didRemoveNotebookDocumentEmitter = new core_1.Emitter();
        this.onDidRemoveNotebookDocument = this.didRemoveNotebookDocumentEmitter.event;
        this.ready = new promise_util_1.Deferred();
    }
    dispose() {
        this.disposables.dispose();
    }
    /**
     * Marks the notebook service as ready. From this point on, the service will start dispatching the `onNotebookSerializer` event.
     */
    markReady() {
        this.ready.resolve();
    }
    registerNotebookSerializer(viewType, serializer) {
        if (this.notebookProviders.has(viewType)) {
            throw new Error(`notebook provider for viewtype '${viewType}' already exists`);
        }
        this.notebookProviders.set(viewType, { notebookType: viewType, serializer });
        this.didRegisterNotebookSerializerEmitter.fire(viewType);
        return core_1.Disposable.create(() => {
            this.notebookProviders.delete(viewType);
            this.didRemoveViewTypeEmitter.fire(viewType);
        });
    }
    async createNotebookModel(data, viewType, resource) {
        const dataProvider = await this.getNotebookDataProvider(viewType);
        const serializer = dataProvider.serializer;
        const model = this.notebookModelFactory({ data, resource, viewType, serializer });
        this.notebookModels.set(resource.uri.toString(), model);
        // Resolve cell text models right after creating the notebook model
        // This ensures that all text models are available in the plugin host
        await this.textModelService.createTextModelsForNotebook(model);
        this.didAddNotebookDocumentEmitter.fire(model);
        model.onDidDispose(() => {
            this.notebookModels.delete(resource.uri.toString());
            this.didRemoveNotebookDocumentEmitter.fire(model);
        });
        return model;
    }
    async getNotebookDataProvider(viewType) {
        try {
            return await this.waitForNotebookProvider(viewType);
        }
        catch {
            throw new Error(`No provider registered for view type: '${viewType}'`);
        }
    }
    /**
     * When the application starts up, notebook providers from plugins are not registered yet.
     * It takes a few seconds for the plugin host to start so that notebook data providers can be registered.
     * This methods waits until the notebook provider is registered.
     */
    waitForNotebookProvider(type) {
        const existing = this.notebookProviders.get(type);
        if (existing) {
            return Promise.resolve(existing);
        }
        const deferred = new promise_util_1.Deferred();
        // 20 seconds of timeout
        const timeoutDuration = 20000;
        // Must declare these variables where they can be captured by the closure
        let disposable;
        // eslint-disable-next-line
        let timeout;
        // eslint-disable-next-line
        disposable = this.onDidRegisterNotebookSerializer(viewType => {
            if (viewType === type) {
                clearTimeout(timeout);
                disposable.dispose();
                const newProvider = this.notebookProviders.get(type);
                if (!newProvider) {
                    deferred.reject(new Error(`Notebook provider for type ${type} is invalid`));
                }
                else {
                    deferred.resolve(newProvider);
                }
            }
        });
        timeout = setTimeout(() => {
            clearTimeout(timeout);
            disposable.dispose();
            deferred.reject(new Error(`Timed out while waiting for notebook serializer for type ${type} to be registered`));
        }, timeoutDuration);
        this.ready.promise.then(() => {
            this.willUseNotebookSerializerEmitter.fire(type);
        });
        return deferred.promise;
    }
    getNotebookEditorModel(uri) {
        return this.notebookModels.get(uri.toString());
    }
    getNotebookModels() {
        return this.notebookModels.values();
    }
    async willOpenNotebook(type) {
        return this.willOpenNotebookTypeEmitter.sequence(async (listener) => listener(type));
    }
    listNotebookDocuments() {
        return [...this.notebookModels.values()];
    }
    applyWorkspaceEdit(workspaceEdit) {
        try {
            workspaceEdit.edits.forEach(edit => {
                const notebook = this.getNotebookEditorModel(edit.resource);
                notebook === null || notebook === void 0 ? void 0 : notebook.applyEdits([edit.edit], true);
            });
            return true;
        }
        catch (e) {
            console.error(e);
            return false;
        }
    }
    getCodeCellLanguage(model) {
        var _a;
        const firstCodeCell = model.cells.find(cellModel => cellModel.cellKind === common_1.CellKind.Code);
        const cellLanguage = (_a = firstCodeCell === null || firstCodeCell === void 0 ? void 0 : firstCodeCell.language) !== null && _a !== void 0 ? _a : 'plaintext';
        return cellLanguage;
    }
};
exports.NotebookService = NotebookService;
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], NotebookService.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_model_1.NotebookModelFactory),
    tslib_1.__metadata("design:type", Function)
], NotebookService.prototype, "notebookModelFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_cell_model_1.NotebookCellModelFactory),
    tslib_1.__metadata("design:type", Function)
], NotebookService.prototype, "notebookCellModelFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_monaco_text_model_service_1.NotebookMonacoTextModelService),
    tslib_1.__metadata("design:type", notebook_monaco_text_model_service_1.NotebookMonacoTextModelService)
], NotebookService.prototype, "textModelService", void 0);
exports.NotebookService = NotebookService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookService);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/view-model/notebook-cell-model.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/view-model/notebook-cell-model.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookCodeEditorFindMatch = exports.NotebookCellModel = exports.createNotebookCellModelContainer = exports.NotebookCellModelFactory = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/notebook/lib/common/index.js");
const notebook_monaco_text_model_service_1 = __webpack_require__(/*! ../service/notebook-monaco-text-model-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-monaco-text-model-service.js");
const notebook_cell_output_model_1 = __webpack_require__(/*! ./notebook-cell-output-model */ "../../node_modules/@theia/notebook/lib/browser/view-model/notebook-cell-output-model.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const notebook_preferences_1 = __webpack_require__(/*! ../contributions/notebook-preferences */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-preferences.js");
const language_service_1 = __webpack_require__(/*! @theia/core/lib/browser/language-service */ "../../node_modules/@theia/core/lib/browser/language-service.js");
exports.NotebookCellModelFactory = Symbol('NotebookModelFactory');
function createNotebookCellModelContainer(parent, props) {
    const child = parent.createChild();
    child.bind(NotebookCellModelProps).toConstantValue(props);
    child.bind(NotebookCellModel).toSelf();
    return child;
}
exports.createNotebookCellModelContainer = createNotebookCellModelContainer;
const NotebookCellModelProps = Symbol('NotebookModelProps');
let NotebookCellModel = class NotebookCellModel {
    constructor() {
        this.onDidChangeOutputsEmitter = new core_1.Emitter();
        this.onDidChangeOutputs = this.onDidChangeOutputsEmitter.event;
        this.onDidChangeOutputItemsEmitter = new core_1.Emitter();
        this.onDidChangeOutputItems = this.onDidChangeOutputItemsEmitter.event;
        this.onDidChangeContentEmitter = new core_1.Emitter();
        this.onDidChangeContent = this.onDidChangeContentEmitter.event;
        this.onDidChangeMetadataEmitter = new core_1.Emitter();
        this.onDidChangeMetadata = this.onDidChangeMetadataEmitter.event;
        this.onDidChangeInternalMetadataEmitter = new core_1.Emitter();
        this.onDidChangeInternalMetadata = this.onDidChangeInternalMetadataEmitter.event;
        this.onDidChangeLanguageEmitter = new core_1.Emitter();
        this.onDidChangeLanguage = this.onDidChangeLanguageEmitter.event;
        this.onDidRequestCellEditChangeEmitter = new core_1.Emitter();
        this.onDidRequestCellEditChange = this.onDidRequestCellEditChangeEmitter.event;
        this.onWillFocusCellEditorEmitter = new core_1.Emitter();
        this.onWillFocusCellEditor = this.onWillFocusCellEditorEmitter.event;
        this.onWillBlurCellEditorEmitter = new core_1.Emitter();
        this.onWillBlurCellEditor = this.onWillBlurCellEditorEmitter.event;
        this.onDidChangeEditorOptionsEmitter = new core_1.Emitter();
        this.onDidChangeEditorOptions = this.onDidChangeEditorOptionsEmitter.event;
        this.outputVisibilityChangeEmitter = new core_1.Emitter();
        this.onDidChangeOutputVisibility = this.outputVisibilityChangeEmitter.event;
        this.onDidFindMatchesEmitter = new core_1.Emitter();
        this.onDidFindMatches = this.onDidFindMatchesEmitter.event;
        this.onDidSelectFindMatchEmitter = new core_1.Emitter();
        this.onDidSelectFindMatch = this.onDidSelectFindMatchEmitter.event;
        this.onDidRequestCenterEditorEmitter = new core_1.Emitter();
        this.onDidRequestCenterEditor = this.onDidRequestCenterEditorEmitter.event;
        this.onDidCellHeightChangeEmitter = new core_1.Emitter();
        this.onDidCellHeightChange = this.onDidCellHeightChangeEmitter.event;
        this.toDispose = new core_1.DisposableCollection();
        this._editing = false;
        this._editorOptions = {};
        this._outputVisible = true;
        this._selection = undefined;
        this._cellheight = 0;
    }
    get outputs() {
        return this._outputs;
    }
    get metadata() {
        return this._metadata;
    }
    set metadata(newMetadata) {
        this._metadata = newMetadata;
        this.onDidChangeMetadataEmitter.fire();
    }
    get internalMetadata() {
        return this._internalMetadata;
    }
    set internalMetadata(newInternalMetadata) {
        const lastRunSuccessChanged = this._internalMetadata.lastRunSuccess !== newInternalMetadata.lastRunSuccess;
        newInternalMetadata = {
            ...newInternalMetadata,
            ...{ runStartTimeAdjustment: computeRunStartTimeAdjustment(this._internalMetadata, newInternalMetadata) }
        };
        this._internalMetadata = newInternalMetadata;
        this.onDidChangeInternalMetadataEmitter.fire({ lastRunSuccessChanged });
    }
    get text() {
        return this.textModel && !this.textModel.isDisposed() ? this.textModel.getText() : this.source;
    }
    get source() {
        return this.props.source;
    }
    set source(source) {
        var _a;
        this.props.source = source;
        (_a = this.textModel) === null || _a === void 0 ? void 0 : _a.textEditorModel.setValue(source);
    }
    get language() {
        return this.props.language;
    }
    set language(newLanguage) {
        if (this.language === newLanguage) {
            return;
        }
        if (this.textModel) {
            this.textModel.setLanguageId(newLanguage);
        }
        this.props.language = newLanguage;
        this.onDidChangeLanguageEmitter.fire(newLanguage);
        this.onDidChangeContentEmitter.fire('language');
    }
    get languageName() {
        var _a, _b;
        return (_b = (_a = this.languageService.getLanguage(this.language)) === null || _a === void 0 ? void 0 : _a.name) !== null && _b !== void 0 ? _b : this.language;
    }
    get uri() {
        return this.props.uri;
    }
    get handle() {
        return this.props.handle;
    }
    get cellKind() {
        return this.props.cellKind;
    }
    get editing() {
        return this._editing;
    }
    get editorOptions() {
        return this._editorOptions;
    }
    set editorOptions(options) {
        this._editorOptions = options;
        this.onDidChangeEditorOptionsEmitter.fire(options);
    }
    get outputVisible() {
        return this._outputVisible;
    }
    set outputVisible(visible) {
        if (this._outputVisible !== visible) {
            this._outputVisible = visible;
            this.outputVisibilityChangeEmitter.fire(visible);
        }
    }
    get selection() {
        return this._selection;
    }
    set selection(selection) {
        this._selection = selection;
    }
    get cellHeight() {
        return this._cellheight;
    }
    set cellHeight(height) {
        if (height !== this._cellheight) {
            this.onDidCellHeightChangeEmitter.fire(height);
            this._cellheight = height;
        }
    }
    init() {
        var _a, _b;
        this._outputs = this.props.outputs.map(op => new notebook_cell_output_model_1.NotebookCellOutputModel(op));
        this._metadata = (_a = this.props.metadata) !== null && _a !== void 0 ? _a : {};
        this._internalMetadata = (_b = this.props.internalMetadata) !== null && _b !== void 0 ? _b : {};
        this.editorOptions = {
            lineNumbers: this.preferenceService.get(notebook_preferences_1.NotebookPreferences.NOTEBOOK_LINE_NUMBERS)
        };
        this.toDispose.push(this.preferenceService.onPreferenceChanged(e => {
            if (e.preferenceName === notebook_preferences_1.NotebookPreferences.NOTEBOOK_LINE_NUMBERS) {
                this.editorOptions = {
                    ...this.editorOptions,
                    lineNumbers: this.preferenceService.get(notebook_preferences_1.NotebookPreferences.NOTEBOOK_LINE_NUMBERS)
                };
            }
        }));
    }
    dispose() {
        this.onDidChangeOutputsEmitter.dispose();
        this.onDidChangeOutputItemsEmitter.dispose();
        this.onDidChangeContentEmitter.dispose();
        this.onDidChangeMetadataEmitter.dispose();
        this.onDidChangeInternalMetadataEmitter.dispose();
        this.onDidChangeLanguageEmitter.dispose();
        this.toDispose.dispose();
    }
    requestEdit() {
        if (!this.textModel || !this.textModel.readOnly) {
            this._editing = true;
            this.onDidRequestCellEditChangeEmitter.fire(true);
        }
    }
    requestStopEdit() {
        this._editing = false;
        this.onDidRequestCellEditChangeEmitter.fire(false);
    }
    requestFocusEditor(focusRequest) {
        this.requestEdit();
        this.onWillFocusCellEditorEmitter.fire(focusRequest);
    }
    requestBlurEditor() {
        this.requestStopEdit();
        this.onWillBlurCellEditorEmitter.fire();
    }
    requestCenterEditor() {
        this.onDidRequestCenterEditorEmitter.fire();
    }
    spliceNotebookCellOutputs(splice) {
        if (splice.deleteCount > 0 && splice.newOutputs.length > 0) {
            const commonLen = Math.min(splice.deleteCount, splice.newOutputs.length);
            // update
            for (let i = 0; i < commonLen; i++) {
                const currentOutput = this.outputs[splice.start + i];
                const newOutput = splice.newOutputs[i];
                this.replaceOutputData(currentOutput.outputId, newOutput);
            }
            this.outputs.splice(splice.start + commonLen, splice.deleteCount - commonLen, ...splice.newOutputs.slice(commonLen).map(op => new notebook_cell_output_model_1.NotebookCellOutputModel(op)));
            this.onDidChangeOutputsEmitter.fire({ start: splice.start + commonLen, deleteCount: splice.deleteCount - commonLen, newOutputs: splice.newOutputs.slice(commonLen) });
        }
        else {
            this.outputs.splice(splice.start, splice.deleteCount, ...splice.newOutputs.map(op => new notebook_cell_output_model_1.NotebookCellOutputModel(op)));
            this.onDidChangeOutputsEmitter.fire(splice);
        }
    }
    replaceOutputData(outputId, newOutputData) {
        const output = this.outputs.find(out => out.outputId === outputId);
        if (!output) {
            return false;
        }
        output.replaceData(newOutputData);
        this.onDidChangeOutputItemsEmitter.fire(output);
        return true;
    }
    changeOutputItems(outputId, append, items) {
        const output = this.outputs.find(out => out.outputId === outputId);
        if (!output) {
            return false;
        }
        if (append) {
            output.appendData(items);
        }
        else {
            output.replaceData({ outputId: outputId, outputs: items, metadata: output.metadata });
        }
        this.onDidChangeOutputItemsEmitter.fire(output);
        return true;
    }
    getData() {
        return {
            cellKind: this.cellKind,
            language: this.language,
            outputs: this.outputs.map(output => output.getData()),
            source: this.text,
            collapseState: this.props.collapseState,
            internalMetadata: this.internalMetadata,
            metadata: this.metadata
        };
    }
    async resolveTextModel() {
        if (this.textModel) {
            return this.textModel;
        }
        const ref = await this.textModelService.getOrCreateNotebookCellModelReference(this.uri);
        this.textModel = ref.object;
        this.toDispose.push(ref);
        this.toDispose.push(this.textModel.onDidChangeContent(e => {
            this.props.source = e.model.getText();
        }));
        return ref.object;
    }
    restartOutputRenderer(outputId) {
        const output = this.outputs.find(out => out.outputId === outputId);
        if (output) {
            this.onDidChangeOutputItemsEmitter.fire(output);
        }
    }
    showMatch(selected) {
        this.onDidSelectFindMatchEmitter.fire(selected);
    }
    findMatches(options) {
        var _a, _b;
        if (this.cellKind === common_1.CellKind.Markup && !this.editing) {
            return (_b = (_a = this.onMarkdownFind) === null || _a === void 0 ? void 0 : _a.call(this, options)) !== null && _b !== void 0 ? _b : [];
        }
        if (!this.textModel) {
            return [];
        }
        const matches = options.search ? this.textModel.findMatches({
            searchString: options.search,
            isRegex: options.regex,
            matchCase: options.matchCase,
            matchWholeWord: options.wholeWord
        }) : [];
        const editorFindMatches = matches.map(match => new NotebookCodeEditorFindMatch(this, match.range, this.textModel));
        this.onDidFindMatchesEmitter.fire(editorFindMatches);
        return editorFindMatches;
    }
    replaceAll(matches, value) {
        var _a;
        const editOperations = matches.map(match => ({
            range: {
                startColumn: match.range.start.character,
                startLineNumber: match.range.start.line,
                endColumn: match.range.end.character,
                endLineNumber: match.range.end.line
            },
            text: value
        }));
        (_a = this.textModel) === null || _a === void 0 ? void 0 : _a.textEditorModel.pushEditOperations(
        // eslint-disable-next-line no-null/no-null
        null, editOperations, 
        // eslint-disable-next-line no-null/no-null
        () => null);
    }
};
exports.NotebookCellModel = NotebookCellModel;
tslib_1.__decorate([
    (0, inversify_1.inject)(NotebookCellModelProps),
    tslib_1.__metadata("design:type", Object)
], NotebookCellModel.prototype, "props", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_monaco_text_model_service_1.NotebookMonacoTextModelService),
    tslib_1.__metadata("design:type", notebook_monaco_text_model_service_1.NotebookMonacoTextModelService)
], NotebookCellModel.prototype, "textModelService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(language_service_1.LanguageService),
    tslib_1.__metadata("design:type", language_service_1.LanguageService)
], NotebookCellModel.prototype, "languageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], NotebookCellModel.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], NotebookCellModel.prototype, "init", null);
exports.NotebookCellModel = NotebookCellModel = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookCellModel);
class NotebookCodeEditorFindMatch {
    constructor(cell, range, textModel) {
        this.cell = cell;
        this.range = range;
        this.textModel = textModel;
        this.selected = false;
    }
    show() {
        this.cell.showMatch(this);
    }
    replace(value) {
        this.textModel.textEditorModel.pushEditOperations(
        // eslint-disable-next-line no-null/no-null
        null, [{
                range: {
                    startColumn: this.range.start.character,
                    startLineNumber: this.range.start.line,
                    endColumn: this.range.end.character,
                    endLineNumber: this.range.end.line
                },
                text: value
            }], 
        // eslint-disable-next-line no-null/no-null
        () => null);
    }
}
exports.NotebookCodeEditorFindMatch = NotebookCodeEditorFindMatch;
function computeRunStartTimeAdjustment(oldMetadata, newMetadata) {
    if (oldMetadata.runStartTime !== newMetadata.runStartTime && typeof newMetadata.runStartTime === 'number') {
        const offset = Date.now() - newMetadata.runStartTime;
        return offset < 0 ? Math.abs(offset) : 0;
    }
    else {
        return newMetadata.runStartTimeAdjustment;
    }
}


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/view-model/notebook-cell-output-model.js":
/*!***********************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/view-model/notebook-cell-output-model.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookCellOutputModel = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/notebook/lib/common/index.js");
const notebook_output_utils_1 = __webpack_require__(/*! ../notebook-output-utils */ "../../node_modules/@theia/notebook/lib/browser/notebook-output-utils.js");
class NotebookCellOutputModel {
    get outputId() {
        return this.rawOutput.outputId;
    }
    get outputs() {
        return this.rawOutput.outputs || [];
    }
    get metadata() {
        return this.rawOutput.metadata;
    }
    constructor(rawOutput) {
        this.rawOutput = rawOutput;
        this.didChangeDataEmitter = new core_1.Emitter();
        this.onDidChangeData = this.didChangeDataEmitter.event;
    }
    replaceData(rawData) {
        this.rawOutput = rawData;
        this.optimizeOutputItems();
        this.didChangeDataEmitter.fire();
    }
    appendData(items) {
        this.rawOutput.outputs.push(...items);
        this.optimizeOutputItems();
        this.didChangeDataEmitter.fire();
    }
    dispose() {
        this.didChangeDataEmitter.dispose();
    }
    getData() {
        return {
            outputs: this.outputs,
            metadata: this.metadata,
            outputId: this.outputId
        };
    }
    optimizeOutputItems() {
        if (this.outputs.length > 1 && this.outputs.every(item => (0, common_1.isTextStreamMime)(item.mime))) {
            // Look for the mimes in the items, and keep track of their order.
            // Merge the streams into one output item, per mime type.
            const mimeOutputs = new Map();
            const mimeTypes = [];
            this.outputs.forEach(item => {
                let items;
                if (mimeOutputs.has(item.mime)) {
                    items = mimeOutputs.get(item.mime);
                }
                else {
                    items = [];
                    mimeOutputs.set(item.mime, items);
                    mimeTypes.push(item.mime);
                }
                items.push(item.data.buffer);
            });
            this.outputs.length = 0;
            mimeTypes.forEach(mime => {
                const compressionResult = (0, notebook_output_utils_1.compressOutputItemStreams)(mimeOutputs.get(mime));
                this.outputs.push({
                    mime,
                    data: compressionResult.data
                });
            });
        }
    }
}
exports.NotebookCellOutputModel = NotebookCellOutputModel;


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/view-model/notebook-model.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/view-model/notebook-model.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 Typefox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookModel = exports.NotebookModelResolverServiceProxy = exports.createNotebookModelContainer = exports.NotebookModelFactory = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/notebook/lib/common/index.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const notebook_cell_model_1 = __webpack_require__(/*! ./notebook-cell-model */ "../../node_modules/@theia/notebook/lib/browser/view-model/notebook-cell-model.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const undo_redo_service_1 = __webpack_require__(/*! @theia/editor/lib/browser/undo-redo-service */ "../../node_modules/@theia/editor/lib/browser/undo-redo-service.js");
exports.NotebookModelFactory = Symbol('NotebookModelFactory');
function createNotebookModelContainer(parent, props) {
    const child = parent.createChild();
    child.bind(NotebookModelProps).toConstantValue(props);
    child.bind(NotebookModel).toSelf();
    return child;
}
exports.createNotebookModelContainer = createNotebookModelContainer;
exports.NotebookModelResolverServiceProxy = Symbol('NotebookModelResolverServiceProxy');
const NotebookModelProps = Symbol('NotebookModelProps');
let NotebookModel = class NotebookModel {
    constructor() {
        this.onDirtyChangedEmitter = new core_1.Emitter();
        this.onDirtyChanged = this.onDirtyChangedEmitter.event;
        this.onDidSaveNotebookEmitter = new core_1.Emitter();
        this.onDidSaveNotebook = this.onDidSaveNotebookEmitter.event;
        this.onDidAddOrRemoveCellEmitter = new core_1.Emitter();
        this.onDidAddOrRemoveCell = this.onDidAddOrRemoveCellEmitter.event;
        this.onDidChangeContentEmitter = new core_1.QueueableEmitter();
        this.onDidChangeContent = this.onDidChangeContentEmitter.event;
        this.onContentChangedEmitter = new core_1.Emitter();
        this.onContentChanged = this.onContentChangedEmitter.event;
        this.onDidChangeSelectedCellEmitter = new core_1.Emitter();
        this.onDidChangeSelectedCell = this.onDidChangeSelectedCellEmitter.event;
        this.onDidDisposeEmitter = new core_1.Emitter();
        this.onDidDispose = this.onDidDisposeEmitter.event;
        this.nextHandle = 0;
        this._dirty = false;
        this._selectedText = '';
        this.dirtyCells = [];
        this.metadata = {};
    }
    get onDidChangeReadOnly() {
        var _a;
        return (_a = this.props.resource.onDidChangeReadOnly) !== null && _a !== void 0 ? _a : core_1.Event.None;
    }
    set dirty(dirty) {
        const oldState = this._dirty;
        this._dirty = dirty;
        if (oldState !== dirty) {
            this.onDirtyChangedEmitter.fire();
        }
    }
    get dirty() {
        return this._dirty;
    }
    get readOnly() {
        var _a;
        return (_a = this.props.resource.readOnly) !== null && _a !== void 0 ? _a : false;
    }
    set selectedText(value) {
        this._selectedText = value;
    }
    get selectedText() {
        return this._selectedText;
    }
    get uri() {
        return this.props.resource.uri;
    }
    get viewType() {
        return this.props.viewType;
    }
    initialize() {
        this.dirty = false;
        this.cells = this.props.data.cells.map((cell, index) => this.cellModelFactory({
            uri: common_1.CellUri.generate(this.props.resource.uri, index),
            handle: index,
            source: cell.source,
            language: cell.language,
            cellKind: cell.cellKind,
            outputs: cell.outputs,
            metadata: cell.metadata,
            internalMetadata: cell.internalMetadata,
            collapseState: cell.collapseState
        }));
        this.addCellOutputListeners(this.cells);
        this.metadata = this.props.data.metadata;
        this.nextHandle = this.cells.length;
    }
    dispose() {
        this.onDirtyChangedEmitter.dispose();
        this.onDidSaveNotebookEmitter.dispose();
        this.onDidAddOrRemoveCellEmitter.dispose();
        this.onDidChangeContentEmitter.dispose();
        this.onDidChangeSelectedCellEmitter.dispose();
        this.cells.forEach(cell => cell.dispose());
        this.onDidDisposeEmitter.fire();
    }
    async save(options) {
        this.dirtyCells = [];
        this.dirty = false;
        const serializedNotebook = await this.serialize();
        this.fileService.writeFile(this.uri, serializedNotebook);
        this.onDidSaveNotebookEmitter.fire();
    }
    createSnapshot() {
        return {
            read: () => JSON.stringify(this.getData())
        };
    }
    serialize() {
        return this.props.serializer.fromNotebook(this.getData());
    }
    async applySnapshot(snapshot) {
        const rawData = browser_1.Saveable.Snapshot.read(snapshot);
        if (!rawData) {
            throw new Error('could not read notebook snapshot');
        }
        const data = JSON.parse(rawData);
        this.setData(data);
    }
    async revert(options) {
        if (!(options === null || options === void 0 ? void 0 : options.soft)) {
            // Load the data from the file again
            try {
                const data = await this.modelResolverService.resolveExistingNotebookData(this.props.resource, this.props.viewType);
                this.setData(data, false);
            }
            catch (err) {
                console.error('Failed to revert notebook', err);
            }
        }
        this.dirty = false;
    }
    isDirty() {
        return this.dirty;
    }
    cellDirtyChanged(cell, dirtyState) {
        if (dirtyState) {
            this.dirtyCells.push(cell);
        }
        else {
            this.dirtyCells.splice(this.dirtyCells.indexOf(cell), 1);
        }
        this.dirty = this.dirtyCells.length > 0;
        // Only fire `onContentChangedEmitter` here, because `onDidChangeContentEmitter` is used for model level changes only
        // However, this event indicates that the content of a cell has changed
        this.onContentChangedEmitter.fire();
    }
    setData(data, markDirty = true) {
        // Replace all cells in the model
        this.dirtyCells = [];
        this.replaceCells(0, this.cells.length, data.cells, false, false);
        this.metadata = data.metadata;
        this.dirty = markDirty;
        this.onDidChangeContentEmitter.fire();
    }
    getData() {
        return {
            cells: this.cells.map(cell => cell.getData()),
            metadata: this.metadata
        };
    }
    undo() {
        if (!this.readOnly) {
            this.undoRedoService.undo(this.uri);
        }
    }
    redo() {
        if (!this.readOnly) {
            this.undoRedoService.redo(this.uri);
        }
    }
    setSelectedCell(cell, scrollIntoView) {
        if (this.selectedCell !== cell) {
            this.selectedCell = cell;
            this.onDidChangeSelectedCellEmitter.fire({ cell, scrollIntoView: scrollIntoView !== null && scrollIntoView !== void 0 ? scrollIntoView : true });
        }
    }
    addCellOutputListeners(cells) {
        for (const cell of cells) {
            cell.onDidChangeOutputs(() => {
                this.dirty = true;
            });
            cell.onDidRequestCellEditChange(() => {
                this.onContentChangedEmitter.fire();
            });
        }
    }
    getVisibleCells() {
        return this.cells;
    }
    applyEdits(rawEdits, computeUndoRedo) {
        var _a, _b, _c;
        const editsWithDetails = rawEdits.map((edit, index) => {
            let cellIndex = -1;
            if ('index' in edit) {
                cellIndex = edit.index;
            }
            else if ('handle' in edit) {
                cellIndex = this.getCellIndexByHandle(edit.handle);
            }
            else if ('outputId' in edit) {
                cellIndex = this.cells.findIndex(cell => cell.outputs.some(output => output.outputId === edit.outputId));
            }
            return {
                edit,
                cellIndex,
                end: edit.editType === 1 /* CellEditType.Replace */ ? edit.index + edit.count : cellIndex,
                originalIndex: index
            };
        });
        for (const { edit, cellIndex } of editsWithDetails) {
            const cell = this.cells[cellIndex];
            if (cell) {
                this.cellDirtyChanged(cell, true);
            }
            let scrollIntoView = true;
            switch (edit.editType) {
                case 1 /* CellEditType.Replace */:
                    this.replaceCells(edit.index, edit.count, edit.cells, computeUndoRedo, true);
                    scrollIntoView = edit.cells.length > 0;
                    break;
                case 2 /* CellEditType.Output */: {
                    if (edit.append) {
                        cell.spliceNotebookCellOutputs({ deleteCount: 0, newOutputs: edit.outputs, start: cell.outputs.length });
                    }
                    else {
                        // could definitely be more efficient. See vscode __spliceNotebookCellOutputs2
                        // For now, just replace the whole existing output with the new output
                        cell.spliceNotebookCellOutputs({ start: 0, deleteCount: (_a = edit.deleteCount) !== null && _a !== void 0 ? _a : cell.outputs.length, newOutputs: edit.outputs });
                    }
                    this.onDidChangeContentEmitter.queue({ kind: common_1.NotebookCellsChangeType.Output, index: cellIndex, outputs: cell.outputs, append: (_b = edit.append) !== null && _b !== void 0 ? _b : false });
                    break;
                }
                case 7 /* CellEditType.OutputItems */:
                    cell.changeOutputItems(edit.outputId, !!edit.append, edit.items);
                    this.onDidChangeContentEmitter.queue({
                        kind: common_1.NotebookCellsChangeType.OutputItem, index: cellIndex, outputItems: edit.items,
                        outputId: edit.outputId, append: (_c = edit.append) !== null && _c !== void 0 ? _c : false
                    });
                    break;
                case 3 /* CellEditType.Metadata */:
                    this.changeCellMetadata(this.cells[cellIndex], edit.metadata, false);
                    break;
                case 8 /* CellEditType.PartialMetadata */:
                    this.changeCellMetadataPartial(this.cells[cellIndex], edit.metadata, false);
                    break;
                case 9 /* CellEditType.PartialInternalMetadata */:
                    this.changeCellInternalMetadataPartial(this.cells[cellIndex], edit.internalMetadata);
                    break;
                case 4 /* CellEditType.CellLanguage */:
                    this.changeCellLanguage(this.cells[cellIndex], edit.language, computeUndoRedo);
                    break;
                case 5 /* CellEditType.DocumentMetadata */:
                    this.updateNotebookMetadata(edit.metadata, false);
                    break;
                case 6 /* CellEditType.Move */:
                    this.moveCellToIndex(cellIndex, edit.length, edit.newIdx, computeUndoRedo);
                    break;
            }
            // if selected cell is affected update it because it can potentially have been replaced
            if (cell === this.selectedCell) {
                this.setSelectedCell(this.cells[Math.min(cellIndex, this.cells.length - 1)], scrollIntoView);
            }
        }
        this.fireContentChange();
    }
    fireContentChange() {
        this.onDidChangeContentEmitter.fire();
        this.onContentChangedEmitter.fire();
    }
    replaceCells(start, deleteCount, newCells, computeUndoRedo, requestEdit) {
        var _a, _b;
        const cells = newCells.map(cell => {
            const handle = this.nextHandle++;
            return this.cellModelFactory({
                uri: common_1.CellUri.generate(this.uri, handle),
                handle: handle,
                source: cell.source,
                language: cell.language,
                cellKind: cell.cellKind,
                outputs: cell.outputs,
                metadata: cell.metadata,
                internalMetadata: cell.internalMetadata,
                collapseState: cell.collapseState
            });
        });
        this.addCellOutputListeners(cells);
        const changes = [{
                start,
                deleteCount,
                newItems: cells,
                startHandle: (_b = (_a = this.cells[start]) === null || _a === void 0 ? void 0 : _a.handle) !== null && _b !== void 0 ? _b : -1 // -1 in case of new Cells are added at the end.
            }];
        const deletedCells = this.cells.splice(start, deleteCount, ...cells);
        for (const cell of deletedCells) {
            cell.dispose();
        }
        if (computeUndoRedo) {
            this.undoRedoService.pushElement(this.uri, async () => {
                this.replaceCells(start, newCells.length, deletedCells.map(cell => cell.getData()), false, false);
                this.fireContentChange();
            }, async () => {
                this.replaceCells(start, deleteCount, newCells, false, false);
                this.fireContentChange();
            });
        }
        this.onDidAddOrRemoveCellEmitter.fire({ rawEvent: { kind: common_1.NotebookCellsChangeType.ModelChange, changes }, newCellIds: cells.map(cell => cell.handle) });
        this.onDidChangeContentEmitter.queue({ kind: common_1.NotebookCellsChangeType.ModelChange, changes });
        if (cells.length > 0 && requestEdit) {
            this.setSelectedCell(cells[cells.length - 1]);
            cells[cells.length - 1].requestEdit();
        }
    }
    changeCellInternalMetadataPartial(cell, internalMetadata) {
        var _a;
        const newInternalMetadata = {
            ...cell.internalMetadata
        };
        let k;
        // eslint-disable-next-line guard-for-in
        for (k in internalMetadata) {
            newInternalMetadata[k] = ((_a = internalMetadata[k]) !== null && _a !== void 0 ? _a : undefined);
        }
        cell.internalMetadata = newInternalMetadata;
        this.onDidChangeContentEmitter.queue({ kind: common_1.NotebookCellsChangeType.ChangeCellInternalMetadata, index: this.cells.indexOf(cell), internalMetadata: newInternalMetadata });
    }
    updateNotebookMetadata(metadata, computeUndoRedo) {
        const oldMetadata = this.metadata;
        if (computeUndoRedo) {
            this.undoRedoService.pushElement(this.uri, async () => this.updateNotebookMetadata(oldMetadata, false), async () => this.updateNotebookMetadata(metadata, false));
        }
        this.metadata = metadata;
        this.onDidChangeContentEmitter.queue({ kind: common_1.NotebookCellsChangeType.ChangeDocumentMetadata, metadata: this.metadata });
    }
    changeCellMetadataPartial(cell, metadata, computeUndoRedo) {
        var _a;
        const newMetadata = {
            ...cell.metadata
        };
        let k;
        // eslint-disable-next-line guard-for-in
        for (k in metadata) {
            const value = (_a = metadata[k]) !== null && _a !== void 0 ? _a : undefined;
            newMetadata[k] = value;
        }
        this.changeCellMetadata(cell, newMetadata, computeUndoRedo);
    }
    changeCellMetadata(cell, metadata, computeUndoRedo) {
        const triggerDirtyChange = this.isCellMetadataChanged(cell.metadata, metadata);
        if (triggerDirtyChange) {
            if (computeUndoRedo) {
                const oldMetadata = cell.metadata;
                cell.metadata = metadata;
                this.undoRedoService.pushElement(this.uri, async () => { cell.metadata = oldMetadata; }, async () => { cell.metadata = metadata; });
            }
        }
        cell.metadata = metadata;
        this.onDidChangeContentEmitter.queue({ kind: common_1.NotebookCellsChangeType.ChangeCellMetadata, index: this.cells.indexOf(cell), metadata: cell.metadata });
    }
    changeCellLanguage(cell, languageId, computeUndoRedo) {
        if (cell.language === languageId) {
            return;
        }
        cell.language = languageId;
        this.onDidChangeContentEmitter.queue({ kind: common_1.NotebookCellsChangeType.ChangeCellLanguage, index: this.cells.indexOf(cell), language: languageId });
    }
    moveCellToIndex(fromIndex, length, toIndex, computeUndoRedo) {
        if (computeUndoRedo) {
            this.undoRedoService.pushElement(this.uri, async () => {
                this.moveCellToIndex(toIndex, length, fromIndex, false);
                this.fireContentChange();
            }, async () => {
                this.moveCellToIndex(fromIndex, length, toIndex, false);
                this.fireContentChange();
            });
        }
        const cells = this.cells.splice(fromIndex, length);
        this.cells.splice(toIndex, 0, ...cells);
        this.onDidChangeContentEmitter.queue({ kind: common_1.NotebookCellsChangeType.Move, index: fromIndex, length, newIdx: toIndex, cells });
        return true;
    }
    getCellIndexByHandle(handle) {
        return this.cells.findIndex(c => c.handle === handle);
    }
    getCellByHandle(handle) {
        return this.cells.find(c => c.handle === handle);
    }
    isCellMetadataChanged(a, b) {
        const keys = new Set([...Object.keys(a || {}), ...Object.keys(b || {})]);
        for (const key of keys) {
            if (a[key] !== b[key]) {
                return true;
            }
        }
        return false;
    }
    findMatches(options) {
        const matches = [];
        for (const cell of this.cells) {
            matches.push(...cell.findMatches(options));
        }
        return matches;
    }
    replaceAll(matches, text) {
        var _a;
        const matchMap = new Map();
        for (const match of matches) {
            if (match instanceof notebook_cell_model_1.NotebookCodeEditorFindMatch) {
                if (!matchMap.has(match.cell)) {
                    matchMap.set(match.cell, []);
                }
                (_a = matchMap.get(match.cell)) === null || _a === void 0 ? void 0 : _a.push(match);
            }
        }
        for (const [cell, cellMatches] of matchMap) {
            cell.replaceAll(cellMatches, text);
        }
    }
};
exports.NotebookModel = NotebookModel;
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], NotebookModel.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(undo_redo_service_1.UndoRedoService),
    tslib_1.__metadata("design:type", undo_redo_service_1.UndoRedoService)
], NotebookModel.prototype, "undoRedoService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(NotebookModelProps),
    tslib_1.__metadata("design:type", Object)
], NotebookModel.prototype, "props", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_cell_model_1.NotebookCellModelFactory),
    tslib_1.__metadata("design:type", Function)
], NotebookModel.prototype, "cellModelFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(exports.NotebookModelResolverServiceProxy),
    tslib_1.__metadata("design:type", Function)
], NotebookModel.prototype, "modelResolverService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], NotebookModel.prototype, "initialize", null);
exports.NotebookModel = NotebookModel = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookModel);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/view/notebook-cell-editor.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/view/notebook-cell-editor.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CellEditor = exports.FIND_MATCH_DECORATION = exports.CURRENT_FIND_MATCH_DECORATION = void 0;
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const simple_monaco_editor_1 = __webpack_require__(/*! @theia/monaco/lib/browser/simple-monaco-editor */ "../../node_modules/@theia/monaco/lib/browser/simple-monaco-editor.js");
const monaco_editor_provider_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-editor-provider */ "../../node_modules/@theia/monaco/lib/browser/monaco-editor-provider.js");
const contextkey_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/platform/contextkey/common/contextkey */ "../../node_modules/@theia/monaco-editor-core/esm/vs/platform/contextkey/common/contextkey.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const notebook_context_keys_1 = __webpack_require__(/*! ../contributions/notebook-context-keys */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-context-keys.js");
const editorExtensions_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/browser/editorExtensions */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/browser/editorExtensions.js");
const textModel_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/common/model/textModel */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/common/model/textModel.js");
const model_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/editor/common/model */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/common/model.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const DEFAULT_EDITOR_OPTIONS = {
    ...monaco_editor_provider_1.MonacoEditorProvider.inlineOptions,
    minHeight: -1,
    maxHeight: -1,
    scrollbar: {
        ...monaco_editor_provider_1.MonacoEditorProvider.inlineOptions.scrollbar,
        alwaysConsumeMouseWheel: false
    },
    lineDecorationsWidth: 10,
};
exports.CURRENT_FIND_MATCH_DECORATION = textModel_1.ModelDecorationOptions.register({
    description: 'current-find-match',
    stickiness: 1 /* TrackedRangeStickiness.NeverGrowsWhenTypingAtEdges */,
    zIndex: 13,
    className: 'currentFindMatch',
    inlineClassName: 'currentFindMatchInline',
    showIfCollapsed: true,
    overviewRuler: {
        color: 'editorOverviewRuler.findMatchForeground',
        position: model_1.OverviewRulerLane.Center
    }
});
exports.FIND_MATCH_DECORATION = textModel_1.ModelDecorationOptions.register({
    description: 'find-match',
    stickiness: 1 /* TrackedRangeStickiness.NeverGrowsWhenTypingAtEdges */,
    zIndex: 10,
    className: 'findMatch',
    inlineClassName: 'findMatchInline',
    showIfCollapsed: true,
    overviewRuler: {
        color: 'editorOverviewRuler.findMatchForeground',
        position: model_1.OverviewRulerLane.Center
    }
});
class CellEditor extends React.Component {
    constructor() {
        super(...arguments);
        this.toDispose = new core_1.DisposableCollection();
        this.matches = [];
        this.oldMatchDecorations = [];
        this.handleResize = () => {
            var _a;
            (_a = this.editor) === null || _a === void 0 ? void 0 : _a.refresh();
        };
    }
    componentDidMount() {
        var _a;
        this.disposeEditor();
        this.toDispose.push(this.props.cell.onWillFocusCellEditor(focusRequest => {
            var _a, _b, _c, _d, _e, _f;
            (_a = this.editor) === null || _a === void 0 ? void 0 : _a.getControl().focus();
            const lineCount = (_c = (_b = this.editor) === null || _b === void 0 ? void 0 : _b.getControl().getModel()) === null || _c === void 0 ? void 0 : _c.getLineCount();
            if (focusRequest && lineCount !== undefined) {
                (_d = this.editor) === null || _d === void 0 ? void 0 : _d.getControl().setPosition(focusRequest === 'lastLine' ?
                    { lineNumber: lineCount, column: 1 } :
                    { lineNumber: focusRequest, column: 1 }, 'keyboard');
            }
            const currentLine = (_f = (_e = this.editor) === null || _e === void 0 ? void 0 : _e.getControl().getPosition()) === null || _f === void 0 ? void 0 : _f.lineNumber;
            this.props.notebookContextManager.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_CELL_CURSOR_FIRST_LINE, currentLine === 1);
            this.props.notebookContextManager.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_CELL_CURSOR_LAST_LINE, currentLine === lineCount);
        }));
        this.toDispose.push(this.props.cell.onWillBlurCellEditor(() => this.blurEditor()));
        this.toDispose.push(this.props.cell.onDidChangeEditorOptions(options => {
            var _a;
            (_a = this.editor) === null || _a === void 0 ? void 0 : _a.getControl().updateOptions(options);
        }));
        this.toDispose.push(this.props.cell.onDidChangeLanguage(language => {
            var _a;
            (_a = this.editor) === null || _a === void 0 ? void 0 : _a.setLanguage(language);
        }));
        this.toDispose.push(this.props.cell.onDidFindMatches(matches => {
            this.matches = matches;
            (0, browser_1.animationFrame)().then(() => this.setMatches());
        }));
        this.toDispose.push(this.props.cell.onDidSelectFindMatch(match => this.centerEditorInView()));
        this.toDispose.push(this.props.notebookModel.onDidChangeSelectedCell(e => {
            var _a;
            if (e.cell !== this.props.cell && ((_a = this.editor) === null || _a === void 0 ? void 0 : _a.getControl().hasTextFocus())) {
                this.blurEditor();
            }
        }));
        if (!this.props.notebookViewportService || (this.container && this.props.notebookViewportService.isElementInViewport(this.container))) {
            this.initEditor();
        }
        else {
            const disposable = (_a = this.props.notebookViewportService) === null || _a === void 0 ? void 0 : _a.onDidChangeViewport(() => {
                if (!this.editor && this.container && this.props.notebookViewportService.isElementInViewport(this.container)) {
                    this.initEditor();
                    disposable.dispose();
                }
            });
            this.toDispose.push(disposable);
        }
        this.toDispose.push(this.props.cell.onDidRequestCenterEditor(() => {
            this.centerEditorInView();
        }));
    }
    componentWillUnmount() {
        this.disposeEditor();
    }
    disposeEditor() {
        if (this.editor) {
            this.props.notebookCellEditorService.editorDisposed(this.editor.uri);
        }
        this.toDispose.dispose();
        this.toDispose = new core_1.DisposableCollection();
    }
    centerEditorInView() {
        var _a, _b;
        const editorDomNode = (_a = this.editor) === null || _a === void 0 ? void 0 : _a.getControl().getDomNode();
        if (editorDomNode) {
            editorDomNode.scrollIntoView({
                behavior: 'instant',
                block: 'center'
            });
        }
        else {
            (_b = this.container) === null || _b === void 0 ? void 0 : _b.scrollIntoView({
                behavior: 'instant',
                block: 'center'
            });
        }
    }
    async initEditor() {
        const { cell, notebookModel, monacoServices } = this.props;
        if (this.container) {
            const editorNode = this.container;
            editorNode.style.height = '';
            const editorModel = await cell.resolveTextModel();
            const uri = cell.uri;
            this.editor = new simple_monaco_editor_1.SimpleMonacoEditor(uri, editorModel, editorNode, monacoServices, { ...DEFAULT_EDITOR_OPTIONS, ...cell.editorOptions }, [[contextkey_1.IContextKeyService, this.props.notebookContextManager.scopedStore]], { contributions: editorExtensions_1.EditorExtensionsRegistry.getEditorContributions().filter(c => c.id !== 'editor.contrib.findController') });
            this.toDispose.push(this.editor);
            this.editor.setLanguage(cell.language);
            this.toDispose.push(this.editor.getControl().onDidContentSizeChange(() => {
                editorNode.style.height = this.editor.getControl().getContentHeight() + 7 + 'px';
                this.editor.setSize({ width: -1, height: this.editor.getControl().getContentHeight() });
            }));
            this.toDispose.push(this.editor.onDocumentContentChanged(e => {
                notebookModel.cellDirtyChanged(cell, true);
            }));
            this.toDispose.push(this.editor.getControl().onDidFocusEditorText(() => {
                this.props.notebookModel.setSelectedCell(cell, false);
                this.props.notebookCellEditorService.editorFocusChanged(this.editor);
            }));
            this.toDispose.push(this.editor.getControl().onDidBlurEditorText(() => {
                var _a;
                if (((_a = this.props.notebookCellEditorService.getActiveCell()) === null || _a === void 0 ? void 0 : _a.uri.toString()) === this.props.cell.uri.toString()) {
                    this.props.notebookCellEditorService.editorFocusChanged(undefined);
                }
            }));
            this.toDispose.push(this.editor.getControl().onDidChangeCursorSelection(e => {
                const selectedText = this.editor.getControl().getModel().getValueInRange(e.selection);
                // TODO handle secondary selections
                this.props.cell.selection = {
                    start: { line: e.selection.startLineNumber - 1, character: e.selection.startColumn - 1 },
                    end: { line: e.selection.endLineNumber - 1, character: e.selection.endColumn - 1 }
                };
                this.props.notebookModel.selectedText = selectedText;
            }));
            this.toDispose.push(this.editor.getControl().onDidChangeCursorPosition(e => {
                if (e.secondaryPositions.length === 0) {
                    this.props.notebookContextManager.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_CELL_CURSOR_FIRST_LINE, e.position.lineNumber === 1);
                    this.props.notebookContextManager.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_CELL_CURSOR_LAST_LINE, e.position.lineNumber === this.editor.getControl().getModel().getLineCount());
                }
                else {
                    this.props.notebookContextManager.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_CELL_CURSOR_FIRST_LINE, false);
                    this.props.notebookContextManager.scopedStore.setContext(notebook_context_keys_1.NOTEBOOK_CELL_CURSOR_LAST_LINE, false);
                }
            }));
            this.props.notebookCellEditorService.editorCreated(uri, this.editor);
            this.setMatches();
            if (notebookModel.selectedCell === cell) {
                this.editor.getControl().focus();
            }
        }
    }
    setMatches() {
        if (!this.editor) {
            return;
        }
        const decorations = [];
        for (const match of this.matches) {
            const decoration = match.selected ? exports.CURRENT_FIND_MATCH_DECORATION : exports.FIND_MATCH_DECORATION;
            decorations.push({
                range: {
                    startLineNumber: match.range.start.line,
                    startColumn: match.range.start.character,
                    endLineNumber: match.range.end.line,
                    endColumn: match.range.end.character
                },
                options: decoration
            });
        }
        this.oldMatchDecorations = this.editor.getControl()
            .changeDecorations(accessor => accessor.deltaDecorations(this.oldMatchDecorations, decorations));
    }
    setContainer(component) {
        this.container = component !== null && component !== void 0 ? component : undefined;
    }
    ;
    estimateHeight() {
        var _a, _b;
        const lineHeight = (_b = (_a = this.props.fontInfo) === null || _a === void 0 ? void 0 : _a.lineHeight) !== null && _b !== void 0 ? _b : 20;
        return this.props.cell.text.split(core_1.OS.backend.EOL).length * lineHeight + 10 + 7 + 'px';
    }
    render() {
        return React.createElement("div", { className: 'theia-notebook-cell-editor', onResize: this.handleResize, id: this.props.cell.uri.toString(), ref: container => this.setContainer(container), style: { height: this.editor ? undefined : this.estimateHeight() } });
    }
    blurEditor() {
        var _a;
        let parent = (_a = this.container) === null || _a === void 0 ? void 0 : _a.parentElement;
        while (parent && !parent.classList.contains('theia-notebook-cell')) {
            parent = parent.parentElement;
        }
        if (parent) {
            parent.focus();
        }
    }
}
exports.CellEditor = CellEditor;


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/view/notebook-cell-list-view.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/view/notebook-cell-list-view.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookCellDivider = exports.NotebookCellListView = exports.observeCellHeight = void 0;
// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/notebook/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const notebook_actions_contribution_1 = __webpack_require__(/*! ../contributions/notebook-actions-contribution */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-actions-contribution.js");
const notebook_cell_actions_contribution_1 = __webpack_require__(/*! ../contributions/notebook-cell-actions-contribution */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-cell-actions-contribution.js");
function observeCellHeight(ref, cell) {
    var _a;
    if (ref) {
        cell.cellHeight = (_a = ref === null || ref === void 0 ? void 0 : ref.getBoundingClientRect().height) !== null && _a !== void 0 ? _a : 0;
        new ResizeObserver(entries => { var _a; return cell.cellHeight = (_a = ref === null || ref === void 0 ? void 0 : ref.getBoundingClientRect().height) !== null && _a !== void 0 ? _a : 0; }).observe(ref);
    }
}
exports.observeCellHeight = observeCellHeight;
class NotebookCellListView extends React.Component {
    constructor(props) {
        super(props);
        this.toDispose = new core_1.DisposableCollection();
        this.cellListRef = React.createRef();
        this.state = { selectedCell: props.notebookModel.selectedCell, dragOverIndicator: undefined, scrollIntoView: true };
        this.toDispose.push(props.notebookModel.onDidAddOrRemoveCell(e => {
            if (e.newCellIds && e.newCellIds.length > 0) {
                this.setState({
                    ...this.state,
                    selectedCell: this.props.notebookModel.cells.find(model => model.handle === e.newCellIds[e.newCellIds.length - 1]),
                    scrollIntoView: true
                });
            }
            else {
                this.setState({
                    ...this.state,
                    selectedCell: this.props.notebookModel.cells.find(cell => cell === this.state.selectedCell),
                    scrollIntoView: false
                });
            }
        }));
        this.toDispose.push(props.notebookModel.onDidChangeContent(events => {
            if (events.some(e => e.kind === common_1.NotebookCellsChangeType.Move)) {
                // When a cell has been moved, we need to rerender the whole component
                this.forceUpdate();
            }
        }));
        this.toDispose.push(props.notebookModel.onDidChangeSelectedCell(e => {
            this.setState({
                ...this.state,
                selectedCell: e.cell,
                scrollIntoView: e.scrollIntoView
            });
        }));
        this.toDispose.push((0, browser_1.onDomEvent)(document, 'focusin', () => {
            (0, browser_1.animationFrame)().then(() => {
                if (!this.cellListRef.current) {
                    return;
                }
                let hasCellFocus = false;
                let hasFocus = false;
                if (this.cellListRef.current.contains(document.activeElement)) {
                    if (this.props.notebookModel.selectedCell) {
                        hasCellFocus = true;
                    }
                    hasFocus = true;
                }
                this.props.notebookContext.changeCellFocus(hasCellFocus);
                this.props.notebookContext.changeCellListFocus(hasFocus);
            });
        }));
    }
    componentWillUnmount() {
        this.toDispose.dispose();
    }
    render() {
        return React.createElement("ul", { className: 'theia-notebook-cell-list', ref: this.cellListRef, onDragStart: e => this.onDragStart(e) },
            this.props.notebookModel.getVisibleCells()
                .map((cell, index) => React.createElement(React.Fragment, { key: 'cell-' + cell.handle },
                React.createElement(NotebookCellDivider, { menuRegistry: this.props.menuRegistry, isVisible: () => this.isEnabled(), onAddNewCell: (commandId) => this.onAddNewCell(commandId, index), onDrop: e => this.onDrop(e, index), onDragOver: e => this.onDragOver(e, cell, 'top') }),
                React.createElement(CellDropIndicator, { visible: this.shouldRenderDragOverIndicator(cell, 'top') }),
                React.createElement("li", { className: 'theia-notebook-cell' + (this.state.selectedCell === cell ? ' focused' : '') + (this.isEnabled() ? ' draggable' : ''), onDragEnd: e => {
                        var _a;
                        (_a = NotebookCellListView.dragGhost) === null || _a === void 0 ? void 0 : _a.remove();
                        this.setState({ ...this.state, dragOverIndicator: undefined });
                    }, onDragOver: e => this.onDragOver(e, cell), onDrop: e => this.onDrop(e, index), draggable: true, tabIndex: -1, "data-cell-handle": cell.handle, ref: ref => {
                        if (ref && cell === this.state.selectedCell && this.state.scrollIntoView) {
                            ref.scrollIntoView({ block: 'nearest' });
                            if (cell.cellKind === common_1.CellKind.Markup && !cell.editing) {
                                ref.focus();
                            }
                        }
                    }, onClick: e => {
                        this.setState({ ...this.state, selectedCell: cell });
                        this.props.notebookModel.setSelectedCell(cell, false);
                    } },
                    React.createElement("div", { className: 'theia-notebook-cell-sidebar' },
                        React.createElement("div", { className: 'theia-notebook-cell-marker' + (this.state.selectedCell === cell ? ' theia-notebook-cell-marker-selected' : '') }),
                        this.renderCellSidebar(cell)),
                    React.createElement("div", { className: 'theia-notebook-cell-content' }, this.renderCellContent(cell, index)),
                    this.state.selectedCell === cell &&
                        this.props.toolbarRenderer.renderCellToolbar(notebook_cell_actions_contribution_1.NotebookCellActionContribution.ACTION_MENU, cell, {
                            contextMenuArgs: () => [cell], commandArgs: () => [this.props.notebookModel]
                        })),
                React.createElement(CellDropIndicator, { visible: this.shouldRenderDragOverIndicator(cell, 'bottom') }))),
            React.createElement(NotebookCellDivider, { menuRegistry: this.props.menuRegistry, isVisible: () => this.isEnabled(), onAddNewCell: (commandId) => this.onAddNewCell(commandId, this.props.notebookModel.cells.length), onDrop: e => this.onDrop(e, this.props.notebookModel.cells.length - 1), onDragOver: e => this.onDragOver(e, this.props.notebookModel.cells[this.props.notebookModel.cells.length - 1], 'bottom') }));
    }
    renderCellContent(cell, index) {
        const renderer = this.props.renderers.get(cell.cellKind);
        if (!renderer) {
            throw new Error(`No renderer found for cell type ${cell.cellKind}`);
        }
        return renderer.render(this.props.notebookModel, cell, index);
    }
    renderCellSidebar(cell) {
        const renderer = this.props.renderers.get(cell.cellKind);
        if (!renderer) {
            throw new Error(`No renderer found for cell type ${cell.cellKind}`);
        }
        return renderer.renderSidebar(this.props.notebookModel, cell);
    }
    onDragStart(event) {
        var _a, _b;
        event.stopPropagation();
        if (!this.isEnabled()) {
            event.preventDefault();
            return;
        }
        const cellHandle = event.target.getAttribute('data-cell-handle');
        if (!cellHandle) {
            throw new Error('Cell handle not found in element for cell drag event');
        }
        const index = this.props.notebookModel.getCellIndexByHandle(parseInt(cellHandle));
        const cell = this.props.notebookModel.cells[index];
        NotebookCellListView.dragGhost = document.createElement('div');
        NotebookCellListView.dragGhost.classList.add('theia-notebook-drag-ghost-image');
        NotebookCellListView.dragGhost.appendChild((_b = (_a = this.props.renderers.get(cell.cellKind)) === null || _a === void 0 ? void 0 : _a.renderDragImage(cell)) !== null && _b !== void 0 ? _b : document.createElement('div'));
        document.body.appendChild(NotebookCellListView.dragGhost);
        event.dataTransfer.setDragImage(NotebookCellListView.dragGhost, -10, 0);
        event.dataTransfer.setData('text/theia-notebook-cell-index', index.toString());
        event.dataTransfer.setData('text/plain', this.props.notebookModel.cells[index].source);
    }
    onDragOver(event, cell, position) {
        if (!this.isEnabled()) {
            return;
        }
        event.preventDefault();
        event.stopPropagation();
        // show indicator
        this.setState({ ...this.state, dragOverIndicator: { cell, position: (position !== null && position !== void 0 ? position : event.nativeEvent.offsetY < event.currentTarget.clientHeight / 2) ? 'top' : 'bottom' } });
    }
    isEnabled() {
        return !Boolean(this.props.notebookModel.readOnly);
    }
    onDrop(event, dropElementIndex) {
        var _a;
        if (!this.isEnabled()) {
            this.setState({ dragOverIndicator: undefined });
            return;
        }
        const index = parseInt(event.dataTransfer.getData('text/theia-notebook-cell-index'));
        const isTargetBelow = index < dropElementIndex;
        let newIdx = ((_a = this.state.dragOverIndicator) === null || _a === void 0 ? void 0 : _a.position) === 'top' ? dropElementIndex : dropElementIndex + 1;
        newIdx = isTargetBelow ? newIdx - 1 : newIdx;
        if (index !== undefined && index !== dropElementIndex) {
            this.props.notebookModel.applyEdits([{
                    editType: 6 /* CellEditType.Move */,
                    length: 1,
                    index,
                    newIdx
                }], true);
        }
        this.setState({ ...this.state, dragOverIndicator: undefined });
    }
    onAddNewCell(commandId, index) {
        if (this.isEnabled()) {
            this.props.commandRegistry.executeCommand(notebook_actions_contribution_1.NotebookCommands.CHANGE_SELECTED_CELL.id, index - 1);
            this.props.commandRegistry.executeCommand(commandId, this.props.notebookModel, index);
        }
    }
    shouldRenderDragOverIndicator(cell, position) {
        return this.isEnabled() &&
            this.state.dragOverIndicator !== undefined &&
            this.state.dragOverIndicator.cell === cell &&
            this.state.dragOverIndicator.position === position;
    }
}
exports.NotebookCellListView = NotebookCellListView;
function NotebookCellDivider({ isVisible, onAddNewCell, onDrop, onDragOver, menuRegistry }) {
    const [hover, setHover] = React.useState(false);
    const menuPath = notebook_actions_contribution_1.NotebookMenus.NOTEBOOK_MAIN_TOOLBAR_CELL_ADD_GROUP;
    const menuItems = menuRegistry.getMenuNode(menuPath).children;
    const renderItem = (item) => React.createElement("button", { key: item.id, className: 'theia-notebook-add-cell-button', onClick: () => onAddNewCell(item.command || ''), title: core_1.nls.localizeByDefault(`Add ${item.label} Cell`) },
        React.createElement("div", { className: item.icon + ' theia-notebook-add-cell-button-icon' }),
        React.createElement("div", { className: 'theia-notebook-add-cell-button-text' }, item.label));
    return React.createElement("li", { className: 'theia-notebook-cell-divider', onMouseEnter: () => setHover(true), onMouseLeave: () => setHover(false), onDrop: onDrop, onDragOver: onDragOver }, hover && isVisible() && React.createElement("div", { className: 'theia-notebook-add-cell-buttons' }, menuItems.map((item) => renderItem(item))));
}
exports.NotebookCellDivider = NotebookCellDivider;
function CellDropIndicator(props) {
    return React.createElement("div", { className: 'theia-notebook-cell-drop-indicator', style: { visibility: props.visible ? 'visible' : 'hidden' } });
}


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/view/notebook-cell-toolbar-factory.js":
/*!********************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/view/notebook-cell-toolbar-factory.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookCellToolbarFactory = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
const notebook_cell_toolbar_1 = __webpack_require__(/*! ./notebook-cell-toolbar */ "../../node_modules/@theia/notebook/lib/browser/view/notebook-cell-toolbar.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const notebook_context_manager_1 = __webpack_require__(/*! ../service/notebook-context-manager */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-context-manager.js");
let NotebookCellToolbarFactory = class NotebookCellToolbarFactory {
    renderCellToolbar(menuPath, cell, itemOptions) {
        return React.createElement(notebook_cell_toolbar_1.NotebookCellToolbar, { getMenuItems: () => this.getMenuItems(menuPath, cell, itemOptions), onContextKeysChanged: this.notebookContextManager.onDidChangeContext });
    }
    renderSidebar(menuPath, cell, itemOptions) {
        return React.createElement(notebook_cell_toolbar_1.NotebookCellSidebar, { getMenuItems: () => this.getMenuItems(menuPath, cell, itemOptions), onContextKeysChanged: this.notebookContextManager.onDidChangeContext });
    }
    getMenuItems(menuItemPath, cell, itemOptions) {
        var _a, _b;
        const inlineItems = [];
        for (const menuNode of this.menuRegistry.getMenu(menuItemPath).children) {
            if (!menuNode.when || this.notebookContextManager.getCellContext(cell.handle).match(menuNode.when, this.notebookContextManager.context)) {
                if (menuNode.role === 2 /* CompoundMenuNodeRole.Flat */) {
                    inlineItems.push(...(_b = (_a = menuNode.children) === null || _a === void 0 ? void 0 : _a.map(child => this.createToolbarItem(child, itemOptions))) !== null && _b !== void 0 ? _b : []);
                }
                else {
                    inlineItems.push(this.createToolbarItem(menuNode, itemOptions));
                }
            }
        }
        return inlineItems;
    }
    createToolbarItem(menuNode, itemOptions) {
        const menuPath = menuNode.role === 0 /* CompoundMenuNodeRole.Submenu */ ? this.menuRegistry.getPath(menuNode) : undefined;
        return {
            id: menuNode.id,
            icon: menuNode.icon,
            label: menuNode.label,
            onClick: menuPath ?
                e => {
                    var _a;
                    return this.contextMenuRenderer.render({
                        anchor: e.nativeEvent,
                        menuPath,
                        includeAnchorArg: false,
                        args: (_a = itemOptions.contextMenuArgs) === null || _a === void 0 ? void 0 : _a.call(itemOptions),
                        context: this.notebookContextManager.context || e.currentTarget
                    });
                } :
                () => { var _a, _b; return this.commandRegistry.executeCommand(menuNode.command, ...((_b = (_a = itemOptions.commandArgs) === null || _a === void 0 ? void 0 : _a.call(itemOptions)) !== null && _b !== void 0 ? _b : [])); },
            isVisible: () => { var _a, _b; return menuPath ? true : Boolean(this.commandRegistry.getVisibleHandler(menuNode.command, ...((_b = (_a = itemOptions.commandArgs) === null || _a === void 0 ? void 0 : _a.call(itemOptions)) !== null && _b !== void 0 ? _b : []))); },
            contextKeys: menuNode.when ? this.contextKeyService.parseKeys(menuNode.when) : undefined
        };
    }
};
exports.NotebookCellToolbarFactory = NotebookCellToolbarFactory;
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.MenuModelRegistry),
    tslib_1.__metadata("design:type", core_1.MenuModelRegistry)
], NotebookCellToolbarFactory.prototype, "menuRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    tslib_1.__metadata("design:type", Object)
], NotebookCellToolbarFactory.prototype, "contextKeyService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ContextMenuRenderer),
    tslib_1.__metadata("design:type", browser_1.ContextMenuRenderer)
], NotebookCellToolbarFactory.prototype, "contextMenuRenderer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.CommandRegistry),
    tslib_1.__metadata("design:type", core_1.CommandRegistry)
], NotebookCellToolbarFactory.prototype, "commandRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_context_manager_1.NotebookContextManager),
    tslib_1.__metadata("design:type", notebook_context_manager_1.NotebookContextManager)
], NotebookCellToolbarFactory.prototype, "notebookContextManager", void 0);
exports.NotebookCellToolbarFactory = NotebookCellToolbarFactory = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookCellToolbarFactory);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/view/notebook-cell-toolbar.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/view/notebook-cell-toolbar.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookCellSidebar = exports.NotebookCellToolbar = void 0;
// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
class NotebookCellActionBar extends React.Component {
    constructor(props) {
        super(props);
        this.toDispose = new core_1.DisposableCollection();
        this.toDispose.push(props.onContextKeysChanged(e => {
            const menuItems = this.props.getMenuItems();
            if (menuItems.some(item => item.contextKeys ? e.affects(item.contextKeys) : false)) {
                this.setState({ inlineItems: menuItems });
            }
        }));
        this.state = { inlineItems: this.props.getMenuItems() };
    }
    componentWillUnmount() {
        this.toDispose.dispose();
    }
    renderItem(item) {
        return React.createElement("div", { key: item.id, id: item.id, title: item.label, onClick: item.onClick, className: `${item.icon} ${browser_1.ACTION_ITEM} theia-notebook-cell-toolbar-item` });
    }
}
class NotebookCellToolbar extends NotebookCellActionBar {
    render() {
        return React.createElement("div", { className: 'theia-notebook-cell-toolbar' }, this.state.inlineItems.filter(e => e.isVisible()).map(item => this.renderItem(item)));
    }
}
exports.NotebookCellToolbar = NotebookCellToolbar;
class NotebookCellSidebar extends NotebookCellActionBar {
    render() {
        return React.createElement("div", { className: 'theia-notebook-cell-sidebar-toolbar' }, this.state.inlineItems.filter(e => e.isVisible()).map(item => this.renderItem(item)));
    }
}
exports.NotebookCellSidebar = NotebookCellSidebar;


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/view/notebook-code-cell-view.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/view/notebook-code-cell-view.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookCodeCellOutputs = exports.NotebookCodeCellStatus = exports.NotebookCodeCellSidebar = exports.NotebookCodeCellRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const monaco_editor_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-editor */ "../../node_modules/@theia/monaco/lib/browser/monaco-editor.js");
const notebook_renderer_registry_1 = __webpack_require__(/*! ../notebook-renderer-registry */ "../../node_modules/@theia/notebook/lib/browser/notebook-renderer-registry.js");
const notebook_cell_editor_1 = __webpack_require__(/*! ./notebook-cell-editor */ "../../node_modules/@theia/notebook/lib/browser/view/notebook-cell-editor.js");
const notebook_cell_list_view_1 = __webpack_require__(/*! ./notebook-cell-list-view */ "../../node_modules/@theia/notebook/lib/browser/view/notebook-cell-list-view.js");
const notebook_cell_toolbar_factory_1 = __webpack_require__(/*! ./notebook-cell-toolbar-factory */ "../../node_modules/@theia/notebook/lib/browser/view/notebook-cell-toolbar-factory.js");
const notebook_cell_actions_contribution_1 = __webpack_require__(/*! ../contributions/notebook-cell-actions-contribution */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-cell-actions-contribution.js");
const notebook_execution_state_service_1 = __webpack_require__(/*! ../service/notebook-execution-state-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-execution-state-service.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/notebook/lib/common/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const notebook_context_manager_1 = __webpack_require__(/*! ../service/notebook-context-manager */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-context-manager.js");
const notebook_viewport_service_1 = __webpack_require__(/*! ./notebook-viewport-service */ "../../node_modules/@theia/notebook/lib/browser/view/notebook-viewport-service.js");
const browser_2 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const notebook_options_1 = __webpack_require__(/*! ../service/notebook-options */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-options.js");
const markdown_renderer_1 = __webpack_require__(/*! @theia/core/lib/browser/markdown-rendering/markdown-renderer */ "../../node_modules/@theia/core/lib/browser/markdown-rendering/markdown-renderer.js");
const htmlContent_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/base/common/htmlContent */ "../../node_modules/@theia/monaco-editor-core/esm/vs/base/common/htmlContent.js");
const notebook_cell_editor_service_1 = __webpack_require__(/*! ../service/notebook-cell-editor-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-cell-editor-service.js");
const cell_output_webview_1 = __webpack_require__(/*! ../renderers/cell-output-webview */ "../../node_modules/@theia/notebook/lib/browser/renderers/cell-output-webview.js");
const notebook_cell_status_bar_service_1 = __webpack_require__(/*! ../service/notebook-cell-status-bar-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-cell-status-bar-service.js");
const label_parser_1 = __webpack_require__(/*! @theia/core/lib/browser/label-parser */ "../../node_modules/@theia/core/lib/browser/label-parser.js");
let NotebookCodeCellRenderer = class NotebookCodeCellRenderer {
    render(notebookModel, cell, handle) {
        return React.createElement("div", { className: 'theia-notebook-cell-with-sidebar', ref: ref => (0, notebook_cell_list_view_1.observeCellHeight)(ref, cell) },
            React.createElement("div", { className: 'theia-notebook-cell-editor-container' },
                React.createElement(notebook_cell_editor_1.CellEditor, { notebookModel: notebookModel, cell: cell, monacoServices: this.monacoServices, notebookContextManager: this.notebookContextManager, notebookViewportService: this.notebookViewportService, notebookCellEditorService: this.notebookCellEditorService, fontInfo: this.notebookOptionsService.editorFontInfo }),
                React.createElement(NotebookCodeCellStatus, { cell: cell, notebook: notebookModel, commandRegistry: this.commandRegistry, executionStateService: this.executionStateService, cellStatusBarService: this.notebookCellStatusBarService, labelParser: this.labelParser, onClick: () => cell.requestFocusEditor() })));
    }
    renderSidebar(notebookModel, cell) {
        return React.createElement("div", null,
            React.createElement(NotebookCodeCellSidebar, { cell: cell, notebook: notebookModel, notebookCellToolbarFactory: this.notebookCellToolbarFactory }),
            React.createElement(NotebookCodeCellOutputs, { cell: cell, notebook: notebookModel, outputWebview: this.outputWebview, renderSidebar: () => this.notebookCellToolbarFactory.renderSidebar(notebook_cell_actions_contribution_1.NotebookCellActionContribution.OUTPUT_SIDEBAR_MENU, cell, {
                    contextMenuArgs: () => [notebookModel, cell, cell.outputs[0]]
                }) }));
    }
    renderDragImage(cell) {
        var _a;
        const dragImage = document.createElement('div');
        dragImage.className = 'theia-notebook-drag-image';
        dragImage.style.width = ((_a = this.notebookContextManager.context) === null || _a === void 0 ? void 0 : _a.clientWidth) + 'px';
        dragImage.style.height = '100px';
        dragImage.style.display = 'flex';
        const fakeRunButton = document.createElement('span');
        fakeRunButton.className = `${(0, browser_1.codicon)('play')} theia-notebook-cell-status-item`;
        dragImage.appendChild(fakeRunButton);
        const fakeEditor = document.createElement('div');
        dragImage.appendChild(fakeEditor);
        const lines = cell.source.split('\n').slice(0, 5).join('\n');
        const codeSequence = this.getMarkdownCodeSequence(lines);
        const firstLine = new htmlContent_1.MarkdownString(`${codeSequence}${cell.language}\n${lines}\n${codeSequence}`, { supportHtml: true, isTrusted: false });
        fakeEditor.appendChild(this.markdownRenderer.render(firstLine).element);
        fakeEditor.classList.add('theia-notebook-cell-editor-container');
        fakeEditor.style.padding = '10px';
        return dragImage;
    }
    getMarkdownCodeSequence(input) {
        // We need a minimum of 3 backticks to start a code block.
        let longest = 2;
        let current = 0;
        for (let i = 0; i < input.length; i++) {
            const char = input.charAt(i);
            if (char === '`') {
                current++;
                if (current > longest) {
                    longest = current;
                }
            }
            else {
                current = 0;
            }
        }
        return Array(longest + 1).fill('`').join('');
    }
};
exports.NotebookCodeCellRenderer = NotebookCodeCellRenderer;
tslib_1.__decorate([
    (0, inversify_1.inject)(monaco_editor_1.MonacoEditorServices),
    tslib_1.__metadata("design:type", monaco_editor_1.MonacoEditorServices)
], NotebookCodeCellRenderer.prototype, "monacoServices", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_renderer_registry_1.NotebookRendererRegistry),
    tslib_1.__metadata("design:type", notebook_renderer_registry_1.NotebookRendererRegistry)
], NotebookCodeCellRenderer.prototype, "notebookRendererRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_cell_toolbar_factory_1.NotebookCellToolbarFactory),
    tslib_1.__metadata("design:type", notebook_cell_toolbar_factory_1.NotebookCellToolbarFactory)
], NotebookCodeCellRenderer.prototype, "notebookCellToolbarFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_execution_state_service_1.NotebookExecutionStateService),
    tslib_1.__metadata("design:type", notebook_execution_state_service_1.NotebookExecutionStateService)
], NotebookCodeCellRenderer.prototype, "executionStateService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_context_manager_1.NotebookContextManager),
    tslib_1.__metadata("design:type", notebook_context_manager_1.NotebookContextManager)
], NotebookCodeCellRenderer.prototype, "notebookContextManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_viewport_service_1.NotebookViewportService),
    tslib_1.__metadata("design:type", notebook_viewport_service_1.NotebookViewportService)
], NotebookCodeCellRenderer.prototype, "notebookViewportService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.EditorPreferences),
    tslib_1.__metadata("design:type", Object)
], NotebookCodeCellRenderer.prototype, "editorPreferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_cell_editor_service_1.NotebookCellEditorService),
    tslib_1.__metadata("design:type", notebook_cell_editor_service_1.NotebookCellEditorService)
], NotebookCodeCellRenderer.prototype, "notebookCellEditorService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.CommandRegistry),
    tslib_1.__metadata("design:type", core_1.CommandRegistry)
], NotebookCodeCellRenderer.prototype, "commandRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_options_1.NotebookOptionsService),
    tslib_1.__metadata("design:type", notebook_options_1.NotebookOptionsService)
], NotebookCodeCellRenderer.prototype, "notebookOptionsService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(markdown_renderer_1.MarkdownRenderer),
    tslib_1.__metadata("design:type", Object)
], NotebookCodeCellRenderer.prototype, "markdownRenderer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(cell_output_webview_1.CellOutputWebview),
    tslib_1.__metadata("design:type", Object)
], NotebookCodeCellRenderer.prototype, "outputWebview", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_cell_status_bar_service_1.NotebookCellStatusBarService),
    tslib_1.__metadata("design:type", notebook_cell_status_bar_service_1.NotebookCellStatusBarService)
], NotebookCodeCellRenderer.prototype, "notebookCellStatusBarService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(label_parser_1.LabelParser),
    tslib_1.__metadata("design:type", label_parser_1.LabelParser)
], NotebookCodeCellRenderer.prototype, "labelParser", void 0);
exports.NotebookCodeCellRenderer = NotebookCodeCellRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookCodeCellRenderer);
class NotebookCodeCellSidebar extends React.Component {
    constructor(props) {
        super(props);
        this.toDispose = new core_1.DisposableCollection();
        this.toDispose.push(props.cell.onDidCellHeightChange(() => this.forceUpdate()));
    }
    componentWillUnmount() {
        this.toDispose.dispose();
    }
    render() {
        return React.createElement("div", { className: 'theia-notebook-cell-sidebar-actions', style: { height: `${this.props.cell.cellHeight}px` } },
            this.props.notebookCellToolbarFactory.renderSidebar(notebook_cell_actions_contribution_1.NotebookCellActionContribution.CODE_CELL_SIDEBAR_MENU, this.props.cell, {
                contextMenuArgs: () => [this.props.cell], commandArgs: () => [this.props.notebook, this.props.cell]
            }),
            React.createElement(CodeCellExecutionOrder, { cell: this.props.cell }));
    }
}
exports.NotebookCodeCellSidebar = NotebookCodeCellSidebar;
class NotebookCodeCellStatus extends React.Component {
    constructor(props) {
        super(props);
        this.toDispose = new core_1.DisposableCollection();
        this.statusBarItems = [];
        this.state = {
            executionTime: 0
        };
        let currentInterval;
        if (props.executionStateService) {
            this.toDispose.push(props.executionStateService.onDidChangeExecution(event => {
                var _a;
                if (event.affectsCell(this.props.cell.uri)) {
                    this.setState({ currentExecution: event.changed, executionTime: 0 });
                    clearInterval(currentInterval);
                    if (((_a = event.changed) === null || _a === void 0 ? void 0 : _a.state) === common_1.NotebookCellExecutionState.Executing) {
                        const startTime = Date.now();
                        // The resolution of the time display is only a single digit after the decimal point.
                        // Therefore, we only need to update the display every 100ms.
                        currentInterval = setInterval(() => {
                            this.setState({
                                executionTime: Date.now() - startTime
                            });
                        }, 100);
                    }
                }
            }));
        }
        this.toDispose.push(props.cell.onDidChangeLanguage(() => {
            this.forceUpdate();
        }));
        this.updateStatusBarItems();
        this.props.cellStatusBarService.onDidChangeItems(() => this.updateStatusBarItems());
        this.props.notebook.onContentChanged(() => this.updateStatusBarItems());
    }
    async updateStatusBarItems() {
        this.statusBarItems = await this.props.cellStatusBarService.getStatusBarItemsForCell(this.props.notebook.uri, this.props.notebook.cells.indexOf(this.props.cell), this.props.notebook.viewType, core_1.CancellationToken.None);
        this.forceUpdate();
    }
    componentWillUnmount() {
        this.toDispose.dispose();
    }
    render() {
        var _a;
        return React.createElement("div", { className: 'notebook-cell-status', onClick: () => this.props.onClick() },
            React.createElement("div", { className: 'notebook-cell-status-left' },
                this.props.executionStateService && this.renderExecutionState(),
                ((_a = this.statusBarItems) === null || _a === void 0 ? void 0 : _a.length) && this.renderStatusBarItems()),
            React.createElement("div", { className: 'notebook-cell-status-right' },
                React.createElement("span", { className: 'notebook-cell-language-label', onClick: () => {
                        this.props.commandRegistry.executeCommand(notebook_cell_actions_contribution_1.NotebookCellCommands.CHANGE_CELL_LANGUAGE.id, this.props.notebook, this.props.cell);
                    } }, this.props.cell.languageName)));
    }
    renderExecutionState() {
        var _a;
        const state = (_a = this.state.currentExecution) === null || _a === void 0 ? void 0 : _a.state;
        const { lastRunSuccess } = this.props.cell.internalMetadata;
        let iconClasses = undefined;
        let color = undefined;
        if (!state && lastRunSuccess) {
            iconClasses = (0, browser_1.codicon)('check');
            color = 'green';
        }
        else if (!state && lastRunSuccess === false) {
            iconClasses = (0, browser_1.codicon)('error');
            color = 'red';
        }
        else if (state === common_1.NotebookCellExecutionState.Pending || state === common_1.NotebookCellExecutionState.Unconfirmed) {
            iconClasses = (0, browser_1.codicon)('clock');
        }
        else if (state === common_1.NotebookCellExecutionState.Executing) {
            iconClasses = `${(0, browser_1.codicon)('sync')} theia-animation-spin`;
        }
        return React.createElement(React.Fragment, null, iconClasses &&
            React.createElement(React.Fragment, null,
                React.createElement("span", { className: `${iconClasses} notebook-cell-status-item`, style: { color } }),
                React.createElement("div", { className: 'notebook-cell-status-item' }, this.renderTime(this.getExecutionTime()))));
    }
    getExecutionTime() {
        const { runStartTime, runEndTime } = this.props.cell.internalMetadata;
        const { executionTime } = this.state;
        if (runStartTime !== undefined && runEndTime !== undefined) {
            return runEndTime - runStartTime;
        }
        return executionTime;
    }
    renderTime(ms) {
        return `${(ms / 1000).toLocaleString(undefined, { maximumFractionDigits: 1, minimumFractionDigits: 1 })}s`;
    }
    renderStatusBarItems() {
        return React.createElement(React.Fragment, null, this.statusBarItems.flatMap((itemList, listIndex) => itemList.items.map((item, index) => this.renderStatusBarItem(item, `${listIndex}-${index}`))));
    }
    renderStatusBarItem(item, key) {
        const content = this.props.labelParser.parse(item.text).map(part => {
            if (typeof part === 'string') {
                return part;
            }
            else {
                return React.createElement("span", { key: part.name, className: `codicon codicon-${part.name}` });
            }
        });
        return React.createElement("div", { key: key, className: `cell-status-bar-item ${item.command ? 'cell-status-item-has-command' : ''}`, onClick: async () => {
                var _a;
                if (item.command) {
                    if (typeof item.command === 'string') {
                        this.props.commandRegistry.executeCommand(item.command);
                    }
                    else {
                        this.props.commandRegistry.executeCommand(item.command.id, ...((_a = item.command.arguments) !== null && _a !== void 0 ? _a : []));
                    }
                }
            } }, content);
    }
}
exports.NotebookCodeCellStatus = NotebookCodeCellStatus;
class NotebookCodeCellOutputs extends React.Component {
    constructor() {
        super(...arguments);
        this.toDispose = new core_1.DisposableCollection();
        this.outputHeight = 0;
    }
    async componentDidMount() {
        const { cell } = this.props;
        this.toDispose.push(cell.onDidChangeOutputs(() => this.forceUpdate()));
        this.toDispose.push(this.props.cell.onDidChangeOutputVisibility(() => this.forceUpdate()));
        this.toDispose.push(this.props.outputWebview.onDidRenderOutput(event => {
            if (event.cellHandle === this.props.cell.handle) {
                this.outputHeight = event.outputHeight;
                this.forceUpdate();
            }
        }));
    }
    componentWillUnmount() {
        this.toDispose.dispose();
    }
    render() {
        var _a;
        if (!((_a = this.props.cell.outputs) === null || _a === void 0 ? void 0 : _a.length)) {
            return React.createElement(React.Fragment, null);
        }
        if (this.props.cell.outputVisible) {
            return React.createElement("div", { style: { minHeight: this.outputHeight } }, this.props.renderSidebar());
        }
        return React.createElement("div", { className: 'theia-notebook-collapsed-output-container' },
            React.createElement("i", { className: 'theia-notebook-collapsed-output' }, core_1.nls.localizeByDefault('Outputs are collapsed')));
    }
}
exports.NotebookCodeCellOutputs = NotebookCodeCellOutputs;
function CodeCellExecutionOrder({ cell }) {
    var _a;
    const [executionOrder, setExecutionOrder] = React.useState((_a = cell.internalMetadata.executionOrder) !== null && _a !== void 0 ? _a : ' ');
    React.useEffect(() => {
        const listener = cell.onDidChangeInternalMetadata(e => {
            var _a;
            setExecutionOrder((_a = cell.internalMetadata.executionOrder) !== null && _a !== void 0 ? _a : ' ');
        });
        return () => listener.dispose();
    }, []);
    return React.createElement("span", { className: 'theia-notebook-code-cell-execution-order' }, `[${executionOrder}]`);
}


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/view/notebook-find-widget.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/view/notebook-find-widget.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookFindWidget = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const debounce = __webpack_require__(/*! lodash/debounce */ "../../node_modules/lodash/debounce.js");
class NotebookFindWidget extends React.Component {
    constructor(props) {
        var _a;
        super(props);
        this.searchRef = React.createRef();
        this.debounceSearch = debounce(this.search.bind(this), 50);
        this.state = {
            search: '',
            replace: '',
            currentMatch: 0,
            matches: [],
            expanded: false,
            matchCase: false,
            regex: false,
            wholeWord: false,
            activeFilters: ((_a = props.filters) === null || _a === void 0 ? void 0 : _a.filter(filter => filter.active).map(filter => filter.id)) || []
        };
    }
    render() {
        const hasMatches = this.hasMatches();
        const canReplace = this.canReplace();
        const canReplaceAll = this.canReplaceAll();
        return (React.createElement("div", { onKeyUp: event => {
                if (event.key === 'Escape') {
                    this.props.onClose();
                }
            }, className: `theia-notebook-find-widget ${!this.state.expanded ? 'search-mode' : ''} ${this.props.hidden ? 'hidden' : ''}` },
            React.createElement("div", { className: 'theia-notebook-find-widget-expand', title: core_1.nls.localizeByDefault('Toggle Replace'), onClick: () => {
                    this.setState({
                        expanded: !this.state.expanded
                    });
                } },
                React.createElement("div", { className: (0, browser_1.codicon)(`chevron-${this.state.expanded ? 'down' : 'right'}`) })),
            React.createElement("div", { className: 'theia-notebook-find-widget-inputs' },
                React.createElement("div", { className: 'theia-notebook-find-widget-input-wrapper' },
                    React.createElement("input", { ref: this.searchRef, type: 'text', className: 'theia-input theia-notebook-find-widget-input', placeholder: core_1.nls.localizeByDefault('Find'), value: this.state.search, onChange: event => {
                            this.setState({
                                search: event.target.value
                            });
                            this.debounceSearch({});
                        }, onKeyDown: event => {
                            if (event.key === 'Enter') {
                                if (event.shiftKey) {
                                    this.gotoPreviousMatch();
                                }
                                else {
                                    this.gotoNextMatch();
                                }
                                event.preventDefault();
                            }
                        } }),
                    React.createElement("div", { className: `${(0, browser_1.codicon)('case-sensitive', true)} option ${this.state.matchCase ? 'enabled' : ''}`, title: core_1.nls.localizeByDefault('Match Case'), onClick: () => {
                            this.search({
                                matchCase: !this.state.matchCase
                            });
                        } }),
                    React.createElement("div", { className: `${(0, browser_1.codicon)('whole-word', true)} option ${this.state.wholeWord ? 'enabled' : ''}`, title: core_1.nls.localizeByDefault('Match Whole Word'), onClick: () => {
                            this.search({
                                wholeWord: !this.state.wholeWord
                            });
                        } }),
                    React.createElement("div", { className: `${(0, browser_1.codicon)('regex', true)} option ${this.state.regex ? 'enabled' : ''}`, title: core_1.nls.localizeByDefault('Use Regular Expression'), onClick: () => {
                            this.search({
                                regex: !this.state.regex
                            });
                        } })),
                React.createElement("input", { type: 'text', className: 'theia-input theia-notebook-find-widget-replace', placeholder: core_1.nls.localizeByDefault('Replace'), value: this.state.replace, onChange: event => {
                        this.setState({
                            replace: event.target.value
                        });
                    }, onKeyDown: event => {
                        if (event.key === 'Enter') {
                            this.replaceOne();
                            event.preventDefault();
                        }
                    } })),
            React.createElement("div", { className: 'theia-notebook-find-widget-buttons' },
                React.createElement("div", { className: 'theia-notebook-find-widget-buttons-first' },
                    React.createElement("div", { className: 'theia-notebook-find-widget-matches-count' }, this.getMatchesCount()),
                    React.createElement("div", { className: `${(0, browser_1.codicon)('arrow-up', hasMatches)} ${hasMatches ? '' : 'disabled'}`, title: core_1.nls.localizeByDefault('Previous Match'), onClick: () => {
                            this.gotoPreviousMatch();
                        } }),
                    React.createElement("div", { className: `${(0, browser_1.codicon)('arrow-down', hasMatches)} ${hasMatches ? '' : 'disabled'}`, title: core_1.nls.localizeByDefault('Next Match'), onClick: () => {
                            this.gotoNextMatch();
                        } }),
                    React.createElement("div", { className: (0, browser_1.codicon)('close', true), title: core_1.nls.localizeByDefault('Close'), onClick: () => {
                            this.props.onClose();
                        } })),
                React.createElement("div", { className: 'theia-notebook-find-widget-buttons-second' },
                    React.createElement("div", { className: `${(0, browser_1.codicon)('replace', canReplace)} ${canReplace ? '' : 'disabled'}`, title: core_1.nls.localizeByDefault('Replace'), onClick: () => {
                            this.replaceOne();
                        } }),
                    React.createElement("div", { className: `${(0, browser_1.codicon)('replace-all', canReplaceAll)} ${canReplaceAll ? '' : 'disabled'}`, title: core_1.nls.localizeByDefault('Replace All'), onClick: () => {
                            this.replaceAll();
                        } })))));
    }
    hasMatches() {
        return this.state.matches.length > 0;
    }
    canReplace() {
        var _a;
        return Boolean((_a = this.state.matches[this.state.currentMatch]) === null || _a === void 0 ? void 0 : _a.replace);
    }
    canReplaceAll() {
        return this.state.matches.some(match => Boolean(match.replace));
    }
    getMatchesCount() {
        if (this.hasMatches()) {
            return core_1.nls.localizeByDefault('{0} of {1}', this.state.currentMatch + 1, this.state.matches.length);
        }
        else {
            return core_1.nls.localizeByDefault('No results');
        }
    }
    gotoNextMatch() {
        this.search({
            modifyIndex: (matches, index) => (index + 1) % matches.length,
            jumpToMatch: true
        });
    }
    gotoPreviousMatch() {
        this.search({
            modifyIndex: (matches, index) => (index === 0 ? matches.length : index) - 1,
            jumpToMatch: true
        });
    }
    replaceOne() {
        var _a;
        const existingMatches = this.state.matches;
        const match = existingMatches[this.state.currentMatch];
        if (match) {
            (_a = match.replace) === null || _a === void 0 ? void 0 : _a.call(match, this.state.replace);
            this.search({
                jumpToMatch: true,
                modifyIndex: (matches, index) => {
                    if (matches.length < existingMatches.length) {
                        return index % matches.length;
                    }
                    else {
                        const diff = matches.length - existingMatches.length;
                        return (index + diff + 1) % matches.length;
                    }
                }
            });
        }
    }
    replaceAll() {
        this.props.onReplace(this.state.matches, this.state.replace);
        this.search({});
    }
    componentDidUpdate(prevProps, prevState) {
        var _a;
        if (!this.props.hidden && prevProps.hidden) {
            // Focus the search input when the widget switches from hidden to visible.
            (_a = this.searchRef.current) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }
    focusSearch(content) {
        var _a;
        (_a = this.searchRef.current) === null || _a === void 0 ? void 0 : _a.focus();
        if (content) {
            this.search({
                search: content,
                jumpToMatch: false
            });
        }
    }
    search(options) {
        var _a, _b, _c, _d;
        const matchCase = (_a = options.matchCase) !== null && _a !== void 0 ? _a : this.state.matchCase;
        const wholeWord = (_b = options.wholeWord) !== null && _b !== void 0 ? _b : this.state.wholeWord;
        const regex = (_c = options.regex) !== null && _c !== void 0 ? _c : this.state.regex;
        const search = (_d = options.search) !== null && _d !== void 0 ? _d : this.state.search;
        const matches = this.props.onSearch({
            search,
            matchCase,
            wholeWord,
            regex,
            activeFilters: this.state.activeFilters
        });
        let currentMatch = Math.max(0, Math.min(this.state.currentMatch, matches.length - 1));
        if (options.modifyIndex && matches.length > 0) {
            currentMatch = options.modifyIndex(matches, currentMatch);
        }
        const selectedMatch = matches[currentMatch];
        if (selectedMatch) {
            selectedMatch.selected = true;
            if (options.jumpToMatch) {
                selectedMatch.show();
            }
        }
        this.setState({
            search,
            matches,
            currentMatch,
            matchCase,
            wholeWord,
            regex
        });
    }
}
exports.NotebookFindWidget = NotebookFindWidget;


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/view/notebook-main-toolbar.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/view/notebook-main-toolbar.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookMainToolbar = exports.NotebookMainToolbarRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const notebook_actions_contribution_1 = __webpack_require__(/*! ../contributions/notebook-actions-contribution */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-actions-contribution.js");
const notebook_kernel_service_1 = __webpack_require__(/*! ../service/notebook-kernel-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-kernel-service.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
const notebook_context_manager_1 = __webpack_require__(/*! ../service/notebook-context-manager */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-context-manager.js");
let NotebookMainToolbarRenderer = class NotebookMainToolbarRenderer {
    render(notebookModel, editorNode) {
        return React.createElement(NotebookMainToolbar, { notebookModel: notebookModel, menuRegistry: this.menuRegistry, notebookKernelService: this.notebookKernelService, commandRegistry: this.commandRegistry, contextKeyService: this.contextKeyService, editorNode: editorNode, notebookContextManager: this.notebookContextManager, contextMenuRenderer: this.contextMenuRenderer });
    }
};
exports.NotebookMainToolbarRenderer = NotebookMainToolbarRenderer;
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_kernel_service_1.NotebookKernelService),
    tslib_1.__metadata("design:type", notebook_kernel_service_1.NotebookKernelService)
], NotebookMainToolbarRenderer.prototype, "notebookKernelService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.CommandRegistry),
    tslib_1.__metadata("design:type", core_1.CommandRegistry)
], NotebookMainToolbarRenderer.prototype, "commandRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.MenuModelRegistry),
    tslib_1.__metadata("design:type", core_1.MenuModelRegistry)
], NotebookMainToolbarRenderer.prototype, "menuRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    tslib_1.__metadata("design:type", Object)
], NotebookMainToolbarRenderer.prototype, "contextKeyService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_context_manager_1.NotebookContextManager),
    tslib_1.__metadata("design:type", notebook_context_manager_1.NotebookContextManager)
], NotebookMainToolbarRenderer.prototype, "notebookContextManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ContextMenuRenderer),
    tslib_1.__metadata("design:type", browser_1.ContextMenuRenderer)
], NotebookMainToolbarRenderer.prototype, "contextMenuRenderer", void 0);
exports.NotebookMainToolbarRenderer = NotebookMainToolbarRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookMainToolbarRenderer);
class NotebookMainToolbar extends React.Component {
    constructor(props) {
        var _a;
        super(props);
        this.toDispose = new core_1.DisposableCollection();
        this.nativeSubmenus = [
            notebook_actions_contribution_1.NotebookMenus.NOTEBOOK_MAIN_TOOLBAR_CELL_ADD_GROUP[notebook_actions_contribution_1.NotebookMenus.NOTEBOOK_MAIN_TOOLBAR_CELL_ADD_GROUP.length - 1],
            notebook_actions_contribution_1.NotebookMenus.NOTEBOOK_MAIN_TOOLBAR_EXECUTION_GROUP[notebook_actions_contribution_1.NotebookMenus.NOTEBOOK_MAIN_TOOLBAR_EXECUTION_GROUP.length - 1]
        ];
        this.lastGapElementWidth = 0;
        this.resizeObserver = new ResizeObserver(() => this.calculateItemsToHide());
        this.state = {
            selectedKernelLabel: (_a = props.notebookKernelService.getSelectedOrSuggestedKernel(props.notebookModel)) === null || _a === void 0 ? void 0 : _a.label,
            numberOfHiddenItems: 0,
        };
        this.toDispose.push(props.notebookKernelService.onDidChangeSelectedKernel(event => {
            var _a, _b;
            if (props.notebookModel.uri.isEqual(event.notebook)) {
                this.setState({ selectedKernelLabel: (_b = props.notebookKernelService.getKernel((_a = event.newKernel) !== null && _a !== void 0 ? _a : '')) === null || _b === void 0 ? void 0 : _b.label });
            }
        }));
        // in case the selected kernel is added after the notebook is loaded
        this.toDispose.push(props.notebookKernelService.onDidAddKernel(() => {
            var _a;
            if (!this.state.selectedKernelLabel) {
                this.setState({ selectedKernelLabel: (_a = props.notebookKernelService.getSelectedOrSuggestedKernel(props.notebookModel)) === null || _a === void 0 ? void 0 : _a.label });
            }
        }));
        // TODO maybe we need a mechanism to check for changes in the menu to update this toolbar
        const contextKeys = new Set();
        this.getAllContextKeys(this.getMenuItems(), contextKeys);
        props.notebookContextManager.onDidChangeContext(e => {
            if (e.affects(contextKeys)) {
                this.forceUpdate();
            }
        });
        props.contextKeyService.onDidChange(e => {
            if (e.affects(contextKeys)) {
                this.forceUpdate();
            }
        });
    }
    componentWillUnmount() {
        this.toDispose.dispose();
    }
    componentDidUpdate() {
        this.calculateItemsToHide();
    }
    componentDidMount() {
        this.calculateItemsToHide();
    }
    calculateItemsToHide() {
        const numberOfMenuItems = this.getMenuItems().length;
        if (this.gapElement && this.gapElement.getBoundingClientRect().width < NotebookMainToolbar.MIN_FREE_AREA && this.state.numberOfHiddenItems < numberOfMenuItems) {
            this.setState({ ...this.state, numberOfHiddenItems: this.state.numberOfHiddenItems + 1 });
            this.lastGapElementWidth = this.gapElement.getBoundingClientRect().width;
        }
        else if (this.gapElement && this.gapElement.getBoundingClientRect().width > this.lastGapElementWidth && this.state.numberOfHiddenItems > 0) {
            this.setState({ ...this.state, numberOfHiddenItems: 0 });
            this.lastGapElementWidth = this.gapElement.getBoundingClientRect().width;
        }
    }
    renderContextMenu(event, menuItems) {
        const hiddenItems = menuItems.slice(menuItems.length - this.calculateNumberOfHiddenItems(menuItems));
        const contextMenu = this.props.menuRegistry.getMenu([notebook_actions_contribution_1.NotebookMenus.NOTEBOOK_MAIN_TOOLBAR_HIDDEN_ITEMS_CONTEXT_MENU]);
        contextMenu.children.map(item => item.id).forEach(id => contextMenu.removeNode(id));
        hiddenItems.forEach(item => contextMenu.addNode(item));
        this.props.contextMenuRenderer.render({
            anchor: event,
            menuPath: [notebook_actions_contribution_1.NotebookMenus.NOTEBOOK_MAIN_TOOLBAR_HIDDEN_ITEMS_CONTEXT_MENU],
            context: this.props.editorNode,
            args: [this.props.notebookModel.uri]
        });
    }
    render() {
        var _a;
        const menuItems = this.getMenuItems();
        return React.createElement("div", { className: 'theia-notebook-main-toolbar', id: 'notebook-main-toolbar' },
            menuItems.slice(0, menuItems.length - this.calculateNumberOfHiddenItems(menuItems)).map(item => this.renderMenuItem(item)),
            this.state.numberOfHiddenItems > 0 &&
                React.createElement("span", { className: `${(0, browser_1.codicon)('ellipsis')} action-label theia-notebook-main-toolbar-item`, onClick: e => this.renderContextMenu(e.nativeEvent, menuItems) }),
            React.createElement("div", { ref: element => this.gapElementChanged(element), style: { flexGrow: 1 } }),
            React.createElement("div", { className: 'theia-notebook-main-toolbar-item action-label', id: notebook_actions_contribution_1.NotebookCommands.SELECT_KERNEL_COMMAND.id, onClick: () => this.props.commandRegistry.executeCommand(notebook_actions_contribution_1.NotebookCommands.SELECT_KERNEL_COMMAND.id, this.props.notebookModel) },
                React.createElement("span", { className: (0, browser_1.codicon)('server-environment') }),
                React.createElement("span", { className: ' theia-notebook-main-toolbar-item-text', id: 'kernel-text' }, (_a = this.state.selectedKernelLabel) !== null && _a !== void 0 ? _a : core_1.nls.localizeByDefault('Select Kernel'))));
    }
    gapElementChanged(element) {
        if (this.gapElement) {
            this.resizeObserver.unobserve(this.gapElement);
        }
        this.gapElement = element !== null && element !== void 0 ? element : undefined;
        if (this.gapElement) {
            this.lastGapElementWidth = this.gapElement.getBoundingClientRect().width;
            this.resizeObserver.observe(this.gapElement);
        }
    }
    renderMenuItem(item, submenu) {
        var _a, _b, _c, _d, _e, _f;
        if (item.role === 1 /* CompoundMenuNodeRole.Group */) {
            const itemNodes = core_1.ArrayUtils.coalesce((_b = (_a = item.children) === null || _a === void 0 ? void 0 : _a.map(child => this.renderMenuItem(child, item.id))) !== null && _b !== void 0 ? _b : []);
            return React.createElement(React.Fragment, { key: item.id },
                itemNodes,
                itemNodes && itemNodes.length > 0 && React.createElement("span", { key: `${item.id}-separator`, className: 'theia-notebook-toolbar-separator' }));
        }
        else if ((this.nativeSubmenus.includes(submenu !== null && submenu !== void 0 ? submenu : '')) || !item.when || this.props.contextKeyService.match(item.when, this.props.editorNode)) {
            const visibleCommand = Boolean(this.props.commandRegistry.getVisibleHandler((_c = item.command) !== null && _c !== void 0 ? _c : '', this.props.notebookModel));
            if (!visibleCommand) {
                return undefined;
            }
            const command = this.props.commandRegistry.getCommand((_d = item.command) !== null && _d !== void 0 ? _d : '');
            const label = (_e = command === null || command === void 0 ? void 0 : command.shortTitle) !== null && _e !== void 0 ? _e : item.label;
            const title = (_f = command === null || command === void 0 ? void 0 : command.tooltip) !== null && _f !== void 0 ? _f : item.label;
            return React.createElement("div", { key: item.id, id: item.id, title: title, className: `theia-notebook-main-toolbar-item action-label${this.getAdditionalClasses(item)}`, onClick: () => {
                    if (item.command && (!item.when || this.props.contextKeyService.match(item.when, this.props.editorNode))) {
                        this.props.commandRegistry.executeCommand(item.command, this.props.notebookModel.uri);
                    }
                } },
                React.createElement("span", { className: item.icon }),
                React.createElement("span", { className: 'theia-notebook-main-toolbar-item-text' }, label));
        }
        return undefined;
    }
    getMenuItems() {
        const menuPath = notebook_actions_contribution_1.NotebookMenus.NOTEBOOK_MAIN_TOOLBAR;
        const pluginCommands = this.props.menuRegistry.getMenuNode(menuPath).children;
        const theiaCommands = this.props.menuRegistry.getMenu([menuPath]).children;
        return theiaCommands.concat(pluginCommands);
    }
    getAdditionalClasses(item) {
        return !item.when || this.props.contextKeyService.match(item.when, this.props.editorNode) ? '' : ' theia-mod-disabled';
    }
    getAllContextKeys(menus, keySet) {
        menus.filter(item => item.when)
            .forEach(item => { var _a; return (_a = this.props.contextKeyService.parseKeys(item.when)) === null || _a === void 0 ? void 0 : _a.forEach(key => keySet.add(key)); });
        menus.filter(item => item.children && item.children.length > 0)
            .forEach(item => this.getAllContextKeys(item.children, keySet));
    }
    calculateNumberOfHiddenItems(allMenuItems) {
        return this.state.numberOfHiddenItems >= allMenuItems.length ?
            allMenuItems.length :
            this.state.numberOfHiddenItems % allMenuItems.length;
    }
}
exports.NotebookMainToolbar = NotebookMainToolbar;
// The minimum area between items and kernel select before hiding items in a context menu
NotebookMainToolbar.MIN_FREE_AREA = 10;


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/view/notebook-markdown-cell-view.js":
/*!******************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/view/notebook-markdown-cell-view.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookMarkdownCellRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const markdown_renderer_1 = __webpack_require__(/*! @theia/core/lib/browser/markdown-rendering/markdown-renderer */ "../../node_modules/@theia/core/lib/browser/markdown-rendering/markdown-renderer.js");
const markdown_string_1 = __webpack_require__(/*! @theia/core/lib/common/markdown-rendering/markdown-string */ "../../node_modules/@theia/core/lib/common/markdown-rendering/markdown-string.js");
const notebook_cell_list_view_1 = __webpack_require__(/*! ./notebook-cell-list-view */ "../../node_modules/@theia/notebook/lib/browser/view/notebook-cell-list-view.js");
const notebook_cell_editor_1 = __webpack_require__(/*! ./notebook-cell-editor */ "../../node_modules/@theia/notebook/lib/browser/view/notebook-cell-editor.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const monaco_editor_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-editor */ "../../node_modules/@theia/monaco/lib/browser/monaco-editor.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const notebook_context_manager_1 = __webpack_require__(/*! ../service/notebook-context-manager */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-context-manager.js");
const notebook_options_1 = __webpack_require__(/*! ../service/notebook-options */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-options.js");
const notebook_code_cell_view_1 = __webpack_require__(/*! ./notebook-code-cell-view */ "../../node_modules/@theia/notebook/lib/browser/view/notebook-code-cell-view.js");
const mark = __webpack_require__(/*! advanced-mark.js */ "../../node_modules/advanced-mark.js/dist/mark.js");
const notebook_cell_editor_service_1 = __webpack_require__(/*! ../service/notebook-cell-editor-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-cell-editor-service.js");
const notebook_cell_status_bar_service_1 = __webpack_require__(/*! ../service/notebook-cell-status-bar-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-cell-status-bar-service.js");
const label_parser_1 = __webpack_require__(/*! @theia/core/lib/browser/label-parser */ "../../node_modules/@theia/core/lib/browser/label-parser.js");
let NotebookMarkdownCellRenderer = class NotebookMarkdownCellRenderer {
    render(notebookModel, cell) {
        return React.createElement(MarkdownCell, { markdownRenderer: this.markdownRenderer, commandRegistry: this.commandRegistry, monacoServices: this.monacoServices, notebookOptionsService: this.notebookOptionsService, cell: cell, notebookModel: notebookModel, notebookContextManager: this.notebookContextManager, notebookCellEditorService: this.notebookCellEditorService, notebookCellStatusBarService: this.notebookCellStatusBarService, labelParser: this.labelParser });
    }
    renderSidebar(notebookModel, cell) {
        return React.createElement("div", { className: 'theia-notebook-markdown-sidebar' });
    }
    renderDragImage(cell) {
        var _a;
        const dragImage = document.createElement('div');
        dragImage.style.width = ((_a = this.notebookContextManager.context) === null || _a === void 0 ? void 0 : _a.clientWidth) + 'px';
        const markdownString = new markdown_string_1.MarkdownStringImpl(cell.source, { supportHtml: true, isTrusted: true });
        const markdownElement = this.markdownRenderer.render(markdownString).element;
        dragImage.appendChild(markdownElement);
        return dragImage;
    }
};
exports.NotebookMarkdownCellRenderer = NotebookMarkdownCellRenderer;
tslib_1.__decorate([
    (0, inversify_1.inject)(markdown_renderer_1.MarkdownRenderer),
    tslib_1.__metadata("design:type", Object)
], NotebookMarkdownCellRenderer.prototype, "markdownRenderer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(monaco_editor_1.MonacoEditorServices),
    tslib_1.__metadata("design:type", monaco_editor_1.MonacoEditorServices)
], NotebookMarkdownCellRenderer.prototype, "monacoServices", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_context_manager_1.NotebookContextManager),
    tslib_1.__metadata("design:type", notebook_context_manager_1.NotebookContextManager)
], NotebookMarkdownCellRenderer.prototype, "notebookContextManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.CommandRegistry),
    tslib_1.__metadata("design:type", core_1.CommandRegistry)
], NotebookMarkdownCellRenderer.prototype, "commandRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_options_1.NotebookOptionsService),
    tslib_1.__metadata("design:type", notebook_options_1.NotebookOptionsService)
], NotebookMarkdownCellRenderer.prototype, "notebookOptionsService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_cell_editor_service_1.NotebookCellEditorService),
    tslib_1.__metadata("design:type", notebook_cell_editor_service_1.NotebookCellEditorService)
], NotebookMarkdownCellRenderer.prototype, "notebookCellEditorService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_cell_status_bar_service_1.NotebookCellStatusBarService),
    tslib_1.__metadata("design:type", notebook_cell_status_bar_service_1.NotebookCellStatusBarService)
], NotebookMarkdownCellRenderer.prototype, "notebookCellStatusBarService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(label_parser_1.LabelParser),
    tslib_1.__metadata("design:type", label_parser_1.LabelParser)
], NotebookMarkdownCellRenderer.prototype, "labelParser", void 0);
exports.NotebookMarkdownCellRenderer = NotebookMarkdownCellRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookMarkdownCellRenderer);
function MarkdownCell({ markdownRenderer, monacoServices, cell, notebookModel, notebookContextManager, notebookOptionsService, commandRegistry, notebookCellEditorService, notebookCellStatusBarService, labelParser }) {
    const [editMode, setEditMode] = React.useState(cell.editing);
    let empty = false;
    React.useEffect(() => {
        const listener = cell.onDidRequestCellEditChange(cellEdit => setEditMode(cellEdit));
        return () => listener.dispose();
    }, [editMode]);
    React.useEffect(() => {
        if (!editMode) {
            const instance = new mark(markdownContent);
            cell.onMarkdownFind = options => {
                instance.unmark();
                if (empty) {
                    return [];
                }
                return searchInMarkdown(instance, options);
            };
            return () => {
                cell.onMarkdownFind = undefined;
                instance.unmark();
            };
        }
    }, [editMode, cell.source]);
    let markdownContent = React.useMemo(() => {
        const markdownString = new markdown_string_1.MarkdownStringImpl(cell.source, { supportHtml: true, isTrusted: true });
        const rendered = markdownRenderer.render(markdownString).element;
        const children = [];
        rendered.childNodes.forEach(child => {
            if (child instanceof HTMLElement) {
                children.push(child);
            }
        });
        return children;
    }, [cell.source]);
    if (markdownContent.length === 0) {
        const italic = document.createElement('i');
        italic.className = 'theia-notebook-empty-markdown';
        italic.innerText = core_1.nls.localizeByDefault('Empty markdown cell, double-click or press enter to edit.');
        italic.style.pointerEvents = 'none';
        markdownContent = [italic];
        empty = true;
    }
    return editMode ?
        (React.createElement("div", { className: 'theia-notebook-markdown-editor-container', key: "code", ref: ref => (0, notebook_cell_list_view_1.observeCellHeight)(ref, cell) },
            React.createElement(notebook_cell_editor_1.CellEditor, { notebookModel: notebookModel, cell: cell, monacoServices: monacoServices, notebookContextManager: notebookContextManager, notebookCellEditorService: notebookCellEditorService, fontInfo: notebookOptionsService.editorFontInfo }),
            React.createElement(notebook_code_cell_view_1.NotebookCodeCellStatus, { cell: cell, notebook: notebookModel, commandRegistry: commandRegistry, cellStatusBarService: notebookCellStatusBarService, labelParser: labelParser, onClick: () => cell.requestFocusEditor() }))) :
        (React.createElement("div", { className: 'theia-notebook-markdown-content', key: "markdown", onDoubleClick: () => cell.requestEdit(), ref: node => {
                node === null || node === void 0 ? void 0 : node.replaceChildren(...markdownContent);
                (0, notebook_cell_list_view_1.observeCellHeight)(node, cell);
            } }));
}
function searchInMarkdown(instance, options) {
    const matches = [];
    const markOptions = {
        className: 'theia-find-match',
        diacritics: false,
        caseSensitive: options.matchCase,
        acrossElements: true,
        separateWordSearch: false,
        each: node => {
            matches.push(new MarkdownEditorFindMatch(node));
        }
    };
    if (options.regex || options.wholeWord) {
        let search = options.search;
        if (options.wholeWord) {
            if (!options.regex) {
                search = escapeRegExp(search);
            }
            search = '\\b' + search + '\\b';
        }
        instance.markRegExp(new RegExp(search, options.matchCase ? '' : 'i'), markOptions);
    }
    else {
        instance.mark(options.search, markOptions);
    }
    return matches;
}
function escapeRegExp(value) {
    return value.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
}
class MarkdownEditorFindMatch {
    constructor(node) {
        this.node = node;
        this._selected = false;
    }
    get selected() {
        return this._selected;
    }
    set selected(selected) {
        this._selected = selected;
        const className = 'theia-find-match-selected';
        if (this.node instanceof HTMLElement) {
            if (selected) {
                this.node.classList.add(className);
            }
            else {
                this.node.classList.remove(className);
            }
        }
    }
    show() {
        if (this.node instanceof HTMLElement) {
            this.node.scrollIntoView({
                behavior: 'instant',
                block: 'center'
            });
        }
    }
}


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/view/notebook-viewport-service.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/view/notebook-viewport-service.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookViewportService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const vscode_languageserver_protocol_1 = __webpack_require__(/*! @theia/core/shared/vscode-languageserver-protocol */ "../../node_modules/@theia/core/shared/vscode-languageserver-protocol/index.js");
/**
 * this service is for managing the viewport and scroll state of a notebook editor.
 * its used both for restoring scroll state after reopening an editor and for cell to check if they are in the viewport.
 */
let NotebookViewportService = class NotebookViewportService {
    constructor() {
        this.onDidChangeViewportEmitter = new vscode_languageserver_protocol_1.Emitter();
        this.onDidChangeViewport = this.onDidChangeViewportEmitter.event;
    }
    set viewportElement(element) {
        var _a;
        this._viewportElement = element;
        if (element) {
            this.onDidChangeViewportEmitter.fire();
            (_a = this.resizeObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
            this.resizeObserver = new ResizeObserver(() => this.onDidChangeViewportEmitter.fire());
            this.resizeObserver.observe(element);
        }
    }
    isElementInViewport(element) {
        if (this._viewportElement) {
            const rect = element.getBoundingClientRect();
            const viewRect = this._viewportElement.getBoundingClientRect();
            return rect.top < viewRect.top ? rect.bottom > viewRect.top : rect.top < viewRect.bottom;
        }
        return false;
    }
    onScroll(e) {
        this.onDidChangeViewportEmitter.fire();
    }
    dispose() {
        var _a;
        (_a = this.resizeObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
};
exports.NotebookViewportService = NotebookViewportService;
exports.NotebookViewportService = NotebookViewportService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookViewportService);


/***/ }),

/***/ "../../node_modules/advanced-mark.js/dist/mark.js":
/*!********************************************************!*\
  !*** ../../node_modules/advanced-mark.js/dist/mark.js ***!
  \********************************************************/
/***/ (function(module) {

/*!***************************************************
* advanced-mark.js v2.6.0
* https://github.com/angezid/advanced-mark.js
* MIT licensed
* Copyright (c) 2022–2024, angezid
* Based on 'mark.js', license https://git.io/vwTVl
*****************************************************/

(function (global, factory) {
   true ? module.exports = factory() :
  0;
})(this, (function () { 'use strict';

  function _typeof(o) {
    "@babel/helpers - typeof";

    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) {
      return typeof o;
    } : function (o) {
      return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
    }, _typeof(o);
  }
  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }
  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
    }
  }
  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    Object.defineProperty(Constructor, "prototype", {
      writable: false
    });
    return Constructor;
  }
  function _extends() {
    _extends = Object.assign ? Object.assign.bind() : function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];
        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }
      return target;
    };
    return _extends.apply(this, arguments);
  }
  function _toPrimitive(input, hint) {
    if (typeof input !== "object" || input === null) return input;
    var prim = input[Symbol.toPrimitive];
    if (prim !== undefined) {
      var res = prim.call(input, hint || "default");
      if (typeof res !== "object") return res;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return (hint === "string" ? String : Number)(input);
  }
  function _toPropertyKey(arg) {
    var key = _toPrimitive(arg, "string");
    return typeof key === "symbol" ? key : String(key);
  }

  var DOMIterator = /*#__PURE__*/function () {
    function DOMIterator(ctx, opt) {
      _classCallCheck(this, DOMIterator);
      this.ctx = ctx;
      this.opt = opt;
      this.map = [];
    }
    _createClass(DOMIterator, [{
      key: "getContexts",
      value: function getContexts() {
        var ctx = this.ctx,
          win = this.opt.window,
          sort = false;
        if (!ctx) return [];
        if (Array.isArray(ctx)) {
          sort = true;
        } else if (typeof ctx === 'string') {
          ctx = this.toArray(win.document.querySelectorAll(ctx));
        } else if (ctx.length >= 0) {
          ctx = this.toArray(ctx);
        } else {
          ctx = [ctx];
        }
        var array = [];
        ctx.forEach(function (elem) {
          if (array.indexOf(elem) === -1 && !array.some(function (node) {
            return node.contains(elem);
          })) {
            array.push(elem);
          }
        });
        if (sort) {
          array.sort(function (a, b) {
            return (a.compareDocumentPosition(b) & win.Node.DOCUMENT_POSITION_FOLLOWING) > 0 ? -1 : 1;
          });
        }
        return array;
      }
    }, {
      key: "toArray",
      value: function toArray(collection) {
        var array = [];
        for (var i = 0; i < collection.length; i++) {
          array.push(collection[i]);
        }
        return array;
      }
    }, {
      key: "getIframeContents",
      value: function getIframeContents(iframe, successFn, errorFn) {
        try {
          var doc = iframe.contentWindow.document;
          if (doc) {
            this.map.push([iframe, 'ready']);
            successFn({
              iframe: iframe,
              context: doc
            });
          }
        } catch (e) {
          errorFn({
            iframe: iframe,
            error: e
          });
        }
      }
    }, {
      key: "observeIframeLoad",
      value: function observeIframeLoad(ifr, successFn, errorFn) {
        var _this = this;
        if (this.map.some(function (arr) {
          return arr[0] === ifr;
        })) {
          return;
        }
        var id = null;
        var listener = function listener() {
          clearTimeout(id);
          ifr.removeEventListener('load', listener);
          _this.getIframeContents(ifr, successFn, errorFn);
        };
        ifr.addEventListener('load', listener);
        this.map.push([ifr, true]);
        id = setTimeout(listener, this.opt.iframesTimeout);
      }
    }, {
      key: "onIframeReady",
      value: function onIframeReady(ifr, successFn, errorFn) {
        try {
          var bl = 'about:blank',
            src = ifr.getAttribute('src'),
            win = ifr.contentWindow;
          if (win.document.readyState === 'complete') {
            if (src && src.trim() !== bl && win.location.href === bl) {
              this.observeIframeLoad(ifr, successFn, errorFn);
            } else {
              this.getIframeContents(ifr, successFn, errorFn);
            }
          } else {
            this.observeIframeLoad(ifr, successFn, errorFn);
          }
        } catch (e) {
          errorFn(e);
        }
      }
    }, {
      key: "waitForIframes",
      value: function waitForIframes(ctx, doneCb) {
        var _this2 = this;
        var shadow = this.opt.shadowDOM;
        var count = 0,
          iframes = 0,
          array,
          node;
        var collect = function collect(context) {
          var iterator = _this2.createIterator(context, _this2.opt.window.NodeFilter.SHOW_ELEMENT);
          while (node = iterator.nextNode()) {
            if (_this2.isIframe(node) && !_this2.map.some(function (arr) {
              return arr[0] === node;
            })) {
              array.push(node);
              iframes++;
            }
            if (shadow && node.shadowRoot && node.shadowRoot.mode === 'open') {
              collect(node.shadowRoot);
            }
          }
        };
        var loop = function loop(obj) {
          array = [];
          if (!obj.iframe || obj.context.location.href !== 'about:blank') {
            collect(obj.context);
            if (!obj.iframe && !array.length) {
              doneCb();
              return;
            }
          }
          if (array.length) {
            array.forEach(function (iframe) {
              _this2.onIframeReady(iframe, function (obj) {
                count++;
                loop(obj);
              }, function (obj) {
                if (_this2.opt.debug) {
                  console.log(obj.error || obj);
                }
                if (++count === iframes) doneCb();
              });
            });
          } else if (count === iframes) {
            doneCb();
          }
        };
        loop({
          context: ctx
        });
      }
    }, {
      key: "createIterator",
      value: function createIterator(ctx, whatToShow) {
        var win = this.opt.window;
        return win.document.createNodeIterator(ctx, whatToShow, function () {
          return win.NodeFilter.FILTER_ACCEPT;
        }, false);
      }
    }, {
      key: "addRemoveStyle",
      value: function addRemoveStyle(root, style, add) {
        if (add && !style) return;
        var elem = root.querySelector('style[data-markjs]');
        if (add) {
          if (!elem) {
            elem = this.opt.window.document.createElement('style');
            elem.setAttribute('data-markjs', 'true');
            root.appendChild(elem);
          }
          elem.textContent = style;
        } else if (elem) {
          root.removeChild(elem);
        }
      }
    }, {
      key: "isIframe",
      value: function isIframe(node) {
        return node.tagName === 'IFRAME' && !DOMIterator.matches(node, this.opt.exclude);
      }
    }, {
      key: "iterateThroughNodes",
      value: function iterateThroughNodes(ctx, whatToShow, filterCb, eachCb, doneCb) {
        var _this3 = this;
        var filter = this.opt.window.NodeFilter,
          shadow = this.opt.shadowDOM,
          iframe = this.opt.iframes;
        if (iframe || shadow) {
          var showElement = (whatToShow & filter.SHOW_ELEMENT) > 0,
            showText = (whatToShow & filter.SHOW_TEXT) > 0;
          var traverse = function traverse(node) {
            var iterator = _this3.createIterator(node, whatToShow | filter.SHOW_ELEMENT),
              root;
            while (node = iterator.nextNode()) {
              if (node.nodeType === 1) {
                if (showElement && filterCb(node)) {
                  eachCb(node);
                }
                if (iframe && _this3.isIframe(node) && _this3.map.some(function (arr) {
                  return arr[0] === node && arr[1] === 'ready';
                })) {
                  var doc = node.contentWindow.document;
                  if (doc) traverse(doc);
                }
                if (shadow && (root = node.shadowRoot) && root.mode === 'open') {
                  _this3.addRemoveStyle(root, shadow.style, showText);
                  traverse(root);
                }
              } else if (showText && node.nodeType === 3 && filterCb(node)) {
                eachCb(node);
              }
            }
          };
          traverse(ctx);
        } else {
          var iterator = this.createIterator(ctx, whatToShow);
          var node;
          while (node = iterator.nextNode()) {
            if (filterCb(node)) {
              eachCb(node);
            }
          }
        }
        doneCb();
      }
    }, {
      key: "forEachNode",
      value: function forEachNode(whatToShow, each, filter) {
        var _this4 = this;
        var done = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : function () {};
        var contexts = this.getContexts();
        var open = contexts.length;
        if (!open) done();
        var ready = function ready() {
          contexts.forEach(function (ctx) {
            _this4.iterateThroughNodes(ctx, whatToShow, filter, each, function () {
              if (--open <= 0) done();
            });
          });
        };
        if (this.opt.iframes) {
          var count = open,
            fired = false;
          var id = setTimeout(function () {
            fired = true;
            ready();
          }, this.opt.iframesTimeout);
          var finish = function finish() {
            clearTimeout(id);
            if (!fired) ready();
          };
          contexts.forEach(function (ctx) {
            _this4.waitForIframes(ctx, function () {
              if (--count <= 0) finish();
            });
          });
        } else {
          ready();
        }
      }
    }], [{
      key: "matches",
      value: function matches(element, selector) {
        if (!selector || !selector.length) {
          return false;
        }
        var selectors = typeof selector === 'string' ? [selector] : selector;
        var fn = element.matches || element.matchesSelector || element.msMatchesSelector || element.mozMatchesSelector || element.oMatchesSelector || element.webkitMatchesSelector;
        return fn && selectors.some(function (sel) {
          return fn.call(element, sel);
        });
      }
    }]);
    return DOMIterator;
  }();

  var RegExpCreator = /*#__PURE__*/function () {
    function RegExpCreator(options) {
      _classCallCheck(this, RegExpCreator);
      this.opt = _extends({}, {
        'diacritics': true,
        'synonyms': {},
        'accuracy': 'partially',
        'caseSensitive': false,
        'ignoreJoiners': false,
        'ignorePunctuation': [],
        'wildcards': 'disabled'
      }, options);
    }
    _createClass(RegExpCreator, [{
      key: "chars",
      get: function get() {
        var _this = this;
        if (!this._chars) {
          this._chars = [];
          ['aàáảãạăằắẳẵặâầấẩẫậäåāą', 'cçćč', 'dđď', 'eèéẻẽẹêềếểễệëěēę', 'iìíỉĩịîïī', 'lł', 'nñňń', 'oòóỏõọôồốổỗộơởỡớờợöøōő', 'rř', 'sšśșş', 'tťțţ', 'uùúủũụưừứửữựûüůūű', 'yýỳỷỹỵÿ', 'zžżź'].forEach(function (str) {
            _this._chars.push(str, str.toUpperCase());
          });
        }
        return this._chars;
      }
    }, {
      key: "create",
      value: function create(str, patterns) {
        var flags = 'g' + (this.opt.caseSensitive ? '' : 'i');
        str = this.checkWildcardsEscape(str);
        str = this.createSynonyms(str, flags);
        var joiners = this.getJoinersPunctuation();
        if (joiners) {
          str = this.setupIgnoreJoiners(str);
        }
        if (this.opt.diacritics) {
          str = this.createDiacritics(str);
        }
        str = str.replace(/\s+/g, '[\\s]+');
        if (joiners) {
          str = this.createJoiners(str, joiners);
        }
        if (this.opt.wildcards !== 'disabled') {
          str = this.createWildcards(str);
        }
        var obj = this.createAccuracy(str);
        return patterns ? obj : new RegExp("".concat(obj.lookbehind, "(").concat(obj.pattern, ")").concat(obj.lookahead), flags);
      }
    }, {
      key: "createCombinePattern",
      value: function createCombinePattern(array, capture) {
        var _this2 = this;
        if (!Array.isArray(array) || !array.length) {
          return null;
        }
        var group = capture ? '(' : '(?:',
          obj = this.create(array[0], true);
        obj.pattern = this.distinct(array.map(function (str) {
          return "".concat(group).concat(_this2.create(str, true).pattern, ")");
        })).join('|');
        return obj;
      }
    }, {
      key: "sortByLength",
      value: function sortByLength(arry) {
        return arry.sort(function (a, b) {
          return a.length === b.length ? a > b ? 1 : -1 : b.length - a.length;
        });
      }
    }, {
      key: "escape",
      value: function escape(str) {
        return str.replace(/[[\]/{}()*+?.\\^$|]/g, '\\$&');
      }
    }, {
      key: "preprocess",
      value: function preprocess(val) {
        if (val && val.length) {
          return this.distinct(typeof val === 'string' ? val.split('') : val).join('').replace(/[-^\]\\]/g, '\\$&');
        }
        return '';
      }
    }, {
      key: "distinct",
      value: function distinct(array) {
        var result = [];
        array.forEach(function (item) {
          if (item.trim() && result.indexOf(item) === -1) {
            result.push(item);
          }
        });
        return result;
      }
    }, {
      key: "createSynonyms",
      value: function createSynonyms(str, flags) {
        var _this3 = this;
        var syn = this.opt.synonyms;
        if (!Object.keys(syn).length) {
          return str;
        }
        for (var key in syn) {
          if (syn.hasOwnProperty(key)) {
            var array = Array.isArray(syn[key]) ? syn[key] : [syn[key]];
            array.unshift(key);
            array = this.sortByLength(this.distinct(array)).map(function (term) {
              return _this3.checkWildcardsEscape(term);
            });
            if (array.length > 1) {
              var pattern = array.map(function (k) {
                return _this3.escape(k);
              }).join('|');
              str = str.replace(new RegExp(pattern, flags), "(?:".concat(array.join('|'), ")"));
            }
          }
        }
        return str;
      }
    }, {
      key: "checkWildcardsEscape",
      value: function checkWildcardsEscape(str) {
        if (this.opt.wildcards !== 'disabled') {
          str = str.replace(/(\\.)+|[?*]/g, function (m, gr) {
            return gr ? m : m === '?' ? '\x01' : '\x02';
          }).replace(/\\+(?=[?*\x01\x02])/g, function (m) {
            return m.slice(1);
          });
        }
        return this.escape(str);
      }
    }, {
      key: "createWildcards",
      value: function createWildcards(str) {
        var spaces = this.opt.wildcards === 'withSpaces',
          boundary = this.opt.blockElementsBoundary,
          anyChar = "[^".concat(spaces && boundary ? '\x01' : '', "]*?");
        return str.replace(/\x01/g, spaces ? '[^]?' : '\\S?').replace(/\x02/g, spaces ? anyChar : '\\S*');
      }
    }, {
      key: "setupIgnoreJoiners",
      value: function setupIgnoreJoiners(str) {
        var reg = /((?:\\\\)+|\x02|\(\?:|\|)|\\?(?:[\uD800-\uDBFF][\uDC00-\uDFFF]|.)(?=([|)\x02]|$)|.)/g;
        return str.replace(reg, function (m, gr1, gr2) {
          return gr1 || typeof gr2 !== 'undefined' ? m : m + '\x00';
        });
      }
    }, {
      key: "createJoiners",
      value: function createJoiners(str, joiners) {
        return str.split(/\x00+/).join("[".concat(joiners, "]*"));
      }
    }, {
      key: "getJoinersPunctuation",
      value: function getJoinersPunctuation() {
        var punct = this.preprocess(this.opt.ignorePunctuation),
          str = punct ? punct : '';
        if (this.opt.ignoreJoiners) {
          str += "\\u00ad\\u200b\\u200c\\u200d";
        }
        return str;
      }
    }, {
      key: "createDiacritics",
      value: function createDiacritics(str) {
        var _this4 = this;
        var array = this.chars;
        return str.split('').map(function (ch) {
          for (var i = 0; i < array.length; i += 2) {
            var lowerCase = array[i].indexOf(ch) !== -1;
            if (_this4.opt.caseSensitive) {
              if (lowerCase) {
                return '[' + array[i] + ']';
              } else if (array[i + 1].indexOf(ch) !== -1) {
                return '[' + array[i + 1] + ']';
              }
            } else if (lowerCase || array[i + 1].indexOf(ch) !== -1) {
              return '[' + array[i] + array[i + 1] + ']';
            }
          }
          return ch;
        }).join('');
      }
    }, {
      key: "createAccuracy",
      value: function createAccuracy(str) {
        var chars = '!-/:-@[-`{-~¡¿';
        var accuracy = this.opt.accuracy,
          lookbehind = '()',
          pattern = str,
          lookahead = '',
          limiters;
        if (typeof accuracy !== 'string') {
          limiters = this.preprocess(accuracy.limiters);
          accuracy = accuracy.value;
        }
        if (accuracy === 'exactly') {
          var charSet = limiters ? '[\\s' + limiters + ']' : '\\s';
          lookbehind = "(^|".concat(charSet, ")");
          lookahead = "(?=$|".concat(charSet, ")");
        } else {
          var chs = limiters || chars,
            _charSet = "[^\\s".concat(chs, "]*");
          if (accuracy === 'complementary') {
            pattern = _charSet + str + _charSet;
          } else if (accuracy === 'startsWith') {
            lookbehind = "(^|[\\s".concat(chs, "])");
            pattern = str.split(/\[\\s\]\+/).join(_charSet + '[\\s]+') + _charSet;
          }
        }
        return {
          lookbehind: lookbehind,
          pattern: pattern,
          lookahead: lookahead
        };
      }
    }]);
    return RegExpCreator;
  }();

  var Mark$1 = /*#__PURE__*/function () {
    function Mark(ctx) {
      _classCallCheck(this, Mark);
      this.ctx = ctx;
      this.nodeNames = ['script', 'style', 'title', 'head', 'html'];
    }
    _createClass(Mark, [{
      key: "opt",
      get: function get() {
        return this._opt;
      },
      set: function set(val) {
        if (!(val && val.window && val.window.document) && typeof window === 'undefined') {
          throw new Error('Mark.js: please provide a window object as an option.');
        }
        var win = val && val.window || window;
        this._opt = _extends({}, {
          'window': win,
          'element': '',
          'className': '',
          'exclude': [],
          'iframes': false,
          'iframesTimeout': 5000,
          'separateWordSearch': true,
          'acrossElements': false,
          'ignoreGroups': 0,
          'each': function each() {},
          'noMatch': function noMatch() {},
          'filter': function filter() {
            return true;
          },
          'done': function done() {},
          'debug': false,
          'log': win.console
        }, val);
        if (!this._opt.element) {
          this._opt.element = 'mark';
        }
        this.filter = win.NodeFilter;
        this.empty = win.document.createTextNode('');
      }
    }, {
      key: "iterator",
      get: function get() {
        return new DOMIterator(this.ctx, this.opt);
      }
    }, {
      key: "log",
      value: function log(msg) {
        var level = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'debug';
        if (this.opt.debug) {
          var log = this.opt.log;
          if (_typeof(log) === 'object' && typeof log[level] === 'function') {
            log[level]("mark.js: ".concat(msg));
          }
        }
      }
    }, {
      key: "report",
      value: function report(array) {
        var _this = this;
        array.forEach(function (item) {
          _this.log("".concat(item.text, " ").concat(JSON.stringify(item.obj)), item.level || 'debug');
          if (!item.skip) {
            _this.opt.noMatch(item.obj);
          }
        });
      }
    }, {
      key: "checkOption",
      value: function checkOption(opt, del) {
        this.opt = opt;
        var dict = this.cacheDict,
          clear = true;
        if (dict) {
          if (!del && this.opt.cacheTextNodes) {
            if (this.opt.acrossElements) {
              if (dict.across) {
                clear = false;
              }
            } else if (!dict.across) {
              clear = false;
            }
          }
          if (clear) {
            this.cacheDict = null;
          }
        }
      }
    }, {
      key: "getSeachTerms",
      value: function getSeachTerms(sv) {
        var search = typeof sv === 'string' ? [sv] : sv,
          separate = this.opt.separateWordSearch,
          array = [],
          termStats = {},
          split = function split(str) {
            str.split(/ +/).forEach(function (word) {
              return add(word);
            });
          },
          add = function add(str) {
            if (str.trim() && array.indexOf(str) === -1) {
              array.push(str);
              termStats[str] = 0;
            }
          };
        search.forEach(function (str) {
          if (separate) {
            if (separate === 'preserveTerms') {
              str.split(/"("*[^"]+"*)"/).forEach(function (term, i) {
                if (i % 2 > 0) add(term);else split(term);
              });
            } else {
              split(str);
            }
          } else {
            add(str);
          }
        });
        array.sort(function (a, b) {
          return b.length - a.length;
        });
        return {
          terms: array,
          termStats: termStats
        };
      }
    }, {
      key: "isNumeric",
      value: function isNumeric(value) {
        return Number(parseFloat(value)) == value;
      }
    }, {
      key: "checkRanges",
      value: function checkRanges(array, logs, min, max) {
        var _this2 = this;
        var level = 'error';
        var ranges = array.filter(function (range) {
          if (_this2.isNumeric(range.start) && _this2.isNumeric(range.length)) {
            range.start = parseInt(range.start);
            range.length = parseInt(range.length);
            if (range.start >= min && range.start < max && range.length > 0) {
              return true;
            }
          }
          logs.push({
            text: 'Invalid range: ',
            obj: range,
            level: level
          });
          return false;
        }).sort(function (a, b) {
          return a.start - b.start;
        });
        if (this.opt.wrapAllRanges) {
          return ranges;
        }
        var lastIndex = 0,
          index;
        return ranges.filter(function (range) {
          index = range.start + range.length;
          if (range.start >= lastIndex) {
            lastIndex = index;
            return true;
          }
          logs.push({
            text: (index < lastIndex ? 'Nest' : 'Overlapp') + 'ing range: ',
            obj: range,
            level: level
          });
          return false;
        });
      }
    }, {
      key: "setType",
      value: function setType(tags, boundary) {
        var custom = Array.isArray(boundary.tagNames) && boundary.tagNames.length;
        if (custom) {
          boundary.tagNames.forEach(function (name) {
            return tags[name.toLowerCase()] = 2;
          });
        }
        if (!custom || boundary.extend) {
          for (var key in tags) {
            tags[key] = 2;
          }
        }
        tags['br'] = 3;
      }
    }, {
      key: "getTextNodesAcross",
      value: function getTextNodesAcross(cb) {
        var _this3 = this;
        if (this.opt.cacheTextNodes && this.cacheDict) {
          this.cacheDict.lastIndex = 0;
          this.cacheDict.lastTextIndex = 0;
          cb(this.cacheDict);
          return;
        }
        var tags = {
          div: 1,
          p: 1,
          li: 1,
          td: 1,
          tr: 1,
          th: 1,
          ul: 1,
          ol: 1,
          dd: 1,
          dl: 1,
          dt: 1,
          h1: 1,
          h2: 1,
          h3: 1,
          h4: 1,
          h5: 1,
          h6: 1,
          hr: 1,
          blockquote: 1,
          figcaption: 1,
          figure: 1,
          pre: 1,
          table: 1,
          thead: 1,
          tbody: 1,
          tfoot: 1,
          input: 1,
          img: 1,
          nav: 1,
          details: 1,
          label: 1,
          form: 1,
          select: 1,
          menu: 1,
          br: 3,
          menuitem: 1,
          main: 1,
          section: 1,
          article: 1,
          aside: 1,
          picture: 1,
          output: 1,
          button: 1,
          header: 1,
          footer: 1,
          address: 1,
          area: 1,
          canvas: 1,
          map: 1,
          fieldset: 1,
          textarea: 1,
          track: 1,
          video: 1,
          audio: 1,
          body: 1,
          iframe: 1,
          meter: 1,
          object: 1,
          svg: 1
        };
        var nodes = [],
          boundary = this.opt.blockElementsBoundary,
          priorityType = boundary ? 2 : 1;
        var ch = '\x01',
          tempType,
          type,
          prevNode;
        if (boundary) {
          this.setType(tags, boundary);
          if (boundary["char"]) {
            ch = boundary["char"].charAt(0);
          }
        }
        var obj = {
          text: '',
          regex: /\s/,
          tags: tags,
          boundary: boundary,
          startOffset: 0,
          str: '',
          ch: ch
        };
        this.iterator.forEachNode(this.filter.SHOW_ELEMENT | this.filter.SHOW_TEXT, function (node) {
          if (prevNode) {
            nodes.push(_this3.getNodeInfo(prevNode, node, type, obj));
          }
          type = null;
          prevNode = node;
        }, function (node) {
          if (node.nodeType === 1) {
            tempType = tags[node.nodeName.toLowerCase()];
            if (tempType === 3) {
              obj.str += '\n';
            }
            if (!type || tempType === priorityType) {
              type = tempType;
            }
            return false;
          }
          return !_this3.excluded(node.parentNode);
        }, function () {
          if (prevNode) {
            nodes.push(_this3.getNodeInfo(prevNode, null, type, obj));
          }
          cb(_this3.createDict(obj.text, nodes, true));
        });
      }
    }, {
      key: "getNodeInfo",
      value: function getNodeInfo(prevNode, node, type, obj) {
        var start = obj.text.length,
          startOffset = obj.startOffset,
          ch = obj.ch;
        var offset = 0,
          str = obj.str,
          text = prevNode.textContent;
        if (node) {
          var startBySpace = obj.regex.test(node.textContent[0]),
            both = startBySpace && obj.regex.test(text[text.length - 1]);
          if (obj.boundary || !both) {
            var separate = type;
            if (!type) {
              var parent = prevNode.parentNode;
              while (parent) {
                type = obj.tags[parent.nodeName.toLowerCase()];
                if (type) {
                  separate = !(parent === node.parentNode || parent.contains(node));
                  break;
                }
                parent = parent.parentNode;
              }
            }
            if (separate) {
              if (!both) {
                str += type === 1 ? ' ' : type === 2 ? ' ' + ch + ' ' : '';
              } else if (type === 2) {
                str += both ? ch : startBySpace ? ' ' + ch : ch + ' ';
              }
            }
          }
        }
        if (str) {
          text += str;
          offset = str.length;
          obj.startOffset -= offset;
          obj.str = '';
        }
        obj.text += text;
        return this.createInfo(prevNode, start, obj.text.length - offset, offset, startOffset);
      }
    }, {
      key: "getTextNodes",
      value: function getTextNodes(cb) {
        var _this4 = this;
        if (this.opt.cacheTextNodes && this.cacheDict) {
          cb(this.cacheDict);
          return;
        }
        var nodes = [],
          regex = /\n/g,
          newLines = [0],
          lines = this.opt.markLines,
          show = this.filter.SHOW_TEXT | (lines ? this.filter.SHOW_ELEMENT : 0);
        var text = '',
          len = 0,
          rm;
        this.iterator.forEachNode(show, function (node) {
          if (lines) {
            while ((rm = regex.exec(node.textContent)) !== null) {
              newLines.push(len + rm.index);
            }
          }
          text += node.textContent;
          nodes.push({
            start: len,
            end: len = text.length,
            offset: 0,
            node: node
          });
        }, function (node) {
          if (lines && node.nodeType === 1) {
            if (node.tagName === 'BR') {
              newLines.push(len);
            }
            return false;
          }
          return !_this4.excluded(node.parentNode);
        }, function () {
          var dict = _this4.createDict(text, nodes, false);
          if (lines) {
            newLines.push(len);
            dict.newLines = newLines;
          }
          cb(dict);
        });
      }
    }, {
      key: "createDict",
      value: function createDict(text, nodes, across) {
        var dict = {
          text: text,
          nodes: nodes,
          lastIndex: 0,
          lastTextIndex: 0
        };
        if (this.opt.cacheTextNodes) {
          this.cacheDict = dict;
          this.cacheDict.across = across;
        }
        return dict;
      }
    }, {
      key: "excluded",
      value: function excluded(elem) {
        return this.nodeNames.indexOf(elem.nodeName.toLowerCase()) !== -1 || DOMIterator.matches(elem, this.opt.exclude);
      }
    }, {
      key: "wrapRangeInsert",
      value: function wrapRangeInsert(dict, n, s, e, start, index) {
        var ended = e === n.node.textContent.length,
          end = n.end;
        var type = 1,
          splitIndex = e,
          node = n.node;
        if (s !== 0) {
          node = node.splitText(s);
          splitIndex = e - s;
          type = ended ? 2 : 3;
        } else if (ended) {
          type = 0;
        }
        var retNode = ended ? this.empty : node.splitText(splitIndex),
          mark = this.wrapTextNode(node),
          markChild = mark.childNodes[0],
          nodeInfo = this.createInfo(retNode, type === 0 || type === 2 ? end : n.start + e, end, n.offset, n.startOffset);
        if (type === 0) {
          n.node = markChild;
          return {
            mark: mark,
            nodeInfo: nodeInfo,
            increment: 0
          };
        }
        var info = this.createInfo(markChild, type === 1 ? n.start : start, n.start + e, 0, n.startOffset);
        if (type === 1) {
          dict.nodes.splice(index, 1, info, nodeInfo);
        } else {
          if (type === 2) {
            dict.nodes.splice(index + 1, 0, info);
          } else {
            dict.nodes.splice(index + 1, 0, info, nodeInfo);
          }
          n.end = start;
          n.offset = 0;
        }
        return {
          mark: mark,
          nodeInfo: nodeInfo,
          increment: type < 3 ? 1 : 2
        };
      }
    }, {
      key: "createInfo",
      value: function createInfo(node, start, end, offset, startOffset) {
        return {
          node: node,
          start: start,
          end: end,
          offset: offset,
          startOffset: startOffset
        };
      }
    }, {
      key: "wrapRange",
      value: function wrapRange(node, start, end, eachCb) {
        var ended = end === node.textContent.length,
          index = end,
          retNode;
        if (start !== 0) {
          node = node.splitText(start);
          index = end - start;
        }
        retNode = ended ? this.empty : node.splitText(index);
        eachCb(this.wrapTextNode(node));
        return retNode;
      }
    }, {
      key: "wrapTextNode",
      value: function wrapTextNode(node) {
        var markNode = this.opt.window.document.createElement(this.opt.element);
        markNode.setAttribute('data-markjs', 'true');
        if (this.opt.className) {
          markNode.setAttribute('class', this.opt.className);
        }
        markNode.textContent = node.textContent;
        node.parentNode.replaceChild(markNode, node);
        return markNode;
      }
    }, {
      key: "wrapRangeAcross",
      value: function wrapRangeAcross(dict, start, end, filterCb, eachCb) {
        var i = dict.lastIndex,
          rangeStart = true;
        var wrapAllRanges = this.opt.wrapAllRanges || this.opt.cacheTextNodes;
        if (wrapAllRanges) {
          while (i > 0 && dict.nodes[i].start > start) {
            i--;
          }
        } else if (start < dict.lastTextIndex) {
          return;
        }
        for (i; i < dict.nodes.length; i++) {
          if (i + 1 === dict.nodes.length || dict.nodes[i + 1].start > start) {
            var n = dict.nodes[i];
            if (!filterCb(n)) break;
            var s = start - n.start,
              e = (end > n.end ? n.end : end) - n.start;
            if (s >= 0 && e > s) {
              if (wrapAllRanges) {
                var obj = this.wrapRangeInsert(dict, n, s, e, start, i);
                n = obj.nodeInfo;
                eachCb(obj.mark, rangeStart);
              } else {
                n.node = this.wrapRange(n.node, s, e, function (node) {
                  eachCb(node, rangeStart);
                });
                n.start += e;
                dict.lastTextIndex = n.start;
              }
              rangeStart = false;
            }
            if (end > n.end) {
              start = n.end + n.offset;
            } else {
              break;
            }
          }
        }
        dict.lastIndex = i;
      }
    }, {
      key: "wrapGroups",
      value: function wrapGroups(node, match, params, filterCb, eachCb) {
        var _this5 = this;
        var startIndex = match.index,
          isWrapped = false,
          group,
          start;
        params.groups.forEach(function (index) {
          group = match[index];
          if (group) {
            start = node.textContent.indexOf(group, startIndex);
            if (start !== -1) {
              if (filterCb(node, group, index)) {
                node = _this5.wrapRange(node, start, start + group.length, function (node) {
                  eachCb(node, index);
                });
                startIndex = 0;
                isWrapped = true;
              } else {
                startIndex = start + group.length;
              }
            }
          }
        });
        if (isWrapped) {
          params.regex.lastIndex = 0;
        }
        return node;
      }
    }, {
      key: "wrapGroupsAcross",
      value: function wrapGroupsAcross(dict, match, params, filterCb, eachCb) {
        var _this6 = this;
        var startIndex = 0,
          group,
          start,
          end;
        var s = match.index,
          text = match[0],
          wrap = function wrap(start, end, index) {
            _this6.wrapRangeAcross(dict, s + start, s + end, function (obj) {
              return filterCb(obj, text, index);
            }, function (node, groupStart) {
              eachCb(node, groupStart, index);
            });
          };
        if (this.opt.wrapAllRanges) {
          wrap(0, text.length, 0);
        }
        params.groups.forEach(function (index) {
          group = match[index];
          if (group) {
            start = text.indexOf(group, startIndex);
            if (start !== -1) {
              end = start + group.length;
              wrap(start, end, index);
              startIndex = end;
            }
          }
        });
      }
    }, {
      key: "wrapGroupsDFlag",
      value: function wrapGroupsDFlag(node, match, params, filterCb, eachCb) {
        var lastIndex = 0,
          offset = 0,
          i = 0,
          isWrapped = false,
          group,
          start,
          end = 0;
        while (++i < match.length) {
          group = match[i];
          if (group) {
            start = match.indices[i][0];
            if (start >= lastIndex) {
              end = match.indices[i][1];
              if (filterCb(node, group, i)) {
                node = this.wrapRange(node, start - offset, end - offset, function (node) {
                  eachCb(node, i);
                });
                if (end > lastIndex) {
                  lastIndex = end;
                }
                offset = end;
                isWrapped = true;
              }
            }
          }
        }
        if (isWrapped) {
          params.regex.lastIndex = 0;
        } else if (match[0].length === 0) {
          this.setLastIndex(params.regex, end);
        }
        return node;
      }
    }, {
      key: "wrapGroupsDFlagAcross",
      value: function wrapGroupsDFlagAcross(dict, match, params, filterCb, eachCb) {
        var lastIndex = 0,
          i = 0,
          group,
          start,
          end = 0,
          isWrapped;
        while (++i < match.length) {
          group = match[i];
          if (group) {
            start = match.indices[i][0];
            if (this.opt.wrapAllRanges || start >= lastIndex) {
              end = match.indices[i][1];
              isWrapped = false;
              this.wrapRangeAcross(dict, start, end, function (obj) {
                return filterCb(obj, group, i);
              }, function (node, groupStart) {
                isWrapped = true;
                eachCb(node, groupStart, i);
              });
              if (isWrapped && end > lastIndex) {
                lastIndex = end;
              }
            }
          }
        }
        if (match[0].length === 0) {
          this.setLastIndex(params.regex, end);
        }
      }
    }, {
      key: "setLastIndex",
      value: function setLastIndex(regex, end) {
        var index = regex.lastIndex;
        regex.lastIndex = end > index ? end : end > 0 ? index + 1 : Infinity;
      }
    }, {
      key: "collectGroupIndexes",
      value: function collectGroupIndexes(regex) {
        var groups = [],
          stack = [],
          index = 0,
          brackets = 0,
          str = regex.source,
          rm,
          reg = /(?:\\.)+|\[(?:[^\\\]]|(?:\\.))+\]|(\(\?<(?![=!])|\((?!\?))|(\()|(\))/g;
        while ((rm = reg.exec(str)) !== null) {
          if (rm[1]) {
            stack.push(1);
            index++;
            if (brackets++ === 0) {
              groups.push(index);
            }
          } else if (rm[2]) {
            stack.push(0);
          } else if (rm[3] && stack.pop()) {
            brackets--;
          }
        }
        return groups;
      }
    }, {
      key: "wrapSeparateGroups",
      value: function wrapSeparateGroups(regex, unused, filterCb, eachCb, endCb) {
        var _this7 = this;
        var hasIndices = regex.hasIndices,
          fn = hasIndices ? 'wrapGroupsDFlag' : 'wrapGroups',
          params = {
            regex: regex,
            groups: hasIndices ? {} : this.collectGroupIndexes(regex)
          },
          execution = {
            abort: false
          },
          info = {
            execution: execution
          };
        var node,
          match,
          filterStart,
          eachStart,
          count = 0;
        this.getTextNodes(function (dict) {
          dict.nodes.every(function (obj) {
            node = obj.node;
            info.offset = obj.start;
            while ((match = regex.exec(node.textContent)) !== null && (hasIndices || match[0] !== '')) {
              info.match = match;
              filterStart = eachStart = true;
              node = _this7[fn](node, match, params, function (node, group, grIndex) {
                info.matchStart = filterStart;
                info.groupIndex = grIndex;
                filterStart = false;
                return filterCb(node, group, info);
              }, function (node, grIndex) {
                if (eachStart) {
                  count++;
                }
                eachCb(node, {
                  match: match,
                  matchStart: eachStart,
                  count: count,
                  groupIndex: grIndex
                });
                eachStart = false;
              });
              if (execution.abort) break;
            }
            return !execution.abort;
          });
          endCb(count);
        });
      }
    }, {
      key: "wrapSeparateGroupsAcross",
      value: function wrapSeparateGroupsAcross(regex, unused, filterCb, eachCb, endCb) {
        var _this8 = this;
        var hasIndices = regex.hasIndices,
          fn = hasIndices ? 'wrapGroupsDFlagAcross' : 'wrapGroupsAcross',
          params = {
            regex: regex,
            groups: hasIndices ? {} : this.collectGroupIndexes(regex)
          },
          execution = {
            abort: false
          },
          info = {
            execution: execution
          };
        var match,
          filterStart,
          eachStart,
          count = 0;
        this.getTextNodesAcross(function (dict) {
          while ((match = regex.exec(dict.text)) !== null && (hasIndices || match[0] !== '')) {
            info.match = match;
            filterStart = eachStart = true;
            _this8[fn](dict, match, params, function (obj, group, grIndex) {
              info.matchStart = filterStart;
              info.groupIndex = grIndex;
              info.offset = obj.startOffset;
              filterStart = false;
              return filterCb(obj.node, group, info);
            }, function (node, groupStart, grIndex) {
              if (eachStart) {
                count++;
              }
              eachCb(node, {
                match: match,
                matchStart: eachStart,
                count: count,
                groupIndex: grIndex,
                groupStart: groupStart
              });
              eachStart = false;
            });
            if (execution.abort) break;
          }
          endCb(count);
        });
      }
    }, {
      key: "wrapMatches",
      value: function wrapMatches(regex, ignoreGroups, filterCb, eachCb, endCb) {
        var _this9 = this;
        var index = ignoreGroups === 0 ? 0 : ignoreGroups + 1,
          execution = {
            abort: false
          },
          filterInfo = {
            execution: execution
          };
        var info,
          node,
          match,
          str,
          count = 0;
        this.getTextNodes(function (dict) {
          for (var k = 0; k < dict.nodes.length; k++) {
            info = dict.nodes[k];
            node = info.node;
            while ((match = regex.exec(node.textContent)) !== null && (str = match[index]) !== '') {
              filterInfo.match = match;
              filterInfo.offset = info.start;
              if (!filterCb(node, str, filterInfo)) {
                continue;
              }
              var i = 0,
                start = match.index;
              while (++i < index) {
                if (match[i]) {
                  start += match[i].length;
                }
              }
              var end = start + str.length;
              if (_this9.opt.cacheTextNodes) {
                var obj = _this9.wrapRangeInsert(dict, info, start, end, info.start + start, k);
                eachCb(obj.mark, {
                  match: match,
                  count: ++count
                });
                if (obj.increment === 0) break;
                k += obj.increment;
                info = obj.nodeInfo;
                node = info.node;
              } else {
                node = _this9.wrapRange(node, start, end, function (node) {
                  eachCb(node, {
                    match: match,
                    count: ++count
                  });
                });
              }
              regex.lastIndex = 0;
              if (execution.abort) break;
            }
            if (execution.abort) break;
          }
          endCb(count);
        });
      }
    }, {
      key: "wrapMatchesAcross",
      value: function wrapMatchesAcross(regex, ignoreGroups, filterCb, eachCb, endCb) {
        var _this10 = this;
        var index = ignoreGroups === 0 ? 0 : ignoreGroups + 1,
          execution = {
            abort: false
          },
          filterInfo = {
            execution: execution
          };
        var match,
          str,
          matchStart,
          count = 0;
        this.getTextNodesAcross(function (dict) {
          while ((match = regex.exec(dict.text)) !== null && (str = match[index]) !== '') {
            filterInfo.match = match;
            matchStart = true;
            var i = 0,
              start = match.index;
            while (++i < index) {
              if (match[i]) {
                start += match[i].length;
              }
            }
            _this10.wrapRangeAcross(dict, start, start + str.length, function (obj) {
              filterInfo.matchStart = matchStart;
              filterInfo.offset = obj.startOffset;
              matchStart = false;
              return filterCb(obj.node, str, filterInfo);
            }, function (node, mStart) {
              if (mStart) {
                count++;
              }
              eachCb(node, {
                match: match,
                matchStart: mStart,
                count: count
              });
            });
            if (execution.abort) break;
          }
          endCb(count);
        });
      }
    }, {
      key: "wrapRanges",
      value: function wrapRanges(ranges, filterCb, eachCb, endCb) {
        var _this11 = this;
        var lines = this.opt.markLines,
          logs = [],
          skipped = [],
          level = 'warn';
        var count = 0;
        this.getTextNodes(function (dict) {
          var max = lines ? dict.newLines.length : dict.text.length,
            array = _this11.checkRanges(ranges, logs, lines ? 1 : 0, max);
          array.forEach(function (range, index) {
            var start = range.start,
              end = start + range.length;
            if (end > max) {
              logs.push({
                text: "Range was limited to: ".concat(max),
                obj: range,
                skip: true,
                level: level
              });
              end = max;
            }
            if (lines) {
              start = dict.newLines[start - 1];
              if (dict.text[start] === '\n') {
                start++;
              }
              end = dict.newLines[end - 1];
            }
            var substr = dict.text.substring(start, end);
            if (substr.trim()) {
              _this11.wrapRangeAcross(dict, start, end, function (obj) {
                return filterCb(obj.node, range, substr, index);
              }, function (node, rangeStart) {
                if (rangeStart) {
                  count++;
                }
                eachCb(node, range, {
                  matchStart: rangeStart,
                  count: count
                });
              });
            } else {
              logs.push({
                text: 'Skipping whitespace only range: ',
                obj: range,
                level: level
              });
              skipped.push(range);
            }
          });
          _this11.log("Valid ranges: ".concat(JSON.stringify(array.filter(function (range) {
            return skipped.indexOf(range) === -1;
          }))));
          endCb(count, logs);
        });
      }
    }, {
      key: "unwrapMatches",
      value: function unwrapMatches(node) {
        var parent = node.parentNode,
          first = node.firstChild;
        if (node.childNodes.length === 1) {
          if (first.nodeType === 3) {
            var previous = node.previousSibling,
              next = node.nextSibling;
            if (previous && previous.nodeType === 3) {
              if (next && next.nodeType === 3) {
                previous.nodeValue += first.nodeValue + next.nodeValue;
                parent.removeChild(next);
              } else {
                previous.nodeValue += first.nodeValue;
              }
            } else if (next && next.nodeType === 3) {
              next.nodeValue = first.nodeValue + next.nodeValue;
            } else {
              parent.replaceChild(node.firstChild, node);
              return;
            }
            parent.removeChild(node);
          } else {
            parent.replaceChild(node.firstChild, node);
          }
        } else {
          if (!first) {
            parent.removeChild(node);
          } else {
            var docFrag = this.opt.window.document.createDocumentFragment();
            while (node.firstChild) {
              docFrag.appendChild(node.removeChild(node.firstChild));
            }
            parent.replaceChild(docFrag, node);
          }
          parent.normalize();
        }
      }
    }, {
      key: "markRegExp",
      value: function markRegExp(regexp, opt) {
        var _this12 = this;
        this.checkOption(opt);
        var totalMarks = 0,
          matchesSoFar = 0,
          fn = this.opt.separateGroups ? 'wrapSeparateGroups' : 'wrapMatches';
        if (this.opt.acrossElements) {
          fn += 'Across';
          if (!regexp.global && !regexp.sticky) {
            var splits = regexp.toString().split('/');
            regexp = new RegExp(regexp.source, 'g' + splits[splits.length - 1]);
            this.log('RegExp is recompiled - it must have a `g` flag');
          }
        }
        this.log("RegExp \"".concat(regexp, "\""));
        this[fn](regexp, this.opt.ignoreGroups, function (node, match, filterInfo) {
          return _this12.opt.filter(node, match, matchesSoFar, filterInfo);
        }, function (element, eachInfo) {
          matchesSoFar = eachInfo.count;
          totalMarks++;
          _this12.opt.each(element, eachInfo);
        }, function (totalMatches) {
          if (totalMatches === 0) {
            _this12.opt.noMatch(regexp);
          }
          _this12.opt.done(totalMarks, totalMatches);
        });
      }
    }, {
      key: "mark",
      value: function mark(sv, opt) {
        var _this13 = this;
        this.checkOption(opt);
        var _this$getSeachTerms = this.getSeachTerms(sv),
          terms = _this$getSeachTerms.terms,
          termStats = _this$getSeachTerms.termStats;
        if (!terms.length) {
          this.opt.done(0, 0, termStats);
          return;
        }
        if (this.opt.combinePatterns) {
          this.markCombinePatterns(terms, termStats);
          return;
        }
        var index = 0,
          totalMarks = 0,
          matches = 0,
          totalMatches = 0,
          termMatches;
        var regCreator = new RegExpCreator(this.opt),
          fn = this.opt.acrossElements ? 'wrapMatchesAcross' : 'wrapMatches';
        var loop = function loop(term) {
          termMatches = 0;
          var regex = regCreator.create(term);
          _this13.log("RegExp \"".concat(regex, "\""));
          _this13[fn](regex, 1, function (node, t, filterInfo) {
            matches = totalMatches + termMatches;
            return _this13.opt.filter(node, term, matches, termMatches, filterInfo);
          }, function (element, eachInfo) {
            termMatches = eachInfo.count;
            totalMarks++;
            _this13.opt.each(element, eachInfo);
          }, function (count) {
            totalMatches += count;
            if (count === 0) {
              _this13.opt.noMatch(term);
            }
            termStats[term] = count;
            if (++index < terms.length) {
              loop(terms[index]);
            } else {
              _this13.opt.done(totalMarks, totalMatches, termStats);
            }
          });
        };
        loop(terms[index]);
      }
    }, {
      key: "markCombinePatterns",
      value: function markCombinePatterns(terms, termStats) {
        var _this14 = this;
        var index = 0,
          totalMarks = 0,
          totalMatches = 0,
          term,
          termMatches;
        var across = this.opt.acrossElements,
          fn = across ? 'wrapMatchesAcross' : 'wrapMatches',
          flags = "g".concat(this.opt.caseSensitive ? '' : 'i'),
          patterns = this.getPatterns(terms);
        var loop = function loop(_ref) {
          var pattern = _ref.pattern,
            regTerms = _ref.regTerms;
          var regex = new RegExp(pattern, flags);
          _this14.log("RegExp \"".concat(regex, "\""));
          _this14[fn](regex, 1, function (node, t, filterInfo) {
            if (!across || filterInfo.matchStart) {
              term = _this14.getCurrentTerm(filterInfo.match, regTerms);
            }
            termMatches = termStats[term];
            return _this14.opt.filter(node, term, totalMatches + termMatches, termMatches, filterInfo);
          }, function (element, eachInfo) {
            totalMarks++;
            if (!across || eachInfo.matchStart) {
              termStats[term] += 1;
            }
            _this14.opt.each(element, eachInfo);
          }, function (count) {
            totalMatches += count;
            var array = regTerms.filter(function (term) {
              return termStats[term] === 0;
            });
            if (array.length) {
              _this14.opt.noMatch(array);
            }
            if (++index < patterns.length) {
              loop(patterns[index]);
            } else {
              _this14.opt.done(totalMarks, totalMatches, termStats);
            }
          });
        };
        loop(patterns[index]);
      }
    }, {
      key: "getCurrentTerm",
      value: function getCurrentTerm(match, terms) {
        var i = match.length;
        while (--i > 2) {
          if (match[i]) {
            return terms[i - 3];
          }
        }
        return ' ';
      }
    }, {
      key: "getPatterns",
      value: function getPatterns(terms) {
        var creator = new RegExpCreator(this.opt),
          option = this.opt.combinePatterns,
          array = [];
        var num = 10,
          value;
        if (option === Infinity) {
          num = Math.pow(2, 31);
        } else if (Number.isInteger(option) && (value = parseInt(option)) > 0) {
          num = value;
        }
        for (var i = 0; i < terms.length; i += num) {
          var chunk = terms.slice(i, Math.min(i + num, terms.length)),
            obj = creator.createCombinePattern(chunk, true);
          array.push({
            pattern: "".concat(obj.lookbehind, "(").concat(obj.pattern, ")").concat(obj.lookahead),
            regTerms: chunk
          });
        }
        return array;
      }
    }, {
      key: "markRanges",
      value: function markRanges(ranges, opt) {
        var _this15 = this;
        this.checkOption(opt, true);
        if (Array.isArray(ranges)) {
          var totalMarks = 0;
          this.wrapRanges(ranges, function (node, range, match, index) {
            return _this15.opt.filter(node, range, match, index);
          }, function (elem, range, rangeInfo) {
            totalMarks++;
            _this15.opt.each(elem, range, rangeInfo);
          }, function (totalRanges, logs) {
            _this15.report(logs);
            _this15.opt.done(totalMarks, totalRanges);
          });
        } else {
          this.report([{
            text: 'markRanges() accept an array of objects: ',
            obj: ranges,
            level: 'error'
          }]);
          this.opt.done(0, 0);
        }
      }
    }, {
      key: "unmark",
      value: function unmark(opt) {
        var _this16 = this;
        this.checkOption(opt, true);
        var selector = this.opt.element + '[data-markjs]';
        if (this.opt.className) {
          selector += ".".concat(this.opt.className);
        }
        this.log("Removal selector \"".concat(selector, "\""));
        this.iterator.forEachNode(this.filter.SHOW_ELEMENT, function (node) {
          _this16.unwrapMatches(node);
        }, function (node) {
          return DOMIterator.matches(node, selector) && !_this16.excluded(node);
        }, this.opt.done);
      }
    }]);
    return Mark;
  }();

  function Mark(ctx) {
    var _this = this;
    var instance = new Mark$1(ctx);
    this.mark = function (sv, opt) {
      instance.mark(sv, opt);
      return _this;
    };
    this.markRegExp = function (sv, opt) {
      instance.markRegExp(sv, opt);
      return _this;
    };
    this.markRanges = function (sv, opt) {
      instance.markRanges(sv, opt);
      return _this;
    };
    this.unmark = function (opt) {
      instance.unmark(opt);
      return _this;
    };
    this.getVersion = function () {
      return '2.6.0';
    };
    return this;
  }

  return Mark;

}));


/***/ }),

/***/ "../../node_modules/lodash/_Symbol.js":
/*!********************************************!*\
  !*** ../../node_modules/lodash/_Symbol.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var root = __webpack_require__(/*! ./_root */ "../../node_modules/lodash/_root.js");

/** Built-in value references. */
var Symbol = root.Symbol;

module.exports = Symbol;


/***/ }),

/***/ "../../node_modules/lodash/_baseGetTag.js":
/*!************************************************!*\
  !*** ../../node_modules/lodash/_baseGetTag.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Symbol = __webpack_require__(/*! ./_Symbol */ "../../node_modules/lodash/_Symbol.js"),
    getRawTag = __webpack_require__(/*! ./_getRawTag */ "../../node_modules/lodash/_getRawTag.js"),
    objectToString = __webpack_require__(/*! ./_objectToString */ "../../node_modules/lodash/_objectToString.js");

/** `Object#toString` result references. */
var nullTag = '[object Null]',
    undefinedTag = '[object Undefined]';

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (symToStringTag && symToStringTag in Object(value))
    ? getRawTag(value)
    : objectToString(value);
}

module.exports = baseGetTag;


/***/ }),

/***/ "../../node_modules/lodash/_baseTrim.js":
/*!**********************************************!*\
  !*** ../../node_modules/lodash/_baseTrim.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var trimmedEndIndex = __webpack_require__(/*! ./_trimmedEndIndex */ "../../node_modules/lodash/_trimmedEndIndex.js");

/** Used to match leading whitespace. */
var reTrimStart = /^\s+/;

/**
 * The base implementation of `_.trim`.
 *
 * @private
 * @param {string} string The string to trim.
 * @returns {string} Returns the trimmed string.
 */
function baseTrim(string) {
  return string
    ? string.slice(0, trimmedEndIndex(string) + 1).replace(reTrimStart, '')
    : string;
}

module.exports = baseTrim;


/***/ }),

/***/ "../../node_modules/lodash/_freeGlobal.js":
/*!************************************************!*\
  !*** ../../node_modules/lodash/_freeGlobal.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof __webpack_require__.g == 'object' && __webpack_require__.g && __webpack_require__.g.Object === Object && __webpack_require__.g;

module.exports = freeGlobal;


/***/ }),

/***/ "../../node_modules/lodash/_getRawTag.js":
/*!***********************************************!*\
  !*** ../../node_modules/lodash/_getRawTag.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Symbol = __webpack_require__(/*! ./_Symbol */ "../../node_modules/lodash/_Symbol.js");

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the raw `toStringTag`.
 */
function getRawTag(value) {
  var isOwn = hasOwnProperty.call(value, symToStringTag),
      tag = value[symToStringTag];

  try {
    value[symToStringTag] = undefined;
    var unmasked = true;
  } catch (e) {}

  var result = nativeObjectToString.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag] = tag;
    } else {
      delete value[symToStringTag];
    }
  }
  return result;
}

module.exports = getRawTag;


/***/ }),

/***/ "../../node_modules/lodash/_objectToString.js":
/*!****************************************************!*\
  !*** ../../node_modules/lodash/_objectToString.js ***!
  \****************************************************/
/***/ ((module) => {

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/**
 * Converts `value` to a string using `Object.prototype.toString`.
 *
 * @private
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 */
function objectToString(value) {
  return nativeObjectToString.call(value);
}

module.exports = objectToString;


/***/ }),

/***/ "../../node_modules/lodash/_root.js":
/*!******************************************!*\
  !*** ../../node_modules/lodash/_root.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var freeGlobal = __webpack_require__(/*! ./_freeGlobal */ "../../node_modules/lodash/_freeGlobal.js");

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

module.exports = root;


/***/ }),

/***/ "../../node_modules/lodash/_trimmedEndIndex.js":
/*!*****************************************************!*\
  !*** ../../node_modules/lodash/_trimmedEndIndex.js ***!
  \*****************************************************/
/***/ ((module) => {

/** Used to match a single whitespace character. */
var reWhitespace = /\s/;

/**
 * Used by `_.trim` and `_.trimEnd` to get the index of the last non-whitespace
 * character of `string`.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {number} Returns the index of the last non-whitespace character.
 */
function trimmedEndIndex(string) {
  var index = string.length;

  while (index-- && reWhitespace.test(string.charAt(index))) {}
  return index;
}

module.exports = trimmedEndIndex;


/***/ }),

/***/ "../../node_modules/lodash/debounce.js":
/*!*********************************************!*\
  !*** ../../node_modules/lodash/debounce.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isObject = __webpack_require__(/*! ./isObject */ "../../node_modules/lodash/isObject.js"),
    now = __webpack_require__(/*! ./now */ "../../node_modules/lodash/now.js"),
    toNumber = __webpack_require__(/*! ./toNumber */ "../../node_modules/lodash/toNumber.js");

/** Error message constants. */
var FUNC_ERROR_TEXT = 'Expected a function';

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max,
    nativeMin = Math.min;

/**
 * Creates a debounced function that delays invoking `func` until after `wait`
 * milliseconds have elapsed since the last time the debounced function was
 * invoked. The debounced function comes with a `cancel` method to cancel
 * delayed `func` invocations and a `flush` method to immediately invoke them.
 * Provide `options` to indicate whether `func` should be invoked on the
 * leading and/or trailing edge of the `wait` timeout. The `func` is invoked
 * with the last arguments provided to the debounced function. Subsequent
 * calls to the debounced function return the result of the last `func`
 * invocation.
 *
 * **Note:** If `leading` and `trailing` options are `true`, `func` is
 * invoked on the trailing edge of the timeout only if the debounced function
 * is invoked more than once during the `wait` timeout.
 *
 * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred
 * until to the next tick, similar to `setTimeout` with a timeout of `0`.
 *
 * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)
 * for details over the differences between `_.debounce` and `_.throttle`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Function
 * @param {Function} func The function to debounce.
 * @param {number} [wait=0] The number of milliseconds to delay.
 * @param {Object} [options={}] The options object.
 * @param {boolean} [options.leading=false]
 *  Specify invoking on the leading edge of the timeout.
 * @param {number} [options.maxWait]
 *  The maximum time `func` is allowed to be delayed before it's invoked.
 * @param {boolean} [options.trailing=true]
 *  Specify invoking on the trailing edge of the timeout.
 * @returns {Function} Returns the new debounced function.
 * @example
 *
 * // Avoid costly calculations while the window size is in flux.
 * jQuery(window).on('resize', _.debounce(calculateLayout, 150));
 *
 * // Invoke `sendMail` when clicked, debouncing subsequent calls.
 * jQuery(element).on('click', _.debounce(sendMail, 300, {
 *   'leading': true,
 *   'trailing': false
 * }));
 *
 * // Ensure `batchLog` is invoked once after 1 second of debounced calls.
 * var debounced = _.debounce(batchLog, 250, { 'maxWait': 1000 });
 * var source = new EventSource('/stream');
 * jQuery(source).on('message', debounced);
 *
 * // Cancel the trailing debounced invocation.
 * jQuery(window).on('popstate', debounced.cancel);
 */
function debounce(func, wait, options) {
  var lastArgs,
      lastThis,
      maxWait,
      result,
      timerId,
      lastCallTime,
      lastInvokeTime = 0,
      leading = false,
      maxing = false,
      trailing = true;

  if (typeof func != 'function') {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  wait = toNumber(wait) || 0;
  if (isObject(options)) {
    leading = !!options.leading;
    maxing = 'maxWait' in options;
    maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait;
    trailing = 'trailing' in options ? !!options.trailing : trailing;
  }

  function invokeFunc(time) {
    var args = lastArgs,
        thisArg = lastThis;

    lastArgs = lastThis = undefined;
    lastInvokeTime = time;
    result = func.apply(thisArg, args);
    return result;
  }

  function leadingEdge(time) {
    // Reset any `maxWait` timer.
    lastInvokeTime = time;
    // Start the timer for the trailing edge.
    timerId = setTimeout(timerExpired, wait);
    // Invoke the leading edge.
    return leading ? invokeFunc(time) : result;
  }

  function remainingWait(time) {
    var timeSinceLastCall = time - lastCallTime,
        timeSinceLastInvoke = time - lastInvokeTime,
        timeWaiting = wait - timeSinceLastCall;

    return maxing
      ? nativeMin(timeWaiting, maxWait - timeSinceLastInvoke)
      : timeWaiting;
  }

  function shouldInvoke(time) {
    var timeSinceLastCall = time - lastCallTime,
        timeSinceLastInvoke = time - lastInvokeTime;

    // Either this is the first call, activity has stopped and we're at the
    // trailing edge, the system time has gone backwards and we're treating
    // it as the trailing edge, or we've hit the `maxWait` limit.
    return (lastCallTime === undefined || (timeSinceLastCall >= wait) ||
      (timeSinceLastCall < 0) || (maxing && timeSinceLastInvoke >= maxWait));
  }

  function timerExpired() {
    var time = now();
    if (shouldInvoke(time)) {
      return trailingEdge(time);
    }
    // Restart the timer.
    timerId = setTimeout(timerExpired, remainingWait(time));
  }

  function trailingEdge(time) {
    timerId = undefined;

    // Only invoke if we have `lastArgs` which means `func` has been
    // debounced at least once.
    if (trailing && lastArgs) {
      return invokeFunc(time);
    }
    lastArgs = lastThis = undefined;
    return result;
  }

  function cancel() {
    if (timerId !== undefined) {
      clearTimeout(timerId);
    }
    lastInvokeTime = 0;
    lastArgs = lastCallTime = lastThis = timerId = undefined;
  }

  function flush() {
    return timerId === undefined ? result : trailingEdge(now());
  }

  function debounced() {
    var time = now(),
        isInvoking = shouldInvoke(time);

    lastArgs = arguments;
    lastThis = this;
    lastCallTime = time;

    if (isInvoking) {
      if (timerId === undefined) {
        return leadingEdge(lastCallTime);
      }
      if (maxing) {
        // Handle invocations in a tight loop.
        clearTimeout(timerId);
        timerId = setTimeout(timerExpired, wait);
        return invokeFunc(lastCallTime);
      }
    }
    if (timerId === undefined) {
      timerId = setTimeout(timerExpired, wait);
    }
    return result;
  }
  debounced.cancel = cancel;
  debounced.flush = flush;
  return debounced;
}

module.exports = debounce;


/***/ }),

/***/ "../../node_modules/lodash/isObject.js":
/*!*********************************************!*\
  !*** ../../node_modules/lodash/isObject.js ***!
  \*********************************************/
/***/ ((module) => {

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

module.exports = isObject;


/***/ }),

/***/ "../../node_modules/lodash/isObjectLike.js":
/*!*************************************************!*\
  !*** ../../node_modules/lodash/isObjectLike.js ***!
  \*************************************************/
/***/ ((module) => {

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

module.exports = isObjectLike;


/***/ }),

/***/ "../../node_modules/lodash/isSymbol.js":
/*!*********************************************!*\
  !*** ../../node_modules/lodash/isSymbol.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(/*! ./_baseGetTag */ "../../node_modules/lodash/_baseGetTag.js"),
    isObjectLike = __webpack_require__(/*! ./isObjectLike */ "../../node_modules/lodash/isObjectLike.js");

/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike(value) && baseGetTag(value) == symbolTag);
}

module.exports = isSymbol;


/***/ }),

/***/ "../../node_modules/lodash/now.js":
/*!****************************************!*\
  !*** ../../node_modules/lodash/now.js ***!
  \****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var root = __webpack_require__(/*! ./_root */ "../../node_modules/lodash/_root.js");

/**
 * Gets the timestamp of the number of milliseconds that have elapsed since
 * the Unix epoch (1 January 1970 00:00:00 UTC).
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Date
 * @returns {number} Returns the timestamp.
 * @example
 *
 * _.defer(function(stamp) {
 *   console.log(_.now() - stamp);
 * }, _.now());
 * // => Logs the number of milliseconds it took for the deferred invocation.
 */
var now = function() {
  return root.Date.now();
};

module.exports = now;


/***/ }),

/***/ "../../node_modules/lodash/toNumber.js":
/*!*********************************************!*\
  !*** ../../node_modules/lodash/toNumber.js ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseTrim = __webpack_require__(/*! ./_baseTrim */ "../../node_modules/lodash/_baseTrim.js"),
    isObject = __webpack_require__(/*! ./isObject */ "../../node_modules/lodash/isObject.js"),
    isSymbol = __webpack_require__(/*! ./isSymbol */ "../../node_modules/lodash/isSymbol.js");

/** Used as references for various `Number` constants. */
var NAN = 0 / 0;

/** Used to detect bad signed hexadecimal string values. */
var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;

/** Used to detect binary string values. */
var reIsBinary = /^0b[01]+$/i;

/** Used to detect octal string values. */
var reIsOctal = /^0o[0-7]+$/i;

/** Built-in method references without a dependency on `root`. */
var freeParseInt = parseInt;

/**
 * Converts `value` to a number.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to process.
 * @returns {number} Returns the number.
 * @example
 *
 * _.toNumber(3.2);
 * // => 3.2
 *
 * _.toNumber(Number.MIN_VALUE);
 * // => 5e-324
 *
 * _.toNumber(Infinity);
 * // => Infinity
 *
 * _.toNumber('3.2');
 * // => 3.2
 */
function toNumber(value) {
  if (typeof value == 'number') {
    return value;
  }
  if (isSymbol(value)) {
    return NAN;
  }
  if (isObject(value)) {
    var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
    value = isObject(other) ? (other + '') : other;
  }
  if (typeof value != 'string') {
    return value === 0 ? value : +value;
  }
  value = baseTrim(value);
  var isBinary = reIsBinary.test(value);
  return (isBinary || reIsOctal.test(value))
    ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
    : (reIsBadHex.test(value) ? NAN : +value);
}

module.exports = toNumber;


/***/ }),

/***/ "../../node_modules/react-perfect-scrollbar/lib/index.js":
/*!***************************************************************!*\
  !*** ../../node_modules/react-perfect-scrollbar/lib/index.js ***!
  \***************************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));

var _scrollbar = __webpack_require__(/*! ./scrollbar */ "../../node_modules/react-perfect-scrollbar/lib/scrollbar.js");

var _scrollbar2 = _interopRequireDefault(_scrollbar);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports["default"] = _scrollbar2.default;
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/react-perfect-scrollbar/lib/scrollbar.js":
/*!*******************************************************************!*\
  !*** ../../node_modules/react-perfect-scrollbar/lib/scrollbar.js ***!
  \*******************************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = __webpack_require__(/*! react */ "../../node_modules/react/index.js");

var _react2 = _interopRequireDefault(_react);

var _propTypes = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");

var _perfectScrollbar = __webpack_require__(/*! perfect-scrollbar */ "../../node_modules/perfect-scrollbar/dist/perfect-scrollbar.esm.js");

var _perfectScrollbar2 = _interopRequireDefault(_perfectScrollbar);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var handlerNameByEvent = {
  'ps-scroll-y': 'onScrollY',
  'ps-scroll-x': 'onScrollX',
  'ps-scroll-up': 'onScrollUp',
  'ps-scroll-down': 'onScrollDown',
  'ps-scroll-left': 'onScrollLeft',
  'ps-scroll-right': 'onScrollRight',
  'ps-y-reach-start': 'onYReachStart',
  'ps-y-reach-end': 'onYReachEnd',
  'ps-x-reach-start': 'onXReachStart',
  'ps-x-reach-end': 'onXReachEnd'
};
Object.freeze(handlerNameByEvent);

var ScrollBar = function (_Component) {
  _inherits(ScrollBar, _Component);

  function ScrollBar(props) {
    _classCallCheck(this, ScrollBar);

    var _this = _possibleConstructorReturn(this, (ScrollBar.__proto__ || Object.getPrototypeOf(ScrollBar)).call(this, props));

    _this.handleRef = _this.handleRef.bind(_this);
    _this._handlerByEvent = {};
    return _this;
  }

  _createClass(ScrollBar, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      if (this.props.option) {
        console.warn('react-perfect-scrollbar: the "option" prop has been deprecated in favor of "options"');
      }

      this._ps = new _perfectScrollbar2.default(this._container, this.props.options || this.props.option);
      // hook up events
      this._updateEventHook();
      this._updateClassName();
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate(prevProps) {
      this._updateEventHook(prevProps);

      this.updateScroll();

      if (prevProps.className !== this.props.className) {
        this._updateClassName();
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      var _this2 = this;

      // unhook up evens
      Object.keys(this._handlerByEvent).forEach(function (key) {
        var value = _this2._handlerByEvent[key];

        if (value) {
          _this2._container.removeEventListener(key, value, false);
        }
      });
      this._handlerByEvent = {};
      this._ps.destroy();
      this._ps = null;
    }
  }, {
    key: '_updateEventHook',
    value: function _updateEventHook() {
      var _this3 = this;

      var prevProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      // hook up events
      Object.keys(handlerNameByEvent).forEach(function (key) {
        var callback = _this3.props[handlerNameByEvent[key]];
        var prevCallback = prevProps[handlerNameByEvent[key]];
        if (callback !== prevCallback) {
          if (prevCallback) {
            var prevHandler = _this3._handlerByEvent[key];
            _this3._container.removeEventListener(key, prevHandler, false);
            _this3._handlerByEvent[key] = null;
          }
          if (callback) {
            var handler = function handler() {
              return callback(_this3._container);
            };
            _this3._container.addEventListener(key, handler, false);
            _this3._handlerByEvent[key] = handler;
          }
        }
      });
    }
  }, {
    key: '_updateClassName',
    value: function _updateClassName() {
      var className = this.props.className;


      var psClassNames = this._container.className.split(' ').filter(function (name) {
        return name.match(/^ps([-_].+|)$/);
      }).join(' ');

      if (this._container) {
        this._container.className = 'scrollbar-container' + (className ? ' ' + className : '') + (psClassNames ? ' ' + psClassNames : '');
      }
    }
  }, {
    key: 'updateScroll',
    value: function updateScroll() {
      this.props.onSync(this._ps);
    }
  }, {
    key: 'handleRef',
    value: function handleRef(ref) {
      this._container = ref;
      this.props.containerRef(ref);
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          className = _props.className,
          style = _props.style,
          option = _props.option,
          options = _props.options,
          containerRef = _props.containerRef,
          onScrollY = _props.onScrollY,
          onScrollX = _props.onScrollX,
          onScrollUp = _props.onScrollUp,
          onScrollDown = _props.onScrollDown,
          onScrollLeft = _props.onScrollLeft,
          onScrollRight = _props.onScrollRight,
          onYReachStart = _props.onYReachStart,
          onYReachEnd = _props.onYReachEnd,
          onXReachStart = _props.onXReachStart,
          onXReachEnd = _props.onXReachEnd,
          component = _props.component,
          onSync = _props.onSync,
          children = _props.children,
          remainProps = _objectWithoutProperties(_props, ['className', 'style', 'option', 'options', 'containerRef', 'onScrollY', 'onScrollX', 'onScrollUp', 'onScrollDown', 'onScrollLeft', 'onScrollRight', 'onYReachStart', 'onYReachEnd', 'onXReachStart', 'onXReachEnd', 'component', 'onSync', 'children']);

      var Comp = component;

      return _react2.default.createElement(
        Comp,
        _extends({ style: style, ref: this.handleRef }, remainProps),
        children
      );
    }
  }]);

  return ScrollBar;
}(_react.Component);

exports["default"] = ScrollBar;


ScrollBar.defaultProps = {
  className: '',
  style: undefined,
  option: undefined,
  options: undefined,
  containerRef: function containerRef() {},
  onScrollY: undefined,
  onScrollX: undefined,
  onScrollUp: undefined,
  onScrollDown: undefined,
  onScrollLeft: undefined,
  onScrollRight: undefined,
  onYReachStart: undefined,
  onYReachEnd: undefined,
  onXReachStart: undefined,
  onXReachEnd: undefined,
  onSync: function onSync(ps) {
    return ps.update();
  },
  component: 'div'
};

ScrollBar.propTypes = {
  children: _propTypes.PropTypes.node.isRequired,
  className: _propTypes.PropTypes.string,
  style: _propTypes.PropTypes.object,
  option: _propTypes.PropTypes.object,
  options: _propTypes.PropTypes.object,
  containerRef: _propTypes.PropTypes.func,
  onScrollY: _propTypes.PropTypes.func,
  onScrollX: _propTypes.PropTypes.func,
  onScrollUp: _propTypes.PropTypes.func,
  onScrollDown: _propTypes.PropTypes.func,
  onScrollLeft: _propTypes.PropTypes.func,
  onScrollRight: _propTypes.PropTypes.func,
  onYReachStart: _propTypes.PropTypes.func,
  onYReachEnd: _propTypes.PropTypes.func,
  onXReachStart: _propTypes.PropTypes.func,
  onXReachEnd: _propTypes.PropTypes.func,
  onSync: _propTypes.PropTypes.func,
  component: _propTypes.PropTypes.string
};
module.exports = exports['default'];

/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_notebook_lib_browser_service_notebook-model-resolver-service_js-no-a94865.js.map