"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var time_graph_performance_test_1 = require("../unitTest/time-graph-performance-test");
var settings_1 = require("../unitTest/data/longRemoval/settings");
describe('TImeGraphChart performance test with long states removal', function () {
    var timeGraph;
    beforeEach(function () {
        // Initiating the test
        timeGraph = new time_graph_performance_test_1.TimeGraphPerformanceTest(settings_1.LongRemovalTestData.data, settings_1.LongRemovalTestData.viewRange);
        timeGraph.toNextDataSet();
        timeGraph.setViewRange(settings_1.LongRemovalTestData.zoomRange.start, settings_1.LongRemovalTestData.zoomRange.end);
    });
    it('addOrUpdateRow() test with long removal time', function () {
        var data = timeGraph.getData();
        var timeGraphChart = timeGraph.getTimeGraphChart();
        var start = performance.now();
        // @ts-ignore
        timeGraphChart.addOrUpdateRows(data);
        var end = performance.now();
        var time = end - start;
        console.log("addOrUpdateRow() - with long removal time", time, "ms");
        expect(time).toBeGreaterThan(0);
    });
});
//# sourceMappingURL=time-graph-chart-long-removal-test.js.map