"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bindTraceServerPreferences = void 0;
const browser_1 = require("@theia/core/lib/browser");
const trace_server_preference_1 = require("./trace-server-preference");
function bindTraceServerPreferences(bind) {
    bind(trace_server_preference_1.TracePreferences)
        .toDynamicValue(ctx => {
        const preferences = ctx.container.get(browser_1.PreferenceService);
        return (0, browser_1.createPreferenceProxy)(preferences, trace_server_preference_1.ServerSchema);
    })
        .inSingletonScope();
    bind(browser_1.PreferenceContribution).toConstantValue({
        schema: trace_server_preference_1.ServerSchema
    });
}
exports.bindTraceServerPreferences = bindTraceServerPreferences;
//# sourceMappingURL=trace-server-bindings.js.map