"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var temp = require("temp");
var path = require("path");
var os = require("os");
var fs = require("fs-extra");
var chai_1 = require("chai");
var status_1 = require("./status");
var status_2 = require("../model/status");
var test_helper_1 = require("./test-helper");
var clone_1 = require("./clone");
var track = temp.track();
describe('status', function () { return __awaiter(void 0, void 0, void 0, function () {
    var repositoryWithChanges;
    return __generator(this, function (_a) {
        repositoryWithChanges = path.join(os.homedir(), '.git');
        before(function () {
            return __awaiter(this, void 0, void 0, function () {
                var tmpPath;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            this.timeout(80000);
                            if (fs.existsSync(repositoryWithChanges)) {
                                fs.removeSync(repositoryWithChanges);
                            }
                            return [4 /*yield*/, (0, clone_1.clone)('https://github.com/eclipse/xtext-core.git', repositoryWithChanges)];
                        case 1:
                            _a.sent();
                            tmpPath = path.join(repositoryWithChanges, 'tmp');
                            fs.mkdirpSync(tmpPath);
                            fs.readdirSync(repositoryWithChanges).forEach(function (fileName) {
                                if (fileName.startsWith('org.eclipse.xtext')) {
                                    fs.moveSync(path.join(repositoryWithChanges, fileName), path.join(tmpPath, fileName));
                                }
                            });
                            return [2 /*return*/];
                    }
                });
            });
        });
        after(function () { return __awaiter(void 0, void 0, void 0, function () {
            return __generator(this, function (_a) {
                track.cleanupSync();
                fs.removeSync(repositoryWithChanges);
                return [2 /*return*/];
            });
        }); });
        it('missing', function () { return __awaiter(void 0, void 0, void 0, function () {
            var error_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, (0, status_1.getStatus)('/does/not/exist')];
                    case 1:
                        _a.sent();
                        throw new Error('Expected error when getting status from a non-existing repository.');
                    case 2:
                        error_1 = _a.sent();
                        (0, chai_1.expect)(error_1.message).to.be.equal('Unable to find path to repository on disk.');
                        return [3 /*break*/, 3];
                    case 3: return [2 /*return*/];
                }
            });
        }); });
        it('empty', function () { return __awaiter(void 0, void 0, void 0, function () {
            var repositoryPath, status;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, (0, test_helper_1.createTestRepository)(track.mkdirSync())];
                    case 1:
                        repositoryPath = _a.sent();
                        return [4 /*yield*/, (0, status_1.getStatus)(repositoryPath)];
                    case 2:
                        status = _a.sent();
                        (0, chai_1.expect)(status.workingDirectory.files).to.be.empty;
                        return [2 /*return*/];
                }
            });
        }); });
        it('new', function () { return __awaiter(void 0, void 0, void 0, function () {
            var repositoryPath, filePaths, status, files;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, (0, test_helper_1.createTestRepository)(track.mkdirSync())];
                    case 1:
                        repositoryPath = _a.sent();
                        filePaths = (0, test_helper_1.add)(repositoryPath, { path: 'X.txt' });
                        return [4 /*yield*/, (0, status_1.getStatus)(repositoryPath)];
                    case 2:
                        status = _a.sent();
                        files = status.workingDirectory.files;
                        (0, chai_1.expect)(files).to.have.lengthOf(1);
                        (0, chai_1.expect)(files[0].path).to.be.equal(path.relative(repositoryPath, filePaths[0]));
                        (0, chai_1.expect)(files[0].status).to.be.equal(status_2.FileStatus.New);
                        return [2 /*return*/];
                }
            });
        }); });
        it('deleted', function () { return __awaiter(void 0, void 0, void 0, function () {
            var repositoryPath, filePaths, status, files;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, (0, test_helper_1.createTestRepository)(track.mkdirSync())];
                    case 1:
                        repositoryPath = _a.sent();
                        filePaths = (0, test_helper_1.remove)(repositoryPath, 'A.txt');
                        return [4 /*yield*/, (0, status_1.getStatus)(repositoryPath)];
                    case 2:
                        status = _a.sent();
                        files = status.workingDirectory.files;
                        (0, chai_1.expect)(files).to.have.lengthOf(1);
                        (0, chai_1.expect)(files[0].path).to.be.equal(path.relative(repositoryPath, filePaths[0]));
                        (0, chai_1.expect)(files[0].status).to.be.equal(status_2.FileStatus.Deleted);
                        return [2 /*return*/];
                }
            });
        }); });
        it('modified', function () { return __awaiter(void 0, void 0, void 0, function () {
            var repositoryPath, filePaths, status, files;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, (0, test_helper_1.createTestRepository)(track.mkdirSync())];
                    case 1:
                        repositoryPath = _a.sent();
                        filePaths = (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: 'content' });
                        return [4 /*yield*/, (0, status_1.getStatus)(repositoryPath)];
                    case 2:
                        status = _a.sent();
                        files = status.workingDirectory.files;
                        (0, chai_1.expect)(files).to.have.lengthOf(1);
                        (0, chai_1.expect)(files[0].path).to.be.equal(path.relative(repositoryPath, filePaths[0]));
                        (0, chai_1.expect)(files[0].status).to.be.equal(status_2.FileStatus.Modified);
                        return [2 /*return*/];
                }
            });
        }); });
        it('in repository with changes', function () {
            return __awaiter(this, void 0, void 0, function () {
                var status;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            this.timeout(1000);
                            return [4 /*yield*/, (0, status_1.getStatus)(repositoryWithChanges)];
                        case 1:
                            status = _a.sent();
                            (0, chai_1.expect)(status.workingDirectory.files.length > 10000);
                            (0, chai_1.expect)(!!status.incomplete).to.be.false;
                            return [2 /*return*/];
                    }
                });
            });
        });
        it('limit changes', function () {
            return __awaiter(this, void 0, void 0, function () {
                var status;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            this.timeout(1000);
                            return [4 /*yield*/, (0, status_1.getStatus)(repositoryWithChanges, false, 500)];
                        case 1:
                            status = _a.sent();
                            (0, chai_1.expect)(status.workingDirectory.files.length === 500);
                            (0, chai_1.expect)(status.incomplete).to.be.true;
                            return [2 /*return*/];
                    }
                });
            });
        });
        return [2 /*return*/];
    });
}); });
//# sourceMappingURL=status.spec.js.map