/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

import { KeyCode } from '../../../../base/common/keyCodes';
import { EditorCommand, registerEditorAction, registerEditorCommand, registerEditorContribution } from '../../../browser/editorExtensions';
import { EditorContextKeys } from '../../../common/editorContextKeys';
import { HoverParticipantRegistry } from '../../hover/browser/hoverTypes';
import { inlineSuggestCommitId } from './consts';
import { GhostTextController, ShowNextInlineSuggestionAction, ShowPreviousInlineSuggestionAction, TriggerInlineSuggestionAction } from './ghostTextController';
import { InlineCompletionsHoverParticipant } from './ghostTextHoverParticipant';
import { ContextKeyExpr } from '../../../../platform/contextkey/common/contextkey';
import { KeybindingsRegistry } from '../../../../platform/keybinding/common/keybindingsRegistry';

registerEditorContribution(GhostTextController.ID, GhostTextController);
registerEditorAction(TriggerInlineSuggestionAction);
registerEditorAction(ShowNextInlineSuggestionAction);
registerEditorAction(ShowPreviousInlineSuggestionAction);
HoverParticipantRegistry.register(InlineCompletionsHoverParticipant);

const GhostTextCommand = EditorCommand.bindToContribution(GhostTextController.get);

export const commitInlineSuggestionAction = new GhostTextCommand({
	id: inlineSuggestCommitId,
	precondition: GhostTextController.inlineSuggestionVisible,
	handler(x) {
		x.commit();
		x.editor.focus();
	}
});
registerEditorCommand(commitInlineSuggestionAction);

KeybindingsRegistry.registerKeybindingRule({
	primary: KeyCode.Tab,
	weight: 200,
	id: commitInlineSuggestionAction.id,
	when: ContextKeyExpr.and(
		commitInlineSuggestionAction.precondition,
		EditorContextKeys.tabMovesFocus.toNegated(),
		GhostTextController.inlineSuggestionHasIndentationLessThanTabSize
	),
});

registerEditorCommand(new GhostTextCommand({
	id: 'editor.action.inlineSuggest.hide',
	precondition: GhostTextController.inlineSuggestionVisible,
	kbOpts: {
		weight: 100,
		primary: KeyCode.Escape,
	},
	handler(x) {
		x.hide();
	}
}));
