"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkerBasedDocumentDiffProvider = void 0;
const linesDiffComputer_1 = require("../../common/diff/linesDiffComputer");
const range_1 = require("../../common/core/range");
const editorWorker_1 = require("../../common/services/editorWorker");
let WorkerBasedDocumentDiffProvider = class WorkerBasedDocumentDiffProvider {
    constructor(editorWorkerService) {
        this.editorWorkerService = editorWorkerService;
    }
    computeDiff(original, modified, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const result = yield this.editorWorkerService.computeDiff(original.uri, modified.uri, options);
            if (!result) {
                throw new Error('no diff result available');
            }
            // Convert from space efficient JSON data to rich objects.
            const diff = {
                identical: result.identical,
                quitEarly: result.quitEarly,
                changes: result.changes.map((c) => {
                    var _a;
                    return new linesDiffComputer_1.LineRangeMapping(new linesDiffComputer_1.LineRange(c[0], c[1]), new linesDiffComputer_1.LineRange(c[2], c[3]), (_a = c[4]) === null || _a === void 0 ? void 0 : _a.map((c) => new linesDiffComputer_1.RangeMapping(new range_1.Range(c[0], c[1], c[2], c[3]), new range_1.Range(c[4], c[5], c[6], c[7]))));
                }),
            };
            return diff;
        });
    }
};
WorkerBasedDocumentDiffProvider = __decorate([
    __param(0, editorWorker_1.IEditorWorkerService)
], WorkerBasedDocumentDiffProvider);
exports.WorkerBasedDocumentDiffProvider = WorkerBasedDocumentDiffProvider;
//# sourceMappingURL=workerBasedDocumentDiffProvider.js.map