"use strict";
// *****************************************************************************
// Copyright (C) 2020 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElectronTokenValidator = void 0;
const cookie = require("cookie");
const crypto = require("crypto");
const inversify_1 = require("inversify");
const common_1 = require("../../common");
const electron_token_1 = require("../../electron-common/electron-token");
/**
 * On Electron, we want to make sure that only Electron's browser-windows access the backend services.
 */
let ElectronTokenValidator = class ElectronTokenValidator {
    postConstruct() {
        this.electronSecurityToken = this.getToken();
    }
    allowWsUpgrade(request) {
        return this.allowRequest(request);
    }
    /**
     * Expects the token to be passed via cookies by default.
     */
    allowRequest(request) {
        const cookieHeader = request.headers.cookie;
        if ((0, common_1.isString)(cookieHeader)) {
            const token = cookie.parse(cookieHeader)[electron_token_1.ElectronSecurityToken];
            if ((0, common_1.isString)(token)) {
                return this.isTokenValid(JSON.parse(token));
            }
        }
        return false;
    }
    /**
     * Validates a token.
     *
     * This method both checks the shape of the parsed token data and its actual value.
     *
     * @param token Parsed object sent by the client as the token.
     */
    isTokenValid(token) {
        if ((0, common_1.isObject)(token) && (0, common_1.isString)(token.value)) {
            try {
                const received = Buffer.from(token.value, 'utf8');
                const expected = Buffer.from(this.electronSecurityToken.value, 'utf8');
                return received.byteLength === expected.byteLength && crypto.timingSafeEqual(received, expected);
            }
            catch (error) {
                console.error(error);
            }
        }
        return false;
    }
    /**
     * Returns the token to compare to when authorizing requests.
     */
    getToken() {
        return JSON.parse(process.env[electron_token_1.ElectronSecurityToken]);
    }
};
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], ElectronTokenValidator.prototype, "postConstruct", null);
ElectronTokenValidator = __decorate([
    (0, inversify_1.injectable)()
], ElectronTokenValidator);
exports.ElectronTokenValidator = ElectronTokenValidator;
//# sourceMappingURL=electron-token-validator.js.map