"use strict";
/********************************************************************************
 * Copyright (C) 2023 STMicroelectronics and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CdtCloudBlueprintExamplesContribution = void 0;
const core_1 = require("@theia/core");
const inversify_1 = require("@theia/core/shared/inversify");
const common_1 = require("@theia/task/lib/common");
const cdt_blueprint_examples_1 = require("../common/cdt-blueprint-examples");
let CdtCloudBlueprintExamplesContribution = class CdtCloudBlueprintExamplesContribution {
    get examples() {
        return [{
                id: cdt_blueprint_examples_1.CdtCloudBlueprintExamples.CMAKE_EXAMPLE,
                label: 'CMake example',
                welcomeFile: 'CMAKE_EXAMPLE_README.md',
                resourcesPath: new core_1.URI(module.path).resolve('../../resources/cmake-example').normalizePath().toString(),
                launches: (options) => [{
                        'type': 'gdb',
                        'request': 'launch',
                        'name': `Debug Example C++ (${options.targetFolderName})`,
                        'program': `\${workspaceFolder}/${options.targetFolderName}/Example`,
                        'initCommands': ['tbreak main'],
                        'preLaunchTask': `Binary build (${options.targetFolderName})`
                    }],
                tasks: (options) => [{
                        'label': `Binary build (${options.targetFolderName})`,
                        'type': 'shell',
                        'command': 'cmake . && make',
                        'group': {
                            'kind': 'build',
                            'isDefault': true
                        },
                        'options': {
                            'cwd': `\${workspaceFolder}/${options.targetFolderName}`
                        },
                        'problemMatcher': []
                    },
                    {
                        'label': `Launch Example C++ (${options.targetFolderName})`,
                        'type': 'shell',
                        'command': './Example',
                        'dependsOn': [`Binary build (${options.targetFolderName})`],
                        'presentation': {
                            'echo': true,
                            'reveal': common_1.RevealKind.Always,
                            'focus': true,
                            'panel': common_1.PanelKind.Shared,
                            'showReuseMessage': false,
                            'clear': true
                        },
                        'options': {
                            'cwd': `\${workspaceFolder}/${options.targetFolderName}`
                        },
                        'problemMatcher': []
                    }]
            },
            {
                id: cdt_blueprint_examples_1.CdtCloudBlueprintExamples.EXAMPLE_TRACES,
                label: 'Example traces',
                welcomeFile: 'EXAMPLE_TRACES_README.md',
                resourcesPath: new core_1.URI(module.path).resolve('../../resources/example-traces').normalizePath().toString()
            },
            {
                id: cdt_blueprint_examples_1.CdtCloudBlueprintExamples.CLANGD_CONTEXTS,
                label: 'Clangd contexts',
                welcomeFile: 'CLANGD_CONTEXTS_README.md',
                resourcesPath: new core_1.URI(module.path).resolve('../../resources/clangd-contexts').normalizePath().toString()
            }];
    }
};
CdtCloudBlueprintExamplesContribution = __decorate([
    (0, inversify_1.injectable)()
], CdtCloudBlueprintExamplesContribution);
exports.CdtCloudBlueprintExamplesContribution = CdtCloudBlueprintExamplesContribution;
//# sourceMappingURL=blueprint-examples-contribution.js.map