"use strict";
/********************************************************************************
 * Copyright (C) 2022 STMicroelectronics and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExampleGeneratorServiceImpl = void 0;
const core_1 = require("@theia/core");
const uri_1 = require("@theia/core/lib/common/uri");
const file_uri_1 = require("@theia/core/lib/node/file-uri");
const inversify_1 = require("@theia/core/shared/inversify");
const fs = require("fs-extra");
const protocol_1 = require("../common/protocol");
let ExampleGeneratorServiceImpl = class ExampleGeneratorServiceImpl {
    async getExamples() {
        const contributions = this.examplesProvider.getContributions();
        return contributions.flatMap(contribution => contribution.examples);
    }
    async generateExample(example, target, folderName) {
        var _a;
        const resolvedExample = (_a = (await this.getExamples()).find(e => e.id === example.id)) !== null && _a !== void 0 ? _a : example;
        const exampleUri = new uri_1.default(resolvedExample.resourcesPath);
        const examplePath = file_uri_1.FileUri.fsPath(exampleUri);
        if (!examplePath || !fs.existsSync(examplePath)) {
            throw new Error(`Could not find resources of example in ${examplePath}`);
        }
        const targetUri = new uri_1.default(target);
        this.copyFiles(targetUri, examplePath);
        if (resolvedExample.tasks || resolvedExample.launches) {
            const workspaceRoot = folderName ? targetUri.parent : targetUri;
            const configFolder = file_uri_1.FileUri.fsPath(workspaceRoot.resolve('.theia'));
            fs.ensureDirSync(configFolder);
            this.createOrAmendTasksJson(resolvedExample, workspaceRoot, folderName);
            this.createOrAmendLaunchJson(resolvedExample, workspaceRoot, folderName);
        }
    }
    copyFiles(targetUri, examplePath) {
        const targetPath = file_uri_1.FileUri.fsPath(targetUri);
        fs.copySync(examplePath, targetPath, { recursive: true, errorOnExist: true });
    }
    createOrAmendTasksJson(example, workspaceRoot, targetFolderName) {
        if (example.tasks) {
            const tasksJsonPath = file_uri_1.FileUri.fsPath(workspaceRoot.resolve('.theia/tasks.json'));
            if (!fs.existsSync(tasksJsonPath)) {
                fs.writeFileSync(tasksJsonPath, `{
                    "version": "2.0.0",
                    "tasks": []
                }`);
            }
            const tasksJson = JSON.parse(fs.readFileSync(tasksJsonPath).toString());
            const existingTaskConfigurations = tasksJson['tasks'];
            const targetFolder = file_uri_1.FileUri.fsPath(workspaceRoot.resolve(targetFolderName));
            const newTasks = example.tasks({ targetFolderName, targetFolder });
            tasksJson['tasks'] = [...existingTaskConfigurations, ...newTasks];
            fs.writeFileSync(tasksJsonPath, JSON.stringify(tasksJson, undefined, 2));
        }
    }
    createOrAmendLaunchJson(example, workspaceRoot, targetFolderName) {
        if (example.launches) {
            const launchJsonPath = file_uri_1.FileUri.fsPath(workspaceRoot.resolve('.theia/launch.json'));
            if (!fs.existsSync(launchJsonPath)) {
                fs.writeFileSync(launchJsonPath, `{
                    "version": "2.0.0",
                    "configurations": []
                }`);
            }
            const launchJson = JSON.parse(fs.readFileSync(launchJsonPath).toString());
            const existingLaunchConfigurations = launchJson['configurations'];
            const targetFolder = file_uri_1.FileUri.fsPath(workspaceRoot.resolve(targetFolderName));
            const newLaunchConfigs = example.launches({ targetFolderName, targetFolder });
            launchJson['configurations'] = [...existingLaunchConfigurations, ...newLaunchConfigs];
            fs.writeFileSync(launchJsonPath, JSON.stringify(launchJson, undefined, 2));
        }
    }
};
__decorate([
    (0, inversify_1.inject)(core_1.ContributionProvider),
    (0, inversify_1.named)(protocol_1.ExamplesContribution),
    __metadata("design:type", Object)
], ExampleGeneratorServiceImpl.prototype, "examplesProvider", void 0);
ExampleGeneratorServiceImpl = __decorate([
    (0, inversify_1.injectable)()
], ExampleGeneratorServiceImpl);
exports.ExampleGeneratorServiceImpl = ExampleGeneratorServiceImpl;
//# sourceMappingURL=example-generator-service.js.map