"use strict";
/********************************************************************************
 * Copyright (C) 2022 STMicroelectronics and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@theia/core");
const inversify_1 = require("@theia/core/shared/inversify");
const protocol_1 = require("../common/protocol");
const example_generator_service_1 = require("./example-generator-service");
exports.default = new inversify_1.ContainerModule((bind, unbind, isBound, rebind) => {
    (0, core_1.bindContributionProvider)(bind, protocol_1.ExamplesContribution);
    bind(protocol_1.ExampleGeneratorService).to(example_generator_service_1.ExampleGeneratorServiceImpl).inSingletonScope();
    bind(core_1.ConnectionHandler).toDynamicValue(ctx => new core_1.JsonRpcConnectionHandler(protocol_1.EXAMPLE_GENERATOR_PATH, () => ctx.container.get(protocol_1.ExampleGeneratorService))).inSingletonScope();
});
//# sourceMappingURL=example-generator-backend-module.js.map