/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.jarpackager;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;

public class JarPackageUtil {
    private static final int INTERNAL_ERROR = 10001;

    private static void addEntry(JarEntry entry, InputStream content, JarOutputStream fjarOutputStream) throws IOException {
        byte[] readBuffer = new byte[4096];
        try {
            int count;
            fjarOutputStream.putNextEntry(entry);
            while ((count = content.read(readBuffer, 0, readBuffer.length)) != -1) {
                fjarOutputStream.write(readBuffer, 0, count);
            }
        }
        finally {
            if (content != null) {
                content.close();
            }
        }
    }

    public static MultiStatus writeArchive(ZipFile zipFile, boolean areDirectoryEntriesIncluded, boolean isCompressed, JarOutputStream fjarOutputStream, Set<String> fdirectories, IProgressMonitor progressMonitor) {
        MultiStatus fstatus = new MultiStatus("org.eclipse.jdtls.ext.core", 0, "");
        Enumeration<? extends ZipEntry> jarEntriesEnum = zipFile.entries();
        File zipFile1 = new File(zipFile.getName());
        try {
            String zipFileCanonical = zipFile1.getCanonicalPath();
            while (jarEntriesEnum.hasMoreElements()) {
                ZipEntry zipEntry = jarEntriesEnum.nextElement();
                if (!zipEntry.isDirectory()) {
                    String entryName = zipEntry.getName();
                    File zipEntryFile = new File(zipFile1, entryName);
                    String zipEntryCanonical = zipEntryFile.getCanonicalPath();
                    if (zipEntryCanonical.startsWith(String.valueOf(zipFileCanonical) + File.separator)) {
                        JarPackageUtil.addFile(entryName, zipEntry, zipFile, areDirectoryEntriesIncluded, isCompressed, fjarOutputStream, fdirectories, fstatus);
                    } else {
                        JarPackageUtil.addWarning("Invalid path" + entryName, null, fstatus);
                    }
                }
                progressMonitor.worked(1);
                if (!progressMonitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
        }
        catch (IOException e) {
            JarPackageUtil.addWarning("ZipFile error" + zipFile.getName(), null, fstatus);
            e.printStackTrace();
        }
        return fstatus;
    }

    private static void addFile(String destinationPath, ZipEntry jarEntry, ZipFile zipFile, boolean areDirectoryEntriesIncluded, boolean isCompressed, JarOutputStream fjarOutputStream, Set<String> fdirectories, MultiStatus fstatus) {
        block3: {
            if (destinationPath.equalsIgnoreCase("META-INF/MANIFEST.MF") || destinationPath.startsWith("META-INF/") && destinationPath.endsWith(".SF")) {
                return;
            }
            try {
                JarPackageUtil.addZipEntry(jarEntry, zipFile, destinationPath, areDirectoryEntriesIncluded, isCompressed, fjarOutputStream, fdirectories);
            }
            catch (IOException ex) {
                if (!(ex instanceof ZipException) || ex.getMessage() == null || !ex.getMessage().startsWith("duplicate entry:") || destinationPath.startsWith("META-INF/")) break block3;
                JarPackageUtil.addWarning(ex.getMessage(), ex, fstatus);
            }
        }
    }

    private static void addFile(File file, IPath path, boolean areDirectoryEntriesIncluded, boolean isCompressed, JarOutputStream fjarOutputStream, Set<String> fdirectories) throws IOException {
        if (areDirectoryEntriesIncluded) {
            JarPackageUtil.addDirectories(path, fjarOutputStream, fdirectories);
        }
        JarEntry newEntry = new JarEntry(path.toString().replace(File.separatorChar, '/'));
        if (isCompressed) {
            newEntry.setMethod(8);
        } else {
            newEntry.setMethod(0);
            JarPackageUtil.calculateCrcAndSize(newEntry, new FileInputStream(file), new byte[4096]);
        }
        newEntry.setTime(file.lastModified());
        JarPackageUtil.addEntry(newEntry, new FileInputStream(file), fjarOutputStream);
    }

    private static void addZipEntry(ZipEntry zipEntry, ZipFile zipFile, String path, boolean areDirectoryEntriesIncluded, boolean isCompressed, JarOutputStream fjarOutputStream, Set<String> fdirectories) throws IOException {
        if (areDirectoryEntriesIncluded) {
            JarPackageUtil.addDirectories(path, fjarOutputStream, fdirectories);
        }
        JarEntry newEntry = new JarEntry(path.replace(File.separatorChar, '/'));
        if (isCompressed) {
            newEntry.setMethod(8);
        } else {
            newEntry.setMethod(0);
            newEntry.setSize(zipEntry.getSize());
            newEntry.setCrc(zipEntry.getCrc());
        }
        long lastModified = System.currentTimeMillis();
        newEntry.setTime(lastModified);
        JarPackageUtil.addEntry(newEntry, zipFile.getInputStream(zipEntry), fjarOutputStream);
    }

    private static void addDirectories(String destPath, JarOutputStream fjarOutputStream, Set<String> fdirectories) throws IOException {
        String path = destPath.replace(File.separatorChar, '/');
        int lastSlash = path.lastIndexOf(47);
        ArrayList<JarEntry> directories = new ArrayList<JarEntry>(2);
        while (lastSlash != -1) {
            if (!fdirectories.add(path = path.substring(0, lastSlash + 1))) break;
            JarEntry newEntry = new JarEntry(path);
            newEntry.setMethod(0);
            newEntry.setSize(0L);
            newEntry.setCrc(0L);
            newEntry.setTime(System.currentTimeMillis());
            directories.add(newEntry);
            lastSlash = path.lastIndexOf(47, lastSlash - 1);
        }
        int i = directories.size() - 1;
        while (i >= 0) {
            fjarOutputStream.putNextEntry((ZipEntry)directories.get(i));
            --i;
        }
    }

    private static void addDirectories(IPath destinationPath, JarOutputStream fjarOutputStream, Set<String> fdirectories) throws IOException {
        JarPackageUtil.addDirectories(destinationPath.toString(), fjarOutputStream, fdirectories);
    }

    public static void writeFile(File file, IPath destinationPath, boolean areDirectoryEntriesIncluded, boolean isCompressed, JarOutputStream fjarOutputStream, Set<String> fdirectories) throws CoreException {
        try {
            JarPackageUtil.addFile(file, destinationPath, areDirectoryEntriesIncluded, isCompressed, fjarOutputStream, fdirectories);
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdtls.ext.core", 10001, ex.getLocalizedMessage(), (Throwable)ex));
        }
    }

    private static void calculateCrcAndSize(ZipEntry entry, InputStream stream, byte[] buffer) throws IOException {
        int size = 0;
        CRC32 crc = new CRC32();
        try {
            int count;
            while ((count = stream.read(buffer, 0, buffer.length)) != -1) {
                crc.update(buffer, 0, count);
                size += count;
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        entry.setSize(size);
        entry.setCrc(crc.getValue());
    }

    private static final void addWarning(String message, Throwable error, MultiStatus fstatus) {
        fstatus.add((IStatus)new Status(2, "org.eclipse.jdtls.ext.core", 10001, message, error));
    }
}

