/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.regex.Pattern;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;

public class InlayHintFilter {
    private MethodPattern pattern;
    private boolean isCaseSensitive;
    private int matchMode;
    private boolean requireResolveBinding;

    public InlayHintFilter(String methodPattern) {
        if (((String)methodPattern).startsWith("(")) {
            methodPattern = "*" + (String)methodPattern;
        }
        this.pattern = (MethodPattern)SearchPattern.createPattern((String)methodPattern, (int)1, (int)0, (int)10);
        if (this.pattern != null) {
            int matchRule = this.pattern.getMatchRule();
            this.matchMode = matchRule & 0x187;
            this.requireResolveBinding = InlayHintFilter.requireResolveBinding(this.pattern);
        }
        this.isCaseSensitive = true;
    }

    boolean isRequireResolveBinding() {
        return this.requireResolveBinding;
    }

    private static boolean requireResolveBinding(MethodPattern pattern) {
        if (pattern.declaringQualification != null) {
            return true;
        }
        if (pattern.parameterCount <= 0) {
            return false;
        }
        char[][] cArray = pattern.parameterSimpleNames;
        int n = pattern.parameterSimpleNames.length;
        int n2 = 0;
        while (n2 < n) {
            char[] c = cArray[n2];
            if (c != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isValid() {
        return this.pattern != null;
    }

    private boolean match(String name, int argsLength) {
        int length;
        if (!this.matchesName(this.pattern.selector, name.toCharArray())) {
            return false;
        }
        return this.pattern.parameterSimpleNames == null || (length = this.pattern.parameterSimpleNames.length) == argsLength;
    }

    protected boolean matchesName(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name == null) {
            return false;
        }
        return this.matchNameValue(pattern, name);
    }

    protected boolean matchNameValue(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name == null) {
            return false;
        }
        if (name.length == 0) {
            return pattern.length == 0;
        }
        if (pattern.length == 0) {
            return false;
        }
        boolean matchFirstChar = !this.isCaseSensitive || pattern[0] == name[0];
        boolean sameLength = pattern.length == name.length;
        boolean canBePrefix = name.length >= pattern.length;
        switch (this.matchMode) {
            case 0: {
                if (!sameLength || !matchFirstChar || !CharOperation.equals((char[])pattern, (char[])name, (boolean)this.isCaseSensitive)) break;
                return true;
            }
            case 1: {
                if (!canBePrefix || !matchFirstChar || !CharOperation.prefixEquals((char[])pattern, (char[])name, (boolean)this.isCaseSensitive)) break;
                return true;
            }
            case 2: {
                if (!this.isCaseSensitive) {
                    pattern = CharOperation.toLowerCase((char[])pattern);
                }
                if (!CharOperation.match((char[])pattern, (char[])name, (boolean)this.isCaseSensitive)) break;
                return true;
            }
            case 4: {
                if (!Pattern.matches(new String(pattern), new String(name))) break;
                return true;
            }
            case 128: {
                if (CharOperation.camelCaseMatch((char[])pattern, (char[])name, (boolean)false)) {
                    return true;
                }
                if (this.isCaseSensitive || !CharOperation.prefixEquals((char[])pattern, (char[])name, (boolean)false)) break;
                return true;
            }
            case 256: {
                if (!CharOperation.camelCaseMatch((char[])pattern, (char[])name, (boolean)true)) break;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean match(IMethod method) {
        if (method == null) {
            return false;
        }
        try {
            int argsLength = method.getParameters().length;
            if (this.pattern.declaringQualification != null && !this.matchesName(this.pattern.declaringQualification, method.getDeclaringType().getPackageFragment().getElementName().toCharArray())) {
                return false;
            }
            if (this.pattern.declaringSimpleName != null && !this.matchesName(this.pattern.declaringSimpleName, method.getDeclaringType().getTypeQualifiedName().toCharArray())) {
                return false;
            }
            if (!this.match(method.getElementName(), argsLength)) {
                return false;
            }
            if (this.pattern.parameterSimpleNames != null) {
                String[] parameterNames;
                String[] stringArray = parameterNames = method.getParameterNames();
                int n = parameterNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String parameterName = stringArray[n2];
                    if (!this.matchParam(argsLength, parameterName)) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    private boolean matchParam(int argsLength, String parameterName) {
        int i = 0;
        while (i < argsLength) {
            if (this.matchesName(this.pattern.parameterSimpleNames[i], parameterName.toCharArray())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

