/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.surround;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Pattern;
import org.eclipse.jdt.core.dom.PatternInstanceofExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypePattern;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.surround.ExceptionAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.SurroundWithAnalyzer;

public class SurroundWithTryCatchAnalyzer
extends SurroundWithAnalyzer {
    private ITypeBinding[] fExceptions;

    public SurroundWithTryCatchAnalyzer(ICompilationUnit unit, Selection selection) throws CoreException {
        super(unit, selection, true);
    }

    public ITypeBinding[] getExceptions() {
        return this.fExceptions;
    }

    @Override
    public void endVisit(CompilationUnit node) {
        ASTNode enclosingNode = null;
        if (!this.getStatus().hasFatalError() && this.hasSelectedNodes()) {
            enclosingNode = SurroundWithAnalyzer.getEnclosingNode(this.getFirstSelectedNode());
        }
        super.endVisit(node);
        if (enclosingNode != null && !this.getStatus().hasFatalError()) {
            this.fExceptions = ExceptionAnalyzer.perform(enclosingNode, this.getSelection(), false);
            if (this.fExceptions == null || this.fExceptions.length == 0) {
                if (enclosingNode instanceof MethodReference) {
                    this.invalidSelection(RefactoringCoreMessages.SurroundWithTryCatchAnalyzer_doesNotContain);
                } else {
                    this.fExceptions = new ITypeBinding[]{node.getAST().resolveWellKnownType("java.lang.Exception")};
                }
            }
        }
    }

    public Map<SimpleName, IVariableBinding> getVariableStatementBinding(ASTNode astNode) {
        final HashMap<SimpleName, IVariableBinding> variableBindings = new HashMap<SimpleName, IVariableBinding>();
        astNode.accept(new ASTVisitor(){

            public boolean visit(VariableDeclarationStatement node) {
                for (Object o : node.fragments()) {
                    VariableDeclarationFragment vdf;
                    SimpleName name;
                    IBinding binding;
                    if (!(o instanceof VariableDeclarationFragment) || !((binding = (name = (vdf = (VariableDeclarationFragment)o).getName()).resolveBinding()) instanceof IVariableBinding)) continue;
                    variableBindings.put(name, (IVariableBinding)binding);
                    break;
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public boolean visit(PatternInstanceofExpression node) {
                SimpleName name;
                IBinding binding;
                SingleVariableDeclaration svd = node.getRightOperand();
                AST ast = node.getAST();
                if (ast.apiLevel() == 20 && ast.isPreviewEnabled() || ast.apiLevel() > 20) {
                    Pattern p = node.getPattern();
                    Pattern pattern = p;
                    if (pattern instanceof TypePattern) {
                        void typePattern;
                        TypePattern typePattern2 = (TypePattern)pattern;
                        TypePattern cfr_ignored_0 = (TypePattern)pattern;
                        svd = typePattern.getPatternVariable();
                    } else {
                        return false;
                    }
                }
                if ((binding = (name = svd.getName()).resolveBinding()) instanceof IVariableBinding) {
                    variableBindings.put(name, (IVariableBinding)binding);
                }
                return false;
            }
        });
        return variableBindings;
    }
}

