/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javadoc;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.JavaDocRegion;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TagProperty;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.javadoc.JavaDoc2MarkdownConverter;
import org.eclipse.jdt.ls.core.internal.javadoc.JavaElementLinks;

public class JavaDocSnippetStringEvaluator {
    public static final String SNIPPET = "SNIPPET";
    private final IJavaElement fElement;

    public JavaDocSnippetStringEvaluator(IJavaElement element) {
        this.fElement = element;
    }

    /*
     * WARNING - void declaration
     */
    public void AddTagElementString(TagElement snippetTag, StringBuffer buffer) {
        if (snippetTag != null) {
            List fragments = snippetTag.fragments();
            for (Object fragment : fragments) {
                Object str = "";
                Object e = fragment;
                if (e instanceof TextElement) {
                    void textElement;
                    TextElement cfr_ignored_0 = (TextElement)e;
                    TextElement cfr_ignored_1 = (TextElement)e;
                    Object tagElements = this.getTagElementsForTextElement(snippetTag, (TextElement)textElement);
                    str = this.getModifiedString((TextElement)textElement, (List<TagElement>)tagElements);
                } else {
                    Object e2 = fragment;
                    if (e2 instanceof JavaDocRegion) {
                        void region;
                        JavaDocRegion cfr_ignored_2 = (JavaDocRegion)e2;
                        JavaDocRegion cfr_ignored_3 = (JavaDocRegion)e2;
                        if (region.isDummyRegion()) {
                            Object tagElements = this.getTagElementsForDummyJavaDocRegion(snippetTag, (JavaDocRegion)region);
                            str = this.getModifiedString((JavaDocRegion)region, (List<TagElement>)tagElements);
                        }
                    } else {
                        Object e3 = fragment;
                        if (e3 instanceof TagElement) {
                            void tagElement;
                            TagElement cfr_ignored_4 = (TagElement)e3;
                            TagElement cfr_ignored_5 = (TagElement)e3;
                            List<TagElement> tagElements = this.getTagElementsForTagElement(snippetTag, (TagElement)tagElement);
                            str = this.getModifiedString((TagElement)tagElement, tagElements);
                            if ("@link".equals(tagElement.getTagName())) {
                                int leadingSpaces = 0;
                                while (((String)str).length() > leadingSpaces + 1 && ((String)str).charAt(leadingSpaces) == ' ') {
                                    ++leadingSpaces;
                                }
                                try {
                                    str = new JavaDoc2MarkdownConverter((String)str).getAsString();
                                    int i = 0;
                                    while (i < leadingSpaces) {
                                        str = " " + (String)str;
                                        ++i;
                                    }
                                    str = (String)str + "  \n";
                                }
                                catch (IOException e4) {
                                    JavaLanguageServerPlugin.logException(e4.getMessage(), e4);
                                }
                            }
                        }
                    }
                }
                buffer.append(SNIPPET);
                buffer.append((String)str);
            }
        }
    }

    private String getModifiedString(TextElement textElement, List<TagElement> tags) {
        return this.getModifiedString(textElement.getText(), tags);
    }

    private String getModifiedString(TagElement tagElement, List<TagElement> tags) {
        return this.getModifiedString(((TextElement)tagElement.fragments().get(0)).getText(), tags);
    }

    private String getModifiedString(JavaDocRegion region, List<TagElement> tags) {
        return this.getModifiedString(((TextElement)region.fragments().get(0)).getText(), tags);
    }

    private String getModifiedString(String str, List<TagElement> tags) {
        ArrayList<ActionElement> actionElements = new ArrayList<ActionElement>();
        String modifiedStr = str;
        for (TagElement tag : tags) {
            String name = tag.getTagName();
            if ("@highlight".equals(name)) {
                this.handleSnippetHighlight(modifiedStr, tag, actionElements);
                continue;
            }
            if ("@replace".equals(name)) {
                modifiedStr = this.handleSnippetReplace(modifiedStr, tag, actionElements);
                continue;
            }
            if (!"@link".equals(name)) continue;
            this.handleSnippetLink(modifiedStr, tag, actionElements);
        }
        return this.getString(modifiedStr, actionElements);
    }

    private String getString(String str, List<ActionElement> actionElements) {
        Object modifiedStr = str;
        ArrayList<StringItem> items = new ArrayList<StringItem>();
        for (ActionElement actElem : actionElements) {
            StringItem startItem = new StringItem(actElem.start, actElem.startTag);
            StringItem endItem = new StringItem(actElem.end, actElem.endTag);
            ListIterator<StringItem> iterator = items.listIterator();
            boolean endIndexAdded = false;
            boolean startIndexAdded = false;
            while (iterator.hasNext()) {
                StringItem elem = (StringItem)iterator.next();
                if (!endIndexAdded && elem.index < endItem.index) {
                    iterator.previous();
                    iterator.add(endItem);
                    endIndexAdded = true;
                    iterator.next();
                }
                if (!startIndexAdded && elem.index < startItem.index) {
                    iterator.previous();
                    iterator.add(startItem);
                    startIndexAdded = true;
                    iterator.next();
                }
                if (startIndexAdded && endIndexAdded) break;
            }
            if (!endIndexAdded) {
                items.add(endItem);
            }
            if (startIndexAdded) continue;
            items.add(startItem);
        }
        for (StringItem item : items) {
            modifiedStr = ((String)modifiedStr).substring(0, item.index) + item.tag + ((String)modifiedStr).substring(item.index);
        }
        return modifiedStr;
    }

    private void modifyPrevActionItemsReplacement(int replacementIntervalStart, int relacementIntervalEnd, int replacementStrNewLength, List<ActionElement> actionElements) {
        ListIterator<ActionElement> iterator = actionElements.listIterator();
        int oldLength = relacementIntervalEnd - replacementIntervalStart;
        int diff = replacementStrNewLength - oldLength;
        while (iterator.hasNext()) {
            ActionElement elem = iterator.next();
            ReplacementStringIntervalStatus intervalStatus = elem.getIntervalStatus(replacementIntervalStart, relacementIntervalEnd);
            switch (intervalStatus) {
                case AFTER: {
                    break;
                }
                case BEFORE: {
                    if (diff == 0) break;
                    elem.start += diff;
                    elem.end += diff;
                    break;
                }
                case ENCOMPASS: {
                    iterator.remove();
                    break;
                }
                case POST_OVERLAP: {
                    elem.end = replacementIntervalStart;
                    break;
                }
                case PREV_OVERLAP: {
                    elem.end += diff;
                    elem.start = relacementIntervalEnd + diff;
                    break;
                }
                case WITHIN: {
                    int newEnd = elem.end + diff;
                    elem.end = replacementIntervalStart;
                    int newStart = relacementIntervalEnd + diff;
                    ActionElement newElem = new ActionElement(newStart, newEnd, elem.startTag, elem.endTag);
                    iterator.add(newElem);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<TagElement> getTagElementsForTextElement(TagElement snippetTag, TextElement textElement) {
        ArrayList<TagElement> tagElements = new ArrayList<TagElement>();
        List regions = snippetTag.tagRegionsStartingAtTextElement((ASTNode)textElement);
        List masterList = snippetTag.tagRegionsContainingTextElement((ASTNode)textElement);
        masterList.removeAll(regions);
        for (JavaDocRegion region : masterList) {
            for (Object tagObj : region.tags()) {
                tagElements.add((TagElement)tagObj);
            }
        }
        for (JavaDocRegion region : regions) {
            for (Object tagObj : region.tags()) {
                void intProp;
                void tagElem;
                Object prop;
                Object e = tagObj;
                if (!(e instanceof TagElement)) continue;
                TagElement cfr_ignored_0 = (TagElement)e;
                TagElement cfr_ignored_1 = (TagElement)e;
                Object object = prop = tagElem.getProperty("SnippetInlineTagCount");
                if (!(object instanceof Integer)) continue;
                Integer cfr_ignored_2 = (Integer)object;
                Integer cfr_ignored_3 = (Integer)object;
                int val = intProp.intValue();
                ListIterator listIterator = tagElements.listIterator();
                TagElement addBefore = null;
                while (listIterator.hasNext()) {
                    void intProp2;
                    TagElement tElem = (TagElement)listIterator.next();
                    Object prop2 = tElem.getProperty("SnippetInlineTagCount");
                    Object object2 = prop2;
                    if (!(object2 instanceof Integer)) continue;
                    Integer cfr_ignored_4 = (Integer)object2;
                    Integer cfr_ignored_5 = (Integer)object2;
                    int val2 = intProp2.intValue();
                    if (val2 <= val) continue;
                    addBefore = tElem;
                    break;
                }
                if (addBefore == null) {
                    tagElements.add((TagElement)tagElem);
                    continue;
                }
                tagElements.add(tagElements.indexOf(addBefore), (TagElement)tagElem);
            }
        }
        return tagElements;
    }

    /*
     * WARNING - void declaration
     */
    private List<TagElement> getTagElementsForDummyJavaDocRegion(TagElement snippetTag, JavaDocRegion javaDocRegion) {
        ArrayList<TagElement> tagElements = new ArrayList<TagElement>();
        TextElement textElement = (TextElement)javaDocRegion.fragments().get(0);
        List regions = snippetTag.tagRegionsStartingAtTextElement((ASTNode)textElement);
        List masterList = snippetTag.tagRegionsContainingTextElement((ASTNode)textElement);
        masterList.removeAll(regions);
        for (JavaDocRegion region : masterList) {
            for (Object tagObj : region.tags()) {
                tagElements.add((TagElement)tagObj);
            }
        }
        regions.add(javaDocRegion);
        for (JavaDocRegion region : regions) {
            for (Object tagObj : region.tags()) {
                void intProp;
                void tagElem;
                Object prop;
                Object e = tagObj;
                if (!(e instanceof TagElement)) continue;
                TagElement cfr_ignored_0 = (TagElement)e;
                TagElement cfr_ignored_1 = (TagElement)e;
                Object object = prop = tagElem.getProperty("SnippetInlineTagCount");
                if (!(object instanceof Integer)) continue;
                Integer cfr_ignored_2 = (Integer)object;
                Integer cfr_ignored_3 = (Integer)object;
                int val = intProp.intValue();
                ListIterator listIterator = tagElements.listIterator();
                TagElement addBefore = null;
                while (listIterator.hasNext()) {
                    void intProp2;
                    TagElement tElem = (TagElement)listIterator.next();
                    Object prop2 = tElem.getProperty("SnippetInlineTagCount");
                    Object object2 = prop2;
                    if (!(object2 instanceof Integer)) continue;
                    Integer cfr_ignored_4 = (Integer)object2;
                    Integer cfr_ignored_5 = (Integer)object2;
                    int val2 = intProp2.intValue();
                    if (val2 <= val) continue;
                    addBefore = tElem;
                    break;
                }
                if (addBefore == null) {
                    tagElements.add((TagElement)tagElem);
                    continue;
                }
                tagElements.add(tagElements.indexOf(addBefore), (TagElement)tagElem);
            }
        }
        return tagElements;
    }

    /*
     * WARNING - void declaration
     */
    private List<TagElement> getTagElementsForTagElement(TagElement snippetTag, TagElement tag) {
        ArrayList<TagElement> tagElements = new ArrayList<TagElement>();
        TextElement textElement = (TextElement)tag.fragments().get(0);
        List regions = snippetTag.tagRegionsStartingAtTextElement((ASTNode)textElement);
        List masterList = snippetTag.tagRegionsContainingTextElement((ASTNode)textElement);
        masterList.removeAll(regions);
        for (JavaDocRegion region : masterList) {
            for (Object tagObj : region.tags()) {
                tagElements.add((TagElement)tagObj);
            }
        }
        for (JavaDocRegion region : regions) {
            for (Object tagObj : region.tags()) {
                void intProp;
                void tagElem;
                Object prop;
                Object e = tagObj;
                if (!(e instanceof TagElement)) continue;
                TagElement cfr_ignored_0 = (TagElement)e;
                TagElement cfr_ignored_1 = (TagElement)e;
                Object object = prop = tagElem.getProperty("SnippetInlineTagCount");
                if (!(object instanceof Integer)) continue;
                Integer cfr_ignored_2 = (Integer)object;
                Integer cfr_ignored_3 = (Integer)object;
                int val = intProp.intValue();
                ListIterator listIterator = tagElements.listIterator();
                TagElement addBefore = null;
                while (listIterator.hasNext()) {
                    void intProp2;
                    TagElement tElem = (TagElement)listIterator.next();
                    Object prop2 = tElem.getProperty("SnippetInlineTagCount");
                    Object object2 = prop2;
                    if (!(object2 instanceof Integer)) continue;
                    Integer cfr_ignored_4 = (Integer)object2;
                    Integer cfr_ignored_5 = (Integer)object2;
                    int val2 = intProp2.intValue();
                    if (val2 <= val) continue;
                    addBefore = tElem;
                    break;
                }
                if (addBefore == null) {
                    tagElements.add((TagElement)tagElem);
                    continue;
                }
                tagElements.add(tagElements.indexOf(addBefore), (TagElement)tagElem);
            }
        }
        Object prop3 = tag.getProperty("SnippetInlineTagCount");
        Object object = prop3;
        if (object instanceof Integer) {
            void intProp3;
            Integer n = (Integer)object;
            Integer cfr_ignored_6 = (Integer)object;
            int val = intProp3.intValue();
            ListIterator listIterator = tagElements.listIterator();
            TagElement addBefore = null;
            while (listIterator.hasNext()) {
                void intProp2;
                TagElement tElem = (TagElement)listIterator.next();
                Object prop2 = tElem.getProperty("SnippetInlineTagCount");
                Object object3 = prop2;
                if (!(object3 instanceof Integer)) continue;
                Integer cfr_ignored_7 = (Integer)object3;
                Integer cfr_ignored_8 = (Integer)object3;
                int val2 = intProp2.intValue();
                if (val2 <= val) continue;
                addBefore = tElem;
                break;
            }
            if (addBefore == null) {
                tagElements.add(tag);
            } else {
                tagElements.add(tagElements.indexOf(addBefore), tag);
            }
        }
        return tagElements;
    }

    private void handleSnippetHighlight(String text, TagElement tagElement, List<ActionElement> actionElements) {
        try {
            String defHighlight;
            List tagProperties = tagElement.tagProperties();
            String startDefHighlight = defHighlight = this.getHighlightHtmlTag(tagProperties);
            String endDefHighlight = defHighlight;
            String regExValue = this.getPropertyValue("regex", tagProperties);
            String subStringValue = this.getPropertyValue("substring", tagProperties);
            Pattern regexPattern = null;
            if (regExValue != null) {
                regexPattern = Pattern.compile(regExValue);
            }
            if (regexPattern != null) {
                Matcher matcher = regexPattern.matcher(text);
                while (matcher.find()) {
                    actionElements.add(new ActionElement(matcher.start(), matcher.end(), startDefHighlight, endDefHighlight));
                }
            } else if (subStringValue != null) {
                int startIndex = 0;
                while ((startIndex = text.indexOf(subStringValue, startIndex)) != -1) {
                    actionElements.add(new ActionElement(startIndex, startIndex + subStringValue.length(), startDefHighlight, endDefHighlight));
                    startIndex += subStringValue.length();
                }
            } else {
                actionElements.add(new ActionElement(0, text.length(), startDefHighlight, endDefHighlight));
            }
            return;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return;
        }
    }

    private String handleSnippetReplace(String text, TagElement tagElement, List<ActionElement> actionElements) {
        try {
            List tagProperties = tagElement.tagProperties();
            String regExValue = this.getPropertyValue("regex", tagProperties);
            String subStringValue = this.getPropertyValue("substring", tagProperties);
            String substitution = this.getPropertyValue("replacement", tagProperties);
            Pattern regexPattern = null;
            if (regExValue != null) {
                regexPattern = Pattern.compile(regExValue);
            }
            Object modifiedText = text;
            if (regexPattern != null) {
                Matcher matcher = regexPattern.matcher((CharSequence)modifiedText);
                StringBuilder strBuild = new StringBuilder();
                int finalMatchIndex = 0;
                while (matcher.find()) {
                    finalMatchIndex = matcher.end();
                    this.modifyPrevActionItemsReplacement(matcher.start(), matcher.end(), substitution.length(), actionElements);
                    matcher.appendReplacement(strBuild, substitution);
                }
                modifiedText = strBuild.toString() + ((String)modifiedText).substring(finalMatchIndex);
            } else if (subStringValue != null) {
                int startIndex = 0;
                while ((startIndex = ((String)modifiedText).indexOf(subStringValue, startIndex)) != -1) {
                    this.modifyPrevActionItemsReplacement(startIndex, startIndex + subStringValue.length(), substitution.length(), actionElements);
                    modifiedText = ((String)modifiedText).substring(0, startIndex) + substitution + ((String)modifiedText).substring(startIndex + subStringValue.length());
                    startIndex += substitution.length();
                }
            } else {
                actionElements.clear();
                modifiedText = substitution;
            }
            return modifiedText;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return text;
        }
    }

    private void handleSnippetLink(String text, TagElement tagElement, List<ActionElement> actionElements) {
        try {
            List tagProperties = tagElement.tagProperties();
            String regExValue = this.getPropertyValue("regex", tagProperties);
            String subStringValue = this.getPropertyValue("substring", tagProperties);
            Object additionalStartTag = this.getLinkHtmlTag(tagProperties);
            Object additionalEndTag = "";
            if (((String)additionalStartTag).length() > 0) {
                additionalEndTag = "</" + (String)additionalStartTag + ">";
                additionalStartTag = "<" + (String)additionalStartTag + ">";
            }
            ASTNode target = this.getPropertyNodeValue("target", tagProperties);
            String linkRefTxt = this.getLinkRef(target);
            String startDefLink = linkRefTxt + (String)additionalStartTag;
            String endDefLink = (String)additionalEndTag + "</a>";
            Pattern regexPattern = null;
            if (regExValue != null) {
                regexPattern = Pattern.compile(regExValue);
            }
            String modifiedText = text;
            if (regexPattern != null) {
                Matcher matcher = regexPattern.matcher(modifiedText);
                while (matcher.find()) {
                    actionElements.add(new ActionElement(matcher.start(), matcher.end(), startDefLink, endDefLink));
                }
            } else if (subStringValue != null) {
                int startIndex = 0;
                while ((startIndex = modifiedText.indexOf(subStringValue, startIndex)) != -1) {
                    actionElements.add(new ActionElement(startIndex, startIndex + subStringValue.length(), startDefLink, endDefLink));
                    startIndex += subStringValue.length();
                }
            } else {
                String subText = modifiedText.trim();
                if (subText.length() < text.length()) {
                    int startIndex = text.indexOf(subText);
                    actionElements.add(new ActionElement(startIndex, startIndex + subText.length(), startDefLink, endDefLink));
                }
            }
            return;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getLinkRef(ASTNode node) {
        Object str = "";
        String refTypeName = null;
        String refMemberName = null;
        String[] refMethodParamTypes = null;
        String[] refMethodParamNames = null;
        int startPosition = -1;
        ASTNode aSTNode = node;
        if (aSTNode instanceof Name) {
            void name;
            Name name2 = (Name)aSTNode;
            Name cfr_ignored_0 = (Name)aSTNode;
            refTypeName = name.getFullyQualifiedName();
            startPosition = name.getStartPosition();
        } else {
            ASTNode aSTNode2 = node;
            if (aSTNode2 instanceof MemberRef) {
                void memberRef;
                MemberRef memberRef2 = (MemberRef)aSTNode2;
                MemberRef cfr_ignored_1 = (MemberRef)aSTNode2;
                Name qualifier = memberRef.getQualifier();
                refTypeName = qualifier == null ? "" : qualifier.getFullyQualifiedName();
                refMemberName = memberRef.getName().getIdentifier();
                startPosition = memberRef.getStartPosition();
            } else {
                ASTNode aSTNode3 = node;
                if (aSTNode3 instanceof MethodRef) {
                    void methodRef;
                    MethodRef qualifier = (MethodRef)aSTNode3;
                    MethodRef cfr_ignored_2 = (MethodRef)aSTNode3;
                    Name qualifier2 = methodRef.getQualifier();
                    refTypeName = qualifier2 == null ? "" : qualifier2.getFullyQualifiedName();
                    refMemberName = methodRef.getName().getIdentifier();
                    List params = methodRef.parameters();
                    int ps = params.size();
                    refMethodParamTypes = new String[ps];
                    refMethodParamNames = new String[ps];
                    int i = 0;
                    while (i < ps) {
                        MethodRefParameter param = (MethodRefParameter)params.get(i);
                        refMethodParamTypes[i] = ASTNodes.asString((ASTNode)param.getType());
                        SimpleName paramName = param.getName();
                        if (paramName != null) {
                            refMethodParamNames[i] = paramName.getIdentifier();
                        }
                        ++i;
                    }
                    startPosition = methodRef.getStartPosition();
                }
            }
        }
        if (refTypeName != null) {
            str = (String)str + "<a href='";
            try {
                String scheme = "file";
                String uri = JavaElementLinks.createURI("file", this.fElement, refTypeName, refMemberName, refMethodParamTypes, startPosition);
                str = (String)str + uri;
            }
            catch (URISyntaxException e) {
                JavaLanguageServerPlugin.logException(e);
            }
            str = (String)str + "'>";
        }
        return str;
    }

    /*
     * WARNING - void declaration
     */
    private String getLinkHtmlTag(List<? extends ASTNode> tagProperties) {
        String defaultTag;
        block8: {
            defaultTag = "";
            if (tagProperties == null) break block8;
            for (ASTNode aSTNode : tagProperties) {
                String tagValue;
                void tagProp;
                ASTNode aSTNode2 = aSTNode;
                if (!(aSTNode2 instanceof TagProperty)) continue;
                TagProperty cfr_ignored_0 = (TagProperty)aSTNode2;
                TagProperty cfr_ignored_1 = (TagProperty)aSTNode2;
                if (!"type".equals(tagProp.getName())) continue;
                switch (tagValue = tagProp.getStringValue()) {
                    case "linkplain": {
                        defaultTag = "";
                        break;
                    }
                }
                break;
            }
        }
        return defaultTag;
    }

    /*
     * WARNING - void declaration
     */
    private String getPropertyValue(String property, List<? extends ASTNode> tagProperties) {
        String defaultTag = null;
        if (tagProperties != null && property != null) {
            for (ASTNode aSTNode : tagProperties) {
                void tagProp;
                ASTNode aSTNode2 = aSTNode;
                if (!(aSTNode2 instanceof TagProperty)) continue;
                TagProperty cfr_ignored_0 = (TagProperty)aSTNode2;
                TagProperty cfr_ignored_1 = (TagProperty)aSTNode2;
                if (!property.equals(tagProp.getName())) continue;
                defaultTag = tagProp.getStringValue();
                break;
            }
        }
        return defaultTag;
    }

    /*
     * WARNING - void declaration
     */
    private ASTNode getPropertyNodeValue(String property, List<? extends ASTNode> tagProperties) {
        ASTNode defaultTag = null;
        if (tagProperties != null && property != null) {
            for (ASTNode aSTNode : tagProperties) {
                void tagProp;
                ASTNode aSTNode2 = aSTNode;
                if (!(aSTNode2 instanceof TagProperty)) continue;
                TagProperty cfr_ignored_0 = (TagProperty)aSTNode2;
                TagProperty cfr_ignored_1 = (TagProperty)aSTNode2;
                if (!property.equals(tagProp.getName())) continue;
                defaultTag = tagProp.getNodeValue();
                break;
            }
        }
        return defaultTag;
    }

    /*
     * WARNING - void declaration
     */
    private String getHighlightHtmlTag(List<? extends ASTNode> tagProperties) {
        String defaultTag;
        block14: {
            defaultTag = "**";
            if (tagProperties == null) break block14;
            for (ASTNode aSTNode : tagProperties) {
                String tagValue;
                void tagProp;
                ASTNode aSTNode2 = aSTNode;
                if (!(aSTNode2 instanceof TagProperty)) continue;
                TagProperty cfr_ignored_0 = (TagProperty)aSTNode2;
                TagProperty cfr_ignored_1 = (TagProperty)aSTNode2;
                if (!"type".equals(tagProp.getName())) continue;
                switch (tagValue = tagProp.getStringValue()) {
                    case "bold": {
                        defaultTag = "**";
                        break;
                    }
                    case "italic": {
                        defaultTag = "*";
                        break;
                    }
                    case "highlighted": {
                        defaultTag = "***";
                        break;
                    }
                    default: {
                        defaultTag = "";
                        break;
                    }
                }
                break;
            }
        }
        return defaultTag;
    }

    public class ActionElement {
        public int start;
        public int end;
        public String startTag;
        public String endTag;

        public ActionElement(int start, int end, String startTag, String endTag) {
            this.start = start;
            this.end = end;
            this.startTag = startTag;
            this.endTag = endTag;
        }

        public ReplacementStringIntervalStatus getIntervalStatus(int replacementIntervalStart, int replacementIntervalEnd) {
            ReplacementStringIntervalStatus intervalStatus = ReplacementStringIntervalStatus.DEFAULT;
            int startDiff = replacementIntervalStart - this.start;
            int endDiff = replacementIntervalEnd - this.end;
            if (this.end <= replacementIntervalStart) {
                intervalStatus = ReplacementStringIntervalStatus.AFTER;
            } else if (this.start >= replacementIntervalEnd) {
                intervalStatus = ReplacementStringIntervalStatus.BEFORE;
            } else if (startDiff <= 0 && endDiff >= 0) {
                intervalStatus = ReplacementStringIntervalStatus.ENCOMPASS;
            } else if (startDiff > 0 && endDiff < 0) {
                intervalStatus = ReplacementStringIntervalStatus.WITHIN;
            } else if (startDiff > 0) {
                intervalStatus = ReplacementStringIntervalStatus.POST_OVERLAP;
            } else if (endDiff < 0) {
                intervalStatus = ReplacementStringIntervalStatus.PREV_OVERLAP;
            }
            return intervalStatus;
        }
    }

    public static enum ReplacementStringIntervalStatus {
        BEFORE,
        AFTER,
        WITHIN,
        ENCOMPASS,
        PREV_OVERLAP,
        POST_OVERLAP,
        DEFAULT;

    }

    public class StringItem {
        public int index;
        public String tag;

        public StringItem(int index, String tag) {
            this.index = index;
            this.tag = tag;
        }
    }
}

