"use strict";
// *****************************************************************************
// Copyright (C) 2022 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", { value: true });
exports.preload = void 0;
const nls_1 = require("../common/nls");
const endpoint_1 = require("./endpoint");
const os_1 = require("../common/os");
const frontend_application_config_provider_1 = require("./frontend-application-config-provider");
function fetchFrom(path) {
    const endpoint = new endpoint_1.Endpoint({ path }).getRestUrl().toString();
    return fetch(endpoint);
}
async function loadTranslations() {
    const defaultLocale = frontend_application_config_provider_1.FrontendApplicationConfigProvider.get().defaultLocale;
    if (defaultLocale && !nls_1.nls.locale) {
        Object.assign(nls_1.nls, {
            locale: defaultLocale
        });
    }
    if (nls_1.nls.locale) {
        const response = await fetchFrom(`/i18n/${nls_1.nls.locale}`);
        nls_1.nls.localization = await response.json();
    }
}
async function loadBackendOS() {
    const response = await fetchFrom('/os');
    const osType = await response.text();
    const isWindows = osType === 'Windows';
    const isOSX = osType === 'OSX';
    os_1.OS.backend.isOSX = isOSX;
    os_1.OS.backend.isWindows = isWindows;
    os_1.OS.backend.type = () => osType;
}
async function preload() {
    await Promise.allSettled([
        loadTranslations(),
        loadBackendOS()
    ]);
}
exports.preload = preload;
//# sourceMappingURL=preloader.js.map