/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.highlighting;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.ui.javaeditor.HighlightedPositionCore;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.highlighting.SemanticHighlightingDiffCalculator;
import org.eclipse.jdt.ls.core.internal.highlighting.SemanticHighlightingLS;
import org.eclipse.jdt.ls.core.internal.highlighting.SemanticHighlightingReconciler;
import org.eclipse.jdt.ls.core.internal.highlighting.SemanticHighlightings;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.lsp4j.SemanticHighlightingInformation;
import org.eclipse.lsp4j.SemanticHighlightingParams;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.util.SemanticHighlightingTokens;

public class SemanticHighlightingService {
    private static ImmutableBiMap.Builder<Integer, List<String>> BUILDER = ImmutableBiMap.builder();
    private static BiMap<Integer, List<String>> LOOKUP_TABLE;
    private final Supplier<Boolean> enabled;
    private final JavaClientConnection connection;
    private final Map<String, List<HighlightedPositionCore>> cache;
    private CoreASTProvider astProvider;
    private SemanticHighlightingDiffCalculator diffCalculator;

    static {
        AtomicInteger i = new AtomicInteger();
        Stream.of(SemanticHighlightings.getSemanticHighlightings()).map(SemanticHighlightingLS::getScopes).forEach(scopes -> {
            ImmutableBiMap.Builder builder = BUILDER.put((Object)i.getAndIncrement(), scopes);
        });
        LOOKUP_TABLE = BUILDER.build();
    }

    public static List<List<String>> getAllScopes() {
        ArrayList result = Lists.newArrayList();
        int i = 0;
        while (i < LOOKUP_TABLE.keySet().size()) {
            List scopes = (List)LOOKUP_TABLE.get((Object)i);
            Assert.isNotNull((Object)scopes, (String)("No scopes are available for index: " + i));
            result.add(scopes);
            ++i;
        }
        return ImmutableList.copyOf((Collection)result);
    }

    public static List<String> getScopes(int index) {
        List scopes = (List)LOOKUP_TABLE.get((Object)index);
        Assert.isNotNull((Object)scopes, (String)("No scopes were registered for index: " + index));
        return scopes;
    }

    public static int getIndex(List<String> scopes) {
        Integer index = (Integer)LOOKUP_TABLE.inverse().get(scopes);
        Assert.isNotNull((Object)index, (String)("Cannot get index for scopes: " + Iterables.toString(scopes)));
        return index;
    }

    public SemanticHighlightingService(JavaClientConnection connection, CoreASTProvider astProvider, PreferenceManager preferenceManager) {
        this(connection, astProvider, (Supplier<Boolean>)Suppliers.memoize(() -> preferenceManager.getClientPreferences().isSemanticHighlightingSupported()));
    }

    public SemanticHighlightingService(JavaClientConnection connection, CoreASTProvider astProvider, Supplier<Boolean> enabled) {
        this.connection = connection;
        this.astProvider = astProvider;
        this.enabled = enabled;
        this.cache = Maps.newHashMap();
        this.diffCalculator = new SemanticHighlightingDiffCalculator();
    }

    public boolean isEnabled() {
        return (Boolean)this.enabled.get();
    }

    public void uninstall(String uri) {
        if (((Boolean)this.enabled.get()).booleanValue()) {
            this.cache.remove(uri);
        }
    }

    public List<Position> install(ICompilationUnit unit) throws JavaModelException, BadPositionCategoryException {
        if (((Boolean)this.enabled.get()).booleanValue()) {
            List<HighlightedPositionCore> positions = this.calculateHighlightedPositions(unit, false);
            String uri = JDTUtils.getFileURI(unit.getResource());
            this.cache.put(uri, positions);
            if (!positions.isEmpty()) {
                IDocument document = JsonRpcHelpers.toDocument(unit.getBuffer());
                List<SemanticHighlightingInformation> infos = this.toInfos(document, positions);
                VersionedTextDocumentIdentifier textDocument = new VersionedTextDocumentIdentifier(uri, Integer.valueOf(1));
                this.notifyClient(textDocument, infos);
            }
            return ImmutableList.copyOf(positions);
        }
        return Collections.emptyList();
    }

    public List<HighlightedPositionCore> calculateHighlightedPositions(ICompilationUnit unit, boolean cache) throws JavaModelException, BadPositionCategoryException {
        if (((Boolean)this.enabled.get()).booleanValue()) {
            IDocument document = JsonRpcHelpers.toDocument(unit.getBuffer());
            ASTNode ast = this.getASTNode(unit);
            List<HighlightedPositionCore> positions = this.calculateHighlightedPositions(document, ast);
            if (cache) {
                String uri = JDTUtils.getFileURI(unit.getResource());
                this.cache.put(uri, positions);
            }
            return ImmutableList.copyOf(positions);
        }
        return Collections.emptyList();
    }

    public List<HighlightedPositionCore> getHighlightedPositions(String uri) {
        return ImmutableList.copyOf((Collection)this.cache.getOrDefault(uri, Collections.emptyList()));
    }

    public void update(VersionedTextDocumentIdentifier textDocument, List<HighlightedPositionDiffContext> diffContexts) throws BadLocationException, BadPositionCategoryException, JavaModelException {
        if (((Boolean)this.enabled.get()).booleanValue() && !diffContexts.isEmpty()) {
            ArrayList deltaInfos = Lists.newArrayList();
            for (HighlightedPositionDiffContext context : diffContexts) {
                deltaInfos.addAll(this.diffCalculator.getDiffInfos(context));
            }
            if (!deltaInfos.isEmpty()) {
                this.notifyClient(textDocument, deltaInfos);
            }
        }
    }

    protected List<HighlightedPositionCore> calculateHighlightedPositions(IDocument document, ASTNode ast) throws BadPositionCategoryException {
        return new SemanticHighlightingReconciler().reconciled(document, ast, false, (IProgressMonitor)new NullProgressMonitor());
    }

    protected ASTNode getASTNode(ICompilationUnit unit) {
        this.astProvider.disposeAST();
        return this.astProvider.getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
    }

    protected List<SemanticHighlightingInformation> toInfos(IDocument document, List<HighlightedPositionCore> positions) {
        HashMultimap infos = HashMultimap.create();
        for (HighlightedPositionCore position : positions) {
            int[] lineAndColumn = JsonRpcHelpers.toLine(document, position.offset);
            if (lineAndColumn == null) {
                JavaLanguageServerPlugin.logError("Cannot locate line and column information for the semantic highlighting position: " + position + ". Skipping it.");
                continue;
            }
            int line = lineAndColumn[0];
            int character = lineAndColumn[1];
            int length = position.length;
            int scope = (Integer)LOOKUP_TABLE.inverse().get(position.getHighlighting());
            infos.put((Object)line, (Object)new SemanticHighlightingTokens.Token(character, length, scope));
        }
        return infos.asMap().entrySet().stream().map(entry -> new SemanticHighlightingInformation(((Integer)entry.getKey()).intValue(), SemanticHighlightingTokens.encode((Iterable)((Iterable)entry.getValue())))).collect(Collectors.toList());
    }

    protected void notifyClient(VersionedTextDocumentIdentifier textDocument, List<SemanticHighlightingInformation> infos) {
        if (infos.isEmpty()) {
            return;
        }
        this.connection.semanticHighlighting(new SemanticHighlightingParams(textDocument, infos));
    }

    public static class HighlightedPositionDiffContext {
        public final IDocument oldState;
        public final IDocument newState;
        public final DocumentEvent event;
        public final List<HighlightedPositionCore> oldPositions;
        public final List<HighlightedPositionCore> newPositions;

        public HighlightedPositionDiffContext(IDocument oldState, DocumentEvent event, Iterable<? extends HighlightedPositionCore> oldPositions, Iterable<? extends HighlightedPositionCore> newPositions) {
            this.oldState = oldState;
            this.newState = event.fDocument;
            this.event = event;
            this.oldPositions = ImmutableList.copyOf(oldPositions);
            this.newPositions = ImmutableList.copyOf(newPositions);
        }
    }
}

